;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald PROOF-GRAPHS)


;;;(lset *inference-nodes-to-discard* '())
;;;
;;;(define (DEDUCTION-GRAPH-DELETE-INFERENCE-NODES dg infns)
;;;  (set (deduction-graph-inference-nodes dg)
;;;       (set-difference (deduction-graph-inference-nodes dg) infns))
;;;  (walk (lambda (infn)
;;;	  (walk
;;;	   (lambda (sqn)
;;;	     (if (memq? sqn (inference-node-hypotheses infn))
;;;		 (set (sequent-node-out-arrows sqn)
;;;		      (delete-set-element infn (sequent-node-out-arrows sqn)))))
;;;	   (deduction-graph-sequent-nodes dg)))
;;;	infns)
;;;  (walk
;;;   (lambda (sqn)
;;;     (set (sequent-node-in-arrows sqn)
;;;	  (set-difference (sequent-node-in-arrows sqn) infns)))
;;;   (deduction-graph-sequent-nodes dg))
;;;  dg)
;;;
;;;
;;;(define (DEDUCTION-GRAPH-DELETE-SEQUENT-NODES dg sqns)
;;;  (walk (lambda (inf)
;;;	(if (set-intersection sqns (inference-node-hypotheses inf))
;;;	    (imps-error "Attempt to delete a premise sequent.")))
;;;	(deduction-graph-inference-nodes dg))
;;;  (walk (lambda (sqn)
;;;	  (deduction-graph-delete-inference-nodes dg (sequent-node-in-arrows sqn)))
;;;	(deduction-graph-sequent-nodes dg))
;;;  (set (deduction-graph-sequent-nodes dg)
;;;       (set-difference (deduction-graph-sequent-nodes dg) sqns)))
;;;
;;;(define (COPY-DEDUCTION-GRAPH dg)
;;;  (let ((theory (deduction-graph-theory dg))
;;;	(goal (sequent-node-sequent (deduction-graph-goal dg)))
;;;	(new-dg (make-deduction-graph)))
;;;    (set (deduction-graph-sequent-nodes new-dg) '())
;;;    (set (deduction-graph-inference-nodes new-dg) '())
;;;    (set (deduction-graph-goal new-dg) (post goal new-dg))
;;;    (set (deduction-graph-theory new-dg) theory)
;;;    (walk (lambda (x)
;;;	    (let ((sqn (post (sequent-node-sequent x) new-dg)))
;;;	      (set (sequent-node-grounded? sqn) (sequent-node-grounded? x))
;;;	      (set (sequent-node-level sqn)(sequent-node-level x))))
;;;	  (deduction-graph-sequent-nodes dg))
;;;    (walk
;;;     (lambda (x)
;;;       (let ((infn (deduction-graph-add-inference-node
;;;		    new-dg
;;;		    (inference->inference-node (inference-node-inference x) new-dg))))
;;;	 (set (inference-node-grounded? infn) (inference-node-grounded? x))
;;;	 (set (inference-node-level infn) (inference-node-level x))))
;;;     (deduction-graph-inference-nodes dg))
;;;    new-dg))
;;;

(define (SEQUENT-NODE-SELECT-INFERENCE-NODE sqn)
  (let* ((infs (sequent-node-proper-in-arrows sqn)))
    (if (null? infs)
	'#f
	(last infs))))
;;;	(let ((max-pref (apply max (map inference-node-preference infs))))
;;;	  (any
;;;	   (lambda (x)
;;;	     (let ((pref (inference-node-preference x)))
;;;	       (if (= max-pref pref) x '#f)))
;;;	   infs))

(define (SEQUENT-NODE-PROPER-IN-ARROWS sqn)
  
  ;;If sqn is grounded, returns the grounded in-arrows 
  ;;Otherwise returns all in-arrows. 

  (if (sequent-node-grounded? sqn)
      (iterate loop ((accum '()) (in-arrows (sequent-node-in-arrows sqn)))
	(cond ((null? in-arrows) accum)
	      ((and (inference-node-grounded? (car in-arrows))
		    (<= (inference-node-level (car in-arrows))
			(sequent-node-level sqn)))
	       (loop (cons (car in-arrows) accum) (cdr in-arrows)))
	      (else (loop accum (cdr in-arrows)))))
      (sequent-node-in-arrows sqn)))

(define (SIMPLE-INFERENCE? inf)
  (= (length (inference-node-hypotheses inf)) 1))

(define (LINEAR-INFERENCE? inf)
  (and (context-assumptions
	(sequent-context
	 (sequent-node-sequent (inference-node-conclusion inf))))
       (let ((conclusion-context
	      (sequent-context
	       (sequent-node-sequent (inference-node-conclusion inf)))))
	 (every? (lambda (x)
		   (eq? conclusion-context
			(sequent-context
			 (sequent-node-sequent x))))

		 (inference-node-hypotheses inf)))))
 
(define (LOCAL-INFERENCE? inf) '#f)

;;;  (let ((conc-num (sequent-node-number (inference-node-conclusion inf))))
;;;    (any?
;;;
;;;     (lambda (x)
;;;       (= 1 (- (sequent-node-number x) conc-num)))
;;;     (inference-node-hypotheses inf)))

;;;(define (RENUMBER-SEQUENT-NODES dg)
;;;  
;;;  ;;start by resetting all sequent node numbers to '#f:
;;;
;;;  (walk (lambda (x) (set (sequent-node-number x) '#f))
;;;	(deduction-graph-sequent-nodes dg))
;;;
;;;  (set (sequent-node-number (deduction-graph-goal dg)) 0)
;;;
;;;  (let ((num 1))
;;;
;;;    (iterate loop ((sqn (deduction-graph-goal dg)))
;;;      (let ((in-arrow (sequent-node-select-inference-node sqn)))
;;;	(if in-arrow
;;;	    (block
;;;	      (walk (lambda (x)
;;;		      (if (null? (sequent-node-number x))
;;;			  (block (set (sequent-node-number x) num)
;;;				 (set num (1+ num)))))
;;;		    (inference-node-hypotheses in-arrow))
;;;	      (walk loop (inference-node-hypotheses in-arrow)))))))
;;;  dg)
;;;
;;;(define (SEQUENT-NODE-BASE sqn infs)
;;;  ;;returns a list of sequent nodes where sqni is supported by sqnsi using inferences
;;;  ;;in infs.
;;;  (let ((infs-1 (set-intersection (sequent-node-proper-in-arrows sqn) infs)))
;;;    (if (null? infs-1) (list sqn)
;;;	(block
;;;	  (set *inference-nodes-to-discard* (set-union *inference-nodes-to-discard* infs-1))
;;;	  (let ((sqns (inference-node-hypotheses (car infs-1))))
;;;	    (if (null? sqns) (list sqn)
;;;		(big-u (map (lambda (x) (sequent-node-base x infs)) sqns))))))))
;;;
;;;;;;preference of a rule is used for selecting a node for printing.

;;;(define-settable-operation (RULE-PREFERENCE rule) 0)
;;;(define (INFERENCE-NODE-PREFERENCE inf)
;;;  (rule-preference
;;;   (inference-rule
;;;    (inference-node-inference inf))))
;;;
;;;(define (CONSOLIDATE-INFERENCE-NODES-RULE infs dg a-name)
;;;  (let ((preference 1))
;;;    (labels
;;;	((soi
;;;	  (object
;;;	      (lambda (sequents)
;;;		(or (null? (cdr sequents))
;;;		    (imps-error "CONSOLIDATE-INFERENCE-NODES-RULE: Too many sequents ~S" sequents))
;;;		(let* ((conc (car sequents))
;;;		       (hyps (map sequent-node-sequent
;;;				  (sequent-node-base (post conc dg) infs))))
;;;		  (if (equal? hyps (list conc)) '#f
;;;		      (build-inference  soi hyps conc))))
;;;
;;;	    ((rule? soi) '#t)
;;;	    ((rule-preference soi) preference)
;;;	    (((setter rule-preference) soi val) (set preference val))
;;;	    ((rule-soundness-predicate soi)
;;;	     (lambda (theory) (sub-theory? (deduction-graph-theory dg) theory)))
;;;	    ((name soi) (if a-name (car a-name) 'consolidated-inference-nodes-rule))
;;;	    ((rule-generator soi) consolidate-inference-nodes-rule))))
;;;      soi)))
;;;
;;;(define (CONSOLIDATE-DIRECT-INFERENCES-RULE dg)
;;;  (let ((preference 1))
;;;    (labels
;;;	((soi
;;;	  (object
;;;	      (lambda (sequents)
;;;		(or (null? (cdr sequents))
;;;		    (imps-error "CONSOLIDATE-DIRECT-INFERENCES-RULE: Too many sequents ~S" sequents))
;;;		(let* ((conc (car sequents))
;;;		       (hyps
;;;			(map sequent-node-sequent
;;;			     (sequent-node-base (post conc dg)
;;;						(deduction-graph-direct-inferences dg)))))
;;;
;;;		  (if (equal? hyps (list conc)) '#f
;;;		      (build-inference  soi hyps conc))))
;;;
;;;	    ((rule? soi) '#t)
;;;	    ((rule-preference soi) preference)
;;;	    (((setter rule-preference) soi val) (set preference val))
;;;	    ((rule-soundness-predicate soi)
;;;	     (lambda (theory) (sub-theory? (deduction-graph-theory dg) theory)))
;;;	    ((name soi) 'consolidated-direct-inferences-rule)
;;;	    ((rule-generator soi) consolidate-direct-inferences-rule))))
;;;      soi)))
;;;
;;;
;;;(define (CONSOLIDATE-INFERENCES-BY-GENERATOR-RULE dg generator a-name)
;;;  (let ((preference 1))
;;;    (labels
;;;	((soi
;;;	  (object
;;;	      (lambda (sequents)
;;;		(or (null? (cdr sequents))
;;;		    (imps-error
;;;		     "CONSOLIDATE-DIRECT-INFERENCES-BY-GENERATOR-RULE: Too many sequents ~S" sequents))
;;;		(let* ((conc (car sequents))
;;;		       (hyps
;;;			(map sequent-node-sequent
;;;			     (sequent-node-base
;;;			      (post conc dg)
;;;			      (deduction-graph-generator-inferences dg generator)))))
;;;
;;;		  (if (equal? hyps (list conc)) '#f
;;;		      (build-inference  soi hyps conc))))
;;;
;;;	    ((rule? soi) '#t)
;;;	    ((rule-preference soi) preference)
;;;	    (((setter rule-preference) soi val) (set preference val))
;;;	    ((rule-soundness-predicate soi)
;;;	     (lambda (theory) (sub-theory? (deduction-graph-theory dg) theory)))
;;;	    ((name soi)  (if a-name (car a-name) 'consolidated-inferences-rule))
;;;	    ((rule-generator soi) consolidate-inferences-by-generator-rule))))
;;;      soi)))
;;;
;;;
;;;(define (DEDUCTION-GRAPH-DIRECT-INFERENCES dg)
;;;  (iterate loop ((infs (deduction-graph-inference-nodes dg)) (accum '()))
;;;    (cond ((null? infs) accum)
;;;	  ((direct-inference? (inference-rule (inference-node-inference (car infs))))
;;;	   (loop (cdr infs) (cons (car infs) accum)))
;;;	  (else (loop (cdr infs) accum)))))
;;;
;;;
;;;(define (DEDUCTION-GRAPH-GENERATOR-INFERENCES dg generator)
;;;  (iterate loop ((infs (deduction-graph-inference-nodes dg)) (accum '()))
;;;    (cond ((null? infs) accum)
;;;	  ((eq?
;;;	    (rule-generator
;;;	     (inference-rule (inference-node-inference (car infs))))
;;;	    generator)
;;;	   (loop (cdr infs) (cons (car infs) accum)))
;;;	  (else (loop (cdr infs) accum)))))
;;;
;;;(define (DEDUCTION-GRAPH-CONSOLIDATE-GENERATOR-INFERENCES dg generator . a-name)
;;;  (let ((rule (consolidate-inferences-by-generator-rule dg generator a-name)))
;;;    (iterate loop ((sqn (deduction-graph-goal dg)))
;;;      (let ((inference (deduction-graph-infer rule (list sqn) dg)))
;;;	(if (succeed? inference)
;;;	    (walk loop (inference-node-hypotheses inference))
;;;	    (let ((in-arrow (sequent-node-select-inference-node sqn)))
;;;	      (if in-arrow
;;;		  (walk loop (inference-node-hypotheses in-arrow)) '#t)))))
;;;    dg))
;;;
;;;(define (DEDUCTION-GRAPH-CONSOLIDATE-DIRECT-INFERENCES dg)
;;;  (let ((rule (consolidate-direct-inferences-rule dg)))
;;;    (iterate loop ((sqn (deduction-graph-goal dg)))
;;;      (let ((inference (deduction-graph-infer rule (list sqn) dg)))
;;;	(if (succeed? inference)
;;;	    (walk loop (inference-node-hypotheses inference))
;;;	    (let ((in-arrow (sequent-node-select-inference-node sqn)))
;;;	      (if in-arrow
;;;		  (walk loop (inference-node-hypotheses in-arrow)) '#t)))))
;;;    dg))
;;;
;;;
;;;(define (PROOF-STATISTICS dg)
;;;  (let ((generator-distribution-table (make-table)))
;;;    (iterate loop ((inferences (deduction-graph-inference-nodes dg)))
;;;      (if (null? inferences)
;;;	  generator-distribution-table
;;;	  (let* ((generator
;;;		  (rule-generator (inference-rule (inference-node-inference (car inferences)))))
;;;		 (look-up (table-entry generator-distribution-table generator)))
;;;	    (if look-up
;;;		(set (table-entry generator-distribution-table generator)
;;;		     (1+ look-up))
;;;		(set (table-entry generator-distribution-table generator) 1))
;;;	    (loop (cdr inferences)))))))

