/* xse -- Send key events to a named window. */
/* John D. Ramsdell.  December 1990 */

/* xse window-name message
Sends the named window X events that simulate typing the message.
*/

/* $Header: /tmp_mnt/usr/src/local2/imps/src/xse/RCS/xse.c,v 1.2 92/01/24 12:50:37 guttman Exp $ */

#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>

char *display_name = NULL;
char *program_name;		/* Used for error messages. */

/* finds the first window named window_name by a depth-first
   search of the tree rooted at window.
   returns non-zero on success. */
int find_named_window(display, window_name, window, window_return)
     Display *display;
     char *window_name;
     Window window, *window_return;
{
  char *name_return;
  Window root, parent, *child, *children;
  unsigned int nchildren;

  if (XFetchName(display, window, &name_return)
      && !strcmp(name_return, window_name)) {
    *window_return = window;	/* Found window. */
    return 1;
  }
  
  if (!XQueryTree(display, window, /* Get children. */
		  &root, &parent, &children, &nchildren)) {
    fprintf (stderr, "%s:  Tree Query of root failed.\n", program_name);
    exit (1);
  }

  for (child = children; child < children+nchildren; child++)
    if (find_named_window(display, window_name, *child, window_return)) {
      XFree((char *) children);	/* Search succeeded */
      return 1;
    }

  XFree((char *) children);	/* Search failed. */
  return 0;
}

void send_key_event (display, window, key, type)
     Display *display;
     Window window;
     KeySym key;
     int type;
{
  XEvent event[1];
  event->xkey.type = type;
  event->xkey.state = NoEventMask;
  event->xkey.keycode = XKeysymToKeycode(display, key);

  if (!XSendEvent(display, window, True,
		  KeyPressMask|KeyReleaseMask, event)) {
    fprintf(stderr, "XSendEvent failed\n");
    exit (1);
  }
  XFlush(display);
}

int send_key_message(display, window, message)
     Display *display;
     Window window;
     char *message;
{
  for (; *message != '\0'; message++) {
    send_key_event(display, window, (KeySym) *message, KeyPress);
    send_key_event(display, window, (KeySym) *message, KeyRelease);
  }
  return 0;
}

int main (argc, argv)
     int argc;
     char **argv;
{
  Display *display;
  Window root, window;
  char *window_name;

  program_name = argv[0];

  if (argc != 3) {
    fprintf (stderr, "%s:  Usage:  %s window_name message\n",
	     program_name, program_name);
    exit (1);
  }

  window_name = argv[1];

  if (NULL == (display = XOpenDisplay(display_name))) {
    fprintf (stderr, "%s:  unable to open display \"%s\"\n",
	     program_name, XDisplayName (display_name));
    exit (1);
  }

  root = RootWindowOfScreen (DefaultScreenOfDisplay (display));
  if (!find_named_window (display, window_name, root, &window)) {
    fprintf (stderr, "Cannot find a window named %s.\n", window_name);
    exit (1);
  }

  return send_key_message (display, window, argv[2]);
}
