/* Lexical analysis. */

/* $Header: /usr/src/local/imps/src/xdg/RCS/scan.c,v 1.1 90/11/02 11:33:00 ramsdell Exp $ */

/* Scanner for Lisp-like syntax.
   ; is the comment character.
   Delimiters are EOF, white space, '(', ')', and '"'.
   Delimiters may be included in atoms by quoting the atom
   with a pair of '"' characters.
*/

#include <stdio.h>
#include <ctype.h>
#include "scan.h"
#include "store.h"
#include "parse.h"

#define SYMBOL_LENGTH 256
#define isnewline(c) ((c)=='\n')
#define isdelim(c) \
  ((c) == EOF || (isspace(c)) || \
   (c) == '(' || (c) == ')' || (c) == '"' || (c) == ';')
#define isatom(c) ((isprint(c)) && !(isdelim(c)))

char scanned_text[SYMBOL_LENGTH];

int line_number = 1;

#if defined __STDC__
int scan (void)
#else
int scan ()
#endif
{
  int c; int i;

  while (isspace (c = fgetc(stdin))) /* remove leading spaces. */
    if (isnewline(c)) line_number++;

  switch(c) {
  case ';':
    do {			/* Ignore comment characters. */
      c = fgetc(stdin);
      if (c == EOF) return c;
    } while (!isnewline (c));
    return scan ();		/* Return next token. */
  case EOF:
  case '(':
  case ')':
    return c;
  case '"':			/* Found a string. */
    i = 0;
    while (1) {
      c = fgetc(stdin);
      if (c == EOF) parse_error("EOF within a string");
      if (c == '"') {		/* End of string. */
	if (i >= SYMBOL_LENGTH - 1)
	  parse_error("string too long");
	scanned_text[i] = '\0';
	return ATOM;
      }
      if (c == '\\') {
	c = fgetc(stdin);
	if (c == EOF) parse_error("EOF within a string");
      }
      scanned_text[i++] = c;
      if (i >= SYMBOL_LENGTH) i--;
    }
  default:
    i = 0;
    do {			/* Copy input */
      scanned_text[i++] = c;	/* into scanned_text. */
      c = fgetc (stdin);
      if (i >= SYMBOL_LENGTH) i--;
    } while (isatom(c));
    if (i >= SYMBOL_LENGTH - 1)
      parse_error("atom too long");
    ungetc (c, stdin);
    scanned_text[i] = '\0';
#if !defined CASE_SENSITIVE_SYMBOLS
    {
      char *s;			/* Lower case is the preferred case. */
      for (s = scanned_text; *s != '\0'; s++)
	if (isupper(*s)) *s = tolower(*s);
    }
#endif
    return ATOM;
  }
}
