;; Copyright (c) 1990-1994 The MITRE Corporation
;; 
;; Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;;   
;; The MITRE Corporation (MITRE) provides this software to you without
;; charge to use, copy, modify or enhance for any legitimate purpose
;; provided you reproduce MITRE's copyright notice in any copy or
;; derivative work of this software.
;; 
;; This software is the copyright work of MITRE.  No ownership or other
;; proprietary interest in this software is granted you other than what
;; is granted in this license.
;; 
;; Any modification or enhancement of this software must identify the
;; part of this software that was modified, by whom and when, and must
;; inherit this license including its warranty disclaimers.
;; 
;; MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;; OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;; OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;; FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;; SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;; SUCH DAMAGES.
;; 
;; You, at your expense, hereby indemnify and hold harmless MITRE, its
;; Board of Trustees, officers, agents and employees, from any and all
;; liability or damages to third parties, including attorneys' fees,
;; court costs, and other related costs and expenses, arising out of your
;; use of this software irrespective of the cause of said liability.
;; 
;; The export from the United States or the subsequent reexport of this
;; software is subject to compliance with United States export control
;; and munitions control restrictions.  You agree that in the event you
;; seek to export this software or any derivative work thereof, you
;; assume full responsibility for obtaining all necessary export licenses
;; and approvals and for assuring compliance with applicable reexport
;; restrictions.
;; 
;; 
;; COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994



(defconst major-version (read (substring emacs-version  0 2))
  "Number of major version of this incarnation of emacs, either 18 or 19")


(defun v18p ()
  "True if using FSF v18.whatever."
  (= major-version 18))

(defun v19-lucid-p ()
  "True if using Lucid lemacs v19."
  (and (= major-version 19)
       (string-match "Lucid" emacs-version)))

(defun v19-fsf-p ()
  "True if using FSF emacs v19."
  (and (= major-version 19)
       (not (string-match "Lucid" emacs-version))))

(defconst imps-files
  (cond ((and window-system (v19-lucid-p))
	 '(process-filter theory-information sqns cmpn imps-edit protocols 
		       deduction-graphs imps-commands xdg imps-manual
		       imps-df-templates imps-proof-edit imps-lucid-support
		       imps-tutorial micro-exercises def-form-edit))
	((and window-system (v19-fsf-p))
	 '(process-filter theory-information sqns cmpn imps-edit protocols 
		       deduction-graphs imps-commands xdg imps-manual
		       imps-df-templates imps-proof-edit imps-fsf-support
		       imps-tutorial micro-exercises imps-font-lock def-form-edit))

	(window-system
	 '(process-filter theory-information sqns cmpn imps-edit protocols
		       deduction-graphs imps-commands xdg imps-manual
		       imps-df-templates imps-proof-edit imps-x-support
		       imps-tutorial micro-exercises def-form-edit))
	(t '(process-filter theory-information sqns cmpn imps-edit protocols
		       deduction-graphs imps-commands xdg imps-manual
		       imps-df-templates imps-proof-edit
		       imps-tutorial micro-exercises def-form-edit))))


(mapcar
 (function (lambda (sym)
	     (require sym)))
 imps-files)

(if (and window-system (v19-fsf-p))
    (progn (require 'frames)
	   (if (and (boundp '*calling-from-emacs*)
		    (not *calling-from-emacs*))
	       (let ((filename  (concat (getenv "HOME") "/imps/imps-emacs.el")))
		 (if (file-exists-p filename)
		     (load filename)
		   (load "frame-specs" t t))))))


(defun imps-reload-imps-files ()
  (mapcar
   (function (lambda (sym)
	       (load-library (symbol-name sym))))
   imps-files))
  
(defvar imps-xview-process '())

(defun imps-xview-maybe-start-xdvi ()
  (or (and (processp imps-xview-process)
	   (eq 'run (process-status imps-xview-process)))
      (imps-xview-start-xdvi)))      

(defun imps-xview-start-xdvi ()
  "Start up xdvi, using correct display.  
Modifies IMPS variable PREVIEWER-COMMAND."
  (interactive)
  (let ((default-directory (imps-tmp-dir)))
    (or (file-exists-p (format "%s%s-imps.dvi" default-directory (user-login-name)))
	(copy-file (expand-file-name
		    (substitute-in-file-name
		     "$IMPS/../etc/null-imps.dvi"))
		   (format "%s%s-imps.dvi" default-directory (user-login-name))))
    (tea-eval-expression
     "(block (set previewer-command \"echo\") repl-wont-print)")
    (setq imps-xview-process
	  (start-process "imps-xtex" nil "xdvi" "-iconic" "-keep"
			 "-s" "2" (concat (user-login-name) "-imps.dvi")))))

(defun imps-tmp-dir ()
  "Expand $IMPS_TMP if that's defined, otherwise /tmp/"
  (let ((imps-dir (getenv "IMPS_TMP")))
    (if imps-dir
	(format "%s/" (expand-file-name imps-dir))
      "/tmp/")))

(defun run-latex-for-imps ()
  (let ((default-directory (imps-tmp-dir)))
    (condition-case var
	(progn (call-process
		"latex" nil 
		(get-buffer-create "*IMPS LaTeX Output*")
		nil
		(concat (user-login-name) "-imps"))
	       (message "Starting xview... done"))
      (error
       (message "Latex failed. Please see system guru.")))))

(defun imps-ref ()
  "Insert (imps-ref ) and poise cursor before left-paren."
  (interactive)
  (insert-string "(imps-ref )")
  (backward-char 1))

(defun imps-set-current-theory (theory-name)
  (interactive
   (list  (imps-completing-read "New theory: "
				 imps-obarray
				 'kind-is-theory-p
				 nil
				 nil)))
  (tea-eval-expression (format "(set (current-theory) (name->theory '%s))" theory-name)))

(defun imps-error (format-string)
  (ding)
  (or (buffer-visible-p (get-buffer "*tea*"))
      (with-output-to-temp-buffer
	    "*IMPS Error Buffer*"	
	(princ format-string))))

(defvar tea-gc-now nil
  "True of false depending on whether Tea is now garbage collecting now.")

(defun tea-start-gc ()
  (setq tea-gc-now t)
  (message "Tea starting to GC... "))

(defun tea-finish-gc ()
  (setq tea-gc-now nil)
  (message "Tea starting to GC... GC done."))

(define-key inferior-tea-mode-map "\C-co"	'imps-ref)

(defun imps-print-tex-output ()
  (interactive)
  (shell-command
   (format "dvips /tmp/%s-imps | lpr %s"
	   (user-login-name)
	   (mapconcat (function (lambda (a) a))
		      lpr-switches
		      " "))))

(defvar imps-save-tex-dir
  (let ((dir (expand-file-name "~/imps/proofs/")))
    (if (file-directory-p dir)
	dir
      (expand-file-name "~/"))))

(defun imps-save-tex-output ()
  "Copy /tmp/{$USER}-imps.tex to FILENAME." 
  (interactive)
  (let ((filename (read-file-name "Copy to file: " imps-save-tex-dir)))
    (copy-file (format "/tmp/%s-imps.tex" (user-login-name))
	       filename 0 t)))



(defvar imps-input-history '()
  "List of previously submitted IMPS inputs.")

(defconst imps-input-history-max 32
  "Maximum length of imps-input-history ring before oldest elements are thrown away.")

(defvar imps-input-history-offset 0
  "Offset of current entry within imps-input-history")


(defun imps-get-input ()
  (nth imps-input-history-offset imps-input-history))

(defun imps-push-input (str)
  (setq imps-input-history (cons str imps-input-history))
  (if (> (length imps-input-history) imps-input-history-max)
      (setcdr (nthcdr (1- imps-input-history-max) imps-input-history) nil)))

(defun imps-increment-history-offset ()
  (if (< (1+ imps-input-history-offset)
	 (length imps-input-history))
      (setq imps-input-history-offset (1+ imps-input-history-offset))))

(defun imps-decrement-history-offset ()
  (if (< 0 imps-input-history-offset)
      (setq imps-input-history-offset (1- imps-input-history-offset))))

(defun imps-reset-history-offset ()
  (setq imps-input-history-offset 0))

(defun imps-mb-insert-previous-input ()
  (interactive)
  (erase-buffer)
  (insert (imps-get-input))
  (imps-increment-history-offset))
  
(defun imps-mb-insert-next-input ()
  (interactive)
  (erase-buffer)
  (insert (imps-get-input))
  (imps-decrement-history-offset))
  
(defun imps-mb-return ()
  (interactive)
  (imps-reset-history-offset)
  (let ((str (buffer-string)))
    (or (string= str "")
	(imps-push-input str)))
  (exit-minibuffer))

(defun imps-read-from-minibuffer (prompt &optional initial-input keymap read)
  (catch 'minibuffer-read-tag
    ;; I'm sorry if catches and throws are offensive to people, but it
    ;; is very convenient in this case.
    (let ((keymap (or keymap imps-minibuffer-map)))
      (read-from-minibuffer prompt initial-input keymap read))))

;(defun imps-read-from-minibuffer (prompt &optional initial-input keymap read)
;  (let ((keymap (or keymap imps-minibuffer-map)))
;    (read-from-minibuffer prompt initial-input keymap read)))

(defun imps-completing-read (prompt table &optional predicate require-match initial-input)
  (let ((minibuffer-local-completion-map imps-minibuffer-completion-map))
    (completing-read prompt table predicate require-match initial-input)))


(defun abort-resetting-history-offset ()
  "command to abort recursive-edit, resetting imps history offset."
  (interactive)
  (imps-reset-history-offset)
  (abort-recursive-edit))

(defvar inferior-tea-minibuffer-map (copy-keymap inferior-tea-mode-map))
(define-key inferior-tea-minibuffer-map "\C-co" 'imps-ref)
(define-key inferior-tea-minibuffer-map "\C-m" 'imps-mb-return)
(define-key inferior-tea-minibuffer-map "\C-g" 'abort-resetting-history-offset)
(define-key inferior-tea-minibuffer-map "\en" 'imps-mb-insert-next-input)
(define-key inferior-tea-minibuffer-map "\ep" 'imps-mb-insert-previous-input)

(defvar imps-minibuffer-map (copy-keymap minibuffer-local-map))
(define-key imps-minibuffer-map "\C-co" 'imps-ref)
(define-key imps-minibuffer-map "\C-m" 'imps-mb-return)
(define-key imps-minibuffer-map "\C-g" 'abort-resetting-history-offset)
(define-key imps-minibuffer-map "\en" 'imps-mb-insert-next-input)
(define-key imps-minibuffer-map "\ep" 'imps-mb-insert-previous-input)

(defvar imps-minibuffer-completion-map (copy-keymap minibuffer-local-completion-map))
(define-key imps-minibuffer-completion-map "\C-co" 'imps-ref)
(define-key imps-minibuffer-completion-map "\C-m" 'imps-mb-return)
(define-key imps-minibuffer-completion-map "\C-g" 'abort-resetting-history-offset)
(define-key imps-minibuffer-completion-map "\en" 'imps-mb-insert-next-input)
(define-key imps-minibuffer-completion-map "\ep" 'imps-mb-insert-previous-input)


;; (define-key minibuffer-local-map "\en" 'next-history-element)
;; (define-key minibuffer-local-map "\ep" 'previous-history-element)
(define-key minibuffer-local-map "\C-g" 'abort-resetting-history-offset)
(define-key macete-minibuffer-map "\en" 'imps-mb-insert-next-input)
(define-key macete-minibuffer-map "\ep" 'imps-mb-insert-previous-input)
(define-key macete-minibuffer-map "\C-g" 'abort-resetting-history-offset)
(define-key macete-minibuffer-map "\C-m" 'imps-mb-return)


(provide 'imps)
