/****************************************************************************
**
**    engel.c                         NQ                       Werner Nickel
**                                                    werner@pell.anu.edu.au
**
**    Copyright Dec 1992                        Mathematics Research Section
**                                           School of Mathematical Sciences 
**                                            Australian National University
*/


#include "nq.h"
#include "engel.h"

static	int	LeftEngel = 0, RightEngel = 0, Engel = 0;
static	int	NrWords;
static	word	A;

static
void	Error( v, w, type )
word	v, w;
char	type;

{	printf( "Overflow in collector computing [ " );
	printWord( v, 'a' );
	if( type == 'e' ) printf( " , %d ", Engel );
	if( type == 'l' ) printf( " , %d ", LeftEngel );
	if( type == 'r' ) printf( " , %d ", RightEngel );
	printWord( w, 'a' );
	printf( " ]\n" );
}

static
void	evalEngelRel( v, w )
word	v, w;

{	word	v1, vv = v;
	long	n;

/*	printf( "evalEngelRel() called with : " );*/
/*	printWord( v, 'A' );*/
/*	printf( "    " );*/
/*	printWord( w, 'A' );*/
/*	putchar( '\n' );*/

	NrWords++;
	/* Calculate [ v, w, .., w ] */
	if( (v = Commutator( v, w )) == (word)0 ) {
	    Error( vv, w, 'e' );
	    return;
	}
	n = Engel-1;
	while( n-- > 0 ) { 
	    if( (v1 = Commutator( v, w )) == (word)0 ) {
		Error( vv, w, 'e' );
		free( v );
		return;
	    }
	    free( v );
	    v = v1;
	}

	addRow( ExpVecWord( v ) );
	free( v );
}

static
void	buildPairs( u, i, g, v, wt, which )
word	u, v;
long	i;
gen	g;
long	wt, which;

{	long	save_wt;

	if( wt == 0 && which == 1 && i > 0 && WordCmp( u, v ) != 0 ) {
	    evalEngelRel( u, v );
	    return;
	}

	/* Keep u and start to build v. */
	if( i > 0 && which == 2 ) buildPairs( v, 0, 1, u, wt, 1 );

	if( g > NrPcGens ) return;

	save_wt = wt;
	while( g <= NrPcGens && Wt(g) <= wt ) {
	    u[i].g   = g;
	    u[i].e   = 0;
	    u[i+1].g = EOW;
	    while( Wt(g) <= wt ) {
		u[i].e++;
		if( Exponent[g] > 0 && Exponent[g] == u[i].e ) break;
		wt -= Wt(g);
		buildPairs( u, i+1, g+1, v, wt, which );
	    }
	    wt = save_wt;
	    g++;
	}
	u[i].g = EOW;
	u[i].e = 0;
}

static
void	evalEngel()

{	word	u, v;
	long	c;

	u = (word)Allocate( (NrPcGens+NrCenGens+1) * sizeof(gpower) );
	v = (word)Allocate( (NrPcGens+NrCenGens+1) * sizeof(gpower) );

	for( c = 2; c <= Class+1; c++ ) {
	    u[0].g = EOW; u[0].e = 0;
	    v[0].g = EOW; v[0].e = 0;
	    NrWords = 0;
	    if(Verbose) printf("#    Checking pairs of words of weight %d",c);
	    buildPairs( u, 0, 1, v, c, 2 );
	    if(Verbose) printf( " (%d)\n", NrWords );
	}

	free( u ); free( v );
}

static
void	evalRightEngelRel( w )
word	w;

{	word	v, v1;
	long	n;

/*	printf( "evalRightEngelRel() called with : " );*/
/*	printWord( w, 'A' );*/
/*	putchar( '\n' );*/

	NrWords++;
	/* Calculate [ a, w, .., w ] */
	if( (v = Commutator( A, w )) == (word)0 ) {
	    Error( A, w, 'r' );
	    return;
	}
	n = RightEngel-1;
	while( n-- > 0 ) {
	    if( (v1 = Commutator( v, w )) == (word)0 ) {
		Error( A, w, 'r' );
		free( v );
		return;
	    }
	    free( v );
	    v = v1;
	}

	addRow( ExpVecWord( v ) );
	free( v );
}

static
void	evalLeftEngelRel( w )
word	w;

{	word	v, v1;
	long	n;

/*	printf( "evalLeftEngelRel() called with : " );*/
/*	printWord( w, 'A' );*/
/*	putchar( '\n' );*/

	NrWords++;
	/* Calculate [ w, a, .., a ] */
	if( (v = Commutator( w, A )) == (word)0 ) {
	    Error( w, A, 'l' );
	    return;
	}
	n = LeftEngel-1;
	while( n-- > 0 ) {
	    if( (v1 = Commutator( v, A )) == (word)0 ) {
		Error( w, A, 'l' );
		free( v );
		return;
	    }
	    free( v );
	    v = v1;
	}

	addRow( ExpVecWord( v ) );
	free( v );
}

static
void	buildWord( u, i, g, wt )
word	u;
long	i, wt;
gen	g;

{	long	save_wt;

	if( wt == 0 && i > 0 ) { 
	    if( RightEngel ) evalRightEngelRel( u );
	    if( LeftEngel )  evalLeftEngelRel( u );
	    return;
	}

	if( g > NrPcGens ) return;

	save_wt = wt;
	while( g <= NrPcGens && Wt(g) <= wt ) {
	    u[i].g   = g;
	    u[i].e   = 0;
	    u[i+1].g = EOW;
	    while( Wt(g) <= wt ) {
		u[i].e++;
		if( Exponent[g] > 0 && Exponent[g] == u[i].e ) break;
		wt -= Wt(g);
		buildWord( u, i+1, g+1, wt );
	    }
	    wt = save_wt;
	    g++;
	}
	u[i].g = EOW;
	u[i].e = 0;
}

static
void	evalLREngel() {

	word	u;
	long	cl;

	A = (word)Allocate( 2*sizeof(gpower) );
	A[0].g = 1;   A[0].e = 1;
	A[1].g = EOW; A[1].e = 0;

	u = (word)Allocate( (NrPcGens+NrCenGens+1) * sizeof(gpower) );

	for( cl = 2; cl <= Class+1; cl++ ) {
	    u[0].g = EOW; u[0].e = 0;
	    NrWords = 0;
	    if(Verbose) printf("#    Checking words of weight %d",cl-1);
	    buildWord( u, 0, 1, cl-1 );
	    if(Verbose) printf( " (%d)\n", NrWords );
	}

	free( u ); free( A );
}

void	EvalEngel() {	

	long	t;

	if( Verbose ) t = RunTime();

	if( LeftEngel || RightEngel ) evalLREngel();
	if( Engel ) evalEngel();

	if( Verbose )
	    printf("#    Evaluated Engel condition (%d msec).\n",RunTime()-t);
}

void	InitEngel( l, r, e )
int	l, r, e;

{	LeftEngel = l;
	RightEngel = r;
	Engel = e;
}
