		/* display.c - a xview previer for xyplot */
		/*  ronnie@goshawk.lanl.gov 1992 */

/* xysee.c -- modified by jt@lanl.gov 
              from original display.c, by ronnie@goshawk.lanl.gov
   CHANGES:
   main changes are:
       o  no longer assumes that scaling range will be 4096, 
          but reads value from the input file
       o  reads lineWidth from input file, so variable thicknesses
          are plotted; originally, only lineWidth=0 was assumed.
          also, the default is 1, not 0
       o  tries to do linestyle as a separate function
       o  verbose flag for debugging, and some debugging printf's
     
   new variables and functions:

      verbose flag: for debugging
      float xSize=4096,
            ySize=4096: range of incoming coordinates, 
                        originally hardcoded xSize=ySize=4096
      get_unscaled_coord(point): unscaled version of getcoord(),
                                 but now getcoord scales
	  int capStyle = CapButt,
	      joinStyle = JoinMiter: variables now instead of being hardcoded

	  linestyle(gc,dpy,label): this is a function now, instead of
                               part of a long switch
      char lineStyle[20]:      global variable, for linestyle()
                               is initialized to be "solid"
      int lineWidth=1;         formerly =0, this seems to work better
      FILE *err=stdout;        instead of hardcoded at stderr
                               this helps in debugging, can be
                               set to stderr if that is prefered

*/

#define YES	(1)
#define NO	(0)

#include <ctype.h>
#include <X11/Xlib.h>
#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/canvas.h>
#include <xview/win_event.h>
#include <xview/xv_xrect.h>
#include <xview/svrimage.h>
#include <xview/icon.h>

int verbose=0; /* note that though verbose may help debug, it
                  puts the program into an infinite loop!
                */

#include <stdio.h>
FILE *err = stdout;

typedef struct coordinate {
	int x,y;
} coordinate;


float Scale;			/* how to rescale the fixed coordinates */
float xSize=4096.,
      ySize=4096.;      /* range of incoming coordinates */
int Width, Height;		/* dimensions of the canvas */

char lineStyle[20];
int lineWidth=1;        /* line width */
                        /* width == 0 is better for diagonal lines; but
                           width == 1 is better for vertical & horizontal */
int capStyle = CapButt;     /* or: CapRound */
int joinStyle = JoinMiter;  /* or: JoinRound */

Frame RootFrame;		/* the root frame */
FILE *DataFile;			/* the temporary file with the data */
char *DataFileName;		/* name of the temporary file */
char *Prog;
int Erase = -1;			/* how many times to erase */
int Page = 0;			/* which page to draw */

short i_image[] = {
#include "display.icon"
};

short i_mask[] = {
#include "display.mask"
};

main(ac,av)
char *av[];
int ac;
{
	Frame frame;
	Canvas canvas;
	Server_image icon_image, icon_mask;
	Icon icon;
	void paint(),pressed();

	strcpy(lineStyle,"solid"); /* initialize lineStyle */

	xv_init(XV_INIT_ARGC_PTR_ARGV,&ac,av,NULL);
	Prog = av[0];
	
	frame = (Frame) xv_create(NULL,FRAME,
		XV_WIDTH, 450,
		XV_HEIGHT, 400,
		FRAME_LABEL,Prog,	/* display program name */
		NULL);
	
	RootFrame = frame;

	canvas = (Canvas) xv_create(frame,
		CANVAS,
		CANVAS_REPAINT_PROC, paint,
		CANVAS_X_PAINT_WINDOW, TRUE,
		NULL);

	icon_mask = (Server_image) xv_create(NULL, SERVER_IMAGE,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		SERVER_IMAGE_BITS, i_mask,
		NULL);

	icon_image = (Server_image) xv_create(NULL, SERVER_IMAGE,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		SERVER_IMAGE_BITS, i_image,
		NULL);
	
	icon = (Icon) xv_create(frame, ICON,
		ICON_TRANSPARENT, TRUE,
		ICON_MASK_IMAGE, icon_mask,
		ICON_IMAGE, icon_image,
		NULL);
	xv_set(frame, FRAME_ICON, icon, NULL);

	xv_set(canvas_paint_window(canvas),
		WIN_EVENT_PROC, pressed,
		WIN_CONSUME_EVENTS,
		   WIN_MOUSE_BUTTONS, NULL,
		NULL);

	xv_main_loop(frame);
	fclose(DataFile);
	unlink(DataFileName);
	exit(0);
}


void
paint(canvas,win,dpy,xwin,area)
Canvas canvas;
Xv_window win;
Display *dpy;
Window xwin;
Xv_xrectlist *area;
{
	extern float Scale;
	extern float xSize,ySize;
	extern int Width,Height;
	GC gc;
	coordinate lleft,uright,current,center,start;
	int code,drawing,eread;
	char label[256];
	char *getstring();
	static int once=NO;

	gc = DefaultGC(dpy,DefaultScreen(dpy));
	Width = (int) xv_get(win,XV_WIDTH);
	Height = (int) xv_get(win,XV_HEIGHT);
	Scale = (Width>Height) ? Height : Width;
	XClearWindow(dpy,xwin);

    eread = 0;
    if (Page==0) drawing = YES; else drawing = NO;
    while( (code = getletter()) != EOF)
	{
		if (verbose) fprintf(err,"code: %c ",(char)code);
		switch(code)
        {
        case 'e':                               /* clear screen */
			if (!once) ++Erase;
			++eread;
			if (eread==Page) drawing=YES; else drawing= NO;
			break;
        case 's':               /* set up space area */
			get_unscaled_coord(&lleft);
			get_unscaled_coord(&uright);
			xSize = uright.x - lleft.x;
			ySize = uright.y - lleft.y;
			break;
        case 'm': 
			getcoord(&current);             /* read in current point */
			break;
        case 'p':
			getcoord(&current);             /* plot a point */
			if (drawing) 
				XDrawPoint(dpy,xwin,gc,current.x,current.y);
			break;
        case 'l':  
			getcoord(&current);             /* plot a line  */
			/* continue into case 'n' */
        case 'n':                   
			getcoord(&start);         /* line from current to next*/
			if (drawing)
				XDrawLine(dpy,xwin,gc,current.x,current.y,start.x,start.y);
			current=start;
			break;
        case 't':      
			/* will not work with input method */
			getstring(label);     /* put a label in the graph */
			break;
        case 'a':                               /* draw an arc */
			getcoord(&center);
			getcoord(&start);
			getcoord(&start);
			break;
        case 'c':                               /* draw a circle */
			getcoord(&center);
			break;
        case 'f':
			getstring(label);                    /* change linestyle */
			linestyle(gc,dpy,label);
			break;
			/* NONSTANDARD protocol */
		case 'w':
			lineWidth = getint();
			linestyle(gc,dpy,lineStyle);
			break;
        default:
			fprintf(err,"%s:  Unknown Code: %c\n",Prog,code);
		}
	}
	
    once = YES;  /* the routine has been called once */
}


void
pressed(win,ev,arg)
Xv_window win;
Event *ev;
Notify_arg arg;
{
	/* hack to see if it is in window */
	if (   event_x(ev) < 0 || event_x(ev) > (int)xv_get(win,XV_WIDTH) ||
	       event_y(ev) < 0 || event_y(ev) > (int)xv_get(win,XV_HEIGHT)
	) return;
	/* if inside continue */

	if (event_action(ev) == ACTION_SELECT && event_is_up(ev)) {
		if (Erase) {
			/* clear the xv_window */
			XClearWindow(
				XV_DISPLAY_FROM_WINDOW(win),
				(Window) xv_get(win, XV_XID)
			);
			--Erase;
			++Page;
			/* repaint the canvas */
			paint( (Canvas) NULL,
			    win,
			    XV_DISPLAY_FROM_WINDOW(win),
			    (Window) xv_get(win, XV_XID),
			    (Xv_xrectlist *) NULL);
		} else 
			xv_destroy_safe(RootFrame);
	}
}

getcoord(point)
coordinate *point;
{
	int a, b, c, d;
	float x,y;
	extern float Scale;
	extern float xSize,ySize;
	extern int Width, Height;

	a = getletter();
	b = getletter();
	c = getletter();
	d = getletter();

	if (verbose) fprintf(err,"[%d][%d][%d][%d]<%d><%d>{<%d><%d>}",a,b,c,d,
						 256*b+a,256*d+c,(b<<8 | a),(d<<8 | c));

	if (verbose) fprintf(err,"(%g)[%g,%g]",Scale,xSize,ySize);

	x = (b<<8 | a)*Scale/xSize;
	y = Height - (d<<8 | c)*Scale/ySize; 
	point->x = (int)x;
	point->y = (int)y;
	if (verbose) fprintf(err,"(%g,%g)",x,y);
	if (verbose) fprintf(err,"point: %d %d\n",point->x,point->y);
}
get_unscaled_coord(point)
coordinate *point;
{
	int a, b, c, d;
	float x,y;

	a = getletter();
	b = getletter();
	c = getletter();
	d = getletter();

	point->x = (b<<8 | a);
	point->y = (d<<8 | c);
}	
getint()
{
	int a, b;

	a = getletter();
	b = getletter();

	return( b << 8 | a);
}

getletter()
{
	static int reading = NO;
	static int ReadOnce = NO;
	int c;
	FILE *mktmpfile();

	if (ReadOnce) {
		c = getc(DataFile);
		if (c != EOF ) return(c);
		else {
			rewind(DataFile);
			return(c);
		}
	} else if (reading) {
		c=getc(stdin);
		if (c != EOF) {
			putc(c,DataFile);
			return(c);
		} else {
			ReadOnce = YES;
			rewind(DataFile);
			return(EOF);
		}
	} else {
		DataFile = mktmpfile();
		if (DataFile == NULL) {
		   fprintf(err,"%s: Cannot open data file\n",Prog);
		   xv_destroy_safe(RootFrame);
		}
		reading = YES;
		return(getletter());
	}
}

char *
getstring(s)
char *s;
{
	char *a;

	a = s;
	while( (*s=getletter()) && *s != EOF && *s != '\n' && isprint(*s)) ++s;
	if (*s == EOF || !isprint(*s)) a=NULL ; else *s = '\0';
	return(a);
}
linestyle(gc,dpy,label)
GC gc;
Display *dpy;
char *label;
{
	char dashes[20];

	if(strncmp(label,"solid",5)==0) {
		XSetLineAttributes(dpy,gc,lineWidth,LineSolid,
						   capStyle,joinStyle);
		strcpy(lineStyle,"solid");
	}
	else if(strncmp(label,"dotted",6)==0) {
		dashes[0]= 1; dashes[1]=3;
		XSetDashes(dpy,gc,0,dashes,2);
		XSetLineAttributes(dpy,gc,lineWidth,LineOnOffDash,
						   capStyle,joinStyle);
		strcpy(lineStyle,"dotted");
	} 
	else if(strncmp(label,"shortdashed",11)==0) {
		dashes[0]= 5; dashes[1]=5;
		XSetDashes(dpy,gc,0,dashes,2);
		XSetLineAttributes(dpy,gc,lineWidth,LineOnOffDash,
						   capStyle,joinStyle);
		strcpy(lineStyle,"shortdashed");
	} 
	else if(strncmp(label,"longdashed",10)==0) {
		dashes[0]= 10; dashes[1]=3;
		XSetDashes(dpy,gc,0,dashes,2);
		XSetLineAttributes(dpy,gc,lineWidth,LineOnOffDash,
						   capStyle,joinStyle);
		strcpy(lineStyle,"longdashed");
	} 
	else if(strncmp(label,"dotdashed",9)==0) {
		dashes[0]= 1; dashes[1]=2;dashes[2]=3;dashes[3]=2;
		XSetDashes(dpy,gc,0,dashes,4);
		XSetLineAttributes(dpy,gc,lineWidth,LineOnOffDash,
						   capStyle,joinStyle);
		strcpy(lineStyle,"dotdashed");
	} 
	else if(strncmp(label,"dashdotdotted",13)==0) {
		dashes[0]= 3; dashes[1]=2;dashes[2]=1;dashes[3]=2;
		dashes[4]=5;
		XSetDashes(dpy,gc,0,dashes,5);
		XSetLineAttributes(dpy,gc,lineWidth,LineOnOffDash,
						   capStyle,joinStyle);
		strcpy(lineStyle,"dashdotdotted");
	}
	else
		lineStyle[0] = '\0';
} 
FILE *
mktmpfile()
{
	char *name;
	FILE *f;
	
	/* create a file in /tmp */
	name = tempnam("/tmp","xy");
	if (name == NULL) {
		fprintf(err,"%s: Could not create temporary file name\n",
				Prog);
		xv_destroy_safe(RootFrame);
	}
	DataFileName = name;

	f = fopen(name,"w+");
	return(f);
}
