/* xyplot.h */

#define YES (1)
#define NO  (0)
 
/* normally we might use HUGE here, but for Linux at least, HUGE is
 * the largest double, and what we want is the largest float.  in a
 * future release of xyplot, we'll want the largest double; in that
 * case we can go back to defining VERYBIG to being HUGE
 */
#ifndef VERYBIG
#ifdef FLOATMAX
#define VERYBIG FLOATMAX
#else
#define VERYBIG 1e30
#endif /* FLOATMAX */
#endif /* VERYBIG */

#define EPS           1e-5 /* tolerance factor */
#define SHORTLOGRANGE 100  /* if log range is less than this, then label
                              with 2's and 5's */
#define BSIZ 256           /* default BufferSize */


#define SIZE 4096                   /* resolution of a full "page" */
#define TSIZE (0.0125*SIZE)         /* convenient "units" for small features 
									 * on the graph; it is also the default 
									 * size of a subtick
									 */
#define SSize (TSIZE*overallsize)	/* convenient "scaled" units */

#define TitleSize SSize * titlesize
#define titleSize titlesize*overallsize*SIZE/4096
#define xTitleSize SSize * xtitlesize
#define xtitleSize xtitlesize*overallsize*SIZE/4096
#define yTitleSize SSize * ytitlesize
#define ytitleSize ytitlesize*overallsize*SIZE/4096
#define NumlblSize SSize * numlblsize
#define numlblSize numlblsize*overallsize*SIZE/4096

 
/*-- structures:
 *   xy:        x or y axis information
 *   datum:     single data point
 *   datastyle: how to plot a data point
 */
struct xy {
    int             xlbf, xubf; /* flag:explicit lower and upper bound */
    int             xqf;        /* flag:explicit quantum */
    double          (*xf) ();   /* transform function, e.g. log */
    float           xa, xb;     /* scaling coefficients */
    float           xlb, xub;   /* lower and upper bound */
    float           xllb, xuub; /* lower-lower and upper-upper bound */
	int				xlogf;      /* log-style axes */
    float           xquant;     /* quantum */
    float           xoff;       /* screen offset fraction */
    float           xsize;      /* screen fraction */
    int             xbot, xtop; /* screen coords of border */
    float           xmult;      /* scaling constant */
};
 
struct datum {
    float           xv;     /* x coordinate */
    float           yv;     /* y coordinate */
    float           yerr;   /* optional error on y */
	struct 
         datastyle *style;
 
};
struct datastyle {
    char            line_mode;  /* current line mode */
    char            err_flag;   /* does data have an error bar */
	char            err_xy;     /* is errorbar on x or y axis? */
    char            con_flag;   /* conect to previous point ? */
    char           *lblptr;     /* optional plot symbol or label */
	float			symsiz;		/* the size of the symbol or label */
    char            symb_flag;  /* is *lblptr a symbol or a label */
	float			line_width; /* line width */
	struct
		datastyle  *parent;     /* housekeeping */
};

/* neg(x): returns abs(x) if x negative, 0 otherwise */
/* pos(x): returns abs(x) if x positive, 0 otherwise */
#define neg(size) (((size)>0)? 0 : -(size))
#define pos(size) (((size)>0)? (size) : 0 )
#define	max(a,b)	((a)>(b)?(a):(b))
 

