
/* alloc.c
 */

/***********************************************************************/
/*  COPYRIGHT NOTICE         *******************************************/
/***********************************************************************/

/*   This program is copyright (C) 1990, Regents  of  the
University  of  California.   Anyone may reproduce this software,
in whole or in part, provided that:
(1)  Any copy  or  redistribution  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;
(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
to this software under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     This software is provided as a professional  academic
contribution for  joint exchange.  Thus it is experimental, is
provided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
Bug reports or fixes may be sent to the author, who may or may
not act on them as he desires.
*/

/*   Author:  Brian L. Tierney
 *            Lawrence Berkeley Laboratory
 *            Imaging and Distributed Computing Group
 *            email: bltierney@lbl.gov
*/

#include <stdio.h>
#include <sys/types.h>

#define Calloc(x,y) (y *)calloc((unsigned)(x), sizeof(y))
#define Fread(a,b,c,d) fread((char *)(a), b, (int)(c), d)
#define Fwrite(a,b,c,d) fwrite((char *)(a), b, (int)(c), d)

/*************************************************************/
u_char ***
alloc_3d_byte_array(nx, ny, nz)	/* in hips terminology: col,row,frame */
    int       nx, ny, nz;
{
    u_char ***array;
    register int i, j;

    /* allocate 3-d array for input image data */

    /* allocate 2 arrays of pointers */
    if ((array = Calloc(nx, u_char **)) == NULL)
	perror("calloc error: array ");
    if ((array[0] = Calloc(nx * ny, u_char *)) == NULL)
	perror("calloc error: array ");

    /* allocate array for data */
    if ((array[0][0] = Calloc(nx * ny * nz, u_char)) == NULL)
	perror("calloc error: array ");

    /* initialize pointer arrays */
    for (i = 1; i < ny; i++)
	array[0][i] = **array + (nz * i);
    for (i = 1; i < nx; i++) {
	array[i] = *array + (ny * i);
	array[i][0] = **array + (nz * ny * i);
	for (j = 1; j < ny; j++)/* initialize pointer array */
	    array[i][j] = array[i][0] + (nz * j);
    }
    return (array);
}

/****************************************************************/
float  ***
alloc_3d_float_array(nx, ny, nz)
    int       nx, ny, nz;
{
    float  ***array;
    register int i, j;

    /* allocate 3-d array for input image data */

    /* allocate 2 arrays of pointers */
    if ((array = Calloc(nx, float **)) == NULL)
	perror("calloc error: array ");
    if ((array[0] = Calloc(nx * ny, float *)) == NULL)
	perror("calloc error: array ");

    /* allocate array for data */
    if ((array[0][0] = Calloc(nx * ny * nz, float)) == NULL)
	perror("calloc error: array ");

    /* initialize pointer arrays */
    for (i = 1; i < ny; i++)
	array[0][i] = **array + (nz * i);
    for (i = 1; i < nx; i++) {
	array[i] = *array + (ny * i);
	array[i][0] = **array + (ny * nz * i);
	for (j = 1; j < ny; j++)/* initialize pointer array */
	    array[i][j] = array[i][0] + (nz * j);
    }
    return (array);
}

/**************************************************************/

long   ***
alloc_3d_long_array(nx, ny, nz)	/* in hips terminology: col,row,frame */
    int       nx, ny, nz;
{
    long   ***array;
    register int i, j;

    /* allocate 3-d array for input image data */

    /* allocate 2 arrays of pointers */
    if ((array = Calloc(nx, long **)) == NULL)
	perror("calloc error: array ");
    if ((array[0] = Calloc(nx * ny, long *)) == NULL)
	perror("calloc error: array ");

    /* allocate array for data */
    if ((array[0][0] = Calloc(nx * ny * nz, long)) == NULL)
	perror("calloc error: array ");

    /* initialize pointer arrays */
    for (i = 1; i < ny; i++)
	array[0][i] = **array + (nz * i);
    for (i = 1; i < nx; i++) {
	array[i] = *array + (ny * i);
	array[i][0] = **array + (nz * ny * i);
	for (j = 1; j < ny; j++)/* initialize pointer array */
	    array[i][j] = array[i][0] + (nz * j);
    }
    return (array);
}

/**************************************************************/
int
free_3d_array(array)
    char   ***array;
{
    cfree(array[0][0]);
    cfree(array[0]);
    cfree(array);
}

/*********************************/
int
free_2d_array(array)
    char    **array;
{
    cfree(array[0]);
    cfree(array);
}

/********************************/
int
read_3d_byte_array(fp, array, nx, ny, nz)
    FILE     *fp;
    u_char ***array;
    int       nx, ny, nz;
{
    long      rsize;

    rsize = nx * ny * nz;
    if (Fread(array[0][0], sizeof(u_char), rsize, fp) != rsize) {
	perror("\n error reading file\n");
	return (-1);
    }
    return (0);
}

/********************************/
int
read_3d_float_array(fp, array, nx, ny, nz)
    FILE     *fp;
    float  ***array;
    int       nx, ny, nz;
{
    long      rsize;

    rsize = nx * ny * nz;
    if (Fread(array[0][0], sizeof(float), rsize, fp) != rsize) {
	perror("\n error reading file\n");
	return (-1);
    }
    return (0);
}
