/* mclean.h  --  header file for image morphology noise reduction program */

/* mclean version 1.0   15 July 1991               */
/* morphological image noise reduction program     */
/*                                                 */ 
/* by Richard Alan Peters II                       */
/* Department of Electrical Engineering            */
/* Vanderbilt University School of Engineering     */ 
/* Nashville, TN 37235                             */ 
/* rap2@vuse.vanderbilt.edu                        */ 
/*                                                 */ 
/* This software is freely redistributable if      */ 
/* the author's name and affiliation are included. */

/* 

IMPORTANT: to use this program you must have the environment variable SEPATH
set to the pathname of the directory containing the structuring element file
isod8.tfm.

This is an image enhancement / noise reduction program that uses
2-dimensional gray-scale mathematical morphology. The program cleans
up any image with noise in its luminance component such that the noise 
has a smaller variance than the most important luminance edges.

In its default configuration, the program computes a smoothed version (S) of 
the luminance component (L) of the original image (I) by taking a pointwise 
average of the opening (O) and the closing (C) of L with a user-specified 
structuring element (SE). It subtracts S from L to create a residual image (R). 
The positive pixels in R form an image called the "tophat" (T) and the negative 
pixels form an image called the "bothat" (B). T contains bright image features 
that could not be created with the SE. (Recall that O is the best approximation 
of L than can be created by overlaying SE's subject to the constraint that
L is pointwise everywhere GREATER than or equal to O.) T, then, contains
noise as well lines, spots, and other thin or small (with respect to the SE), 
bright image features. B contains similar types of features, but dark 
rather than light. (Recall that C is the best approximation of L than can be 
created by overlaying SE's subject to the constraint that L is pointwise 
everywhere LESS than or equal to B.) 

If the gray level variance of the noise in L is less than that of important
luminance features such as lines and highlights, the noise can be filtered 
from R by inverse center clipping. That is, create a thresholded residual 
image (RT) by replacing with zero the value of any pixel in R whose magnitude 
is lower than some threshold. In general, the upper threshold, u (the threshold 
for T), is different in magnitude from the the lower threshold, l (the 
threshold for B). Threshold u is nonnegative and l is nonpositive. 
The important features in R remain in RT along with some isolated very bright 
or very dark noise points (isolated single pixels). Define the support of RT
to be the set of all nonzero pixels in RT. Then, the noise points are removed 
by perfoming an isolated delete on the support of RT.

RT is recombined with S as follows: 
Let TT be the thresholded tophat part of RT, and let BT be the thresholded
bothat part of RT.
Subtract u pixelwise from the TT and add the result (pixelwise) back to the S. 
Add l pixelwise to BT and subtract the result(pixelwise) from S. 
This procedure puts the important original features back in L without the noise.

Program mclean operates on Sun rasterfiles. It automatically extracts the
luminance portion of the image if the rasterfile has a colormap. The output
of mclean is a grayscale rasterfile. To recreate a color image requires
extracting the hue and saturation components from the original image and
recombining these with the cleaned up luminance. I have not tried morphological
processing on the H and S components. Also, to remake LHS image back into
an 8-bit color (lookup-table indexed) image requires use of a color
quantization scheme such as Heckbert's median cut. I do not know what noise
this will reintroduce into the result.


usage:

mclean InFile OutFile [-s g|b] [-o s|f] [-t|b] [-l nnn] [-u nnn] 
		[-f nn.nn] [-r nn.nn] [-h] [-a OCFile] 
		-k SEFile | 3x3 | 5x5 | plus | auto xxx yyy [zzz]

where:

	InFile is the path name of the Sun rasterfile input image. 

	OutFile is the pathname of the Sun rasterfile output image.

    mclean extracts and operates on the luminance component of the image.
	Thus the output of mclean is grayscale even if the input is color.

	Switch -s  indicates that the next letter tells the structuring 
	element type: either b for a binary SE or g for a gray-level SE. 
	If -s is not included, the default is binary.

	The letter following -o, either s or f, indicates that the
	operation is either a set operation or a function operation.
	If -o is not included, the default is set op. Selecting f along with
	a not-flat-topped SE will more closely approximate the original image
	However, it also seems to make the noise reduction less effective.

	The presence of -t on the command line tells mclean to do a tophat
	only process (i.e. don't use the bothat). This can be more effective
	Than the general top/bot approach if it appears that most of the
	image noise and features are lighter than their surroundings. 
	Similarly, -b means do a bothat only. This can be more effective than 
	the combo if most of the nose and features are darker than their 
	backgrounds.

	Switches -l and -u cause mclean to use the numbers following as
	lower and upper thresholds, respectively. These override mclean's
	automatically determined bothat and tophat thresholds. 
	
	Switch -f precedes a floating point nuber that is used as a scale
	factor to adjust both the lower and upper thresholds.  If it seems
	that mclean has been too extreme in its thresholding, use -f 0.nn
	to adjust the threshold down. If, on the other hand, too much noise
	appears to remain in the output, use -f 1.nn. You could actually
	go higher than 1.99 but but if the scale factor is too large, you
	will get back the original image. When not selected, the scale factor 
	defaults to 1.0.

	The floating point number following -r tells mclean to amplify the
	thresholded residual, RT, before recombining it with the the smoothed 
	image, S. This exagerates the intensity of the remaining features.
	If the number is more than about 1.05, the result looks artificial
	This defaults to 1. When not selected, RT is not amplified.

	Flag -h tells mclean to use an alternate method to select the lower
	and upper thresholds. When -h is NOT present (the default) mclean
	computes the thresholds as follows: Compute a graylevel histograms
	ht and hb from the tophat image T and bothat image B, respectively.
	ht is defined over nonnegative values only and hb is defined over
	nonpositive values only. mclean takes as lower threshold, l, the 
	second moment of hb. Similarly, u is the second moment of ht.
	When -h IS present, mclean creates one histogram, h defined over all
	values. It chooses upper and lower thresholds as the value one standard
	deviation above and below the mean, respectively.
	Generally the default procedure does a better job because in most images
	there is an unequal distribution of light and dark features (and noise).

	Switch -a tells mclean to write out the smoothed image to a file
	where OCfile represents the user-suplied file name. It can be quite
	useful to have this, sometimes, for experimentation.
	
	Switch -k indicates that the next field defines the morphological
	stucturing element (SE) in one of 5 ways:

	(1) "3x3"  --  specifies the SE to be a 3 by 3 square of pixels. 
	(Don't use the quotes "" on the actual command line.)

	(2) "plus"  --  specifies the SE to be a 3 by 3 "+" shaped set of 
	pixels.

	(3) "5x5"  --  specifies the SE to be a 5x5 quasi disk (square without
	corners) of pixels.

	If one of the canned SE's (3x3, plus, or 5x5) is chosen, the -s and -o
	flags are forced to be -s g  -o s.

	(4) "auto x y [z]"  --  the program makes an SE. The self-made SE is
	a disk with support covering x pixels horizontally and y pixels
	vertically.  x and y must be odd. If specified, z is the gray level of 
	the center pixel. If z > 0, a function operation (-o f) is performed. 
	If z is not given or z == 0, the level defaults to BLACK (0) and a set
	operation is performed (-o s). If "-k auto" is specified the SE type is 
	forced to gray (-s g).

	(5) If the field following -k is not one of the above, then the 
	string, called SEFILE in the usage example, is taken as the pathname 
	of a structuring element file. If the user has an environment 
	variable called SEPATH, the program appends SEFILE to it for the
	complete pathname.

	A structuring element file is an ASCII file of integers separated
	by spaces. The first two numbers, x, y, are the horizontal and 
	vertical dimensions in pixels of the smallest rectangle that will 
	cover the structuring element. Both x and y must be > 0.
	The next two numbers, i, j are the horizontal and vertical 
	coordinates, respectively, of the SE origin.  
	IMPORTANT: The origin is expected to be in the covering rectangle. 
	The upper left hand corner of  the rectangle has coordinates (0,0); 
	the lower right is (x-1,y-1).
	Following the first four integers are x*y integers separated by 
	spaces. These numbers are the SE elements. Their interpretation 
	depends on the morphological operation being performed.

	Negative SE elements are ALWAYS treated as logical DON'T CAREs. That
	is, when the operation is in progress, image pixels under negative SE
	elements are ignored. Thus, the support of the SE is limited to
	those elments that are nonnegative. This permits the creation
	of odd-shaped and multiply connected SE's.

*/
	

/* includes */

#include <ctype.h>
#include <math.h>
#include <malloc.h>			
#include <stdio.h>	
#include <strings.h>


/* defs */

#define SFMASK	0x0400		/* set / function mask */
#define SET		0x0000		/* set operation */
#define FUNCT	0x0400		/* function operation */

#define IMMASK  0x0200		/* image type bit of MorphOp */
#define	GRAIMG	0x0000		/* gray-level image flag */
#define	BINIMG	0x0200		/* binary image flag */

#define SEMASK	0x0100		/* structuring element (SE) type bit */
#define GRASE	0x0000		/* gray-level SE */
#define BINSE	0x0100		/* binary SE */

#define OPMASK	0x00FF		/* morph operation type bits of MorphOp */
#define LLMASK  0x001F		/* low-level morph ops mask */
#define	ERODE	0x0001		/* erode flag  */
#define	DILATE	0x0002		/* dilate flag */
#define	OPEN	0x0004		/* open flag   */
#define	CLOSE	0x0008		/* close flag  */
#define RANK	0x0010		/* rank filter flag */
#define TOPHAT  0x0020		/* tophat (image minus open ) flag */
#define BOTHAT  0x0040		/* tophat (close minus image) flag */
#define NOTFLG  0x0080      /* "not" flag for binary erodes and dilates */

#define SEPATH	"SEPATH"	/* structuring element directory env. var */

#define AUTO	1		/* make disk SE */
#define PLUS	2		/* use 3 by 3 "+" shaped SE */
#define S3X3	3		/* use 3 by 3 square SE */
#define S5X5	4		/* use 5 by 5 quasi disk SE */

#define BLACK	0
#define WHITE	255
#define TRUE	1
#define FALSE	0
#define ZERO	0
#define NSIZE	256
#define ALLOC	TRUE

#define MIN(a,b) ((a<b)?(a):(b))
#define MAX(a,b) ((a>b)?(a):(b))

/* typedefs */

#ifndef BYTE
typedef unsigned char byte;
#define BYTE 1
#endif

#ifndef WORD
typedef short int word;
#define WORD
#endif
