#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <Sender.h>
#include <Receiver.h>

/* This test was written to test the Port Manager's "DisconnectFromPortMgr" function.
   The program connects with the Port Manager, then waits for a return to be pressed at
   the terminal.  When the return is pressed, the program formally disconnects from
   the Port Manager.
*/

main(int argc, char** argv)
{
  Sender*	sender;
  Receiver*	receiver;
  Port		senderPort;

  printf("Starting the test.\n");
  printf("Port number to connect to is %d.\n",PortMgrPortNumber);
  senderPort.hostName = argv[1];
  senderPort.portNumber = PortMgrPortNumber;
  sender = NewSender(&senderPort);
  receiver = NewReceiver(sender,argv[0],AnyPort);
  printf("Connected with the Port Manager.\n");
  printf("Please press the Return key to exit this program.\n");
  getchar();
  printf("Thank you.  Now attempting a clean break-off with the Port Manager.\n");
  SenderDisconnectFromPortMgr(sender,&(receiver->receivePort));
  printf("Disconnected from the Port Manager.  Exiting.\n");
  exit(0);
}
