/*
 *  my_stubs.c - derived from Button_stubs.c 
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <gdd.h>
#include "Button_ui.h"

#include "Browse.h"

#ifdef MAIN

/* $Header: /Source/Media/warren/Browse/RCS/Button.c,v 0.15 91/05/30 11:50:26 warren Exp Locker: warren $ */
/* $Log:	Button.c,v $
 * Revision 0.15  91/05/30  11:50:26  warren
 * Making all rev numbers the same -- about to ci a new version to collab
 * 
 * Revision 0.10  1991/05/09  01:40:43  warren
 * *** empty log message ***
 * */
static char rcsid[] = "$Header: /Source/Media/warren/Browse/RCS/Button.c,v 0.15 91/05/30 11:50:26 warren Exp Locker: warren $";


/* Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */
Attr_attribute	INSTANCE;
char *keepIt;
int OpenHandler(), SaveHandler();

void
main(argc, argv)
	int		argc;
	char		**argv;
{
	Button_window1_objects	*Button_window1;
	
	/*
	 * Initialize XView.
	 */
	xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, 0);
	INSTANCE = xv_unique_key();
	
        /*
	 * Initialize user interface components.
	 */
	Button_window1 = Button_window1_objects_initialize(NULL, NULL);
	CreateBrowse(OpenHandler, SaveHandler, 
			Button_window1->window1);    /* Create the Browse with window1 as owner */

	
	/*
	 * Turn control over to XView.
	 */
	xv_main_loop(Button_window1->window1);
	exit(0);
}

#endif


int
  OpenHandler(char *proposedPath, int id)
{
  char *errorMessage;
  
  if (strcmp("mmmmmm", proposedPath) != 0)
    {
    printf("Button: OpenHandler thinks that %s \nlooks like a good path.\n", proposedPath);	  
    keepIt = (char *)strdup(proposedPath);				    /* Keep a copy for use elsewhere */
    return 0;
  }
  else
    {
      errorMessage = (char*)malloc(50*sizeof(char));
      sprintf(errorMessage, "OpenHandler does not like the name 'mmmmmm'\n");
      free(proposedPath);
      proposedPath = errorMessage;
      return(1);
  }
}

int
  SaveHandler(char *proposedPath, int id)
{
  char *errorMessage;
  
  if (strcmp("mmmmmm", proposedPath) != 0)
    {
    printf("Button: SaveHandler thinks that %s \nlooks like a good path.\n", proposedPath);	  
    keepIt = (char *)strdup(proposedPath);				    /* Keep a copy for use elsewhere */
    return 0;
  }
  else
    {
      errorMessage = (char*)malloc(50*sizeof(char));
      sprintf(errorMessage, "SaveHandler does not like the name 'mmmmmm'\n");
      free(proposedPath);
      proposedPath = errorMessage;
      return(1);
  }
}

/*
 * Notify callback function for `open'.
 */
void
openNotify(item, event)
	Panel_item	item;
	Event		*event;
{
  Button_window1_objects	*ip = (Button_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
  char *path = "/Source";					    /* Where to start browsing */

  fputs("Button: openNotify\n", stderr);
  Browse(NULL, BrowseOpen, NULL, NULL, NULL);     /* Now use it */
}

/*
 * Notify callback function for `save'.
 */
void
saveNotify(item, event)
	Panel_item	item;
	Event		*event;
{
  Button_window1_objects	*ip = (Button_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
  char *path = "/Source";					    /* Where to start browsing */

  fputs("Button: openNotify\n", stderr);
  Browse(NULL, BrowseSave, NULL, "#Shell Edit File#", "ShellEdit");      /* Now use it */
}



