;GIL-3
(
(
	:type                   :menu
	:name                   previewMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Video Preview"
	:menu-item-labels       ("Play entire edit" "Play part of edit..." )
	:menu-item-label-types  (:string :string )
	:menu-item-states       (:active :active )
	:menu-item-defaults     (t nil )
	:initial-selections     (nil nil )
	:menu-item-handlers     (PreviewStartEnd EditPreview )
	:menu-item-menus        (nil nil )
	:menu-item-colors       ("" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (previewMenu "Play entire edit")
		:when                   (Notify )
		:to                     (previewMenu "Play entire edit")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PreviewStartEnd)
		)
		(
		:from                   (previewMenu "Play part of edit...")
		:when                   (Notify )
		:to                     (previewMenu "Play part of edit...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditPreview)
		)
	)
)
(
	:type                   :menu
	:name                   editAudioMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Stereo"
	:menu-item-labels       ("Stereo" "Right" "Left" "Mute" )
	:menu-item-label-types  (:string :string :string :string )
	:menu-item-states       (:active :active :active :active )
	:menu-item-defaults     (t nil nil nil )
	:initial-selections     (nil nil nil nil )
	:menu-item-handlers     (EditAudioStereo EditAudioRight EditAudioLeft EditAudioMute )
	:menu-item-menus        (nil nil nil nil )
	:menu-item-colors       ("" "" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (editAudioMenu "Stereo")
		:when                   (Notify )
		:to                     (editAudioMenu "Stereo")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditAudioStereo)
		)
		(
		:from                   (editAudioMenu "Right")
		:when                   (Notify )
		:to                     (editAudioMenu "Right")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditAudioRight)
		)
		(
		:from                   (editAudioMenu "Left")
		:when                   (Notify )
		:to                     (editAudioMenu "Left")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditAudioLeft)
		)
		(
		:from                   (editAudioMenu "Mute")
		:when                   (Notify )
		:to                     (editAudioMenu "Mute")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditAudioMute)
		)
	)
)
(
	:type                   :menu
	:name                   DocMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Document"
	:menu-item-labels       ("Open" "Save" "Save As ..." "Close File" "Close Window" )
	:menu-item-label-types  (:string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active )
	:menu-item-defaults     (nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil )
	:menu-item-handlers     (FileLoad FileSave FileSaveAs EditFileClose EditCloseWindow )
	:menu-item-menus        (nil nil nil nil nil )
	:menu-item-colors       ("" "" "" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (DocMenu "Open")
		:when                   (Notify )
		:to                     (DocMenu "Open")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (FileLoad)
		)
		(
		:from                   (DocMenu "Save")
		:when                   (Notify )
		:to                     (DocMenu "Save")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (FileSave)
		)
		(
		:from                   (DocMenu "Save As ...")
		:when                   (Notify )
		:to                     (DocMenu "Save As ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (FileSaveAs)
		)
		(
		:from                   (DocMenu "Close File")
		:when                   (Notify )
		:to                     (DocMenu "Close File")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditFileClose)
		)
		(
		:from                   (DocMenu "Close Window")
		:when                   (Notify )
		:to                     (DocMenu "Close Window")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditCloseWindow)
		)
	)
)
(
	:type                   :base-window
	:name                   window1
	:owner                  nil
	:width                  234
	:height                 452
	:background-color       "BG1"
	:foreground-color       ""
	:label                  "VCR Remote Controller"
	:label-type             :string
	:initial-state          :open
	:show-footer            t
	:resizable              t
	:icon-file              "icons/vcrEditIcon"
	:icon-label             ""
	:icon-mask-file         ""
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   remoteCtrlControls
	:owner                  window1
	:help                   ""
	:x                      0
	:y                      0
	:width                  234
	:height                 204
	:background-color       "BG1"
	:foreground-color       "Black"
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   optionsButton
	:owner                  remoteCtrlControls
	:help                   "Opens Options Popup."
	:x                      12
	:y                      12
	:width                  75
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Options..."
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Options
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 optionsButton)
		:when                   (Notify )
		:to                     (window1 optionsButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Options)
		)
	)
)
(
	:type                   :button
	:name                   editButton
	:owner                  remoteCtrlControls
	:help                   "Opens Edit List for video editing."
	:x                      100
	:y                      12
	:width                  55
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  " Edit..."
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Edit
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 editButton)
		:when                   (Notify )
		:to                     (window1 editButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Edit)
		)
	)
)
(
	:type                   :button
	:name                   quitButton
	:owner                  remoteCtrlControls
	:help                   "Quits the application."
	:x                      168
	:y                      12
	:width                  57
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  " Quit  "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Quit
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 quitButton)
		:when                   (Notify )
		:to                     (window1 quitButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Quit)
		)
	)
)
(
	:type                   :setting
	:name                   timeStg
	:owner                  remoteCtrlControls
	:help                   "Sets the selected field's slider active."
	:x                      16
	:y                      48
	:width                  197
	:height                 23
	:value-x                16
	:value-y                48
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :exclusive
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         TimeInput
	:event-handler          nil
	:choices                ("Abs" "Hr" "Min" "Sec" "Frame" )
	:choice-label-types     (:string :string :string :string :string )
	:choice-colors          ("" "" "" "" "" )
	:initial-selections     (nil nil nil nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (window1 timeStg)
		:when                   (Notify )
		:to                     (window1 timeStg)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (TimeInput)
		)
	)
)
(
	:type                   :message
	:name                   timeMsg
	:owner                  remoteCtrlControls
	:help                   ""
	:x                      72
	:y                      80
	:width                  73
	:height                 13
	:foreground-color       ""
	:label                  "00:00:00:00"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   timePlusButton
	:owner                  remoteCtrlControls
	:help                   "Increases the value of the currently
active slider by one unit."
	:x                      192
	:y                      80
	:width                  30
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "+ "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         TimePlus
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 timePlusButton)
		:when                   (Notify )
		:to                     (window1 timePlusButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (TimePlus)
		)
	)
)
(
	:type                   :slider
	:name                   secSlider
	:owner                  remoteCtrlControls
	:help                   ""
	:x                      0
	:y                      100
	:width                  176
	:height                 26
	:value-x                0
	:value-y                100
	:slider-width           130
	:ticks                  7
	:foreground-color       ""
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          nil
	:show-range             t
	:show-value             nil
	:min-value              0
	:max-value              60
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:notify-handler         SecInput
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 secSlider)
		:when                   (Notify )
		:to                     (window1 secSlider)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SecInput)
		)
	)
)
(
	:type                   :slider
	:name                   hrSlider
	:owner                  remoteCtrlControls
	:help                   ""
	:x                      0
	:y                      100
	:width                  168
	:height                 26
	:value-x                0
	:value-y                100
	:slider-width           130
	:ticks                  9
	:foreground-color       ""
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          nil
	:show-range             t
	:show-value             nil
	:min-value              0
	:max-value              8
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:notify-handler         HrInput
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 hrSlider)
		:when                   (Notify )
		:to                     (window1 hrSlider)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (HrInput)
		)
	)
)
(
	:type                   :slider
	:name                   frameSlider
	:owner                  remoteCtrlControls
	:help                   ""
	:x                      0
	:y                      100
	:width                  176
	:height                 26
	:value-x                0
	:value-y                100
	:slider-width           130
	:ticks                  4
	:foreground-color       ""
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          nil
	:show-range             t
	:show-value             nil
	:min-value              0
	:max-value              30
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:notify-handler         FrameInput
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 frameSlider)
		:when                   (Notify )
		:to                     (window1 frameSlider)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (FrameInput)
		)
	)
)
(
	:type                   :slider
	:name                   minSlider
	:owner                  remoteCtrlControls
	:help                   ""
	:x                      0
	:y                      100
	:width                  176
	:height                 26
	:value-x                0
	:value-y                100
	:slider-width           130
	:ticks                  7
	:foreground-color       ""
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          nil
	:show-range             t
	:show-value             nil
	:min-value              0
	:max-value              60
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:notify-handler         MinInput
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 minSlider)
		:when                   (Notify )
		:to                     (window1 minSlider)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (MinInput)
		)
	)
)
(
	:type                   :slider
	:name                   absSlider
	:owner                  remoteCtrlControls
	:help                   ""
	:x                      20
	:y                      100
	:width                  146
	:height                 26
	:value-x                20
	:value-y                100
	:slider-width           130
	:ticks                  9
	:foreground-color       ""
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          nil
	:show-range             nil
	:show-value             nil
	:min-value              0
	:max-value              864000
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:notify-handler         AbsInput
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 absSlider)
		:when                   (Notify )
		:to                     (window1 absSlider)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (AbsInput)
		)
	)
)
(
	:type                   :button
	:name                   timeMinusButton
	:owner                  remoteCtrlControls
	:help                   "Decreases the value on the currently
active time slider by one unit."
	:x                      192
	:y                      116
	:width                  30
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "- "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         TimeMinus
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 timeMinusButton)
		:when                   (Notify )
		:to                     (window1 timeMinusButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (TimeMinus)
		)
	)
)
(
	:type                   :text-field
	:name                   frameTxt1
	:owner                  remoteCtrlControls
	:help                   "Hour field for position of tape head."
	:x                      16
	:y                      140
	:width                  36
	:height                 15
	:value-x                16
	:value-y                140
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         HrTxtInput
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 frameTxt1)
		:when                   (Notify )
		:to                     (window1 frameTxt1)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (HrTxtInput)
		)
	)
)
(
	:type                   :text-field
	:name                   frameTxt2
	:owner                  remoteCtrlControls
	:help                   "Minute field of position of tape head."
	:x                      64
	:y                      140
	:width                  47
	:height                 15
	:value-x                75
	:value-y                140
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ":"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         MinTxtInput
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 frameTxt2)
		:when                   (Notify )
		:to                     (window1 frameTxt2)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (MinTxtInput)
		)
	)
)
(
	:type                   :text-field
	:name                   frameTxt3
	:owner                  remoteCtrlControls
	:help                   "Second field of position of tape head."
	:x                      112
	:y                      140
	:width                  47
	:height                 15
	:value-x                123
	:value-y                140
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ":"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         SecTxtInput
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 frameTxt3)
		:when                   (Notify )
		:to                     (window1 frameTxt3)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SecTxtInput)
		)
	)
)
(
	:type                   :text-field
	:name                   frameTxt4
	:owner                  remoteCtrlControls
	:help                   "Frame field of position of tape head."
	:x                      164
	:y                      140
	:width                  47
	:height                 15
	:value-x                175
	:value-y                140
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ":"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         FrameTxtInput
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 frameTxt4)
		:when                   (Notify )
		:to                     (window1 frameTxt4)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (FrameTxtInput)
		)
	)
)
(
	:type                   :button
	:name                   searchButton
	:owner                  remoteCtrlControls
	:help                   "Searches for the position denoted by
the time shown by the slider."
	:x                      24
	:y                      172
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Search"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Search
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 searchButton)
		:when                   (Notify )
		:to                     (window1 searchButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Search)
		)
	)
)
(
	:type                   :button
	:name                   currFrameButton
	:owner                  remoteCtrlControls
	:help                   "Gets the current position of tape head."
	:x                      120
	:y                      172
	:width                  100
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Current Time"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         CurrentFrame
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 currFrameButton)
		:when                   (Notify )
		:to                     (window1 currFrameButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (CurrentFrame)
		)
	)
)
(
	:type                   :control-area
	:name                   remoteIconControls
	:owner                  window1
	:help                   ""
	:x                      0
	:y                      203
	:width                  234
	:height                 249
	:background-color       "BG1"
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   pauseButton
	:owner                  remoteIconControls
	:help                   "Toggles between pause (video still) and
playback."
	:x                      24
	:y                      12
	:width                  42
	:height                 25
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/pauseIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         Pause
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 pauseButton)
		:when                   (Notify )
		:to                     (window1 pauseButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Pause)
		)
	)
)
(
	:type                   :button
	:name                   playButton
	:owner                  remoteIconControls
	:help                   "Set device into playback mode."
	:x                      92
	:y                      12
	:width                  42
	:height                 25
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/playIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         Play
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 playButton)
		:when                   (Notify )
		:to                     (window1 playButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Play)
		)
	)
)
(
	:type                   :button
	:name                   stopButton
	:owner                  remoteIconControls
	:help                   "Stops playback and video mutes."
	:x                      160
	:y                      12
	:width                  42
	:height                 25
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/stopIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         Stop
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 stopButton)
		:when                   (Notify )
		:to                     (window1 stopButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Stop)
		)
	)
)
(
	:type                   :button
	:name                   scanRevButton
	:owner                  remoteIconControls
	:help                   "Fast reverses the video."
	:x                      64
	:y                      48
	:width                  42
	:height                 22
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/rwIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         ScanReverse
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 scanRevButton)
		:when                   (Notify )
		:to                     (window1 scanRevButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ScanReverse)
		)
	)
)
(
	:type                   :button
	:name                   scanFwdButton
	:owner                  remoteIconControls
	:help                   "Fast forwards the video."
	:x                      120
	:y                      48
	:width                  42
	:height                 22
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/ffIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         ScanForward
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 scanFwdButton)
		:when                   (Notify )
		:to                     (window1 scanFwdButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ScanForward)
		)
	)
)
(
	:type                   :button
	:name                   indexPrevButton
	:owner                  remoteIconControls
	:help                   "Fast rewinds to previous index."
	:x                      12
	:y                      96
	:width                  42
	:height                 22
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "icons/rIndexIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         PrevIndexSearch
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 indexPrevButton)
		:when                   (Notify )
		:to                     (window1 indexPrevButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PrevIndexSearch)
		)
	)
)
(
	:type                   :button
	:name                   revStepButton
	:owner                  remoteIconControls
	:help                   "Stills video and reverses the picture
by one frame."
	:x                      68
	:y                      96
	:width                  42
	:height                 22
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "icons/rStepIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         ReverseStep
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 revStepButton)
		:when                   (Notify )
		:to                     (window1 revStepButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ReverseStep)
		)
	)
)
(
	:type                   :button
	:name                   fwdStepButton
	:owner                  remoteIconControls
	:help                   "Stills the video and advances the picture 
by one frame."
	:x                      120
	:y                      96
	:width                  42
	:height                 22
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/fStepIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         ForwardStep
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 fwdStepButton)
		:when                   (Notify )
		:to                     (window1 fwdStepButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ForwardStep)
		)
	)
)
(
	:type                   :button
	:name                   indexNextButton
	:owner                  remoteIconControls
	:help                   "Fast forwards to next index."
	:x                      176
	:y                      96
	:width                  42
	:height                 22
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "icons/fIndexIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         NextIndexSearch
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 indexNextButton)
		:when                   (Notify )
		:to                     (window1 indexNextButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (NextIndexSearch)
		)
	)
)
(
	:type                   :button
	:name                   IndexScanRevButton
	:owner                  remoteIconControls
	:help                   "Reverse searches for indices and plays for
a few seconds at each index found."
	:x                      56
	:y                      128
	:width                  61
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "|< Scan"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         IndexScanRev
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 IndexScanRevButton)
		:when                   (Notify )
		:to                     (window1 IndexScanRevButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (IndexScanRev)
		)
	)
)
(
	:type                   :button
	:name                   indexScanFwdButton
	:owner                  remoteIconControls
	:help                   "Searches forward for indices and plays
a few seconds of each index found."
	:x                      120
	:y                      128
	:width                  61
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Scan >|"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         IndexScanFwd
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 indexScanFwdButton)
		:when                   (Notify )
		:to                     (window1 indexScanFwdButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (IndexScanFwd)
		)
	)
)
(
	:type                   :text-field
	:name                   speedTxt
	:owner                  remoteIconControls
	:help                   "Shows the current speed achieved with the
speed slider."
	:x                      40
	:y                      164
	:width                  92
	:height                 15
	:value-x                92
	:value-y                164
	:value-length           5
	:stored-length          5
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Speed:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   speedMsg
	:owner                  remoteIconControls
	:help                   ""
	:x                      140
	:y                      164
	:width                  67
	:height                 13
	:foreground-color       ""
	:label                  "frames/sec"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :slider
	:name                   speedSlider
	:owner                  remoteIconControls
	:help                   "Shuttle-knob behavior for adjusting
playback speed. 
Moving the slider to the right means forward
play, and moving it to the left means
reverse play.
Releasing the slider will still video."
	:x                      12
	:y                      188
	:width                  216
	:height                 20
	:value-x                12
	:value-y                188
	:slider-width           200
	:ticks                  0
	:foreground-color       ""
	:label                  ""
	:label-type             :string
	:layout-type            :vertical
	:orientation            :horizontal
	:show-endboxes          nil
	:show-range             nil
	:show-value             nil
	:min-value              -810
	:max-value              810
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:notify-handler         SpeedChange
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 speedSlider)
		:when                   (Notify )
		:to                     (window1 speedSlider)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SpeedChange)
		)
	)
)
(
	:type                   :button
	:name                   powerButton
	:owner                  remoteIconControls
	:help                   "Toggles power between on and off.
"
	:x                      24
	:y                      216
	:width                  42
	:height                 25
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/powerIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         Power
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 powerButton)
		:when                   (Notify )
		:to                     (window1 powerButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Power)
		)
	)
)
(
	:type                   :button
	:name                   ejectButton
	:owner                  remoteIconControls
	:help                   "Ejects the tape from the device."
	:x                      168
	:y                      216
	:width                  42
	:height                 25
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "icons/ejectIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         Eject
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 ejectButton)
		:when                   (Notify )
		:to                     (window1 ejectButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Eject)
		)
	)
)
(
	:type                   :popup-window
	:name                   optionsPopup
	:owner                  window1
	:width                  448
	:height                 270
	:background-color       ""
	:foreground-color       ""
	:label                  "Video Options"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            t
	:resizable              t
	:pinned                 t
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   optionsControls
	:owner                  optionsPopup
	:help                   "Closes Options popup."
	:x                      0
	:y                      0
	:width                  448
	:height                 270
	:background-color       "BG1"
	:foreground-color       "Black"
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   optionsPlayerStg
	:owner                  optionsControls
	:help                   "Sets the device to use with this application."
	:x                      49
	:y                      16
	:width                  125
	:height                 23
	:value-x                107
	:value-y                16
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  "Player :"
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("None" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   optionsPreSearch
	:owner                  optionsControls
	:help                   "Pre-searches for the next selection whenever
possible, for use with the TimeLine application.
"
	:x                      248
	:y                      20
	:width                  160
	:height                 23
	:value-x                339
	:value-y                20
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :exclusive
	:selection-required     t
	:label                  "Pre-search :"
	:label-type             :string
	:notify-handler         SetPreSearch
	:event-handler          nil
	:choices                ("No" "Yes" )
	:choice-label-types     (:string :string )
	:choice-colors          ("" "" )
	:initial-selections     (nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (optionsPopup optionsPreSearch)
		:when                   (Notify )
		:to                     (optionsPopup optionsPreSearch)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SetPreSearch)
		)
	)
)
(
	:type                   :setting
	:name                   port
	:owner                  optionsControls
	:help                   "Sets the serial port to which the device is
to be connected."
	:x                      21
	:y                      52
	:width                  194
	:height                 23
	:value-x                107
	:value-y                52
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :exclusive
	:selection-required     t
	:label                  "Serial Port :"
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Default" "A" "B" )
	:choice-label-types     (:string :string :string )
	:choice-colors          ("" "" "" )
	:initial-selections     (nil nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   setPlayerButton
	:owner                  optionsControls
	:help                   ""
	:x                      108
	:y                      96
	:width                  79
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Foreground"
	:label                  "Set Player"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         SetPlayer
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (optionsPopup setPlayerButton)
		:when                   (Notify )
		:to                     (optionsPopup setPlayerButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SetPlayer)
		)
	)
)
(
	:type                   :text-field
	:name                   optionsNetworkHost
	:owner                  optionsControls
	:help                   "Sets the network host to which the current
application will connect, so that it can 
communicate with other MAEstro applications
on the same network host."
	:x                      5
	:y                      136
	:width                  342
	:height                 15
	:value-x                107
	:value-y                136
	:value-length           30
	:stored-length          30
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Network Host:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         SetNetworkHost
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (optionsPopup optionsNetworkHost)
		:when                   (Notify )
		:to                     (optionsPopup optionsNetworkHost)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SetNetworkHost)
		)
	)
)
(
	:type                   :setting
	:name                   optionsAudioStg
	:owner                  optionsControls
	:help                   "Sets the audio for device operation."
	:x                      16
	:y                      168
	:width                  238
	:height                 23
	:value-x                66
	:value-y                168
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       "Black"
	:setting-type           :exclusive
	:selection-required     t
	:label                  "Audio:"
	:label-type             :string
	:notify-handler         AudioSelect
	:event-handler          nil
	:choices                ("Mute" "Left" "Right" "Stereo" )
	:choice-label-types     (:string :string :string :string )
	:choice-colors          ("" "" "" "" )
	:initial-selections     (nil nil nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (optionsPopup optionsAudioStg)
		:when                   (Notify )
		:to                     (optionsPopup optionsAudioStg)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (AudioSelect)
		)
	)
)
(
	:type                   :setting
	:name                   optionsVideoStg
	:owner                  optionsControls
	:help                   "Sets the onscreen video."
	:x                      292
	:y                      168
	:width                  138
	:height                 23
	:value-x                349
	:value-y                168
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :exclusive
	:selection-required     t
	:label                  "  Video:"
	:label-type             :string
	:notify-handler         VideoSelect
	:event-handler          nil
	:choices                ("Mute" "On" )
	:choice-label-types     (:string :string )
	:choice-colors          ("" "" )
	:initial-selections     (nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (optionsPopup optionsVideoStg)
		:when                   (Notify )
		:to                     (optionsPopup optionsVideoStg)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (VideoSelect)
		)
	)
)
(
	:type                   :setting
	:name                   optionsMutedScreen
	:owner                  optionsControls
	:help                   "Sets the color of the screen."
	:x                      192
	:y                      198
	:width                  243
	:height                 32
	:value-x                353
	:value-y                198
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  "Color of Muted Screen:"
	:label-type             :string
	:notify-handler         ScreenSelect
	:event-handler          nil
	:choices                ("icons/Chip" "icons/Chip" "icons/Chip" "icons/Chip" "icons/Chip" "icons/Chip" "icons/Chip" "icons/Chip" )
	:choice-label-types     (:glyph :glyph :glyph :glyph :glyph :glyph :glyph :glyph )
	:choice-colors          ("Magenta" "Blue" "Green" "Yellow" "Red" "Violet" "Cyan" "Green Yellow" )
	:choice-defaults        (nil nil nil nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil nil nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (optionsPopup optionsMutedScreen)
		:when                   (Notify )
		:to                     (optionsPopup optionsMutedScreen)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ScreenSelect)
		)
	)
)
(
	:type                   :setting
	:name                   optionsBrightStg
	:owner                  optionsControls
	:help                   "Sets screen brightness."
	:x                      16
	:y                      201
	:width                  164
	:height                 26
	:value-x                102
	:value-y                201
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :exclusive
	:selection-required     t
	:label                  "Brightness:"
	:label-type             :string
	:notify-handler         BrightSelect
	:event-handler          nil
	:choices                ("icons/Full" "icons/Full" "icons/Full" )
	:choice-label-types     (:glyph :glyph :glyph )
	:choice-colors          ("White" "BG2" "Dark Slate Gray" )
	:initial-selections     (nil nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (optionsPopup optionsBrightStg)
		:when                   (Notify )
		:to                     (optionsPopup optionsBrightStg)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (BrightSelect)
		)
	)
)
(
	:type                   :button
	:name                   optionsInfoButton
	:owner                  optionsControls
	:help                   "Opens Info popup."
	:x                      152
	:y                      244
	:width                  51
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Info..."
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Info
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (optionsPopup optionsInfoButton)
		:when                   (Notify )
		:to                     (optionsPopup optionsInfoButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Info)
		)
	)
)
(
	:type                   :button
	:name                   optionsDoneButton
	:owner                  optionsControls
	:help                   ""
	:x                      256
	:y                      244
	:width                  49
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Done"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Done
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (optionsPopup optionsDoneButton)
		:when                   (Notify )
		:to                     (optionsPopup optionsDoneButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Done)
		)
	)
)
(
	:type                   :popup-window
	:name                   previewPopup
	:owner                  window1
	:width                  244
	:height                 172
	:background-color       ""
	:foreground-color       ""
	:label                  "Video Preview"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            t
	:resizable              t
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   previewControls
	:owner                  previewPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  244
	:height                 172
	:background-color       "BG1"
	:foreground-color       "Black"
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   previewMsg
	:owner                  previewControls
	:help                   ""
	:x                      72
	:y                      16
	:width                  108
	:height                 13
	:foreground-color       "Black"
	:label                  "Play Part of Edit"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   previewSecMsg
	:owner                  previewControls
	:help                   ""
	:x                      88
	:y                      36
	:width                  72
	:height                 13
	:foreground-color       ""
	:label                  "(in seconds)"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   previewPlayFirstButton
	:owner                  previewControls
	:help                   "Plays first x seconds of current
selection."
	:x                      180
	:y                      64
	:width                  38
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Midnight Blue"
	:label                  "<- "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         PreviewStart
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (previewPopup previewPlayFirstButton)
		:when                   (Notify )
		:to                     (previewPopup previewPlayFirstButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PreviewStart)
		)
	)
)
(
	:type                   :text-field
	:name                   previewPlayFirstTxt
	:owner                  previewControls
	:help                   "Enter number of seconds to playback."
	:x                      12
	:y                      68
	:width                  153
	:height                 15
	:value-x                94
	:value-y                68
	:value-length           3
	:stored-length          3
	:rows                   3
	:foreground-color       "Black"
	:text-type              :numeric
	:label                  "Play first : "
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              999
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         PreviewStartTxt
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (previewPopup previewPlayFirstTxt)
		:when                   (Notify )
		:to                     (previewPopup previewPlayFirstTxt)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PreviewStartTxt)
		)
	)
)
(
	:type                   :button
	:name                   previewPlayLastButton
	:owner                  previewControls
	:help                   "Plays last x seconds of current
selection."
	:x                      180
	:y                      96
	:width                  38
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Midnight Blue"
	:label                  "<- "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         PreviewEnd
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (previewPopup previewPlayLastButton)
		:when                   (Notify )
		:to                     (previewPopup previewPlayLastButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PreviewEnd)
		)
	)
)
(
	:type                   :text-field
	:name                   previewPlayLastTxt
	:owner                  previewControls
	:help                   "Enter number of seconds."
	:x                      12
	:y                      100
	:width                  149
	:height                 15
	:value-x                90
	:value-y                100
	:value-length           3
	:stored-length          3
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "Play last  :"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              100
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         PreviewEndTxt
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (previewPopup previewPlayLastTxt)
		:when                   (Notify )
		:to                     (previewPopup previewPlayLastTxt)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PreviewEndTxt)
		)
	)
)
(
	:type                   :button
	:name                   previewDoneButton
	:owner                  previewControls
	:help                   "Closes Preview popup."
	:x                      68
	:y                      132
	:width                  104
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Close window"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         PreviewDone
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (previewPopup previewDoneButton)
		:when                   (Notify )
		:to                     (previewPopup previewDoneButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PreviewDone)
		)
	)
)
(
	:type                   :popup-window
	:name                   infoPopup
	:owner                  window1
	:width                  477
	:height                 265
	:background-color       ""
	:foreground-color       ""
	:label                  "About vcrEdit"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            t
	:resizable              t
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   infoControls
	:owner                  infoPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  477
	:height                 265
	:background-color       "BG1"
	:foreground-color       "Black"
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   infoMsg5
	:owner                  infoControls
	:help                   ""
	:x                      162
	:y                      16
	:width                  149
	:height                 13
	:foreground-color       "Black"
	:label                  "VCR Edit  Version 1.14"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   infoMsg6
	:owner                  infoControls
	:help                   ""
	:x                      78
	:y                      40
	:width                  317
	:height                 13
	:foreground-color       "Black"
	:label                  "An application for annotating and editing videotape"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   infoMsg7
	:owner                  infoControls
	:help                   ""
	:x                      21
	:y                      64
	:width                  430
	:height                 13
	:foreground-color       ""
	:label                  "designed for use with the MAEstro Multimedia Authoring Environment"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   infoMsg1
	:owner                  infoControls
	:help                   ""
	:x                      180
	:y                      96
	:width                  111
	:height                 13
	:foreground-color       "Black"
	:label                  "by Wee-Lee Lim"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   infoMsg3
	:owner                  infoControls
	:help                   ""
	:x                      8
	:y                      132
	:width                  457
	:height                 13
	:foreground-color       "Black"
	:label                  "Copyright (C) 1990, 1991, 1992 Libraries and Information Resources (L&IR)"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   infoMsg2
	:owner                  infoControls
	:help                   ""
	:x                      176
	:y                      156
	:width                  118
	:height                 13
	:foreground-color       "Black"
	:label                  "Stanford University"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   infoMsg8
	:owner                  infoControls
	:help                   ""
	:x                      177
	:y                      176
	:width                  119
	:height                 13
	:foreground-color       ""
	:label                  "Stanford, California"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   infoMsg4
	:owner                  infoControls
	:help                   ""
	:x                      82
	:y                      204
	:width                  309
	:height                 13
	:foreground-color       "Black"
	:label                  "For more info, contact maestro@sioux.stanford.edu"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   infoOkButton
	:owner                  infoControls
	:help                   "Closes Info popup."
	:x                      216
	:y                      236
	:width                  36
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "OK"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         InfoDone
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (infoPopup infoOkButton)
		:when                   (Notify )
		:to                     (infoPopup infoOkButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (InfoDone)
		)
	)
)
(
	:type                   :popup-window
	:name                   editPopup
	:owner                  window1
	:width                  584
	:height                 482
	:background-color       "BG1"
	:foreground-color       ""
	:label                  "Untitled"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            t
	:resizable              t
	:pinned                 t
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   editFileControls
	:owner                  editPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  584
	:height                 40
	:background-color       "BG1"
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   editDocButton
	:owner                  editFileControls
	:help                   ""
	:x                      28
	:y                      12
	:width                  94
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Document"
	:label-type             :string
	:initial-state          :active
	:menu                   DocMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   editScrollListControls
	:owner                  editPopup
	:help                   ""
	:x                      0
	:y                      40
	:width                  584
	:height                 226
	:background-color       "BG1"
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editListMsg
	:owner                  editScrollListControls
	:help                   ""
	:x                      264
	:y                      15
	:width                  56
	:height                 13
	:foreground-color       "Black"
	:label                  "Edit List"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editNumEditMsg
	:owner                  editScrollListControls
	:help                   ""
	:x                      424
	:y                      15
	:width                  88
	:height                 13
	:foreground-color       "Black"
	:label                  "No. of Edits : 0"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editTableHeader
	:owner                  editScrollListControls
	:help                   ""
	:x                      24
	:y                      39
	:width                  361
	:height                 13
	:foreground-color       "Black"
	:label                  "  Edit #            Label                             Start              End"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editTableHeader2
	:owner                  editScrollListControls
	:help                   ""
	:x                      440
	:y                      39
	:width                  39
	:height                 13
	:foreground-color       ""
	:label                  "Audio"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editTableHeader3
	:owner                  editScrollListControls
	:help                   ""
	:x                      500
	:y                      39
	:width                  41
	:height                 13
	:foreground-color       ""
	:label                  "Speed"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :scrolling-list
	:name                   editScrollList
	:owner                  editScrollListControls
	:help                   "Displays edits."
	:x                      4
	:y                      64
	:width                  545
	:height                 146
	:value-x                4
	:value-y                64
	:rows                   7
	:foreground-color       "Black"
	:label                  ""
	:title                  ""
	:label-type             :string
	:layout-type            :horizontal
	:read-only              nil
	:multiple-selections    nil
	:selection-required     nil
	:initial-state          :active
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:notify-handler         List
	:event-handler          nil
	:initial-list-values    ()
	:initial-list-glyphs    ()
	:initial-selections     ()
	:user-data              ()
	:actions                (
		(
		:from                   (editPopup editScrollList)
		:when                   (Notify )
		:to                     (editPopup editScrollList)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (List)
		)
	)
)
(
	:type                   :control-area
	:name                   editSelectionControls
	:owner                  editPopup
	:help                   ""
	:x                      0
	:y                      266
	:width                  584
	:height                 216
	:background-color       "BG1"
	:foreground-color       "Black"
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editNewEditMsg
	:owner                  editSelectionControls
	:help                   ""
	:x                      196
	:y                      16
	:width                  189
	:height                 13
	:foreground-color       "Black"
	:label                  "Current Selection : New Edit"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editTimeMsg1
	:owner                  editSelectionControls
	:help                   ""
	:x                      84
	:y                      44
	:width                  14
	:height                 13
	:foreground-color       ""
	:label                  "Hr"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editTimeMsg2
	:owner                  editSelectionControls
	:help                   ""
	:x                      132
	:y                      44
	:width                  23
	:height                 13
	:foreground-color       ""
	:label                  "Min"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editTimeMsg3
	:owner                  editSelectionControls
	:help                   ""
	:x                      188
	:y                      44
	:width                  20
	:height                 13
	:foreground-color       ""
	:label                  "Sec"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editTimeMsg4
	:owner                  editSelectionControls
	:help                   ""
	:x                      232
	:y                      44
	:width                  38
	:height                 13
	:foreground-color       ""
	:label                  "Frame"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   editGetStartButton
	:owner                  editSelectionControls
	:help                   "Places current playback position as 
start of current selection."
	:x                      276
	:y                      64
	:width                  34
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "<-"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         GetStart
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editPopup editGetStartButton)
		:when                   (Notify )
		:to                     (editPopup editGetStartButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (GetStart)
		)
	)
)
(
	:type                   :text-field
	:name                   editStartTxt1
	:owner                  editSelectionControls
	:help                   "Hour field of start of current selection."
	:x                      16
	:y                      68
	:width                  91
	:height                 15
	:value-x                71
	:value-y                68
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  "Start  : "
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   editStartTxt2
	:owner                  editSelectionControls
	:help                   "Minute field of start of current selection."
	:x                      112
	:y                      68
	:width                  47
	:height                 15
	:value-x                123
	:value-y                68
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ":"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   editStartTxt3
	:owner                  editSelectionControls
	:help                   "Second field of start of current selection."
	:x                      168
	:y                      68
	:width                  47
	:height                 15
	:value-x                179
	:value-y                68
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ":"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   editStartTxt4
	:owner                  editSelectionControls
	:help                   "Frame field of start of current selection."
	:x                      220
	:y                      68
	:width                  47
	:height                 15
	:value-x                231
	:value-y                68
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ":"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editInstruct1
	:owner                  editSelectionControls
	:help                   ""
	:x                      312
	:y                      68
	:width                  113
	:height                 13
	:foreground-color       "Black"
	:label                  "Get current frame "
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   editGetEndButton
	:owner                  editSelectionControls
	:help                   "Places the current playback position as
the end of current selection."
	:x                      276
	:y                      88
	:width                  34
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "<-"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         GetEnd
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editPopup editGetEndButton)
		:when                   (Notify )
		:to                     (editPopup editGetEndButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (GetEnd)
		)
	)
)
(
	:type                   :message
	:name                   editInstruct2
	:owner                  editSelectionControls
	:help                   ""
	:x                      316
	:y                      88
	:width                  48
	:height                 13
	:foreground-color       "Black"
	:label                  "number"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   editSpeedTxt
	:owner                  editSelectionControls
	:help                   "Speed setting for current selection.
Whether segment play can perform at
any particular speed depends on the
device."
	:x                      424
	:y                      88
	:width                  127
	:height                 15
	:value-x                476
	:value-y                88
	:value-length           5
	:stored-length          5
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "Speed:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              810
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         EditSpeedSet
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editPopup editSpeedTxt)
		:when                   (Notify )
		:to                     (editPopup editSpeedTxt)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditSpeedSet)
		)
	)
)
(
	:type                   :text-field
	:name                   editEndTxt1
	:owner                  editSelectionControls
	:help                   "Hour field of end of current selection."
	:x                      16
	:y                      92
	:width                  92
	:height                 15
	:value-x                72
	:value-y                92
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  "End    : "
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   editEndTxt2
	:owner                  editSelectionControls
	:help                   "Minute field of end of current selection."
	:x                      112
	:y                      92
	:width                  47
	:height                 15
	:value-x                123
	:value-y                92
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ":"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   editEndTxt3
	:owner                  editSelectionControls
	:help                   "Second field of end of current selection."
	:x                      168
	:y                      92
	:width                  47
	:height                 15
	:value-x                179
	:value-y                92
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ":"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   editEndTxt4
	:owner                  editSelectionControls
	:help                   "Frame field of end of current selection."
	:x                      220
	:y                      92
	:width                  47
	:height                 15
	:value-x                231
	:value-y                92
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ":"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editSpeedMsg
	:owner                  editSelectionControls
	:help                   ""
	:x                      480
	:y                      112
	:width                  67
	:height                 13
	:foreground-color       ""
	:label                  "frames/sec"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   editLabelTxt
	:owner                  editSelectionControls
	:help                   "Type here to label current selection."
	:x                      16
	:y                      120
	:width                  229
	:height                 15
	:value-x                69
	:value-y                120
	:value-length           22
	:stored-length          22
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  "Label :"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   editAudioMenuButton
	:owner                  editSelectionControls
	:help                   "Audio setting for current selection.
Whether any particular audio setting can 
be played during segment play depends on
the device."
	:x                      476
	:y                      140
	:width                  57
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       ""
	:label                  "Stereo"
	:label-type             :string
	:initial-state          :active
	:menu                   editAudioMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   editDurTxt
	:owner                  editSelectionControls
	:help                   "Displays approximate duration of current
selection."
	:x                      16
	:y                      144
	:width                  228
	:height                 15
	:value-x                180
	:value-y                144
	:value-length           8
	:stored-length          80
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  "Approximate duration :"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              t
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editDurSecMsg
	:owner                  editSelectionControls
	:help                   ""
	:x                      248
	:y                      144
	:width                  48
	:height                 13
	:foreground-color       "Black"
	:label                  "seconds"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editAudioMsg
	:owner                  editSelectionControls
	:help                   ""
	:x                      424
	:y                      144
	:width                  42
	:height                 13
	:foreground-color       ""
	:label                  "Audio:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   editAddButton
	:owner                  editSelectionControls
	:help                   "Adds the selection in the Current Selection
panel (including audio and speed settings)
onto the Edit List."
	:x                      16
	:y                      176
	:width                  57
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    Add"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         EditAdd
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editPopup editAddButton)
		:when                   (Notify )
		:to                     (editPopup editAddButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditAdd)
		)
	)
)
(
	:type                   :button
	:name                   editModButton
	:owner                  editSelectionControls
	:help                   "Updates the modifications made in current
selection onto the Edit List."
	:x                      132
	:y                      176
	:width                  57
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "  Modify"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         EditModify
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editPopup editModButton)
		:when                   (Notify )
		:to                     (editPopup editModButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditModify)
		)
	)
)
(
	:type                   :button
	:name                   editDelButton
	:owner                  editSelectionControls
	:help                   "Deletes current selection in Edit List."
	:x                      244
	:y                      176
	:width                  57
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "  Delete"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         EditDelete
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editPopup editDelButton)
		:when                   (Notify )
		:to                     (editPopup editDelButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditDelete)
		)
	)
)
(
	:type                   :button
	:name                   editDelAllButton
	:owner                  editSelectionControls
	:help                   "Clears the Edit List. Please make sure all
changes are saved."
	:x                      356
	:y                      176
	:width                  86
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Delete All..."
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         EditDeleteAll
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editPopup editDelAllButton)
		:when                   (Notify )
		:to                     (editPopup editDelAllButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditDeleteAll)
		)
	)
)
(
	:type                   :button
	:name                   editPreviewButton
	:owner                  editSelectionControls
	:help                   "Menu button that allows preview of :-
1. The entire current selection
2. The first few seconds or last few
   seconds of the current selection.
"
	:x                      476
	:y                      176
	:width                  57
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Preview  "
	:label-type             :string
	:initial-state          :active
	:menu                   previewMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
)
