/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/VideoObject/RCS/PanasonicOptDriver.h,v 0.20 92/09/12 14:07:09 drapeau Exp Locker: drapeau $ */
/* $Log:	PanasonicOptDriver.h,v $
 * Revision 0.20  92/09/12  14:07:09  drapeau
 * Removed the function PanasonicOptReadResponse() since it was not being used.
 * Because of this, also removed references to XView toolkit header files.
 * 
 * Revision 0.19  92/09/01  17:11:46  drapeau
 * Updated copyright notice.
 * Also, added function prototypes to function definitions for better
 * ANSI compliance.
 * 
 * Revision 0.18  92/01/03  16:52:46  drapeau
 * Removed inclusion of string.h so as not to conflict with other files
 * that use this driver.
 * 
 * Revision 0.17  91/09/30  17:05:44  lim
 * Added PanasonicOptPing.
 * 
 * Revision 0.16  91/08/24  13:38:05  lim
 * 1. Updated to use status codes in new PlayerStatus.h
 * 2. Clear Marker() removed as part of video object.
 * 
 * Revision 0.15  91/08/07  13:46:51  lim
 * *** empty log message ***
 * 
 * Revision 0.14  91/08/07  13:04:24  lim
 * 1. Included <sys/time.h>, <sys/wait.h>, <sys/resource.h>, "videoObj.h"
 * and "PlayerStatus.h"
 * 2. PanasonicClient is set to 100.
 * 
 * Revision 0.13  91/08/02  12:53:04  lim
 * Pause() is removed.
 * 
 * Revision 0.12  91/07/29  22:25:17  lim
 * Removed #define's for player status to PlayerStatus.h
 * 
 * Revision 0.11  91/07/27  22:27:13  lim
 * Changed speed from double to int.
 * Took macros for "MyAbs" and "MyRound" to vEdit.h
 * 
 * Revision 0.10  91/07/23  16:14:25  lim
 * Initial revision.
 *  */

#include <ctype.h>
#include <fcntl.h>
#include <sys/termio.h>
#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>

#ifndef _WaitHeader_
#define _WaitHeader_
#include <sys/wait.h>
#endif

#include "PlayerStatus.h"
#include "videoObj.h"

#define Stx               '\x02'
#define Etx               '\x03'
#define Ack               '\x06'
#define Nak               '\x15'
#define PanasonicClient   100

/* Error Codes */

#define InvalidInstruction -1
#define DiskCheck          -2
#define NoDisk             -3
#define CantFindAddress    -4
#define OutOfFocus         -6
#define DiscMotorSyncNG    -7
#define OptHeadOffEnd      -8
#define RecordError        -9 
#define ExtVideoError      -10
#define LoadError          -11
#define Moisture           -12
#define RcvBuffOverflow    -20
#define CommError          -21
#define InvalidCmdFormat   -22
#define ConcentricDisc     -24
#define Battery            -30
#define NestingErr         -32
#define NoProgram          -33
#define ProgramExceedMem   -34
#define NoiseInUnit        -35



int PanasonicOptPlay			(VideoObject*);
int PanasonicOptPlayFromTo		(VideoObject*, int, int, int);
int PanasonicOptFastForward		(VideoObject*);
int PanasonicOptReverse			(VideoObject*);
int PanasonicOptCalcSpeed		(VideoObject*, int, int);
int PanasonicOptPlayAtSpeedDir		(VideoObject*, int, enum Direction);
int PanasonicOptStep			(VideoObject*, enum Direction);
int PanasonicOptStill			(VideoObject*);
int PanasonicOptStop			(VideoObject*);
int PanasonicOptSetDefaults		(VideoObject*, int, int, int, int);
int PanasonicOptSetAudio		(VideoObject*, int);
int PanasonicOptSetVideo		(VideoObject*, int);
int PanasonicOptSetAddressDisplay	(VideoObject*, int, int);
int PanasonicOptEject			(VideoObject*);
int PanasonicOptPower			(VideoObject*, int);
int PanasonicOptQueryFrame		(VideoObject*);
int PanasonicOptQueryChapter		(VideoObject*);
int PanasonicOptQueryAudio		(VideoObject*);
int PanasonicOptQueryVideo		(VideoObject*);
int PanasonicOptQueryMedium		(VideoObject*, char*);
int PanasonicOptQueryStatus		(VideoObject*);
int PanasonicOptPing			(VideoObject*);
int PanasonicOptRecord			(VideoObject*);
int PanasonicOptRecordFromTo		(VideoObject*, int, int, int);
void PanasonicOptErrorDecode		(VideoObject*, int, char*);
