/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/VideoEdit/RCS/VideoEditPreview.c,v 0.19 92/01/03 15:49:43 drapeau Exp Locker: drapeau $ */
/* $Log:	VideoEditPreview.c,v $
 * Revision 0.19  92/01/03  15:49:43  drapeau
 * Changed occurrances of "NULL" in calls to Browse() to use "0" instead.
 * This is due to the ANSI definition of NULL as "(void*)0".
 * Also, modified function PlayMode() to more clearly show the logic
 * of the function, using defined constants from VideoObject library
 * to set current audio setting.
 * 
 * Revision 0.18  91/09/24  21:36:53  lim
 * Changed 'vEdit' to 'VideoEdit' everywhere.
 * 
 * Revision 0.17  91/08/16  13:12:08  lim
 * xsaber-ed the code.
 * 
 * Revision 0.16  91/08/07  13:29:04  lim
 * 1.Added instance pointer, "theObject" to all public function calls.
 * 2. Duration for PreviewStart and PreviewEnd corrected.
 * 
 * Revision 0.15  91/08/02  13:02:15  lim
 * 'currentAudio' is used in preview rather than audioStg[editnum]
 * 
 * Revision 0.14  91/07/29  22:30:09  lim
 * Updated status codes to conform with specs.
 * Duration in previewing start/end n seconds of
 * edit corrected to take into account speed of edit.
 * 
 * Revision 0.13  91/07/27  22:29:34  lim
 * Changed speed from double to int.
 * 
 * Revision 0.12  91/07/24  11:03:19  lim
 * Ran through xsaber - fixed warnings.
 * 
 * Revision 0.11  91/07/19  14:14:08  lim
 * Added PlayMode.
 * 
 * Revision 0.10  91/07/12  16:21:08  lim
 * Initial revision implementing VideoObject.
 *  */

#include "VideoEdit.h"

static char prevrcs[] = "$Header: /Source/Media/collab/VideoEdit/RCS/VideoEditPreview.c,v 0.19 92/01/03 15:49:43 drapeau Exp Locker: drapeau $";


/* 	EDIT PREVIEW FUNCTIONS (POPUP WINDOW 3)	*/


/* Does the standard checks for playing from `start' to `end' in `mode' */
void
PlayMode(mode, start, end)
     int mode;
     int start;
     int end;
{
  int err;
  int speed;
  
  err = DevSetAddMode(myVideo, mode);				    /* set addressing mode */
  if (err == -1)
    return;
  
  if (currentAudio == Mute)
    DevSetAudio(myVideo, PlayerAudioMute);			    /* Set audio */
  else
    if (currentAudio == Right)
      DevSetAudio(myVideo, PlayerAudioRight);
    else
      if (currentAudio == Left)
	DevSetAudio(myVideo, PlayerAudioLeft);
      else
	if (currentAudio == Stereo)
	  DevSetAudio(myVideo, PlayerAudioStereo);
  speed =  (int) xv_get(VideoEdit_editPopup->editSpeedTxt, PANEL_VALUE);
  DevPlayFromTo(myVideo, start, end, speed);			    /* Play segment at set speed */
}


/*
 * Menu handler for `previewMenu (Play entire edit)'.
 * Default : Play the current selection from start to end.
 */
Menu_item
PreviewStartEnd(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  int start;
  int end;
  int value;
  int result;
  
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
    
   case MENU_DISPLAY_DONE:
    break;
    
   case MENU_NOTIFY:
    
    /* get start and end frames */

    start = xv_get (VideoEdit_editPopup->editStartTxt, PANEL_VALUE);
    end = xv_get (VideoEdit_editPopup->editEndTxt, PANEL_VALUE);

    (void) SetDuration();
    
    result = CheckSelection(start, end);			    /* check if selection is valid */
    if (result == -1) return item;  
    
    PlayMode(PlayerFrameMode, start, end);
    
    /* check if search status is frame or chapter */
    value = xv_get(VideoEdit_optionsPopup->optionsSearchStg, 
		   PANEL_VALUE);
    if (value == 1) 
      DevSetAddMode(myVideo, PlayerChapterMode);

    break;
    
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
   
}


/*
 * Notify callback function for `previewPlayFirstButton'.
 * Play the first x seconds of the current selection.
 */
void
PreviewStart(item, event)
     Panel_item      item;
     Event           *event;
{
  
  int start;
  int end;
  int speed;
  int duration;
  int value;
  int result;
  
  /* get start and end frames */

  start = xv_get (VideoEdit_editPopup->editStartTxt, PANEL_VALUE);
  end = xv_get (VideoEdit_editPopup->editEndTxt, PANEL_VALUE);
  speed = xv_get (VideoEdit_editPopup->editSpeedTxt, PANEL_VALUE);

  result = CheckSelection(start, end);				    /* check if selection is valid */
  if (result == -1) return; 
  
  /* get the duration to be played */

  duration = xv_get (VideoEdit_previewPopup->previewPlayFirstTxt, 
		     PANEL_VALUE);
  if (end > (start + duration*speed))
    end = start + duration*speed;				    /* convert into frame numbers */
  
  PlayMode(PlayerFrameMode, start, end);
  
  /* check if search status is frame or chapter */
  value = xv_get(VideoEdit_optionsPopup->optionsSearchStg, 
		 PANEL_VALUE);
  if (value == 1) 
    DevSetAddMode(myVideo, PlayerChapterMode);
  
}

/*
 * Notify callback function for `previewPlayFirstTxt'.
 */
Panel_setting
PreviewStartTxt(item, event)
     Panel_item	item;
     Event		*event;
{
  
  if (event_action(event) != '\r')
    return (0);
  if (search == 1)
    search = 0;
  else 
  {
    PreviewStart(item, event);
    search = 1;
  }
  
}



/* Notify callback function for `previewPlayLastButton'.
 * Play the last x seconds of the current selection.
 */
void
PreviewEnd(item, event)
     Panel_item      item;
     Event           *event;
{
  int start;
  int end;
  int speed;
  int duration;
  int value;
  int result;
  
  
  /* get start and end frame numbers */
  start = xv_get (VideoEdit_editPopup->editStartTxt, PANEL_VALUE);
  end = xv_get (VideoEdit_editPopup->editEndTxt, PANEL_VALUE);
  speed = xv_get (VideoEdit_editPopup->editSpeedTxt, PANEL_VALUE);
								    
  result = CheckSelection(start, end);				    /* check if selection is valid */
  if (result == -1) return;					    
  
  /* get the duration to be played */
  duration = xv_get (VideoEdit_previewPopup->previewPlayLastTxt, 
		     PANEL_VALUE);
  if (start < (end - duration*speed))
    start = end - duration*speed;				    /* convert into frame numbers */
  
  PlayMode(PlayerFrameMode, start, end);
  
  /* Reset search status */
  value = xv_get(VideoEdit_optionsPopup->optionsSearchStg, PANEL_VALUE);
  if (value == 1) 
    DevSetAddMode(myVideo, PlayerChapterMode);
}

/*
 * Notify callback function for `previewPlayLastTxt'.
 */
Panel_setting
PreviewEndTxt(item, event)
     Panel_item	item;
     Event		*event;
{
  
  if (event_action(event) != '\r')
    return (0);
  if (search == 1)
    search = 0;
  else 
  {
    PreviewEnd(item, event);
    search = 1;
  }
  
}


/*
 * Notify callback function for `previewDoneButton'.
 * Close the preview popup window
 */
void
PreviewDone(item, event)
     Panel_item      item;
     Event           *event;
{
  xv_set(VideoEdit_previewPopup->previewPopup, FRAME_CMD_PUSHPIN_IN, FALSE, NULL);
  xv_set(VideoEdit_previewPopup->previewPopup, XV_SHOW, FALSE, NULL);
  
}
