/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
/* $Header: /Source/Media/collab/TimeLine/RCS/grid.c,v 1.0 91/09/30 16:57:29 chua Exp Locker: drapeau $ */
/* $Log:	grid.c,v $
 * Revision 1.0  91/09/30  16:57:29  chua
 * Update to version 1.0
 * 
 * Revision 0.42  91/09/19  17:28:48  chua
 * Make sure that variables are initialized properly.  Change formatting slightly,
 * so that (if, for, while) statements with only one statement in them will not have
 * braces.
 * 
 * Revision 0.41  91/07/18  15:05:13  chua
 * 
 * 
 * Revision 0.40  91/07/18  15:01:38  chua
 * This file contains the menu handlers for the grid menu (under the edit menu button).
 * It also contains the DrawGrid routine, which will draw the grid lines on the canvas
 * according to the spacing specified by the user (using the grid menu).
 *  */

static char gridrcsid[] = "$Header: /Source/Media/collab/TimeLine/RCS/grid.c,v 1.0 91/09/30 16:57:29 chua Exp Locker: drapeau $";

#include "main.h"

/*
 * Menu handler for `GridMenu (Grid Off)'.
 */
Menu_item GridOffHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  TimeLineFramePtr tlFrame;
  TimeLine_window_objects * ip = (TimeLine_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

  tlFrame = TimeLineWindow[xv_get(ip->controls, PANEL_CLIENT_DATA)];
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    tlFrame->gridSpacing = 0;
    DrawCanvasRepaintHandler(tlFrame->TimeLine_window->DrawCanvas, tlFrame->paintWinDraw, 
			     tlFrame->dpyDraw, tlFrame->xidDraw, NULL);
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/*
 * Menu handler for `GridMenu (5 pixel spacing)'.
 */
Menu_item FivePixelHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  TimeLineFramePtr tlFrame;
  TimeLine_window_objects * ip = (TimeLine_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

  tlFrame = TimeLineWindow[xv_get(ip->controls, PANEL_CLIENT_DATA)];
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    tlFrame->gridSpacing = 5;
    DrawCanvasRepaintHandler(tlFrame->TimeLine_window->DrawCanvas, tlFrame->paintWinDraw, 
			     tlFrame->dpyDraw, tlFrame->xidDraw, NULL);
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/*
 * Menu handler for `GridMenu (10 pixel spacing)'.
 */
Menu_item TenPixelHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  TimeLineFramePtr tlFrame;
  TimeLine_window_objects * ip = (TimeLine_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

  tlFrame = TimeLineWindow[xv_get(ip->controls, PANEL_CLIENT_DATA)];
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    tlFrame->gridSpacing = 10;
    DrawCanvasRepaintHandler(tlFrame->TimeLine_window->DrawCanvas, tlFrame->paintWinDraw, 
			     tlFrame->dpyDraw, tlFrame->xidDraw, NULL);
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/*
 * Menu handler for `GridMenu (20 pixel spacing)'.
 */
Menu_item TwentyPixelHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  TimeLineFramePtr tlFrame;
  TimeLine_window_objects * ip = (TimeLine_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

  tlFrame = TimeLineWindow[xv_get(ip->controls, PANEL_CLIENT_DATA)];
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    tlFrame->gridSpacing = 20;
    DrawCanvasRepaintHandler(tlFrame->TimeLine_window->DrawCanvas, tlFrame->paintWinDraw, 
			     tlFrame->dpyDraw, tlFrame->xidDraw, NULL);
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/*
 * Menu handler for `GridMenu (30 pixel spacing)'.
 */
Menu_item ThirtyPixelHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  TimeLineFramePtr tlFrame;
  TimeLine_window_objects * ip = (TimeLine_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

  tlFrame = TimeLineWindow[xv_get(ip->controls, PANEL_CLIENT_DATA)];
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    tlFrame->gridSpacing = 30;
    DrawCanvasRepaintHandler(tlFrame->TimeLine_window->DrawCanvas, tlFrame->paintWinDraw, 
			     tlFrame->dpyDraw, tlFrame->xidDraw, NULL);
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/*
 * Menu handler for `GridMenu (40 pixel spacing)'.
 */
Menu_item FortyPixelHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  TimeLineFramePtr tlFrame;
  TimeLine_window_objects * ip = (TimeLine_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

  tlFrame = TimeLineWindow[xv_get(ip->controls, PANEL_CLIENT_DATA)];
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    tlFrame->gridSpacing = 40;
    DrawCanvasRepaintHandler(tlFrame->TimeLine_window->DrawCanvas, tlFrame->paintWinDraw, 
			     tlFrame->dpyDraw, tlFrame->xidDraw, NULL);
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/*
 * Menu handler for `GridMenu (50 pixel spacing)'.
 */
Menu_item FiftyPixelHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  TimeLineFramePtr tlFrame;
  TimeLine_window_objects * ip = (TimeLine_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

  tlFrame = TimeLineWindow[xv_get(ip->controls, PANEL_CLIENT_DATA)];
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    tlFrame->gridSpacing = 50;
    DrawCanvasRepaintHandler(tlFrame->TimeLine_window->DrawCanvas, tlFrame->paintWinDraw, 
			     tlFrame->dpyDraw, tlFrame->xidDraw, NULL);
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/* 
 * This function will draw the grid lines on the canvas.
 * First, it will set the line width to 1 pixel wide and the foreground color of the grid lines to white (to differentiate from the playback head).
 * It will then perform a loop to draw the grid lines.
 * The line width is then set back to 2.
 */
void DrawGrid(tlFrame)
  TimeLineFramePtr tlFrame;
{
  int i;  

  if (tlFrame->gridSpacing > 0) 
  {
    SetLineAttributes(tlFrame, 1);
    XSetForeground(tlFrame->dpyDraw, tlFrame->gc, (long)tlFrame->pixelTable[White]);
    for (i=0; i < tlFrame->TimeLineLength; i += tlFrame->gridSpacing) /* Draw the grid lines */
      XDrawLine(tlFrame->dpyDraw, tlFrame->xidDraw, tlFrame->gc, i, 0,
		i, tlFrame->numberOfApps * 72 + FirstCableYPosition);
    SetLineAttributes(tlFrame, 2);
  }
}


