/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/drapeau/NetworkProtocol/RCS/MAEstro.x,v 1.16 92/05/29 12:40:31 drapeau Exp $ */
/* $Log:	MAEstro.x,v $
Revision 1.16  92/05/29  12:40:31  drapeau
Changed the name of the "Selection" structure to "MAESelection",
to avoid name conflicts with other software packages and toolkits
that might also define a "Selection" structure.

Revision 1.15  92/01/15  19:27:05  drapeau
Replaced program number "99" with program number "300115",
an officially assigned RPC protocol number from Sun
Microsystems (rpc@sun.com).

Revision 1.14  91/09/18  12:37:12  drapeau
Renamed the protocol to "MAEstro", in keeping with the project
name.
Also, changed the return value of the GetPortFromName()
message.  It now returns a list of matching Ports, rather than just
one Port.

Revision 1.13  91/09/03  16:58:35  drapeau
Modified definition of GetPortFromName() message so that it returns
a Port instead of a void.

Revision 1.12  91/06/19  14:11:37  drapeau
Added support for five new messages:
 - PauseSelection
 - ResumeSelection
 - HideApplication
 - ShowApplication
 - GetAppIcon
Also, replaced the "PerformPartialSelection" message with
"HaltSelection" message.

Also, modified the definition of the Selection structure, to accommodate
partial selections (the offset field is for this purpose) and to allow
applications to transmit brief descriptions of selections (the label field
is for this purpose).
In this new Selection structure, a partial selection is defined by a
non-zero value in the offset field.  For example, if a Selection is 3000
milliseconds long (duration = 3000) but the offset field is set to 2 seconds
(offset = 2000), the resulting Selection is a partial selection, and the
media editor is to attempt at "performing" only the last second of the
selection (i.e., the media editor should begin 2000 milliseconds into its
selection, instead of at the beginning of that selection).

Revision 1.11  91/02/28  07:18:46  drapeau
No protocol specification changes; this version uses a new version
numbering scheme and a new version of RCS.

Revision 1.1  90/10/24  18:29:36  drapeau
Initial revision
 */

/* Protocol for inter-application communication.  Originally written on 7/6/90
   by George Drapeau. */


const LabelLength = 256;

struct Port
{
  string	hostName<>;
  string	appName<>;
  int		portNumber;
};

struct PortArray
{
  Port	portArray<>;
  int	numberOfPorts;
};


struct MAESelection
{
  int		start;
  int		end;
  int		duration;					    /* Estimated time in msecs to perform selection */
  int		offset;						    /* Start performance this many msecs into selection above  */
  string	label<LabelLength>;				    /* Brief, descriptive text for this selection */
};

struct IconData
{
  opaque	iconData<>;
  int		dataLength;
};


program MAEstro
{
  version FirstTestVersion
    {
      void 		OpenDocument(string) = 1;
      string		GetCurrentDocName(void) = 2;
      MAESelection	GetSelection(void) = 3;
      void		SetSelection(MAESelection) = 4;
      void		PerformSelection(void) = 5;
      void		ConnectWithPortMgr(Port) = 6;
      PortArray		GetOpenApps(void) = 7;
      PortArray		GetPortFromName(Port) = 8;
      void		DisconnectFromPortMgr(Port) = 9;
      void		Ping(void) = 10;
      void		HaltSelection(void) = 11;
      void		PauseSelection(void) = 12;
      void		ResumeSelection(void) = 13;
      void		HideApplication(void) = 14;
      void		ShowApplication(void) = 15;
      IconData		GetAppIcon(void) = 16;
    }
  = 1;
}
= 300115;							    /* Official RPC number for this protocol given by rpc@sun.com */
