/*
 * OMa_stubs.c - Notify and event callback function stubs.
 * This file was generated by `gxv' from `OMa.G'.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <group.h>

/*
 * ToolTalk include files
 */
#include <desktop/tt_c.h>
#include <desktop/ce.h>

#include "OMa_ui.h"

/*
 * constants
 */
#define MSG_LEN 80
#define TT_KEY "MaMA_TT"

#define OPEN_MSG "open_editlist"
#define PLAY_MSG "play_edit"
#define PAUSE_MSG "pause_edit"
#define STOP_MSG "stop_edit"
#define SELECT_NR_MSG "select_edit_nr"
#define SELECT_LBL_MSG "select_edit_label"
#define REPEAT_ON_MSG "repeat_on"
#define REPEAT_OFF_MSG "repeat_off"

/*
 * ToolTalk globals
 */
void    ToolTalk_init();
void    Activator(int, int, int);
void    Play_Msg(Panel_item, int, Event *);
void    Pause_Msg(Panel_item, int, Event *);
void    Stop_Msg(Panel_item, int, Event *);
void    Select_Nr_Msg(Panel_item, int, Event *);
void    Select_Label_Msg(Panel_item, int, Event *);
void	Quit_proc(Panel_item, Event *);
void	Open_Msg(Panel_item, int, Event *);
void    CheckCmdOptions(int argc, char **argv);
void	Repeat_Off_Msg(Panel_item, int, Event *);
void	Repeat_On_Msg(Panel_item, int, Event *);

char    *my_pid;
char    *other_session;
int     ttfd;
Tt_pattern pat;

unsigned char Message[MSG_LEN];
unsigned char EditLabel[MSG_LEN];
unsigned char Filename[MSG_LEN];
unsigned char EditNumber[3];

char MachineName[256];

int i_EditNumber;

/*
 * Global object definitions.
 */
OMa_Main_Window_objects    *OMa_Main_Window;
void PrintUsage();

/*
 * Global object definitions.
 */
OMa_Main_Window_objects	*OMa_Main_Window;

#ifdef MAIN

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */
Attr_attribute    INSTANCE;

main(int argc, char **argv)
{
    if (argc == 1) PrintUsage();

    if (0 == strcmp(argv[1], "-m"))
    {
        /*
         * use machine given on command line as session
         */
        sprintf(MachineName, "%s:0", argv[2]);
 
        other_session = tt_X_session(MachineName);
        tt_default_session_set(other_session);
    }

    /*
     * Check command line options
     */
    CheckCmdOptions(argc, argv);

    /*
     * Initialize XView.
     */
    xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);
    INSTANCE = xv_unique_key();
    
    /*
     * Initialize user interface components.
     * Do NOT edit the object initializations by hand.
     */
    OMa_Main_Window = OMa_Main_Window_objects_initialize(NULL, NULL);
    
    ToolTalk_init();
    
    /*
     * Turn control over to XView.
     */
    OMa_Main_Window = OMa_Main_Window_objects_initialize(NULL, NULL);
    xv_main_loop(OMa_Main_Window->Main_Window);

    tt_close();

    exit(0);
}

void
PrintUsage()
{
    fprintf(stderr, "\n\tOMa v1.0 -- Usage\n\t-----------------\n\n");
    fprintf(stderr, "\tOMa [-m <machine name>] [-<message>]\n\n");
    fprintf(stderr, "\t-m <machine name>\tSend message to this machine\n");
    fprintf(stderr, "\t-open <editlistfile>\n");
    fprintf(stderr, "\t-play\n");
    fprintf(stderr, "\t-pause\n");
    fprintf(stderr, "\t-stop\n");
    fprintf(stderr, "\t-select_nr <#>\n");
    fprintf(stderr, "\t-select_label <editlabel>\n");
    fprintf(stderr, "\t-repeat_on\n");
    fprintf(stderr, "\t-repeat_off\n");
    fprintf(stderr, "\n");

    exit(0);
}

void
CheckCmdOptions(int argc, char **argv)
{
    int i;

    if ((0 == strcmp(argv[1], "-m")) && (argc == 3)) return; 
    if (argc == 1) return;

    for (i = 1; i < argc; i++)
    {
        unsigned char *Argument;
        Bool CorrectArg;
        char *arg = argv[i];

        Argument = (unsigned char *)0;
        CorrectArg = False;

        ToolTalk_init();

        /*
         * check for valid options
         */
        if (0 == strcmp(arg, "-v"))
        {
            PrintUsage();
        } else
 
        if (0 == strcmp(arg, "-open"))
        {
            sprintf((char *)Message, OPEN_MSG);

            Argument = (unsigned char *)argv[++i];
            CorrectArg = True;
        } else

        if (0 == strcmp(arg, "-play"))
        {
            sprintf((char *)Message, PLAY_MSG);

            CorrectArg = True;
        } else

        if (0 == strcmp(arg, "-pause"))
        {
            sprintf((char *)Message, PAUSE_MSG);

            CorrectArg = True;
        } else

        if (0 == strcmp(arg, "-stop"))
        {
            sprintf((char *)Message, STOP_MSG);

            CorrectArg = True;
        } else

        if (0 == strcmp(arg, "-select_nr"))
        {
            sprintf((char *)Message, SELECT_NR_MSG);
            arg = argv[++i];

            Argument = (unsigned char *)arg;
            CorrectArg = True;
        } else

        if (0 == strcmp(arg, "-select_label"))
        {
            sprintf((char *)Message, SELECT_LBL_MSG);
            arg = argv[++i];

            Argument = (unsigned char *)arg;

            CorrectArg = True;
        } else

        if (0 == strcmp(arg, "-repeat_on"))
        {
            sprintf((char *)Message, REPEAT_ON_MSG);

            CorrectArg = True;
        } else

        if (0 == strcmp(arg, "-repeat_off"))
        {
            sprintf((char *)Message, REPEAT_OFF_MSG);
            CorrectArg = True;
        } else {

            CorrectArg = False;
        }

        if (CorrectArg)
        {
            Tt_message msg_out;
 
            /*
             * Create and send a ToolTalk notice message
             */
            msg_out = tt_pnotice_create(TT_SESSION, TT_KEY);
            tt_message_arg_add(msg_out, TT_IN, "string", NULL);
            tt_message_arg_add(msg_out, TT_IN, "string", NULL);

            tt_message_arg_bval_set(msg_out, 0, Message, 
                strlen((char *)Message));

            if (Argument != (unsigned char *)0)
            {
                tt_message_arg_bval_set(msg_out, 1, Argument, 
                    strlen((char *)Argument));
            }

            tt_message_send(msg_out);

            /*            
             * Since this message is a notice, we don't expect a reply, so
             * there's no reason to keep a handle for the message.
             */
            tt_message_destroy(msg_out);
        } else {
		fprintf(stderr, "Error: Wrong option or args!\n");
            	PrintUsage();
	}
    
    }

    tt_close();

    exit(0);
}

#endif

/*
 * User-defined action for `Msg_Setting'.
 */
void
Open_Msg(Panel_item item, int	 value, Event *event)
{
    Activator(FALSE, TRUE, TRUE);
    sprintf((char *)Message, OPEN_MSG);
}

/*
 * User-defined action for `Msg_Setting'.
 */
void
Play_Msg(Panel_item item, int     value, Event *event)
{
    Activator(TRUE, TRUE, TRUE);
    sprintf((char *)Message, PLAY_MSG);
}

/*
 * User-defined action for `Msg_Setting'.
 */
void
Pause_Msg(Panel_item item, int     value, Event *event)
{
    Activator(TRUE, TRUE, TRUE);
    sprintf((char *)Message, PAUSE_MSG);
}

/*
 * User-defined action for `Msg_Setting'.
 */
void
Stop_Msg(Panel_item item, int     value, Event *event)
{
    Activator(TRUE, TRUE, TRUE);
    sprintf((char *)Message, STOP_MSG);
}

/*
 * User-defined action for `Msg_Setting'.
 */
void
Select_Nr_Msg(Panel_item item, int     value, Event *event)
{
    Activator(TRUE, FALSE, TRUE);
    sprintf((char *)Message, SELECT_NR_MSG);
}

/*
 * User-defined action for `Msg_Setting'.
 */
void
Select_Label_Msg(Panel_item item, int     value, Event *event)
{
    Activator(TRUE, TRUE, FALSE);
    sprintf((char *)Message, SELECT_LBL_MSG);
}

/*
 * User-defined action for `Msg_Setting'.
 */
void
Repeat_Off_Msg(Panel_item item, int	 value, Event *event)
{
    Activator(TRUE, TRUE, TRUE);
    sprintf((char *)Message, REPEAT_OFF_MSG);
}

/*
 * User-defined action for `Msg_Setting'.
 */
void
Repeat_On_Msg(Panel_item item, int	 value, Event *event)
{
    Activator(TRUE, TRUE, TRUE);
    sprintf((char *)Message, REPEAT_ON_MSG);
}

void
Activator(int File_TORF, int Num_TORF, int Lbl_TORF)
{
    xv_set(OMa_Main_Window->File_tf, PANEL_INACTIVE, File_TORF, NULL);
    xv_set(OMa_Main_Window->Number_tf, PANEL_INACTIVE, Num_TORF, NULL);
    xv_set(OMa_Main_Window->Label_tf, PANEL_INACTIVE, Lbl_TORF, NULL);
}

/*
 * Notify callback function for `Send_Button'.
 */
void
Send_proc(Panel_item item, Event *event)
{
    Tt_message msg_out;

    /*
     * Create and send a ToolTalk notice message
     */
    msg_out = tt_pnotice_create(TT_SESSION, TT_KEY);
    tt_message_arg_add(msg_out, TT_IN, "string", NULL);
    tt_message_arg_add(msg_out, TT_IN, "string", NULL);
    tt_message_arg_bval_set(msg_out, 0, Message, strlen((char *)Message));

    /* 
     * add argument
     */
    if (0 == strcmp(OPEN_MSG, (char *)Message))
    {
        strcpy((char *)Filename,(char *) 
                       xv_get(OMa_Main_Window->File_tf, PANEL_VALUE, NULL));
        tt_message_arg_bval_set(msg_out, 1, Filename, strlen((char *)Filename));
    }

    if (0 == strcmp(SELECT_NR_MSG, (char *)Message))
    {
        i_EditNumber = (int) xv_get(OMa_Main_Window->Number_tf, 
                                                            PANEL_VALUE, NULL);
        sprintf((char *)EditNumber, "%d", i_EditNumber);
        tt_message_arg_bval_set(msg_out, 1, EditNumber, strlen(EditNumber));
    }

    if (0 == strcmp(SELECT_LBL_MSG, (char *)Message))
    {
        strcpy((char *)EditLabel, (char *)
                       xv_get(OMa_Main_Window->Label_tf, PANEL_VALUE, NULL));
        tt_message_arg_bval_set(msg_out, 1, EditLabel, strlen(EditLabel));
    }

    tt_message_send(msg_out);

    /*            
     * Since this message is a notice, we don't expect a reply, so
     * there's no reason to keep a handle for the message.
     */
    tt_message_destroy(msg_out);
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

void
ToolTalk_init()
{
    /*
     * init value of Message
     */
    strcpy((char *)Message, "open_editlist");

    /*
     * Initialize ToolTalk
     */
    my_pid = tt_open();
    ttfd = tt_fd();
 
    pat = tt_pattern_create();
    tt_pattern_category_set(pat, TT_OBSERVE);
    tt_pattern_scope_add(pat, TT_SESSION);
    tt_pattern_op_add(pat, TT_KEY);
    tt_pattern_register(pat);

    tt_session_join(tt_default_session());
}

/*
 * User-defined action for `Quit_Button'.
 */
void
Quit_proc(Panel_item item, Event *event)
{
    tt_close();
    
    exit(0);
}

/*
 * Notify callback function for `Msg_Setting'.
 */
void
OMa_Main_Window_Msg_Setting_notify_callback(
    Panel_item item, int value, Event *event)
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */
	/* gxv_end_connections */
}

/*
 * Notify callback function for `Msg_Setting'.
 */
void
Repeat_Msg(Panel_item item, int	 value, Event *event)
{
	OMa_Main_Window_objects *ip = (OMa_Main_Window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 1)
	{
		Play_Msg(item, value, event);
	}
	
	if (value == 2)
	{
		Pause_Msg(item, value, event);
	}
	
	if (value == 3)
	{
		Stop_Msg(item, value, event);
	}
	
	if (value == 4)
	{
		Select_Nr_Msg(item, value, event);
	}
	
	if (value == 5)
	{
		Select_Label_Msg(item, value, event);
	}
	
	if (value == 0)
	{
		Open_Msg(item, value, event);
	}
	
	if (value == 6)
	{
		Repeat_Off_Msg(item, value, event);
	}
	
	if (value == 7)
	{
		Repeat_On_Msg(item, value, event);
	}
	
	/* gxv_end_connections */

}
