/******************************************************************************\
*                                                                              *
*        File : MaMA_main_global.h                                             *
*                                                                              *
* Description : Contains all possible global definitions for MaMA              *
*                                                                              *
\******************************************************************************/
#define NullString ((caddr_t) NULL)
#define TIME_COEFF 1			/* coefficient to adjust to real time */

#define FRAME_MAGIC "framemaker-document"
#define MaMA_EDIT_MAGIC "MaMA_Edit_File"
#define MSG_LEN 80

void    MaMA_init();
void    link_menu_proc(Panel_item, Event *);
void    jump_proc(Panel_item, int, Event *);
void    goto_fp_proc(Panel_item, int, Event *);
void    goto_np_proc(Panel_item, int, Event *);
void    goto_pp_proc(Panel_item, int, Event *);
void    goto_lp_proc(Panel_item, int, Event *);
void    zoom_page_proc(Panel_item, int, Event *);
void    open_doc_proc(Panel_item, int, Event *);
void    close_doc_proc(Panel_item, int, Event *);
void    quit_doc_proc(Panel_item, int, Event *);
void    view_target_doc_proc(Panel_item, Event *);
int     load_proc(gfm_popup_objects *, char *, char *);
int     select_proc(gfm_popup_objects *, char *, char *);
int     saveas_proc(gfm_popup_objects *, char *, char *);
int     edit_list_proc(Panel_item, char *, Xv_opaque, Panel_list_op,
               Event *, int);

/*
 * FileList global definitions
 */
void     PrintFileList(FILELIST *);
FILELIST *DeleteSelectedFile(FILELIST *);
void     UnselectFile(FILELIST *FileListPtr);
void     SelectFile(FILELIST *, int);
FILELIST *InsertFile(FILELIST *, char *, char *);
FILELIST *BuildFileList(ACTIONLIST *);
void     DisplayFileInfo(FILELIST *, int, int);
int      FileInList(FILELIST *, char *, char *);
FILELIST *FindSelectedDoc(FILELIST *);
void     doc_drop_proc(Xv_opaque, Event *, GDD_DROP_INFO *);
void	 doc_drag_proc(Xv_opaque, Event *, GDD_DROP_INFO *, int);
void     FreeFileList(FILELIST *);
void     FreeLinkList(LINKLIST *);
 
/*
 * ActionList global definitions
 */
void       PrintActionList(ACTIONLIST *);
ACTIONLIST *DeleteSelectedAction(ACTIONLIST *);
void       UnselectAction(ACTIONLIST *ActionListPtr);
void       SelectAction(ACTIONLIST *, int);
ACTIONLIST *InsertAction(ACTIONLIST *, char *, char *);
EDITLIST   *MoveEditDown(EDITLIST *);
EDITLIST   *MoveEditUp(EDITLIST *);
EDITLIST   *SwitchEdit(EDITLIST *);
ACTIONLIST *MoveDown(ACTIONLIST *);
ACTIONLIST *MoveUp(ACTIONLIST *);
ACTIONLIST *SwitchAction(ACTIONLIST *);
ACTIONLIST *GetNewAction(ACTIONLIST *);
ACTIONLIST *GetSelectedAction(ACTIONLIST *);
ACTIONLIST *CopyActionList(ACTIONLIST *);
void       FillAction();
char       *BuildActionString();
void       DeleteActionList(ACTIONLIST *);
void       FreeAction(ACTIONLIST *);

 
/*
 * EditList global definitions
 */
void     PrintEditList(EDITLIST *);
EDITLIST *DeleteSelectedEdit(EDITLIST *);
void     UnselectEdit(EDITLIST *EditListPtr);
void     SelectEdit(EDITLIST *, int);
EDITLIST *InsertEdit(EDITLIST *);
EDITLIST *GetSelectedEdit(EDITLIST *);
void     DisplayEditInfo(EDITLIST *, int, int);
void     FillEdit();
char     *BuildEditString();
int      CheckLabelName();
void     FreeEditList(EDITLIST *);
void     FreeEdit(EDITLIST *);
void     SelectEditByLabel(unsigned char *);
void	 LoadEditList(char *); 
void	 edit_list_drag_proc(Xv_opaque, Event *, GDD_DROP_INFO *, int);
void	 edit_list_drop_proc(Xv_opaque, Event *, GDD_DROP_INFO *);

extern FILELIST *CurDoc;
 
#ifndef SaM
    /*
     * Communication global definitions
     */
    Sender   *NewSender(Port *);
    void     BuildDispatchTable(DispatchTable *);
    
    void       MaMA_OpenDocument(char **);
    char     **MaMA_GetCurDoc();
    MAESelection *MaMA_GetSelection();
    void       MaMA_SetSelection(MAESelection *);
    void       MaMA_PerformSelection();
    void       MaMA_HaltSelection();
    void       MaMA_PauseSelection();
    void       MaMA_ResumeSelection();
    void       MaMA_HideApplication();
    void       MaMA_ShowApplication();
    IconData  *MaMA_GetAppIcon();
 
#endif

/* 
 * AutoMnt globals 
 */ 
void        PrintAutoMntList(AUTOMNTLIST *);
AUTOMNTLIST *DeleteSelectedAutoMnt(AUTOMNTLIST *);
void        UnselectAutoMnt(AUTOMNTLIST *);
void        SelectAutoMnt(AUTOMNTLIST *, int);
AUTOMNTLIST *AddAutoMnt(AUTOMNTLIST *);
AUTOMNTLIST *GetSelectedAutoMnt(AUTOMNTLIST *);
char        resourcefile[FILELEN];      /* our init file                      */

/*
 * Frame Server Functions global def's
 */
int      OpenFMDoc(char *);
void     doFmCommands(unsigned int doc, int *codes, unsigned int  num);
 
/*
 * Miscelaneous global definitions
 */
void done_proc();
void InitPopup();
void BuildLinkList();
void CheckOptions(int, char **);
int  CheckFileType(char *, char *);
void EditButtonsActive();
void ActionButtonsActive();
void DocButtonsActive();
void MoveButtonsActive();
void MoveEditButtonsActive();
void AddLinks2File(FILELIST *, char **);
void PutLinksInChoice(LINKLIST *);
void SetHeader(char *);
char *RetrieveFilename(char *);
char *RemoveAutoMntDir(char *);
void RetrieveAutoMntDirs();
void PositionPopup();
void SetMenu();
void ResetMenu();
void Print(char *);

Notify_value DestroyBaseWindow(Notify_client, Destroy_status);
char Debug_Msg[DBG_MSG_LEN];

Bool ChangeEditMode;
/*
 * load / save globals
 */
EDITLIST     *ReadEditFromFile(FILE *);
ACTIONLIST   *ReadActionListFromFile(FILE *, int *);
void         WrongFormatMsg();
int          Check4WrongFormat(FILE *, char *, char *, int);
int          WriteEditList2File(EDITLIST *);
void         WriteEdit2File(FILE *, EDITLIST *);
void         WriteActionList2File(FILE *, ACTIONLIST *);
EDITLISTINFO *ReadEditListFromFile(char *);
char *       WriteEditList2Buf(EDITLIST *);
void         WriteEdit2Buf(EDITLIST *);
void         WriteActionList2Buf(ACTIONLIST *);

/*
 * ToolTalk globals
 */
void receive_tt_message();
void ToolTalk_init();

char *my_pid;
char *other_session;
int  ttfd;
Tt_pattern pat;

/*
 * Xresource globals
 */
void Xrc_init(int *, char **);
void Apply_Pref();
void Reset_Pref();
void Add_Resource_Data();

char FramePath[PATHLEN + FILELEN];
int  FMDemoVersion;
int  OpenFM4EachAction;
