/******************************************************************************\
*                                                                              *
* The software for `MaMA' was developed by:    H. K. Blokhuis and              *
*                                              S. L. Voogd                     *
*                                                                              *
* as part of their graduation for:     the Hoger Informatica Onderwijs (HIO)   *
* in Enschede.                             ---------------------------------   *
* The project was carried out at:          Sun Microsystems Nederland B.V.     *
* in Amersfoort.                           -------------------------------     *
*                                                                              *
*                                                                              *
* Copyright (c) 1992 Sun Microsystems Nederland B.V.                           *
*                                                                              *
* Permission to use, copy, modify, and distribute this software and            *
* its documentation for any purpose is hereby granted without fee, provided    *
* that (i) the above copyright notices and this permission notice appear in    *
* all copies of the software and related documentation, and (ii) the name      *
* Sun may not be used in any advertising or publicity relating to              *
* the software without the specific, prior written permission of               *
* Sun.                                                                         *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,           *
* EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY             *
* WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.             *
*                                                                              *
* IN NO EVENT SHALL SUN BE LIABLE FOR ANY SPECIAL, INCIDENTAL,                 *
* INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES                *
* WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT       *
* ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,        *
* ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS          *
* SOFTWARE.                                                                    *
*                                                                              *
\******************************************************************************/

/*----------------------------------------------------------------------------*\
|                                                                              |
|        File : MaMA_misc.c                                                    |
|                                                                              |
|    Contents : functions for miscelaneous purposes                            |
|                                                                              *
\*----------------------------------------------------------------------------*/

#include <MaMA_include.h>
#include <MaMA_global.h>
#include <desktop/ce.h>
#include <desktop/ce_err.h>

void EditButtonsActivate(int);
void ActionButtonActivate(int);
void DocButtonsActivate(int);

extern int NumberOfActions;
extern int NumberOfEdits;
extern int NumberOfDoc;

extern char  *AutoMntDirs[];

int NumberOfLinks;

#ifndef SaM
    extern Port  senderPort;
    extern int   ReceiverPortNumber;
#endif

char         startFilename[MAXPATHLEN];

CE_NAMESPACE f_name_space;
CE_ENTRY     ftype_ent;
CE_ATTRIBUTE fns_type, fns_attr;
int          argcount;


/******************************************************************************\
*                                                                              *
*        Name : Print                                                          *
*                                                                              *
* Description : Print messages                                                 *
*                                                                              *
\******************************************************************************/

void
Print(char *Message)
{
    if (DebugMode)
    {
        (void )fprintf(stderr,"%s", Message);
    }
}

/******************************************************************************\
*                                                                              *
*        Name : PrintLinkList                                                  *
*                                                                              *
* Description : Print the names of hyperlinks of the given LinkList            *
*                                                                              *
\******************************************************************************/

void
PrintLinkList(LINKLIST * LinkListPtr)
{
    Print("- L - I - N - K - L - I - S - T -\n");
    while (LinkListPtr != NIL(LINKLIST *))
    {
        sprintf(Debug_Msg, "Linkname = '%s'\n", LinkListPtr->Linkname);
        Print(Debug_Msg);
        LinkListPtr = LinkListPtr->next;
    }
    Print("- - - - - - - - - - - - - - - - -\n");
}

/******************************************************************************\
*                                                                              *
*        Name : InitPopup                                                      *
*                                                                              *
* Description : Initialise the Popup Window                                    *
*                                                                              *
\******************************************************************************/

void
InitPopup()
{
    xv_set(MaMA_Edit_Panel->Edit_Label_tf, PANEL_VALUE, "", NULL);
    xv_set(MaMA_Edit_Panel->Minutes_tf, PANEL_VALUE, 0, NULL);
    xv_set(MaMA_Edit_Panel->Repeat_tf, PANEL_VALUE, 1, NULL);
    xv_set(MaMA_Edit_Panel->Seconds_tf, PANEL_VALUE, 5, NULL);
    xv_set(MaMA_Edit_Panel->Link_Name_tf, PANEL_VALUE, "", NULL);
    xv_set(MaMA_Edit_Panel->Action_Settings, PANEL_VALUE, 0, NULL);
    xv_set(MaMA_Edit_Panel->Link_Layer, XV_SHOW, TRUE, NULL);
    xv_set(MaMA_Edit_Panel->Fit_Settings, PANEL_VALUE, 0, NULL);
    xv_set(MaMA_Edit_Panel->Action_List, PANEL_LIST_DELETE_ROWS, 0,
    NumberOfActions, NULL);
}

/******************************************************************************\
*                                                                              *
*        Name : BuildLinkList                                                  *
*                                                                              *
* Description : Build the HyperLink List *(* WORK AROUND *)*                   *
*                                                                              *
\******************************************************************************/

void
BuildLinkList()
{
    char buf[HYPERLEN];
    char HyperLinkname[HYPERLEN];
    LINKLIST *LinkListPtr;
    LINKLIST *LinkList;
    FILE *File;
    int GO_ON;
    int len;
    int j;
    char *ptr;

    /*
     * init
     */
    NumberOfLinks = 0;
    CurDoc->File->LinkList = NIL(LINKLIST *);
    LinkList = NIL(LINKLIST *);

    /*
     * save link names in temp file
     */
    system("fgrep newlink /tmp/.markers > /tmp/.links");

    /*
     * open file with hyperlink names
     */
    if ((File = fopen("/tmp/.links","r")) == NULL)
    {
        fprintf(stderr, dgettext("MaMA_labels", "COULD NOT OPEN FILE\n"));
        return;
    }

    while ((fscanf(File, "    <MText `%s", buf) == 1) &&
        (strcmp(buf, "newlink") == 0))
    {
        strcpy(HyperLinkname, "\0");
        GO_ON = True;

        while(GO_ON)
        {
            fscanf(File, "%s", buf);
 
            len = strlen(buf);
 
            /*
             * go to end of string until ptr points to last two chars
             */
            for (ptr = buf, j = 0 ; j < len - 1 ; ptr++, j++);
               
            /*                                                 
             * compare ptr with "'>" (i.e. : the end of a hyperlink declaration)             * append string to hyperlink name
             */
            if ( strcmp(--ptr, "'>") == 0)
            {  
                strncat(HyperLinkname, buf, len - 2);
                GO_ON = False;
            } else {
                strcat(HyperLinkname, buf);
                strcat(HyperLinkname, " ");
            }
        }

        if (LinkList == NIL(LINKLIST *)) 
        {
            LinkListPtr = (LINKLIST *)malloc((unsigned)sizeof(LINKLIST));
            LinkListPtr->next = NIL(LINKLIST *);

            strcpy(LinkListPtr->Linkname, HyperLinkname);

            LinkList = LinkListPtr;
        } else {
            LinkListPtr->next = (LINKLIST *)malloc((unsigned)sizeof(LINKLIST));
            LinkListPtr->next->next = NIL(LINKLIST *);

            LinkListPtr = LinkListPtr->next;

            strcpy(LinkListPtr->Linkname, HyperLinkname);
        }

        NumberOfLinks++;

        PrintLinkList(LinkList);
    }
    fclose(File);

    CurDoc->File->LinkList = LinkList;

    if (NumberOfLinks == 0)
    {
        notice_prompt (MaMA_Edit_Panel->Edit_Panel, NULL,
            NOTICE_MESSAGE_STRINGS,
            dgettext("MaMA_labels", "No Hyperlinks in this Document!"),
            NULL,
            NOTICE_BUTTON, "OK", 100,
            NULL);

        CurDoc->File->LinkList = NIL(LINKLIST *);
        return;
    }

    PutLinksInChoice(CurDoc->File->LinkList);
}

/******************************************************************************\
*                                                                              *
*        Name : CheckOptions                                                   *
*                                                                              *
* Description : Scan the command line options                                  *
*                                                                              *
\******************************************************************************/

void
CheckOptions(int argc, char **argv)
{
    int optionChar;
    int option_index = 0;
    static struct option long_options[] =
    {
        {"hostname", 1, 0, 'h'},

        {"portnumber", 1, 0, 'p'},
        {0, 0, 0, 0}
    };

    /*
     * Start parsing all known options
     */
    while (1)
    {
        optionChar = getopt_long_only (argc, argv, "h:p:",
            long_options, &option_index);

        /*
         * Done with all options ?
         */
        if (optionChar == EOF)
        {
            break;
        }
        switch (optionChar)
        {
#ifndef SaM
            case 'h':
                if (optarg)
                {
                    strcpy (senderPort.hostName, optarg);
                }
                break;

            case 'p':
                if (optarg)
                {
                    ReceiverPortNumber = atoi(optarg);
                }
                break;
#endif

            default:
                break;
        }
    }  

    /*
     * Check if a filename has been specified
     */
    if (optind < argc)
    {
        strcpy (startFilename, argv[optind]);
    }
}

/******************************************************************************\
*                                                                              *
*        Name : CheckFileType                                                  *
*                                                                              *
* Description : Checks if the file is of the given type                        *
*                                                                              *
\******************************************************************************/

int
CheckFileType(char *Filename, char *FileType)
{
    int  fd;
    char buf[256];
    char ErrorMsg[256];
    int  bufsize, status;

    /*
     * Initialize the Classing Engine
     */
    status = ce_begin (NULL);
    if (status)    
    {
        ce_end();
        notice_prompt(MaMA_Main_Window->Main_Window, NULL,
            NOTICE_MESSAGE_STRINGS,
            dgettext("MaMA_labels", "Fatal:"),
            dgettext("MaMA_labels", 
                "Cannot use Classing Engine to check for file type"),
            dgettext("MaMA_labels", "Contact your system administrator."),
            NULL,
            NOTICE_BUTTON, "OK", 100,
            NULL);
        return(0);
    }
    
    /* 
     * Read in Namespace Entries
     */
    f_name_space = ce_get_namespace_id ("Files");
    if (!f_name_space)    
    {
        ce_end();
        notice_prompt(MaMA_Main_Window->Main_Window, NULL,
            NOTICE_MESSAGE_STRINGS,
            dgettext("MaMA_labels", "Fatal:"),
            dgettext("MaMA_labels", 
                "Cannot use name-space database of Classing Engine."),
            dgettext("MaMA_labels", "Contact your system administrator."),
            NULL,
            NOTICE_BUTTON, "OK", 100,
            NULL);
        return(0);
    }
    
    fns_attr = ce_get_attribute_id (f_name_space, "FNS_TYPE");
    
    if (!fns_attr)    
    {
        ce_end();
        notice_prompt(MaMA_Main_Window->Main_Window, NULL,
            NOTICE_MESSAGE_STRINGS,
            dgettext("MaMA_labels", "Fatal:"),
            dgettext("MaMA_labels", 
                "Cannot use name-space database of Classing Engine."),
            dgettext("MaMA_labels", "Contact your system administrator."),
            NULL,
            NOTICE_BUTTON, "OK", 100,
            NULL);
        return(0);
    }

    /*  
     * check the filename and type it
     */

    if ((fd = open (Filename, 0)) == -1) 
    {
        ce_end();
        sprintf(ErrorMsg, "Cannot open:\n%s\n", Filename);

        notice_prompt(MaMA_Main_Window->Main_Window, NULL,
            NOTICE_MESSAGE_STRINGS,
            ErrorMsg,
            NULL,
            NOTICE_BUTTON, "OK", 100,
            NULL);
        return(0);
    }

    bufsize = read (fd, buf, sizeof (buf));
    if (bufsize <= 0) 
    {
        close (fd);
        ce_end();

        notice_prompt(MaMA_Main_Window->Main_Window, NULL,
            NOTICE_MESSAGE_STRINGS,
            dgettext("MaMA_labels", "Empty file or directory"),
            NULL,
            NOTICE_BUTTON, "OK", 100,
            NULL);
        return(0);
    }

    /* Get a matching entry in the files namespace */
    argcount = 3;
    ftype_ent =  ce_get_entry (f_name_space, argcount, Filename, buf, bufsize);
    if (!ftype_ent)    
    {
        ce_end();
        sprintf(ErrorMsg, "%s\n%s %s.\n", Filename, 
            dgettext("MaMA_labels", "is not a"), FileType);

        notice_prompt(MaMA_Main_Window->Main_Window, NULL,
            NOTICE_MESSAGE_STRINGS,
            ErrorMsg,
            NULL,
            NOTICE_BUTTON, "OK", 100,
            NULL);
        return(0);
    }
 
    fns_type = ce_get_attribute (f_name_space, ftype_ent, fns_attr);
 
    if (!fns_type)    
    {
        ce_end();
        sprintf(ErrorMsg, "%s\n%s %s.\n", Filename, 
            dgettext("MaMA_labels", "is not a"), FileType);

        notice_prompt(MaMA_Main_Window->Main_Window, NULL,
            NOTICE_MESSAGE_STRINGS,
            ErrorMsg,
            NULL,
            NOTICE_BUTTON, "OK", 100,
            NULL);
        return(0);
    }

    if (0 == strcmp((char *)fns_type, FileType))
    {
        ce_end();
        return(1);
    }
    
    ce_end();
    sprintf(ErrorMsg, "%s\n%s %s.\n", Filename, 
        dgettext("MaMA_labels", "is not a"), FileType);

    notice_prompt(MaMA_Main_Window->Main_Window, NULL,
        NOTICE_MESSAGE_STRINGS,
        ErrorMsg,
        NULL,
        NOTICE_BUTTON, "OK", 100,
        NULL);
    return(0);
}

/******************************************************************************\
*                                                                              *
*        Name : EditButtonsActive                                              *
*               EditButtonsActivate                                            *
*                                                                              *
* Description : Activates or De-activates edit buttons                         *
*                                                                              *
\******************************************************************************/

void
EditButtonsActive()
{
    if (NumberOfEdits == 0)
    {
        EditButtonsActivate(TRUE);
    } else {
        EditButtonsActivate(FALSE);
    }

    MoveEditButtonsActive();
}

void
EditButtonsActivate(int TORF)
{
    xv_set(MaMA_Main_Window->Change_Edit_Button, PANEL_INACTIVE,TORF,NULL);
    xv_set(MaMA_Main_Window->Delete_Edit_Button, PANEL_INACTIVE,TORF,NULL);
    xv_set(MaMA_Main_Window->Stop_Button, PANEL_INACTIVE, TORF, NULL);
    xv_set(MaMA_Main_Window->Play_Button, PANEL_INACTIVE, TORF, NULL);
    xv_set(MaMA_Main_Window->Pause_Button, PANEL_INACTIVE, TORF, NULL);
    xv_set(MaMA_Main_Window->Time_Gauge1, PANEL_INACTIVE, TORF, NULL);
    xv_set(MaMA_Main_Window->Action_Time_Gauge, PANEL_INACTIVE, TORF, NULL);
    xv_set(MaMA_Main_Window->Time_message1, PANEL_INACTIVE, TORF, NULL);
    xv_set(MaMA_Main_Window->Start_message1, PANEL_INACTIVE, TORF, NULL);
    xv_set(MaMA_Main_Window->End_message1, PANEL_INACTIVE, TORF, NULL);
    xv_set(MaMA_Edit_Panel->Change_Edit_Button_In_Pop, PANEL_INACTIVE, TORF, 
        NULL);

#ifdef SaM
    xv_set(MaMA_Main_Window->Repeat_Setting, PANEL_INACTIVE, TORF, NULL);
#endif
}

/******************************************************************************\
*                                                                              *
*        Name : ActionButtonsActive                                            *
*               ActionButtonsActivate                                          *
*                                                                              *
* Description : Activates or De-activates action buttons                       *
*                                                                              *
\******************************************************************************/

void
ActionButtonsActive()
{
    if (NumberOfActions == 0)
    {
        ActionButtonActivate(TRUE);
    } else {
        ActionButtonActivate(FALSE);
    }

    MoveButtonsActive();
}

void
ActionButtonActivate(int TORF)
{
    xv_set(MaMA_Edit_Panel->Change_Action_Button, PANEL_INACTIVE, TORF, NULL);
    xv_set(MaMA_Edit_Panel->Del_Action_Button, PANEL_INACTIVE, TORF, NULL);
    xv_set(MaMA_Edit_Panel->Stop_Button2, PANEL_INACTIVE, TORF, NULL);
    xv_set(MaMA_Edit_Panel->Play_Button2, PANEL_INACTIVE, TORF, NULL);
    xv_set(MaMA_Edit_Panel->Pause_Button2, PANEL_INACTIVE, TORF, NULL);
    xv_set(MaMA_Edit_Panel->Time_Gauge2, PANEL_INACTIVE, TORF, NULL);
    xv_set(MaMA_Edit_Panel->Time_message2, PANEL_INACTIVE, TORF, NULL);
    xv_set(MaMA_Edit_Panel->Start_message2, PANEL_INACTIVE, TORF, NULL);
    xv_set(MaMA_Edit_Panel->End_message2, PANEL_INACTIVE, TORF, NULL);
}

/******************************************************************************\
*                                                                              *
*        Name : DocButtonsActive                                               *
*               DocButtonsActivate                                             *
*                                                                              *
* Description : Activates or De-activates doc buttons                          *
*                                                                              *
\******************************************************************************/

void
DocButtonsActive()
{
    if (NumberOfDoc == 0)
    {
        DocButtonsActivate(TRUE);
    } else {
        DocButtonsActivate(FALSE);
    }
}

void
DocButtonsActivate(int TORF)
{
    xv_set(MaMA_Edit_Panel->View_Doc_Button, PANEL_INACTIVE, TORF, NULL);
    xv_set(MaMA_Edit_Panel->Delete_Doc_Button, PANEL_INACTIVE, TORF, NULL);
    xv_set(MaMA_Edit_Panel->Update_Button, PANEL_INACTIVE, TORF, NULL);
}

/******************************************************************************\
*                                                                              *
*        Name : MoveButtonsActive                                              *
*                                                                              *
* Description : Activates or De-activates move buttons                         *
*                                                                              *
\******************************************************************************/

void
MoveButtonsActive()
{
    int row;

    if ((NumberOfActions == 0) || (NumberOfActions == 1))
    {
        xv_set(MaMA_Edit_Panel->Up_Button, PANEL_INACTIVE, TRUE, NULL);
        xv_set(MaMA_Edit_Panel->Down_Button, PANEL_INACTIVE, TRUE, NULL);
    } else {
        row = (int)xv_get(MaMA_Edit_Panel->Action_List,
            PANEL_LIST_FIRST_SELECTED);

        if (row == 0)
	{
            xv_set(MaMA_Edit_Panel->Up_Button, PANEL_INACTIVE, TRUE, NULL);
            xv_set(MaMA_Edit_Panel->Down_Button, PANEL_INACTIVE, FALSE, NULL);
            return;
	}

        if (row == (NumberOfActions -1))
        {
            xv_set(MaMA_Edit_Panel->Down_Button, PANEL_INACTIVE, TRUE, NULL);
            xv_set(MaMA_Edit_Panel->Up_Button, PANEL_INACTIVE, FALSE, NULL);
            return;
        }

        xv_set(MaMA_Edit_Panel->Down_Button, PANEL_INACTIVE, FALSE, NULL);
        xv_set(MaMA_Edit_Panel->Up_Button, PANEL_INACTIVE, FALSE, NULL);
    }
}

/******************************************************************************\
*                                                                              *
*        Name : MoveEditButtonsActive                                          *
*                                                                              *
* Description : Activates or De-activates move buttons                         *
*                                                                              *
\******************************************************************************/

void
MoveEditButtonsActive()
{
    int row;

    if ((NumberOfEdits == 0) || (NumberOfEdits == 1))
    {
        xv_set(MaMA_Main_Window->Edit_Up_Button, PANEL_INACTIVE, TRUE, NULL);
        xv_set(MaMA_Main_Window->Edit_Down_Button, PANEL_INACTIVE, TRUE, NULL);
    } else {
        row = (int)xv_get(MaMA_Main_Window->Edit_List,
            PANEL_LIST_FIRST_SELECTED);

        if (row == 0)
	{
            xv_set(MaMA_Main_Window->Edit_Up_Button, PANEL_INACTIVE, TRUE, 
                NULL);
            xv_set(MaMA_Main_Window->Edit_Down_Button, PANEL_INACTIVE, FALSE, 
                NULL);
            return;
	}

        if (row == (NumberOfEdits -1))
        {
            xv_set(MaMA_Main_Window->Edit_Down_Button, PANEL_INACTIVE, TRUE, 
                NULL);
            xv_set(MaMA_Main_Window->Edit_Up_Button, PANEL_INACTIVE, FALSE, 
                NULL);
            return;
        }

        xv_set(MaMA_Main_Window->Edit_Down_Button, PANEL_INACTIVE, FALSE, NULL);
        xv_set(MaMA_Main_Window->Edit_Up_Button, PANEL_INACTIVE, FALSE, NULL);
    }
}

/******************************************************************************\
*                                                                              *
*        Name : PutLinksInChoice                                               *
*                                                                              *
* Description : Puts the names of the hyperlinks into the choice list          *
*                                                                              *
\******************************************************************************/

void
PutLinksInChoice(LINKLIST *LinkListPtr)
{
    /*
     * Clean 'Old' List in GUI
     */
    xv_set(MaMA_Edit_Panel->Link_Name_tf, PANEL_VALUE, "", NULL);
    xv_set(MaMA_Edit_Panel->Link_Settings, PANEL_CHOICE_STRINGS, "", NULL,
        NULL);

    NumberOfLinks = 0;

    /*
     * Enter new hyperlinkname in choice list
     */
    while (LinkListPtr != NIL(LINKLIST *))
    {
        xv_set(MaMA_Edit_Panel->Link_Settings, PANEL_CHOICE_STRING, 
            NumberOfLinks, LinkListPtr->Linkname, NULL);
        LinkListPtr = LinkListPtr->next;
	NumberOfLinks++;
    }
}

/******************************************************************************\
*                                                                              *
*        Name : RetrieveFileName                                               *
*                                                                              *
* Description : Filters the filename out of a complete pathname                *
*                                                                              *
\******************************************************************************/

char
*RetrieveFileName(char *FullFileName)
{
    char *Result;
    char Lastresult[FILELEN];
    char FileName[PATHLEN + FILELEN];

    strcpy(FileName, (char *)FullFileName);

    Result = (char *)strtok(FileName, "/");
    strcpy(Lastresult, Result);

    while((Result = (char *)strtok(NULL, "/")) != (char *)0)
    {
        strcpy(Lastresult, Result);
    }

    return(Lastresult);
}
