/******************************************************************************\
*                                                                              *
* The software for `MaMA' was developed by:    H. K. Blokhuis and              *
*                                              S. L. Voogd                     *
*                                                                              *
* as part of their graduation for:     the Hoger Informatica Onderwijs (HIO)   *
* in Enschede.                             ---------------------------------   *
* The project was carried out at:          Sun Microsystems Nederland B.V.     *
* in Amersfoort.                           -------------------------------     *
*                                                                              *
*                                                                              *
* Copyright (c) 1992 Sun Microsystems Nederland B.V.                           *
*                                                                              *
* Permission to use, copy, modify, and distribute this software and            *
* its documentation for any purpose is hereby granted without fee, provided    *
* that (i) the above copyright notices and this permission notice appear in    *
* all copies of the software and related documentation, and (ii) the name      *
* Sun may not be used in any advertising or publicity relating to              *
* the software without the specific, prior written permission of               *
* Sun.                                                                         *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,           *
* EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY             *
* WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.             *
*                                                                              *
* IN NO EVENT SHALL SUN BE LIABLE FOR ANY SPECIAL, INCIDENTAL,                 *
* INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES                *
* WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT       *
* ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,        *
* ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS          *
* SOFTWARE.                                                                    *
*                                                                              *
\******************************************************************************/

/*----------------------------------------------------------------------------*\
|                                                                              |
|        File : MaMA_link.c                                                    |
|                                                                              |
| Description : Functions for the link with TimeLine                           |
|                                                                              |
|          NB : The Sun RPC messaging system imposes returnvalues to be        |
|               declared as `static's                                          |
|                                                                              |
\*----------------------------------------------------------------------------*/

#include <MaMA_include.h>
#include <MaMA_global.h>

extern EDITLIST     *CurEdit;
extern EDITLIST     *EditList;
extern EDITLISTINFO *EditListInfo;
extern int           EditOffset;

/******************************************************************************\
*                                                                              *
*    Function : MaMA_OpenDocument                                              *
*                                                                              *
* Description : Loads the current EditList into MaMA                           *
*                                                                              *
\******************************************************************************/

void
MaMA_OpenDocument(char **buf)
{
    if (0 == strcmp(*buf, EditListInfo->FullFileName))
    {
	/*
         * The right EditList is already loaded in MaMA
         */
        return;
    }

    LoadEditList(*buf);

    /*
     * (de-) activate Edit buttons
     */
    EditButtonsActive();
}

/******************************************************************************\
*                                                                              *
*    Function : MaMA_GetCurDoc                                                 *
*                                                                              *
* Description : Returns the current EditList name                              *
*                                                                              *
\******************************************************************************/

char
**MaMA_GetCurDoc()
{
    static char *buf;

    buf = strdup(EditListInfo->FullFileName);

    return(&buf);
}

/******************************************************************************\
*                                                                              *
*    Function : MaMA_GetSelection                                              *
*                                                                              *
* Description :                                                                *
*                                                                              *
\******************************************************************************/

MAESelection
*MaMA_GetSelection()
{
    static MAESelection *GetSelectionRetVal; 

    /*
     * Return current Edit if there is one
     */
    if (CurEdit != NIL(EDITLIST *))
    {
        GetSelectionRetVal = (MAESelection *)malloc((unsigned)sizeof(MAESelection));

        GetSelectionRetVal->duration = CurEdit->TotalDur * 1000;
        GetSelectionRetVal->start = 0;
        GetSelectionRetVal->end = 0;
        strcpy(GetSelectionRetVal->label, CurEdit->Label);
        return(GetSelectionRetVal);
    }

    /*
     * No current Edit
     */
    GetSelectionRetVal = NIL(MAESelection *);

    return(GetSelectionRetVal);
}

/******************************************************************************\
*                                                                              *
*    Function : MaMA_SetSelection                                              *
*                                                                              *
* Description : Retrieve Edit info for TimeLine                                *
*                                                                              *
\******************************************************************************/

void
MaMA_SetSelection(MAESelection *selection)
{
    EDITLIST *EditListPtr;
    static int EditNumber;

    EditNumber = 0;

    /*
     * set offset to received offset
     */
    EditOffset = (int)(selection->offset / 1000);

    /*
     * set current Edit to Edit on timeline
     */
    EditListPtr = EditList;
    while(EditListPtr != NIL(EDITLIST *))
    {
	/*
	 * Unselect all other Edits                          
	 */
	EditListPtr->Selected = False;

	/*
	 * Select Edit according to 'received' label name
	 */
        if (strcmp(selection->label, EditListPtr->Label) == 0)
        {
            CurEdit = EditListPtr;
            CurEdit->Selected = True;

            xv_set(MaMA_Main_Window->Edit_List, 
                PANEL_LIST_SELECT, EditNumber, TRUE, NULL);
            break;
        }
        EditListPtr = EditListPtr->next;
        EditNumber++;
    }
}

/******************************************************************************\
*                                                                              *
*    Function : MaMA_PerformSelection                                          *
*                                                                              *
* Description : Perform the currently selected Edit                            *
*                                                                              *
\******************************************************************************/

void
MaMA_PerformSelection()
{
    /*
     * Play the current Edit
     */
    play_button_proc(MaMA_Main_Window->Main_Window, NIL(Event *));

    /*
     * Reset offset;
     */
    EditOffset = 0;
}

/******************************************************************************\
*                                                                              *
*    Function : MaMA_HaltSelection                                             *
*                                                                              *
* Description : Halts the performance                                          *
*                                                                              *
\******************************************************************************/

void
MaMA_HaltSelection()
{
    stop_button_proc(MaMA_Main_Window->Main_Window, NIL(Event *));
}

/******************************************************************************\
*                                                                              *
*    Function : MaMA_PauseSelection                                            *
*                                                                              *
* Description : Pauses the performance                                         *
*                                                                              *
\******************************************************************************/

void
MaMA_PauseSelection()
{
    pause_button_proc(MaMA_Main_Window->Main_Window, NIL(Event *));
}

/******************************************************************************\
*                                                                              *
*    Function : MaMA_ResumeSelection                                           *
*                                                                              *
* Description : Pauses the performance                                         *
*                                                                              *
\******************************************************************************/

void
MaMA_ResumeSelection()
{
    pause_button_proc(MaMA_Main_Window->Main_Window, NIL(Event *));
}

/******************************************************************************\
*                                                                              *
*    Function : MaMA_HideApplication                                           *
*                                                                              *
* Description : Iconify application                                            *
*                                                                              *
\******************************************************************************/

void
MaMA_HideApplication()
{
    xv_set(MaMA_Main_Window->Main_Window, FRAME_CLOSED, TRUE, NULL);    
}

/******************************************************************************\
*                                                                              *
*    Function : MaMA_ShowApplication                                           *
*                                                                              *
* Description : Open the application                                           *
*                                                                              *
\******************************************************************************/

void
MaMA_ShowApplication()
{
    xv_set(MaMA_Main_Window->Main_Window, FRAME_CLOSED, FALSE, NULL);    
}

/******************************************************************************\
*                                                                              *
*    Function : MaMA_GetAppIcon                                                *
*                                                                              *
* Description : Returns the icon to be used in the TimeLine                    *
*                                                                              *
\******************************************************************************/

IconData 
*MaMA_GetAppIcon()
{
    static IconData returnVal;
    static unsigned short baseWindow_bits[] = 
    {
        #include "include/images/MaMA_main.icon"
    };

    returnVal.iconData = (char *)malloc((unsigned)sizeof(baseWindow_bits));
    bcopy(baseWindow_bits, returnVal.iconData, sizeof(baseWindow_bits));

    if (returnVal.iconData) returnVal.dataLength = sizeof(baseWindow_bits);

    return(&returnVal);
}
