/******************************************************************************\
*                                                                              *
* The software for `MaMA' was developed by:    H. K. Blokhuis and              *
*                                              S. L. Voogd                     *
*                                                                              *
* as part of their graduation for:     the Hoger Informatica Onderwijs (HIO)   *
* in Enschede.                             ---------------------------------   *
* The project was carried out at:          Sun Microsystems Nederland B.V.     *
* in Amersfoort.                           -------------------------------     *
*                                                                              *
*                                                                              *
* Copyright (c) 1992 Sun Microsystems Nederland B.V.                           *
*                                                                              *
* Permission to use, copy, modify, and distribute this software and            *
* its documentation for any purpose is hereby granted without fee, provided    *
* that (i) the above copyright notices and this permission notice appear in    *
* all copies of the software and related documentation, and (ii) the name      *
* Sun may not be used in any advertising or publicity relating to              *
* the software without the specific, prior written permission of               *
* Sun.                                                                         *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,           *
* EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY             *
* WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.             *
*                                                                              *
* IN NO EVENT SHALL SUN BE LIABLE FOR ANY SPECIAL, INCIDENTAL,                 *
* INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES                *
* WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT       *
* ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,        *
* ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS          *
* SOFTWARE.                                                                    *
*                                                                              *
\******************************************************************************/

 
#include <MaMA_include.h>
#include <MaMA_global.h>

#define Success 0
#define Failure -1

#define FRAMEVERSION  "FrameMaker2.1.1"

static struct timeval fiveSeconds = { 5, 0 };
static struct timeval halfMinute = { 60, 0 };
static FmRpcNiceErrorT nice;

char
*GetFrameVersion()
{
    return(FRAMEVERSION);
}

/*
I call RPC's.
*/

/*
Utilities.
*/

static bool_t localCall(proc, inproc, in, outproc, out, total_timeout)
struct timeval total_timeout;
char *in, *out;
xdrproc_t inproc, outproc;
{
struct hostent *hp;
int addrlen, sock = RPC_ANYSOCK;
CLIENT *client;
enum clnt_stat clnt_stat;
struct sockaddr_in server_addr;

hp = gethostbyname("localhost");
if (! hp)
	return (FALSE);

addrlen = sizeof(struct sockaddr_in);
bcopy(hp->h_addr, (caddr_t)&server_addr.sin_addr, hp->h_length);
server_addr.sin_family = AF_INET;
server_addr.sin_port = 0;

client = clntudp_create(&server_addr, FM_RPC_PROG, FM_RPC_VERS, total_timeout, &sock); 
if (! client)
	return (FALSE);
	
clnt_stat = clnt_call(client, proc, inproc, in, outproc, out, total_timeout);
if (clnt_stat != RPC_SUCCESS) {
	clnt_perror(client, "");
	return (FALSE);
}

close(sock);
clnt_destroy(client);
return (TRUE);
}

static freeReturn(returnp, freer)
char *returnp;
xdrproc_t freer; 
{
XDR anXdrStream;

xdrmem_create(&anXdrStream, returnp, 8 * 1024, XDR_FREE);
freer(&anXdrStream, returnp);
}

/*
RPC's.
*/

void doFmCommands(doc, codes, num) 
UIntT doc;
IntT *codes;
u_int num;
{
FmRpcCommandsArgT arg;

arg.doc = (UIntT) doc;
arg.commands.FmRpcCommandsT_len = num;
arg.commands.FmRpcCommandsT_val = codes;
bzero(&nice, sizeof(nice));
if (localCall(FM_RPC_COMMANDS, xdr_FmRpcCommandsArgT, &arg, xdr_FmRpcNiceErrorT, &nice, halfMinute)) {
	if (nice.code != Success)
		;
	freeReturn(&nice, xdr_FmRpcNiceErrorT);
}
}

int CloseFMDoc(doc)
UIntT doc;
{
int codes[12];

codes[0] = KBD_CLOSEWIN;
doFmCommands(doc, codes, 1);
}

int OpenFMDoc(doc)
char *doc;
{ 
FmRpcOpenDocArgT arg;
FmRpcOpenDocReturnT openDocReturn;
int handle;

arg.doc = doc;
bzero(&openDocReturn, sizeof(openDocReturn));
handle = -1;
if (localCall(FM_RPC_OPEN_DOC, xdr_FmRpcOpenDocArgT, &arg, xdr_FmRpcOpenDocReturnT, &openDocReturn, halfMinute)) {
	if (openDocReturn.nice.code != Success) {
	}
	else handle =(int) openDocReturn.doc;
	freeReturn(&openDocReturn, xdr_FmRpcOpenDocReturnT);
}
return (handle);
}

int GoToLink(src, dst, tag, isNewWindow)
UIntT src;
char *dst;
StringT tag;
UIntT isNewWindow;
{ 
FmRpcGoToLinkArgT arg;

arg.doc = src;
arg.dstDoc = dst;
arg.tag = tag;
arg.isNewWindow = (BoolT) isNewWindow;
bzero(&nice, sizeof(nice));
if (localCall(FM_RPC_GO_TO_LINK, xdr_FmRpcGoToLinkArgT, &arg, xdr_FmRpcNiceErrorT, &nice, halfMinute)) {
	if (nice.code != Success) {
		freeReturn(&nice, xdr_FmRpcNiceErrorT);
		return (-1);
	}
	freeReturn(&nice, xdr_FmRpcNiceErrorT);
	return (0);
}
return (-1);
}

int Import(file) 
char *file;
{
FmRpcImportArgT arg;

arg.doc = NULL; 
arg.file = file; 
arg.isCurrentDoc = (BoolT) 1;
arg.isCopy = 0;
bzero(&nice, sizeof(nice));
if (localCall(FM_RPC_IMPORT, xdr_FmRpcImportArgT, &arg, xdr_FmRpcNiceErrorT, &nice, halfMinute)) {
	if (nice.code != Success) {
		freeReturn(&nice, xdr_FmRpcNiceErrorT);
		return (-1);
	}
	freeReturn(&nice, xdr_FmRpcNiceErrorT);
	return (0);
}
return (-1);
}

 
FmRpcSaveMifArgT aMifArg;
int mode = 0777;
 
int
saveMarkers(unsigned int doc, char *file)
{
        bzero(&aMifArg, sizeof(aMifArg));
 
        aMifArg.doc = doc;
        aMifArg.file = file;
        aMifArg.mode = mode ;
        aMifArg.isMakeBackup = False;
        aMifArg.saveOptions = MIF_SAVE_MKRS;
 
        bzero(&nice, sizeof(nice));
 
        if(localCall(FM_RPC_SAVE_MIF, xdr_FmRpcSaveMifArgT,
                (char *) &aMifArg, xdr_FmRpcNiceErrorT, &nice, halfMinute))       
        {
            if (nice.code != Success)
            {
                    freeReturn(&nice, xdr_FmRpcNiceErrorT);
                    return (-1);
            }
            freeReturn(&nice, xdr_FmRpcNiceErrorT);
            return (0);
        }
return(-1);
}
