/******************************************************************************\
*                                                                              *
* The software for `MaMA' was developed by:    H. K. Blokhuis and              *
*                                              S. L. Voogd                     *
*                                                                              *
* as part of their graduation for:     the Hoger Informatica Onderwijs (HIO)   *
* in Enschede.                             ---------------------------------   *
* The project was carried out at:          Sun Microsystems Nederland B.V.     *
* in Amersfoort.                           -------------------------------     *
*                                                                              *
*                                                                              *
* Copyright (c) 1992 Sun Microsystems Nederland B.V.                           *
*                                                                              *
* Permission to use, copy, modify, and distribute this software and            *
* its documentation for any purpose is hereby granted without fee, provided    *
* that (i) the above copyright notices and this permission notice appear in    *
* all copies of the software and related documentation, and (ii) the name      *
* Sun may not be used in any advertising or publicity relating to              *
* the software without the specific, prior written permission of               *
* Sun.                                                                         *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,           *
* EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY             *
* WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.             *
*                                                                              *
* IN NO EVENT SHALL SUN BE LIABLE FOR ANY SPECIAL, INCIDENTAL,                 *
* INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES                *
* WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT       *
* ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,        *
* ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS          *
* SOFTWARE.                                                                    *
*                                                                              *
\******************************************************************************/

/*----------------------------------------------------------------------------*\
|                                                                              |
|        File : MaMA_TT.c                                                      |
|                                                                              |
|    Contents : ToolTallk communication functions                              |
|                                                                              *
\*----------------------------------------------------------------------------*/

#include <MaMA_include.h>
#include <MaMA_global.h>

extern EDITLIST   *EditList;
extern int        NumberOfEdits;

extern int RepeatOn;

void
ToolTalk_init()
{
    tt_default_session_set(other_session);

    /*
     * Initialize ToolTalk
     */
    my_pid = tt_open();
    ttfd = tt_fd();
 
    /*                 
     * Arrange for XView to call receive_tt_message when the ToolTalk
     * file descriptor becomes active.
     */
    notify_set_input_func(MaMA_Main_Window->Main_Window,
        (Notify_func)receive_tt_message, ttfd);
 
    pat = tt_pattern_create();
    tt_pattern_category_set(pat, TT_OBSERVE);
    tt_pattern_scope_add(pat, TT_SESSION);
    tt_pattern_op_add(pat, TT_KEY);
    tt_pattern_register(pat);
 
    tt_session_join(tt_default_session());
}

/*
 * When a ToolTalk message is available, receive it; 
 * When the message key is TT_KEY, it will be received
 */
void
receive_tt_message()
{
    Tt_message msg_in;
    int mark;
    unsigned char *Message[MSG_LEN];
    int len;
    int TT_EditNumber;
    unsigned char *c_EditNumber[3];
    unsigned char *TT_EditLabel[MSG_LEN];
    unsigned char *TT_Filename[MSG_LEN];
 
    msg_in = tt_message_receive();
 
    /*
     * It's possible that the file descriptor would become active
     * even though ToolTalk doesn't really have a message for us.
     */
    if (msg_in == NULL) return;
 
    /*
     * Get a storage mark so we can easily free all the data
     * ToolTalk returns to us.
     */
    mark = tt_mark();
 
    /*
     * If message key is TT_KEY, perform according action
     */
    if (0 == strcmp(TT_KEY, tt_message_op(msg_in)))
    {
        tt_message_arg_bval(msg_in, 0, Message, &len);

        if (0 == strcmp((char *)*Message, "open_editlist"))
        {
            tt_message_arg_bval(msg_in, 1, TT_Filename, &len);
            /*
             * Read in file
             */
            if (CheckFileType((char *)*TT_Filename, MaMA_EDIT_MAGIC))
            {   
                LoadEditList((char *)*TT_Filename);
    
   		SetHeader((char *)*TT_Filename);
 
                /*
                 * Reset changed bools
                 */
                ActionListChanged = False;
                EditListChanged = False;
                xv_set(MaMA_Main_Window->Main_Window, FRAME_RIGHT_FOOTER, "", 
                    NULL); 
                /*
                 * (De)acivate edit buttons
                 */
                EditButtonsActive();
            }
        } else

        if (0 == strcmp((char *)*Message, "play_edit"))
        {
            if (EditList != NIL(EDITLIST *))
            {
                play_button_proc(MaMA_Main_Window->Main_Window, NIL(Event *));
            }
        } else

        if (0 == strcmp((char *)*Message, "pause_edit"))
        {
            pause_button_proc(MaMA_Main_Window->Main_Window, NIL(Event *));
        } else

        if (0 == strcmp((char *)*Message, "stop_edit"))
        {
            stop_button_proc(MaMA_Main_Window->Main_Window, NIL(Event *));
        } else

        if (0 == strcmp((char *)*Message, "select_edit_nr"))
        {
            tt_message_arg_bval(msg_in, 1, c_EditNumber, &len);
            TT_EditNumber = atoi((char *)*c_EditNumber);

            if (NumberOfEdits >= TT_EditNumber )
            {
                xv_set(MaMA_Main_Window->Edit_List, PANEL_LIST_SELECT, 
                    TT_EditNumber - 1, TRUE, NULL);
                SelectEdit(EditList, TT_EditNumber - 1);
		MoveEditButtonsActive();
	        FillPopup();
            }
        } else
    
        if (0 == strcmp((char *)*Message, "select_edit_label"))
        {
            tt_message_arg_bval(msg_in, 1, TT_EditLabel, &len);
            SelectEditByLabel(*TT_EditLabel);
	    MoveEditButtonsActive();
	    FillPopup();
        } else

        if (0 == strcmp((char *)*Message, "repeat_on"))
        {
            RepeatOn = True;
#ifdef SaM
            xv_set(MaMA_Main_Window->Repeat_Setting, PANEL_VALUE, 0, NULL);
#endif
        } else

        if (0 == strcmp((char *)*Message, "repeat_off"))
        {
            RepeatOn = False;
#ifdef SaM
            xv_set(MaMA_Main_Window->Repeat_Setting, PANEL_VALUE, -1, NULL);
#endif
        }
    }
 
    tt_message_destroy(msg_in);
    tt_release(mark);

    return;
}
