/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
/* $Header: /Source/Media/bryant/DisplayTool/RCS/imagePanel.c,v 1.1 92/10/29 13:57:35 drapeau Exp $ */
/* $Log:	imagePanel.c,v $
 * Revision 1.1  92/10/29  13:57:35  drapeau
 * Initial revision
 *  */
static char dtImagePanel[] = "$Header: /Source/Media/bryant/DisplayTool/RCS/imagePanel.c,v 1.1 92/10/29 13:57:35 drapeau Exp $";

#include "DisplayTool.h"
#include "externs.h"



/*
 * Notify callback function for `imageXPosition'.
 */
Panel_setting
  ImageXPosition(Panel_item item, Event *event)
{
  int	value = (int) xv_get(item, PANEL_VALUE);
  if (selectedSlideImage == None)
    {
      NoImageSelected();
      return panel_text_notify(item, event);
    }
  else
    {
      EraseOldImage(selectedSlideImage);
      dtImage[selectedSlideImage]->corner.x = value/largeFactor;
      DrawNewImage(selectedSlideImage);
    }
  return panel_text_notify(item, event);
}

/*
 * Notify callback function for `imageYPosition'.
 */
Panel_setting
  ImageYPosition(Panel_item item, Event *event)
{
  int	value = (int) xv_get(item, PANEL_VALUE);
  if (selectedSlideImage == None)
    {
      NoImageSelected();
      return panel_text_notify(item, event);
    }
  else
    {
      EraseOldImage(selectedSlideImage);
      dtImage[selectedSlideImage]->corner.y = value/largeFactor;
      DrawNewImage(selectedSlideImage);
    }
  return panel_text_notify(item, event);
}

/*
 * Notify callback function for `imageWidth'.
 */
Panel_setting
  ImageWidth(Panel_item item, Event *event)
{
  int	value = (int) xv_get(item, PANEL_VALUE);
  IMAGE	tempImage;
  
  if (selectedSlideImage == None)
    {
      NoImageSelected();
      return panel_text_notify(item, event);
    }
  else
    {
      EraseOldImage(selectedSlideImage);
      tempImage = dtImage[selectedSlideImage];
      tempImage->slideImage = Resize(tempImage->imageData,
				    tempImage->origWidth,
				    tempImage->origHeight,
				    value / largeFactor,
				    tempImage->largeHeight / largeFactor);
      tempImage->largeWidth = value;				    /* Update width of the image to be displayed */
      if (tempImage->largeImage != (XImage*)NULL)		    /* Destroy the now-obsolete largeImage, if it exists */
	XDestroyImage(tempImage->largeImage);
      DrawNewImage(selectedSlideImage);
    }
  return panel_text_notify(item, event);
}



/*
 * Notify callback function for `imageHeight'.
 */
Panel_setting
  ImageHeight(Panel_item item, Event *event)
{
  int	value = (int) xv_get(item, PANEL_VALUE);
  IMAGE	tempImage;
  
  if (selectedSlideImage == None)
    {
      NoImageSelected();
      return panel_text_notify(item, event);
    }
  else
    {
      EraseOldImage(selectedSlideImage);
      tempImage = dtImage[selectedSlideImage];
      tempImage->slideImage = Resize(tempImage->imageData,
				    tempImage->origWidth,
				    tempImage->origHeight,
				    tempImage->origWidth / largeFactor,
				    value / largeFactor);
      tempImage->largeHeight = value;				    /* Update height of the image to be displayed */
      if (tempImage->largeImage != (XImage*)NULL)		    /* Destroy the now-obsolete largeImage, if it exists */
	XDestroyImage(tempImage->largeImage);
      DrawNewImage(selectedSlideImage);
    }
  return panel_text_notify(item, event);
}								    /* end function ImageHeight */




/*
 * Notify callback function for `imageList'.
 */
int
  ImageList(Panel_item item, char *string, Xv_opaque client_data, 
	    Panel_list_op op, Event *event, int row)
{
  int i, count = 0;
  switch(op) {
  case PANEL_LIST_OP_DESELECT:
    WriteSlideInfoToPanel(None);
    break;
    
  case PANEL_LIST_OP_SELECT:
    for (i=0; i<numSlidesImages; i++)
      if (dtImage[i]->slide == selectedSlide)
	{
	  if (count == row)
	    {
	      WriteSlideInfoToPanel(i);
	      break;
	    }
	  count++;
	}
    break;
    
  case PANEL_LIST_OP_VALIDATE:
  case PANEL_LIST_OP_DELETE:
    break;
  }
  return XV_OK;
}								    /* end function ImageList */


/*
 * Menu handler for `imagesMenu (Duplicate Image)'.
 */
Menu_item
  DuplicateImage(Menu_item item, Menu_generate op)
{
  if (op == MENU_NOTIFY)
    notice_prompt(baseWindow->baseWindow, NULL,
		  NOTICE_MESSAGE_STRINGS,
		  "Duplicate Image function hasn't been implemented yet.",
		  NULL,
		  NOTICE_BUTTON_YES, "OK",
		  NULL);
  return item;
}

/*
 * Menu handler for `imagesMenu (Cut Image)'.
 */
Menu_item
  CutImage(Menu_item item, Menu_generate op)
{
  int i;
  if (op == MENU_NOTIFY)
    {
      if (selectedSlideImage == None)
	{
	  NoImageSelected();
	  return item;
	}
      numSlidesImages--;
      for(i=selectedSlideImage; i<numSlidesImages; i++)
	CopyImage(dtImage[i+1], dtImage[i]);
      /*      FreeImage(slidesImage[numSlidesImages]);  */
      WriteSlideInfoToPanel(None);
      SetCurrentSlide(selectedSlide+1);
      SlidesRepaint(NULL, NULL, NULL, NULL);
    }
  return item;
}

/*
 * Menu handler for `imagesMenu (Resize Image)'.
 */
Menu_item
  ResizeImageGeneral(Menu_item item, Menu_generate op)
{
  static int	first = TRUE;
  static	Rect	rect;
  
  if (first == TRUE)
    frame_get_rect(resizePopup->resizePopup, &rect);
  if (op == MENU_NOTIFY)
    if ((int)xv_get(resizePopup->resizePopup, XV_SHOW) == FALSE && first)			   
      {
	ShowPopup(&resizePopup->resizePopup, 300, 170, rect.r_width, rect.r_height);
	first = FALSE;
      }
    else
      ShowPopup(&resizePopup->resizePopup, None, None, rect.r_width, rect.r_height);
  return item;
}

/*
 * Menu handler for `imagesMenu (Resize Image + 10%)'.
 */
Menu_item
  ResizeImagePlus10Percent(Menu_item item, Menu_generate op)
{
  IMAGE	tempImage;
  
  if (op == MENU_NOTIFY)
    {
      if (selectedSlideImage == None)
	{
	  NoImageSelected();
	  return item;
	}
      else
	{
	  tempImage = dtImage[selectedSlideImage];
	  EraseOldImage(selectedSlideImage);
	  tempImage->slideImage = Resize(tempImage->imageData,
					tempImage->origWidth,
					tempImage->origHeight,
					1.1 * (tempImage->largeWidth / largeFactor),
					1.1 * (tempImage->largeHeight / largeFactor));
	  tempImage->largeWidth = 1.1 * tempImage->largeWidth;
	  tempImage->largeHeight = 1.1 * tempImage->largeHeight;
	  DrawNewImage(selectedSlideImage);
	  xv_set(slidePopup->imageWidth, PANEL_VALUE,
		 tempImage->largeWidth, NULL);
	  xv_set(slidePopup->imageHeight, PANEL_VALUE, 
		 tempImage->largeHeight, NULL);
	}
    }
  return item;
}

/*
 * Menu handler for `imagesMenu (Resize Image - 10%)'.
 */
Menu_item
  ResizeImageMinus10Percent(Menu_item item, Menu_generate op)
{
  IMAGE	tempImage;
  
  if (op == MENU_NOTIFY)
    {
      if (selectedSlideImage == None)
	{
	  NoImageSelected();
	  return item;
	}
      else
	{ 
	  tempImage = dtImage[selectedSlideImage];
	  EraseOldImage(selectedSlideImage);
	  tempImage->slideImage = Resize(tempImage->imageData,
					tempImage->origWidth,
					tempImage->origHeight,
					.9 * (tempImage->largeWidth / largeFactor),
					.9 * (tempImage->largeHeight / largeFactor));
	  tempImage->largeWidth = .9 * tempImage->largeWidth;
	  tempImage->largeHeight = .9 * tempImage->largeHeight;
	  DrawNewImage(selectedSlideImage);
	  xv_set(slidePopup->imageWidth, PANEL_VALUE,
		 tempImage->largeWidth, NULL);
	  xv_set(slidePopup->imageHeight, PANEL_VALUE, 
		 tempImage->largeHeight, NULL);
	}
    }
  return item;
}

/*
 * Menu handler for `imagesMenu (Set To Original Size)'.
 */
Menu_item
  ImageEditSetToOriginalSize(Menu_item item, Menu_generate op)
{
  IMAGE	tempImage;
  
  if (op == MENU_NOTIFY)
    {
      if (selectedSlideImage == None)
	{
	  NoImageSelected();
	  return item;
	}
      else
	{
	  tempImage = dtImage[selectedSlideImage];
	  EraseOldImage(selectedSlideImage);
	  tempImage->slideImage = Resize(tempImage->imageData,
					tempImage->origWidth,
					tempImage->origHeight,
					tempImage->origWidth / largeFactor,
					tempImage->origHeight / largeFactor);
	  tempImage->largeWidth = tempImage->origWidth;
	  tempImage->largeHeight = tempImage->origHeight;
	  DrawNewImage(selectedSlideImage);
	  xv_set(slidePopup->imageWidth, PANEL_VALUE,
		 tempImage->largeWidth, NULL);
	  xv_set(slidePopup->imageHeight, PANEL_VALUE, 
		 tempImage->largeHeight, NULL);
	}
    }
  return item;
}								    /* end function ImageEditSetToOriginalSize */





/*
 * Menu handler for `selectSlideMenu (Next Slide)'.
 */
Menu_item
  NextSlide(Menu_item item, Menu_generate op)
{
  char temp[MaxLength];
  if (op == MENU_NOTIFY)
    {
      CheckGeometry();  
      if (selectedSlide < GetMaxSlide())
	selectedSlide++;
      else
	{
	  notice_prompt(baseWindow->baseWindow, NULL,
			NOTICE_MESSAGE_STRINGS,
			"There are no slides beyond the current slide.",
			NULL,
			NOTICE_BUTTON_YES, "OK",
			NULL);
	  return(item);
	}
      beginDoubleBuffer = 1;
      sprintf(temp, "Current Slide    # %d", selectedSlide+1);
      PrepareMultipleWindowsForDisplay(selectedSlide);
      DisplayMultipleWindows(selectedSlide);
    }
  return(item);
}								    /* end function NextSlide */



/*
 * Menu handler for `selectSlideMenu (Previous Slide)'.
 */
Menu_item
  PreviousSlide(Menu_item item, Menu_generate op)
{
  char temp[MaxLength];
  if (op == MENU_NOTIFY)
    {
      CheckGeometry();
      if (selectedSlide > 0)
	selectedSlide--;
      else
	{
	  notice_prompt(baseWindow->baseWindow, NULL,
			NOTICE_MESSAGE_STRINGS,
			"The current slide is the first slide.",
			NULL,
			NOTICE_BUTTON_YES, "OK",
			NULL);
	  return(item);
	}
      beginDoubleBuffer = 1;
      sprintf(temp, "Current Slide    # %d", selectedSlide+1);
      PrepareMultipleWindowsForDisplay(selectedSlide);
      DisplayMultipleWindows(selectedSlide);
    }
  return(item);
}								    /* end function PreviousSlide */



/*
 * Menu handler for `selectSlideMenu (First Slide)'.
 */
Menu_item
  FirstSlide(Menu_item item, Menu_generate op)
{
  char temp[MaxLength];
  if (op == MENU_NOTIFY)
    {
      CheckGeometry();
      previousSlide = selectedSlide;
      selectedSlide = 0;
      sprintf(temp, "Current Slide    # 1");
      beginDoubleBuffer = 1;
      PrepareMultipleWindowsForDisplay(selectedSlide);
      DisplayMultipleWindows(selectedSlide);
    }
  return item;
}

/*
 * Menu handler for `selectSlideMenu (Last Slide)'.
 */
Menu_item
  LastSlide(Menu_item item, Menu_generate op)
{
  char temp[MaxLength];
  if (op == MENU_NOTIFY)
    {
      CheckGeometry();
      previousSlide = selectedSlide;
      selectedSlide = GetMaxSlide();
      sprintf(temp, "Current Slide    # %d", selectedSlide+1);
      beginDoubleBuffer = 1;
      PrepareMultipleWindowsForDisplay(selectedSlide);
      DisplayMultipleWindows(selectedSlide);
    }
  return item;
}

/*
 * Menu handler for `selectSlideMenu (Slide Number ...)'.
 */
Menu_item
  SlideNumberPopup(Menu_item item, Menu_generate op)
{
  static int	first = TRUE;
  static	Rect	rect;
  
  if (first == TRUE)
    frame_get_rect(slideNumberPopup->slideNumberPopup, &rect);
  if (op == MENU_NOTIFY)
    ShowPopup(&slideNumberPopup->slideNumberPopup, 300, 170, rect.r_width, rect.r_height);
  return item;
}

/*
 * Notify callback function for `slideNumber'.
 */
Panel_setting
  SlideNumber(Panel_item item, Event *event)
{
  HidePopup(&slideNumberPopup->slideNumberPopup);
  return panel_text_notify(item, event);
}



void 
  SetCurrentSlide(int slide)
{
  char temp[MaxLength];
  sprintf(temp, "Current Slide    # %d", slide);
  xv_set(baseWindow->currentSlideMessage, PANEL_LABEL_STRING, temp, NULL); 
  if ((int)xv_get(slidePopup->slidePopup, XV_SHOW))
    {
      int i, lastImage, count;
      xv_set(slidePopup->currentSlideInfoMessage, PANEL_LABEL_STRING, temp, NULL); 
      sprintf(temp, "Images on Slide # %d", slide);
      xv_set(slidePopup->imageList, PANEL_LIST_TITLE, temp, NULL);
      ClearList(slidePopup->imageList);
      for (i=0, count=0; i<numSlidesImages; i++)
	if (dtImage[i]->slide == slide-1)
	  {
	    xv_set(slidePopup->imageList,
		   PANEL_LIST_INSERT, count, 
		   XV_SHOW, FALSE, 
		   PANEL_LIST_STRING, count, dtImage[i]->filename,
		   PANEL_LIST_FONT, count, listFont,
		   NULL);
	    count++;
	    lastImage = i;
	  }
      
/* if there's only one item in the scrolling list then automatically select it */
      if (count == 1)
	{
	  xv_set(slidePopup->imageList, PANEL_LIST_SELECT, 0, TRUE, NULL);
	  WriteSlideInfoToPanel(lastImage);
	}
      else
	WriteSlideInfoToPanel(None);	
      xv_set(slidePopup->imageList, XV_SHOW, TRUE, NULL); 
    }
}



void WriteSlideInfoToPanel(int i)
{
  char	temp[MaxLength];
  IMAGE	tempImage;
  
  tempImage = dtImage[i];
  if (i >= 0 && tempImage->filename && tempImage->format)
    {
      xv_set(slidePopup->imageName, PANEL_LABEL_STRING, tempImage->filename, NULL);
      xv_set(slidePopup->imageFormat, PANEL_LABEL_STRING, tempImage->format, NULL); 
      sprintf(temp, "%dx%d", tempImage->origWidth, tempImage->origHeight);
      xv_set(slidePopup->imageOriginalSize, PANEL_LABEL_STRING, temp, NULL);
      xv_set(slidePopup->imageXPosition, PANEL_VALUE, 
	     largeFactor*tempImage->corner.x, NULL);
      xv_set(slidePopup->imageYPosition, PANEL_VALUE, 
	     largeFactor*tempImage->corner.y, NULL);
      xv_set(slidePopup->imageWidth, PANEL_VALUE, 
	     largeFactor*tempImage->largeWidth, NULL);
      xv_set(slidePopup->imageHeight, PANEL_VALUE, 
	     largeFactor*tempImage->largeHeight, NULL);
      selectedSlideImage = i;
    }
  else
    {
      xv_set(slidePopup->imageName, PANEL_LABEL_STRING, "", NULL);
      xv_set(slidePopup->imageFormat, PANEL_LABEL_STRING, "", NULL); 
      xv_set(slidePopup->imageOriginalSize, PANEL_LABEL_STRING, "", NULL);
      xv_set(slidePopup->imageXPosition, PANEL_VALUE, 0, NULL);
      xv_set(slidePopup->imageYPosition, PANEL_VALUE, 0, NULL);
      xv_set(slidePopup->imageWidth, PANEL_VALUE, 0, NULL);
      xv_set(slidePopup->imageHeight, PANEL_VALUE, 0, NULL);
      selectedSlideImage = None;
    }
}
