/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
/* $Header: /Source/Media/bryant/DisplayTool/RCS/externs.h,v 1.2 92/10/29 17:55:08 drapeau Exp $ */
/* $Log:	externs.h,v $
 * Revision 1.2  92/10/29  17:55:08  drapeau
 * Minor adjustments to functions responsible for creating and painting the
 * popup canvases used when displaying an image full-size.  The problem occurred
 * when a slide contained multiple images to be drawn: the result was that the
 * same image would be drawn in each of the full-sized canvases, instead of each
 * separate image being drawn in the separate canvases.
 * 
 * Revision 1.1  92/10/29  13:54:21  drapeau
 * Initial revision
 *  */

#include "DisplayTool.h"


extern struct itimerval timer;
extern Xv_singlecolor colors[];

extern Cms cms;
extern int cmsSize;
extern unsigned long*	pixelValues;

extern Attr_attribute	INSTANCE;
extern DisplayTool_baseWindow_objects        *baseWindow;
extern DisplayTool_infoPopup_objects	      *infoPopup;
extern DisplayTool_resizePopup_objects	      *resizePopup;
extern DisplayTool_helpPopup_objects         *helpPopup;
extern DisplayTool_slidePopup_objects        *slidePopup;
extern DisplayTool_slideNumberPopup_objects  *slideNumberPopup;

extern char    *canonFilename;

extern char      *input_file;
extern FILE      *fp;
extern Scrollbar galleryScrollbar;
extern Scrollbar slidesScrollbar;
extern Window    galleryWin;
extern Window    slidesWin;
extern Display   *display;
extern Colormap  galleryCmap;
extern Colormap  slidesCmap;
extern IconData  iconData;
extern Frame     globalPopup[MaxNumImages];
extern Canvas    globalCanvas[MaxNumImages];
extern Frame     oldPopups[MaxNumImages];
extern Canvas    oldCanvases[MaxNumImages];
extern XGCValues gcvalues;
extern IMAGE     dtImage	[MaxNumImages];
extern IMAGE     gallery	[MaxNumImages];
extern IMAGE     clipboardImage[MaxNumImages];
extern SCR       slide		[MaxNumSlides];

int numGalleryImages;
extern int numSlidesImages;
extern int numClipboardImages;
extern int selectedGalleryImage;
extern int selectedSlideImage;
extern int selectedSlide;
extern int oldSelectedSlide;
extern int previousSlide;
extern int largeFactor;
extern int slideSize;
extern int beginDoubleBuffer;
extern int changes;
extern int popupTot;
extern int oldPopupTot;
extern int dontCheckGeometry;
extern int performing;
extern int pauseMode;
extern int timeCount;
extern int borderOffset;
extern int imagesPerRow;
extern int numSlides;
extern int	printDiags;
extern int	cmap[NumColors];
extern Xv_font listFont; 
extern char	currentFilename[MAXPATHLEN];
extern char	dummy[MAXPATHLEN];
extern char	diagString[MAXPATHLEN];
Attr_attribute		canvasKeyData;


extern Sender* sender;
extern Receiver* receiver;
extern Port senderPort;
extern int ReceiverPortNumber;
