/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/DTR/RCS/waveedit.c,v 1.0 92/01/07 14:25:00 drapeau Exp Locker: derek $ */
/* $Log:	waveedit.c,v $
 * Revision 1.0  92/01/07  14:25:00  drapeau
 * Removed unneeded code, due to simplification of the interface.
 * Also, Made a number of cosmetic changes to make code easier to read and
 * to conform to programming specifications.
 * 
 * Revision 0.19  91/09/30  16:13:22  derek
 * DTR will now disconnect from the Port Manager when it quits.  Also,
 * a number of printf statements are removed.
 * 
 * Revision 0.18  91/09/18  22:47:40  derek
 * The following things are done:
 * 1.	The Makefile is changed corresponding to the changes in collab/.
 * 2.	Copyright messages included.
 * 3.	Some minor bugs fixed.
 * 
 * Revision 0.17  91/08/14  16:14:16  derek
 * Fixed a few saving/appending bugs.
 * 
 * Revision 0.16  91/08/07  16:24:53  derek
 * The Edit list part of DTR is done.  OpenPanel is also incorporated.
 * 
 * Revision 0.15  91/07/23  21:25:45  derek
 * This version is not ready for release.  Disk space editing is half-done:
 * the application can play an infinite sound and the canvases can handle
 * infinite sound files.  The app is pretty bug free too, I think.  The
 * weakness is that it cannot record sond infinitely.
 * 
 * Revision 0.14  91/06/26  15:55:58  derek
 * I have reformatted the code to conform coding specs.
 * 
 * Revision 0.13  91/06/25  11:40:12  derek
 * I have added the new protocol items.
 * 
 * Revision 0.12  91/06/20  20:01:25  derek
 * The network part should be working.  Also fixed a number of bugs involving
 * canvases and display.
 * 
 * Revision 0.11  91/06/05  15:00:14  derek
 * checking in after porting the code to collab
 * 
 * Revision 0.10  1991/04/25  01:54:04  derek
 * This version is checked in on 4/24/91
 * */
static char rcsid[] = "$Header: /Source/Media/collab/DTR/RCS/waveedit.c,v 1.0 92/01/07 14:25:00 drapeau Exp Locker: derek $";

#include "dtr.h"              
#include "dtr_ui.h"

BOOL       CutPortionReady;					    /*  Global variable to indicate that a cut...       */
                                                                    /*  ...portion is currently in memory.              */
BOOL       AboutToCopy;
BOOL       AboutToPaste;

void
  InitWaveEditVariables()
{
  CutPortionReady = FALSE;
  AboutToCopy = FALSE;
  AboutToPaste = FALSE;
  CanUndo = FALSE;
  BufferSaved = TRUE;
/*  WaveEditMode = TRUE;*/
  WaveEditMode = FALSE;
}


/*
 *  Handles "cut" (by edit-menu).
 */
void
  WaveCutHandler()
{
  int             size;
  unsigned char   *newdata;
  int             RightIntMarker;
  int             LeftIntMarker;
  double          saveZoom;
  int             saveScrollbarViewStart;
  extern Scrollbar   WaveCanvasScrollbar;
  
  saveZoom = Zoom;						    /*  Save old values.                                */
  saveScrollbarViewStart = xv_get(WaveCanvasScrollbar, 
				  PANEL_VALUE, 
				  SCROLLBAR_VIEW_START);
  
  if (!WaveCanvasRightMarkerSet ||				    /*  If markers are not set (ie. no wave segment...  */
      !GlobalWaveCanvasRightMarkerSet)				    /*  ...is chosen (highlighted) yet, return...       */
    return;							    /*  ...without doing anything.                      */
  
  RightIntMarker = irint(oldRightFloatMarker);
  LeftIntMarker = irint(oldLeftFloatMarker);
  size = (RightIntMarker - LeftIntMarker)+1;
  
  AllocCutBuffer(size);						    /*  Save the highlighted portion into CutBuffer...  */
  memcpy(CutBuffer.data, &Buffer.data[LeftIntMarker], size);	    /*  ...for future use.                              */
  CutPortionReady = TRUE;
  
  newdata = (unsigned char *) malloc(Buffer.hdr.data_size - size);  /*  Delete the highlithged portion from the...      */
  memcpy(newdata, Buffer.data, LeftIntMarker);			    /*  ...sound buffer.                                */
  memcpy(&newdata[LeftIntMarker], &Buffer.data[RightIntMarker+1],
	 Buffer.hdr.data_size - RightIntMarker - 1); 
  
  Buffer.old_hdr_data_size = Buffer.hdr.data_size;
  Buffer.old_alloc_size = Buffer.alloc_size;
  
  Buffer.hdr.data_size -= size;
  Buffer.alloc_size = (unsigned int) Buffer.hdr.data_size;
  free(Buffer.olddata);
  Buffer.olddata = Buffer.data;
  Buffer.data = newdata;
  
  Buffer.play.start = 0;
  Buffer.play.end = Buffer.hdr.data_size - 1;
  ResetWaveCanvas();
  ResetGlobalWaveCanvas();
  Zoom = saveZoom;
  RepaintWaveCanvas();
  xv_set(WaveCanvasScrollbar, SCROLLBAR_VIEW_START,
	 saveScrollbarViewStart, NULL);
  RepaintGlobalWaveCanvas();
  UpdateMessageDisplay();
  UpdateSelection();
  CanUndo = TRUE;
  BufferSaved = FALSE;
  UpdateHeader(TRUE);
}								    /* end function WaveCutHandler */


/*
 *  Handles "copy" (by edit-menu).
 */
void
  WaveCopyHandler(insertPoint)
int  insertPoint;
{
  int             size;
  unsigned char   *newdata;
  int             RightIntMarker;
  int             LeftIntMarker;
  
  RightIntMarker = irint(oldRightFloatMarker);
  LeftIntMarker = irint(oldLeftFloatMarker);
  size = (RightIntMarker - LeftIntMarker)+1;
  AllocCutBuffer(size);						    /*  Save the highlighted portion into CutBuffer...  */
  memcpy(CutBuffer.data, &Buffer.data[LeftIntMarker], size);	    /*  ...for future use.                              */
  CutBuffer.alloc_size = size;
  CutPortionReady = TRUE;
  newdata = (unsigned char *) malloc(Buffer.hdr.data_size + size);
  memcpy(newdata, Buffer.data, insertPoint);
  memcpy(&newdata[insertPoint], &Buffer.data[LeftIntMarker], size);
  memcpy(&newdata[insertPoint + size], &Buffer.data[insertPoint+1],
	 Buffer.hdr.data_size - insertPoint);
  Buffer.old_hdr_data_size = Buffer.hdr.data_size;
  Buffer.old_alloc_size = Buffer.alloc_size;
  Buffer.hdr.data_size += size;
  Buffer.alloc_size = (unsigned int) Buffer.hdr.data_size;
  free(Buffer.olddata);
  Buffer.olddata = Buffer.data;
  Buffer.data = newdata;
  ResetWaveCanvasMarkers();
  ResetGlobalWaveCanvasMarkers();
  RepaintWaveCanvas();
  RepaintGlobalWaveCanvas();
  UpdateMessageDisplay();
  AboutToCopy = FALSE;
  CanUndo = TRUE;
  BufferSaved = FALSE;
  UpdateHeader(TRUE);
}								    /* end function WaveCopyHandler */


/*
 *  Handles "paste" (by edit-menu).  It takes a "cut" wave portion and 
 *  inserts it into the current sound buffer.
 */
void
  WavePasteHandler(insertPoint)
int  insertPoint;
{
  unsigned char   *newdata;
  
  newdata = (unsigned char *) malloc(Buffer.hdr.data_size + 
				     CutBuffer.alloc_size);
  memcpy(newdata, Buffer.data, insertPoint);
  memcpy(&newdata[insertPoint], CutBuffer.data, CutBuffer.alloc_size);
  memcpy(&newdata[insertPoint + CutBuffer.alloc_size], 
	 &Buffer.data[insertPoint+1], 
	 Buffer.hdr.data_size - insertPoint);
  
  Buffer.old_hdr_data_size = Buffer.hdr.data_size;
  Buffer.old_alloc_size = Buffer.alloc_size;
  
  Buffer.hdr.data_size += CutBuffer.alloc_size;
  Buffer.alloc_size = (unsigned int) Buffer.hdr.data_size;
  free(Buffer.olddata);
  
  Buffer.olddata = Buffer.data;
  Buffer.data = newdata;
  
  Buffer.play.start = 0;					    /*  Reset all the sound and display parameters.     */
  Buffer.play.end = Buffer.hdr.data_size - 1;
  ResetWaveCanvas();
  ResetGlobalWaveCanvas();
  RepaintWaveCanvas();
  RepaintGlobalWaveCanvas();
  UpdateMessageDisplay();
  
  AboutToPaste = FALSE;
  CanUndo = TRUE;
  BufferSaved = FALSE;
  UpdateHeader(TRUE);
}								    /* end function WavePasteHandler */


void
  AllocCutBuffer(size)
int  size;
{
  if (CutBuffer.data != NULL)
    (void) free((char *)CutBuffer.data);
  CutBuffer.data = (unsigned char *) malloc(size);
  if (CutBuffer.data == (unsigned char*)NULL)
  {
    fprintf(stderr, "Error:  Malloc failure in AllocCutBuffer");
    exit(0);
  }
  CutBuffer.alloc_size = size;
}


void
  SetWaveEditModeOn()
{
  WaveEditMode = TRUE;
}


void
  SetWaveEditModeOff()
{
  WaveEditMode = FALSE;
}
