/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/DTR/RCS/timer.c,v 1.10 92/01/09 12:43:05 drapeau Exp Locker: derek $ */
/* $Log:	timer.c,v $
 * Revision 1.10  92/01/09  12:43:05  drapeau
 * Slight modifications to the code to make it ANSI-compliant.
 * 
 * Revision 1.0  92/01/06  17:51:32  drapeau
 * Made a number of cosmetic changes to make code easier to read and
 * to conform to programming specifications.
 * 
 * Revision 0.16  91/09/18  22:47:39  derek
 * The following things are done:
 * 1.	The Makefile is changed corresponding to the changes in collab/.
 * 2.	Copyright messages included.
 * 3.	Some minor bugs fixed.
 * 
 * Revision 0.15  91/08/21  11:34:33  derek
 * The following changes are made:
 * 1.	Now the duration and size of the recorded sound will be displayed
 * 	during recording.
 * 2.	I have changed GetSelection() corresponding to the request of Tek joo
 * 3.	Info Panel is added to the application.
 * 4.	Fixed SizeToFitHandler() so that when no file or buffer is currently
 * 	loaded, it would not do anything (except giving a warning
 * 	notice_prompt).
 * 5.	Inplemented the `Close' Menu option in the document menu.
 * 6.	Fixed the bug in which after ClearAll and I press PreviewEdit,
 * 	the edit wont be played.
 * 7.	I have made the changes corresponding to the change in OpenPanel's
 * 	name.  (from OpenPanel to Browse).
 * 8.	Incorporated BrowseCheck to check command line arg.
 * 9.	Changed most EditingStatusMessages to NoticePrompts.
 * 10.	SoundFileSaveAsPopUp and EditListSaveAsPopUp are removed 
 * 	from the application.
 * 
 * Revision 0.14  91/08/13  20:38:42  derek
 * The buttons (play, pause, record) will now flash after they are pressed.
 * This only applies to times when audio files (not edit-lists) are 
 * played.
 * 
 * Revision 0.13  91/08/07  16:24:50  derek
 * The Edit list part of DTR is done.  OpenPanel is also incorporated.
 * 
 * Revision 0.12  91/06/26  15:55:56  derek
 * I have reformatted the code to conform coding specs.
 * 
 * Revision 0.11  91/06/05  15:00:12  derek
 * checking in after porting the code to collab
 * 
 * Revision 0.10  1991/04/25  01:53:22  derek
 * This version is checked in on 4/24/91
 * */
static char rcsid[] = "$Header: /Source/Media/collab/DTR/RCS/timer.c,v 1.10 92/01/09 12:43:05 drapeau Exp Locker: derek $";

#include "dtr.h"
#include "dtr_ui.h"

extern  dtr_mainWindow_objects *dtr_mainWindow;


/*
 * Time handler.  Entered whenever it is time to do both
 * VUMeter updating and update button glowing.
 */
Notify_value
  VUMeterTimerHandler(client, which)
Notify_client client;
int           which;
{
  EVENT("VUMeter_Timer_Handler");
  
  if (ActiveFlag & PLAY)
    UpdateVUMeter();
  return(NOTIFY_DONE);
}

/*
 * Set a periodic timer to poll for device open availability.  This
 * timer is mainly for updating both the VUMeter and the button glow.
 */
void
  SetVUMeterTimer(time)
double time;
{
  static     struct itimerval	timer;
  int			secs;
  int			usecs;
  
  EVENT("Set_VUMeter_Timer");
  
  secs = (int)time;
  usecs = (int)((time - (double)secs) * 1000000.);
  
  timer.it_value.tv_usec = usecs;
  timer.it_value.tv_sec = secs;
  timer.it_interval.tv_usec = usecs;
  timer.it_interval.tv_sec = secs;
  (void) notify_set_itimer_func((Notify_client)dtr_mainWindow, 
				(Notify_func)VUMeterTimerHandler,
				ITIMER_REAL, &timer, 
				((struct itimerval *)0));
}

/* 
 * Cancel any outstanding periodic timer.  This is used for
 * cancelling the timer which updates the VUMeter.
 */
void
  CancelVUMeterTimer()
{
  EVENT("Cancel_VUMeter_Timer");
  
  (void) notify_set_itimer_func((Notify_client)dtr_mainWindow, 
				(Notify_func)VUMeterTimerHandler,
				ITIMER_REAL, 
				((struct itimerval *)0), 
				((struct itimerval *)0));
}


/*
 * Button glow Time handler.  Entered whenever it is time to make the button glow.
 */
Notify_value
  ButtonGlowTimerHandler(client, which)
Notify_client client;
int           which;
{
  EVENT("Button_Glow_Timer_Handler");
  
  UpdateButtonGlow();
  return(NOTIFY_DONE);
}

/*
 * Set a periodic timer to poll for device open availability.  This
 * timer is mainly for updating the Button glow.
 */
void
  SetButtonGlowTimer(time)
double time;
{
  static  struct itimerval	timer;
  int			secs;
  int			usecs;
  extern  dtr_editListPanelPopUp_objects *dtr_editListPanelPopUp;
  
  EVENT("Set_Button_Glow_Timer");
  
  secs = (int)time;
  usecs = (int)((time - (double)secs) * 1000000.);
  
  timer.it_value.tv_usec = usecs;
  timer.it_value.tv_sec = secs;
  timer.it_interval.tv_usec = usecs;
  timer.it_interval.tv_sec = secs;
  (void)notify_set_itimer_func((Notify_client)dtr_editListPanelPopUp, /*  EditListPanel  used as a dummy client to be...  */
			       (Notify_func)ButtonGlowTimerHandler, /*  ...notified.                                    */
			       ITIMER_REAL, &timer, 
			       ((struct itimerval *)0));
}

/* 
 * Cancel any outstanding periodic timer.  This is used for
 * cancelling the timer which updates the button color.
 */
void
  CancelButtonGlowTimer()
{
  extern  dtr_editListPanelPopUp_objects *dtr_editListPanelPopUp;

  EVENT("Cancel_Button_Glow_Timer");
  
  (void)notify_set_itimer_func((Notify_client)dtr_editListPanelPopUp, /*  editListPanelPopUp is used as a dummy to be...  */
			       (Notify_func)ButtonGlowTimerHandler, /*  ...notified.                                    */
			       ITIMER_REAL, 
			       ((struct itimerval *)0), 
			       ((struct itimerval *)0));
}

