/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/DTR/RCS/gbcanvas.c,v 1.10 92/01/09 12:42:06 drapeau Exp Locker: derek $ */
/* $Log:	gbcanvas.c,v $
 * Revision 1.10  92/01/09  12:42:06  drapeau
 * Slight modifications to the code to make it ANSI-compliant.
 * 
 * Revision 1.0  92/01/06  17:55:07  drapeau
 * Made a number of cosmetic changes to make code easier to read and
 * to conform to programming specifications.
 * 
 * Revision 0.20  91/09/18  22:47:25  derek
 * The following things are done:
 * 1.	The Makefile is changed corresponding to the changes in collab/.
 * 2.	Copyright messages included.
 * 3.	Some minor bugs fixed.
 * 
 * Revision 0.19  91/08/27  18:06:05  derek
 * The SizeToFit bug is fixed.
 * 
 * Revision 0.18  91/08/21  11:34:18  derek
 * The following changes are made:
 * 1.	Now the duration and size of the recorded sound will be displayed
 * 	during recording.
 * 2.	I have changed GetSelection() corresponding to the request of Tek joo
 * 3.	Info Panel is added to the application.
 * 4.	Fixed SizeToFitHandler() so that when no file or buffer is currently
 * 	loaded, it would not do anything (except giving a warning
 * 	notice_prompt).
 * 5.	Inplemented the `Close' Menu option in the document menu.
 * 6.	Fixed the bug in which after ClearAll and I press PreviewEdit,
 * 	the edit wont be played.
 * 7.	I have made the changes corresponding to the change in OpenPanel's
 * 	name.  (from OpenPanel to Browse).
 * 8.	Incorporated BrowseCheck to check command line arg.
 * 9.	Changed most EditingStatusMessages to NoticePrompts.
 * 10.	SoundFileSaveAsPopUp and EditListSaveAsPopUp are removed 
 * 	from the application.
 * 
 * Revision 0.17  91/08/08  21:44:37  derek
 * Fixed a number of bugs.
 * 
 * Revision 0.16  91/08/08  11:02:12  derek
 * This is a cleaner version.  I have removed lots of printf/fprintf 
 * statements from it, and have also cleaned up the code using xsaber.
 * This version should run substantially faster.
 * 
 * Revision 0.15  91/08/07  16:24:15  derek
 * The Edit list part of DTR is done.  OpenPanel is also incorporated.
 * 
 * Revision 0.14  91/07/23  21:22:48  derek
 * This version is not ready for release.  Disk space editing is half-done:
 * the application can play an infinite sound and the canvases can handle
 * infinite sound files.  The app is pretty bug free too, I think.  The
 * weakness is that it cannot record sond infinitely.
 * 
 * Revision 0.13  91/06/26  15:55:07  derek
 * I have reformatted the code to conform coding specs.
 * 
 * Revision 0.12  91/06/20  20:00:42  derek
 * The network part should be working.  Also fixed a number of bugs involving
 * canvases and display.
 * 
 * Revision 0.11  91/06/05  14:59:53  derek
 * checking in after porting the code to collab
 * 
 * Revision 0.10  1991/04/25  01:48:26  derek
 * This version is checked in on 4/24/91
 * */
static char rcsid[] = "$Header: /Source/Media/collab/DTR/RCS/gbcanvas.c,v 1.10 92/01/09 12:42:06 drapeau Exp Locker: derek $";

#include "dtr.h"
#include "dtr_ui.h"

/*
 * Various Windows.
 */
extern  dtr_globalWaveCanvasPopUp_objects    *dtr_globalWaveCanvasPopUp;

/*
 * Global variables for Global Wave Canvas;
 */
Window     	xidGbWave;
Xv_Window  	paintWinGbWave;
Display    	*dpyGbWave;
GC         	gcGbWave;
unsigned long *	GlobalWaveCanvasColormap;

extern 	int	ScrollbarViewStart;
extern	int	ScrollbarViewEnd;


void
  InitGlobalWaveCanvas()
{
  Xv_opaque       gwcanvas = dtr_globalWaveCanvasPopUp->globalWaveCanvas;
  
  EVENT("Init_Global_Wave_Canvas");
  
  paintWinGbWave = canvas_paint_window(gwcanvas);
  xidGbWave = (Window) xv_get(paintWinGbWave, XV_XID);
  dpyGbWave = (Display *) xv_get(gwcanvas, XV_DISPLAY);
  gcGbWave = XCreateGC(dpyGbWave, xidGbWave, 0, 0);
  
  xv_set(paintWinGbWave, WIN_CONSUME_EVENTS, WIN_NO_EVENTS,	    /*  Specifies that only the left- and the right-... */
	 WIN_ASCII_EVENTS,					    /*  ...button events will be registered, in fact... */
	 LOC_DRAG, MS_LEFT,					    /*  ...useless because middle button events will... */
	 MS_MIDDLE, NULL, NULL);				    /*  ...anyways.                                     */
  
  GlobalWaveCanvasColormap = GetColormap(gwcanvas);		    /*  Get Colormap.                                   */
  XSetForeground(dpyGbWave, gcGbWave, 
		 GetColorIndex(GlobalWaveCanvasColormap, "White"));
  
  oldLeftFloatGbWaveMarker = -1.0;				    /*  Init left and right wave canvas markers.        */
  oldRightFloatGbWaveMarker = -1.0;
  GlobalWaveCanvasRightMarkerSet = FALSE;
  
  GlobalWaveCanvasWidth = (int) xv_get(gwcanvas, CANVAS_WIDTH, NULL);
  GlobalWaveCanvasHeight = (int) xv_get(gwcanvas, CANVAS_HEIGHT, NULL);
  GlobalWaveWindowWidth = (int) xv_get(gwcanvas, XV_WIDTH, NULL);
  GlobalWaveWindowHeight = (int) xv_get(gwcanvas, XV_HEIGHT, NULL);
  GlobalWaveCanvasMidHeight = GlobalWaveCanvasHeight/2;
  GlobalWaveScopeWidth = GlobalWaveCanvasMidHeight - 4;
  GlobalWaveCanvasInitReady = TRUE;
  GbWaveLeftButtonHoldPoint = NOTREADY;
}								    /* end function InitGlobalWaveCanvas */


void
  RepaintGlobalWaveCanvas()
{
  EVENT("Repaint_Global_Wave_Canvas");
  
  GlobalWaveCanvasRepaintHandler(
				 (Canvas)dtr_globalWaveCanvasPopUp->globalWaveCanvas,
				 paintWinGbWave, 
				 (Display *)dpyGbWave,
				 xidGbWave, NULL);
}


/*
 *  Clear Wave Canvas, reset the scrollbars.
 */
void
  ResetGlobalWaveCanvas()
{
  ClearGlobalWaveCanvas();					    /*  Clear Global Wave Canvas.                       */
  oldLeftFloatGbWaveMarker = oldRightFloatGbWaveMarker = -1.0;	    /*  Reset Various Selection Parameters.             */
  GlobalWaveCanvasRightMarkerSet = FALSE;
  GbWaveLeftButtonHoldPoint = NOTREADY;
}



void
  ClearGlobalWaveCanvas()
{
  extern   GC gcGbWave;
  
  XClearWindow(dpyGbWave, xidGbWave);
  XSetForeground(dpyGbWave, gcGbWave, 
		 GetColorIndex(GlobalWaveCanvasColormap, "White"));
  XDrawLine(dpyGbWave, xidGbWave, gcGbWave, 0, GlobalWaveCanvasMidHeight,
	    GlobalWaveCanvasWidth-1, GlobalWaveCanvasMidHeight);
  
  oldLeftFloatGbWaveMarker = oldRightFloatGbWaveMarker = 0.0;	    /*  Clear Markers.                                  */
}


/*
 *  Check if the user has clicked the mouse at a place outside
 *  the scope of the soundbuffer.
 */
BOOL
  GlobalWaveCanvasOutOfSoundScope(winX)
int winX;
{
  int bufferX;
  
  if (GlobalWaveCanvasDataSamplingInterval == 0.0)
    return (TRUE);
  
  bufferX = irint(winX * GlobalWaveCanvasDataSamplingInterval);
  
  if (bufferX > Buffer.hdr.data_size || bufferX < 0)
    return(TRUE);
  return(FALSE);
}


void
  GlobalWaveCanvasMarkerHandler(winX, oldmarker)
int winX;
double *oldmarker;
{
  int     oldLeftWinX, oldRightWinX, LeftWinX, RightWinX;
  
  EVENT("Global_Wave_Canvas_Marker_Handler");
  
  if (GlobalWaveCanvasOutOfSoundScope(winX))
    return;
  
  oldLeftWinX = irint( oldLeftFloatGbWaveMarker /		    /*  Save old markers.                               */
		      GlobalWaveCanvasDataSamplingInterval );
  oldRightWinX = irint( oldRightFloatGbWaveMarker / 
		       GlobalWaveCanvasDataSamplingInterval );
  
  if (oldmarker == &oldLeftFloatGbWaveMarker)			    /*  Left button or right button pressed.            */
  {
    oldLeftFloatGbWaveMarker = oldRightFloatGbWaveMarker = 
      winX * GlobalWaveCanvasDataSamplingInterval;
  } 
  else
  {
    oldRightFloatGbWaveMarker = winX * 
      GlobalWaveCanvasDataSamplingInterval;
  }
  
  LeftWinX = irint( oldLeftFloatGbWaveMarker /			    /*  Draw Markers.                                   */
		   GlobalWaveCanvasDataSamplingInterval );
  RightWinX = irint( oldRightFloatGbWaveMarker / 
		    GlobalWaveCanvasDataSamplingInterval );
  
  if (!GlobalWaveCanvasRightMarkerSet && oldmarker == &oldRightFloatGbWaveMarker)
    ReverseGlobalWaveCanvasArea(winX, winX);
  
  if (LeftWinX > oldRightWinX || RightWinX < oldLeftWinX) 
  {      
    if (GlobalWaveCanvasRightMarkerSet)
    {
      ReverseGlobalWaveCanvasArea(oldLeftWinX, oldRightWinX);
      if (oldmarker == &oldLeftFloatGbWaveMarker)
	ReverseGlobalWaveCanvasArea(winX, winX);
    }
  }
  else if (GlobalWaveCanvasRightMarkerSet)
  {
    if (LeftWinX > oldLeftWinX /***&& oldLeftWinX != 0 ***/)
    {
      ReverseGlobalWaveCanvasArea(oldLeftWinX, LeftWinX-1);
    } 
    else if (LeftWinX < oldLeftWinX)
    {
      ReverseGlobalWaveCanvasArea(LeftWinX, oldLeftWinX-1);
    }
    
    if (RightWinX > oldRightWinX)
    {
      ReverseGlobalWaveCanvasArea(oldRightWinX + 1, RightWinX);
    } 
    else if (RightWinX < oldRightWinX)
    {
      ReverseGlobalWaveCanvasArea(RightWinX + 1, oldRightWinX);
    }
  }
  
  if (oldmarker == &oldRightFloatGbWaveMarker)
    GlobalWaveCanvasRightMarkerSet = TRUE;
  
  Buffer.play.start = irint(oldLeftFloatGbWaveMarker);		    /*  Update start and end points.                    */
  Buffer.play.end = irint(oldRightFloatGbWaveMarker);
  
  UpdateMessageDisplay();					    /*  Update message display (sound selection size... */
								    /*  ...and duration etc.)                           */
}								    /* end function GlobalWaveCanvasMarkerHandler */


/*
 *  Takes cares of case when user tries to drag leftwards (instead of 
 *  rightwards).
 */
void
  GlobalWaveCanvasBackwardMarkerHandler(winX, oldmarker)
int  winX;
double *oldmarker;
{
  int     oldLeftWinX, oldRightWinX, LeftWinX, RightWinX;
  
  EVENT("Global_Wave_Canvas_Backward_Marker_Handler");
  
  if (GlobalWaveCanvasOutOfSoundScope(winX))
    return;
  
  oldLeftWinX = irint( oldLeftFloatGbWaveMarker /		    /*  Save old markers.                               */
		      GlobalWaveCanvasDataSamplingInterval );
  oldRightWinX = irint( oldRightFloatGbWaveMarker / 
		       GlobalWaveCanvasDataSamplingInterval );
  
  if (oldmarker == &oldLeftFloatGbWaveMarker)			    /*  Left button or right button pressed.            */
  {
    oldLeftFloatGbWaveMarker = winX * 
      GlobalWaveCanvasDataSamplingInterval;
  } 
  
  LeftWinX = irint( oldLeftFloatGbWaveMarker /			    /*  Draw markers.                                   */
		   GlobalWaveCanvasDataSamplingInterval );
  RightWinX = irint( oldRightFloatGbWaveMarker / 
		    GlobalWaveCanvasDataSamplingInterval );
  
  if (!GlobalWaveCanvasRightMarkerSet && oldmarker == 
      &oldRightFloatGbWaveMarker)
    ReverseGlobalWaveCanvasArea(winX, winX);
  
  if (LeftWinX > oldRightWinX || RightWinX < oldLeftWinX)
  {
    if (GlobalWaveCanvasRightMarkerSet)
      ReverseGlobalWaveCanvasArea(oldLeftWinX, oldRightWinX);
    if (oldmarker == &oldLeftFloatGbWaveMarker)
      ReverseGlobalWaveCanvasArea(winX, winX);
  }
  else if (GlobalWaveCanvasRightMarkerSet)
  {
    if (LeftWinX > oldLeftWinX && oldLeftWinX != 0)
    {
      ReverseGlobalWaveCanvasArea(oldLeftWinX, LeftWinX-1);
    } 
    else if (LeftWinX < oldLeftWinX)
    {
      ReverseGlobalWaveCanvasArea(LeftWinX, oldLeftWinX-1);
    }
    
    if (RightWinX > oldRightWinX)
    {
      ReverseGlobalWaveCanvasArea(oldRightWinX + 1, RightWinX);
    } 
    else if (RightWinX < oldRightWinX)
    {
      ReverseGlobalWaveCanvasArea(RightWinX + 1, oldRightWinX);
    }
  }
  
  GlobalWaveCanvasRightMarkerSet = TRUE;
  
  Buffer.play.start = irint(oldLeftFloatGbWaveMarker);		    /*  Update start and end points.                    */
  Buffer.play.end = irint(oldRightFloatGbWaveMarker);
  
  UpdateMessageDisplay();					    /*  update message display (sound selection size... */
								    /*  ...and duration).                               */
}								    /* end function GlobalWaveCanvasBackwardMarkerHandler */


/*
 *  Set Foreground color of GlobalWave canvas.
 */
void
  GlobalWaveCanvasPenColor(colorStr)
char *colorStr;
{
  XSetForeground(dpyGbWave, gcGbWave, 
		 GetColorIndex(GlobalWaveCanvasColormap, colorStr));
}


/*
 *  This function is called when user selects "Reset Markers"
 *  from the function menu.
 */
void
  ResetGlobalWaveCanvasMarkers()
{
  EVENT("Reset_Global_Wave_Canvas_Markers");
  
  ReverseGlobalWaveCanvasArea(
			      irint(oldLeftFloatGbWaveMarker/
				    GlobalWaveCanvasDataSamplingInterval),
			      irint(oldRightFloatGbWaveMarker/
				    GlobalWaveCanvasDataSamplingInterval));
  GlobalWaveCanvasRightMarkerSet = FALSE;
  GbWaveLeftButtonHoldPoint = NOTREADY;
  UpdateMessageDisplay();
  Buffer.play.start = 0;
  Buffer.play.end = Buffer.hdr.data_size - 1;
}


/*
 *  For Highlighting or Unhighlighting a portion of the canvas.
 */
void
  ReverseGlobalWaveCanvasArea(left, right)
int  left, right;
{
  XSetFunction(dpyGbWave, gcGbWave, GXinvert);
  XFillRectangle(dpyGbWave, xidGbWave, gcGbWave, 
		 left, 0,
		 right - left + 1, GlobalWaveWindowHeight - 1);
  XSetFunction(dpyGbWave, gcGbWave, GXcopy);
}


/*
 *  This routine takes care of the local wave canvas frame within
 *  the global wave canvas.
 */
void
  UpdateCanvasFrame()
{
  int                   newViewStart;
  int		        newViewEnd;
  extern        int     ScrollbarPixelsPerUnit;
  extern Scrollbar      WaveCanvasScrollbar;
  
  XSetFunction(dpyGbWave, gcGbWave, GXxor);
  GlobalWaveCanvasPenColor("red");
  
  XDrawLine(dpyGbWave, xidGbWave, gcGbWave, 
	    ScrollbarViewStart, 0+5, 
	    ScrollbarViewStart, WaveWindowHeight-1-8);
  XDrawLine(dpyGbWave, xidGbWave, gcGbWave,
	    ScrollbarViewEnd, 0+5, 
	    ScrollbarViewEnd, WaveWindowHeight-1-8);
  XDrawLine(dpyGbWave, xidGbWave, gcGbWave,
	    ScrollbarViewStart, 0+5, 
	    ScrollbarViewEnd, 0+5);
  XDrawLine(dpyGbWave, xidGbWave, gcGbWave,
	    ScrollbarViewStart, WaveWindowHeight-1-8,
	    ScrollbarViewEnd, WaveWindowHeight-1-8);
  
  newViewStart = irint((FrameStartingSecond / 10.0) *
		       WaveCanvasWidth +
		       (ScrollbarPixelsPerUnit *
			xv_get(WaveCanvasScrollbar, SCROLLBAR_VIEW_START)));
  
  newViewEnd = newViewStart + WaveWindowWidth - 1;
  
  ScrollbarViewStart = irint(newViewStart * WaveCanvasDataSamplingInterval
			     / GlobalWaveCanvasDataSamplingInterval);
  ScrollbarViewEnd = irint(newViewEnd * WaveCanvasDataSamplingInterval
			   / GlobalWaveCanvasDataSamplingInterval);
  
  XDrawLine(dpyGbWave, xidGbWave, gcGbWave, 
	    ScrollbarViewStart, 0+5, 
	    ScrollbarViewStart, WaveWindowHeight-1-8);
  XDrawLine(dpyGbWave, xidGbWave, gcGbWave,
	    ScrollbarViewEnd, 0+5, 
	    ScrollbarViewEnd, WaveWindowHeight-1-8);
  XDrawLine(dpyGbWave, xidGbWave, gcGbWave,
	    ScrollbarViewStart, 0+5, 
	    ScrollbarViewEnd, 0+5);
  XDrawLine(dpyGbWave, xidGbWave, gcGbWave,
	    ScrollbarViewStart, WaveWindowHeight-1-8,
	    ScrollbarViewEnd, WaveWindowHeight-1-8);
  
  XSetFunction(dpyGbWave, gcGbWave, GXcopy);
}								    /* end function UpdateCanvasFrame */

void
  DisplayCanvasFrame()
{
  extern   Scrollbar     WaveCanvasScrollbar;
  extern   int           ScrollbarPixelsPerUnit;
  int                    frameStart;
  int                    frameEnd;
  
  XSetFunction(dpyGbWave, gcGbWave, GXxor);
  GlobalWaveCanvasPenColor("red");
  
  frameStart = ScrollbarPixelsPerUnit * 
    xv_get(WaveCanvasScrollbar, SCROLLBAR_VIEW_START, NULL);
  frameEnd = frameStart + WaveWindowWidth-1;
  
  if (GlobalWaveCanvasDataSamplingInterval != 0.0)
  {
    ScrollbarViewStart = irint(frameStart * WaveCanvasDataSamplingInterval
			       / GlobalWaveCanvasDataSamplingInterval);
    ScrollbarViewEnd = irint(frameEnd * WaveCanvasDataSamplingInterval
			     / GlobalWaveCanvasDataSamplingInterval);
  }
  else
  {
    ScrollbarViewStart = 0;
    ScrollbarViewEnd = 0;
  }
  
  XDrawLine(dpyGbWave, xidGbWave, gcGbWave, 
	    ScrollbarViewStart, 0+5, 
	    ScrollbarViewStart, WaveWindowHeight-1-8);
  XDrawLine(dpyGbWave, xidGbWave, gcGbWave,
	    ScrollbarViewEnd, 0+5, 
	    ScrollbarViewEnd, WaveWindowHeight-1-8);
  XDrawLine(dpyGbWave, xidGbWave, gcGbWave,
	    ScrollbarViewStart, 0+5, 
	    ScrollbarViewEnd, 0+5);
  XDrawLine(dpyGbWave, xidGbWave, gcGbWave,
	    ScrollbarViewStart, WaveWindowHeight-1-8,
	    ScrollbarViewEnd, WaveWindowHeight-1-8);
  
  XSetFunction(dpyGbWave, gcGbWave, GXcopy);
}    

