/*******************************************************************************
+
+  LEDA  3.0
+
+
+  _slist.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#include <LEDA/impl/slist.h>

//------------------------------------------------------------------------------
// Members of class SLIST
//------------------------------------------------------------------------------

SLIST::SLIST()      
{ h=0; 
  t=0;
  count=0;
  iterator=0; 
}

SLIST::SLIST(GenPtr a) 
{ h=t=new slink(a,0);
  count=1; 
  iterator=0;  
}

SLIST::SLIST(const SLIST& x)
{ slink* p = x.h;
  h=0; 
  t=0; 
  count=0; 
  iterator=0;
  while (p) { append(p->e);     //copy new list
              p = p->succ;}
}

GenPtr SLIST::pop()    
{ if (iterator!=0) error_handler(1,"pop: deletion while iterator is active");
  GenPtr res;
  if (h) 
  { if (t==h) t = 0;
    slink* x=h; 
    res = x->e;
    h=x->succ; 
    delete x;
    count--;
   }
  return res;
}

slink* SLIST::insert(GenPtr a, slink* p)   
{ if (iterator!=0) 
         error_handler(2,"insert: insertion while iterator is active");
  count++;
  p->succ = new slink(a,p->succ); 
  if (t==p) t = p->succ;
  return h;
}


slink* SLIST::cyclic_succ(slink* loc) const
{ if (loc==0) return 0;
  return loc->succ? loc->succ : h;
 }

SLIST& SLIST::operator=(const SLIST& x)
{ iterator=0;
  clear();
  slink* p = x.h;
  while (p) 
  { append(p->e);
    x.copy_el(p->e);
    p = p->succ;
   }
  return *this;
 }

void SLIST::clear()
{ if (h==0) return;
  for (slink* p = h; p; p = p->succ) clear_el(p->e);
  deallocate_list(h,t,sizeof(slink));
  iterator=h=t=0;
  count=0;
 }
