/*******************************************************************************
+
+  LEDA  3.0
+
+
+  queue.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_QUEUE_H
#define LEDA_QUEUE_H

//------------------------------------------------------------------------------
// queue                                                                
//------------------------------------------------------------------------------

#include <LEDA/basic.h>

#ifndef SLISTH
#include <LEDA/impl/slist.h>
#endif



template<class type>

struct _CLASSTYPE queue : SLIST
{
  void copy_el(GenPtr& x)  const { x=Copy(ACCESS(type,x)); }
  void clear_el(GenPtr& x) const { Clear(ACCESS(type,x)); }

  queue() {}
  queue(const queue& Q) : SLIST(Q) {}
 ~queue() { clear(); }

  void append(type x) { SLIST::append(Convert(x)); }
  type top()   const  { return ACCESS(type,SLIST::head()); }
  type pop()          { type x=top(); SLIST::pop(); return x; }
  int  size()  const  { return SLIST::length(); }
  int  empty() const  { return SLIST::empty(); }
  void clear()        { SLIST::clear(); }

  queue& operator=(const queue& Q) { return (queue&)SLIST::operator=(Q); }
};

#endif
