/*******************************************************************************
+
+  LEDA  3.0
+
+
+  slist.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_SLIST_H
#define LEDA_SLIST_H

//------------------------------------------------------------------------------
// simply linked lists
//------------------------------------------------------------------------------


#include <LEDA/basic.h>


class SLIST; 
class slink;

typedef slink* slist_item;

//------------------------------------------------------------------------------
// class slink 
//------------------------------------------------------------------------------

class slink {

  friend class SLIST;

  slink* succ;
  GenPtr e;

  slink(GenPtr a, slink* suc) { e = a; succ = suc; }

  LEDA_MEMORY(slink)

};


//------------------------------------------------------------------------------
// SLIST: base class for all simply linked Lists
//------------------------------------------------------------------------------

class SLIST {

   slink* h;                     //head
   slink* t;                     //tail
   slink* iterator;              //iterator;
   int    count;                 //length of List

virtual void clear_el(GenPtr&) const {}
virtual void copy_el(GenPtr&)  const {}

public:

   int space()  const { return sizeof(SLIST) + count * sizeof(slink); }
   int length() const { return count; }
   int empty()  const { return (count==0);}

   slink* insert(GenPtr, slink*);

   slink* push(GenPtr a)   
   { count++;
     h = new slink(a,h); 
     if (t==0) t = h;
     return h;
   }

   slink* append(GenPtr a)
   { count++;
     if (t) t = t->succ = new slink(a,0); 
     else   t = h = new slink(a,0); 
     return t;
   } 

   slink* first() const { return h; }
   slink* last()  const { return t; }

   slink* get_iterator()  const { return iterator; }

   void   set_iterator(slink* loc) const 
   { const slist_item *const p = &iterator;  
     (*(slink**)p) = loc;
    }

   void init_iterator()  const { set_iterator(0); }

   slink* move_iterator() const  
   { set_iterator( iterator ? iterator->succ : h);
     return iterator;
   } 

   slink* cyclic_succ(slink*) const;
   slink* succ(slink* l)      const { return l->succ; }

   GenPtr head()   const { return h ? h->e : 0;}
   GenPtr tail()   const { return t ? t->e : 0;}
   GenPtr pop();

   bool current_element(GenPtr& x)  const
   { if (!iterator) return false;
     else { x = iterator->e;
            return true; }
    }

   bool next_element(GenPtr& x) const 
  { move_iterator(); 
    return current_element(x); 
   }

   GenPtr  contents(slink* l)  const  { return l->e; }
   GenPtr& entry(slink* l)            { return l->e; }
   GenPtr& operator[](slink* l)       { return l->e; }
   GenPtr  operator[](slink* l) const { return l->e; }

   void clear();

   SLIST();    
   SLIST(GenPtr a);
   SLIST& operator=(const SLIST&); 
   SLIST(const SLIST&);
   virtual ~SLIST()     { clear(); }
};


//------------------------------------------------------------------------------
// slist: generic SLISTs
//-----------------------------------------------------------------------------


template <class type>

class _CLASSTYPE slist : public SLIST {

type X;

int  cmp_el(GenPtr x, GenPtr y) const
                             { return compare(ACCESS(type,x),ACCESS(type,y));}
void print_el(GenPtr& x,ostream& out) const { Print(ACCESS(type,x),out);  }
void read_el(GenPtr& x,istream& in)         { Read(X,in); x = Copy(X); }
void clear_el(GenPtr& x)              const { Clear(ACCESS(type,x)); }
void copy_el(GenPtr& x)               const { x = Copy(ACCESS(type,x)); }

public:

slink* push(type a)             { return SLIST::push( Convert(a) ); }
slink* push(slist& l)           { return SLIST::push((SLIST&)l); }
slink* append(type a)           { return SLIST::append( Convert(a) ); }
slink* append(slist& l)         { return SLIST::append((SLIST&)l); }
slink* insert(type a, slink* l) { return SLIST::insert(Convert(a),l); }

bool current_element(type& x) const {GenPtr y; bool b=SLIST::current_element(y);
                                     if (b) x = ACCESS(type,y); return b; }
bool next_element(type& x) const { GenPtr y; bool b = SLIST::next_element(y);
                                   if (b) x = ACCESS(type,y); return b; }

type head()             const { return ACCESS(type,SLIST::head() ); }
type tail()             const { return ACCESS(type,SLIST::tail() ); }
type pop()                    { type a = head(); 
                                clear_el(SLIST::pop()); 
                                return a;
                               }
type contents(slink* l) const { return ACCESS(type,SLIST::contents(l)); }
type inf(slink* l)      const { return ACCESS(type,SLIST::contents(l)); }

   slist() { }
   slist(const slist& a) : SLIST((SLIST&)a) { }
   slist(type a) : SLIST(Convert(a)) { }
   ~slist() {}

   slist& operator=(const slist& a)
           { SLIST::operator=(a);  return *this; }
   slist operator+(slist a)
           {return (slist&)(SLIST(*this) + a); }
   slink* operator+=(type x)  { return append(x); }
   slink* operator&=(type x)  { return push(x); }
   type& operator[](slink* l) { return ACCESS(type,SLIST::entry(l)); }
};


#endif
