/*******************************************************************************
+
+  LEDA  3.0
+
+
+  dictionary.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_DICTIONARY_H
#define LEDA_DICTIONARY_H

#include <LEDA/basic.h>
#include <LEDA/impl/rs_tree.h>     // default implementation: rs_tree

typedef rst_item dic_item;



template <class ktype, class itype> 

class _CLASSTYPE dictionary : public rs_tree 
{

int  int_type()              const { return INT_TYPE(ktype); }
int  cmp(GenPtr x, GenPtr y) const
                          { return compare(ACCESS(ktype,x),ACCESS(ktype,y)); }
void clear_key(GenPtr& x) const { Clear(ACCESS(ktype,x)); }
void clear_inf(GenPtr& x) const { Clear(ACCESS(itype,x)); }
void copy_key(GenPtr& x)  const { x=Copy(ACCESS(ktype,x)); }
void copy_inf(GenPtr& x)  const { x=Copy(ACCESS(itype,x)); }

public:

virtual dic_item lookup(ktype x) const
{ return rs_tree::lookup(Convert(x));}
virtual int      defined(ktype x) const { return (lookup(x)) ? false : true; }

virtual void     change_inf(dic_item it, itype i)
{ rs_tree::change_inf(it,Convert(i)); }

virtual dic_item insert(ktype x,itype y)
{ return rs_tree::insert(Convert(x),Convert(y)); } 

virtual void  del(ktype x)          { rs_tree::del(Convert(x)); } 
virtual void  del_item(dic_item it) { rs_tree::del_item(it); } 

virtual ktype key(dic_item it) const { return ACCESS(ktype,rs_tree::key(it));}
virtual itype inf(dic_item it) const { return ACCESS(itype,rs_tree::inf(it));}
virtual itype access(ktype k)  const { return inf(lookup(k));}

virtual int      size()  const { return rs_tree::size(); }
virtual bool     empty() const { return (size()==0) ? true : false; }
virtual dic_item first_item() const { return rs_tree::first_item(); }
virtual dic_item next_item(dic_item it) const { return rs_tree::next_item(it);}

dictionary& operator=(const dictionary& D)
{ return (dictionary&)rs_tree::operator=(D); }
         
dictionary() {}

dictionary(const dictionary& D) : rs_tree(D) {}

virtual ~dictionary()   { rs_tree::clear(); }
};


//------------------------------------------------------------------------------
//
// Dictionaries with implementation parameter:
//
//   _dictionary<keytype,inftype,dic_impl> 
//
//------------------------------------------------------------------------------

#define _dictionary_class(ktype,itype,impl)\
\
class _CLASSTYPE _dict_(ktype,itype,impl) : public impl, public dictionary<ktype,itype>\
{\
\
int int_type() const { return INT_TYPE(ktype); }\
\
int cmp(GenPtr x, GenPtr y) const\
{ return compare(ACCESS(ktype,x),ACCESS(ktype,y)); }\
void clear_key(GenPtr& x) const { Clear(ACCESS(ktype,x)); }\
void clear_inf(GenPtr& x) const { Clear(ACCESS(itype,x)); }\
void copy_key(GenPtr& x) const { x=Copy(ACCESS(ktype,x)); }\
void copy_inf(GenPtr& x) const { x=Copy(ACCESS(itype,x)); }\
void print_key(GenPtr x) const { Print(ACCESS(ktype,x),cout); }\
void print_inf(GenPtr x) const { Print(ACCESS(itype,x),cout); }\
\
public:\
\
dic_item lookup(ktype x) const { return dic_item(impl::lookup(Convert(x))); }\
int defined(ktype x) const { return (lookup(x)==nil) ? false : true; }\
\
void change_inf(dic_item it, itype i)\
{ impl::change_inf(impl::item(it),Convert(i));}\
\
dic_item insert(ktype x,itype y)\
{ return dic_item(impl::insert(Convert(x),Convert(y))); }\
\
void del(ktype x) { impl::del(Convert(x)); }\
void del_item(dic_item it) { impl::del_item(impl::item(it)); }\
ktype key(dic_item it) const { return ACCESS(ktype,impl::key(impl::item(it))); }\
itype inf(dic_item it) const { return ACCESS(itype,impl::inf(impl::item(it)));}\
\
int size() const { return impl::size(); }\
bool empty() const { return (size()==0) ? true : false; }\
dic_item first_item() const { return dic_item(impl::first_item()); }\
dic_item next_item(dic_item it) const { return dic_item(impl::next_item(impl::item(it))); }\
\
_dict_(ktype,itype,impl)& operator=(const _dict_(ktype,itype,impl)& D)\
{ return (_dict_(ktype,itype,impl)&)impl::operator=(D); }\
\
_dict_(ktype,itype,impl)() {}\
_dict_(ktype,itype,impl)(const _dict_(ktype,itype,impl)& D) : impl(D)\
{}\
~_dict_(ktype,itype,impl)() { impl::clear(); }

#if defined(__TEMPLATE_ARGS_AS_BASE__)
#define _dict_(a,b,c) _dictionary
template <class ktype, class itype, class impl> 
_dictionary_class(ktype,itype,impl)
};
#else
#define _dictionary(a,b,c)         name4(a,b,c,_dictionary)
#define _dict_(a,b,c)              name4(a,b,c,_dictionary)
#define _dictionarydeclare3(_a,_b,_c) _dictionary_class(_a,_b,_c) };
#endif


#endif
