/*******************************************************************************
+
+  LEDA  3.0
+
+
+  d2_dictionary.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



#ifndef LEDA_D2_DICTIONARY_H
#define LEDA_D2_DICTIONARY_H

#include <LEDA/impl/range_tree.h>


typedef range_tree_item dic2_item;



//--------------------------------------------------------------------
// 2-dim Dictionary
//--------------------------------------------------------------------


template<class type1, class type2, class itype>

struct _CLASSTYPE d2_dictionary : public range_tree {

void clear_key(GenPtr& x) const  { Clear(ACCESS(type1,(*(tuplep)x)[0]));
                                   Clear(ACCESS(type2,(*(tuplep)x)[1])); }

void clear_inf(GenPtr& x) const  { Clear(ACCESS(itype,(*(tuplep)x).info()));}

void copy_key(GenPtr& x)  const  { Copy(ACCESS(type1,(*(tuplep)x)[0]));
                                   Copy(ACCESS(type2,(*(tuplep)x)[1])); }

void copy_inf(GenPtr& x)  const  { Copy(ACCESS(itype,(*(tuplep)x).info()));}

int cmp_tuple_entry(int i,tuplep p, tuplep q) const 
{ if (i==1) return compare(ACCESS(type1,(*p)[0]),ACCESS(type1,(*q)[0]));
  else      return compare(ACCESS(type2,(*p)[1]),ACCESS(type2,(*q)[1]));
 }

range_tree* new_range_tree(int dim)
{ return new d2_dictionary<type1,type2,itype>(dim); }

itype inf(dic2_item x)    { return ACCESS(itype,x->info());}

type1 key1(dic2_item x)   { return ACCESS(type1,(*x)[0]);  }
type2 key2(dic2_item x)   { return ACCESS(type2,(*x)[1]);  }


void  change_inf(dic2_item x, itype i) { Clear(ACCESS(itype,x->info()));
                                         x->info() = Copy(i); }

dic2_item min_key1()       { return range_tree::min(1); }
dic2_item max_key1()       { return range_tree::max(1); }
dic2_item min_key2()       { return range_tree::min(2); }
dic2_item max_key2()       { return range_tree::max(2); }


dic2_item insert(type1 x,type2 y,itype i)
{ tuplep p = new tuple(Copy(x),Copy(y));
  p->info() = Copy(i);
  return range_tree::insert_tuple(p);
 }

void del(type1 x,type2 y)
{ tuple p(Convert(x),Convert(y));
  range_tree::del(&p);
 }

void del_item(dic2_item it)
{ range_tree::del(it);
 }

list<dic2_item> all_items()
{ list<range_tree_item> L = all_tuples();
  return *(list<dic2_item>*)&L;
 }

list<dic2_item> range_search(type1 x0,type1 x1,type2 y0,type2 y1)
{ list<range_tree_item> L;
  tuple p(Convert(x0),Convert(y0));
  tuple q(Convert(x1),Convert(y1));
  range_tree::query_tuples(&p,&q,L);
  return *(list<dic2_item>*)&L;
 }

dic2_item lookup(type1 x,type2 y)
{ tuple q(Convert(x),Convert(y));
  q.set_cmp(1);
  bb_tree_item p=rm_tree::lookup(&q);
  dic2_item r = ( p ? key(p) : 0);
  return r;
 }

 list<dic2_item> L;

 void init_iteration() { L = all_items(); }

 d2_dictionary(int dim = 2) : range_tree(dim) { }

virtual ~d2_dictionary() { clear(); }

};


// --------------------------------------------------------------------
// iteration
// --------------------------------------------------------------------

#define forall_dic2_items(x,T)  (T).init_iteration(); forall(x,(T).L )


#endif
