.\" @(#)writedir.3t	1.3 5/15/90
.\"
.\" Copyright (c) 1990 by Sam Leffler.
.\" All rights reserved.
.\"
.\" This file is provided for unrestricted use provided that this
.\" legend is included on all tape media and as a part of the
.\" software program in whole or part.  Users may copy, modify or
.\" distribute this file at will.
.\"
.TH TIFFWriteDirectory 3T "May 2, 1990"
.SH NAME
TIFFWriteDirectory \- write the current directory in an open
.SM TIFF
file
.SH SYNOPSIS
.B "#include <tiffio.h>"
.br
.B "int TIFFWriteDirectory(TIFF* tif)"
.SH DESCRIPTION
Write the contents of the current directory to the file and setup
to create a new subfile in the same file.
Applications only need to call
.IR TIFFWriteDirectory ()
when writing multiple subfiles to a single
.SM TIFF
file.
.IR TIFFWriteDirectory ()
is automatically called by
.IR TIFFClose ()
to write a modified directory if the file is open for writing.
.SH DIAGNOSTICS
All error messages are directed to the
.IR TIFFError (3T)
routine.
.PP
.BR "Error flushing data before directory write" .
Before writing the contents of the current directory, any pending
data are flushed.
This message indicates that an error occurred while doing this.
.PP
.BR "Cannot write directory, out of space" .
There was not enough space to allocate a temporary area for
the directory that was to be written.
.SH "SEE ALSO"
.IR intro (3T),
.IR TIFFOpen (3T),
.IR TIFFError (3T),
.IR TIFFReadDirectory (3T),
.IR TIFFSetDirectory (3T)
