.\" @(#)setfield.3t	1.2 5/2/90
.\"
.\" Copyright (c) 1990 by Sam Leffler.
.\" All rights reserved.
.\"
.\" This file is provided for unrestricted use provided that this
.\" legend is included on all tape media and as a part of the
.\" software program in whole or part.  Users may copy, modify or
.\" distribute this file at will.
.\"
.TH TIFFSetField 3T "May 2, 1990"
.SH NAME
TIFFSetField \- set the value(s) of a tag in a
.SM TIFF
file open for writing
.SH SYNOPSIS
.B "#include <tiffio.h>"
.br
.B "int TIFFSetField(TIFF* tif, int tag, ...)"
.SH DESCRIPTION
.IR TIFFSetField ()
sets the value of a field in the current directory associated with
the open
.SM TIFF
file
.IR tif .
The file must have been previously opened for writing with
.IR TIFFOpen (3T).
The field is identified by
.IR tag ,
one of the values defined in the include file
.B tiff.h
(see also the table below).
The actual value is specified using a variable argument list,
as prescribed by the
.IR varargs (3)
interface.
A 1 is returned if the operation was successful, or 0 if an
error was detected.
.PP
The tags understood by
.IR libtiff ,
the number of parameter values, and the
expected types for the parameter values are shown below.
Tags marked with a \(dg may not have their values changed
once an application begins writing data.
This restriction is applied to those tags that influence
the format of written data.
The data types are specified as in C:
.I char*
is null-terminated string and corresponds to the
.SM ASCII
data type;
.I u_short
is an unsigned 16-bit value;
.I u_long
is an unsigned 32-bit value;
.I u_short*
is an array of unsigned 16-bit values.
Consult the
.SM TIFF
specification for information on the meaning of each tag.
.PP
.nf
.ta \w'TIFFTAG_CONSECUTIVEBADFAXLINES'u+2n +\w'Count'u+2n +\w'u_short*'u+2n
\fITag Name\fP	\fICount\fP	\fITypes\fP	\fINotes\fP
.sp 5p
TIFFTAG_ARTIST	1	char*
TIFFTAG_BADFAXLINES	1	u_long
TIFFTAG_BITSPERSAMPLE	1	u_short	\(dg
TIFFTAG_CLEANFAXDATA	1	u_short
TIFFTAG_COLORMAP	3	u_short*	1<<BitsPerSample arrays
TIFFTAG_COLORRESPONSECURVE	3	u_short*	1<<BitsPerSample entry arrays
TIFFTAG_COLORRESPONSEUNIT	1	u_short
TIFFTAG_COMPRESSION	1	u_short	\(dg
TIFFTAG_CONSECUTIVEBADFAXLINES	1	u_long
TIFFTAG_DATETIME	1	char*
TIFFTAG_DOCUMENTNAME	1	char*
TIFFTAG_FILLORDER	1	u_short	\(dg
TIFFTAG_GRAYRESPONSECURVE	1	u_short*	1<<BitsPerSample entry array
TIFFTAG_GRAYRESPONSEUNIT	1	u_short
TIFFTAG_GROUP3OPTIONS	1	u_long	\(dg
TIFFTAG_GROUP4OPTIONS	1	u_long	\(dg
TIFFTAG_HOSTCOMPUTER	1	char*
TIFFTAG_IMAGEDESCRIPTION	1	char*
TIFFTAG_IMAGELENGTH	1	u_short
TIFFTAG_IMAGEWIDTH	1	u_short	\(dg
TIFFTAG_MAKE	1	char*
TIFFTAG_MATTEING	1	u_short	\(dg
TIFFTAG_MAXSAMPLEVALUE	1	u_short
TIFFTAG_MINSAMPLEVALUE	1	u_short
TIFFTAG_MODEL	1	char*
TIFFTAG_ORIENTATION	1	u_short
TIFFTAG_PAGENAME	1	char*
TIFFTAG_PAGENUMBER	2	u_short
TIFFTAG_PHOTOMETRIC	1	u_short	\(dg
TIFFTAG_PLANARCONFIG	1	u_short	\(dg
TIFFTAG_PREDICTOR	1	u_short	\(dg
TIFFTAG_RESOLUTIONUNIT	1	u_short
TIFFTAG_ROWSPERSTRIP	1	u_long	\(dg
TIFFTAG_SAMPLESPERPIXEL	1	u_short	\(dg value must be <= 4
TIFFTAG_SOFTWARE	1	char*
TIFFTAG_SUBFILETYPE	1	u_long
TIFFTAG_THRESHHOLDING	1	u_short
TIFFTAG_XPOSITION	1	float
TIFFTAG_XRESOLUTION	1	float
TIFFTAG_YPOSITION	1	float
TIFFTAG_YRESOLUTION	1	float
.fi
.SH DIAGNOSTICS
All error messages are directed to the
.IR TIFFError (3T)
routine.
.PP
\fB%s: Cannot modify tag "%s" while writing\fP.
Data has already been written to the file, so the
specified tag's value can not be changed.
This restriction is applied to all tags that affect
the format of written data.
.PP
.BR "Cannot handle %d-channel data"
A value greater than 4 was specified for the
.I SamplesPerPixel
tag.
The library handles at most 4 channel images.
.PP
\fB%d: Bad value for "%s"\fP.
An invalid value was supplied for the named tag.
This usually is caused by supplying the wrong number or
type of parameters.
.SH "SEE ALSO"
.IR intro (3T),
.IR TIFFOpen (3T),
.IR TIFFGetField (3T),
.IR TIFFSetDirectory (3T),
.IR TIFFWriteDirectory (3T),
.IR TIFFReadDirectory (3T)
