#include <math.h>
#include "showfloat.h"
#include "surfproto.h"

/*
 * sn(d) returns a three character representation of the floating point
 * number 'd'.  It just represents values between -1.0 & +1.0, it was
 * designed so that probability matrices could be printed compactly.
 * If a number is less than 0.1, but greater than or equal to 0.01, it is
 * represented as :n (double decimal point)
 * output       d
 *  ^^          > 1.0
 *  ++          = 1.0      100 %
 *  nn          = 0.nn     nn%
 *  .n          = 0.00n    n/10 of %
 *  :n          = 0.000n   n/100 of %
 */
int sign(double d )

{
  if (d<0) return -1;
  else return 1;
}

char *sn(double d )

{
  char *res,c,p;
  int i;
  static char str[40];
  if (d < -1.0) res = " __";
  else if (d > 1.0) res = " ^^";
  else {
    res = str;
    i = 100 * (d + sign(d)*0.005);
    if ((i != 0) && (fabs(d) >= 0.0095)) {
      sprintf(str,"%3d",i);
      if (i == 100) res = " =1";
      if (i == -100) res = "=-1";
    }
    else {
      i = 1000 * (d + sign(d)*0.0005);
      p = '.';
      if (i==0 || fabs(d) < 0.00095) {p=':'; i = 10000 * (d+sign(d)*0.00005);}
      c = ' ';
      if (i < 0) { i = -i; c = '-'; }
      sprintf(str,"%c%c%1d",c,p,i);
      if (i == 0) res = "  0";
    }
  }
  return res;
}

char *tn(double x )

{
  static char str[40];
  sprintf(str," %g",x);
  return str;
}

#ifdef MAIN
main(argc,argv)
int argc;
char *argv[];
{
  double x,atof();
  x = atof(argv[1]);
  printf("%s == %s\n",sn(x),tn(x));
}
#endif
