


/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */



#ifndef MINNEGRAPHICSDEFS
#define MINNEGRAPHICSDEFS

#include "gl.h"

#include "color/color.h"
#include "geometry/point.h"
#include "geometry/transform.h"

/***************************************************************/
/* mg.c */
/***************************************************************/
#define mgreshapeviewport() reshapeviewport()

extern int mgoption( int option, int onoff );
extern int mggetoption( int option );
extern int mgsetdepth( float n, float f );
extern int mgbackground( Color * );

extern int mgworldbegin( void );
extern int mgworldend( void );
extern int mgframebegin( void );
extern int mgframeend( void );
extern int mgbegin( void );
extern int mgend( void );
extern int mgabort( void );

/***************************************************************/
/* mgtransform.c */
/***************************************************************/
extern int mgidentity( void );
extern int mgtransform( Transform );

#define mgrotate( angle, axis ) rot(angle,axis)
#define mgrotatex( angle ) rot(angle,'x')
#define mgrotatey( angle ) rot(angle,'y')
#define mgrotatez( angle ) rot(angle,'z')
#define mgtranslate( x, y, z )  translate(x,y,z)
#define mgscale( x, y, z ) scale(x,y,z)
#define mgorthographic( l, r, b, t, n, f ) ortho(l,r,b,t,n,f)
#define mgperspective( l, r, b, t, n, f ) window(l,r,b,t,n,f)
#define mgpushtransform() pushmatrix()
#define mgpoptransform() popmatrix()

#define mgc(c) c3f((float *)c)
#define mgp(p) v3f((float *)p)
#define mgn(n) n3f((float *)n)
#define mgc3(r,g,b) { float c[3]; c[0]=(r); c[1]=(g); c[2]=(b); c3f(c); }
#define mgp3(x,y,z) { float p[3]; p[0]=(x); p[1]=(y); p[2]=(z); v3f(p); }
#define mgn3(x,y,z) { float n[3]; n[0]=(x); n[1]=(y); n[2]=(z); n3f(n); }

/***************************************************************/
/* mgshade.c */
/***************************************************************/
extern void d3f(/* float c[3], float kd */);
extern void d4f(/* float c[4], float kd */);

extern void mgshademodel( int );
extern void mgconstantcolor();
#define CONSTANT_COLOR lmcolor(LMC_COLOR)	
#define SHADED_COLOR  lmcolor(LMC_DIFFUSE)

extern int mgconstant( void );
extern int mgmatte( float, float, Color *, Color * );
extern int mgmetal( float, float, float, Color *, Color * );
extern int mgplastic( float, float, float, float, Color *, Color *, Color * );
extern void mgmaterialdef( int, float, float, float, float, Color *, Color *, Color *, Color *);
extern void mgmaterial( int );

extern int mgambientlight( float, Color * );
extern int mgdistantlight( float, Color *, Point *, Point *);
extern int mgpointlight( float, Color *, Point * );
extern int mglightdef( int, float, Color *, Point * );
extern int mgilluminate( int, int );
extern int mglightmodeldef( int, Color *, int, float, float );
extern int mglightmodel( int );

/***************************************************************/
/* mgshapes.c */
/***************************************************************/
extern void mgbgnpolygon();
extern void mgendpolygon();
#define mgbgnclosedline() bgnclosedline()
#define mgendclosedline() endclosedline()
extern void mgcircle( float x, float y, float r );
extern void mgcube( void );
extern void mgrectoid( float, float, float, float, float, float );
extern void mgtetrahedron( void );
extern void mgcone( void );
extern void mgcylinder( void );
extern void mgsphere( void );

/* Options to mgoption */
#define MG_RGB		0x1
#define MG_COLORMAP	0x2
#define MG_DOUBLEBUFFER	0x4
#define MG_SINGLEBUFFER 0x8
#define MG_PAINT	0x10
#define MG_HIDDEN	0x20
#define MG_BACKFACECULL	0x40
#define MG_NOBACKFACECULL 0x80
#define MG_FATPOLYGONS	0x100
#define MG_FADE		0x200
#define MG_FASTCLEAR	0x400
#define MG_INHIBITSWAP	0x800
#define MG_INHIBITBACKGROUND 0x4000
#define MG_FOREGROUND   0x1000
#define MG_BACKGROUND   0x2000


#define MG_PERVERT	1
#define MG_PERPOLY	2
#define MG_POINT	0
#define MG_COLOR	4
#define MG_SHADE	8
#define MG_POLYS	16
#define MG_ULINES	32
#define MG_VLINES	64
#define MG_UWRAP	128
#define MG_VWRAP	256
#define MG_REVERSE	512
#define	MG_EDGEDRAW	1024
#define MG_NORMAL       2048

#ifndef NULL
#define NULL 0
#endif

/***************************************************************/
/* added 7/90 munzner */
#define IRISGL 0
#define RENDERMAN 1
#define XWINDOWS 2

/* constant diffusion */
#define CD 1.0 

#endif MINNEGRAPHICSDEFS
