#include	<stdio.h>
#include	<math.h>
#include	<malloc.h>
#include	"cmap.h"
#include	<Xw/Xw.h>
#include	<X11/cursorfont.h>
#include	<X11/Label.h>
#include	<X11/Box.h>
#include	<X11/AsciiText.h>
#include	<Xw/WorkSpace.h>
#include	<Xw/PButton.h>

static char    *names[][NBOX] = {
	{ " Red ", "Green", "Blue ", "Alpha" },
	{ " Hue ", " Sat ", "Value", "Alpha" },
	{ "Yntsc", "Intsc", "Qntsc", "Alpha" },
};


/*
 * Change color schemes.  Relabel the toggle button and the function boxes
 * and rebuild the color table.
 */
void
setScheme(w, client_data, call_data)
    Widget	w;
    caddr_t	client_data, call_data;
{
	Arg	arg[2];
	int	i;

	if(client_data == (caddr_t)-1) {
		colorscheme = (enum colorscheme) ((int)colorscheme + 1);
		if(schemename[(int)colorscheme] == NULL)
			colorscheme = (enum colorscheme) 0;
	} else {
		colorscheme = (enum colorscheme)client_data;
	}
	for(i = 0; i < NBOX; i++) {
	    XtSetArg (arg[0], XtNlabel, (XtArgVal) names[(int)colorscheme][i]);
	    XtSetValues(cbox[i].namelbl, arg, 1);
	    redo(i, 0, cbox[i].count, REDOLUT);
	}
	XtSetArg(arg[0], XtNlabel,
		(XtArgVal) schemename[(int)colorscheme]);
	XtSetValues(rgb_button, arg, 1);
}

void
boxMessage(box, fmt, p1, p2, p3, p4)
    int	box;
    char *fmt;
    long p1, p2, p3, p4;
{
    char buf[512];
    Arg arg;
    XtTextBlock xtb;
    Widget w;

    sprintf(buf, fmt, p1, p2, p3, p4);

    w = cbox[box].diatxt;
    XtTextSetInsertionPoint(w, (XtTextPosition)0);
    XtTextSetLastPos(w, (XtTextPosition)0);
    xtb.firstPos = 0;
    xtb.length = strlen(buf);
    xtb.ptr = buf;
    xtb.format = FMT8BIT;
    XtTextReplace(w, (XtTextPosition)0, (XtTextPosition)0, &xtb);
    XtTextSetInsertionPoint(w, (XtTextPosition)0);
}

	/* Buttons within each box */
#define	B_LOCK_X	1
#define	B_DEL		2
#define	B_SETTO		3
#define	B_INC		4
#define	B_DEC		5

	/* Callbacks' code for which button was pressed in which box */
#define	B_CODE(box, button)  (caddr_t)((box)<<3 | (button))

boxButton(w, client_data, call_data)
    Widget	w;
    caddr_t	client_data, call_data;
{
    /* X action routine for 3 buttons:
     *	Lock X, Del, SetTo, ++, --
     */
    int box = (int)client_data >> 3;
    char *msg;

    /* Get the value in the dialog box, it might be useful */
    msg = cbox[box].diastr;
    
    switch(0x7 & (int)client_data) {
    case B_LOCK_X:	box_lock_x(box, msg); break;
    case B_DEL:		box_delete(box, msg); break;
    case B_SETTO:	box_setadd(box, msg); break;
    case B_INC:		box_pump(box, 1); break;
    case B_DEC:		box_pump(box, -1); break;
    }
}

/*
 * Action table for box contents:
 * we define boxPoint, boxSpot, boxDrag.  These in turn call the
 * device-independent routines box_point, box_spot, box_drag.
 */
extern void boxPoint(), boxSpot(), boxDrag();
XtActionsRec box_actions[] = {
	"boxPoint", boxPoint,
	"boxSpot", boxSpot,
	"boxDrag", boxDrag,
};

/*
 * Translation table for the above actions.
 */
static String box_translations = "\
<Btn3Down>:boxPoint()\n\
<Btn2Motion>:boxDrag()\n\
<Btn2Down>:boxSpot(\"drag\") boxDrag()\n\
<Btn2Up>:boxSpot()\n\
<Btn1Down>:boxSpot()\n\
<Btn1Motion>:boxSpot()";

void
initBoxes (parent)
    Widget	parent;
{
    int		i;
    Arg		arg[10];
    Widget	rgber;
    register struct cbox *cb;
    XtTranslations boxtrans;

    boxtrans = XtParseTranslationTable(box_translations);
    for (i = 0; i < NBOX; i++) {
	/* Components of a box:
	 * "name" labelWidget (red, green, lightness &c)
	 * "Lock X" button (applies to last touched control point)
	 * "Delete" button (ditto)
	 * "Set/Add=>" button (takes info from dialog window)
	 * text window which:
	 *	displays coords of last selected point (rmouse)
	 *	is user editable for setting exact coordinates
	 */
	cb = &cbox[i];
	rgber = XtCreateManagedWidget (names[0][i], boxWidgetClass,
				       parent, arg, 0);

	XtSetArg (arg[0], XtNlabel, (XtArgVal) names[(int)colorscheme][i]);
	cb->namelbl = XtCreateManagedWidget ("Name", labelWidgetClass,
				    rgber, arg, 1);

	XtSetArg (arg[0], XtNlabel, (XtArgVal)"LockX");
	cb->lockbtn = XtCreateManagedWidget("LockX",
				XwpushButtonWidgetClass, rgber, arg, 1);
	XtAddCallback(cb->lockbtn, XtNselect, boxButton, B_CODE(i, B_LOCK_X));

	XtSetArg (arg[0], XtNlabel, (XtArgVal)"++");
	cb->delbtn = XtCreateManagedWidget("++",
			    XwpushButtonWidgetClass, rgber, arg, 1);
	XtAddCallback(cb->delbtn, XtNselect, boxButton, B_CODE(i, B_INC));

	XtSetArg (arg[0], XtNlabel, (XtArgVal)"--");
	cb->delbtn = XtCreateManagedWidget("--",
			    XwpushButtonWidgetClass, rgber, arg, 1);
	XtAddCallback(cb->delbtn, XtNselect, boxButton, B_CODE(i, B_DEC));

	XtSetArg (arg[0], XtNlabel, (XtArgVal)"Del");
	cb->delbtn = XtCreateManagedWidget("Del",
			    XwpushButtonWidgetClass, rgber, arg, 1);
	XtAddCallback(cb->delbtn, XtNselect, boxButton, B_CODE(i, B_DEL));

	XtSetArg (arg[0], XtNlabel, (XtArgVal)"SetTo");
	cb->setbtn = XtCreateManagedWidget("SetTo",
				XwpushButtonWidgetClass, rgber, arg, 1);
	XtAddCallback(cb->setbtn, XtNselect, boxButton, B_CODE(i, B_SETTO));
	

	cb->diastr = malloc(64);
	XtSetArg(arg[0], XtNeditType, (XtArgVal) XttextEdit);
	XtSetArg(arg[1], XtNwidth, (XtArgVal) 128);
	XtSetArg(arg[2], XtNlength, (XtArgVal) 64);
	XtSetArg(arg[3], XtNstring, (XtArgVal) cb->diastr);
	XtSetArg(arg[4], XtNinsertPosition, (XtArgVal) 0);
	cb->diatxt = XtCreateManagedWidget("dia", asciiStringWidgetClass,
				   rgber, arg, 5);

	XtSetArg (arg[0], XtNheight, (XtArgVal) boxheight);
	XtSetArg (arg[1], XtNwidth, (XtArgVal) boxwidth);
	cb->boxws = XtCreateManagedWidget ("box", XwworkSpaceWidgetClass,
				    rgber, arg, 2);

	XtAddCallback (cb->boxws, XtNexpose, boxDraw, i);
	XtAddCallback (cb->boxws, XtNresize, boxResize, i);

	/* Register actions (sort of like callbacks) for interesting events */ 
	XtAppAddActions(XtWidgetToApplicationContext(rgber),
			box_actions, XtNumber(box_actions));

	/* Register a translation table to map real events
	 * (middle mouse click, drag, etc.) to the above actions
	 */
	XtOverrideTranslations(cb->boxws, boxtrans);

	XtAddCallback (cb->boxws, XtNselect, boxSel, i);
	redo(i, 0, 2, RECALC|REDOLUT);
    }
}

void
boxDraw (w, client_data, call_data)
    Widget	w;
    caddr_t	client_data;
    caddr_t	call_data;
{
    int		which;
    int		box;
    Cursor	curs;
    static int	curs_done [NBOX] = {0, 0, 0, 0};

    box = (int)client_data;

    if (!curs_done[box]) {
	curs = XCreateFontCursor(XtDisplay(w), XC_crosshair);
	XDefineCursor (XtDisplay(w), XtWindow(w), curs);
	curs_done[box] = 1;
    }

    redo(box, 0, cbox[box].count-1, 0);	/* Redraw all, don't recalculate */
}

void
boxResize(w, client_data, call_data)
    Widget  w;
    caddr_t client_data, call_data;
{
    static Arg getboxsize[] = {
	XtNwidth, (XtArgVal) &boxwidth,
	XtNheight, (XtArgVal) &boxheight
    };

    XtGetValues(w, getboxsize, XtNumber(getboxsize));
    /* Don't bother to redraw, Xt should call expose anyway. */
    /* However I don't think the colorbar gets a resize event so
     * give it one...
     */
    buildCbar(w, 1);
}


int
wid_to_box(w)
    Widget w;
{
    register int box;

    for(box = NBOX; --box >= 0 && cbox[box].boxws != w; )
	;
    return(box);	/* The box if found, -1 if not. */
}

void
boxAnnounce(box, point)
	int box, point;
{
	register struct cval *c;
	Arg arg;

	if(point < 0 || point >= cbox[box].count) {
		boxMessage(box, "");
		XtSetArg(arg, XtNset, (XtArgVal)FALSE);
	} else {
		c = &cbox[box].cval[point];
		boxMessage(box, "x %d y %d%s",
			ItoUX(c->x, box), ItoUY(c->y, box),
			c->flags & LOCK_X ? " lockedX" : "");

		pick_cbar(c->x, -1, 0);
		XtSetArg(arg, XtNset,
			(XtArgVal)((c->flags&LOCK_X) ? TRUE : FALSE));
	}
	XtSetValues(cbox[box].lockbtn, &arg, 1);
}

void
boxSel (w, client_data, call_data)
    Widget	w;
    caddr_t	client_data;
    caddr_t	call_data;
{
    static char **pp = 0;
    static int zero = 0;

    boxSpot(w, (XEvent *)call_data, pp, &zero);
}

/*
 * Add a control point.  Display its coordinates in the text widget.
 */
void
boxPoint(w, ev, argv, argcp)
    Widget	w;
    XEvent	*ev;
    String	*argv;
    Cardinal	*argcp;
{
    int box;

    box = wid_to_box(w);
    if (box < 0 || ev->type != ButtonPress) {
	printf("boxPoint: ev->type %d?\n", ev->type);
	return;
    }
    add_point(box, GtoIX(ev->xbutton.x), GtoIY(ev->xbutton.y), 0);
}

void
boxSpot(w, ev, argv, argcp)
	Widget w;
	XEvent *ev;
	String *argv;
	Cardinal *argcp;
{
	int box;
	int i;

	box = wid_to_box(w);
	if (box < 0 || (ev->type != ButtonPress
			&& ev->type != ButtonRelease
			&& ev->type != MotionNotify)) {
	    printf("boxSpot: ev->type %d?\n", ev->type);
	    return;
	}
	/* We could get the string "release" as an arg.
	 * Should pass it as a flag to box_spot(), might need it somehow.
	 */
	box_spot(box, GtoIX(ev->xbutton.x), GtoIY(ev->xbutton.y), *argcp);
}

void
boxDrag(w, ev, argv, argcp)
	Widget w;
	XEvent *ev;
	String *argv;
	Cardinal *argcp;
{
	int box;
	int i;

	box = wid_to_box(w);
	if (box < 0 || lastpt < 0 || lastpt >= cbox[box].count) {
		if(lastpt != -2)
			boxMessage(box, "Select a point first");
		lastpt = -2;
		return;
	}
	if(ev->type != ButtonPress
	   && ev->type != ButtonRelease
	   && ev->type != MotionNotify) {
	    printf("boxDrag: ev->type %d?\n", ev->type);
	    return;
	}
	/* We could get the string "release" as an arg.
	 * Should pass it as a flag to box_drag() ...
	 */
	box_drag(box, GtoIX(ev->xbutton.x), GtoIY(ev->xbutton.y), 0);
	if(*argcp > 0)
		boxAnnounce(box, lastpt);
}

void
boxClear (box, lox, hix)
    int	box;
    int lox, hix;
{
    Widget	wid	= cbox[box].boxws;
    Window	drawwin = XtWindow (wid);
    Display	*dpy	= XtDisplay (wid);

    XFillRectangle (dpy, drawwin, gc_w1[0], ItoGX(lox), 0,
					  ItoGX(hix), boxheight-1);
}


/*
 * Draw a batch of lines in a box.
 * Lines determined by a sequence of points which are assumed already
 * transformed to graphics coordinates.  (is this a good idea? for splines,
 * the caller needs to know the transformation anyway to compute a good fit.
 * So maybe it's reasonable to have the caller do the transformation.
 * On the other hand it's too X-specific to use XPoint as an interface.)
 */
void
putlines (box, p, npts, on)
    int		box;
    XPoint	*p;
    int		npts;
    int		on;
{
    Widget	wid	= cbox[box].boxws;
    Window	drawwin = XtWindow (wid);
    Display	*dpy	= XtDisplay (wid);

    XDrawLines(dpy, drawwin, gc_w1[on], p, npts, CoordModeOrigin);
}

/*
 * Plot a batch of control points in a given box.
 * Points assumed to have already been transformed to graphics coordinates.
 */
void
putpoints (box, p, npts, on)
    int		box;
    XPoint	*p;
    int		npts;
    int		on;
{
    Widget	wid	= cbox[box].boxws;
    Window	drawwin = XtWindow (wid);
    Display	*dpy	= XtDisplay (wid);
    register int i;

    for(i = 0; i < npts; i++) {
	XDrawRectangle (dpy, drawwin, gc_w2[on], p[i].x-2, p[i].y-2, 5, 5);
    }

}
