* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
      DOUBLE PRECISION FUNCTION PHI4Z0 (ECCNTS,E0,E1,E2,E3,A,B,C,
     .                                  IPFILE,IFLG)
*
* FUNCTION TO COMPUTE LATITUDE ANGLE (PHI-4).
*
      IMPLICIT REAL*8 (A-Z)
      INTEGER*4 II,NIT,IPFILE,IFLG
      DATA ONE,TWO,FOUR,SIX /1.0D0,2.0D0,4.0D0,6.0D0/
      DATA TOL,NIT /1.0D-11,15/
*
      PHI = A
      DO 020 II = 1,NIT
      SINPHI = DSIN (PHI)
      TANPHI = DTAN (PHI)
      C = TANPHI * DSQRT (ONE - ECCNTS * SINPHI * SINPHI)
      SIN2PH = DSIN (TWO * PHI)
      ML = E0 * PHI - E1 * SIN2PH + E2 * DSIN (FOUR * PHI) -
     .     E3 * DSIN (SIX * PHI)
      MLP = E0 - TWO * E1 * DCOS (TWO * PHI) + FOUR * E2 *
     .      DCOS (FOUR * PHI) - SIX * E3 * DCOS (SIX * PHI)
      CON1 = TWO * ML + C * (ML * ML + B) - TWO * A *
     .       (C * ML + ONE)
      CON2 = ECCNTS * SIN2PH * (ML * ML + B - TWO * A * ML) / (TWO * C)
      CON3 = TWO * (A - ML) * (C * MLP - TWO / SIN2PH) - TWO * MLP
      DPHI = CON1 / (CON2 + CON3)
      PHI = PHI + DPHI
      IF (DABS(DPHI) .GT. TOL) GO TO 020
      PHI4Z0 = PHI
      RETURN
  020 CONTINUE
*
      IF (IPFILE .NE. 0) WRITE (IPFILE,2000)
 2000 FORMAT (' LATITUDE FAILED TO CONVERGE')
      IFLG = 24
      RETURN
*
      END
