/* SCCS @(#)meacresco.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       meacresco.layout.c                             */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   meacresco.layout.c                                  */
/*                                                                      */
/* DESCRIPTION  :   Measures Colour Regions (save counted objects)      */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "meacresco.layout.h"

#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;


/********************************************************
/   Creation Function for MEAS_param_widget
/*******************************************************/

xs_struc_paramprepro
* build_MEAS_param_widget(meacresco)
	Widget meacresco;
{
	Widget MEAS_param_widget;
	Widget Min_size;
	Widget Pattern_point;
	Widget Xcoord;
	Widget YCoord;
	Widget Surface;
	Widget min_size_text;
	Widget YCoord_text;
	Widget Surface_text;
	Widget XCoord_text;
	Widget min_size_label;
	Widget xcoord_label;
	Widget YCoord_Label;
	Widget Surface_Label;
	xs_struc_paramprepro *Paramprepro;
	Arg args[MAX_ARGS];
	int n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));

	/* Creating MEAS_param_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,300); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,300); n++;

	MEAS_param_widget = 
		XmCreateForm(meacresco,"MEAS_param_widget",args,n);

	Paramprepro->parent = MEAS_param_widget;

	/* Creating Min_size Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[230],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightPosition,40); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,5); n++;

	Min_size = XmCreateLabel(MEAS_param_widget,"Min_size",args,n);
	XtManageChild(Min_size);

	/* Creating Pattern_point Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[240],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightPosition,40); n++;
	XtSetArg(args[n],XmNrightWidget,NULL); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,25); n++;

	Pattern_point = XmCreateLabel(MEAS_param_widget,"Pattern_point",args,n);
	XtManageChild(Pattern_point);

	/* Creating Xcoord Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[234],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightPosition,40); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,32); n++;

	Xcoord = XmCreateLabel(MEAS_param_widget,"Xcoord",args,n);
	XtManageChild(Xcoord);

	/* Creating YCoord Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[235],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightPosition,40); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,52); n++;

	YCoord = XmCreateLabel(MEAS_param_widget,"YCoord",args,n);
	XtManageChild(YCoord);

	/* Creating Surface Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[233],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightPosition,40); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,72); n++;

	Surface = XmCreateLabel(MEAS_param_widget,"Surface",args,n);
	XtManageChild(Surface);

	/* Creating min_size_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,20); n++;
	XtSetArg(args[n],XmNleftWidget,NULL); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,65); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,15); n++;
	XtSetArg(args[n],XmNvalue,"0"); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	min_size_text = XmCreateText(MEAS_param_widget,"min_size_text",args,n);

	XtManageChild(min_size_text);

	Paramprepro->diameter = min_size_text;

	/* Creating YCoord_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,20); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,65); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,59); n++;
	XtSetArg(args[n],XmNvalue,"0"); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	YCoord_text = XmCreateText(MEAS_param_widget,"YCoord_text",args,n);

	XtManageChild(YCoord_text);

	Paramprepro->line = YCoord_text;

	/* Creating Surface_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,20); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,65); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,79); n++;
	XtSetArg(args[n],XmNvalue,"0"); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	Surface_text = XmCreateText(MEAS_param_widget,"Surface_text",args,n);

	XtManageChild(Surface_text);

	Paramprepro->alpha = Surface_text;

	/* Creating XCoord_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,20); n++;
	XtSetArg(args[n],XmNleftWidget,Xcoord); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,65); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,39); n++;
	XtSetArg(args[n],XmNvalue,"0"); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	XCoord_text = XmCreateText(MEAS_param_widget,"XCoord_text",args,n);

	XtManageChild(XCoord_text);

	Paramprepro->colon = XCoord_text;

	/* Creating min_size_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[241],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,min_size_text); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,15); n++;

	min_size_label = XmCreateLabel(MEAS_param_widget,"min_size_label",args,n);
	XtManageChild(min_size_label);

	/* Creating xcoord_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[241],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,XCoord_text); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,39); n++;

	xcoord_label = XmCreateLabel(MEAS_param_widget,"xcoord_label",args,n);
	XtManageChild(xcoord_label);

	/* Creating YCoord_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[241],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,YCoord_text); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,59); n++;

	YCoord_Label = XmCreateLabel(MEAS_param_widget,"YCoord_Label",args,n);
	XtManageChild(YCoord_Label);

	/* Creating Surface_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[242],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,Surface_text); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,79); n++;

	Surface_Label = XmCreateLabel(MEAS_param_widget,"Surface_Label",args,n);
	XtManageChild(Surface_Label);

	return(Paramprepro);
}
