/* SCCS @(#)histogr4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      histogr4.c                                      */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   histogr4.c                                          */
/*                                                                      */
/* DESCRIPTION  :   Histogram operations                                */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <math.h>
#include <stdio.h>

#include "type.h"
#include "structure.h"

extern	SetUpPS(), EndImagePS();

/***************************************************************************/

int calcul_histo (imageIn, type, colonne, ligne, tab_hist, histo)
    unsigned char *imageIn;
    int type, colonne, ligne;
    int **tab_hist;
    struct description_vecteur *histo;
{
    float delta, longueur;
    register int i, j;
    int taille, pas, total;
    int *temp;
    struct histogr *ih;

    /* Allocation of memory space for the resultant image */
    *tab_hist = (int *)malloc(histo->ncase * sizeof(int));

    if (!*tab_hist) return (-1);
    
    longueur = histo->b_max - histo->b_min;
    delta = (longueur + 1) / histo->ncase;
    taille = colonne * ligne;

    temp = *tab_hist;

    for (i=0; i<histo->ncase; i++) {
	*temp = 0;
	temp++;
    }
    total = 0;
    switch (type) {
	case -1:
	case 0 :{
	    unsigned char *im = imageIn;
	    for (i=0; i<taille; i++){
		if (*im >= histo->b_min && *im <= histo->b_max){
		    pas = (int) (((*im) - histo->b_min) / delta);
		    (*(*tab_hist + pas))++;
		    im++;  total++;
		}
	    }
            break;
	}
	case 1 :{
	    short *im = (short *)imageIn;
	    for (i=0; i<taille; i++){
		if (*im >= histo->b_min && *im <= histo->b_max){
		    pas = (int) (((*im) - histo->b_min) / delta);
		    (*(*tab_hist + pas))++;
		    im++;  total++;
		}
	    }
            break;
	}
	case 2 :{
	    int *im = (int *)imageIn;
	    for (i=0; i<taille; i++){
		if (*im >= histo->b_min && *im <= histo->b_max){
		    pas = (int) (((*im) - histo->b_min) / delta);
		    (*(*tab_hist + pas))++;
		    im++;  total++;
		}
	    }
            break;
	}
	case 3 :{
	    float *im = (float *)imageIn;
	    for (i=0; i<taille; i++){
		if (*im >= histo->b_min && *im <= histo->b_max){
		    pas = (int) (((*im) - histo->b_min) / delta);
		    (*(*tab_hist + pas))++;
		    im++;  total++;
		}
	    }
            break;
	}
    }

    histo->total = (float) total;
    histo->vmin = (float)taille;
    histo->vmax = 0.0;

    temp = *tab_hist;

    for (i=0; i<histo->ncase; i++){
	if ((float)*temp < histo->vmin) histo->vmin = (float)*temp;
	else if ((float)*temp > histo->vmax) histo->vmax = (float)*temp;
	temp++;
    }
    ih = (struct histogr *)histo->prive;
    ih->tab_hist = *tab_hist;
    return 0;
}	
	
/*****************************************************************************/
	
int imprimer_histo (vecteurIn, histo, fn)
    unsigned char *vecteurIn;
    struct  description_vecteur	*histo;
    struct  fname *fn;
{
    struct  histogr *ih;
    int	    pas = 0;
    int	    *tab_hist, *tab_haut, *temp;
    register int i, j, k;

    ih = (struct histogr *)histo->prive;
    SetUpPS (1,fn->fpim,(histo->ncase * ih->larg_barre)+2, ih->haut_barre + 2);
    tab_hist = (int *)vecteurIn;

    /* Allocation of memory space */
    temp = tab_haut = (int *)malloc(histo->ncase * sizeof(int));

    if (!tab_haut) return (-1);

    for (i=0; i<histo->ncase; i++){
	*tab_haut = *(tab_hist) * ih->haut_barre / histo->vmax;
	tab_haut++;
	tab_hist++;
    }
    for (i=0; i<(histo->ncase * ih->larg_barre) + 2; i++) 
	fprintf (fn->fpim, "00");
    fprintf (fn->fpim, "\n");
    for (j=ih->haut_barre; j>0; j--){
	tab_haut = temp;
	fprintf (fn->fpim, "00");
	for (i=0; i<histo->ncase; i++){
	    if (j > *tab_haut) 
		for (k=0; k<ih->larg_barre; k++)
		    fprintf (fn->fpim, "ff");
	    else
		for (k=0; k<ih->larg_barre; k++)
		    fprintf (fn->fpim, "00");
	    tab_haut++;
	}
	fprintf (fn->fpim, "00");
	fprintf (fn->fpim, "\n");
    }
    for (i=0; i<(histo->ncase * ih->larg_barre) + 2; i++) 
	fprintf (fn->fpim, "00");
    fprintf (fn->fpim, "\n");
    EndImagePS (fn->fpim);
    fclose (fn->fpim);
}

