/* SCCS @(#)LaboMorphoBin.callback.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                          LaboMorphoBin.callback.c                    */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   LaboMorphoBin.callback.c                            */
/*                                                                      */
/* DESCRIPTION  :   MORPHOLOGIE BINAIRE                                 */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/


#include "libwidgets/widgetstructure.h"
#include "LaboMorphoBin.layout.h"
#include "pre_pro.layout.h"
#include "dissim.layout.h"

#include "define.h"
#include "global.h"
#include "MorphBin/def.h"


#define TYPE_BIN -1

extern char *mastertabs[], *mmb3tabs[], *mmb4tabs[], *mmb5tabs[], *mmb6tabs[], *mmb7tabs[];

extern struct desc_ima  tab_ima[];
extern Widget QUIT_Morpho_Bin;
extern Widget Menu_Morpho_Binaire;

int taille, angle;

/******************************************************
/   activateCallback for  all Widgets  OPERATIONS
/*****************************************************/

/*****************************************************/
/* anciennement proc_morphbin 			     */
/*****************************************************/

void
create_parametres(option, no_menu, callData)
	Widget option;
 	int no_menu;
	caddr_t callData;
{
     Widget MORPHO_options_widget;
     int new_opt;

     switch (no_menu){
	case 1:
          if (flag_help_only) {
		 hproc_affiche_morphbin();
		 return;
	  }
	  if (flag_help) hproc_affiche_morphbin();
	  break;
	case 20: 
	  if (flag_help_only) {
		 hproc_complem_mbtranslog();
		 return;
	  }
	  if (flag_help) hproc_complem_mbtranslog();
	  break;
	case 21:
	  if (flag_help_only) {
		 hproc_intersect_mbtranslog();
		 return;
	  }
	  if (flag_help) hproc_intersect_mbtranslog();
	  break;
	case 22:
	  if (flag_help_only){
		 hproc_union_mbtranslog();
		 return;
	  }
	  if (flag_help) hproc_union_mbtranslog(); 		 
	  break;
	case 23: 
	  if (flag_help_only){
		 hproc_diffsym_mbtranslog();
		 return;
	  }
	  if (flag_help) hproc_diffsym_mbtranslog();
	  break;
	case 24:
	  if (flag_help_only){
		 hproc_diff_mbtranslog(); 
		 return;
	  }
	  if (flag_help) hproc_diff_mbtranslog(); 
	  break;
	case 30:
	  if (flag_help_only){
		 hproc_erosion_mbtranssimple();
		 return; 
	  }
	  if (flag_help) hproc_erosion_mbtranssimple(); 		 
	  break;
	case 31: 
	  if (flag_help_only){
		 hproc_erocond_mbtranssimple();
		 return;
	  }
	  if (flag_help) hproc_erocond_mbtranssimple();		 
	  break;
	case 32:
	  if (flag_help_only){
		 hproc_erolin_mbtranssimple(); 
		 return;
	  }
	  if (flag_help) hproc_erolin_mbtranssimple(); 		 
	  break;
	case 33:
	  if (flag_help_only){
		 hproc_dilate_mbtranssimple(); 
		 return;
	  }
	  if (flag_help) hproc_dilate_mbtranssimple();  		 
	  break;
	case 34:
	  if (flag_help_only){
		 hproc_dilate_mbtranssimple(); 
		 return;
	  }
	  if (flag_help) hproc_dilate_mbtranssimple();  		 
	  break;
	case 35:
	  if (flag_help_only){  
		 hproc_dilalin_mbtranssimple(); 
		 return;
	  }
	  if (flag_help) hproc_dilalin_mbtranssimple(); 		
	  break;
	case 36: 
	  if (flag_help_only){
		 hproc_ouvert_mbtranssimple();
		 return;
	  }
	  if (flag_help) hproc_ouvert_mbtranssimple(); 	         
	  break;
	case 37:
	  if (flag_help_only){
		 hproc_ferme_mbtranssimple();
		 return; 
	  }
	  if (flag_help) hproc_ferme_mbtranssimple();	        
	  break;
	case 40:
	  if (flag_help_only){
		 hproc_homotopL_mbaminciss();
		 return;
	  }
	  if (flag_help) hproc_homotopL_mbaminciss();		 
	  break;
	case 41: 
	  if (flag_help_only){
		 hproc_homotopD_mbaminciss();
		 return;
	  }
	  if (flag_help) hproc_homotopD_mbaminciss();		 
	  break;
	case 42:
	  if (flag_help_only){
		 hproc_ebarb_mbaminciss();
		 return;
	  }
	  if (flag_help) hproc_ebarb_mbaminciss();		 
	  break;
	case 43:
	  if (flag_help_only){
		 hproc_contour_mbaminciss();
		 return;
	  }
	  if (flag_help) hproc_contour_mbaminciss();	         
	  break;
	case 50: 
	  if (flag_help_only){
		 hproc_M_epaiss();
		 return;
	  }
	  if (flag_help) hproc_M_epaiss();		 
	  break;
	case 51: 
	  if (flag_help_only){
		 hproc_L_epaiss();
		 return;
	  }
	  if (flag_help) hproc_L_epaiss();		 
	  break;
	case 52:
	  if (flag_help_only){
		 hproc_D_epaiss();
		 return;
	  }
	  if (flag_help) hproc_D_epaiss();		 
	  break;
	case 53: 
	  if (flag_help_only){
		 hproc_E_epaiss();
		 return;
	  }
	  if (flag_help) hproc_E_epaiss();		 
	  break;
	case 54:
	  if (flag_help_only){
		 hproc_C_epaiss();
		 return; 
	  }
	  if (flag_help) hproc_C_epaiss(); 		 
	  break;
	case 60:
	  if (flag_help_only){
		 hproc_extrem_toutrien();
		 return;
	  }
	  if (flag_help) hproc_extrem_toutrien(); 		 
	  break;
	case 61:
	  if (flag_help_only){
		 hproc_triple_toutrien();
		 return; 
	  }
	  if (flag_help) hproc_triple_toutrien(); 		 
	  break;
	case 62:
	  if (flag_help_only){
		 hproc_isole_toutrien();
		 return;
	  }
	  if (flag_help) hproc_isole_toutrien();		 
	  break;
	case 63:
	  if (flag_help_only) {
		hproc_cont_hautniv();
		 return;
	  }
	  if (flag_help) hproc_cont_hautniv(); 		 
	  break;
	case 70:
	  if (flag_help_only){
		 hproc_bord_hautniv();
		 return; 
	  }
	  if (flag_help) hproc_bord_hautniv(); 		 				  break;
	case 71:
	  if (flag_help_only) {
		 hproc_trou_hautniv();
		 return;
	  }
	  if (flag_help) hproc_trou_hautniv(); 		 
	  break;
	case 72: 
	  if (flag_help_only){
		 hproc_squelhom_hautniv();
		 return;
	  }
	  if (flag_help) hproc_squelhom_hautniv(); 		 
	  break;
	case 73: 
	  if (flag_help_only) {
		 hproc_marqhom_hautniv();
		 return;
	  }
	  if (flag_help) hproc_marqhom_hautniv(); 	         
	  break;
	case 74:
	  if (flag_help_only) {
		 hproc_envquasicomp_hautniv();
		 return;
	  }
	  if (flag_help) hproc_envquasicomp_hautniv();	         
	  break;
	case 75:
	  if (flag_help_only) {
		 hproc_envfortcomp_hautniv();
		 return; 
	  }
	  if (flag_help) hproc_envfortcomp_hautniv(); 	         
	  break;
	case 76:
	  if (flag_help_only) {
		 hproc_squelzone_hautniv();
		 return;
	  }
	  if (flag_help) hproc_squelzone_hautniv();         
	  break;
	case 77:
	  if (flag_help_only) {
		 hproc_homotopL_mbamincond();
		 return; 
	  }
	  if (flag_help) hproc_homotopL_mbamincond(); 	         
	  break;
	case 80:
	  if (flag_help_only) {
		 hproc_homotopD_mbamincond();
		 return;
	  }
	  if (flag_help) hproc_homotopD_mbamincond(); 	         
	  break;
	case 81: 
	  if (flag_help_only) {
		hproc_ebarb_mbamincond();
		 return;
	  }
	  if (flag_help) hproc_ebarb_mbamincond();	         
	  break;
	case 82: 
	  if (flag_help_only) {
		hproc_M_epaisscond();
		 return;
	  }
	  if (flag_help) hproc_M_epaisscond();	         
	  break;
	case 90: 
	  if (flag_help_only) {
		hproc_L_epaisscond();
		 return;
	  }
	  if (flag_help) hproc_L_epaisscond(); 		 
	  break;
	case 91:
	  if (flag_help_only) {
		hproc_D_epaisscond();
		 return;
	  }
	  if (flag_help) hproc_D_epaisscond();		 
	  break;
	case 92:
	  if (flag_help_only) {
		hproc_E_epaisscond();
		 return;
	  }
	  if (flag_help) hproc_E_epaisscond();		 
	  break;
	case 93:
	  if (flag_help_only) {
		hproc_C_epaisscond();       
		 return;
	  }
	  if (flag_help) hproc_C_epaisscond();        		 
	  break;
	case 94: 
	  if (flag_help_only) {
		hproc_C_epaisscond();
		 return;
	  }
	  if (flag_help) hproc_C_epaisscond();                 
	  break;
    }

     new_opt = no_menu+100;

     MORPHO_options_widget = 
	build_PRE_PRO_options_widget(option, new_opt, panel_titres[180]);

     XtManageChild(MORPHO_options_widget);
}

/*****************************************************
/  Test si l'unique image d'entree est de type binaire
/****************************************************/

int TestimageIO (PRE_PRO_options_widget, option)
Widget PRE_PRO_options_widget;
int option;
{
  if ((dir_image[index_image[0]].image == NULL) && 
    (tab_ima[index_image[0]].image == NULL))
    {
      /* erreur image de depart vide */
      write_erreur (1);
      return(-1);
    }
  else if (dir_desc[index_image[0]].type != TYPE_BIN)
    {
      /* erreur image non binaire */
      write_erreur (910);
      return(-1);
    }
  else return (0);
}

/*****************************************************
/  Test si les deux images d'entree sont de type binaire
/****************************************************/

int Test2imageIO (PRE_PRO_options_widget, option)
Widget PRE_PRO_options_widget;
int option;
{
  if  ( ((dir_image[index_image[0]].image == NULL) && 
       (tab_ima[index_image[0]].image == NULL)) ||
      ((dir_image[index_image[2]].image == NULL) && 
       (tab_ima[index_image[2]].image == NULL)) )
    {
      /* erreur image de depart vide */
      write_erreur (1);
      return(-1);
    }
  else if ((dir_desc[index_image[0]].type != TYPE_BIN)
    || (dir_desc[index_image[2]].type != TYPE_BIN))
    {
      /* erreur les deux images sont non binaires */
      write_erreur (910);
      return(-1);
    }
  else return(0);
}


/******************************************************
/   activateCallback for Widget  BinMorpho_logical_op
/*****************************************************/

void
BinMorpho_logical_op_actcall(logical_op, caddrData, callData)
        Widget logical_op;
        caddr_t caddrData;
        caddr_t callData;
{
if (flag_help_only || flag_help) trslogmb_help_proc();
}


/******************************************************
/   activateCallback for Widget  logical_compl
/*****************************************************/


void
Logical_compl_actcall(logical_compl, PRE_PRO_options_widget, callData)
	Widget logical_compl;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
  long n;

  sprintf(buf,"not");
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  if (TestimageIO (PRE_PRO_options_widget, 20) == 0) {
	n = entree_morpho (20);
	XtUnmanageChild(PRE_PRO_options_widget);
  }	
}


/******************************************************
/   activateCallback for Widget  Logical_inter
/*****************************************************/

void
Logical_inter_actcall(Logical_inter, PRE_PRO_options_widget, callData)
	Widget Logical_inter;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
  long n;

  sprintf(buf,"and");
  write_master(buf);
  sprintf (buf, " (%d,%d) -->%d \n",
	   index_image[0],index_image[2],index_image[1]);
  write_master (buf);

  if (Test2imageIO(PRE_PRO_options_widget,21) == 0){
	n = entree_morpho (21);
	XtUnmanageChild(PRE_PRO_options_widget);	
  }
}


/******************************************************
/   activateCallback for Widget  logical_uni
/*****************************************************/

void
Logical_uni_actcall(logical_uni, PRE_PRO_options_widget, callData)
	Widget logical_uni;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
  long n;

  sprintf(buf,"or");
  write_master(buf);
  sprintf (buf, " (%d,%d) -->%d \n",
	   index_image[0],index_image[2],index_image[1]);
  write_master (buf);

  if (Test2imageIO(PRE_PRO_options_widget, 22) == 0){
	n = entree_morpho (22);
	XtUnmanageChild(PRE_PRO_options_widget);		
  }
}

/******************************************************
/   activateCallback for Widget  logical_uni
/*****************************************************/

void
Logical_sym_actcall(Logical_sym, PRE_PRO_options_widget, callData)
	Widget Logical_sym;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
  long n;
  
  sprintf(buf,"xor");
  write_master(buf);
  sprintf (buf, " (%d,%d) -->%d \n",
	   index_image[0],index_image[2],index_image[1]);
  write_master (buf);

  if (Test2imageIO(PRE_PRO_options_widget, 23) == 0){
	n = entree_morpho (23);
	XtUnmanageChild(PRE_PRO_options_widget);		
  }
}

/******************************************************
/   activateCallback for Widget  Logical_diff
/*****************************************************/

void
Logical_diff_actcall(Logical_diff, PRE_PRO_options_widget, callData)
	Widget Logical_diff;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
  long n;
  
  sprintf(buf,"diff");
  write_master(buf);
  sprintf (buf, " (%d,%d) -->%d \n",
	   index_image[0],index_image[2],index_image[1]);
  write_master (buf);

  if (Test2imageIO(PRE_PRO_options_widget, 24) == 0){
	entree_morpho (24);
	XtUnmanageChild(PRE_PRO_options_widget);		
  }
}


/******************************************************
/   activateCallback for Widget  BinMorpho_simple_op
/*****************************************************/

void
BinMorpho_simple_op_actcall(simple_op, caddrData, callData)
        Widget simple_op;
        caddr_t caddrData;
        caddr_t callData;
{
if (flag_help_only || flag_help) trsimpmb_help_proc();
}


/******************************************************
/   activateCallback for Widget  Simple_ero
/*****************************************************/

void
Simple_ero_actcall(Simple_ero, Param_taille_angle, callData)
	Widget Simple_ero;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,mmb3tabs[6]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 30) == 0){
	entree_morpho (30);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);	
  }
}
/******************************************************
/   activateCallback for Widget  Simple_cond_ero
/*****************************************************/

void
Simple_cond_ero_actcall(Simple_cond_ero, Param_taille_angle, callData)
	Widget Simple_cond_ero;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,mmb3tabs[0]);
  write_master(buf);
  sprintf (buf, " (%d,%d) -->%d \n",
	   index_image[0],index_image[2],index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (Test2imageIO(Param_taille_angle->GenerParamparent, 31) == 0){
	entree_morpho (31);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);	
  }
}

/******************************************************
/   activateCallback for Widget  Simple_lin_ero
/*****************************************************/

void
Simple_lin_ero_actcall(Simple_lin_ero, Param_taille_angle, callData)
	Widget Simple_lin_ero;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,mmb3tabs[1]);
  write_master(buf);  
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[104], taille, angle);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 32) == 0){
	entree_morpho (32);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);	
  }
}

/******************************************************
/   activateCallback for Widget  Simple_dil
/*****************************************************/

void
Simple_dil_actcall(Simple_dil, Param_taille_angle, callData)
	Widget Simple_dil;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,mmb3tabs[7]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 33) == 0){
	entree_morpho (33);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);	
  }
}


/******************************************************
/   activateCallback for Widget  Simple_cond_dila
/*****************************************************/

void
Simple_cond_dila_actcall(Simple_cond_dila, Param_taille_angle, callData)
	Widget Simple_cond_dila;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,mmb3tabs[2]);
  write_master(buf);
  sprintf (buf, " (%d,%d) -->%d \n",
	   index_image[0],index_image[2],index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (Test2imageIO(Param_taille_angle->GenerParamparent, 34) == 0){
	entree_morpho (34);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);	
  }
}

/******************************************************
/   activateCallback for Widget  Simple_lin_dil
/*****************************************************/

void
Simple_lin_dil_actcall(Simple_lin_dil, Param_taille_angle, callData)
	Widget Simple_lin_dil;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,mmb3tabs[3]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[104], taille, angle);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 35) == 0){
	entree_morpho (35);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);		
  }
}

/******************************************************
/   activateCallback for Widget  Simple_opening
/*****************************************************/

void
Simple_opening_actcall(Simple_opening, Param_taille_angle, callData)
	Widget Simple_opening;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf, mmb3tabs[4]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 36) == 0){
	entree_morpho (36);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);	
  }
}

/******************************************************
/   activateCallback for Widget  Simple_closing
/*****************************************************/

void
Simple_closing_actcall(Simple_closing, Param_taille_angle, callData)
	Widget Simple_closing;
	xs_struc_paramprepro *  Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,mmb3tabs[5]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 37) == 0){
	entree_morpho (37);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);		
  }
}

/******************************************************
/   activateCallback for Widget  BinMorpho_thinning_simple_op
/*****************************************************/

void
BinMorpho_thinning_simple_op_actcall(thinning_op, caddrData, callData)
        Widget thinning_op;
        caddr_t caddrData;
        caddr_t callData;
{
if (flag_help_only || flag_help) aminmb_help_proc();
}


/******************************************************
/   activateCallback for Widget  Simple_thin_homL
/*****************************************************/

void
Simple_thin_homL_actcall(Simple_thin_homL, Param_taille_angle, callData)
	Widget Simple_thin_homL;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,mmb4tabs[0]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 40) == 0){
	entree_morpho (40);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);		
  }
}

/******************************************************
/   activateCallback for Widget  Simple_thin_homD
/*****************************************************/

void
Simple_thin_homD_actcall(Simple_thin_homD, Param_taille_angle, callData)
	Widget Simple_thin_homD;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,mmb4tabs[1]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 41) == 0){
	entree_morpho (41);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);		
  }
}

/******************************************************
/   activateCallback for Widget  Simple_thin_prun
/*****************************************************/

void
Simple_thin_prun_actcall(Simple_thin_prun, Param_taille_angle, callData)
	Widget Simple_thin_prun;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,mmb4tabs[2]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 42) == 0){
	entree_morpho (42);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);		
  }
}

/******************************************************
/   activateCallback for Widget  Simple_thin_bound
/*****************************************************/

void
Simple_thin_bound_actcall(Simple_thin_bound, PRE_PRO_options_widget, callData)
	Widget Simple_thin_bound;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
  long n;
  
  sprintf(buf, mmb4tabs[3]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  if (TestimageIO (PRE_PRO_options_widget, 43) == 0){
	n = entree_morpho (43);
	XtUnmanageChild(PRE_PRO_options_widget);	
  }
}

/******************************************************
/   activateCallback for Widget  BinMorpho_thicking_simple_op
/*****************************************************/

void
BinMorpho_thicking_simple_op_actcall(thicking_op, caddrData, callData)
        Widget thicking_op;
        caddr_t caddrData;
        caddr_t callData;
{
if (flag_help_only || flag_help) epaissmb_help_proc();
}


/******************************************************
/   activateCallback for Widget  Simple_thick_isol
/*****************************************************/

void
Simple_thick_isol_actcall(Simple_thick_isol, Param_taille_angle, callData)
	Widget Simple_thick_isol;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,mmb5tabs[0]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 50) == 0){
	entree_morpho (50);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);		
  }
}

/******************************************************
/   activateCallback for Widget  Simple_thick_homL
/*****************************************************/

void
Simple_thick_homL_actcall(Simple_thick_homL, Param_taille_angle, callData)
	Widget Simple_thick_homL;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf, mastertabs[99]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 51) == 0){
	entree_morpho (51);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);		
  }
}



/******************************************************
/   activateCallback for Widget  Simple_thick_homD
/*****************************************************/

void
Simple_thick_homD_actcall(Simple_thick_homD, Param_taille_angle, callData)
	Widget Simple_thick_homD;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf, mastertabs[100]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 52) == 0){
	entree_morpho (52);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);		
  }
}

/******************************************************
/   activateCallback for Widget  Simple_thick_thickE
/*****************************************************/

void
Simple_thick_thickE_actcall(Simple_thick_thickE, Param_taille_angle, callData)
	Widget Simple_thick_thickE;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,mmb5tabs[3]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 53) == 0){
	entree_morpho (53);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);		
  }
}

/******************************************************
/   activateCallback for Widget  Simple_thick_thickC
/*****************************************************/

void
Simple_thick_thickC_actcall(Simple_thick_thickC, Param_taille_angle, callData)
	Widget Simple_thick_thickC;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,mmb5tabs[4]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 54) == 0){
	entree_morpho (54);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);		
  }
}


/******************************************************
/   activateCallback for Widget  BinMorpho_hit_miss_op
/*****************************************************/

void
BinMorpho_hit_miss_op_actcall(hit_miss_op, caddrData, callData)
        Widget hit_miss_op;
        caddr_t caddrData;
        caddr_t callData;
{
if (flag_help_only || flag_help) toutrienmb_help_proc();
}


/******************************************************
/   activateCallback for Widget  hit_miss_end_points
/*****************************************************/

void
hit_miss_end_points_actcall(hit_miss_end_points, PRE_PRO_options_widget, callData)
	Widget hit_miss_end_points;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
  long n;
  
  sprintf(buf,mastertabs[101]);
  write_master(buf);
  sprintf (buf, " %d --> %d ",
	   index_image[0], index_image[1]);
  write_master (buf);

  if (TestimageIO (PRE_PRO_options_widget, 61) == 0){
	n = entree_morpho (61);
	sprintf(buf,mastertabs[105],n);
	write_master (buf);
	sprintf(buf,"\n"); 
	write_master (buf);
	XtUnmanageChild(PRE_PRO_options_widget);
  }
}

/******************************************************
/   activateCallback for Widget  hit_miss_isol
/*****************************************************/

void
hit_miss_isol_actcall(hit_miss_isol, PRE_PRO_options_widget, callData)
	Widget hit_miss_isol;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
  long n;
  
  sprintf(buf,mmb6tabs[1]);
  write_master(buf);
  sprintf (buf, " %d --> %d ",
	   index_image[0], index_image[1]);
  write_master (buf);

  if (TestimageIO (PRE_PRO_options_widget, 62) == 0){
	n = entree_morpho (62);
	sprintf(buf,mastertabs[105],n);
	write_master (buf);
	sprintf(buf,"\n"); 
	write_master (buf);
	XtUnmanageChild(PRE_PRO_options_widget);	
  }
}

/******************************************************
/   activateCallback for Widget  hit_miss_triple
/*****************************************************/

void
hit_miss_triple_actcall(hit_miss_triple, PRE_PRO_options_widget, callData)
	Widget hit_miss_triple;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
  long n;
  
  sprintf(buf,mmb6tabs[2]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  if (TestimageIO (PRE_PRO_options_widget, 63) == 0){
	n = entree_morpho (63);
	XtUnmanageChild(PRE_PRO_options_widget);	
  }
}


/******************************************************
/   activateCallback for Widget  BinMorpho_high_op
/*****************************************************/

void
BinMorpho_high_op_actcall(high_op, caddrData, callData)
        Widget high_op;
        caddr_t caddrData;
        caddr_t callData;
{
if (flag_help_only || flag_help) trshautnivmb_help_proc();
}


/******************************************************
/   activateCallback for Widget  high_bound
/*****************************************************/

void
high_bound_actcall(high_bound, PRE_PRO_options_widget, callData)
	Widget high_bound;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
  long n;
  
  sprintf(buf,mmb7tabs[0]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  if (TestimageIO (PRE_PRO_options_widget, 70) == 0){
	n = entree_morpho (70);
	XtUnmanageChild(PRE_PRO_options_widget);	
  }
}

/******************************************************
/   activateCallback for Widget  high_elimin
/*****************************************************/

void
high_elimin_actcall(high_elimin, PRE_PRO_options_widget, callData)
	Widget high_elimin;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
  long n;
  
  sprintf(buf,mastertabs[102]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  if (TestimageIO (PRE_PRO_options_widget, 71) == 0){
	n = entree_morpho (71);
	XtUnmanageChild(PRE_PRO_options_widget);	
  }
}

/******************************************************
/   activateCallback for Widget  high_fill
/*****************************************************/

void
high_fill_actcall(high_fill, PRE_PRO_options_widget, callData)
	Widget high_fill;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
  long n;
  
  sprintf(buf, mmb7tabs[2]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  if (TestimageIO (PRE_PRO_options_widget, 72) == 0){
	n = entree_morpho (72);
	XtUnmanageChild(PRE_PRO_options_widget);	
  }
}

/******************************************************
/   activateCallback for Widget  high_hom_skel
/*****************************************************/

void
high_hom_skel_actcall(high_hom_skel, PRE_PRO_options_widget, callData)
	Widget high_hom_skel;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
  long n;
  
  sprintf(buf,mmb7tabs[3]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  if (TestimageIO (PRE_PRO_options_widget, 73) == 0){
	n = entree_morpho (73);
	XtUnmanageChild(PRE_PRO_options_widget);	
  }
}

/******************************************************
/   activateCallback for Widget  high_hom_mark
/*****************************************************/

void
high_hom_mark_actcall(high_hom_mark, PRE_PRO_options_widget, callData)
	Widget high_hom_mark;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
  long n;
  
  sprintf(buf, mmb7tabs[4]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  if (TestimageIO (PRE_PRO_options_widget, 74) == 0){
	n = entree_morpho (74);
	XtUnmanageChild(PRE_PRO_options_widget);	
  }
}

/******************************************************
/   activateCallback for Widget  high_pseudo
/*****************************************************/

void
high_pseudo_actcall(high_pseudo, PRE_PRO_options_widget, callData)
	Widget high_pseudo;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
  long n;
  
  sprintf(buf, mmb7tabs[5]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  if (TestimageIO (PRE_PRO_options_widget, 75) == 0){
	n = entree_morpho (75);
	XtUnmanageChild(PRE_PRO_options_widget);
  }
}


/******************************************************
/   activateCallback for Widget  high_strong
/*****************************************************/

void
high_strong_actcall(high_strong, PRE_PRO_options_widget, callData)
	Widget high_strong;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
  long n;
  
  sprintf(buf, mmb7tabs[6]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  if (TestimageIO (PRE_PRO_options_widget, 76) == 0){
	n = entree_morpho (76);
	XtUnmanageChild(PRE_PRO_options_widget);	
  }
}

/******************************************************
/   activateCallback for Widget  high_skele
/*****************************************************/

void
high_skele_actcall(high_skele, PRE_PRO_options_widget, callData)
	Widget high_skele;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
  long n;
  
  sprintf(buf, mmb7tabs[7]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  if (TestimageIO (PRE_PRO_options_widget, 77) == 0){
	n = entree_morpho (77);
	XtUnmanageChild(PRE_PRO_options_widget);	
  }
}

/******************************************************
/   activateCallback for Widget  BinMorpho_thinning_cond_op
/*****************************************************/

void
BinMorpho_thinning_cond_op_actcall(thinning_op, caddrData, callData)
        Widget thinning_op;
        caddr_t caddrData;
        caddr_t callData;
{
if (flag_help_only || flag_help) amincondmb_help_proc();
}


/******************************************************
/   activateCallback for Widget  Cond_thin_homL
/*****************************************************/

void
Cond_thin_homL_actcall(Cond_thin_homL, Param_taille_angle, callData)
	Widget Cond_thin_homL;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf, mmb4tabs[0]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 80) == 0){
	entree_morpho (80);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);	
  }
}

/******************************************************
/   activateCallback for Widget  Cond_thin_homD
/*****************************************************/

void
Cond_thin_homD_actcall(Cond_thin_homD, Param_taille_angle, callData)
	Widget Cond_thin_homD;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf, mmb4tabs[1]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 81) == 0){
	entree_morpho (81);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);
  }
}

/******************************************************
/   activateCallback for Widget  Cond_thin_prun
/*****************************************************/

void
Cond_thin_prun_actcall(Cond_thin_prun, Param_taille_angle, callData)
	Widget Cond_thin_prun;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,"ebarbulage:E");
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 82) == 0){
	entree_morpho (82);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);	
  }
}


/******************************************************
/   activateCallback for Widget  BinMorpho_thicking_cond_op
/*****************************************************/

void
BinMorpho_thicking_cond_op_actcall(thicking_op, caddrData, callData)
        Widget thicking_op;
        caddr_t caddrData;
        caddr_t callData;
{
if (flag_help_only || flag_help) epaisscondmb_help_proc();
}


/******************************************************
/   activateCallback for Widget  Cond_thick_isol
/*****************************************************/

void
Cond_thick_isol_actcall(Cond_thick_isol, Param_taille_angle, callData)
	Widget Cond_thick_isol;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,mmb5tabs[0]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 90) == 0){
	entree_morpho (90);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);		
  }
}

/******************************************************
/   activateCallback for Widget  Cond_thick_homL
/*****************************************************/

void
Cond_thick_homL_actcall(Cond_thick_homL, Param_taille_angle, callData)
	Widget Cond_thick_homL;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,mmb5tabs[1]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 91) == 0){
	entree_morpho (91);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);		
  }
}

/******************************************************
/   activateCallback for Widget  Cond_thick_homD
/*****************************************************/

void
Cond_thick_homD_actcall(Cond_thick_homD, Param_taille_angle, callData)
	Widget Cond_thick_homD;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,mmb5tabs[2]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 92) == 0){
	entree_morpho (92);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);		
  }
}

/******************************************************
/   activateCallback for Widget  Cond_thick_thickE
/*****************************************************/

void
Cond_thick_thickE_actcall(Cond_thick_thickE, Param_taille_angle, callData)
	Widget Cond_thick_thickE;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,mmb5tabs[3]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 93) == 0){
	entree_morpho (93);
	XtUnmanageChild(Param_taille_angle->GenerParamparent);		
  }
}

/******************************************************
/   activateCallback for Widget  Cond_thick_thickC
/*****************************************************/

void
Cond_thick_thickC_actcall(Cond_thick_thickC, Param_taille_angle, callData)
	Widget Cond_thick_thickC;
	xs_struc_paramprepro * Param_taille_angle;
	caddr_t callData;
{
  sprintf(buf,mmb5tabs[4]);
  write_master(buf);
  sprintf (buf, " %d --> %d \n",
	   index_image[0], index_image[1]);
  write_master (buf);

  taille = atoi (XmTextGetString (Param_taille_angle->alpha));
  sprintf (buf, mastertabs[103], taille);
  write_master (buf);

  if (TestimageIO (Param_taille_angle->GenerParamparent, 94) == 0){
    entree_morpho (94);
    XtUnmanageChild(Param_taille_angle->GenerParamparent);		
  }
}

/******************************************************
/   activateCallback for Widget  DISPLAY
/*****************************************************/

void
DISPLAYbin_actcall(DISPLAY, client_data, callData)
	Widget DISPLAY;
	caddr_t client_data;
	caddr_t callData;
{
	Widget show_image_widget;

	if (flag_help_only){
	  hproc_affiche_morphbin();
	  return;
	}
	if (flag_help) hproc_affiche_morphbin();

	show_image_widget = 
	  build_DISPLAY_show_image_widget(DISPLAY, 1, 9, panel_titres[36]);
	XtManageChild(show_image_widget);
}

/******************************************************
/   activateCallback for Widget  QUIT
/*****************************************************/

void
QUIT_actcall(QUIT, Quit_Morpho_Bin, callData)
	Widget QUIT;
	Widget Quit_Morpho_Bin;
	caddr_t callData;
{
XtManageChild (Quit_Morpho_Bin);
}


void
Cancel_Morpho(Quit_Morpho_Bin, clientData, callData)
	Widget Quit_Morpho_Bin;
	caddr_t clientData;
	caddr_t callData;
{
XtUnmanageChild (Quit_Morpho_Bin);
}


/********************************************************/
/* anciennement proc_sortie_morphbin 			*/
/********************************************************/

void
OKquitmorphobin(Quit_Morpho_Bin, Menu_Morph_Bin, callData)
	Widget Quit_Morpho_Bin;
	Widget Menu_Morph_Bin;
	caddr_t callData;
{
  sprintf(buf,mastertabs[96]);
  write_master(buf);
  sprintf(buf,"\n"); 
  write_master (buf);

  sortie_morpho();

  XtUnmanageChild (Menu_Morpho_Binaire);
  XtUnmanageChild (Quit_Morpho_Bin);
  XtUnmanageChild (QUIT_Morpho_Bin); /*global*/
}
