/* SCCS @(#)DISPLAYmenu.callback.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                            DISPLAYmenu.callback.c                    */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   DISPLAYmenu.callback.c                              */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Display Menu)                            */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/


#include "../libwidgets/widgetstructure.h"
#include "DISPLAYmenu.layout.h"
#include "IOplans.layout.h"
#include "statistics.layout.h"
#include "threshold.layout.h"
#include "profile.layout.h"
#include "pixeledit.layout.h"
#include "RegionInterestmenu.layout.h"

extern GC default_gc, gc_xor;
extern Colormap Mapedit_colormap;

extern int PixelEditTool_Open_Flag;

extern char *disptabs[];

static int Coord_Top = True;
static int Coord_Left = True;


void Coord_top_down_actcall(w, data_display, callData)
    Widget          w;
    xs_struc_display_menu * data_display;
    caddr_t callData;
{
  Arg args[MAX_ARGS];
  int n;

  XCopyArea (XtDisplay(data_display->Drawing_Area), 
	     data_display->ret->pixmap, 
	     XtWindow(data_display->Drawing_Area), default_gc, 0, 0,
	     data_display->im_desc->ncolonne, 
	     data_display->im_desc->nligne, 0, 0);

  Coord_Top = !Coord_Top;

  XtUnmanageChild(w);
  n = 0;
  if (Coord_Top)
      XtSetArg(args[n],XmNlabelString, XmStringLtoRCreate(disptabs[11],
			XmSTRING_DEFAULT_CHARSET)); 
  else 
      XtSetArg(args[n],XmNlabelString, XmStringLtoRCreate(disptabs[12],
			XmSTRING_DEFAULT_CHARSET)); 
  n++;
  XtSetValues(w,args,n);
  XtManageChild(w);
  
}


void Coord_left_right_actcall(w, data_display, callData)
    Widget          w;
    xs_struc_display_menu * data_display;
    caddr_t callData;
{
  Arg args[MAX_ARGS];
  int n;

  XCopyArea (XtDisplay(data_display->Drawing_Area), 
	     data_display->ret->pixmap, 
	     XtWindow(data_display->Drawing_Area), default_gc, 0, 0,
	     data_display->im_desc->ncolonne, 
	     data_display->im_desc->nligne, 0, 0);

  Coord_Left = !Coord_Left;

  XtUnmanageChild(w);
  n = 0;
  if (Coord_Left)
      XtSetArg(args[n],XmNlabelString, XmStringLtoRCreate(disptabs[15],
			XmSTRING_DEFAULT_CHARSET)); 
  else 
      XtSetArg(args[n],XmNlabelString, XmStringLtoRCreate(disptabs[14],
			XmSTRING_DEFAULT_CHARSET)); 
  n++;
  XtSetValues(w,args,n);
  XtManageChild(w);
  
}



void track_mouse_position(w, data_display, event)
    Widget          w;
    xs_struc_display_menu * data_display;
    XEvent         *event;
{
  if (data_display->calliperON)
  {
    int X, Y, pixel;

   /*
    * Extract the position of the sprite from the event
    * and display it in the widgets. 
    */

    X = event->xmotion.x;
    Y = event->xmotion.y;
    pixel = (int)XGetPixel(data_display->ret->ximage, X, Y);

    sprintf (data_display->repfloat, "X:%04d Y:%04d Pix:%03d", 
	     X,Y,pixel); 

    if (Coord_Top)
    {
      XSetForeground(XtDisplay(data_display->Drawing_Area), default_gc, 0);
      if (Coord_Left)
	XFillRectangle(XtDisplay(data_display->Drawing_Area), 
		       XtWindow(data_display->Drawing_Area), 
		       default_gc, 0, 0, 132, 15);
      else 
	XFillRectangle(XtDisplay(data_display->Drawing_Area), 
		       XtWindow(data_display->Drawing_Area), 
		       default_gc, data_display->ret->width - 132, 
		       0, 132, 15);
 
      XSetForeground(XtDisplay(data_display->Drawing_Area), default_gc, 255);
      if (Coord_Left)
	XDrawString(XtDisplay(data_display->Drawing_Area), 
		    XtWindow(data_display->Drawing_Area), 
		    default_gc, 0, 10, data_display->repfloat,
		    strlen(data_display->repfloat));
      else 
	XDrawString(XtDisplay(data_display->Drawing_Area), 
		    XtWindow(data_display->Drawing_Area), 
		    default_gc, data_display->ret->width - 132, 10, 
		    data_display->repfloat,
		    strlen(data_display->repfloat));
    }
    else
    {
      XSetForeground(XtDisplay(data_display->Drawing_Area), default_gc, 0);
      if (Coord_Left)
	XFillRectangle(XtDisplay(data_display->Drawing_Area), 
		       XtWindow(data_display->Drawing_Area), 
		       default_gc, 0,data_display->ret->height - 15, 
		       132, data_display->ret->height);
      else 
	XFillRectangle(XtDisplay(data_display->Drawing_Area), 
		       XtWindow(data_display->Drawing_Area), 
		       default_gc, data_display->ret->width - 132,
		       data_display->ret->height - 15, 
		       132, data_display->ret->height);

      XSetForeground(XtDisplay(data_display->Drawing_Area), default_gc, 255);
      if (Coord_Left)
	XDrawString(XtDisplay(data_display->Drawing_Area), 
		    XtWindow(data_display->Drawing_Area), 
		    default_gc, 0, data_display->ret->height - 4,
		    data_display->repfloat,
		    strlen(data_display->repfloat));
      else 
	XDrawString(XtDisplay(data_display->Drawing_Area), 
		    XtWindow(data_display->Drawing_Area), 
		    default_gc, data_display->ret->width - 132,
		    data_display->ret->height - 4,
		    data_display->repfloat,
		    strlen(data_display->repfloat));
    }
  }
}



/******************************************************
/   activateCallback for Widget  Calliper_button 
/*****************************************************/

void
Calliper_actcall(Calliper_button, data_display, callData)
	Widget Calliper_button;
	xs_struc_display_menu * data_display;
	caddr_t callData;
{
  Arg args[MAX_ARGS];
  int n;

  XCopyArea (XtDisplay(data_display->Drawing_Area), 
	     data_display->ret->pixmap, 
	     XtWindow(data_display->Drawing_Area), default_gc, 0, 0,
	     data_display->im_desc->ncolonne, 
	     data_display->im_desc->nligne, 0, 0);

  data_display->calliperON = !data_display->calliperON;

  XtUnmanageChild(Calliper_button);

  n = 0;
  if (data_display->calliperON)
      XtSetArg(args[n],XmNlabelString, XmStringLtoRCreate(disptabs[13],
			XmSTRING_DEFAULT_CHARSET)); 
  else 
      XtSetArg(args[n],XmNlabelString, XmStringLtoRCreate(disptabs[4],
			XmSTRING_DEFAULT_CHARSET)); 
  n++;
  XtSetValues(Calliper_button,args,n);
  XtManageChild(Calliper_button);  
}


/******************************************************
/   activateCallback for Widget  Statistics_button 
/*****************************************************/

void
statistics_actcall(Statistics_button, im_desc, callData)
	Widget Statistics_button;
	struct image_ecran *im_desc;
	caddr_t callData;
{
  char    titre[25];
  Widget Statistic_display;
  Arg args[MAX_ARGS];
  int n;

  strcpy (titre, paneltabs[57]);
  Statistic_display = 
	   build_statistics_widget (Statistics_button, im_desc, titre);
  XtManageChild(Statistic_display);

  n = 0;
  XtSetArg(args[n],XmNsensitive, False); n++;
  XtSetValues(Statistics_button,args,n);
}


/******************************************************
/   activateCallback for Widget  Threshold_button 
/*****************************************************/

void
Threshold_actcall(Threshold_button, data_display, callData)
	Widget Threshold_button;
	xs_struc_display_menu * data_display;
	caddr_t callData;
{
  Widget Threshold_widget;
  Arg args[MAX_ARGS];
  int n;

  if (flag_help_only){
      hproc_threshold();
      return;
  }
  if (flag_help) hproc_threshold();

  Threshold_widget = 
     build_threshold_widget (Threshold_button, data_display);
  XtManageChild(Threshold_widget);

  n = 0;
  XtSetArg(args[n],XmNsensitive, False); n++;
  XtSetValues(Threshold_button,args,n);

}


/******************************************************
/   activateCallback for Widget  Region_Interest_button 
/*****************************************************/

void
RegionInterest_actcall(Region_Interest_button, data_display, callData)
	Widget Region_Interest_button;
	xs_struc_display_menu * data_display;
	caddr_t callData;
{
  Widget menuRegionInterest;
  Arg args[MAX_ARGS];
  int n;

  menuRegionInterest =
     build_RegionInterest_Menu (Region_Interest_button, 
				data_display);
  XtManageChild(menuRegionInterest);
 
  n = 0;
  XtSetArg(args[n],XmNsensitive, False); n++;
  XtSetValues(Region_Interest_button,args,n);
}



/******************************************************
/   activateCallback for Widget  Save_Color_Table_button 
/*****************************************************/

void
Save_Color_Table_actcall(SAVE, data_display, callData)
	Widget SAVE;
	xs_struc_display_menu * data_display;
	caddr_t callData;
{
  Widget planSortie;

  if (!Mapedit_colormap)
  {
    sprintf(buf, paneltabs[317]);
    write_master(buf);
    return;
  }

  sprintf(buf, paneltabs[318]);
  write_master(buf);

  planSortie = build_IOplans_widget(SAVE, 82, "", data_display);
  XtManageChild(planSortie);
}



/******************************************************
/   activateCallback for Widget  Pixel_Edit_button 
/*****************************************************/

void
Pixel_Edit_actcall(Pixel_Edit_button, data_display, callData)
	Widget Pixel_Edit_button;
	xs_struc_display_menu * data_display;
	caddr_t callData;
{
  Widget Pixel_edit_widget;
  int Type;
  float CC, Couleur_Corr;
  Arg args[MAX_ARGS];
  int n;

  if (flag_help_only){
    hproc_pixeditTool();
    return;
  }
  if (flag_help) hproc_pixeditTool();

  if (PixelEditTool_Open_Flag == TRUE)
  {
    write_erreur(983);
    return;
  }

  PixelEditTool_Open_Flag = TRUE;


  Type = data_display->ret->type;

  if ((Type == 4) || (Type == 5))
  {
    write_erreur(941);
    return;
  }
  if (Type == 6)
  {
    write_erreur(942);
    return;
  }

  switch (Type)
  {
  case -1:
    CC = data_display->im_desc->mu[0];
    if ((CC - data_display->im_desc->mini[0]) < (data_display->im_desc->maxi[0] - CC))
       Couleur_Corr = data_display->im_desc->mini[0];
    else
       Couleur_Corr = data_display->im_desc->maxi[0];
    break;
  case 0:
  case 1:
  case 2:
    Couleur_Corr = (int) (data_display->im_desc->mu[0] + 0.5);
    break;
  case 3:
    Couleur_Corr = data_display->im_desc->mu[0];
  }

  sprintf(buf, "PixelEditTool : \n");
  write_master(buf);

  Pixel_edit_widget = 
     build_pixel_edit_widget (Pixel_Edit_button, data_display, Couleur_Corr);
  XtManageChild(Pixel_edit_widget);

  n = 0;
  XtSetArg(args[n],XmNsensitive, False); n++;
  XtSetValues(Pixel_Edit_button, args, n);

}


/******************************************************
/   activateCallback for Widget  Profile_button 
/*****************************************************/

void
Profile_actcall(Profile_button, data_display, callData)
	Widget Profile_button;
	xs_struc_display_menu * data_display;
	caddr_t callData;
{
  Widget Profile_widget;
  Arg args[MAX_ARGS];
  int n;

  Profile_widget = 
     build_profile_widget (Profile_button, data_display);
  XtManageChild(Profile_widget);

  n = 0;
  XtSetArg(args[n],XmNsensitive, False); n++;
  XtSetValues(Profile_button,args,n);
}

