;**************************************************************************
;** net.lisp                                                             **
;**                                                                      **
;** Ce programme a les definitions, methodes et fonctions qui concernent **
;** la premiere partie du reseau de comparaison.                         **
;** Les net-nodes codifient les modeles (patterns) de la partie gauche   **
;** des regles de production. Quand les faits sont ajoutes a la base,ils **
;** sont compares avec ces nodes.                                        **
;**                                                                      **
;** Claudia Coiteux-Rosu     Juillet 1989                                **    
;**************************************************************************
;** Fonctions et methodes:                                               **
;** Liaison des modeles au reseau:                                       **
;**  add-patterns-net        make-fns-binds        add-fns-net           **
;**  add-pattern             remove-bind                                 **
;**                                                                      **
;** Comparaison des modeles:                                             **
;**  adds-fact               remove-fact                                 **
;**                                                                      **
;**************************************************************************


(eval-when (compile) (load "varenv")
                     (load "ps-util"))

;**************************************************************************
;** Definition du node net-node                                          **
;**************************************************************************
(defflavor net-node (
	(bind-nodes nil)    ; pointeur a la description du modele bind-node
	(path nil)	    ; atome  c..r, fonction d'acces a l'atome dans
                            ; le modele
	(assoc-branch nil)  ; liste de sous-listes (valeur  net-node)
	(else-branch nil)   ; pointeur a un autre net-node, si l'atome du
                            ; modele est atteint par une autre fonction que
                            ; celle de path
	)
  nil
 :initable-instance-variables)


;**************************************************************************
;** Fonctions et methodes pour ajouter et effacer un modele du reseau    **
;**************************************************************************
;** Ajoute un modele au reseau                                           **
(defun add-patterns-net (pats root)
  (let ((nodes (cond (pats 
                       (car (for p in pats
			       tcollect (funcall root 'add-pattern
                                               p (get-paths p)))))
                     (t (ncons (funcall root
                                         'add-pattern '(nil) nil))))))
       (for while (cdr nodes)
	    do (setq nodes
		     (car
		      (for bind (pair nodes (cddr pair))
			   while pair
			   tcollect (cond ((cdr pair)
					     (make-instance 'join-node
					       :left-feed (car pair)
					       :right-feed (cadr pair)))
					  (t (car pair)))))))
       (car nodes)))


;** Ajoute une liste de modeles-fonction au reseau et retourne une liste **
;** de bind-nodes                                                        **
(defun make-fns-binds (root fns)
   (cond ((null fns) nil)
         (t (cons (funcall root 'add-pattern (car fns) nil) 
                  (make-fns-binds root (cdr fns))))))


;** Ajoute une liste de fonctions au reseau **
(defun add-fns-net (root fns out-node)
   (for b in (reverse (make-fns-binds root fns))
        bind (j-node out-node)
             (varsj (symeval-in-instance out-node 'vars))
        do  (funcall b 'ordonne-vars-fcn varsj)
            (setq j-node (make-instance 'join-node
                           :left-feed   j-node
                           :right-feed  b))
        finally j-node))
 

;** Methode qui ajoute un modele au reseau                               **
(defmethod (net-node add-pattern) (pattern path-list)
 (let (new-bind path-pair next)
  (cond ((null path-list)
	   (setq new-bind (make-instance 'bind-node
			     :pattern pattern
			     :vars (get-vars pattern)
			     :net-link self
			     ))
	   (setq bind-nodes (cons new-bind bind-nodes))
	    new-bind)
	((null path)
	   (setq path (caar path-list))
	   (setq next (make-instance 'net-node))
	   (setq assoc-branch `((,(cadar path-list) ,next)))
	   (funcall next 'add-pattern pattern (cdr path-list)))
	((and (setq path-pair (assoc path path-list))
	      (setq next (cadr (assoc (cadr path-pair) assoc-branch))))
	   (funcall next 'add-pattern pattern 
                      (delete path-pair path-list :test 'eq :count 1)))
	(path-pair
	   (setq next (make-instance 'net-node))
	   (setq assoc-branch (cons `(,(cadr path-pair)  ,next)
				     assoc-branch))
	   (funcall next 'add-pattern pattern 
                      (delete path-pair path-list :test 'eq :count 1)))
	(else-branch
	   (funcall else-branch 'add-pattern pattern path-list))
	(t (setq else-branch (make-instance 'net-node))
	   (funcall else-branch 'add-pattern pattern path-list)))))


;** Methode qui efface un modele                                         **
(defmethod (net-node remove-bind) (bnd)
  (setq bind-nodes (delete bnd bind-nodes :test 'eq :count 1)))


;**************************************************************************
;** Comparaison des modeles et faits                                     **
;**************************************************************************
;** Comparaison d'un fait ajoute pour faire l'appariement                **
(defmethod (net-node adds-fact) (fact)
  (for b in bind-nodes do (funcall b 'adds-fact fact))
  (and path
       (let ((val (carcdrs path (symeval-in-instance fact 'value)))
	      next)
	    (setq next (and val (cadr (assoc val assoc-branch))))
	    (and next  (funcall next 'adds-fact fact))
	    (and else-branch (funcall else-branch 'adds-fact fact)))))


;** Comparaison d'un fait efface pour effacer les "bindings"             **
(defmethod (net-node remove-fact) (fact)
  (for b in bind-nodes do (funcall b 'remove-fact fact))
  (and path
       (let ((val (carcdrs path (symeval-in-instance fact 'value)))
	      next)
	    (setq next (and val (cadr (assoc val assoc-branch))))
	    (and next (funcall next 'remove-fact fact))
	    (and else-branch (funcall else-branch 'remove-fact fact)))))









