#!/usr/bin/awk -f
function sqr(a) {return a*a}
BEGIN {
 scale=0.65
# This scaling factor is necessary for compatibility with mol2pdb 
# If you have pdb data from other sources, you may have to fiddle with it.
 pdbscale=10.0
 datenfile=ARGV[2]?ARGV[2]:ENVIRON["HOME"]"/atoms.dec"
 datenfile=ENVIRON["CASCADE"]?ENVIRON["CASCADE"]"/atoms.dec":datenfile
 while (0!=getline <datenfile) {
  if (($0!~/#/)&&($0!~/;/)&&($0!~/\*/)&&($0!="")) {
   oznum[$1]=$4+0
   rad[$4+0]=$5*scale}}}
/^HEADER/ {name=$2}
/^ATOM/ {
 oz[++atome]=oznum[substr($3,1,1)]
 rest=substr($0,31); split (rest,field)
 x[atome]=field[1]*pdbscale
 y[atome]=field[2]*pdbscale
 z[atome]=field[3]*pdbscale}
END {
 print atome
 for (i=1; i<=atome; i++) print oz[i],x[i],y[i],z[i],1
 for (i=1; i<=atome; i++) {
  for (j=1; j<i; j++) {
   d2=sqr(x[i]-x[j])+sqr(y[i]-y[j])+sqr(z[i]-z[j])
   schwelle=(rad[oz[i]+0]+rad[oz[j]+0])
   if (d2<=sqr(schwelle)) {
    a[++bonds]=i
    b[bonds]=j}}}
 print -bonds 
 for (k=1; k<=bonds; k++) print a[k],b[k],1
 print 0}
