MOL23DV(1)            Utility Commands                  MOL23DV(1)

NAME
     mol23dv - converts VAMP .mol-files into 3DV .3dv-files

SYNOPSIS
     mol23dv [file]

DESCRIPTION
       Mol23dv converts a .mol-file (created by T. Clark's VAMP,
     or by one of cascade's own scripts) into a .3dv-file via an awk-script.
     (For information about awk see the documentation in the gawk directory)
       The .3dv-File can then be shown (using O. Garcia's 3dv)
     as a three-dimensional wire-frame object.
       Using your mouse (required) you can change the viewpoint's longitude
     and latitude respectively, change the perspective, graphics mode, etc.
     (For further information about 3dv read the documentation in the 3dv
      directory)

     The colors of the bonds depend on the connected atoms. (see below)

INSTALLATION
       You need awk and 3dv on your system. To create .mol-files you
     probably have to buy a copy of T. Clark's VAMP. Alternatively,
     you can port UNIX VAMP .mol-files to your PC or use the other
     cascade tools to create .mol-files.

     Put awk.exe, 3dv.exe, mol23dv.bat on your path and mol23dv.awk
     in the directory specified in mol23dv.bat

EXAMPLES
     Let's say there is a file h2o.mol (generated by Tim Clark's VAMP)
     Simply type:
     
	mol23dv h2o
     
     (no extension!), click mouse on SHOW and the molecule will be shown.
     Use the mouse to move your viewpoint around the molecule. If you're 
     done, click the button and click on EXIT.

REQUIRED FILES
       For running the program, you need:
     3dv.exe, awk.exe, mol23dv.bat (preferably on the path)
     mol23dv.awk (in the directory specified in mol23dv.bat)
     mol23dv.man (wherever you like it)

COPYING
     See the file COPYING.
     For the copyright of 3dv, see share\3dv\3dv.doc. We assume it's
     (at least) freely redistributable.

BUGS
     A possible problem may be the color of the bonds. (It's not a bug,
     it's a feature.) The coloring of the bonds is determined by the
     color of the atoms:
     We decided to categorize several atoms into certain classes and to 
     assign a specific color to each class as follows:
     class:     color:
	H       white
	F       light green
	Cl      dark green
	Br      light cyan
	I       dark cyan
	O       red
	S       yellow
	N       dark blue
	P       pink
	Si      light grey
	B       light blue
	Li      dark violet
	Mg      light violet
	C       dark grey
     metals     brown

     By the way, this scheme is a generalisation of the CPK colour
     scheme, which in turn is based upon the colors of the
     popular plastic spacefilling models which were developed by
     Corey, Pauling and later improved by Kultun and is
     the scheme conventionally used by chemists.

     If you don't like the colors (which were selected by Ralph to fit
     his personal chemical taste), you can change them in the atoms.dec
     file. If you don't like the categorization above, you will have
     to change the awk-script to fit your needs.

HISTORY
       mol23dv was formerly (in cascade, version 1) named trampel.
     For sake of consistency with cascade, version 2, it was
     renamed to mol23dv. Since version 2, it can also display
     .mol-files created by pac2mol, etc.
       Another innovation in version 2 is the coloring of the bonds:
     They are now half colored.

AUTHORS (i.e., send bug reports to)
     Michael Reichenb"acher (AWK-programming)
     reichenb@mi.uni-erlangen.de

     Ralph Puchta (chemical supervision / color choice)
     puchta@anorganik.chemie.uni-erlangen.de
