head	1.6;
access;
symbols
	Distribution_06:1.5
	IRT_02:1.4.2.1
	Philips_01:1.4.1.1
	D6Base:1.4
	Distribution_05:1.4
	Distribution_04:1.4
	Distribution_03:1.4
	Samsung_01:1.3
	IRT_01:1.3.2.1
	TI_01:1.3
	Distribution_01a:1.4
	Distribution_02:1.4
	Distribution_00:1.1
	Distribution_01:1.3;
locks; strict;
comment	@ * @;


1.6
date	96.02.12.07.13.35;	author rowlands;	state Exp;
branches;
next	1.5;

1.5
date	96.01.20.17.13.10;	author rowlands;	state Exp;
branches;
next	1.4;

1.4
date	95.06.16.06.29.49;	author rowlands;	state Exp;
branches
	1.4.1.0
	1.4.2.0
	1.4.3.0;
next	1.3;

1.3
date	95.04.06.04.29.39;	author rowlands;	state Exp;
branches
	1.3.2.0;
next	1.2;

1.2
date	95.04.06.02.07.35;	author rowlands;	state Exp;
branches;
next	1.1;

1.1
date	95.04.06.02.06.11;	author rowlands;	state Exp;
branches;
next	;

1.3.2.0
date	95.06.16.03.38.39;	author rowlands;	state Exp;
branches;
next	1.3.2.1;

1.3.2.1
date	95.06.16.03.46.42;	author rowlands;	state Exp;
branches;
next	;

1.4.1.0
date	95.11.06.04.11.34;	author rowlands;	state Exp;
branches;
next	1.4.1.1;

1.4.1.1
date	95.11.06.04.12.25;	author rowlands;	state Exp;
branches;
next	;

1.4.2.0
date	95.11.06.04.16.53;	author rowlands;	state Exp;
branches;
next	1.4.2.1;

1.4.2.1
date	95.11.06.04.19.12;	author rowlands;	state Exp;
branches;
next	;

1.4.3.0
date	95.11.06.04.22.45;	author rowlands;	state Exp;
branches;
next	1.4.3.1;

1.4.3.1
date	96.01.19.04.40.26;	author rowlands;	state Exp;
branches;
next	;


desc
@MPEG-2 public C encoder
@


1.6
log
@Release following Munich meeting
@
text
@/**********************************************************************
 * ISO MPEG Audio Subgroup Software Simulation Group (1996)
 * ISO 13818-3 MPEG-2 Audio Multichannel Encoder
 *
 * $Id: subs.c 1.5 1996/01/20 17:13:10 rowlands Exp $
 *
 * $Log: subs.c $
 * Revision 1.3.2.1  1995/06/16  03:46:42  rowlands
 * Input from Susanne Ritscher (IRT)
 *
 **********************************************************************/

/**********************************************************************
 *   date   programmers         comment                               *
 * 2/25/91  Davis Pan           start of version 1.0 records          *
 * 5/10/91  W. Joseph Carter    Ported to Macintosh and Unix.         *
 * 7/10/91  Earle Jennings      Ported to MsDos from Macintosh        *
 *                              Replacement of one float with FLOAT   *
 * 2/11/92  W. Joseph Carter    Added type casting to memset() args.  *
 **********************************************************************
 *                                                                    *
 *                                                                    *
 *  MPEG/audio Phase 2 coding/decoding multichannel                   *
 *                                                                    *
 *  7/27/93        Susanne Ritscher,  IRT Munich                      *
 *  8/27/93        Susanne Ritscher, IRT Munich                       *
 *                 Channel-Switching is working                       *
 *                                                                    *
 *  9/1/93         Susanne Ritscher,  IRT Munich                      *
 *                 all channels normalized                            *
 *  9/20/93        channel-switching is only performed at a           *
 *                 certain limit of TC_ALLOC dB, which is included    *
 *                 in encoder.h                                       *
 *                                                                    *
 *  Version 1.0                                                       *
 *                                                                    *
 *  07/12/94       Susanne Ritscher,  IRT Munich                      *
 *                 Tel: +49 89 32399 458                              *
 *                 Fax: +49 89 32399 415                              *
 *                                                                    *
 *  Version 1.1                                                       *
 *                                                                    *
 *  02/23/95	   Susanne Ritscher,  IRT Munich                      *
 *                 corrected some bugs                                *
 *                 extension bitstream is working                     *
 *                                                                    *
 **********************************************************************/

#include "common.h"
#include "encoder.h"

/*****************************************************************************
 ************************** Start of Subroutines *****************************
 *****************************************************************************/

/*****************************************************************************
 * FFT computes fast fourier transform of BLKSIZE samples of data            *
 *   uses decimation-in-frequency algorithm described in "Digital            *
 *   Signal Processing" by Oppenheim and Schafer, refer to pages 304         *
 *   (flow graph) and 330-332 (Fortran program in problem 5)                 *
 *   to get the inverse fft, change line 20 from                             *
 *                 w_imag[L] = -sin(PI/le1);                                 *
 *                          to                                               *
 *                 w_imag[L] = sin(PI/le1);                                  *
 *                                                                           *
 *   required constants:                                                     *
 *         #define      PI          3.14159265358979                         *
 *         #define      BLKSIZE     1024                                     *
 *         #define      LOGBLKSIZE  10                                       *
 *                                                                           *
 *****************************************************************************/

void fft(float *x_real, float *x_imag, float *energy, float *phi)
{
 static int     M, MM1;
 static int     init=0, N, NV2, NM1;
 static double  w_real[LOGBLKSIZE], w_imag[LOGBLKSIZE];
 int            i,j,k,ll;
 int            ip, le,le1;
 double         t_real, t_imag, u_real, u_imag;

 if(init==0) {
    memset((char *) w_real, 0, sizeof(w_real));  /* preset statics to 0 */
    memset((char *) w_imag, 0, sizeof(w_imag));  /* preset statics to 0 */
    M = LOGBLKSIZE;
    MM1 = LOGBLKSIZE-1;
    N = BLKSIZE;
    NV2 = BLKSIZE >> 1;
    NM1 = BLKSIZE - 1;
    for(ll=0; ll<M; ll++){
       le = 1 << (M-ll);
       le1 = le >> 1;
       w_real[ll] = cos(PI/le1);
       w_imag[ll] = -sin(PI/le1);
    }          
    init++;
 }
 for(ll=0; ll<MM1; ll++){
    le = 1 << (M-ll);
    le1 = le >> 1;
    u_real = 1;
    u_imag = 0;
    for(j=0; j<le1; j++){
       for(i=j; i<N; i+=le){
          ip = i + le1;
          t_real = x_real[i] + x_real[ip];
          t_imag = x_imag[i] + x_imag[ip];
          x_real[ip] = x_real[i] - x_real[ip];
          x_imag[ip] = x_imag[i] - x_imag[ip];
          x_real[i] = t_real;
          x_imag[i] = t_imag;
          t_real = x_real[ip];
          x_real[ip] = x_real[ip]*u_real - x_imag[ip]*u_imag;
          x_imag[ip] = x_imag[ip]*u_real + t_real*u_imag;
       }
       t_real = u_real;
       u_real = u_real*w_real[ll] - u_imag*w_imag[ll];
       u_imag = u_imag*w_real[ll] + t_real*w_imag[ll];
    }
 }
 /* special case: ll = M-1; all Wn = 1 */
 for(i=0; i<N; i+=2){
    ip = i + 1;
    t_real = x_real[i] + x_real[ip];
    t_imag = x_imag[i] + x_imag[ip];
    x_real[ip] = x_real[i] - x_real[ip];
    x_imag[ip] = x_imag[i] - x_imag[ip];
    x_real[i] = t_real;
    x_imag[i] = t_imag;
    energy[i] = x_real[i]*x_real[i] + x_imag[i]*x_imag[i];
    if(energy[i] <= 0.0005){phi[i] = 0;energy[i] = 0.0005;}
    else phi[i] = atan2((double) x_imag[i],(double) x_real[i]);
    energy[ip] = x_real[ip]*x_real[ip] + x_imag[ip]*x_imag[ip];
    if(energy[ip] == 0)phi[ip] = 0;
    else phi[ip] = atan2((double) x_imag[ip],(double) x_real[ip]);
 }
 /* this section reorders the data to the correct ordering */
 j = 0;
 for(i=0; i<NM1; i++){
    if(i<j){
/* use this section only if you need the FFT in complex number form *
 * (and in the correct ordering)                                    */
       t_real = x_real[j];
       t_imag = x_imag[j];
       x_real[j] = x_real[i];
       x_imag[j] = x_imag[i];
       x_real[i] = t_real;
       x_imag[i] = t_imag;
/* reorder the energy and phase, phi                                        */
       t_real = energy[j];
       energy[j] = energy[i];
       energy[i] = t_real;
       t_real = phi[j];
       phi[j] = phi[i];
       phi[i] = t_real;
    }
    k=NV2;
    while(k<=j){
       j = j-k;
       k = k >> 1;
    }
    j = j+k;
 }
}
@


1.5
log
@Moved Merged into main trunk
@
text
@d2 2
a3 3
 * Copyright (c) 1995 MPEG/audio software simulation group
 * All Rights Reserved
 * $Id: subs.c 1.4.3.1 1996/01/19 04:40:26 rowlands Exp $
d5 1
a5 3
 * MPEG/audio coding/decoding software, work in progress
 *   NOT for public distribution until verified and approved by the
 *   MPEG/audio committee.
a7 12
 * Revision 1.4.3.1  1996/01/19  04:40:26  rowlands
 * Merged
 *
 * Revision 1.4.2.1  1995/11/06  04:19:12  rowlands
 * Received from Uwe Felderhoff
 *
 * Revision 1.4.1.1  1995/11/06  04:12:25  rowlands
 * Received from Warner ten Kate
 *
 * Revision 1.4  1995/06/16  06:29:49  rowlands
 * Moved merged IRT/TI into main revision control trunk.
 *
d9 1
a9 4
 * Input from IRT
 *
 * Revision 1.3  1995/04/06  04:29:39  rowlands
 * Added header and RCS info to initial revision.
a13 2
 * VERSION 2.5                                                        *
 *   changes made since last update:                                  *
d35 1
a35 1
 *  Version 1.0 Shareware                                             *
d41 1
a41 1
 *  Version 1.1 Shareware                                             *
@


1.4
log
@Moved merged IRT/TI into main revision control trunk.
@
text
@d4 1
a4 1
 * $Id: subs.c 1.3.2.1 1995/06/16 03:46:42 rowlands Exp $
d11 12
@


1.4.3.0
log
@Branch for merging IRT_02 and Philips_01
@
text
@d4 1
a4 1
 * $Id: subs.c 1.4 1995/06/16 06:29:49 rowlands Exp $
a10 3
 * Revision 1.4  1995/06/16  06:29:49  rowlands
 * Moved merged IRT/TI into main revision control trunk.
 *
@


1.4.3.1
log
@Merged
@
text
@d4 1
a4 1
 * $Id: subs.c 1.4.1.1 1995/11/06 04:12:25 rowlands Exp $
a10 6
 * Revision 1.4.2.1  1995/11/06  04:19:12  rowlands
 * Received from Uwe Felderhoff
 *
 * Revision 1.4.1.1  1995/11/06  04:12:25  rowlands
 * Received from Warner ten Kate
 *
@


1.4.2.0
log
@Branch for Felderhoff
@
text
@d4 1
a4 1
 * $Id: subs.c 1.4 1995/06/16 06:29:49 rowlands Exp $
a10 3
 * Revision 1.4  1995/06/16  06:29:49  rowlands
 * Moved merged IRT/TI into main revision control trunk.
 *
@


1.4.2.1
log
@Received from Uwe Felderhoff
@
text
@@


1.4.1.0
log
@Branch for ten Kate
@
text
@d4 1
a4 1
 * $Id: subs.c 1.4 1995/06/16 06:29:49 rowlands Exp $
a10 3
 * Revision 1.4  1995/06/16  06:29:49  rowlands
 * Moved merged IRT/TI into main revision control trunk.
 *
@


1.4.1.1
log
@Received from Warner ten Kate
@
text
@@


1.3
log
@Added header and RCS info to initial revision.
@
text
@d4 1
a4 1
 * $Id$
d10 7
a16 1
 * $Log$
d86 1
a86 1
 int            i,j,k,L;
d98 2
a99 2
    for(L=0; L<M; L++){
       le = 1 << (M-L);
d101 2
a102 2
       w_real[L] = cos(PI/le1);
       w_imag[L] = -sin(PI/le1);
d106 2
a107 2
 for(L=0; L<MM1; L++){
    le = 1 << (M-L);
d125 2
a126 2
       u_real = u_real*w_real[L] - u_imag*w_imag[L];
       u_imag = u_imag*w_real[L] + t_real*w_imag[L];
d129 1
a129 1
 /* special case: L = M-1; all Wn = 1 */
@


1.3.2.0
log
@Created branch for IRT
@
text
@d4 1
a4 1
 * $Id: subs.c 1.3 1995/04/06 04:29:39 rowlands Exp $
d10 1
a10 4
 * $Log: subs.c $
 * Revision 1.3  1995/04/06  04:29:39  rowlands
 * Added header and RCS info to initial revision.
 *
@


1.3.2.1
log
@Input from IRT
@
text
@d4 1
a4 1
 * $Id: subs.c,v 1.3 1995/04/06 04:29:39 rowlands Exp $
d10 1
a10 1
 * $Log: subs.c,v $
d83 1
a83 1
 int            i,j,k,ll;
d95 2
a96 2
    for(ll=0; ll<M; ll++){
       le = 1 << (M-ll);
d98 2
a99 2
       w_real[ll] = cos(PI/le1);
       w_imag[ll] = -sin(PI/le1);
d103 2
a104 2
 for(ll=0; ll<MM1; ll++){
    le = 1 << (M-ll);
d122 2
a123 2
       u_real = u_real*w_real[ll] - u_imag*w_imag[ll];
       u_imag = u_imag*w_real[ll] + t_real*w_imag[ll];
d126 1
a126 1
 /* special case: ll = M-1; all Wn = 1 */
@


1.2
log
@Processed with protoize
@
text
@d2 11
a12 3
Copyright (c) 1991 MPEG/audio software simulation group, All Rights Reserved
subs.c
**********************************************************************/
a13 5
 * MPEG/audio coding/decoding software, work in progress              *
 *   NOT for public distribution until verified and approved by the   *
 *   MPEG/audio committee.  For further information, please contact   *
 *   Davis Pan, 508-493-2241, e-mail: pan@@gauss.enet.dec.com          *
 *                                                                    *
@


1.1
log
@Initial revision
@
text
@d72 1
a72 2
void fft(x_real,x_imag, energy, phi)
FLOAT x_real[BLKSIZE], x_imag[BLKSIZE], energy[BLKSIZE], phi[BLKSIZE];
@
