head	1.9;
access;
symbols
	Distribution_06:1.7
	IRT_02:1.6.2.1
	Philips_01:1.6.1.1
	D6Base:1.6
	Distribution_05:1.6
	Distribution_04:1.6
	Distribution_03:1.6
	Samsung_01:1.4.3.1
	IRT_01:1.4.2.1
	TI_01:1.4.1.4
	Distribution_01a:1.5
	Distribution_02:1.6
	Distribution_00:1.1
	Distribution_01:1.4;
locks; strict;
comment	@ * @;


1.9
date	96.02.12.07.13.35;	author rowlands;	state Exp;
branches;
next	1.8;

1.8
date	96.02.12.05.51.17;	author rowlands;	state Exp;
branches;
next	1.7;

1.7
date	96.01.20.17.13.10;	author rowlands;	state Exp;
branches;
next	1.6;

1.6
date	95.06.16.10.01.27;	author rowlands;	state Exp;
branches
	1.6.1.0
	1.6.2.0
	1.6.3.0;
next	1.5;

1.5
date	95.06.16.06.29.49;	author rowlands;	state Exp;
branches;
next	1.4;

1.4
date	95.04.06.04.29.39;	author rowlands;	state Exp;
branches
	1.4.1.0
	1.4.2.0
	1.4.3.0;
next	1.3;

1.3
date	95.04.06.03.32.04;	author rowlands;	state Exp;
branches;
next	1.2;

1.2
date	95.04.06.02.07.35;	author rowlands;	state Exp;
branches;
next	1.1;

1.1
date	95.04.06.02.06.11;	author rowlands;	state Exp;
branches;
next	;

1.4.1.0
date	95.06.07.00.56.16;	author rowlands;	state Exp;
branches;
next	1.4.1.1;

1.4.1.1
date	95.06.11.23.26.49;	author rowlands;	state Exp;
branches;
next	1.4.1.2;

1.4.1.2
date	95.06.12.00.54.04;	author rowlands;	state Exp;
branches;
next	1.4.1.3;

1.4.1.3
date	95.06.14.03.03.55;	author rowlands;	state Exp;
branches;
next	1.4.1.4;

1.4.1.4
date	95.06.16.02.49.33;	author rowlands;	state Exp;
branches;
next	;

1.4.2.0
date	95.06.16.03.38.05;	author rowlands;	state Exp;
branches;
next	1.4.2.1;

1.4.2.1
date	95.06.16.03.46.42;	author rowlands;	state Exp;
branches;
next	1.4.2.2;

1.4.2.2
date	95.06.16.04.45.49;	author rowlands;	state Exp;
branches;
next	1.4.2.3;

1.4.2.3
date	95.06.16.06.27.33;	author rowlands;	state Exp;
branches;
next	;

1.4.3.0
date	95.06.16.08.20.22;	author rowlands;	state Exp;
branches;
next	1.4.3.1;

1.4.3.1
date	95.06.16.08.25.11;	author rowlands;	state Exp;
branches;
next	1.4.3.2;

1.4.3.2
date	95.06.16.09.57.51;	author rowlands;	state Exp;
branches;
next	;

1.6.1.0
date	95.11.06.04.11.27;	author rowlands;	state Exp;
branches;
next	1.6.1.1;

1.6.1.1
date	95.11.06.04.12.25;	author rowlands;	state Exp;
branches;
next	;

1.6.2.0
date	95.11.06.04.16.49;	author rowlands;	state Exp;
branches;
next	1.6.2.1;

1.6.2.1
date	95.11.06.04.19.12;	author rowlands;	state Exp;
branches;
next	;

1.6.3.0
date	95.11.06.04.22.40;	author rowlands;	state Exp;
branches;
next	1.6.3.1;

1.6.3.1
date	96.01.19.04.40.26;	author rowlands;	state Exp;
branches;
next	;


desc
@MPEG-2 public C encoder
@


1.9
log
@Release following Munich meeting
@
text
@/**********************************************************************
 * ISO MPEG Audio Subgroup Software Simulation Group (1996)
 * ISO 13818-3 MPEG-2 Audio Multichannel Encoder
 *
 * $Id: musicin.c 1.8 1996/02/12 05:51:17 rowlands Exp $
 *
 * $Log: musicin.c $
 * Revision 1.6.2.1  1995/11/06  04:19:12  rowlands
 * Received from Uwe Felderhoff (IRT)
 *
 * Revision 1.8  1995/08/14  07:57:11  tenkate
 * ML-LSF added Warner ten Kate 7/8/95 (Philips)
 * debugging (whole packet)
 * obtain_params() and parse_args() cleaned up.
 * get_audio_ml() and Psycho_one_ml() only add odd frames upon LSF-ML.
 * II_smr() is called separately because of that.
 * sample shifting is added because of that.
 *
 * Revision 1.7  1995/07/31  07:49:58  tenkate
 * addition of phantom coding, at sevral lines, 25/07/95 WtK
 *
 * Revision 1.4.3.1  1995/06/16  08:25:11  rowlands
 * Input from Sang Wook Kim (Samsung AIT)
 *
 * Revision 1.4.2.1  1995/06/16  03:46:42  rowlands
 * Input from Susanne Ritscher (IRT)
 *
 * Revision 1.4.1.4  1995/06/16  02:49:33  rowlands
 * Added dematrix procedure 2
 *
 * Added support for dematrix procedure 2, without predistortion yet.
 * Calculated the compatible stereo signal subband samples by
 * transforming the compatible signal used for the psychoacoustics,
 * instead of recalculating in the subband domain from the other
 * channels.
 *
 **********************************************************************/

/**********************************************************************
 *   date   programmers         comment                               *
 * 3/01/91  Douglas Wong,       start of version 1.1 records          *
 *          Davis Pan                                                 *
 * 3/06/91  Douglas Wong,       rename: setup.h to endef.h            *
 *                              removed extraneous variables          *
 * 3/21/91  J.Georges Fritsch   introduction of the bit-stream        *
 *                              package. This package allows you      *
 *                              to generate the bit-stream in a       *
 *                              binary or ascii format                *
 * 3/31/91  Bill Aspromonte     replaced the read of the SB matrix    *
 *                              by an "code generated" one            *
 * 5/10/91  W. Joseph Carter    Ported to Macintosh and Unix.         *
 *                              Incorporated Jean-Georges Fritsch's   *
 *                              "bitstream.c" package.                *
 *                              Modified to strictly adhere to        *
 *                              encoded bitstream specs, including    *
 *                              "Berlin changes".                     *
 *                              Modified user interface dialog & code *
 *                              to accept any input & output          *
 *                              filenames desired.  Also added        *
 *                              de-emphasis prompt and final bail-out *
 *                              opportunity before encoding.          *
 *                              Added AIFF PCM sound file reading     *
 *                              capability.                           *
 *                              Modified PCM sound file handling to   *
 *                              process all incoming samples and fill *
 *                              out last encoded frame with zeros     *
 *                              (silence) if needed.                  *
 *                              Located and fixed numerous software   *
 *                              bugs and table data errors.           *
 * 27jun91  dpwe (Aware Inc)    Used new frame_params struct.         *
 *                              Clear all automatic arrays.           *
 *                              Changed some variable names,          *
 *                              simplified some code.                 *
 *                              Track number of bits actually sent.   *
 *                              Fixed padding slot, stereo bitrate    *
 *                              Added joint-stereo : scales L+R.      *
 * 6/12/91  Earle Jennings      added fix for MS_DOS in obtain_param  *
 * 6/13/91  Earle Jennings      added stack length adjustment before  *
 *                              main for MS_DOS                       *
 * 7/10/91  Earle Jennings      conversion of all float to FLOAT      *
 *                              port to MsDos from MacIntosh completed*
 * 8/ 8/91  Jens Spille         Change for MS-C6.00                   *
 * 8/22/91  Jens Spille         new obtain_parameters()               *
 *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           *
 *          Don H. Lee,                                               *
 *          Peter W. Farrett                                          *
 *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   *
 *                              newly introduced functions are        *
 *                              I_CRC_calc, II_CRC_calc and encode_CRC*
 *                              Additions and revisions are marked    *
 *                              with "dhl" for clarity                *
 *11/11/91 Katherine Wang       Documentation of code.                *
 *                                (variables in documentation are     *
 *                                surround by the # symbol, and an '*'*
 *                                denotes layer I or II versions)     *
 * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   *
 *                              important fixes involved changing     *
 *                              16-bit ints to long or unsigned in    *
 *                              bit alloc routines for quant of 65535 *
 *                              and passing proper function args.     *
 *                              Removed "Other Joint Stereo" option   *
 *                              and made bitrate be total channel     *
 *                              bitrate, irrespective of the mode.    *
 *                              Fixed many small bugs & reorganized.  *
 * 2/25/92  Masahiro Iwadare    made code cleaner and more consistent *
 *10 jul 92 Susanne Ritscher    Bug fix in main, scale factor calc.   *
 * 5 aug 92 Soren H. Nielsen    Printout of bit allocation.           *
 *19 aug 92 Soren H. Nielsen	Changed MS-DOS file name extensions.  *
 * 2 dec 92 Susanne Ritscher	Start of changes to multi-channel with*
 *                                                  several options   *										 *
 **********************************************************************
 *                                                                    *
 *                                                                    *
 *  MPEG/audio Phase 2 coding/decoding multichannel                   *
 *                                                                    *
 *                                                                    *
 *  7/27/93        Susanne Ritscher,  IRT Munich                      *
 *                                                                    *
 *	                                                              *
 *  8/13/93        implemented channel-switching by changing          *
 *                 a lot in encode.c                                  *
 *                                                                    *
 *  8/27/93        Susanne Ritscher, IRT Munich                       *
 *                 Channel-Switching is working                       *
 *  9/1/93         Susanne Ritscher,  IRT Munich                      *
 *                 all channels normalized                            *
 *  9/20/93        channel-switching is only performed at a           *
 *                 certain limit of TC_ALLOC dB, which is included    *
 *                 in encoder.h                                       *
 *  1/04/94        try get all the rubbish out!                       *
 *                                                                    *
 *                                                                    *
 *  Version 1.0                                                       *
 *                                                                    *
 *  07/12/94       Susanne Ritscher,  IRT Munich                      *
 *                                                                    *
 *  Version 1.1                                                       *
 *                                                                    *
 *  02/23/95	   Susanne Ritscher,  IRT Munich                      *
 *                 corrected some bugs                                *
 *                 extension bitstream is working                     *
 *                                                                    *
 **********************************************************************/
/**********************************************************************
 *                                                                    *
 *  06/06/95	   Yeon Bae Thomas Kim,  Samsung AIT                  *
 *                 ancillary data is working                          *
 *                                                                    *
 *  06/06/95	   Sang Wook Kim,  Samsung AIT                        *
 *                 corrected some bugs                                *
 *                                                                    *
 **********************************************************************/
#ifdef MS_DOS
#include <dos.h>
#endif
#include "common.h"
#include "encoder.h"
#include <math.h>

/* Global variable definitions for "musicin.c" */

FILE               *musicin;
FILE               *musicin_ml;	/* 08/03/1995 JMZ Multilingual */
Bit_stream_struc   bs;
Bit_stream_struc   bs_ext;
Bit_stream_struc   bs_mpg;
char               *programName;
int		   mesg_index=0; /* YBKim060695 ancillary */
int		   verbosity;

char multilingual_file_name[MAX_NAME_SIZE];	/* 08/03/1995 JMZ Multilingual */

/* Implementations */

/************************************************************************
/*
/* obtain_parameters
/*
/* PURPOSE:  Prompts for and reads user input for encoding parameters
/*
/* SEMANTICS:  The parameters read are:
/* - input and output filenames
/* - sampling frequency (if AIFF file, will read from the AIFF file header)
/* - layer number
/* - mode (stereo, joint stereo, dual channel or mono)
/* - psychoacoustic model (I or II)
/* - total bitrate, irrespective of the mode
/* - de-emphasis, error protection, copyright and original or copy flags
/*
/************************************************************************/

void
obtain_parameters(
	frame_params *fr_ps,
	int *psy,
	long unsigned int *num_samples,
	long unsigned int *num_samples_ml,
	char *original_file_name,
	char *encoded_file_name,
	IFF_AIFF *pcm_aiff_data,
	IFF_AIFF *pcm_aiff_data_ml,
	int *aiff,
	int *byte_per_sample,
	int *cha_sw,
	char *encoded_file_name_ext,
	int *bit_rate,
	char *encoded_file_name_mpg,
	int *dyn_cr,
	int *ancillaryUse,
	int *verbosity
) {
	 int j,bool;
	 long int i;
	 int tot_channels =0;		/* 21/03/1995 JMZ Multimode */ 
	 char configuration[50];	/* 21/03/1995 JMZ Multimode */
	 char t[50];

	 layer *info = fr_ps->header;

	 *aiff = 0;	 /* flag for AIFF-Soundfile*/
	 *cha_sw = 1;

	/********* 05/24/95, SR , dynamic cross_talk ********************/
	 *dyn_cr = 0;
	 
    do  {
       printf("Enter PCM input file name <required>: ");
       gets(original_file_name);
       if (original_file_name[0] == NULL_CHAR)
       printf("PCM input file name is required.\n");
    } while (original_file_name[0] == NULL_CHAR);
    printf(">>> PCM input file name is: %s\n", original_file_name);
 
    if ((musicin = fopen(original_file_name, "rb")) == NULL) {
       printf("Could not find \"%s\".\n", original_file_name);
       exit(0);
	 }
/***************************************************************************/
/* 08/03/1995 Multi lingual extension JMZ                                  */

printf("Do you have multi lingual channels? (Y)es, (<N>)o: ");
gets(multilingual_file_name);
if ((*multilingual_file_name=='Y')||(multilingual_file_name[0]=='y'))
{
	printf("Enter multilingual input file name <%s.%s>: ",original_file_name,DFLT_ML_EXT);
	gets(multilingual_file_name);
	if (multilingual_file_name[0] == NULL_CHAR)
	{
		printf("Null char\n");
		strcat(strcpy(multilingual_file_name, original_file_name), DFLT_ML_EXT);
	}
	if ((musicin_ml = fopen(multilingual_file_name, "rb")) == NULL) 
	{
		printf("Could not find \"%s\".\n", multilingual_file_name);
		exit(0);
	}
/*remplir fr_ps il y a au moins un multilingual*/
	if (aiff_read_headers(musicin_ml, pcm_aiff_data_ml, byte_per_sample) == 0) 
	{
		printf(">>> Using Audio IFF multilingual file headers\n");
		info->multiling_ch = pcm_aiff_data_ml->numChannels;
		printf(">>> Using %d multilingual channels\n",info->multiling_ch);
                *num_samples_ml = pcm_aiff_data_ml->numChannels *
                                  pcm_aiff_data_ml->numSampleFrames;
	}
	else     /* Not using Audio IFF sound file headers. */
	{
		printf("***WARNING: Could not read AIFF header - No MultiLingual coding!!\n");
	        info->multiling_ch = 0;
	}
}

/* 08/03/1995 Multi lingual extension JMZ                                  */
/***************************************************************************/
	
    printf("Enter MPEG encoded output file name <%s%s>: ",
		original_file_name, DFLT_EXT);

    gets(encoded_file_name);
    if (encoded_file_name[0] == NULL_CHAR)

      strcat(strcpy(encoded_file_name, original_file_name), DFLT_EXT);

    printf(">>> MPEG encoded output file name is: %s\n", encoded_file_name);
 
    open_bit_stream_w(&bs, encoded_file_name, BUFFER_SIZE);
 
	 if (aiff_read_headers(musicin, pcm_aiff_data, byte_per_sample) == 0) {

		 printf(">>> Using Audio IFF sound file headers\n");

/**********************************************************/
/* 21/03/1995 JMZ Multimode */
		 tot_channels = pcm_aiff_data->numChannels;
		printf(">>> Using %d audio channels\n",tot_channels);
		if(tot_channels == 6)
	        {
		    info->lfe = 1;
		    printf("lfe is used\n");
		}

		 *aiff = 1;
		 tot_channels = pcm_aiff_data->numChannels;
		 if(tot_channels == 5) 
		 	{
		 	fr_ps->stereomc =3;
    		printf("Which configuration do you want to use?\n");
    		printf("Available: 3/2 (<1>), 3/0 + 2/0 (2): ");
    		gets(configuration);
    		switch(*configuration)
    			{
       			case '1': 
       				info->center = 1; 
       				info->surround = 2; 
       				break;
       			case '2': 
      				info->center = 1; 
       				info->surround = 3; 
       				break;
       			default:  
      				info->center = 1; 
       				info->surround = 2; 
       				printf(">>> Using default 3/2 configuration.\n"); 
       				break;
	 			}
		 	}
		 if(tot_channels == 4) 
		 	{
		 	fr_ps->stereomc =2;
    		printf("Which configuration do you want to use?\n");
    		printf("Available: 3/1 (<1>), 2/2 (2), 2/0 + 2/0 (3): ");
    		gets(configuration);
    		switch(*configuration)
    			{
       			case '1': 
       				info->center = 1; 
       				info->surround = 1; 
       				break;
       			case '2': 
      				info->center = 0; 
       				info->surround = 2; 
       				break;
       			case '3': 
      				info->center = 0; 
       				info->surround = 3; 
       				break;
       			default:  
      				info->center = 1; 
       				info->surround = 1; 
       				printf(">>> Using default 3/1 configuration.\n"); 
       				break;
	 			}
		 	}
		 if(tot_channels == 3) 
		 	{
		 	fr_ps->stereomc =1;
    		printf("Which configuration do you want to use?\n");
    		printf("Available: 3/0 (<1>), 2/1 (2): ");
    		gets(configuration);
    		switch(*configuration)
    			{
       			case '1': 
       				info->center = 1; 
       				info->surround = 0; 
       				printf(">>> Using 3/0 configuration.\n"); 
       				break;
       			case '2': 
      				info->center = 0; 
       				info->surround = 1; 
       				printf(">>> Using 2/1 configuration.\n"); 
       				break;
       			default:  
      				info->center = 1; 
       				info->surround = 0; 
       				printf(">>> Using default 3/0 configuration.\n"); 
       				break;
	 			}
		 	}
		 if(tot_channels == 2) 
		 	{
		 	fr_ps->stereomc =0;
		 	}
		 if(tot_channels == 1) 
		 	{
		 	fr_ps->stereomc =0;
		 	}
		 aiff_check(original_file_name, pcm_aiff_data);
/* 21/03/1995 JMZ Multimode */
/**********************************************************/


       info->sampling_frequency = SmpFrqIndex((long)pcm_aiff_data->sampleRate);
       printf(">>> %.f Hz sampling frequency selected\n",
				  pcm_aiff_data->sampleRate);

       /* Determine number of samples in sound file */
       *num_samples = pcm_aiff_data->numChannels *
                      pcm_aiff_data->numSampleFrames;

       if (info->multiling_ch>0) {
         switch (SmpFrqIndex((long)pcm_aiff_data_ml->sampleRate) - info->sampling_frequency) {
	 case 16 : printf("MultiLingual is LSF coded.\n");
	           info->multiling_fs = 1;
		   break;
	 case  0 : printf("MultiLingual sample rate equals that of Audio.\n");
	           info->multiling_fs = 0;
		   break;
	 default : printf("\n***WARNING: MultiLingual sample rate does not equal (half) mc sample rate.\n            No MultiLingual coding!!!\n\n");
	           info->multiling_ch = 0;
		   break;
	 } /*switch*/
       } /*if (ml_ch>0)*/
    }
    else {    /* Not using Audio IFF sound file headers. */
		 printf("no multichannel coding!!\n");
		fr_ps->stereomc = 0;
	        info->multiling_ch = 0;
       printf("What is the sampling frequency? <48000>[Hz]: ");
       gets(t);
       i = atol(t);
       switch (i) {
          case 48000 : info->sampling_frequency = 1;
              printf(">>> %ld Hz sampling freq selected\n", i);
              break;
          case 44100 : info->sampling_frequency = 0;
              printf(">>> %ld Hz sampling freq selected\n", i);
              break;
          case 32000 : info->sampling_frequency = 2;
              printf(">>> %ld Hz sampling freq selected\n", i);
              break;
          default:    info->sampling_frequency = 1;
              printf(">>> Default 48 kHz samp freq selected\n");
       }
 
       if (fseek(musicin, 0, SEEK_SET) != 0) {
          printf("Could not seek to PCM sound data in \"%s\".\n",
                  original_file_name);
          exit(0);
       }
 
       /* Declare sound file to have "infinite" number of samples. */
       *num_samples = MAX_U_32_NUM;

    }

    printf("Which layer do you want to use?\n");
    printf("Available: Layer (1), Layer (<2>): ");
    gets(t);
    switch(*t){
       case '1': info->lay = 1; printf(">>> Using Layer %s\n",t); break;
       case '2': info->lay = 2; printf(">>> Using Layer %s\n",t); break;
       default:  info->lay = 2; printf(">>> Using default Layer 2\n"); break;
	 }

	if( *aiff == 1)
	{
	 printf("Which mode do you want for the two front channels?\n");
         printf("Available: (<s>)tereo, (j)oint stereo, ");
	 printf("(d)ual channel, s(i)ngle Channel, n<o>ne: ");
          gets(t);
           switch(*t){
             case 's':
             case 'S':
	        info->mode = MPG_MD_STEREO; info->mode_ext = 0;
		 printf(">>> Using mode %s\n",t);
	          break;
	     case 'j':
             case 'J':
	        info->mode = MPG_MD_JOINT_STEREO;
	          printf(">>> Using mode %s\n",t);
	          break;
             case 'd':
             case 'D':
	          info->mode = MPG_MD_DUAL_CHANNEL; info->mode_ext = 0;
	          printf(">>> Using mode %s\n",t);
	          break;
             case 'i':
             case 'I':
	          info->mode = MPG_MD_MONO; info->mode_ext = 0;
	          printf(">>> Using mode %s\n",t);
	       	  break;
             case 'o':
             case 'O':
	          info->mode = MPG_MD_NONE; info->mode_ext = 0;
	          printf(">>> Using mode %s\n",t);
	       	  break;
             default:
	          info->mode = MPG_MD_STEREO; info->mode_ext = 0;
	          printf(">>> Using default stereo mode\n");
	          break;
           }
	}
	else    /* not aiff */
	{
	    printf("Available: (<s>)tereo, (j)oint stereo, ");
	    printf("(d)ual channel, s(i)ngle Channel: ");
	        gets(t);
	        switch(*t){
	           case 's':
	           case 'S':
	              info->mode = MPG_MD_STEREO; info->mode_ext = 0;
	              printf(">>> Using mode %s\n",t);
	              break;
	           case 'j':
	           case 'J':
	              info->mode = MPG_MD_JOINT_STEREO;
	              printf(">>> Using mode %s\n",t);
	              break;
	           case 'd':
	           case 'D':
	              info->mode = MPG_MD_DUAL_CHANNEL; info->mode_ext = 0;
	              printf(">>> Using mode %s\n",t);
	              break;
	           case 'i':
	           case 'I':
	              info->mode = MPG_MD_MONO; info->mode_ext = 0;
	              printf(">>> Using mode %s\n",t);
		      break;
	           default:
	              info->mode = MPG_MD_STEREO; info->mode_ext = 0;
	              printf(">>> Using default stereo mode\n");
	              break;
                }
	}


		 *psy = 1;

	 printf("What is the total bitrate? <%u>[kbps]: ", DFLT_BRT);
		gets(t);
		i = atol(t);
		if (i == 0) i = -10;
		j=0;
		 while (j<=15) 
		 {
		  if (bitrate[info->lay-1][j] == (int) i) break;
		  j++;
		 }
		 if (j==16) 
		 {
		  if(i <= 384)
		  {
	            printf(">>> Using default %u kbps\n", DFLT_BRT);
		    for (j=0;j<15;j++)
	            if (bitrate[info->lay-1][j] == DFLT_BRT) 
		    {
	              info->bitrate_index = j;
	              break;
	            }
		  }
		  else
		  {
		       info->ext_bit_stream_present = 1;
		       info->n_ad_bytes = 1; /* for DTB!!! 06/14/94 */
		       for (j=0;j<15;j++)
		       if (bitrate[info->lay-1][j] == DFLT_BRT) 
		       {
			   info->bitrate_index = j;
			   break;
		       }
		       *bit_rate = i;
		       info->ext_length = ((i - DFLT_BRT) * 24) / 8;
		  }			   
		 }
		 else
		 {
		  info->bitrate_index = j;
		  printf(">>> Bitrate = %d kbps\n", bitrate[info->lay-1][j]);
		 }


 
    printf("What type of de-emphasis should the decoder use?\n");
    printf("Available: (<n>)one, (5)0/15 microseconds, (c)citt j.17: ");
    gets(t);
    if (*t != 'n' && *t != '5' && *t != 'c') {
       printf(">>> Using default no de-emphasis\n");
       info->emphasis = 0;
    }
    else {
       if (*t == 'n')      info->emphasis = 0;
       else if (*t == '5') info->emphasis = 1;
       else if (*t == 'c') info->emphasis = 3;
       printf(">>> Using de-emphasis %s\n",t);
    }
 
/*  Start 2. Part changes for CD Ver 3.2; jsp; 22-Aug-1991 */
 
    printf("Do you want to set the private bit? (y/<n>): ");
    gets(t);
    if (*t == 'y' || *t == 'Y') info->extension = 1;
    else                        info->extension = 0;
    if(info->extension) printf(">>> Private bit set\n");
    else                printf(">>> Private bit not set\n");
 
/*  End changes for CD Ver 3.2; jsp; 22-Aug-1991 */
	
	 printf("Do you want error protection? (y/<n>): ");
	 gets(t);
	 if (*t == 'y' || *t == 'Y') info->error_protection = TRUE;
         else                        info->error_protection = FALSE;
	 if(info->error_protection) printf(">>> Error protection used\n");
	 else printf(">>> Error protection not used\n");
	

    printf("Is the material copyrighted? (y/<n>): ");
    gets(t);
    if (*t == 'y' || *t == 'Y') info->copyright = 1;
    else                        info->copyright = 0;
    if(info->copyright) printf(">>> Copyrighted material\n");
    else                printf(">>> Material not copyrighted\n");
 
    printf("Is this the original? (y/<n>): ");
    gets(t);
    if (*t == 'y' || *t == 'Y') info->original = 1;
    else                        info->original = 0;
    if(info->original) printf(">>> Original material\n");
    else	       printf(">>> Material not original\n");
    
    /* Option for multichannel for matricing, 7/12/93,SR*/
    if(*aiff == 1)
    {
        printf("which kind of matrix do you want(<(-3, -3) = 0>;(-xx, -3) = 1;");
	printf(" (-oo, -3) = 2; (-oo, -oo) = 3)  ");
	gets(t);
	if(strcmp(t,"") == 0) info->matrix = 0;
	else          info->matrix = atoi(t);
	printf("The matrix %d is chosen\n", info->matrix);

        if (info->matrix==3) *cha_sw = 0;
	else
	{
	 printf("Do you want to have Channel-switching?(<y>/n)");
	 gets(t);
	 if(*t == 'n')  
	 {
	  *cha_sw = 0;
	  printf("Channel-switching is not used!\n");
	 } 
	 else
	 {
	  *cha_sw = 1;
           printf("Channel-switching is used\n");	 
	 }
	}
	 
	/********* 27/07/95, WtK , phantom coding ********************/
	if ( (fr_ps->stereomc>0) && (info->center==1) )
	{
	  printf("Do you want to use Phantom Coding of the Center signal? (y/<n>) ");
	  gets(t);
          if ( (*t=='y') || (*t=='Y') )
	  {
	    printf(">>> Phantom Coding is used.\n");
	    fr_ps->phantom_c = 1;
	  } 
	  else
	  {
            printf(">>> No Phantom Coding.\n");	 
	    fr_ps->phantom_c = 0;
	  }
        }

	/********* 05/24/95, SR , dynamic cross_talk ********************/
	 printf("Do you want to have Dynamic Crosstalk?(y/<n>)");
	 gets(t);
	 if(*t == 'y')  
	 {
	  printf("Dynamic Crosstalk is used!\n");
	  bool = 1;
	  do {
	    printf("Which mode of Dynamic Crosstalk do you want? (1 ... 14)\n");
	    gets(t);
	    *dyn_cr = atoi(t);
	    bool = ( 
	             (fr_ps->phantom_c) && 
	             ( (*dyn_cr== 9) || (*dyn_cr==10) || 
	               (*dyn_cr==11) || (*dyn_cr==12) || 
		       (*dyn_cr==14) )
	           );
	    if (bool) printf("!!! Dynamic Crosstalk mode %d cannot be used together with Phantom Coding !!!\n",*dyn_cr);
	  } while (bool) ;
	 } 
	 else
	 {
	  *dyn_cr = 0;
          printf("Dynamic Crosstalk is not used\n");	 
	 }
    }

     /* YBKim060695 ancillary */
     printf("Do you want to use ancillary part ? (y:<n>): ");
     gets(t);
     *ancillaryUse = (*t == 'y' || *t == 'Y');


     printf("How verbose would you like the output ? (0, <1>, 2, 3): ");
     gets(t);
     if (*t >= '0' && *t <= '3')
	*verbosity = atoi(t);
     else
	*verbosity = DFLT_VERB;

    printf("Do you wish to exit (last chance before encoding)? (y/<n>): ");
    gets(t);
    if (*t == 'y' || *t == 'Y') exit(0);
}   

/************************************************************************
/*
/* parse_args
/*
/* PURPOSE:  Sets encoding parameters to the specifications of the
/* command line.  Default settings are used for parameters
/* not specified in the command line.
/*
/* SEMANTICS:  The command line is parsed according to the following
/* syntax:
/*
/* -l  is followed by the layer number
/* -m  is followed by the mode of the two front channels
/* -r  is followed by the sampling rate
/* -b  is followed by the total bitrate, irrespective of the mode
/* -d  is followed by the emphasis flag
/* -c  is followed by the copyright/no_copyright flag
/* -o  is followed by the original/not_original flag
/* -e  is followed by the error_protection on/off flag
/* -x  is followed by the matrix
/* -k  clears the channel-switching flag based on SCF
/* -y* is followed by the a dynamic crosstalk mode
/* -w  sets phantom coding /* 27/07/95: '-p' already reserved for psy */
/* -g  sets MultiLingual coding
/* -v  sets level of verbosity of debug and progress messages
/*
/* If the input file is in AIFF format, the sampling frequency is read
/* from the AIFF header.
/*
/* The input and output filenames are read into #inpath# and #outpath#.
/*
/************************************************************************/
 
void
parse_args(int argc, char **argv, frame_params *fr_ps, int *psy, 
           long unsigned int *num_samples, long unsigned int *num_samples_ml, 
	   char *inPath, char *outPath, 
	   int *aiff, int *byte_per_sample, int *cha_sw, 
	   IFF_AIFF *pcm_aiff_data, IFF_AIFF *pcm_aiff_data_ml, 
	   char *encoded_file_name_ext, int *bit_rate, char *encoded_file_name_mpg, 
	   int *dyn_cr,
	   int *verbosity)
{
   FLOAT srate;
   int	 brate = DFLT_BRT;
   layer *info = fr_ps->header;
   int   err = 0, i = 0;
   int   ml_present = 0; /* MultiLingual coding */
   
  *cha_sw = 1;
  fr_ps->mnr_min = 0.0;
  info->matrix = 0;
  *aiff = 0;
  *dyn_cr = 0;
  fr_ps->phantom_c = 0;
  *verbosity = DFLT_VERB;
 
   /* preset defaults */
   inPath[0] = '\0';   outPath[0] = '\0';
   info->lay = DFLT_LAY;
   switch(DFLT_MOD) {
      case 'r': info->mode = MPG_MD_STEREO; info->mode_ext = 0; break;
      case 'd': info->mode = MPG_MD_DUAL_CHANNEL; info->mode_ext=0; break;
      case 'j': info->mode = MPG_MD_JOINT_STEREO; break;
      case 'm': info->mode = MPG_MD_MONO; info->mode_ext = 0; break;
      default:
         fprintf(stderr, "%s: Bad mode dflt %c\n", programName, DFLT_MOD);
         abort();
   }
   *psy = DFLT_PSY;
   if((info->sampling_frequency = SmpFrqIndex((long)(1000*DFLT_SFQ))) < 0) {
      fprintf(stderr, "%s: bad sfrq default %.2f\n", programName, DFLT_SFQ);
      abort();
   }
   info->bitrate_index = DFLT_BRT;
   if((info->bitrate_index = BitrateIndex(info->lay, DFLT_BRT)) < 0) {
      fprintf(stderr, "%s: bad default bitrate %u\n", programName, DFLT_BRT);
      abort();
   }
   switch(DFLT_EMP) {
      case 'n': info->emphasis = 0; break;
      case '5': info->emphasis = 1; break;
      case 'c': info->emphasis = 3; break;
      default: 
         fprintf(stderr, "%s: Bad emph dflt %c\n", programName, DFLT_EMP);
         abort();
   }
   info->copyright = 0; info->original = 0; info->error_protection = FALSE;
 
   /* process args */
   while(++i<argc && err == 0) {
		char c, *token, *arg, *nextArg;
      int  argUsed;
 
      token = argv[i];
      if(*token++ == '-') {
         if(i+1 < argc) nextArg = argv[i+1];
         else           nextArg = "";
         argUsed = 0;
         while(c = *token++) {
            if(*token /* NumericQ(token) */) arg = token;
            else                             arg = nextArg;
            switch(c) {
               case 'l':        info->lay = atoi(arg); argUsed = 1;
                  if(info->lay<1 || info->lay>2) {
                     fprintf(stderr,"%s: -l layer must be 1 or 2, not %s\n",
                          programName, arg);
                     err = 1;
                  }
                  break;
		case 'm':				  argUsed = 1;
                  if (*arg == 's')
                    { info->mode = MPG_MD_STEREO; info->mode_ext = 0; }
                  else if (*arg == 'd')
                    { info->mode = MPG_MD_DUAL_CHANNEL; info->mode_ext=0; }
                  else if (*arg == 'j')
                    { info->mode = MPG_MD_JOINT_STEREO; }
                  else if (*arg == 'm')
			  { info->mode = MPG_MD_MONO; info->mode_ext = 0; }
	     	  else if (*arg == 'n')
			  { info->mode = MPG_MD_NONE; info->mode_ext = 0; }
                  else 
		  {
                    fprintf(stderr,"%s: -m mode must be s/d/j/m not %s\n",
                            programName, arg);
                    err = 1;
		  }
						break;
		  case 'r':		  
			    srate = atof(arg); argUsed = 1;
	                      if( (info->sampling_frequency =
	                       SmpFrqIndex((long)(1000*srate))) < 0)
	                         err = 1;
			          break;
	          case 'b': 
		              brate = atoi(arg); argUsed = 1;
			      if(brate > 384)
			      {
				 info->ext_bit_stream_present = 1;
				 info->n_ad_bytes = 1; /* for DTB!!! 06/14/94 */
				 *bit_rate = brate;
				 brate = DFLT_BRT;
				 info->ext_length = ((*bit_rate - DFLT_BRT) * 24) / 8;
			       }
			       break;
		  case 'd':  
		             argUsed = 1;
                    if (*arg == 'n')                    info->emphasis = 0;
                    else if (*arg == '5')               info->emphasis = 1;
                    else if (*arg == 'c')               info->emphasis = 3;
                    else 
		    {
                       fprintf(stderr,"%s: -d emp must be n/5/c not %s\n",
                             programName, arg);
                        err = 1;
                     }
                     break;
                   case 'c':       info->copyright = 1; break;
                   case 'o':       info->original  = 1; break;
                   case 'e':       info->error_protection = TRUE; break;
		   case 'x':       info->matrix = atoi(arg); 
		                   if (info->matrix==3) *cha_sw = 0;
				   argUsed = 1;
				   break;
		   case 'k':       *cha_sw = 0; break;
		   
	/********* 05/24/95, SR , dynamic cross_talk ********************/
          	   case 'y':       *dyn_cr = atoi(arg);	
				    if(*dyn_cr == 0)
					*dyn_cr = 15;
				    argUsed = 1;		/* necessary ? */

				   if (fr_ps->phantom_c) {
				     if (*dyn_cr== 9) *dyn_cr = 0;
				     if (*dyn_cr==10) *dyn_cr = 0;
				     if (*dyn_cr==11) *dyn_cr = 1;
				     if (*dyn_cr==12) *dyn_cr = 2;
				     if (*dyn_cr==14) *dyn_cr = 8;
				   }
				   break;		   
		   
	           case 'w':       fr_ps->phantom_c = 1;	
				   argUsed = 0;
				   if (*dyn_cr== 9) *dyn_cr = 0;
				   if (*dyn_cr==10) *dyn_cr = 0;
				   if (*dyn_cr==11) *dyn_cr = 1;
				   if (*dyn_cr==12) *dyn_cr = 2;
				   if (*dyn_cr==14) *dyn_cr = 8;
				   break;		   
		   case 'g':       ml_present = 1;	
				   argUsed = 0;
				   break;		   

		   case 'v':	   *verbosity = atoi(arg);
				   argUsed = 1;
				   break;

                default:        fprintf(stderr,"%s: unrec option %c\n",
                                        programName, c);
                                err = 1; break;
            }
	    
	    
            if(argUsed) {
               if(arg == token)    token = "";   /* no more from token */
               else                ++i;          /* skip arg we used */
               arg = ""; argUsed = 0;
            }
         }
      }
      else {
         if(inPath[0] == '\0')       strcpy(inPath, argv[i]);
         else if(outPath[0] == '\0') strcpy(outPath, argv[i]);
         else {
            fprintf(stderr,"%s: excess arg %s\n", programName, argv[i]);
            err = 1;
         }
      }
   }

   if( (info->bitrate_index = BitrateIndex(info->lay, brate)) < 0) err=1;
   if(err || inPath[0] == '\0') usage();  /* never returns */
 
   if(outPath[0] == '\0') {
      strcpy(outPath, inPath);
      strcat(outPath, DFLT_EXT);
   }
 
   if ((musicin = fopen(inPath, "rb")) == NULL) {
      printf("Could not find \"%s\".\n", inPath);
      exit(0);
   }
 




   open_bit_stream_w(&bs, outPath, BUFFER_SIZE);

	if (aiff_read_headers(musicin, pcm_aiff_data, byte_per_sample) == 0) {

		if (*verbosity >= 2) printf(">>> Using Audio IFF sound file headers\n");

		 *aiff = 1;
		if (*verbosity >= 2) printf(">>> Using Audio IFF sound file headers\n");

      aiff_check(inPath, pcm_aiff_data);
		 	fr_ps->stereomc = 3;
			fr_ps->header->center = 1;
			fr_ps->header->surround = 2;

      info->sampling_frequency = SmpFrqIndex((long)pcm_aiff_data->sampleRate);
      if (*verbosity >= 2) printf(">>> %.f Hz sampling frequency selected\n",
             pcm_aiff_data->sampleRate);

      /* Determine number of samples in sound file */
#ifndef MS_DOS
      *num_samples = pcm_aiff_data->numChannels *
                     pcm_aiff_data->numSampleFrames;
#else
      *num_samples = (long)(pcm_aiff_data->numChannels) *
                     (long)(pcm_aiff_data->numSampleFrames);
#endif

   }
   else {    /* Not using Audio IFF sound file headers. */
   
	if (*verbosity >= 2) printf(" NO MULTICHANNEL CODING!!\n");
	ml_present = 0;
      if (fseek(musicin, 0, SEEK_SET) != 0) {
         printf("Could not seek to PCM sound data in \"%s\".\n", inPath);
         exit(0);
      }
 
      /* Declare sound file to have "infinite" number of samples. */
      *num_samples = MAX_U_32_NUM;

   }

/***************************************************************************/
/* 7/8/95 Multi lingual extension WtK                                      */

if (ml_present)
{
     strcat(strcpy(multilingual_file_name, inPath), DFLT_ML_EXT);
     if ((musicin_ml = fopen(multilingual_file_name, "rb")) == NULL) 
     {
	     printf("Could not find \"%s\".\nNo MultiLingual Coding\n", multilingual_file_name);
	     info->multiling_ch = 0;
     }
     else 
     if (aiff_read_headers(musicin_ml, pcm_aiff_data_ml, byte_per_sample) == 0) 
     {
	     if (*verbosity >= 2) printf(">>> Using Audio IFF multilingual file headers\n");
	     info->multiling_ch = pcm_aiff_data_ml->numChannels;
	     if (*verbosity >= 2) printf(">>> Using %d multilingual channels\n",info->multiling_ch);
	     *num_samples_ml = pcm_aiff_data_ml->numChannels *
			       pcm_aiff_data_ml->numSampleFrames;
     }
     else     /* Not using Audio IFF sound file headers. */
     {
	     printf("***WARNING: Could not read ML AIFF header - No MultiLingual coding!!\n");
	     info->multiling_ch = 0;
     }
     if (info->multiling_ch>0) {
       switch (SmpFrqIndex((long)pcm_aiff_data_ml->sampleRate) - info->sampling_frequency) {
       case 16 : if (*verbosity >= 2) printf("MultiLingual is LSF coded.\n");
		 info->multiling_fs = 1;
		 break;
       case  0 : if (*verbosity >= 2) printf("MultiLingual sample rate equals that of Audio.\n");
		 info->multiling_fs = 0;
		 break;
       default : printf("\n***WARNING: MultiLingual sample rate unequals (half) mc sample rate.\n            No MultiLingual coding!!!\n\n");
		 info->multiling_ch = 0;
		 break;
       } /*switch*/
     } /*if (ml_ch>0)*/
} else {
     info->multiling_ch = 0;
}/* if (ml_present) */

/* 7/8/95 Multi lingual extension WtK                                      */
/***************************************************************************/

}

/************************************************************************
/*
/* print_config
/*
/* PURPOSE:  Prints the encoding parameters used
/*
/************************************************************************/
 
void
print_config(frame_params *fr_ps, int *psy, long unsigned int *num_samples, char *inPath, char *outPath, int *aiff)
{
 layer *info = fr_ps->header;
 
	printf("Encoding configuration:\n");
	if(*aiff == 1){
		printf("Layer=%s   mode=%s   extn=%d   psy model=%d\n",
		  layer_names[info->lay-1], mode_names[info->mode],
		 info->mode_ext, *psy);
	}
	else{
		printf("Layer=%s   mode=%s   extn=%d    psy model=%d\n",
	          layer_names[info->lay-1], mode_names[info->mode],
		 info->mode_ext, *psy);
	}

	if( info->bitrate_index != 0){
		if( bitrate[info->lay-1][info->bitrate_index] == 1000)
			printf("samp frq=%.1f kHz   total bitrate=dynamic bitrate\n",
			 s_freq[info->sampling_frequency]);
		else
			printf("samp frq=%.1f kHz   total bitrate=%d kbps\n",
	                s_freq[info->sampling_frequency],
			bitrate[info->lay-1][info->bitrate_index]);
	 }

   if (info->multiling_ch>0) {
     printf("%d multilingual channels ",info->multiling_ch);
     if (info->multiling_fs==1) printf("LSF coded.\n");
     else                       printf("full sample rate coded.\n");
   }
   else printf("No multilingual coding.\n");
   printf("de-emph=%d   c/right=%d   orig=%d   errprot=%d\n",
          info->emphasis, info->copyright, info->original,
          info->error_protection);
   printf("input file: '%s'   output file: '%s'\n", inPath, outPath);
   fflush(stdout);
}
 
/************************************************************************
/*
/* main
/*
/* PURPOSE:  MPEG I Encoder supporting layers 1 and 2, and
/* psychoacoustic models 1 (MUSICAM) and 2 (AT&T),now portated
/* to multichannel (two front channels, one center and three surround
/* channels. There are different possibilities to code the AIFF-signal,
/* like coding only the surround channels or the front channels,
/* different bitrates for front and surropund channels etc.
/* dec1992 sr.
/*
/* SEMANTICS:  One overlapping frame of audio of up to 2 channels are
/* processed at a time in the following order:
/* (associated routines are in parentheses)
/*
/* 1.  Filter sliding window of data to get 32 subband
/* samples per channel.
/* (window_subband,filter_subband)
/*
/* 2.  If joint stereo mode, combine left and right channels
/* for subbands above #jsbound#.
/* (*_combine_LR)
/*
/* 3.  Calculate scalefactors for the frame, and if layer 2,
/* also calculate scalefactor select information.
/* (*_scale_factor_calc)
/*
/* 4.  Calculate psychoacoustic masking levels using selected
/* psychoacoustic model.
/* (*_Psycho_One, psycho_anal)
/*
/* 5.  Perform iterative bit allocation for subbands with low
/* mask_to_noise ratios using masking levels from step 4.
/* (*_main_bit_allocation)
/*
/* 6.  If error protection flag is active, add redundancy for
/* error protection.
/* (*_CRC_calc)
/*
/* 7.  Pack bit allocation, scalefactors, and scalefactor select
/* information (layer 2) onto bitstream.
/* (*_encode_bit_alloc,*_encode_scale,II_transmission_pattern)
/*
/* 8.  Quantize subbands and pack them into bitstream
/* (*_subband_quantization, *_sample_encoding)
/*
/************************************************************************/

#ifdef MS_DOS
extern unsigned _stklen = 16384;
#endif

main(int argc, char **argv)
{
/*typedef double SBS[7][3][12][SBLIMIT];*/
/*    SBS               *sbsample;*/
double sb_sample[14][3][12][SBLIMIT];	/* JMZ 08/03/1995 */
typedef double JSBS[2][3][12][SBLIMIT];
    JSBS /*far*/        *j_sample;
typedef double IN[14][HAN_SIZE];		/* JMZ 08/03/1995 */
    IN   /*far*/        *win_que;
typedef unsigned int SUB[14][3][12][SBLIMIT]; /* JMZ 08/03/1995 */
    SUB  /*far*/        *subband;
typedef double SAM[12];
    SAM                 *lfe_sample;
typedef unsigned int LSB[12];
    LSB                 *lfe_sbband;
 
    frame_params fr_ps;
    layer info;    
    char original_file_name[MAX_NAME_SIZE];
    char encoded_file_name[MAX_NAME_SIZE];
    char encoded_file_name_ext[MAX_NAME_SIZE];
    char encoded_file_name_mpg[MAX_NAME_SIZE];
    double *win_buf[14];				/* JMZ 08/03/1995 */
    static double buffer[14][1152];			/* JMZ 08/03/1995 */			
    double spiki[14][SBLIMIT];				/* JMZ 08/03/1995 */
    static unsigned int bit_alloc[14][SBLIMIT], scfsi[14][SBLIMIT], scfsi_dyn[14][SBLIMIT];						/* JMZ 08/03/1995 */
    static unsigned int scalar[14][3][SBLIMIT], j_scale[2][3][SBLIMIT],  scalar_dyn[14][3][SBLIMIT];
    static double ltmin[14][SBLIMIT], lgmin[14][SBLIMIT], max_sc[14][SBLIMIT], smr[14][SBLIMIT];							/* JMZ 08/03/1995 */

    static unsigned int lfe_alloc;
    static unsigned int lfe_scalar; 

    FLOAT snr32[32];
    short sam[14][1056];					/* JMZ 08/03/1995 */
    double buffer_matr[14][1152];			/* JMZ 08/03/1995 */
    int whole_SpF, extra_slot = 0;
    double avg_slots_per_frame, frac_SpF, slot_lag;
    int model, stereo, error_protection, stereomc;
    static unsigned int crc, crcmc, crcext;
    int i, j, k, adb, p, l, m, lfe, s;
    unsigned long bitsPerSlot, samplesPerFrame, frameNum = 0;
    unsigned long frameBits, sentBits = 0;
    unsigned long num_samples;
    unsigned long num_samples_ml;	               /* 08/03/1995 JMZ Multilingual */
    int odd_ml = 1;                                    /* LSF MultiLingual: audio inputting only at odd frames , WtK 7/8/95 */
    int ml_eof = 0;                                    /* MultiLingual: frame loop stops if either audio or ML-file has been exhausted , WtK 7/8/95 */
    double   dematrix2_filter_state[3];

    IFF_AIFF aiff_ptr;
    IFF_AIFF aiff_ptr_ml;	                       /* 08/03/1995 JMZ Multilingual */
    int aiff = 0;                                      /* misused to indicate mc-input */
    int byte_per_sample = 0;

    int cha_sw = 1;
    int dyn_cr = 0;
    int predis = 0;
    int bit_rate = 0;
    unsigned int crc_buffer[15];

    int lfe_bits = 0;
    int sentBits1, frameBits1;
    int hi,  hu,  ho;

/*    char *blubb = "rm ";*/	
    char blubb[128];	/* Corrected BUG JMZ 29/03/1995*/

    int  ancillaryUse = 0;  /* YBKim060695 ancillary */
    

#ifdef  PRINTOUT
    int       loop_channel,loop_subband;
    
    al_table  *loop_alloc; /* a pointer to a table */
    sb_alloc  loop_struct; /* a structure of 4 int's */
    alloc_ptr loop_str_ptr; /* a pointer to an sb_alloc structure */
    float     loop_bits;
#endif

#ifdef  MACINTOSH
    console_options.nrows = MAC_WINDOW_SIZE;
    argc = ccommand(&argv);
#endif

    program_information();

    /* Most large variables are declared dynamically to ensure
       compatibility with smaller machines */

    /*sb_sample = (SBS *) mem_alloc(sizeof(SBS), "sb_sample");   */
    j_sample = (JSBS *) mem_alloc(sizeof(JSBS), "j_sample");   

     
    win_que = (IN *) mem_alloc(sizeof(IN), "Win_que");       
    subband = (SUB *) mem_alloc(sizeof(SUB),"subband");        

    lfe_sample = (SAM *) mem_alloc(sizeof(SAM), "lfe_sample");
    lfe_sbband = (LSB *) mem_alloc(sizeof(LSB),"lfe_sbband");
 
    /* clear buffers */
    memset((char *) buffer, 0, sizeof(buffer));
    memset((char *) bit_alloc, 0, sizeof(bit_alloc));
    memset((char *) scalar, 0, sizeof(scalar));
    memset((char *) j_scale, 0, sizeof(j_scale));
    memset((char *) scfsi, 0, sizeof(scfsi));
    memset((char *) ltmin, 0, sizeof(ltmin));
    memset((char *) lgmin, 0, sizeof(lgmin));
    memset((char *) max_sc, 0, sizeof(max_sc));
    memset((char *) snr32, 0, sizeof(snr32));
    memset((char *) sam, 0, sizeof(sam));
 
    fr_ps.header = &info;
    info.mode_ext = 0;
    fr_ps.tab_num = -1;             /* no table loaded */
    fr_ps.tab_num_ml = -1;
    fr_ps.alloc = NULL;
    fr_ps.allocml = NULL;

    info.version = MPEG_AUDIO_ID;
    info.bitrate_index = 0;
    info.lfe = 0;	    /* no low frequency effect channel present! */

    info.multiling_ch  = 0;
    info.multiling_fs  = 0;
    info.multiling_lay = 0;

    info.ext_bit_stream_present = 0;
    info.n_ad_bytes = 0;
    info.audio_mix = 0;
    info.dyn_cross_LR = 0;    /* C out of Lo */
    info.ext_length = 0;
    info.ext_bit = 0;
    info.copy_ident_bit = 0;
    info.copy_ident_start = 0;

    fr_ps.phantom_c = 0;

    init_dematrix2_filter_state(dematrix2_filter_state);

    programName = argv[0];
    if(argc==1)			    /* no command-line args */
	 obtain_parameters(&fr_ps, &model, &num_samples, &num_samples_ml, original_file_name,
		 encoded_file_name, &aiff_ptr, &aiff_ptr_ml, &aiff, &byte_per_sample, 
		 &cha_sw, encoded_file_name_ext,
		  &bit_rate, encoded_file_name_mpg, &dyn_cr, &ancillaryUse, &verbosity);
    else
         parse_args(argc, argv, &fr_ps, &model, &num_samples, &num_samples_ml,
   	      original_file_name, encoded_file_name, &aiff, &byte_per_sample, 
		 &cha_sw, &aiff_ptr, &aiff_ptr_ml, encoded_file_name_ext,
		  &bit_rate, encoded_file_name_mpg, &dyn_cr, &verbosity);
    print_config(&fr_ps, &model, &num_samples,
		  original_file_name, encoded_file_name, &aiff);
  
    hdr_to_frps(&fr_ps);
    stereo = fr_ps.stereo;
    stereomc = fr_ps.stereomc;

    lfe = info.lfe;

    if( aiff != 1) fr_ps.stereomc = 0;
    error_protection = info.error_protection;
 
    if (info.lay == 1) { bitsPerSlot = 32; samplesPerFrame = 384;  }
    else               { bitsPerSlot = 8;  samplesPerFrame = 1152; }
    /* Figure average number of 'slots' per frame. */
    /* Bitrate means TOTAL for both channels, not per side. */
    if(bit_rate == 0) bit_rate = bitrate[info.lay-1][info.bitrate_index];
	if (verbosity >= 2) fprintf(stderr, "bit_rate = %d\n", bit_rate);
	fflush(stderr);    
	 avg_slots_per_frame = ((double)samplesPerFrame /
                           s_freq[info.sampling_frequency]) *
                          ((double)bit_rate / (double)bitsPerSlot);

	 whole_SpF = (int) avg_slots_per_frame;	 /* Bytes per frame within datastream*/
    if (verbosity >= 2) printf("slots/frame = %d\n",whole_SpF);
    frac_SpF  = avg_slots_per_frame - (double)whole_SpF;
    slot_lag  = -frac_SpF;
      if (verbosity >= 2) printf(
		"frac SpF=%.3f, tot bit_rate=%d kbps, s freq=%.1f kHz\n",
                frac_SpF, bit_rate,
		s_freq[info.sampling_frequency]);
 
    if (frac_SpF != 0)
       if (verbosity >= 2) printf("Fractional number of slots, padding required\n");
    else info.padding = 0;

#ifdef PRINTOUT

  if (verbosity >= 3) {
    printf("\nFrame ");
    for (loop_subband=0; loop_subband<SBLIMIT; loop_subband++)
      printf("%3d",loop_subband);
    printf("\n");
  }
#endif
 
     while ( 
             ( get_audio(musicin, buffer, num_samples,
	       stereo, &aiff_ptr, stereomc, &fr_ps, &aiff, &byte_per_sample,
	       buffer_matr, dematrix2_filter_state) > 0 ) &&
	     ( !ml_eof )
	   )  {
    /****************************************************************/
    /*                                                              */
    /*                  START OF FRAME LOOP                         */
    /*                                                              */
    /****************************************************************/

/*the following allocation must happen within the while-loop. 1/5/93, SR*/
	  
      info.mc_prediction_on = 0;	       
      info.tc_sbgr_select = 1;
      info.dyn_cross_on = 0;    
      for(i = 0; i < 12; i++)
      {
         info.tc_alloc[i] = 0;
 	 info.dyn_cross[i] = 0;
 	 info.dyn_second_stereo[i] = 0;
      }
      
      lfe_alloc = 0;

      for( i = 0; i < 8; i++)
      {
         info.mc_pred[i] = 0;
	 for(k = 0; k < 6; k++)
	 {
	   info.delay_comp[i][k] = 0;
	   info.predsi[i][k] = 0;
	 }  
      }   
     
      if ( (fr_ps.stereomc>0) && ((fr_ps.header->center==1) || (fr_ps.header->center==3)) ) {
	if (fr_ps.phantom_c==1) fr_ps.header->center=3;
	if (fr_ps.phantom_c==0) fr_ps.header->center=1;
      } /* 27/7/95 WtK */

        if (verbosity >= 1) {
		fprintf(stderr, "{%4lu}\r", frameNum++); fflush(stderr);
	}

          win_buf[0] = &buffer[0][0];
	  win_buf[1] = &buffer[1][0];
	  win_buf[2] = &buffer[2][0];
	  win_buf[3] = &buffer[3][0];
	  win_buf[4] = &buffer[4][0];
	  win_buf[5] = &buffer[5][0];
	  win_buf[6] = &buffer[6][0];
	  win_buf[7] = &buffer[7][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[8] = &buffer[8][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[9] = &buffer[9][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[10] = &buffer[10][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[11] = &buffer[11][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[12] = &buffer[12][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[13] = &buffer[13][0];	/* JMZ 08/03/1995 Multilingual */

        if (frac_SpF != 0) {
          if (slot_lag > (frac_SpF-1.0) ) {
             slot_lag -= frac_SpF;
             extra_slot = 0;
             info.padding = 0;
	     if (verbosity >= 2) printf("No padding for this frame\n"); 
          }
          else {
             extra_slot = 1;
             info.padding = 1;
             slot_lag += (1-frac_SpF);
          }
        }
	 adb = (whole_SpF+extra_slot) * bitsPerSlot;

/**************************************************************************/
/* 08/03/1995 JMZ Multilingual , WtK 7/8/95 */
if (info.multiling_ch != 0)
{
   if (odd_ml) {
	if ( get_audio_ml(musicin_ml, buffer, num_samples_ml, &aiff_ptr, &fr_ps, 
	                  &aiff, &byte_per_sample,buffer_matr) != 1152*info.multiling_ch ) {
           if (verbosity >= 2) printf("\nHit end of MultiLingual file.\n");
	   ml_eof = 1;
	}

	for (i=0;i<3;i++) for (j=0;j<12;j++)
	for (k = 7; k < 7+info.multiling_ch; k++) 
	{
		window_subband(&win_buf[k], &(*win_que)[k][0], k);
		filter_subband(&(*win_que)[k][0], &(sb_sample)[k][i][j][0]);
	}
        if (info.multiling_fs==1) ml_sb_sample_swap (7,7+info.multiling_ch,sb_sample); /* half fs */
    }
    else ml_sb_sample_shift (7,7+info.multiling_ch,sb_sample);
}

/* 08/03/1995 JMZ Multilingual */
/**************************************************************************/


       switch (info.lay) {
 
/***************************** Layer I **********************************/

          case 1 :
             for (j=0;j<12;j++)
             for (k=0;k<stereo;k++) {
                window_subband(&win_buf[k], &(*win_que)[k][0], k);
                filter_subband(&(*win_que)[k][0], &(/***/sb_sample)[k][0][j][0]);
             }

             I_scale_factor_calc(sb_sample, scalar, stereo);
             if(fr_ps.actual_mode == MPG_MD_JOINT_STEREO) {
                I_combine_LR(sb_sample, *j_sample);
				 I_scale_factor_calc(/***/sb_sample, scalar, 1);
             }
 
             put_scale(scalar, &fr_ps, max_sc);
 
             I_Psycho_One(buffer, max_sc, ltmin, &fr_ps);
 
             I_main_bit_allocation(ltmin, bit_alloc, &adb, &fr_ps);
 
             if (error_protection) I_CRC_calc(&fr_ps, bit_alloc, &crc);
 
             encode_info(&fr_ps, &bs);
 
             if (error_protection) encode_CRC(crc, &bs);
 
             I_encode_bit_alloc(bit_alloc, &fr_ps, &bs);
             I_encode_scale(scalar, bit_alloc, &fr_ps, &bs);
             I_subband_quantization(scalar,/** */sb_sample, j_scale, *j_sample,
                                    bit_alloc, *subband, &fr_ps);
             I_sample_encoding(*subband, bit_alloc, &fr_ps, &bs);

		 /* YBKim060695 ancillary */
		 if(ancillaryUse) {
			ancillary_encode(&fr_ps,&bs,adb);
		 } else {
		 	for (i = 0; i < adb; i++)
                           	put1bit(&bs, 0);
		 }

          break;
 
/***************************** Layer 2 **********************************/
 
	 case 2 :
 	  if( aiff != 1){
             for (i=0;i<3;i++) for (j=0;j<12;j++)
		 for (k = 0; k < stereo; k++) {
                   window_subband(&win_buf[k], &(*win_que)[k][0], k);
                   filter_subband(&(*win_que)[k][0], &(sb_sample)[k][i][j][0]);
                 }
				  
		l = 0;
		if (stereo == 2) m = 2;
		else             m = 1;
                II_scale_factor_calc(&fr_ps,sb_sample, scalar, fr_ps.sblimit,
                                     l, m);
		if (info.multiling_ch>0)
		   II_scale_factor_calc(&fr_ps,sb_sample, scalar, fr_ps.mlsblimit, 7, 7+info.multiling_ch);

                pick_scale(scalar, &fr_ps, max_sc, cha_sw, aiff);
                if(fr_ps.actual_mode == MPG_MD_JOINT_STEREO) {
			 II_combine_LR(sb_sample, *j_sample, fr_ps.sblimit);
			 II_scale_factor_calc(&fr_ps,*j_sample, j_scale,
						  fr_ps.sblimit, 1, 0);
		}
		
				 
		  /* this way we calculate more mono than we need */
                  /* but it is cheap */
 
                 II_Psycho_One(buffer, max_sc, ltmin, &fr_ps,smr,spiki,aiff);
		 if (odd_ml) II_Psycho_One_ml(buffer, max_sc, ltmin, &fr_ps,smr,spiki);
                 if (info.multiling_fs) {
                    pick_scale_ml_2(&fr_ps,sb_sample,max_sc);
		    for (k=7;k<7+info.multiling_ch;k++) 
		     II_smr(&ltmin[k][0], &smr[k][0], &spiki[k][0], &max_sc[k][0], fr_ps.mlsblimit, 0, fr_ps.mlsblimit);
                 }
		 
		 II_transmission_pattern(scalar, scfsi, &fr_ps);
		 
		 II_main_bit_allocation(smr, ltmin, scfsi, bit_alloc, &adb,
					  &fr_ps, &aiff, sb_sample, 
					 scalar, max_sc, cha_sw, buffer_matr,
					spiki, *j_sample, j_scale, dyn_cr, scfsi_dyn, 
					scalar_dyn);
 
                 if (error_protection)
			 II_CRC_calc(&fr_ps, bit_alloc, scfsi, &crc);
			 
 
                 encode_info(&fr_ps, &bs);
 
                 if (error_protection) encode_CRC(crc, &bs);
		 II_encode_bit_alloc(bit_alloc, &fr_ps, &bs);

		 k = 0;
		 i = 2;
		 II_encode_scale(bit_alloc, scfsi, scalar, lfe_alloc, lfe_scalar, &fr_ps, &bs, &k , &i);
                 II_subband_quantization(scalar, sb_sample, j_scale,
                                      *j_sample, bit_alloc, *subband, &fr_ps);
                 II_sample_encoding(*subband, bit_alloc, &fr_ps, &bs);
        
/*******************************************************/
/* 08/03/1995 JMZ Multilingual */
	if(info.multiling_ch >0)
	{
	
		k = 7;
		i = info.multiling_ch+7;		 
		II_encode_bit_alloc_ml(bit_alloc, &fr_ps, &bs);
		II_encode_scale_ml(bit_alloc, scfsi, scalar, &fr_ps, &bs, &k, &i);

		II_subband_quantization_ml(scalar, sb_sample, j_scale,
			*j_sample, bit_alloc, *subband, &fr_ps);


		II_sample_encoding_ml(*subband, bit_alloc, &fr_ps, &bs);
	}
/* 08/03/1995 JMZ Multilingual */
/*******************************************************/


		 /* YBKim060695 ancillary */
		 if(ancillaryUse) {
			ancillary_encode(&fr_ps,&bs,adb);
		 } else {
		 	for (i = 0; i < adb; i++)
                           	put1bit(&bs, 0);
		 }

	  }

/*********************** Now Layer 2 with five channels**************************/

	  else{
             if (lfe){
		lfe_bits = adb;
               lfe_filter(&win_buf[3],*lfe_sample);
               lf_scalefactor(*lfe_sample, &lfe_scalar);
               lfe_allocation(&lfe_alloc, &adb);
		lfe_bits -= adb;     
             }

	     for (i=0;i<3;i++) for (j=0;j<12;j++)
	     {
		l = 0;

		for (k = 0; k < 7; k++) {
                   if(lfe && (k == 3)) l +=1; 
                   window_subband(&win_buf[l], &(*win_que)[k][0], k);

                   filter_subband(&(*win_que)[k][0], &(sb_sample)[k][i][j][0]);
		   l++;
                }
	     }
 
		matricing(sb_sample, &fr_ps);

		l = 0; m = 7;
                II_scale_factor_calc(&fr_ps,sb_sample, scalar, fr_ps.sblimit,
                                     l, m);

		if (info.multiling_ch>0)
		   II_scale_factor_calc(&fr_ps,sb_sample, scalar, fr_ps.mlsblimit, 7, 7+info.multiling_ch);
		 pick_scale(scalar, &fr_ps, max_sc, cha_sw, aiff);

		 if(fr_ps.actual_mode == MPG_MD_JOINT_STEREO)
                 {
                         if (verbosity >= 2) fprintf(stderr,"JOINT!!\n");fflush(stderr);
                         i = 0;		
                	 II_combine_LR(sb_sample, *j_sample, fr_ps.sblimit);
			 II_scale_factor_calc1(*j_sample, j_scale,
						 fr_ps.sblimit, i);
		 }

                II_Psycho_One(buffer_matr, max_sc, ltmin, 
                                                &fr_ps, smr, spiki,aiff);
                if (odd_ml) II_Psycho_One_ml(buffer_matr, max_sc, ltmin, &fr_ps, smr, spiki);
                if (info.multiling_fs) {
                  pick_scale_ml_2(&fr_ps,sb_sample,max_sc);
		  for (k=7;k<7+info.multiling_ch;k++) 
		   II_smr(&ltmin[k][0], &smr[k][0], &spiki[k][0], &max_sc[k][0], fr_ps.mlsblimit, 0, fr_ps.mlsblimit);
		}
		  		
		II_transmission_pattern(scalar, scfsi, &fr_ps);

 	        /*in case of ext_bit_stream adb is the complete number of bits!! 06/22/94, SR*/
 
 		 II_main_bit_allocation(smr, ltmin, scfsi, bit_alloc, &adb, 
		                         &fr_ps, &aiff, sb_sample, 
					scalar, max_sc, cha_sw, buffer_matr, 
					spiki, *j_sample, j_scale, dyn_cr, scfsi_dyn, scalar_dyn);
					
	    	    /* PREDISTORTION, 4/7/94, SR*/

		if(fr_ps.actual_mode != MPG_MD_JOINT_STEREO)
		{
			if((info.matrix == 0) && (info.dyn_cross_on == 0))
			{
	    		    adb = (whole_SpF+extra_slot) * bitsPerSlot - lfe_bits;
			    predistortion(sb_sample,scalar, bit_alloc,
				*subband, &fr_ps, smr, scfsi, &adb, scfsi_dyn);
			    predis = 1; 
			}   
		}	    

		/********** PREDISTORTION-END*****/

 		 if (error_protection)
			 II_CRC_calc(&fr_ps, bit_alloc, scfsi, &crc);
			 
		 lfe_alloc = 4;
		 II_CRC_calcmc(&fr_ps, bit_alloc, lfe_alloc, scfsi, &crcmc);
                 lfe_alloc = 0;

                 encode_info(&fr_ps, &bs);
		
                 if (error_protection) encode_CRC(crc, &bs);

		 II_encode_bit_alloc(bit_alloc, &fr_ps, &bs);
		 k = 0;
		 i = 2;		 

		 II_encode_scale(bit_alloc, scfsi, scalar, lfe_alloc, lfe_scalar, &fr_ps, &bs, &k, &i);
		 
                 II_subband_quantization(scalar, sb_sample, j_scale,
                                  *j_sample, bit_alloc, *subband, &fr_ps);
				  
				  
		 II_sample_encoding(*subband, bit_alloc, &fr_ps, &bs);


	  /***** Now bitstream for the surround channels **************/
	  

		 encode_infomc1(&fr_ps, &bs);
		 
		 encode_CRC(crcmc, &bs);
		 
		 encode_infomc2(&fr_ps, &bs);    /*new draft 5.7.93 SR*/
		 
                 if(lfe){
                   lfe_alloc = 4;
                   II_encode_lfe_alloc(lfe_alloc, &fr_ps, &bs);
                 }

/************************/
/****************************/
		 II_encode_bit_allocmc(bit_alloc, &fr_ps, &bs);
		 k = 2;
		 i = 5;
		 
		 II_encode_scale(bit_alloc, scfsi, scalar, lfe_alloc, lfe_scalar, &fr_ps, &bs, &k, &i);

		 II_subband_quantizationmc(scalar, sb_sample, j_scale,
		            *j_sample, bit_alloc, *subband, &fr_ps);

                 if(lfe) 
                   II_lfe_quantisation(lfe_scalar, *lfe_sample, lfe_alloc,
                                     *lfe_sbband, &fr_ps);
				    
		 II_sample_encodingmc(*subband, *lfe_sbband, bit_alloc, lfe_alloc, &fr_ps, &bs);

/***********************************************/
/* 08/03/1995 JMZ Multilingual */
	if(info.multiling_ch >0)
	{

		k = 7;
		i = info.multiling_ch+7;		 
		II_encode_bit_alloc_ml(bit_alloc, &fr_ps, &bs);
		II_encode_scale_ml(bit_alloc, scfsi, scalar, &fr_ps, &bs, &k, &i);

		II_subband_quantization_ml(scalar, sb_sample, j_scale,
			*j_sample, bit_alloc, *subband, &fr_ps);


		II_sample_encoding_ml(*subband, bit_alloc, &fr_ps, &bs);
	}

/* 08/03/1995 JMZ Multilingual */
/***********************************************/

		 /* YBKim060695 ancillary */
		 if(ancillaryUse) {
			ancillary_encode(&fr_ps,&bs,adb);
		 } else {
		 	for (i = 0; i < adb; i++)
                           	put1bit(&bs, 0);
		 }
	  }

          
 
/***************************** Layer 3, not done yet!!*******************/

          /*case 3 : break;*/

       }
 
       frameBits = sstell(&bs) - sentBits;
       if(frameBits%bitsPerSlot)   /* a program failure */
          fprintf(stderr,"Sent %ld bits = %ld slots plus %ld\n",
                  frameBits, frameBits/bitsPerSlot,
                  frameBits%bitsPerSlot);
       sentBits += frameBits;

#ifdef DEBUG
    if (verbosity >= 3) {
       if ( (info.lay==2) && 
            ((int)aiff_ptr.sampleRate==48000) && 
	    (info.ext_bit_stream_present == 0) && 
	    (frameBits != 24*bitrate[info.lay-1][info.bitrate_index]) 
	  ) /* for debugging purposes WtK */
	  fprintf(stderr,"\n***Error. %d bits have been written instead of %d bits.\n",
	                 frameBits,24*bitrate[info.lay-1][info.bitrate_index]);
    }
#endif DEBUG

#ifdef PRINTOUT
    if (verbosity >= 3) {
       printf("\nFrame %4lu   channel 1  channel 2  channel 3  channel 4  channel 5\n",frameNum-1);
       for (loop_subband=0; loop_subband<SBLIMIT; loop_subband++)
       {
         printf("subband %2d :",loop_subband);
         for (loop_channel=0; loop_channel<fr_ps.stereo + stereomc; loop_channel++)
         {
           /* make loop_alloc point to the alloc-table in fr_ps */
           loop_alloc=fr_ps.alloc;
           loop_bits=(* loop_alloc)[loop_subband][bit_alloc[loop_channel][loop_subband]].bits;
	   if ((loop_channel==1) && 
	       (fr_ps.actual_mode == MPG_MD_JOINT_STEREO) &&
	       (loop_subband >= fr_ps.jsbound))
	       printf("js         ");
           else
	   {
	     if ((* loop_alloc)[loop_subband][bit_alloc[loop_channel][loop_subband]].steps == 0)
	       printf("    - bits ");
	     else
	     {
	       if ((* loop_alloc)[loop_subband][bit_alloc[loop_channel][loop_subband]].group == 1)
		 loop_bits /= 3;
	       printf("%5.1f bits ",loop_bits);
	     }
	   }
         } /* for (loop_channel..) */
         printf("\n");
       } /* for (loop_subband..) */

/* Now the ML part , WtK */
  if (info.multiling_ch>0) {
       printf("\nFrame %4lu ",frameNum-1);
       for (loop_channel=0;loop_channel<info.multiling_ch;loop_channel++) printf("  MLchann %d",loop_channel);
       printf("\n");
       for (loop_subband=0; loop_subband<SBLIMIT; loop_subband++)
       {
         printf("subband %2d :",loop_subband);
         for (loop_channel=0; loop_channel<info.multiling_ch; loop_channel++)
         {
           /* make loop_alloc point to the alloc-table in fr_ps */
           loop_alloc=fr_ps.allocml;
           loop_bits=(* loop_alloc)[loop_subband][bit_alloc[loop_channel][loop_subband]].bits;
	   if ((loop_channel==1) && 
	       (fr_ps.actual_mode == MPG_MD_JOINT_STEREO) &&
	       (loop_subband >= fr_ps.jsbound))
	       printf("js         ");
           else
	   {
	     if ((* loop_alloc)[loop_subband][bit_alloc[loop_channel][loop_subband]].steps == 0)
	       printf("    - bits ");
	     else
	     {
	       if ((* loop_alloc)[loop_subband][bit_alloc[loop_channel][loop_subband]].group == 1)
		 loop_bits /= 3;
	       printf("%5.1f bits ",loop_bits);
	     }
	   }
         } /* for (loop_channel..) */
         printf("\n");
       } /* for (loop_subband..) */
  } /*n_ml_ch>0*/
  } /* verbosity */
#endif

if (info.multiling_fs==1) odd_ml = 1 - odd_ml; /* ML half fs */
    /****************************************************************/
    /*                                                              */
    /*                   END OF FRAME LOOP                          */
    /*                                                              */
    /****************************************************************/
}/* end of while(get_audio) - loop */


close_bit_stream_w(&bs);

if(info.ext_bit_stream_present == 1)
{
    open_bit_stream_r(&bs, encoded_file_name, BUFFER_SIZE);
    strcat(strcpy(encoded_file_name_ext, encoded_file_name), EXT_DFLT_EXT);
    if (verbosity >= 2) printf(">>> file name of extension bitstream is: %s\n", encoded_file_name_ext);
    open_bit_stream_w(&bs_ext, encoded_file_name_ext, BUFFER_SIZE);
    strcat(strcpy(encoded_file_name_mpg, encoded_file_name), DFLT_EXT);
    open_bit_stream_w(&bs_mpg, encoded_file_name_mpg, BUFFER_SIZE);
    for( m = 0; m <= frameNum - 1 /* JMZ BUG 27/03/1995 */; m++)
    {	/*Changed "< frameNum -2" to "<=  frameNum -1" in case only one frame*/
	i =  (((double)samplesPerFrame / s_freq[info.sampling_frequency]) *
	     (double)bitrate[info.lay-1][info.bitrate_index]) - (info.n_ad_bytes * 8);
	for(j = 0; j < i; j++)
	{
	    crc_buffer[0] = get1bit(&bs);
	    put1bit(&bs_mpg, crc_buffer[0]);
	}
	for(j = 0; j < info.n_ad_bytes * 8; j++)
	    put1bit(&bs_mpg, 0);
      
	encode_infomc_ext1(&fr_ps, &bs_ext);
	for( i = 0; i < 14; i++)
	{
	    crc_buffer[i] = getbits(&bs, 8);
	}    
	crc_buffer[14] = getbits(&bs, 4);
	II_CRC_calcmc_ext(&fr_ps, crc_buffer, &crcext);
	encode_infomc_ext2(&fr_ps, &bs_ext, crcext);
	for( i = 0; i < 14; i++)	
	{
	    putbits(&bs_ext, crc_buffer[i], 8);
	}    
	putbits(&bs_ext, crc_buffer[14], 4);
    
	i = (info.ext_length * 8) - 40 - 116;
	for(j = 0; j < i; j++)
	{
	    crc_buffer[0] = get1bit(&bs);
	    put1bit(&bs_ext, crc_buffer[0]);
	}
    }
    close_bit_stream_r(&bs);
    close_bit_stream_w(&bs_ext);
    close_bit_stream_w(&bs_mpg);
    
    strcpy(blubb,  "rm ");				/* Corrected BUG JMZ 29/03/1995*/
    strcat(blubb,  encoded_file_name);

#ifdef DEBUG
    if (verbosity >= 3) printf("%s\n", blubb);
#endif 

    system(blubb);
}    	

if (verbosity >= 2) printf("Avg slots/frame = %.3f; b/smp = %.2f; br = %.3f kbps\n",
      (FLOAT) sentBits / (frameNum * bitsPerSlot),
      (FLOAT) sentBits / (frameNum * samplesPerFrame),
      (FLOAT) sentBits / (frameNum * samplesPerFrame) *
       s_freq[info.sampling_frequency]);

 if (fclose(musicin) != 0){
       printf("Could not close \"%s\".\n", original_file_name);
       exit(2);
 }

#ifdef  MACINTOSH
    set_mac_file_attr(encoded_file_name, VOL_REF_NUM, CREATOR_ENCODE,
                      FILETYPE_ENCODE);
#endif

    if (verbosity >= 2) printf(
	"Encoding of \"%s\" with psychoacoustic model %d is finished\n",
           original_file_name, model);
  if (verbosity >= 2)
    if( aiff == 1) printf(" It is a multichannel file !\n");
    else printf(" It is a twochannel file!\n");	   
    if (verbosity >= 2) printf("The MPEG encoded output file name is \"%s\"\n",
            encoded_file_name);
	    
}
 
/************************************************************************
/*
/* usage
/*
/* PURPOSE:  Writes command line syntax to the file specified by #stderr#
/*
/************************************************************************/

static void usage(void)  /* print syntax & exit */
{
    fprintf(stderr,
    "usage: %s                         queries for all arguments, or\n",
            programName);
    fprintf(stderr,
    "       %s [-l lay][-m mode][-p psy][-s sfrq][-b br][-d emp][-x matr][-y dynX]\n",
            programName);
    fprintf(stderr,
    "          [-c][-o][-e][-k][-w][-g] inputPCM [outBS]\n");
    fprintf(stderr,"where\n");
    fprintf(stderr," -l lay   use layer <lay> coding   (dflt %4u)\n",DFLT_LAY);
    fprintf(stderr," -m mode  channel mode : s/d/j/m   (dflt %4c)\n",DFLT_MOD);
    fprintf(stderr," -n mode  surround mode : s/d/j/m  (dflt %4c)\n",DFLT_MOD);
    fprintf(stderr," -r sfrq  input smpl rate in kHz   (dflt %4.1f)\n",DFLT_SFQ);
    fprintf(stderr," -b br    total bitrate in kbps    (dflt %4u)\n",DFLT_BRT);
    fprintf(stderr," -d emp   de-emphasis n/5/c        (dflt %4c)\n",DFLT_EMP);
    fprintf(stderr," -c       mark as copyright\n");
    fprintf(stderr," -o       mark as original\n");
    fprintf(stderr," -e       add error protection\n");
    fprintf(stderr," -x matr  matrix                    (dflt 0)\n");
    fprintf(stderr," -k       clear channel-switching   (dflt on)\n");
    fprintf(stderr," -y dynX  dyn_cross mode\n");             
    fprintf(stderr," -w       set phantom coding        (dflt off)\n");
    fprintf(stderr," -g       set MultiLingual coding   (dflt off) input ML filename = inputPCM+\"%s\"\n",DFLT_ML_EXT);
    fprintf(stderr," -v	verb  level of verbosity 0-3	(dflt %d)\n", DFLT_VERB);
    fprintf(stderr," inputPCM input PCM sound file (standard or AIFF)\n");
    fprintf(stderr," outBS    output bit stream of encoded audio (dflt inName+%s)\n",
            DFLT_EXT);
    exit(1);
}

/************************************************************************
/*
/* aiff_check
/*
/* PURPOSE:  Checks AIFF header information to make sure it is valid.
/*           Exits if not.
/*
/************************************************************************/

void aiff_check(char *file_name, IFF_AIFF *pcm_aiff_data)
                          /* Pointer to name of AIFF file */
                          /* Pointer to AIFF data structure */
{

    if (strcmp(pcm_aiff_data->sampleType, IFF_ID_SSND) != 0)  {
       printf("Sound data is not PCM in \"%s\".\n", file_name);
       exit(0);
    }

    if(SmpFrqIndex((long)pcm_aiff_data->sampleRate) < 0) {
       printf("in \"%s\".\n", file_name);
       exit(0);
    }

    if (pcm_aiff_data->sampleSize != sizeof(short) * BITS_IN_A_BYTE) {
        printf("Sound data is not %d bits in \"%s\".\n",
               sizeof(short) * BITS_IN_A_BYTE, file_name);
        exit(0);
    }

    if (pcm_aiff_data->numChannels != MONO &&
        pcm_aiff_data->numChannels != STEREO &&
	pcm_aiff_data->numChannels != 3 &&  /*changed that to five-channel 21.6.93.SR*/
	pcm_aiff_data->numChannels != 4 &&
	pcm_aiff_data->numChannels != 5 &&
        pcm_aiff_data->numChannels != 6) {
       printf("Sound data is not mono or stereo or fivechannel in \"%s\".\n", file_name);
       exit(0);
    }

    if (pcm_aiff_data->blkAlgn.blockSize != 0) {
       printf("Block size is not %lu bytes in \"%s\".\n", 0, file_name);
       exit(0);
    }

    if (pcm_aiff_data->blkAlgn.offset != 0) {
       printf("Block offset is not %lu bytes in \"%s\".\n", 0, file_name);
       exit(0);
    }

}
@


1.8
log
@Added verbosity switch to control text output.
@
text
@d2 2
a3 3
 * Copyright (c) 1995 MPEG/audio software simulation group
 * All Rights Reserved
 * $Id: musicin.c 1.7 1996/01/20 17:13:10 rowlands Exp rowlands $
d5 1
a5 3
 * MPEG/audio coding/decoding software, work in progress
 *   NOT for public distribution until verified and approved by the
 *   MPEG/audio committee.
a7 6
 * Revision 1.7  1996/01/20 17:13:10  rowlands
 * Moved Merged into main trunk
 *
 * Revision 1.6.3.1  1996/01/19  04:40:26  rowlands
 * Merged
 *
d9 1
a9 4
 * Received from Uwe Felderhoff
 *
 * Revision 1.6.1.1  1995/11/06  04:12:25  rowlands
 * Received from Warner ten Kate
d12 1
a12 1
 * ML-LSF added WtK 7/8/95
a21 6
 * Revision 1.6  1995/06/16  10:01:27  rowlands
 * Moved merged IRT/Samsung/TI into main revision control trunk.
 *
 * Revision 1.4.3.2  1995/06/16  09:57:51  rowlands
 * Merged and tested revisions 1.5 and 1.4.3.1
 *
d23 1
a23 4
 * Input from Samsung AIT.
 *
 * Revision 1.5  1995/06/16  06:29:49  rowlands
 * Moved merged IRT/TI into main revision control trunk.
a24 6
 * Revision 1.4.2.3  1995/06/16  06:27:33  rowlands
 * Merged and tested revisions 1.4.1.4 and 1.4.2.1
 *
 * Revision 1.4.2.2  1995/06/16  04:45:49  rowlands
 * Merged TI and IRT mods using #ifdef _IRT
 *
d26 1
a26 1
 * Input from IRT
a36 6
 * Revision 1.4.1.0  1995/06/07  00:56:16  rowlands
 * Created branch for TI
 *
 * Revision 1.4  1995/04/06  04:29:39  rowlands
 * Added header and RCS info to initial revision.
 *
a39 2
 * VERSION 2.5                                                        *
 *   changes made since last update:                                  *
d133 1
a133 1
 *  Version 1.0 Shareware                                             *
a135 2
 *                 Tel: +49 89 32399 458                              *
 *                 Fax: +49 89 32399 415                              *
d137 1
a137 1
 *  Version 1.1 Shareware                                             *
a1203 5
#ifdef  MACINTOSH
    console_options.nrows = MAC_WINDOW_SIZE;
    argc = ccommand(&argv);
#endif

a1204 2


d1213 7
@


1.7
log
@Moved Merged into main trunk
@
text
@d4 1
a4 1
 * $Id: musicin.c 1.6.3.1 1996/01/19 04:40:26 rowlands Exp $
d11 3
d206 1
d246 2
a247 1
	int *ancillaryUse
d733 8
d770 1
d786 2
a787 1
	   int *dyn_cr)
d801 1
d856 1
a856 1
					case 'm':				  argUsed = 1;
d939 4
d987 1
a987 1
		 printf(">>> Using Audio IFF sound file headers\n");
d990 1
a990 1
      printf(">>> Using Audio IFF sound file headers\n");
d998 1
a998 1
      printf(">>> %.f Hz sampling frequency selected\n",
d1013 1
a1013 1
	printf(" NO MULTICHANNEL CODING!!\n");
d1039 1
a1039 1
	     printf(">>> Using Audio IFF multilingual file headers\n");
d1041 1
a1041 1
	     printf(">>> Using %d multilingual channels\n",info->multiling_ch);
d1052 1
a1052 1
       case 16 : printf("MultiLingual is LSF coded.\n");
d1055 1
a1055 1
       case  0 : printf("MultiLingual sample rate equals that of Audio.\n");
d1117 1
a1238 2
    FILE *fp100;

a1257 2
fp100 = fopen("SAMPLES", "w+");

d1316 1
a1316 1
		  &bit_rate, encoded_file_name_mpg, &dyn_cr, &ancillaryUse);
d1321 1
a1321 1
		  &bit_rate, encoded_file_name_mpg, &dyn_cr);
d1339 1
a1339 1
	fprintf(stderr, "bit_rate = %d\n", bit_rate);
d1346 1
a1346 1
    printf("slots/frame = %d\n",whole_SpF);
d1349 2
a1350 1
      printf("frac SpF=%.3f, tot bit_rate=%d kbps, s freq=%.1f kHz\n",
d1355 1
a1355 1
       printf("Fractional number of slots, padding required\n");
d1360 1
d1365 1
a1365 1

d1409 3
a1411 1
        fprintf(stderr, "{%4lu}\r", frameNum++); fflush(stderr);
d1433 1
a1433 1
	     printf("No padding for this frame\n"); 
d1450 1
a1450 1
           printf("\nHit end of MultiLingual file.\n");
d1641 1
a1641 1
                         fprintf(stderr,"JOINT!!\n");fflush(stderr);
d1674 1
a1674 1
				*subband, &fr_ps, smr, scfsi, &adb, scfsi_dyn, fp100);
d1781 1
d1789 1
d1793 1
d1854 1
d1872 1
a1872 1
    printf(">>> file name of extension bitstream is: %s\n", encoded_file_name_ext);
a1911 1
    fclose(fp100);
d1917 1
a1917 1
    printf("%s\n", blubb);
d1923 1
a1923 1
printf("Avg slots/frame = %.3f; b/smp = %.2f; br = %.3f kbps\n",
d1939 2
a1940 1
    printf("Encoding of \"%s\" with psychoacoustic model %d is finished\n",
d1942 1
d1945 1
a1945 1
    printf("The MPEG encoded output file name is \"%s\"\n",
d1983 1
@


1.6
log
@Moved merged IRT/Samsung/TI into main revision control trunk.
@
text
@d4 1
a4 1
 * $Id: musicin.c 1.4.3.2 1995/06/16 09:57:51 rowlands Exp $
d11 23
d241 2
a242 1
	int *dyn_cr
d244 1
a244 1
	 int j;
d253 2
a254 1
	 *cha_sw = 0;
d277 1
a277 1
	printf("Enter multilingual input file name <%s.ml>: ",original_file_name);
d282 1
a282 1
		strcat(strcpy(multilingual_file_name, original_file_name), ".ml");
d295 2
a296 3
       *num_samples_ml = pcm_aiff_data_ml->numChannels *
                      pcm_aiff_data_ml->numSampleFrames;
		printf(">>>JMZ num_samples_ml= %d \n",*num_samples_ml);
d300 2
a301 2
		printf("no multichannel coding!!\n exit");
		exit(0);
d328 5
d355 1
a355 1
       				printf(">>> Using default Layer 2\n"); 
d382 1
a382 1
       				printf(">>> Using default Layer 2\n"); 
d397 1
a397 1
       				printf(">>> Using Layer %s\n",t); 
d402 1
a402 1
       				printf(">>> Using Layer %s\n",t); 
d407 1
a407 1
       				printf(">>> Using default Layer 2\n"); 
d431 14
d449 1
d662 4
a665 2

	 printf("Do you want to have Channel-switching based on SCF?(y/<n>)");
d667 1
a667 1
	 if(*t == 'y')  
d669 2
a670 2
	  *cha_sw = 1;
	  printf("Channel-switching on SCF is used!\n");
d674 2
a675 2
	  *cha_sw = 0;
           printf("Channel-switching is not used\n");	 
d677 1
d679 17
d702 13
a714 3
	  printf("Which mode of Dynamic Crosstalk do you want? (1 ... 14)\n");
	  gets(t);
	  *dyn_cr = atoi(t);
d723 5
a727 1
 
d752 2
a753 2
/* -g  is followed by the matrix
/* -k  is followed by the channel-switching flag based on SCF
d755 2
d767 4
a770 2
           long unsigned int *num_samples, char *inPath, char *outPath, 
	   int *aiff, int *byte_per_sample, int *cha_sw, IFF_AIFF *pcm_aiff_data, 
d775 2
a776 2
	int	brate;
layer *info = fr_ps->header;
d778 1
d780 1
a780 1
  *cha_sw = 0;
d785 1
d870 5
a874 5
				*bit_rate = brate;
				brate = DFLT_BRT;
				info->ext_length = ((*bit_rate - DFLT_BRT) * 24) / 8;
				}			   
				break;
d890 3
a892 2
		   case 'g':       info->matrix = atoi(arg); 
		                   argUsed = 1;
d894 1
a894 1
		   case 'k':       *cha_sw = 1; break;
d897 1
a897 1
	   case 'y':       *dyn_cr = atoi(arg);	
d901 22
a922 2
				    break;		   
					   
d945 2
a946 1
	if( (info->bitrate_index = BitrateIndex(info->lay, brate)) < 0) err=1;
d973 3
a975 1
		 	fr_ps->stereomc =3;
d994 1
d1005 45
d1087 6
a1092 1

d1163 4
d1180 4
d1191 1
a1191 1
    int i, j, k, adb, p, l, m;
d1195 3
a1197 1
    unsigned long num_samples_ml;	/* 08/03/1995 JMZ Multilingual */
d1199 1
d1201 2
a1202 2
    IFF_AIFF aiff_ptr_ml;			/* 08/03/1995 JMZ Multilingual */
    int aiff = 0;
d1204 2
a1205 1
    int cha_sw = 0;
d1210 5
d1218 3
a1220 2
    char t[50];		/* YBKim060695 ancillary */
    int  ancillaryUse;  /* YBKim060695 ancillary */
d1239 1
a1240 3



d1251 2
d1269 1
d1271 2
d1276 5
a1280 3
    info.multiling_ch = 0;     /* not done yet */
    info.multiling_fs = 0;     /* dto */
    info.multiling_lay = 0;    /* dto */
d1290 2
d1296 2
a1297 2
	 obtain_parameters(&fr_ps, &model, &num_samples, &num_samples_ml,/*JMZ*/ original_file_name,
		 encoded_file_name, &aiff_ptr, &aiff_ptr_ml /*JMZ*/, &aiff, &byte_per_sample, 
d1299 1
a1299 1
		  &bit_rate, encoded_file_name_mpg, &dyn_cr);
d1301 1
a1301 1
         parse_args(argc, argv, &fr_ps, &model, &num_samples,
d1303 1
a1303 1
		 &cha_sw, &aiff_ptr, encoded_file_name_ext,
d1311 3
d1349 11
a1359 5
     /* YBKim060695 ancillary */
     printf("Do you want to use ancillary part ? (y:<n>): ");
     gets(t);
     if(*t == 'y' || *t == 'Y') ancillaryUse = 1;
     else ancillaryUse = 0;
a1360 6


     while (get_audio(musicin, buffer, num_samples,
	  stereo, &aiff_ptr, stereomc, &fr_ps, &aiff, &byte_per_sample,
             buffer_matr, dematrix2_filter_state) > 0) {

d1373 2
d1385 4
d1390 2
a1391 1
        fprintf(stderr, "{%4lu}", frameNum++); fflush(stderr);
d1397 2
a1398 2
	  win_buf[5] = &buffer[5][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[6] = &buffer[6][0];	/* JMZ 08/03/1995 Multilingual */
d1423 1
a1423 1
/* 08/03/1995 JMZ Multilingual */
d1426 6
a1432 2
	get_audio_ml(musicin_ml, buffer, num_samples_ml, &aiff_ptr, &fr_ps, &aiff, &byte_per_sample,buffer_matr);

d1439 3
d1504 3
a1506 3
		if( stereo == 2) m = 2;
		else m = 1;
                II_scale_factor_calc(sb_sample, scalar, fr_ps.sblimit,
a1507 2
/*****************JMZ 08/03/1995 Multilingual**************/

d1509 1
a1509 1
		II_scale_factor_calc(sb_sample, scalar, fr_ps.sblimit, 7, 7+info.multiling_ch);
a1510 4
/*****************JMZ 08/03/1995 Multilingual**************/

  
  
d1514 1
a1514 1
			 II_scale_factor_calc(*j_sample, j_scale,
d1522 8
a1529 4
                II_Psycho_One(buffer, max_sc, ltmin, &fr_ps,smr,spiki,aiff);
		        	
		

d1545 1
a1545 1
  			 II_encode_bit_alloc(bit_alloc, &fr_ps, &bs);
d1549 1
a1549 1
		 II_encode_scale(bit_alloc, scfsi, scalar, &fr_ps, &bs, &k , &i);
d1587 7
a1593 6
		/*
		 * generate the compatible channel subband signals directly from
		 * the matrixed input signals
		 */
		win_buf[5] = &buffer_matr[0][0];
		win_buf[6] = &buffer_matr[1][0];
d1596 3
d1600 3
a1602 1
                   window_subband(&win_buf[k], &(*win_que)[k][0], k);
d1604 1
d1606 1
d1611 1
a1611 1
                II_scale_factor_calc(sb_sample, scalar, fr_ps.sblimit,
a1613 2
/*****************JMZ 08/03/1995 Multilingual**************/

d1615 1
a1615 5
		II_scale_factor_calc(sb_sample, scalar, fr_ps.sblimit, 7, 7+info.multiling_ch);
		
/*****************JMZ 08/03/1995 Multilingual**************/
				     

a1617 1

d1629 8
a1636 3
		
		
		 II_transmission_pattern(scalar, scfsi, &fr_ps);
d1638 1
a1638 1
 	 /*in case of ext_bit_stream adb is the complete number of bits!! 06/22/94, SR*/
a1645 1
/* 17/03/1995 JMZ TEST MULTILINGUAL */
d1651 1
a1651 1
	    		    adb = (whole_SpF+extra_slot) * bitsPerSlot;
d1653 1
a1653 1
				*subband, &fr_ps, smr, scfsi, &adb);
a1657 1
/* 17/03/1995 JMZ TEST MULTILINGUAL */
d1663 3
a1665 1
		 II_CRC_calcmc(&fr_ps, bit_alloc, scfsi, &crcmc);
a1666 1

d1675 1
a1675 1
		 II_encode_scale(bit_alloc, scfsi, scalar, &fr_ps, &bs, &k, &i);
d1693 5
d1704 1
a1704 1
		 II_encode_scale(bit_alloc, scfsi, scalar, &fr_ps, &bs, &k, &i);
a1705 1

d1708 4
d1713 1
a1713 1
		 II_sample_encodingmc(*subband, bit_alloc, &fr_ps, &bs);
d1759 10
d1797 33
d1831 7
d1887 1
d1894 1
a1894 1
#endif DEBUG
d1938 1
a1938 1
    "       %s [-l lay][-m mode][-p psy][-s sfrq][-b br][-d emp]\n",
d1941 1
a1941 1
    "          [-c][-o][-e] inputPCM [outBS]\n");
d1952 5
a1956 3
    fprintf(stderr," -g matr  matrix                    (dflt 0)\n");
    fprintf(stderr," -k       channel-switching         (dflt no)\n");
    fprintf(stderr," -k dy_cr dyn_cr mode\n");             
d1997 2
a1998 1
	pcm_aiff_data->numChannels != 5) {
@


1.6.3.0
log
@Branch for merging IRT_02 and Philips_01
@
text
@d4 1
a4 1
 * $Id: musicin.c 1.6 1995/06/16 10:01:27 rowlands Exp $
a10 3
 * Revision 1.6  1995/06/16  10:01:27  rowlands
 * Moved merged IRT/Samsung/TI into main revision control trunk.
 *
@


1.6.3.1
log
@Merged
@
text
@d4 1
a4 1
 * $Id: musicin.c 1.6.1.1 1995/11/06 04:12:25 rowlands Exp $
a10 17
 * Revision 1.6.2.1  1995/11/06  04:19:12  rowlands
 * Received from Uwe Felderhoff
 *
 * Revision 1.6.1.1  1995/11/06  04:12:25  rowlands
 * Received from Warner ten Kate
 *
 * Revision 1.8  1995/08/14  07:57:11  tenkate
 * ML-LSF added WtK 7/8/95
 * debugging (whole packet)
 * obtain_params() and parse_args() cleaned up.
 * get_audio_ml() and Psycho_one_ml() only add odd frames upon LSF-ML.
 * II_smr() is called separately because of that.
 * sample shifting is added because of that.
 *
 * Revision 1.7  1995/07/31  07:49:58  tenkate
 * addition of phantom coding, at sevral lines, 25/07/95 WtK
 *
d221 1
a221 2
	int *dyn_cr,
	int *ancillaryUse
d223 1
a223 1
	 int j,bool;
d232 1
a232 2
	 *cha_sw = 1;

d255 1
a255 1
	printf("Enter multilingual input file name <%s.%s>: ",original_file_name,DFLT_ML_EXT);
d260 1
a260 1
		strcat(strcpy(multilingual_file_name, original_file_name), DFLT_ML_EXT);
d273 3
a275 2
                *num_samples_ml = pcm_aiff_data_ml->numChannels *
                                  pcm_aiff_data_ml->numSampleFrames;
d279 2
a280 2
		printf("***WARNING: Could not read AIFF header - No MultiLingual coding!!\n");
	        info->multiling_ch = 0;
a306 5
		if(tot_channels == 6)
	        {
		    info->lfe = 1;
		    printf("lfe is used\n");
		}
d329 1
a329 1
       				printf(">>> Using default 3/2 configuration.\n"); 
d356 1
a356 1
       				printf(">>> Using default 3/1 configuration.\n"); 
d371 1
a371 1
       				printf(">>> Using 3/0 configuration.\n"); 
d376 1
a376 1
       				printf(">>> Using 2/1 configuration.\n"); 
d381 1
a381 1
       				printf(">>> Using default 3/0 configuration.\n"); 
a404 14

       if (info->multiling_ch>0) {
         switch (SmpFrqIndex((long)pcm_aiff_data_ml->sampleRate) - info->sampling_frequency) {
	 case 16 : printf("MultiLingual is LSF coded.\n");
	           info->multiling_fs = 1;
		   break;
	 case  0 : printf("MultiLingual sample rate equals that of Audio.\n");
	           info->multiling_fs = 0;
		   break;
	 default : printf("\n***WARNING: MultiLingual sample rate does not equal (half) mc sample rate.\n            No MultiLingual coding!!!\n\n");
	           info->multiling_ch = 0;
		   break;
	 } /*switch*/
       } /*if (ml_ch>0)*/
a408 1
	        info->multiling_ch = 0;
d621 2
a622 4
        if (info->matrix==3) *cha_sw = 0;
	else
	{
	 printf("Do you want to have Channel-switching?(<y>/n)");
d624 1
a624 1
	 if(*t == 'n')  
d626 2
a627 2
	  *cha_sw = 0;
	  printf("Channel-switching is not used!\n");
d631 2
a632 2
	  *cha_sw = 1;
           printf("Channel-switching is used\n");	 
a633 1
	}
a634 17
	/********* 27/07/95, WtK , phantom coding ********************/
	if ( (fr_ps->stereomc>0) && (info->center==1) )
	{
	  printf("Do you want to use Phantom Coding of the Center signal? (y/<n>) ");
	  gets(t);
          if ( (*t=='y') || (*t=='Y') )
	  {
	    printf(">>> Phantom Coding is used.\n");
	    fr_ps->phantom_c = 1;
	  } 
	  else
	  {
            printf(">>> No Phantom Coding.\n");	 
	    fr_ps->phantom_c = 0;
	  }
        }

d641 3
a643 13
	  bool = 1;
	  do {
	    printf("Which mode of Dynamic Crosstalk do you want? (1 ... 14)\n");
	    gets(t);
	    *dyn_cr = atoi(t);
	    bool = ( 
	             (fr_ps->phantom_c) && 
	             ( (*dyn_cr== 9) || (*dyn_cr==10) || 
	               (*dyn_cr==11) || (*dyn_cr==12) || 
		       (*dyn_cr==14) )
	           );
	    if (bool) printf("!!! Dynamic Crosstalk mode %d cannot be used together with Phantom Coding !!!\n",*dyn_cr);
	  } while (bool) ;
d652 1
a652 5
     /* YBKim060695 ancillary */
     printf("Do you want to use ancillary part ? (y:<n>): ");
     gets(t);
     *ancillaryUse = (*t == 'y' || *t == 'Y');

d677 2
a678 2
/* -x  is followed by the matrix
/* -k  clears the channel-switching flag based on SCF
a679 2
/* -w  sets phantom coding /* 27/07/95: '-p' already reserved for psy */
/* -g  sets MultiLingual coding
d690 2
a691 4
           long unsigned int *num_samples, long unsigned int *num_samples_ml, 
	   char *inPath, char *outPath, 
	   int *aiff, int *byte_per_sample, int *cha_sw, 
	   IFF_AIFF *pcm_aiff_data, IFF_AIFF *pcm_aiff_data_ml, 
d696 2
a697 2
   int	 brate = DFLT_BRT;
   layer *info = fr_ps->header;
a698 1
   int   ml_present = 0; /* MultiLingual coding */
d700 1
a700 1
  *cha_sw = 1;
a704 1
  fr_ps->phantom_c = 0;
d789 5
a793 5
				 *bit_rate = brate;
				 brate = DFLT_BRT;
				 info->ext_length = ((*bit_rate - DFLT_BRT) * 24) / 8;
			       }
			       break;
d809 2
a810 3
		   case 'x':       info->matrix = atoi(arg); 
		                   if (info->matrix==3) *cha_sw = 0;
				   argUsed = 1;
d812 1
a812 1
		   case 'k':       *cha_sw = 0; break;
d815 1
a815 1
          	   case 'y':       *dyn_cr = atoi(arg);	
d819 2
a820 22

				   if (fr_ps->phantom_c) {
				     if (*dyn_cr== 9) *dyn_cr = 0;
				     if (*dyn_cr==10) *dyn_cr = 0;
				     if (*dyn_cr==11) *dyn_cr = 1;
				     if (*dyn_cr==12) *dyn_cr = 2;
				     if (*dyn_cr==14) *dyn_cr = 8;
				   }
				   break;		   
		   
	           case 'w':       fr_ps->phantom_c = 1;	
				   argUsed = 0;
				   if (*dyn_cr== 9) *dyn_cr = 0;
				   if (*dyn_cr==10) *dyn_cr = 0;
				   if (*dyn_cr==11) *dyn_cr = 1;
				   if (*dyn_cr==12) *dyn_cr = 2;
				   if (*dyn_cr==14) *dyn_cr = 8;
				   break;		   
		   case 'g':       ml_present = 1;	
				   argUsed = 0;
				   break;		   

d843 1
a843 2

   if( (info->bitrate_index = BitrateIndex(info->lay, brate)) < 0) err=1;
d870 1
a870 3
		 	fr_ps->stereomc = 3;
			fr_ps->header->center = 1;
			fr_ps->header->surround = 2;
a888 1
	ml_present = 0;
a898 45
/***************************************************************************/
/* 7/8/95 Multi lingual extension WtK                                      */

if (ml_present)
{
     strcat(strcpy(multilingual_file_name, inPath), DFLT_ML_EXT);
     if ((musicin_ml = fopen(multilingual_file_name, "rb")) == NULL) 
     {
	     printf("Could not find \"%s\".\nNo MultiLingual Coding\n", multilingual_file_name);
	     info->multiling_ch = 0;
     }
     else 
     if (aiff_read_headers(musicin_ml, pcm_aiff_data_ml, byte_per_sample) == 0) 
     {
	     printf(">>> Using Audio IFF multilingual file headers\n");
	     info->multiling_ch = pcm_aiff_data_ml->numChannels;
	     printf(">>> Using %d multilingual channels\n",info->multiling_ch);
	     *num_samples_ml = pcm_aiff_data_ml->numChannels *
			       pcm_aiff_data_ml->numSampleFrames;
     }
     else     /* Not using Audio IFF sound file headers. */
     {
	     printf("***WARNING: Could not read ML AIFF header - No MultiLingual coding!!\n");
	     info->multiling_ch = 0;
     }
     if (info->multiling_ch>0) {
       switch (SmpFrqIndex((long)pcm_aiff_data_ml->sampleRate) - info->sampling_frequency) {
       case 16 : printf("MultiLingual is LSF coded.\n");
		 info->multiling_fs = 1;
		 break;
       case  0 : printf("MultiLingual sample rate equals that of Audio.\n");
		 info->multiling_fs = 0;
		 break;
       default : printf("\n***WARNING: MultiLingual sample rate unequals (half) mc sample rate.\n            No MultiLingual coding!!!\n\n");
		 info->multiling_ch = 0;
		 break;
       } /*switch*/
     } /*if (ml_ch>0)*/
} else {
     info->multiling_ch = 0;
}/* if (ml_present) */

/* 7/8/95 Multi lingual extension WtK                                      */
/***************************************************************************/

d936 1
a936 6
   if (info->multiling_ch>0) {
     printf("%d multilingual channels ",info->multiling_ch);
     if (info->multiling_fs==1) printf("LSF coded.\n");
     else                       printf("full sample rate coded.\n");
   }
   else printf("No multilingual coding.\n");
a1006 4
typedef double SAM[12];
    SAM                 *lfe_sample;
typedef unsigned int LSB[12];
    LSB                 *lfe_sbband;
a1019 4

    static unsigned int lfe_alloc;
    static unsigned int lfe_scalar; 

d1027 1
a1027 1
    int i, j, k, adb, p, l, m, lfe, s;
d1031 1
a1031 3
    unsigned long num_samples_ml;	               /* 08/03/1995 JMZ Multilingual */
    int odd_ml = 1;                                    /* LSF MultiLingual: audio inputting only at odd frames , WtK 7/8/95 */
    int ml_eof = 0;                                    /* MultiLingual: frame loop stops if either audio or ML-file has been exhausted , WtK 7/8/95 */
a1032 1

d1034 2
a1035 2
    IFF_AIFF aiff_ptr_ml;	                       /* 08/03/1995 JMZ Multilingual */
    int aiff = 0;                                      /* misused to indicate mc-input */
d1037 1
a1037 2

    int cha_sw = 1;
a1041 5

    int lfe_bits = 0;
    int sentBits1, frameBits1;
    int hi,  hu,  ho;

d1045 2
a1046 3
    FILE *fp100;

    int  ancillaryUse = 0;  /* YBKim060695 ancillary */
a1064 1
fp100 = fopen("SAMPLES", "w+");
d1066 3
a1078 2
    lfe_sample = (SAM *) mem_alloc(sizeof(SAM), "lfe_sample");
    lfe_sbband = (LSB *) mem_alloc(sizeof(LSB),"lfe_sbband");
a1094 1
    fr_ps.tab_num_ml = -1;
a1095 2
    fr_ps.allocml = NULL;

d1099 3
a1101 5

    info.multiling_ch  = 0;
    info.multiling_fs  = 0;
    info.multiling_lay = 0;

a1110 2
    fr_ps.phantom_c = 0;

d1115 2
a1116 2
	 obtain_parameters(&fr_ps, &model, &num_samples, &num_samples_ml, original_file_name,
		 encoded_file_name, &aiff_ptr, &aiff_ptr_ml, &aiff, &byte_per_sample, 
d1118 1
a1118 1
		  &bit_rate, encoded_file_name_mpg, &dyn_cr, &ancillaryUse);
d1120 1
a1120 1
         parse_args(argc, argv, &fr_ps, &model, &num_samples, &num_samples_ml,
d1122 1
a1122 1
		 &cha_sw, &aiff_ptr, &aiff_ptr_ml, encoded_file_name_ext,
a1129 3

    lfe = info.lfe;

d1165 5
a1169 11
     while ( 
             ( get_audio(musicin, buffer, num_samples,
	       stereo, &aiff_ptr, stereomc, &fr_ps, &aiff, &byte_per_sample,
	       buffer_matr, dematrix2_filter_state) > 0 ) &&
	     ( !ml_eof )
	   )  {
    /****************************************************************/
    /*                                                              */
    /*                  START OF FRAME LOOP                         */
    /*                                                              */
    /****************************************************************/
d1171 6
a1188 2
      lfe_alloc = 0;

a1198 4
      if ( (fr_ps.stereomc>0) && ((fr_ps.header->center==1) || (fr_ps.header->center==3)) ) {
	if (fr_ps.phantom_c==1) fr_ps.header->center=3;
	if (fr_ps.phantom_c==0) fr_ps.header->center=1;
      } /* 27/7/95 WtK */
d1200 1
a1200 2
        fprintf(stderr, "{%4lu}\r", frameNum++); fflush(stderr);

d1206 2
a1207 2
	  win_buf[5] = &buffer[5][0];
	  win_buf[6] = &buffer[6][0];
d1232 1
a1232 1
/* 08/03/1995 JMZ Multilingual , WtK 7/8/95 */
a1234 6
   if (odd_ml) {
	if ( get_audio_ml(musicin_ml, buffer, num_samples_ml, &aiff_ptr, &fr_ps, 
	                  &aiff, &byte_per_sample,buffer_matr) != 1152*info.multiling_ch ) {
           printf("\nHit end of MultiLingual file.\n");
	   ml_eof = 1;
	}
d1236 2
a1243 3
        if (info.multiling_fs==1) ml_sb_sample_swap (7,7+info.multiling_ch,sb_sample); /* half fs */
    }
    else ml_sb_sample_shift (7,7+info.multiling_ch,sb_sample);
d1306 3
a1308 3
		if (stereo == 2) m = 2;
		else             m = 1;
                II_scale_factor_calc(&fr_ps,sb_sample, scalar, fr_ps.sblimit,
d1310 2
d1313 1
a1313 1
		   II_scale_factor_calc(&fr_ps,sb_sample, scalar, fr_ps.mlsblimit, 7, 7+info.multiling_ch);
d1315 4
d1322 1
a1322 1
			 II_scale_factor_calc(&fr_ps,*j_sample, j_scale,
d1330 4
a1333 8
                 II_Psycho_One(buffer, max_sc, ltmin, &fr_ps,smr,spiki,aiff);
		 if (odd_ml) II_Psycho_One_ml(buffer, max_sc, ltmin, &fr_ps,smr,spiki);
                 if (info.multiling_fs) {
                    pick_scale_ml_2(&fr_ps,sb_sample,max_sc);
		    for (k=7;k<7+info.multiling_ch;k++) 
		     II_smr(&ltmin[k][0], &smr[k][0], &spiki[k][0], &max_sc[k][0], fr_ps.mlsblimit, 0, fr_ps.mlsblimit);
                 }
		 
d1349 1
a1349 1
		 II_encode_bit_alloc(bit_alloc, &fr_ps, &bs);
d1353 1
a1353 1
		 II_encode_scale(bit_alloc, scfsi, scalar, lfe_alloc, lfe_scalar, &fr_ps, &bs, &k , &i);
d1391 6
a1396 7
             if (lfe){
		lfe_bits = adb;
               lfe_filter(&win_buf[3],*lfe_sample);
               lf_scalefactor(*lfe_sample, &lfe_scalar);
               lfe_allocation(&lfe_alloc, &adb);
		lfe_bits -= adb;     
             }
a1398 3
	     {
		l = 0;

d1400 1
a1400 3
                   if(lfe && (k == 3)) l +=1; 
                   window_subband(&win_buf[l], &(*win_que)[k][0], k);

a1401 1
		   l++;
a1402 1
	     }
d1407 1
a1407 1
                II_scale_factor_calc(&fr_ps,sb_sample, scalar, fr_ps.sblimit,
d1410 2
d1413 5
a1417 1
		   II_scale_factor_calc(&fr_ps,sb_sample, scalar, fr_ps.mlsblimit, 7, 7+info.multiling_ch);
d1420 1
d1432 3
a1434 8
                if (odd_ml) II_Psycho_One_ml(buffer_matr, max_sc, ltmin, &fr_ps, smr, spiki);
                if (info.multiling_fs) {
                  pick_scale_ml_2(&fr_ps,sb_sample,max_sc);
		  for (k=7;k<7+info.multiling_ch;k++) 
		   II_smr(&ltmin[k][0], &smr[k][0], &spiki[k][0], &max_sc[k][0], fr_ps.mlsblimit, 0, fr_ps.mlsblimit);
		}
		  		
		II_transmission_pattern(scalar, scfsi, &fr_ps);
d1436 1
a1436 1
 	        /*in case of ext_bit_stream adb is the complete number of bits!! 06/22/94, SR*/
d1444 1
d1450 1
a1450 1
	    		    adb = (whole_SpF+extra_slot) * bitsPerSlot - lfe_bits;
d1452 1
a1452 1
				*subband, &fr_ps, smr, scfsi, &adb, scfsi_dyn, fp100);
d1457 1
d1463 1
a1463 3
		 lfe_alloc = 4;
		 II_CRC_calcmc(&fr_ps, bit_alloc, lfe_alloc, scfsi, &crcmc);
                 lfe_alloc = 0;
d1465 1
d1474 1
a1474 1
		 II_encode_scale(bit_alloc, scfsi, scalar, lfe_alloc, lfe_scalar, &fr_ps, &bs, &k, &i);
a1491 5
                 if(lfe){
                   lfe_alloc = 4;
                   II_encode_lfe_alloc(lfe_alloc, &fr_ps, &bs);
                 }

d1498 1
a1498 1
		 II_encode_scale(bit_alloc, scfsi, scalar, lfe_alloc, lfe_scalar, &fr_ps, &bs, &k, &i);
d1500 1
a1502 4

                 if(lfe) 
                   II_lfe_quantisation(lfe_scalar, *lfe_sample, lfe_alloc,
                                     *lfe_sbband, &fr_ps);
d1504 1
a1504 1
		 II_sample_encodingmc(*subband, *lfe_sbband, bit_alloc, lfe_alloc, &fr_ps, &bs);
a1549 10
#ifdef DEBUG
       if ( (info.lay==2) && 
            ((int)aiff_ptr.sampleRate==48000) && 
	    (info.ext_bit_stream_present == 0) && 
	    (frameBits != 24*bitrate[info.lay-1][info.bitrate_index]) 
	  ) /* for debugging purposes WtK */
	  fprintf(stderr,"\n***Error. %d bits have been written instead of %d bits.\n",
	                 frameBits,24*bitrate[info.lay-1][info.bitrate_index]);
#endif DEBUG

a1577 33

/* Now the ML part , WtK */
  if (info.multiling_ch>0) {
       printf("\nFrame %4lu ",frameNum-1);
       for (loop_channel=0;loop_channel<info.multiling_ch;loop_channel++) printf("  MLchann %d",loop_channel);
       printf("\n");
       for (loop_subband=0; loop_subband<SBLIMIT; loop_subband++)
       {
         printf("subband %2d :",loop_subband);
         for (loop_channel=0; loop_channel<info.multiling_ch; loop_channel++)
         {
           /* make loop_alloc point to the alloc-table in fr_ps */
           loop_alloc=fr_ps.allocml;
           loop_bits=(* loop_alloc)[loop_subband][bit_alloc[loop_channel][loop_subband]].bits;
	   if ((loop_channel==1) && 
	       (fr_ps.actual_mode == MPG_MD_JOINT_STEREO) &&
	       (loop_subband >= fr_ps.jsbound))
	       printf("js         ");
           else
	   {
	     if ((* loop_alloc)[loop_subband][bit_alloc[loop_channel][loop_subband]].steps == 0)
	       printf("    - bits ");
	     else
	     {
	       if ((* loop_alloc)[loop_subband][bit_alloc[loop_channel][loop_subband]].group == 1)
		 loop_bits /= 3;
	       printf("%5.1f bits ",loop_bits);
	     }
	   }
         } /* for (loop_channel..) */
         printf("\n");
       } /* for (loop_subband..) */
  } /*n_ml_ch>0*/
a1578 7

if (info.multiling_fs==1) odd_ml = 1 - odd_ml; /* ML half fs */
    /****************************************************************/
    /*                                                              */
    /*                   END OF FRAME LOOP                          */
    /*                                                              */
    /****************************************************************/
a1627 1
    fclose(fp100);
d1634 1
a1634 1
#endif 
d1678 1
a1678 1
    "       %s [-l lay][-m mode][-p psy][-s sfrq][-b br][-d emp][-x matr][-y dynX]\n",
d1681 1
a1681 1
    "          [-c][-o][-e][-k][-w][-g] inputPCM [outBS]\n");
d1692 3
a1694 5
    fprintf(stderr," -x matr  matrix                    (dflt 0)\n");
    fprintf(stderr," -k       clear channel-switching   (dflt on)\n");
    fprintf(stderr," -y dynX  dyn_cross mode\n");             
    fprintf(stderr," -w       set phantom coding        (dflt off)\n");
    fprintf(stderr," -g       set MultiLingual coding   (dflt off) input ML filename = inputPCM+\"%s\"\n",DFLT_ML_EXT);
d1735 1
a1735 2
	pcm_aiff_data->numChannels != 5 &&
        pcm_aiff_data->numChannels != 6) {
@


1.6.2.0
log
@Branch for Felderhoff
@
text
@d4 1
a4 1
 * $Id: musicin.c 1.6 1995/06/16 10:01:27 rowlands Exp $
a10 3
 * Revision 1.6  1995/06/16  10:01:27  rowlands
 * Moved merged IRT/Samsung/TI into main revision control trunk.
 *
@


1.6.2.1
log
@Received from Uwe Felderhoff
@
text
@a306 5
		if(tot_channels == 6)
	        {
		    info->lfe = 1;
		    printf("lfe is used\n");
		}
a307 5





a613 2
       
       
a1006 4
typedef double SAM[12];
    SAM                 *lfe_sample;
typedef unsigned int LSB[12];
    LSB                 *lfe_sbband;
a1019 2
    static unsigned int lfe_alloc;
    static unsigned int lfe_scalar; 
d1027 1
a1027 1
    int i, j, k, adb, p, l, m, lfe, s;
a1041 3
    int lfe_bits = 0;
    int sentBits1, frameBits1;
    int hi,  hu,  ho;
a1043 1
    FILE *fp100;
a1065 1
fp100 = fopen("SAMPLES", "w+");
d1068 1
a1077 2
    lfe_sample = (SAM *) mem_alloc(sizeof(SAM), "lfe_sample");
    lfe_sbband = (LSB *) mem_alloc(sizeof(LSB),"lfe_sbband");
a1129 1
    lfe = info.lfe;
a1188 1
      lfe_alloc = 0;
d1353 1
a1353 1
		 II_encode_scale(bit_alloc, scfsi, scalar, lfe_alloc, lfe_scalar, &fr_ps, &bs, &k , &i);
d1391 6
a1396 8
	
             if (lfe){
		lfe_bits = adb;
               lfe_filter(&win_buf[3],*lfe_sample);
               lf_scalefactor(*lfe_sample, &lfe_scalar);
               lfe_allocation(&lfe_alloc, &adb);
		lfe_bits -= adb;     
             }
a1398 2
	     {
	     l = 0;
d1400 1
a1400 2
                   if(lfe && (k == 3)) l +=1; 
                   window_subband(&win_buf[l], &(*win_que)[k][0], k);
a1401 1
		   l++;
a1402 1
		}
d1450 1
a1450 1
	    		    adb = (whole_SpF+extra_slot) * bitsPerSlot - lfe_bits;
d1452 1
a1452 1
				*subband, &fr_ps, smr, scfsi, &adb, scfsi_dyn, fp100);
d1463 1
a1463 3
		 lfe_alloc = 4;
		 II_CRC_calcmc(&fr_ps, bit_alloc, lfe_alloc, scfsi, &crcmc);
                 lfe_alloc = 0;
d1474 1
a1474 2

		 II_encode_scale(bit_alloc, scfsi, scalar, lfe_alloc, lfe_scalar, &fr_ps, &bs, &k, &i);
a1491 6
                 if(lfe){
                   lfe_alloc = 4;
                   II_encode_lfe_alloc(lfe_alloc, &fr_ps, &bs);
                 }


d1498 1
a1498 1
		 II_encode_scale(bit_alloc, scfsi, scalar, lfe_alloc, lfe_scalar, &fr_ps, &bs, &k, &i);
a1502 4

                 if(lfe) 
                   II_lfe_quantisation(lfe_scalar, *lfe_sample, lfe_alloc,
                                     *lfe_sbband, &fr_ps);
d1504 1
a1505 2
		 II_sample_encodingmc(*subband, *lfe_sbband, bit_alloc, lfe_alloc, &fr_ps, &bs);

a1627 1
    fclose(fp100);
d1634 1
a1634 1
#endif 
d1735 1
a1735 2
	pcm_aiff_data->numChannels != 5 &&
        pcm_aiff_data->numChannels != 6) {
@


1.6.1.0
log
@Branch for ten Kate
@
text
@d4 1
a4 1
 * $Id: musicin.c 1.6 1995/06/16 10:01:27 rowlands Exp $
a10 3
 * Revision 1.6  1995/06/16  10:01:27  rowlands
 * Moved merged IRT/Samsung/TI into main revision control trunk.
 *
@


1.6.1.1
log
@Received from Warner ten Kate
@
text
@d4 1
a4 1
 * $Id: musicin.c,v 1.8 1995/08/14 07:57:11 tenkate Exp $
d10 1
a10 12
 * $Log: musicin.c,v $
 * Revision 1.8  1995/08/14  07:57:11  tenkate
 * ML-LSF added WtK 7/8/95
 * debugging (whole packet)
 * obtain_params() and parse_args() cleaned up.
 * get_audio_ml() and Psycho_one_ml() only add odd frames upon LSF-ML.
 * II_smr() is called separately because of that.
 * sample shifting is added because of that.
 *
 * Revision 1.7  1995/07/31  07:49:58  tenkate
 * addition of phantom coding, at sevral lines, 25/07/95 WtK
 *
d221 1
a221 2
	int *dyn_cr,
	int *ancillaryUse
d223 1
a223 1
	 int j,bool;
d232 1
a232 1
	 *cha_sw = 1;
d255 1
a255 1
	printf("Enter multilingual input file name <%s.%s>: ",original_file_name,DFLT_ML_EXT);
d260 1
a260 1
		strcat(strcpy(multilingual_file_name, original_file_name), DFLT_ML_EXT);
d273 3
a275 2
                *num_samples_ml = pcm_aiff_data_ml->numChannels *
                                  pcm_aiff_data_ml->numSampleFrames;
d279 2
a280 2
		printf("***WARNING: Could not read AIFF header - No MultiLingual coding!!\n");
	        info->multiling_ch = 0;
d329 1
a329 1
       				printf(">>> Using default 3/2 configuration.\n"); 
d356 1
a356 1
       				printf(">>> Using default 3/1 configuration.\n"); 
d371 1
a371 1
       				printf(">>> Using 3/0 configuration.\n"); 
d376 1
a376 1
       				printf(">>> Using 2/1 configuration.\n"); 
d381 1
a381 1
       				printf(">>> Using default 3/0 configuration.\n"); 
a404 14

       if (info->multiling_ch>0) {
         switch (SmpFrqIndex((long)pcm_aiff_data_ml->sampleRate) - info->sampling_frequency) {
	 case 16 : printf("MultiLingual is LSF coded.\n");
	           info->multiling_fs = 1;
		   break;
	 case  0 : printf("MultiLingual sample rate equals that of Audio.\n");
	           info->multiling_fs = 0;
		   break;
	 default : printf("\n***WARNING: MultiLingual sample rate unequals (half) mc sample rate.\n            No MultiLingual coding!!!\n\n");
	           info->multiling_ch = 0;
		   break;
	 } /*switch*/
       } /*if (ml_ch>0)*/
a408 1
	        info->multiling_ch = 0;
d621 2
a622 4
        if (info->matrix==3) *cha_sw = 0;
	else
	{
	 printf("Do you want to have Channel-switching?(<y>/n)");
d624 1
a624 1
	 if(*t == 'n')  
d626 2
a627 2
	  *cha_sw = 0;
	  printf("Channel-switching is not used!\n");
d631 2
a632 2
	  *cha_sw = 1;
           printf("Channel-switching is used\n");	 
a633 1
	}
a634 17
	/********* 27/07/95, WtK , phantom coding ********************/
	if ( (fr_ps->stereomc>0) && (info->center==1) )
	{
	  printf("Do you want to use Phantom Coding of the Center signal? (y/<n>) ");
	  gets(t);
          if ( (*t=='y') || (*t=='Y') )
	  {
	    printf(">>> Phantom Coding is used.\n");
	    fr_ps->phantom_c = 1;
	  } 
	  else
	  {
            printf(">>> No Phantom Coding.\n");	 
	    fr_ps->phantom_c = 0;
	  }
        }

d641 3
a643 13
	  bool = 1;
	  do {
	    printf("Which mode of Dynamic Crosstalk do you want? (1 ... 14)\n");
	    gets(t);
	    *dyn_cr = atoi(t);
	    bool = ( 
	             (fr_ps->phantom_c) && 
	             ( (*dyn_cr== 9) || (*dyn_cr==10) || 
	               (*dyn_cr==11) || (*dyn_cr==12) || 
		       (*dyn_cr==14) )
	           );
	    if (bool) printf("!!! Dynamic Crosstalk mode %d cannot be used together with Phantom Coding !!!\n",*dyn_cr);
	  } while (bool) ;
a649 1
	 
d652 1
a652 5
     /* YBKim060695 ancillary */
     printf("Do you want to use ancillary part ? (y:<n>): ");
     gets(t);
     *ancillaryUse = (*t == 'y' || *t == 'Y');

d677 2
a678 2
/* -x  is followed by the matrix
/* -k  clears the channel-switching flag based on SCF
a679 2
/* -w  sets phantom coding /* 27/07/95: '-p' already reserved for psy */
/* -g  sets MultiLingual coding
d690 2
a691 4
           long unsigned int *num_samples, long unsigned int *num_samples_ml, 
	   char *inPath, char *outPath, 
	   int *aiff, int *byte_per_sample, int *cha_sw, 
	   IFF_AIFF *pcm_aiff_data, IFF_AIFF *pcm_aiff_data_ml, 
d696 2
a697 2
   int	 brate = DFLT_BRT;
   layer *info = fr_ps->header;
a698 1
   int   ml_present = 0; /* MultiLingual coding */
d700 1
a700 1
  *cha_sw = 1;
a704 1
  fr_ps->phantom_c = 0;
d789 5
a793 5
				 *bit_rate = brate;
				 brate = DFLT_BRT;
				 info->ext_length = ((*bit_rate - DFLT_BRT) * 24) / 8;
			       }
			       break;
d809 2
a810 3
		   case 'x':       info->matrix = atoi(arg); 
		                   if (info->matrix==3) *cha_sw = 0;
				   argUsed = 1;
d812 1
a812 1
		   case 'k':       *cha_sw = 0; break;
d815 1
a815 1
          	   case 'y':       *dyn_cr = atoi(arg);	
d819 1
a819 20
				   if (fr_ps->phantom_c) {
				     if (*dyn_cr== 9) *dyn_cr = 0;
				     if (*dyn_cr==10) *dyn_cr = 0;
				     if (*dyn_cr==11) *dyn_cr = 1;
				     if (*dyn_cr==12) *dyn_cr = 2;
				     if (*dyn_cr==14) *dyn_cr = 8;
				   }
				   break;		   
		   
	           case 'w':       fr_ps->phantom_c = 1;	
				   argUsed = 0;
				   if (*dyn_cr== 9) *dyn_cr = 0;
				   if (*dyn_cr==10) *dyn_cr = 0;
				   if (*dyn_cr==11) *dyn_cr = 1;
				   if (*dyn_cr==12) *dyn_cr = 2;
				   if (*dyn_cr==14) *dyn_cr = 8;
				   break;		   
		   case 'g':       ml_present = 1;	
				   argUsed = 0;
				   break;		   
d843 1
a843 1
   if( (info->bitrate_index = BitrateIndex(info->lay, brate)) < 0) err=1;
d870 1
a870 3
		 	fr_ps->stereomc = 3;
			fr_ps->header->center = 1;
			fr_ps->header->surround = 2;
a888 1
	ml_present = 0;
a898 45
/***************************************************************************/
/* 7/8/95 Multi lingual extension WtK                                      */

if (ml_present)
{
     strcat(strcpy(multilingual_file_name, inPath), DFLT_ML_EXT);
     if ((musicin_ml = fopen(multilingual_file_name, "rb")) == NULL) 
     {
	     printf("Could not find \"%s\".\nNo MultiLingual Coding\n", multilingual_file_name);
	     info->multiling_ch = 0;
     }
     else 
     if (aiff_read_headers(musicin_ml, pcm_aiff_data_ml, byte_per_sample) == 0) 
     {
	     printf(">>> Using Audio IFF multilingual file headers\n");
	     info->multiling_ch = pcm_aiff_data_ml->numChannels;
	     printf(">>> Using %d multilingual channels\n",info->multiling_ch);
	     *num_samples_ml = pcm_aiff_data_ml->numChannels *
			       pcm_aiff_data_ml->numSampleFrames;
     }
     else     /* Not using Audio IFF sound file headers. */
     {
	     printf("***WARNING: Could not read ML AIFF header - No MultiLingual coding!!\n");
	     info->multiling_ch = 0;
     }
     if (info->multiling_ch>0) {
       switch (SmpFrqIndex((long)pcm_aiff_data_ml->sampleRate) - info->sampling_frequency) {
       case 16 : printf("MultiLingual is LSF coded.\n");
		 info->multiling_fs = 1;
		 break;
       case  0 : printf("MultiLingual sample rate equals that of Audio.\n");
		 info->multiling_fs = 0;
		 break;
       default : printf("\n***WARNING: MultiLingual sample rate unequals (half) mc sample rate.\n            No MultiLingual coding!!!\n\n");
		 info->multiling_ch = 0;
		 break;
       } /*switch*/
     } /*if (ml_ch>0)*/
} else {
     info->multiling_ch = 0;
}/* if (ml_present) */

/* 7/8/95 Multi lingual extension WtK                                      */
/***************************************************************************/

d936 1
a936 6
   if (info->multiling_ch>0) {
     printf("%d multilingual channels ",info->multiling_ch);
     if (info->multiling_fs==1) printf("LSF coded.\n");
     else                       printf("full sample rate coded.\n");
   }
   else printf("No multilingual coding.\n");
d1031 1
a1031 3
    unsigned long num_samples_ml;	               /* 08/03/1995 JMZ Multilingual */
    int odd_ml = 1;                                    /* LSF MultiLingual: audio inputting only at odd frames , WtK 7/8/95 */
    int ml_eof = 0;                                    /* MultiLingual: frame loop stops if either audio or ML-file has been exhausted , WtK 7/8/95 */
d1034 2
a1035 2
    IFF_AIFF aiff_ptr_ml;	                       /* 08/03/1995 JMZ Multilingual */
    int aiff = 0;                                      /* misused to indicate mc-input */
d1037 1
a1037 1
    int cha_sw = 1;
d1044 3
a1046 1
    int  ancillaryUse = 0;  /* YBKim060695 ancillary */
a1094 1
    fr_ps.tab_num_ml = -1;
a1095 1
    fr_ps.allocml = NULL;
d1099 3
a1101 3
    info.multiling_ch  = 0;
    info.multiling_fs  = 0;
    info.multiling_lay = 0;
a1109 1
    fr_ps.phantom_c = 0;
d1115 2
a1116 2
	 obtain_parameters(&fr_ps, &model, &num_samples, &num_samples_ml, original_file_name,
		 encoded_file_name, &aiff_ptr, &aiff_ptr_ml, &aiff, &byte_per_sample, 
d1118 1
a1118 1
		  &bit_rate, encoded_file_name_mpg, &dyn_cr, &ancillaryUse);
d1120 1
a1120 1
         parse_args(argc, argv, &fr_ps, &model, &num_samples, &num_samples_ml,
d1122 1
a1122 1
		 &cha_sw, &aiff_ptr, &aiff_ptr_ml, encoded_file_name_ext,
d1165 5
a1169 11
     while ( 
             ( get_audio(musicin, buffer, num_samples,
	       stereo, &aiff_ptr, stereomc, &fr_ps, &aiff, &byte_per_sample,
	       buffer_matr, dematrix2_filter_state) > 0 ) &&
	     ( !ml_eof )
	   )  {
    /****************************************************************/
    /*                                                              */
    /*                  START OF FRAME LOOP                         */
    /*                                                              */
    /****************************************************************/
d1171 6
a1198 4
      if ( (fr_ps.stereomc>0) && ((fr_ps.header->center==1) || (fr_ps.header->center==3)) ) {
	if (fr_ps.phantom_c==1) fr_ps.header->center=3;
	if (fr_ps.phantom_c==0) fr_ps.header->center=1;
      } /* 27/7/95 WtK */
d1200 1
a1200 1
        fprintf(stderr, "{%4lu}\r", frameNum++); fflush(stderr);
d1206 2
a1207 2
	  win_buf[5] = &buffer[5][0];
	  win_buf[6] = &buffer[6][0];
d1232 1
a1232 1
/* 08/03/1995 JMZ Multilingual , WtK 7/8/95 */
a1234 6
   if (odd_ml) {
	if ( get_audio_ml(musicin_ml, buffer, num_samples_ml, &aiff_ptr, &fr_ps, 
	                  &aiff, &byte_per_sample,buffer_matr) != 1152*info.multiling_ch ) {
           printf("\nHit end of MultiLingual file.\n");
	   ml_eof = 1;
	}
d1236 2
a1243 3
        if (info.multiling_fs==1) ml_sb_sample_swap (7,7+info.multiling_ch,sb_sample); /* half fs */
    }
    else ml_sb_sample_shift (7,7+info.multiling_ch,sb_sample);
d1306 3
a1308 3
		if (stereo == 2) m = 2;
		else             m = 1;
                II_scale_factor_calc(&fr_ps,sb_sample, scalar, fr_ps.sblimit,
d1310 2
d1313 6
a1318 1
		   II_scale_factor_calc(&fr_ps,sb_sample, scalar, fr_ps.mlsblimit, 7, 7+info.multiling_ch);
d1322 1
a1322 1
			 II_scale_factor_calc(&fr_ps,*j_sample, j_scale,
d1330 4
a1333 8
                 II_Psycho_One(buffer, max_sc, ltmin, &fr_ps,smr,spiki,aiff);
		 if (odd_ml) II_Psycho_One_ml(buffer, max_sc, ltmin, &fr_ps,smr,spiki);
                 if (info.multiling_fs) {
                    pick_scale_ml_2(&fr_ps,sb_sample,max_sc);
		    for (k=7;k<7+info.multiling_ch;k++) 
		     II_smr(&ltmin[k][0], &smr[k][0], &spiki[k][0], &max_sc[k][0], fr_ps.mlsblimit, 0, fr_ps.mlsblimit);
                 }
		 
d1349 1
a1349 2
  		 
		 II_encode_bit_alloc(bit_alloc, &fr_ps, &bs);
d1407 1
a1407 1
                II_scale_factor_calc(&fr_ps,sb_sample, scalar, fr_ps.sblimit,
d1409 3
d1413 5
a1417 1
		   II_scale_factor_calc(&fr_ps,sb_sample, scalar, fr_ps.mlsblimit, 7, 7+info.multiling_ch);
d1420 1
d1432 3
a1434 8
                if (odd_ml) II_Psycho_One_ml(buffer_matr, max_sc, ltmin, &fr_ps, smr, spiki);
                if (info.multiling_fs) {
                  pick_scale_ml_2(&fr_ps,sb_sample,max_sc);
		  for (k=7;k<7+info.multiling_ch;k++) 
		   II_smr(&ltmin[k][0], &smr[k][0], &spiki[k][0], &max_sc[k][0], fr_ps.mlsblimit, 0, fr_ps.mlsblimit);
		}
		  		
		II_transmission_pattern(scalar, scfsi, &fr_ps);
d1436 1
a1436 1
 	        /*in case of ext_bit_stream adb is the complete number of bits!! 06/22/94, SR*/
d1444 1
d1457 1
a1548 10
       
#ifdef DEBUG
       if ( (info.lay==2) && 
            ((int)aiff_ptr.sampleRate==48000) && 
	    (info.ext_bit_stream_present == 0) && 
	    (frameBits != 24*bitrate[info.lay-1][info.bitrate_index]) 
	  ) /* for debugging purposes WtK */
	  fprintf(stderr,"\n***Error. %d bits have been written instead of %d bits.\n",
	                 frameBits,24*bitrate[info.lay-1][info.bitrate_index]);
#endif DEBUG
a1577 32
/* Now the ML part , WtK */
  if (info.multiling_ch>0) {
       printf("\nFrame %4lu ",frameNum-1);
       for (loop_channel=0;loop_channel<info.multiling_ch;loop_channel++) printf("  MLchann %d",loop_channel);
       printf("\n");
       for (loop_subband=0; loop_subband<SBLIMIT; loop_subband++)
       {
         printf("subband %2d :",loop_subband);
         for (loop_channel=0; loop_channel<info.multiling_ch; loop_channel++)
         {
           /* make loop_alloc point to the alloc-table in fr_ps */
           loop_alloc=fr_ps.allocml;
           loop_bits=(* loop_alloc)[loop_subband][bit_alloc[loop_channel][loop_subband]].bits;
	   if ((loop_channel==1) && 
	       (fr_ps.actual_mode == MPG_MD_JOINT_STEREO) &&
	       (loop_subband >= fr_ps.jsbound))
	       printf("js         ");
           else
	   {
	     if ((* loop_alloc)[loop_subband][bit_alloc[loop_channel][loop_subband]].steps == 0)
	       printf("    - bits ");
	     else
	     {
	       if ((* loop_alloc)[loop_subband][bit_alloc[loop_channel][loop_subband]].group == 1)
		 loop_bits /= 3;
	       printf("%5.1f bits ",loop_bits);
	     }
	   }
         } /* for (loop_channel..) */
         printf("\n");
       } /* for (loop_subband..) */
  } /*n_ml_ch>0*/
a1578 7

if (info.multiling_fs==1) odd_ml = 1 - odd_ml; /* ML half fs */
    /****************************************************************/
    /*                                                              */
    /*                   END OF FRAME LOOP                          */
    /*                                                              */
    /****************************************************************/
d1678 1
a1678 1
    "       %s [-l lay][-m mode][-p psy][-s sfrq][-b br][-d emp][-x matr][-y dynX]\n",
d1681 1
a1681 1
    "          [-c][-o][-e][-k][-w][-g] inputPCM [outBS]\n");
d1692 3
a1694 5
    fprintf(stderr," -x matr  matrix                    (dflt 0)\n");
    fprintf(stderr," -k       clear channel-switching   (dflt on)\n");
    fprintf(stderr," -y dynX  dyn_cross mode\n");             
    fprintf(stderr," -w       set phantom coding        (dflt off)\n");
    fprintf(stderr," -g       set MultiLingual coding   (dflt off) input ML filename = inputPCM+\"%s\"\n",DFLT_ML_EXT);
@


1.5
log
@Moved merged IRT/TI into main revision control trunk.
@
text
@d4 1
a4 1
 * $Id: musicin.c 1.4.2.3 1995/06/16 06:27:33 rowlands Exp $
d11 9
d155 9
d179 2
d1041 3
d1162 8
d1281 9
a1289 2
             for (i=0;i<adb;i++) put1bit(&bs, 0);
 
d1375 8
a1382 4
                 for (i=0;i<adb;i++){
		  put1bit(&bs, 0);
		  } 
		 
d1400 1
a1400 1

d1442 1
d1453 1
a1456 1

d1523 7
a1529 5

		 for (i = 0; i < adb; i++)
                           put1bit(&bs, 0);


@


1.4
log
@Added header and RCS info to initial revision.
@
text
@d4 1
a4 1
 * $Id$
d10 25
a34 1
 * $Log$
d183 17
a199 16
obtain_parameters(frame_params *fr_ps, int *psy, long unsigned int *num_samples, long unsigned int *num_samples_ml, char *original_file_name, char *encoded_file_name, IFF_AIFF *pcm_aiff_data, IFF_AIFF *pcm_aiff_data_ml, int *aiff, int *byte_per_sample, int *cha_sw, char *encoded_file_name_ext, int *bit_rate, char *encoded_file_name_mpg)
                       
                     
                             
                                 	/* 08/03/1995 JMZ Multilingual */
    		                                  
    		                                 
         	               
         	                   	/* 08/03/1995 JMZ Multilingual */
   		      
   		                 
                        
    		                                     
    		                                     
                          
{
d210 3
a212 1
 
d612 15
d656 1
d666 5
a670 1
parse_args(int argc, char **argv, frame_params *fr_ps, int *psy, long unsigned int *num_samples, char *inPath, char *outPath, int *aiff, int *byte_per_sample, int *cha_sw, IFF_AIFF *pcm_aiff_data, char *encoded_file_name_ext, int *bit_rate, char *encoded_file_name_mpg)
d681 1
d790 8
a797 1
				   
d847 1
d995 1
a995 1
    static unsigned int scalar[14][3][SBLIMIT], j_scale[2][3][SBLIMIT];
d1009 1
d1015 1
d1085 1
d1092 1
a1092 2
		  &bit_rate, encoded_file_name_mpg);

d1097 1
a1097 1
		  &bit_rate, encoded_file_name_mpg);
d1141 1
a1141 1
             buffer_matr) > 0) {
d1202 1
a1202 1
get_audio_ml(musicin_ml, buffer, num_samples_ml, &aiff_ptr, &fr_ps, &aiff, &byte_per_sample,buffer_matr);
d1298 2
a1299 1
					spiki, *j_sample, j_scale);
d1346 7
d1354 1
a1354 1
		for (k = 0; k < stereo+stereomc; k++) {
d1358 1
a1358 4
 
 
 
 
d1360 1
d1396 1
a1396 1
					spiki, *j_sample, j_scale);
a1397 1
					
d1402 1
a1402 3
		    if(fr_ps.actual_mode != MPG_MD_JOINT_STEREO)
		    {
			if(info.matrix == 0)
a1408 1
		    }	    
a1413 1

d1646 1
@


1.4.3.0
log
@Created branch for Samsung
@
text
@d4 1
a4 1
 * $Id: musicin.c 1.4 1995/04/06 04:29:39 rowlands Exp $
d10 1
a10 4
 * $Log: musicin.c $
 * Revision 1.4  1995/04/06  04:29:39  rowlands
 * Added header and RCS info to initial revision.
 *
@


1.4.3.1
log
@Input from Samsung AIT.
@
text
@d4 1
a4 1
 * $Id: musicin.c,v 1.4 1995/04/06 04:29:39 rowlands Exp $
d10 1
a10 1
 * $Log: musicin.c,v $
a124 9
/**********************************************************************
 *                                                                    *
 *  06/06/95	   Yeon Bae Thomas Kim,  Samsung AIT                  *
 *                 ancillary data is working                          *
 *                                                                    *
 *  06/06/95	   Sang Wook Kim,  Samsung AIT                        *
 *                 corrected some bugs                                *
 *                                                                    *
 **********************************************************************/
a139 2
int		   mesg_index=0; /* YBKim060695 ancillary */

a965 3

    char t[50];		/* YBKim060695 ancillary */
    int  ancillaryUse;  /* YBKim060695 ancillary */
a1083 8
     /* YBKim060695 ancillary */
     printf("Do you want to use ancillary part ? (y:<n>): ");
     gets(t);
     if(*t == 'y' || *t == 'Y') ancillaryUse = 1;
     else ancillaryUse = 0;



d1195 1
a1195 9

		 /* YBKim060695 ancillary */
		 if(ancillaryUse) {
			ancillary_encode(&fr_ps,&bs,adb);
		 } else {
		 	for (i = 0; i < adb; i++)
                           	put1bit(&bs, 0);
		 }

d1281 3
a1283 8
		 /* YBKim060695 ancillary */
		 if(ancillaryUse) {
			ancillary_encode(&fr_ps,&bs,adb);
		 } else {
		 	for (i = 0; i < adb; i++)
                           	put1bit(&bs, 0);
		 }

a1339 3

		/* SWKim060695 remove duplication lines */
		/*
a1341 1
		*/
a1351 2
		/* SWKim060695 remove duplication lines */
		/*
a1352 1
		*/
d1424 3
a1426 7
		 /* YBKim060695 ancillary */
		 if(ancillaryUse) {
			ancillary_encode(&fr_ps,&bs,adb);
		 } else {
		 	for (i = 0; i < adb; i++)
                           	put1bit(&bs, 0);
		 }
@


1.4.3.2
log
@Merged and tested revisions 1.5 and 1.4.3.1
@
text
@d4 1
a4 1
 * $Id: musicin.c 1.5 1995/06/16 06:29:49 rowlands Exp $
d10 1
a10 28
 * $Log: musicin.c $
 * Revision 1.4.3.1  1995/06/16  08:25:11  rowlands
 * Input from Samsung AIT.
 *
 * Revision 1.5  1995/06/16  06:29:49  rowlands
 * Moved merged IRT/TI into main revision control trunk.
 *
 * Revision 1.4.2.3  1995/06/16  06:27:33  rowlands
 * Merged and tested revisions 1.4.1.4 and 1.4.2.1
 *
 * Revision 1.4.2.2  1995/06/16  04:45:49  rowlands
 * Merged TI and IRT mods using #ifdef _IRT
 *
 * Revision 1.4.2.1  1995/06/16  03:46:42  rowlands
 * Input from IRT
 *
 * Revision 1.4.1.4  1995/06/16  02:49:33  rowlands
 * Added dematrix procedure 2
 *
 * Added support for dematrix procedure 2, without predistortion yet.
 * Calculated the compatible stereo signal subband samples by
 * transforming the compatible signal used for the psychoacoustics,
 * instead of recalculating in the subband domain from the other
 * channels.
 *
 * Revision 1.4.1.0  1995/06/07  00:56:16  rowlands
 * Created branch for TI
 *
d173 16
a188 17
obtain_parameters(
	frame_params *fr_ps,
	int *psy,
	long unsigned int *num_samples,
	long unsigned int *num_samples_ml,
	char *original_file_name,
	char *encoded_file_name,
	IFF_AIFF *pcm_aiff_data,
	IFF_AIFF *pcm_aiff_data_ml,
	int *aiff,
	int *byte_per_sample,
	int *cha_sw,
	char *encoded_file_name_ext,
	int *bit_rate,
	char *encoded_file_name_mpg,
	int *dyn_cr
) {
d199 1
a199 3
	/********* 05/24/95, SR , dynamic cross_talk ********************/
	 *dyn_cr = 0;
	 
a598 15
	/********* 05/24/95, SR , dynamic cross_talk ********************/
	 printf("Do you want to have Dynamic Crosstalk?(y/<n>)");
	 gets(t);
	 if(*t == 'y')  
	 {
	  printf("Dynamic Crosstalk is used!\n");
	  printf("Which mode of Dynamic Crosstalk do you want? (1 ... 14)\n");
	  gets(t);
	  *dyn_cr = atoi(t);
	 } 
	 else
	 {
	  *dyn_cr = 0;
          printf("Dynamic Crosstalk is not used\n");	 
	 }
a627 1
/* -y* is followed by the a dynamic crosstalk mode
d637 1
a637 5
parse_args(int argc, char **argv, frame_params *fr_ps, int *psy, 
           long unsigned int *num_samples, char *inPath, char *outPath, 
	   int *aiff, int *byte_per_sample, int *cha_sw, IFF_AIFF *pcm_aiff_data, 
	   char *encoded_file_name_ext, int *bit_rate, char *encoded_file_name_mpg, 
	   int *dyn_cr)
a647 1
  *dyn_cr = 0;
d756 1
a756 8
		   
	/********* 05/24/95, SR , dynamic cross_talk ********************/
	   case 'y':       *dyn_cr = atoi(arg);	
				    if(*dyn_cr == 0)
					*dyn_cr = 15;
				    argUsed = 1;		/* necessary ? */
				    break;		   
					   
a805 1
		 	fr_ps->stereomc =3;
d953 1
a953 1
    static unsigned int scalar[14][3][SBLIMIT], j_scale[2][3][SBLIMIT],  scalar_dyn[14][3][SBLIMIT];
a966 1
    double   dematrix2_filter_state[3];
a971 1
    int dyn_cr = 0;
a1043 1
    init_dematrix2_filter_state(dematrix2_filter_state);
d1050 2
a1051 1
		  &bit_rate, encoded_file_name_mpg, &dyn_cr);
d1056 1
a1056 1
		  &bit_rate, encoded_file_name_mpg, &dyn_cr);
d1108 1
a1108 1
             buffer_matr, dematrix2_filter_state) > 0) {
d1169 1
a1169 1
	get_audio_ml(musicin_ml, buffer, num_samples_ml, &aiff_ptr, &fr_ps, &aiff, &byte_per_sample,buffer_matr);
d1226 1
d1273 1
a1273 2
					spiki, *j_sample, j_scale, dyn_cr, scfsi_dyn, 
					scalar_dyn);
d1319 1
a1324 7
		/*
		 * generate the compatible channel subband signals directly from
		 * the matrixed input signals
		 */
		win_buf[5] = &buffer_matr[0][0];
		win_buf[6] = &buffer_matr[1][0];

d1326 1
a1326 1
		for (k = 0; k < 7; k++) {
d1331 3
a1334 1

d1370 1
a1370 1
					spiki, *j_sample, j_scale, dyn_cr, scfsi_dyn, scalar_dyn);
d1372 1
d1376 2
d1380 4
a1383 1
			if((info.matrix == 0) && (info.dyn_cross_on == 0))
d1390 3
d1394 1
a1394 1

d1398 2
d1473 2
a1635 1
    fprintf(stderr," -k dy_cr dyn_cr mode\n");             
@


1.4.2.0
log
@Created branch for IRT
@
text
@d4 1
a4 1
 * $Id: musicin.c 1.4 1995/04/06 04:29:39 rowlands Exp $
d10 1
a10 4
 * $Log: musicin.c $
 * Revision 1.4  1995/04/06  04:29:39  rowlands
 * Added header and RCS info to initial revision.
 *
@


1.4.2.1
log
@Input from IRT
@
text
@d4 1
a4 1
 * $Id: musicin.c,v 1.4 1995/04/06 04:29:39 rowlands Exp $
d10 1
a10 1
 * $Log: musicin.c,v $
d162 1
a162 1
obtain_parameters(frame_params *fr_ps, int *psy, long unsigned int *num_samples, long unsigned int *num_samples_ml, char *original_file_name, char *encoded_file_name, IFF_AIFF *pcm_aiff_data, IFF_AIFF *pcm_aiff_data_ml, int *aiff, int *byte_per_sample, int *cha_sw, char *encoded_file_name_ext, int *bit_rate, char *encoded_file_name_mpg, int *dyn_cr)
a187 3
	/********* 05/24/95, SR , dynamic cross_talk ********************/
	 *dyn_cr = 0;
	 
a587 15
	/********* 05/24/95, SR , dynamic cross_talk ********************/
	 printf("Do you want to have Dynamic Crosstalk?(y/<n>)");
	 gets(t);
	 if(*t == 'y')  
	 {
	  printf("Dynamic Crosstalk is used!\n");
	  printf("Which mode of Dynamic Crosstalk do you want? (1 ... 14)\n");
	  gets(t);
	  *dyn_cr = atoi(t);
	 } 
	 else
	 {
	  *dyn_cr = 0;
          printf("Dynamic Crosstalk is not used\n");	 
	 }
a616 1
/* -y* is followed by the a dynamic crosstalk mode
d626 1
a626 5
parse_args(int argc, char **argv, frame_params *fr_ps, int *psy, 
           long unsigned int *num_samples, char *inPath, char *outPath, 
	   int *aiff, int *byte_per_sample, int *cha_sw, IFF_AIFF *pcm_aiff_data, 
	   char *encoded_file_name_ext, int *bit_rate, char *encoded_file_name_mpg, 
	   int *dyn_cr)
a636 1
  *dyn_cr = 0;
d650 1
a650 2
 /*  *psy = DFLT_PSY;*/
     *psy = 1;
d745 1
a745 8
		   
	/********* 05/24/95, SR , dynamic cross_talk ********************/
	   case 'y':       *dyn_cr = atoi(arg);	
				    if(*dyn_cr == 0)
					*dyn_cr = 15;
				    argUsed = 1;		/* necessary ? */
				    break;		   
					   
a794 1
		 	fr_ps->stereomc =3;
d942 1
a942 1
    static unsigned int scalar[14][3][SBLIMIT], j_scale[2][3][SBLIMIT],  scalar_dyn[14][3][SBLIMIT];
a960 1
    int dyn_cr = 0;
d1036 1
a1036 1
		  &bit_rate, encoded_file_name_mpg, &dyn_cr);
d1042 1
a1042 1
		  &bit_rate, encoded_file_name_mpg, &dyn_cr);
d1243 1
a1243 2
					spiki, *j_sample, j_scale, dyn_cr, scfsi_dyn, 
					scalar_dyn);
d1335 1
a1335 2
					spiki, *j_sample, j_scale, dyn_cr, scfsi_dyn, scalar_dyn);
		     			
d1337 1
d1342 3
a1344 1
			if((info.matrix == 0) && (info.dyn_cross_on == 0))
d1351 1
a1589 1
    fprintf(stderr," -k dy_cr dyn_cr mode\n");             
@


1.4.2.2
log
@Merged TI and IRT mods using #ifdef _IRT
@
text
@d4 1
a4 1
 * $Id: musicin.c 1.4.2.1 1995/06/16 03:46:42 rowlands Exp $
d10 1
a10 16
 * $Log: musicin.c $
 * Revision 1.4.2.1  1995/06/16  03:46:42  rowlands
 * Input from IRT
 *
 * Revision 1.4.1.4  1995/06/16  02:49:33  rowlands
 * Added dematrix procedure 2
 *
 * Added support for dematrix procedure 2, without predistortion yet.
 * Calculated the compatible stereo signal subband samples by
 * transforming the compatible signal used for the psychoacoustics,
 * instead of recalculating in the subband domain from the other
 * channels.
 *
 * Revision 1.4.1.0  1995/06/07  00:56:16  rowlands
 * Created branch for TI
 *
a161 3
#ifndef _IRT
obtain_parameters(frame_params *fr_ps, int *psy, long unsigned int *num_samples, long unsigned int *num_samples_ml, char *original_file_name, char *encoded_file_name, IFF_AIFF *pcm_aiff_data, IFF_AIFF *pcm_aiff_data_ml, int *aiff, int *byte_per_sample, int *cha_sw, char *encoded_file_name_ext, int *bit_rate, char *encoded_file_name_mpg)
#else _IRT
a162 1
#endif _IRT
a187 1
#ifdef _IRT
a190 1
#endif _IRT
a590 1
#ifdef _IRT
a605 1
#endif _IRT
a634 1
#ifdef _IRT
a635 1
#endif _IRT
a644 3
#ifndef _IRT
parse_args(int argc, char **argv, frame_params *fr_ps, int *psy, long unsigned int *num_samples, char *inPath, char *outPath, int *aiff, int *byte_per_sample, int *cha_sw, IFF_AIFF *pcm_aiff_data, char *encoded_file_name_ext, int *bit_rate, char *encoded_file_name_mpg)
#else _IRT
a649 1
#endif _IRT
a659 1
#ifdef _IRT
a660 1
#endif _IRT
a673 3
#ifndef _IRT
   *psy = DFLT_PSY;
#else _IRT
a675 1
#endif _IRT
a769 3
#ifndef _IRT
				   
#else _IRT
a777 1
#endif _IRT
a826 1
#ifdef _IRT
a827 1
#endif _IRT
a974 3
#ifndef _IRT
    static unsigned int scalar[14][3][SBLIMIT], j_scale[2][3][SBLIMIT];
#else _IRT
a975 1
#endif _IRT
a988 3
#ifndef _IRT
    double   dematrix2_filter_state[3];
#endif _IRT
a993 1
#ifdef _IRT
a994 1
#endif _IRT
a1063 3
#ifndef _IRT
    init_dematrix2_filter_state(dematrix2_filter_state);
#endif _IRT
a1069 3
#ifndef _IRT
		  &bit_rate, encoded_file_name_mpg);
#else _IRT
a1070 1
#endif _IRT
a1075 3
#ifndef _IRT
		  &bit_rate, encoded_file_name_mpg);
#else _IRT
a1076 1
#endif _IRT
a1119 3
#ifndef _IRT
             buffer_matr, dematrix2_filter_state) > 0) {
#else _IRT
a1120 1
#endif _IRT
a1180 3
#ifndef _IRT
	get_audio_ml(musicin_ml, buffer, num_samples_ml, &aiff_ptr, &fr_ps, &aiff, &byte_per_sample,buffer_matr);
#else _IRT
a1181 1
#endif _IRT
a1276 3
#ifndef _IRT
					spiki, *j_sample, j_scale);
#else _IRT
a1278 1
#endif _IRT
a1324 9
#ifndef _IRT
		/*
		 * generate the compatible channel subband signals directly from
		 * the matrixed input signals
		 */
		win_buf[5] = &buffer_matr[0][0];
		win_buf[6] = &buffer_matr[1][0];

#endif _IRT
a1325 3
#ifndef _IRT
		for (k = 0; k < 7; k++) {
#else _IRT
a1326 1
#endif _IRT
a1329 3
#ifndef _IRT

#else _IRT
a1333 1
#endif _IRT
a1334 3
#ifndef _IRT

#endif _IRT
a1369 4
#ifndef _IRT
					spiki, *j_sample, j_scale);

#else _IRT
a1371 1
#endif _IRT
a1376 5
#ifndef _IRT
		    if(fr_ps.actual_mode != MPG_MD_JOINT_STEREO)
		    {
			if(info.matrix == 0)
#else _IRT
a1377 1
#endif _IRT
a1383 3
#ifndef _IRT
		    }	    
#endif _IRT
a1388 1
#ifdef _IRT
a1389 1
#endif _IRT
a1621 1
#ifdef _IRT
a1622 1
#endif _IRT
@


1.4.2.3
log
@Merged and tested revisions 1.4.1.4 and 1.4.2.1
@
text
@d4 1
a4 1
 * $Id: musicin.c 1.4.2.2 1995/06/16 04:45:49 rowlands Exp rowlands $
a10 3
 * Revision 1.4.2.2  1995/06/16  04:45:49  rowlands
 * Merged TI and IRT mods using #ifdef _IRT
 *
d177 20
a196 17
obtain_parameters(
	frame_params *fr_ps,
	int *psy,
	long unsigned int *num_samples,
	long unsigned int *num_samples_ml,
	char *original_file_name,
	char *encoded_file_name,
	IFF_AIFF *pcm_aiff_data,
	IFF_AIFF *pcm_aiff_data_ml,
	int *aiff,
	int *byte_per_sample,
	int *cha_sw,
	char *encoded_file_name_ext,
	int *bit_rate,
	char *encoded_file_name_mpg,
	int *dyn_cr
) {
d207 1
d211 2
d612 1
d628 1
d658 1
d660 1
d670 3
d678 1
d689 1
d691 1
d705 1
d707 4
d805 3
d816 1
d866 1
d868 1
d1016 3
d1020 1
d1034 1
d1036 1
d1042 1
d1044 1
d1114 1
d1116 1
d1123 3
d1127 2
d1133 3
d1137 1
d1181 1
d1183 3
d1246 1
d1248 3
d1346 3
d1351 1
d1398 1
d1406 1
d1408 1
d1410 3
d1416 1
d1418 6
d1425 1
d1427 1
d1463 4
d1468 2
d1475 5
d1481 1
d1488 3
d1496 3
d1731 1
d1733 1
@


1.4.1.0
log
@Created branch for TI
@
text
@d4 1
a4 1
 * $Id: musicin.c 1.4 1995/04/06 04:29:39 rowlands Exp $
d10 1
a10 4
 * $Log: musicin.c $
 * Revision 1.4  1995/04/06  04:29:39  rowlands
 * Added header and RCS info to initial revision.
 *
@


1.4.1.1
log
@Screwed it up too much to work, and didn't save intermediate versions
@
text
@d4 1
a4 1
 * $Id: musicin.c 1.4.1.0 1995/06/07 00:56:16 rowlands Exp rowlands $
a10 3
 * Revision 1.4.1.0  1995/06/07  00:56:16  rowlands
 * Created branch for TI
 *
a955 1
    double   dematrix2_filter_state[3];
a1029 1
    init_dematrix2_filter_state(dematrix2_filter_state);
d1086 1
a1086 1
             buffer_matr, dematrix2_filter_state) > 0) {
d1112 14
d1147 1
a1147 1
	get_audio_ml(musicin_ml, buffer, num_samples_ml, &aiff_ptr, &fr_ps, &aiff, &byte_per_sample,buffer_matr);
a1148 3
	for (k = 7; k < 7 + info.multiling_ch; k++) {
		win_buf[k] = &buffer[k][0];
	}
a1165 3
	     for (k = 0; l < stereo; k++) {
		win_buf[k] = &buffer[k][0];
	     }
a1202 3
	     for (k = 0; k < stereo; k++) {
		win_buf[k] = &buffer[k][0];
	     }
a1289 7
	     /*
	      * for multichannel, input the matrixed audio channels to the
	      * analysis filter bank instead of the original audio channels.
	      */
	     for (k = 0; k < 7; k++) {
		win_buf[k] = &buffer_matr[k][0];
	     }
d1291 1
a1291 1
		for (k = 0; k < 7; k++) {
d1296 4
a1299 2
		matrix_scaling(sb_sample, &fr_ps);

d1337 1
a1337 1
#if 0
a1354 1
#endif
@


1.4.1.2
log
@Backed off on some changes - working again
@
text
@d4 1
a4 1
 * $Id: musicin.c 1.4.1.1 1995/06/11 23:26:49 rowlands Exp $
a10 3
 * Revision 1.4.1.1  1995/06/11  23:26:49  rowlands
 * Screwed it up too much to work, and didn't save intermediate versions
 *
a1116 14
          win_buf[0] = &buffer[0][0];
	  win_buf[1] = &buffer[1][0];
	  win_buf[2] = &buffer[2][0];
	  win_buf[3] = &buffer[3][0];
	  win_buf[4] = &buffer[4][0];
	  win_buf[5] = &buffer[5][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[6] = &buffer[6][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[7] = &buffer[7][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[8] = &buffer[8][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[9] = &buffer[9][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[10] = &buffer[10][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[11] = &buffer[11][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[12] = &buffer[12][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[13] = &buffer[13][0];	/* JMZ 08/03/1995 Multilingual */
d1140 3
d1160 3
d1200 3
d1290 7
d1298 1
a1298 1
		for (k = 0; k < stereo+stereomc; k++) {
d1303 1
a1303 1
		matricing(sb_sample, &fr_ps);
a1340 1

d1342 1
d1360 2
@


1.4.1.3
log
@Still not working, and getting inconsistent results. Possible
compiler problem??
@
text
@d4 1
a4 1
 * $Id: musicin.c 1.4.1.2 1995/06/12 00:54:04 rowlands Exp rowlands $
a10 3
 * Revision 1.4.1.2  1995/06/12  00:54:04  rowlands
 * Backed off on some changes - working again
 *
a1297 9
#ifdef NEW_MATRIX_MUSICIN
		/*
		 * generate the compatible channel subband signals directly from
		 * the matrixed input signals
		 */
		win_buf[5] = &buffer_matr[0][0];
		win_buf[6] = &buffer_matr[1][0];
#endif /* NEW_MATRIX_MUSICIN */

a1298 3
#ifdef NEW_FILTER_MUSICIN
		for (k = 0; k < 7; k++) {
#else /* !NEW_FILTER_MUSICIN */
a1299 1
#endif /* !NEW_FILTER_MUSICIN */
d1303 1
a1303 1

@


1.4.1.4
log
@Added dematrix procedure 2
@
text
@d4 1
a4 1
 * $Id: musicin.c 1.4.1.3 1995/06/14 03:03:55 rowlands Exp rowlands $
d11 2
a12 5
 * Added support for dematrix procedure 2, without predistortion yet.
 * Calculated the compatible stereo signal subband samples by
 * transforming the compatible signal used for the psychoacoustics,
 * instead of recalculating in the subband domain from the other
 * channels.
d14 3
d1301 1
d1308 1
d1311 1
d1313 3
@


1.3
log
@Hand-fixes after protoize
@
text
@d2 11
a12 3
Copyright (c) 1991 MPEG/audio software simulation group, All Rights Reserved
musicin.c
**********************************************************************/
a13 5
 * MPEG/audio coding/decoding software, work in progress              *
 *   NOT for public distribution until verified and approved by the   *
 *   MPEG/audio committee.  For further information, please contact   *
 *   Davis Pan, 508-493-2241, e-mail: pan@@gauss.enet.dec.com          *
 *                                                                    *
@


1.2
log
@Processed with protoize
@
text
@d932 2
a933 2
    long *win_buf[14];						/* JMZ 08/03/1995 */
    static long buffer[14][1152];			/* JMZ 08/03/1995 */			
d1220 1
a1220 1
			 II_scale_factor_calc(j_sample, j_scale,
d1237 1
a1237 1
					spiki, j_sample, j_scale);
d1322 1
a1322 1
		 II_transmission_pattern(scalar, scfsi, &fr_ps, scfsi_dyn);
d1329 1
a1329 1
					spiki, j_sample, j_scale);
@


1.1
log
@Initial revision
@
text
@d156 15
a170 17
obtain_parameters(fr_ps,psy,num_samples, num_samples_ml/*JMZ 08/03/1995 Multilingual*/,original_file_name,encoded_file_name,
			pcm_aiff_data, pcm_aiff_data_ml/*JMZ 08/03/1995 Multilingual*/, aiff, byte_per_sample, cha_sw, 
			encoded_file_name_ext, bit_rate, encoded_file_name_mpg)
frame_params    *fr_ps;
int             *psy;
unsigned long   *num_samples;
unsigned long   *num_samples_ml; 	/* 08/03/1995 JMZ Multilingual */
char		original_file_name[MAX_NAME_SIZE];
char		encoded_file_name[MAX_NAME_SIZE];
IFF_AIFF 	*pcm_aiff_data;
IFF_AIFF 	*pcm_aiff_data_ml; 	/* 08/03/1995 JMZ Multilingual */
int		*aiff;
int		*byte_per_sample;
int             *cha_sw;
char		encoded_file_name_ext[MAX_NAME_SIZE];
char		encoded_file_name_mpg[MAX_NAME_SIZE];
int             *bit_rate;
d620 1
a620 17
parse_args(argc, argv, fr_ps, psy, num_samples, inPath, outPath, aiff, byte_per_sample,
		 cha_sw,pcm_aiff_data, encoded_file_name_ext, bit_rate, 
		 encoded_file_name_mpg) 
int     argc;
char    **argv;
frame_params  *fr_ps;
int     *psy;
unsigned long *num_samples;
char    inPath[MAX_NAME_SIZE];
char	  outPath[MAX_NAME_SIZE];
int	  *aiff;
int	  *byte_per_sample;
int       *cha_sw;
IFF_AIFF 	*pcm_aiff_data;
char		encoded_file_name_ext[MAX_NAME_SIZE];
char		encoded_file_name_mpg[MAX_NAME_SIZE];
int             *bit_rate;
d828 1
a828 7
print_config(fr_ps, psy, num_samples, inPath, outPath, aiff)
frame_params *fr_ps;
int     *psy;
unsigned long *num_samples;
char    inPath[MAX_NAME_SIZE];
char	  outPath[MAX_NAME_SIZE];
int	  *aiff;
d914 1
a914 3
main(argc, argv)
int     argc;
char    **argv;
d1562 1
a1562 1
static void usage()  /* print syntax & exit */
d1599 3
a1601 3
void aiff_check(file_name, pcm_aiff_data)
char *file_name;          /* Pointer to name of AIFF file */
IFF_AIFF *pcm_aiff_data;  /* Pointer to AIFF data structure */
@
