head	1.9;
access;
symbols
	Distribution_06:1.7
	IRT_02:1.6.2.1
	Philips_01:1.6.1.1
	D6Base:1.6
	Distribution_05:1.6
	Distribution_04:1.6
	Distribution_03:1.6
	Samsung_01:1.4.3.1
	IRT_01:1.4.2.1
	TI_01:1.4.1.6
	Distribution_01a:1.5
	Distribution_02:1.6
	Distribution_00:1.1
	Distribution_01:1.4;
locks; strict;
comment	@ * @;


1.9
date	96.02.12.07.13.35;	author rowlands;	state Exp;
branches;
next	1.8;

1.8
date	96.02.12.05.51.17;	author rowlands;	state Exp;
branches;
next	1.7;

1.7
date	96.01.20.17.13.10;	author rowlands;	state Exp;
branches;
next	1.6;

1.6
date	95.06.16.10.01.27;	author rowlands;	state Exp;
branches
	1.6.1.0
	1.6.2.0
	1.6.3.0;
next	1.5;

1.5
date	95.06.16.06.29.49;	author rowlands;	state Exp;
branches;
next	1.4;

1.4
date	95.04.06.04.29.39;	author rowlands;	state Exp;
branches
	1.4.1.0
	1.4.2.0
	1.4.3.0;
next	1.3;

1.3
date	95.04.06.03.32.04;	author rowlands;	state Exp;
branches;
next	1.2;

1.2
date	95.04.06.02.07.35;	author rowlands;	state Exp;
branches;
next	1.1;

1.1
date	95.04.06.02.06.11;	author rowlands;	state Exp;
branches;
next	;

1.4.1.0
date	95.05.25.03.35.25;	author rowlands;	state Exp;
branches;
next	1.4.1.1;

1.4.1.1
date	95.06.11.23.26.23;	author rowlands;	state Exp;
branches;
next	1.4.1.2;

1.4.1.2
date	95.06.12.00.54.04;	author rowlands;	state Exp;
branches;
next	1.4.1.3;

1.4.1.3
date	95.06.14.03.03.08;	author rowlands;	state Exp;
branches;
next	1.4.1.4;

1.4.1.4
date	95.06.15.18.18.49;	author rowlands;	state Exp;
branches;
next	1.4.1.5;

1.4.1.5
date	95.06.16.02.04.33;	author rowlands;	state Exp;
branches;
next	1.4.1.6;

1.4.1.6
date	95.06.16.02.41.51;	author rowlands;	state Exp;
branches;
next	;

1.4.2.0
date	95.06.16.03.35.35;	author rowlands;	state Exp;
branches;
next	1.4.2.1;

1.4.2.1
date	95.06.16.03.46.42;	author rowlands;	state Exp;
branches;
next	1.4.2.2;

1.4.2.2
date	95.06.16.04.45.49;	author rowlands;	state Exp;
branches;
next	1.4.2.3;

1.4.2.3
date	95.06.16.06.25.24;	author rowlands;	state Exp;
branches;
next	;

1.4.3.0
date	95.06.16.08.19.14;	author rowlands;	state Exp;
branches;
next	1.4.3.1;

1.4.3.1
date	95.06.16.08.25.11;	author rowlands;	state Exp;
branches;
next	1.4.3.2;

1.4.3.2
date	95.06.16.09.57.51;	author rowlands;	state Exp;
branches;
next	;

1.6.1.0
date	95.11.06.04.11.21;	author rowlands;	state Exp;
branches;
next	1.6.1.1;

1.6.1.1
date	95.11.06.04.12.25;	author rowlands;	state Exp;
branches;
next	;

1.6.2.0
date	95.11.06.04.16.42;	author rowlands;	state Exp;
branches;
next	1.6.2.1;

1.6.2.1
date	95.11.06.04.19.12;	author rowlands;	state Exp;
branches;
next	;

1.6.3.0
date	95.11.06.04.22.34;	author rowlands;	state Exp;
branches;
next	1.6.3.1;

1.6.3.1
date	96.01.19.04.40.26;	author rowlands;	state Exp;
branches;
next	;


desc
@MPEG-2 public C encoder
@


1.9
log
@Release following Munich meeting
@
text
@/**********************************************************************
 * ISO MPEG Audio Subgroup Software Simulation Group (1996)
 * ISO 13818-3 MPEG-2 Audio Multichannel Encoder
 *
 * $Id: encode.c 1.8 1996/02/12 05:51:17 rowlands Exp $
 *
 * $Log: encode.c $
 * Revision 1.6.2.1  1995/11/06  04:19:12  rowlands
 * Received from Uwe Felderhoff (IRT)
 *
 * Revision 1.8  1995/08/14  07:53:28  tenkate
 * ML-LSF added Warner ten Kate 7/8/95 (Philips)
 * variables "alloc" and "sblimit" changed into "allocml" and
 * "mlsblimit" where appropriate.
 * sample loops adapted to 12 or 6 depending on full or half fs.
 * II_a_bit_allocation separate summing for ML.
 *
 * Revision 1.7  1995/07/31  07:48:55  tenkate
 * addition of phantom coding, in void matricing(), 25/07/95 WtK
 *
 * Revision 1.4.3.1  1995/06/16  08:25:11  rowlands
 * Input from Sang Wook Kim (Samsung AIT)
 *
 * Revision 1.4.2.1  1995/06/16  03:46:42  rowlands
 * Input from Susanne Ritscher (IRT)
 *
 * Revision 1.4.1.6  1995/06/16  02:41:51  rowlands
 * Added dematrix procedure 2, corrected dematrixing values.
 *
 * Added support for dematrix procedure 2, without predistortion.
 * To implement predistortion will require a delay in the encoder
 * to be able to calculate the predistorted filtered surround signal
 * subband samples.
 *
 * Modified procedure matricing() to reuse the compatible stereo
 * channel signals computed by matricing_fft(). This was needed to
 * avoid calculating the low-pass-filtered surround signal in the
 * subband domain. The main function of procedure matricing() now
 * is to weight the multichannels. These channels are unweighted
 * prior to this for the benefit of the psycho model.
 *
 * Corrected weighting values for dematrixing procedures.
 * Deleted matrixing on multilingual channels.
 * In the quantization procedures, made quantizing to zero bits
 * a special case to skip some operations on undefined values.
 *
 **********************************************************************/

/**********************************************************************
 *   date   programmers         comment                               *
 * 3/01/91  Douglas Wong,       start of version 1.1 records          *
 *          Davis Pan                                                 *
 * 3/06/91  Douglas Wong        rename: setup.h to endef.h            *
 *                                      efilter to enfilter           *
 *                                      ewindow to enwindow           *
 *                              integrated "quantizer", "scalefactor",*
 *                              and "transmission" files              *
 *                              update routine "window_subband"       *
 * 3/31/91  Bill Aspromonte     replaced read_filter by               *
 *                              create_an_filter                      *
 * 5/10/91  W. Joseph Carter    Ported to Macintosh and Unix.         *
 *                              Incorporated Jean-Georges Fritsch's   *
 *                              "bitstream.c" package.                *
 *                              Incorporated Bill Aspromonte's        *
 *                              filterbank coefficient matrix         *
 *                              calculation routines and added        *
 *                              roundoff to coincide with specs.      *
 *                              Modified to strictly adhere to        *
 *                              encoded bitstream specs, including    *
 *                              "Berlin changes".                     *
 *                              Modified PCM sound file handling to   *
 *                              process all incoming samples and fill *
 *                              out last encoded frame with zeros     *
 *                              (silence) if needed.                  *
 *                              Located and fixed numerous software   *
 *                              bugs and table data errors.           *
 * 19jun91  dpwe (Aware)        moved "alloc_*" reader to common.c    *
 *                              Globals sblimit, alloc replaced by new*
 *                              struct 'frame_params' passed as arg.  *
 *                              Added JOINT STEREO coding, layers I,II*
 *                              Affects: *_bit_allocation,            *
 *                              subband_quantization, encode_bit_alloc*
 *                              sample_encoding                       *
 * 6/10/91  Earle Jennings      modified II_subband_quantization to   *
 *                              resolve type cast problem for MS_DOS  *
 * 6/11/91  Earle Jennings      modified to avoid overflow on MS_DOS  *
 *                              in routine filter_subband             *
 * 7/10/91  Earle Jennings      port to MsDos from MacIntosh version  *
 * 8/ 8/91  Jens Spille         Change for MS-C6.00                   *
 *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           *
 *          Don H. Lee,                                               *
 *          Peter W. Farrett                                          *
 *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   *
 *                              newly introduced function encode_CRC  *
 *11/ 8/91  Kathy Wang          Documentation of code                 *
 *                              All variablenames are referred to     *
 *                              with surrounding pound (#) signs      *
 * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   *
 *                              important fixes involved changing     *
 *                              16-bit ints to long or unsigned in    *
 *                              bit alloc routines for quant of 65535 *
 *                              and passing proper function args.     *
 *                              Removed "Other Joint Stereo" option   *
 *                              and made bitrate be total channel     *
 *                              bitrate, irrespective of the mode.    *
 *                              Fixed many small bugs & reorganized.  *
 * 92-08-11 Soren H. Nielsen    Fixed bug: allocation of space in the *
 *                              bitstream for the CRC-word. Fixed     *
 *                              reading of window from file.          *
 * 92-11-06 Soren H. Nielsen	Fixed scalefactor calculation.        *
 **********************************************************************
 *                                                                    *
 *                                                                    *
 *  MPEG/audio Phase 2 coding/decoding multichannel                   *
 *                                                                    *
 *  7/27/93        Susanne Ritscher,  IRT Munich                      *
 *  8/10/93        changed matricing to 7 channels                    *
 *	           added void matricing_fft                           *
 *  8/12/93        added int required_bits,                           *
 *                       int max_alloc                                *
 *                 implemented the new mc_header (third working draft)*
 *  8/13/93        added channel-switching in required_bits and       *
 *                 II_subband_quantisation, II_encode_scale,          *
 *                 II_encode_bit_alloc, II_encode_sample,             *
 *                 encode_info                                        *
 *                 all channels normalized                            *
 *  9/20/93        channel-switching is only performed at a           *
 *                 certain limit of TC_ALLOC dB, which is included    *
 *                 in encoder.h                                       *
 *  1/04/94        get out some rubbish                               *
 *                                                                    *
 * 01/05/94        implemented the Committee Draft header             *
 *                                                                    *
 * 01/12/94        changed matricing procedure according to           *
 *                 Committee Draft                                    *
 *                                                                    *
 *  Version 1.0                                                       *
 *                                                                    *
 *  07/12/94       Susanne Ritscher,  IRT Munich                      *
 *                 Tel: +49 89 32399 458                              *
 *                 Fax: +49 89 32399 415                              *
 *                                                                    *
 *  Version 1.1                                                       *
 *                                                                    *
 *  02/23/95	   Susanne Ritscher,  IRT Munich                      *
 *                 corrected some bugs                                *
 *                 extension bitstream is working                     *
 *                                                                    *
 **********************************************************************/
/**********************************************************************
 *                                                                    *
 *  06/06/95       Yeon Bae Thomas Kim, Samsung AIT                   *
 *                 ancillary data is working                          *
 *                                                                    *
 *  06/06/95       Sang Wook Kim, Samsung AIT                         *
 *                 corrected some bugs                                *
 *                                                                    *
 **********************************************************************/
#define VERY_FAST_FILTER  1	/* JMZ 08/03/1995 FILTER */


#include "common.h"
#include "encoder.h"
 
/*=======================================================================\
|                                                                       |
| This segment contains all the core routines of the encoder,           |
| except for the psychoacoustic models.                                 |
|                                                                       |
| The user can select either one of the two psychoacoustic              |
| models. Model I is a simple tonal and noise masking threshold         |
| generator, and Model II is a more sophisticated cochlear masking      |
| threshold generator. Model I is recommended for lower complexity      |
| applications whereas Model II gives better subjective quality at low  |
| bit rates.                                                            |
|                                                                       |
| Layers I and II of mono, stereo, and joint stereo modes are supported.|
| Routines associated with a given layer are prefixed by "I_" for layer |
| 1 and "II_" for layer 2.                                              |
\=======================================================================*/
 
/************************************************************************/
/*
/* read_samples()
/*
/* PURPOSE:  reads the PCM samples from a file to the buffer
/*
/*  SEMANTICS:
/* Reads #samples_read# number of shorts from #musicin# filepointer
/* into #sample_buffer[]#.  Returns the number of samples read.
/*
/************************************************************************/

unsigned long read_samples(FILE *musicin, long int *sample_buffer, long unsigned int num_samples, long unsigned int frame_size, int *byte_per_sample, int *aiff)
{
unsigned long samples_read;
static unsigned long samples_to_read;
static char init = TRUE;
short pcm_sample_buffer[6912];        /*for correct reading of pcm-data*/
int i;

   if (init) {
        samples_to_read = num_samples;
        init = FALSE;
   }
   if (samples_to_read >= frame_size)
        samples_read = frame_size;
   else
		  samples_read = samples_to_read;

	if((*aiff==1) &&(*byte_per_sample !=2)){
	 
            if ((samples_read =
		  fread(sample_buffer, *byte_per_sample, (int)samples_read, musicin)) == 0)
		  if (verbosity >= 2) printf("Hit end of audio data\n");
	   
	}
	else{
	 if ((samples_read =
		  fread(pcm_sample_buffer, sizeof(short), (int)samples_read, musicin)) == 0)
		  if (verbosity >= 2) printf("Hit end of audio data\n");
            for(i = 0; i < 6912; ++i) sample_buffer[i] = pcm_sample_buffer[i];
        }

   samples_to_read -= samples_read;
   if (samples_read < frame_size && samples_read > 0) {
        if (verbosity >= 2) printf("Insufficient PCM input for one frame - fillout with zeros\n");
        for (; samples_read < frame_size; sample_buffer[samples_read++] = 0);
        samples_to_read = 0;
   }
   return(samples_read);
}

/************************************************************************/
/*
/* get_audio()
/*
/* PURPOSE:  reads a frame of audio data from a file to the buffer,
/*   aligns the data for future processing, and separates the
/*   left and right channels
/*
/*  SEMANTICS:
/* Calls read_samples() to read a frame of audio data from filepointer
/* #musicin# to #insampl[]#.  The data is shifted to make sure the data
/* is centered for the 1024pt window to be used by the psychoacoustic model,
/* and to compensate for the 256 sample delay from the filter bank. For
/* stereo, the channels are also demultiplexed into #buffer[0][]# and
/* #buffer[1][]#
/*
/* 21/03/1995 JMZ Multimode adaptations
/************************************************************************/
 
unsigned long
get_audio(
	FILE *musicin,
	double (*buffer)[1152],
	long unsigned int num_samples,
	int stereo,
	IFF_AIFF *aiff_ptr,
	int stereomc,
	frame_params *fr_ps,
	int *aiff,
	int *byte_per_sample,
	double		(*buffer_matr)[1152],
	double		dematrix2_filter_state[3]
) {
	int k, j, i;
	long insamp[6912];
	unsigned long samples_read;
	int lay;
        int lfe;
	layer *info = fr_ps->header;
	
	lay = info->lay;
        lfe = info->lfe;

if (lay == 1)
	{
	if(stereo == 2)
		{ /* layer 1, stereo */
		samples_read = read_samples(musicin, insamp, num_samples,
			(unsigned long) 768, byte_per_sample, aiff);
		for(j=0;j<448;j++) 
			{
			if(j<64) 
				{
				buffer[0][j] = buffer[0][j+384];
				buffer[1][j] = buffer[1][j+384];
				buffer[2][j] = 0;
				buffer[3][j] = 0;
				buffer[4][j] = 0;
				}
			else 
				{
				buffer[0][j] = insamp[2*j-128];
				buffer[1][j] = insamp[2*j-127];
				buffer[2][j] = 0;
				buffer[3][j] = 0;
				buffer[4][j] = 0;
				}
			}
		}
	else 
		{ /* layer 1, mono */
		samples_read = read_samples(musicin, insamp, num_samples,
			(unsigned long) 384, byte_per_sample, aiff);
		for(j=0;j<448;j++)
			{
			if(j<64) 
				{
				buffer[0][j] = buffer[0][j+384];
				buffer[1][j] = 0;
				buffer[2][j] = 0;
				buffer[3][j] = 0;
				buffer[4][j] = 0;
				}
			else 
				{
				buffer[0][j] = insamp[j-64];
				buffer[1][j] = 0;
				buffer[2][j] = 0;
				buffer[3][j] = 0;
				buffer[4][j] = 0;
				}
			}
		}
	}
else 
	{
	if( *aiff == 1)
		{
                if(lfe)
                  k = 6;
                else
                  k = 5;
		if(((stereo + stereomc) == 5) && (aiff_ptr->numChannels == k))
			{
			/* 3/2 configuration */
			info->center = 1; /* will be set to 3 subsequently if (phantom_c==1) */
			info->surround = 2;
                        
			samples_read = read_samples(musicin, insamp, num_samples,
				(unsigned long) (k*1152), byte_per_sample, aiff);
			for(j=0; j<1152; j++) 
				{
				buffer[0][j] = insamp[k*j];
				buffer[1][j] = insamp[k*j+1];
				buffer[2][j] = insamp[k*j+2];
				buffer[3][j] = insamp[k*j+3];
				buffer[4][j] = insamp[k*j+4];
                                if(lfe)
				  buffer[5][j] = insamp[k*j+5];
				}
			}
		else if(( stereo == 0) && ( aiff_ptr->numChannels == k))
			{
			/* 3/2 configuration with L,R channels muted */
			info->center = 1;
			info->surround = 2;
                        
			samples_read = read_samples(musicin, insamp, num_samples,
				(unsigned long) (k*1152),byte_per_sample, aiff);
			for(j=0; j<1152; j++) 
				{
				buffer[0][j] = 0;
				buffer[1][j] = 0;
				buffer[2][j] = insamp[k*j+2];
				buffer[3][j] = insamp[k*j+3];
				buffer[4][j] = insamp[k*j+4];
                                if(lfe)
                                  buffer[5][j] = insamp[6*j+5];   
				}
			}
		else if(( stereomc == 0) && ( aiff_ptr->numChannels == k))
			{
			/* 3/2 configuration with C,Ls,Rs channels muted */
			info->center = 0;
			info->surround = 0;
                        
			samples_read = read_samples(musicin, insamp, num_samples,
				(unsigned long) (k*1152), byte_per_sample, aiff);
			for(j=0; j<1152; j++) 
				{
				buffer[0][j] = insamp[k*j];
				buffer[1][j] = insamp[k*j+1];
				buffer[2][j] = 0;
				buffer[3][j] = 0;
				buffer[4][j] = 0;
                                if(lfe)
                                  buffer[5][j] = insamp[6*j+2];
				}
			}
		else if(aiff_ptr->numChannels == 4)
			{

			samples_read = read_samples(musicin, insamp, num_samples,
				(unsigned long) 1152*4, byte_per_sample, aiff);
			for(j=0; j<1152; j++) 
				{
				buffer[0][j] = insamp[4*j];
				buffer[1][j] = insamp[4*j+1];
				buffer[2][j] = insamp[4*j+2];
				buffer[3][j] = insamp[4*j+3];
				buffer[4][j] = 0;
				}
			}
		else if(aiff_ptr->numChannels == 3)
			{

			samples_read = read_samples(musicin, insamp, num_samples,
				(unsigned long) 1152*3, byte_per_sample, aiff);
			for(j=0; j<1152; j++) 
				{
				buffer[0][j] = insamp[3*j];
				buffer[1][j] = insamp[3*j+1];
				buffer[2][j] = insamp[3*j+2];
				buffer[3][j] = 0;
				buffer[4][j] = 0;
				}
			}
		else if(aiff_ptr->numChannels == 2)
			{

			samples_read = read_samples(musicin, insamp, num_samples,
				(unsigned long) 1152*2, byte_per_sample, aiff);
			for(j=0; j<1152; j++) 
				{
				buffer[0][j] = insamp[2*j];
				buffer[1][j] = insamp[2*j+1];
				buffer[2][j] = 0;
				buffer[3][j] = 0;
				buffer[4][j] = 0;
				}
			}
		}
	else 
		{  /* layerII, stereo */
		if( stereo == 2)
			{
			samples_read = read_samples(musicin, insamp, num_samples,
				(unsigned long) ((k-3)*1152), byte_per_sample, aiff);
			for( j = 0; j < 1152; j++)
				{ /* fixed bug 28.6.93 S.R. */
				buffer[0][j] = insamp[(k-3)*j];
				buffer[1][j] = insamp[(k-3)*j+1];
				buffer[2][j] = 0;
				buffer[3][j] = 0;
				buffer[4][j] = 0;
                                if(lfe)
                                  buffer[1][j] = insamp[3*j+2]; /* ########### */
				}
			}

		else
			{ /* layer 2 (or 3), mono */
			samples_read = read_samples(musicin, insamp, num_samples,
				(unsigned long) 1152, byte_per_sample, aiff);
			for(j=0;j<1152;j++)
				{
				buffer[0][j] = insamp[j];
				buffer[1][j] = 0;
				buffer[2][j] = 0;
				buffer[3][j] = 0;
				buffer[4][j] = 0;
				}        
			}
		}
	}

	/*
	 * If LFE is not enabled, "buffer" contains:
	 *	buffer[0]	L
	 *	buffer[1]	R
	 *	buffer[2]	C
	 *	buffer[3]	Ls
	 *	buffer[4]	Rs
	 *
	 * If LFE is enabled, "buffer" contains:
	 *	buffer[0]	L
	 *	buffer[1]	R
	 *	buffer[2]	C
	 *	buffer[3]	LFE
	 *	buffer[4]	Ls
	 *	buffer[5]	Rs
	 */

	matricing_fft(buffer, buffer_matr, fr_ps, dematrix2_filter_state);

	/*
	 * After matrixing, "buffer_matr" contains:
	 *	buffer_matr[0]	Lo
	 *	buffer_matr[1]	Ro
	 *	buffer_matr[2]	C
	 *	buffer_matr[3]	Ls
	 *	buffer_matr[4]	Rs
	 *	buffer_matr[5]	L
	 *	buffer_matr[6]	R
	 */

return(samples_read);
}

/*************************************************************************
/*
/* matricing()
/*
/* The five-channel signal must be matricied to guarantee
/* the compatibility to the stereo-decoder.
/* There must be something of the surround information in the
/* two front channels. In a five-channel decoder there will
/* be a dematricing.
/* There must be 7 channels for channel switching 8/10/93, SR
/* 
/* Channel 5 and 6 are the not matriced signals L and R
/*
/* If phantom coding is used the high-frequency part of the
/* center signal is matrixed to left and right.
/* 27/07/95 WtK
/*                                                                         */
/***************************************************************************/

void matricing_old(double (*sb_sample)[3][12][32], frame_params *fr_ps)
                                     	/* 08/03/1995 JMZ Multilingual */
                    

{
  double matr1;   /* factor for center */
  double matr2;   /* factor for surrounds */
  double matr3;   /* factor for surrounds */
  int i, j, k, l;
  
  layer *info = fr_ps->header;
  switch(info->matrix)
  {
      /* Changed the factors according to Draft International Standard   */
      
      case 0: matr1 = 0.411865234375;        /* normalizing */
	      matr2 = 0.7060546875;          /* matricing   */
	      matr3 = matr2;
	      break;
      case 1: matr1 = 1/(1.5 + 0.5*sqrt(2)); /* normalizing */
              matr2 = 0.7060546875;          /* matricing C */ 
	      matr3 = 0.5;                   /* matricing Ls, Rs */
	      break;
      case 2: matr1 = 0.411865234375;  
	      matr2 = 0.7060546875;
	      matr3 = matr2;
	      break;
      case 3: matr1 = 1.0;
              matr2 = 1.0;
	      matr3 = matr2;
	      break;
  }


	for( j = 0; j < 3; ++j)
	{
	    for(l = 0; l < 12; l ++)
	    {
		for(k = 0; k < SBLIMIT; k ++)
		{
	 	 sb_sample[5][j][l][k] =  sb_sample[0][j][l][k] * matr1;
		 sb_sample[6][j][l][k] =  sb_sample[1][j][l][k] * matr1;
		
		 sb_sample[2][j][l][k] = sb_sample[2][j][l][k] * matr1 * matr2; 
		 
		 if(info->matrix != 1)
		 {
		    sb_sample[3][j][l][k] = sb_sample[3][j][l][k] * matr1 * matr2; 
		    sb_sample[4][j][l][k] = sb_sample[4][j][l][k] * matr1 * matr2; 
		 }
		 else
		 {
		    sb_sample[3][j][l][k] = sb_sample[3][j][l][k] * matr1 * matr3; 
		    sb_sample[4][j][l][k] = sb_sample[4][j][l][k] * matr1 * matr3; 
		 }
		
		 if(info->matrix == 0 || info->matrix == 1)
		 {
		    sb_sample[0][j][l][k] = sb_sample[5][j][l][k] + sb_sample[2][j][l][k] + sb_sample[3][j][l][k];
		    sb_sample[1][j][l][k] = sb_sample[6][j][l][k] + sb_sample[2][j][l][k] + sb_sample[4][j][l][k];
		 }   
		}
	    }
	}
 }
 
 /*******************************************************************/
 /* JMZ 08/03/1995 MULTILINGUAL */
 
void
matricing(
	double		(*sb_sample)[3][12][32],	/* 24/02/1995 JMZ Multilingual */
	frame_params	*fr_ps
) {
  double matrNorm;	/* factor for normalizing JMZ */
  double matrC,matrPC;	/* weighting factor for C, Phantom C */
  double matrLsRs;	/* weighting factor for Ls, Rs */
  register double val;
  int i, j, k, l, n_ml_ch;
  
  layer *info = fr_ps->header;
  n_ml_ch = info->multiling_ch;

  switch(info->matrix)
  {
      /* Changed the factors according to International Standard */
      
	case 0:
	case 2:
	      matrNorm	= 1 / (1 + sqrt(2.0));
	      matrC	= 1 / sqrt(2.0);
	      matrPC	= 1;
	      matrLsRs	= 1 / sqrt(2.0);
	      break;
	case 1:
	      matrNorm	= 1 / (1.5 + 0.5*sqrt(2.0));
	      matrC	= 1 / sqrt(2.0);
	      matrPC	= 1;
	      matrLsRs	= 0.5;
	      break;
	case 3:
	      matrNorm	= 1;
	      matrC	= 1;
	      matrPC	= 1 / sqrt(2.0);
	      matrLsRs	= 1;
	      break;
  }


for( j = 0; j < 3; ++j)
{
	for(l = 0; l < 12; l ++)
	{
		for(k = 0; k < SBLIMIT; k ++)
		{
			double	compatibleLeft;
			double	compatibleRight;

			compatibleLeft	= sb_sample[5][j][l][k];
			compatibleRight	= sb_sample[6][j][l][k];

			sb_sample[5][j][l][k] = sb_sample[0][j][l][k] * matrNorm;
			sb_sample[6][j][l][k] = sb_sample[1][j][l][k] * matrNorm;
			sb_sample[2][j][l][k] = sb_sample[2][j][l][k] * matrNorm * matrC;
			sb_sample[3][j][l][k] = sb_sample[3][j][l][k] * matrNorm * matrLsRs;
			sb_sample[4][j][l][k] = sb_sample[4][j][l][k] * matrNorm * matrLsRs;
/* #if	defined(DIFF_1) || defined(DIFF_3) */	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */ /* ########## */
/*			sb_sample[0][j][l][k] = compatibleLeft; */
/*			sb_sample[1][j][l][k] = compatibleRight; */
/* #elif	defined(DIFF_2) */				/* =========================== */

			sb_sample[0][j][l][k] = compatibleLeft + sb_sample[2][j][l][k] + sb_sample[5][j][l][k];
			sb_sample[1][j][l][k] = compatibleRight + sb_sample[2][j][l][k] + sb_sample[6][j][l][k];
/* #endif */						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
		}

		if (fr_ps->phantom_c)            /* 27/07/95 WtK */
                {
                if (info->matrix==3)
		  for(k = 12; k < SBLIMIT; k ++)
		  {
			val = matrPC * sb_sample[2][j][l][k];
			sb_sample[0][j][l][k] += val;
			sb_sample[1][j][l][k] += val;
			sb_sample[2][j][l][k] = 0;
		  }
                else 
		  for(k = 12; k < SBLIMIT; k ++)
		  {
			val = matrPC * sb_sample[2][j][l][k];
			sb_sample[5][j][l][k] += val;
			sb_sample[6][j][l][k] += val;
			sb_sample[2][j][l][k] = 0;
		  }
                }
	}
}
}
 /* JMZ 08/03/1995 MULTILINGUAL */
 /*******************************************************************/


/**************************************************************/
/* routines for dematrix2_filter */


static double	dematrix2_filter_coeff[3][4] = {
	/* a0    b0     b1   b2 */
	{ 295, 2048, -1394, 521},	/* 44.1 kHz */
	{ 294, 2048, -1388, 520},	/* 48 kHz */
	{ 486, 2048,  -471, 370}	/* 32 kHz */
};

/*
 * init_dematrix2_filter_state()
 *
 *	This routine initializes the state vector of the dematrix
 *	procedure 2 filter to zero. The state should be initialized:
 *	- at startup
 *	- whenever the previous frame did not use dematrix procedure 2
 *	- whenever the sample rate changes
 */
void
init_dematrix2_filter_state(
	double	state[3]
) {
	state[0] = 0.0;
	state[1] = 0.0;
	state[2] = 0.0;
}

/*
 * dematrix2_filter()
 *	This routine accepts one sample of the mono surround signal,
 *	and produces one sample of the filtered signal for dematrix
 *	procedure 2.
 */
double
dematrix2_filter(
	frame_params *fr_ps,
	double	state[3],
	double	sample
) {
	int	sfreq = fr_ps->header->sampling_frequency;
	double	filteredSample;

	state[2] = state[1];
	state[1] = state[0];

	state[0] = (
		sample -
		dematrix2_filter_coeff[sfreq][2] * state[1] -
		dematrix2_filter_coeff[sfreq][3] * state[2]
	) / dematrix2_filter_coeff[sfreq][1];

	filteredSample = dematrix2_filter_coeff[sfreq][0] * (
		state[0] + 2 * state[1] + state[2]
	);

	return(filteredSample);
}


/*************************************************************************
/*
/* matricing_fft()
/*
/* To get the best results in psychoacoustics there must be both,
/* the matriced and the not matriced signal. This matricing
/* may be in full bandwith.
 *
 * If LFE is not enabled, "buffer" contains:
 *	buffer[0]	L
 *	buffer[1]	R
 *	buffer[2]	C
 *	buffer[3]	Ls
 *	buffer[4]	Rs
 *
 * If LFE is enabled, "buffer" contains:
 *	buffer[0]	L
 *	buffer[1]	R
 *	buffer[2]	C
 *	buffer[3]	LFE
 *	buffer[4]	Ls
 *	buffer[5]	Rs
 *
 * This function matrixes the original audio samples to pass to the
 * psychoacoustic model. The model considers the matrixed and non-
 * matrixed versions of the signal, so both are retained here.
 * 
 * On exit, buffer_matr[0] to buffer_matr[6] contain the channels
 * Lo, Ro, C, Ls, Rs, L, R, respectively.
 *
 **************************************************************************/

void
matricing_fft(
	double		(*buffer)[1152],
	double		(*buffer_matr)[1152],
	frame_params	*fr_ps,
	double		dematrix2_filter_state[3]
) {
  double matrNorm;	/* factor for normalizing JMZ */
  double matrC;		/* weighting factor for C */
  double matrLsRs;	/* weighting factor for Ls, Rs */
  int i, j, k, l;
  int lfe;
  double dummy;
  
  layer *info = fr_ps->header;
  lfe = info->lfe;

  switch(info->matrix)
  {
      /* Changed the factors according to International Standard */
      
	case 0:
	case 2:
	      matrNorm	= 1 / (1 + sqrt(2.0));
	      matrC	= 1 / sqrt(2.0);
	      matrLsRs	= 1 / sqrt(2.0);
	      break;
	case 1:
	      matrNorm	= 1 / (1.5 + 0.5*sqrt(2.0));
	      matrC	= 1 / sqrt(2.0);
	      matrLsRs	= 0.5;
	      break;
	case 3:
	      matrNorm	= 1;
	      matrC	= 1;
	      matrLsRs	= 1;
	      break;
  }

/* no normalizing until now!!!! 01/14/94, SR */
   for(i = 0; i < 1152; ++i)
   {
     buffer_matr[2][i]	= buffer[2][i];
     buffer_matr[3][i]	= buffer[3+lfe][i];
     buffer_matr[4][i]	= buffer[4+lfe][i];
     buffer_matr[5][i]	= buffer[0][i];
     buffer_matr[6][i]	= buffer[1][i];

     switch (info->matrix) {
     case 0:
     case 1: {
	buffer_matr[0][i] = matrNorm*(buffer[0][i] + matrC*buffer[2][i] + matrLsRs*buffer[3+lfe][i]);
	buffer_matr[1][i] = matrNorm*(buffer[1][i] + matrC*buffer[2][i] + matrLsRs*buffer[4+lfe][i]);
	break;
      }
     case 2: {
	double	mono_surround;
	double	filtered_surround;

/* add lfe to calculate "mono_surround"    UF 26/10/95 */
	mono_surround = (buffer[3+lfe][i] + buffer[4+lfe][i]) / 2.0;
	filtered_surround = dematrix2_filter(fr_ps, dematrix2_filter_state, mono_surround);
        buffer_matr[0][i] = matrNorm*(buffer[0][i] + matrC*buffer[2][i] - matrLsRs*filtered_surround);
	buffer_matr[1][i] = matrNorm*(buffer[1][i] + matrC*buffer[2][i] + matrLsRs*filtered_surround);
	break;
      }
     case 3: {
	buffer_matr[0][i] = buffer[0][i];
	buffer_matr[1][i] = buffer[1][i];
	break;
      }
     }
   }
}



/************************************************************************/
/*
/* read_ana_window()
/*
/* PURPOSE:  Reads encoder window file "enwindow" into array #ana_win#
/*
/************************************************************************/
 
void read_ana_window(double *ana_win)
       /*far*/                   
{
    int i,j[4];
    FILE *fp;
    double f[4];
    char t[150];
 
    if (!(fp = OpenTableFile("enwindow") ) ) {
       printf("Please check analysis window table 'enwindow'\n");
       exit(1);
    }
    for (i=0;i<512;i+=4) {
       fgets(t, 80, fp); /* changed from 150, 92-08-11 shn */
       sscanf(t,"C[%d] = %lf C[%d] = %lf C[%d] = %lf C[%d] = %lf\n",
              j, f,j+1,f+1,j+2,f+2,j+3,f+3);
       if (i==j[0]) {
          ana_win[i] = f[0];
          ana_win[i+1] = f[1];
          ana_win[i+2] = f[2];
          ana_win[i+3] = f[3];
       }
       else {
          printf("Check index in analysis window table\n");
          exit(1);
       }
       fgets(t,80,fp); /* changed from 150, 92-08-11 shn */
    }
    fclose(fp);
}

/************************************************************************/
/*
/* window_subband()
/*
/* PURPOSE:  Overlapping window on PCM samples
/*
/* SEMANTICS:
/* 32 16-bit pcm samples are scaled to fractional 2's complement and
/* concatenated to the end of the window buffer #x#. The updated window
/* buffer #x# is then windowed by the analysis window #c# to produce the
/* windowed sample #z#
/*
/************************************************************************/
 
void
window_subband(
	double **buffer,
	double *z,
	int k
) {
typedef double XX[14][HAN_SIZE];	/* 08/03/1995 JMZ Multilingual */
static XX *x;
int i, j;
static off[14]= {0,0,0,0,0,0,0,0,0,0,0,0,0,0};/* 08/03/1995 JMZ Multilingual */
static char init = 0;
static double *c;
 
   if (!init) {
      c = (double *) mem_alloc(sizeof(double) * HAN_SIZE, "window");
      read_ana_window(c);
      x = (XX *) mem_alloc(sizeof(XX),"x");
      for (i = 0; i < 14; i++)
         for (j = 0; j < HAN_SIZE; j++)
               (*x)[i][j] = 0;
      init = 1;
   }
 
   for (i=0;i<32;i++) (*x)[k][31-i+off[k]] = (double) *(*buffer)++/SCALE;
   for (i=0;i<HAN_SIZE;i++) z[i] = (*x)[k][(i+off[k])&HAN_SIZE-1] * c[i];
   off[k] += 480; /*offset is modulo (HAN_SIZE-1)*/
   off[k] &= HAN_SIZE-1;

}
 
/************************************************************************/
/*
/* create_ana_filter()
/*
/* PURPOSE:  Calculates the analysis filter bank coefficients
/*
/* SEMANTICS:
/* Calculates the analysis filterbank coefficients and rounds to the
/* 9th decimal place accuracy of the filterbank tables in the ISO
/* document.  The coefficients are stored in #filter#
/*
/************************************************************************/
 
void create_ana_filter(double (*filter)[64])
       /*far*/                     
{
   register int i,k;
 
   for (i = 0; i < 32; i++)
      for (k = 0; k < 64; k++) {
          if ((filter[i][k] = 1e9*cos((double)((2*i+1)*(16-k)*PI64))) >= 0)
             modf(filter[i][k]+0.5, &filter[i][k]);
          else
             modf(filter[i][k]-0.5, &filter[i][k]);
          filter[i][k] *= 1e-9;
   }
}

/************************************************************************/
/*
/* filter_subband()
/*
/* PURPOSE:  Calculates the analysis filter bank coefficients
/*
/* SEMANTICS:
/*      The windowed samples #z# is filtered by the digital filter matrix #m#
/* to produce the subband samples #s#. This done by first selectively
/* picking out values from the windowed samples, and then multiplying
/* them by the filter matrix, producing 32 subband samples.
/*
/************************************************************************/
 
void filter_subband_old(double *z, double *s)
       /*far*/                         
{
   double y[64];
   int i,j, k;
static char init = 0;
   typedef double MM[SBLIMIT][64];
static MM /*far*/ *m;
   double sum1, sum2;
   
#ifdef MS_DOS
   long    SIZE_OF_MM;
   SIZE_OF_MM      = SBLIMIT*64;
   SIZE_OF_MM      *= 8;
   if (!init) {
       m = (MM /*far*/ *) mem_alloc(SIZE_OF_MM, "filter");
       create_ana_filter(*m);
       init = 1;
   }
#else
   if (!init) {
       m = (MM /*far*/ *) mem_alloc(sizeof(MM), "filter");
       create_ana_filter(*m);
       init = 1;
   }
#endif
   /* Window */
   for (i=0; i<64; i++)
   {
      for (k=0, sum1 = 0.0; k<8; k++)
         sum1 += z[i+64*k];
      y[i] = sum1;
   }

   /* Filter */
   for (i=0;i<SBLIMIT;i++)
   {
       for (k=0, sum1=0.0 ;k<64;k++)
          sum1 += (*m)[i][k] * y[k];
       s[i] = sum1;
   }

/*   for (i=0;i<64;i++) for (j=0, y[i] = 0;j<8;j++) y[i] += z[i+64*j];*/
/*   for (i=0;i<SBLIMIT;i++)*/
/*       for (j=0, s[i]= 0;j<64;j++) s[i] += (*m)[i][j] * y[j];*/

}

/************************************************************************/
/* JMZ 08/03/1995 FILTER */

void filter_subband(double *z, double *s)
       /*far*/                         
{
   double y[64];
   int i,j, k;
static char init = 0;
   typedef double MM[SBLIMIT][64];
static MM /*far*/ *m;
   double sum1, sum2;
  
   if (!init) {
       m = (MM /*far*/ *) mem_alloc(sizeof(MM), "filter");
       create_ana_filter(*m);
       init = 1;
   }
   /* Window */
   for (i=0; i<64; i++)
   {
      for (k=0, sum1 = 0.0; k<8; k++)
         sum1 += z[i+64*k];
      y[i] = sum1;
   }

   /* Filter */
#if VERY_FAST_FILTER 
   for (i=0; i<SBLIMIT/2; i++)
   {
       for (k=0, sum1=0.0, sum2=0.0; k<16;)
       {
	sum1 += (*m)[i][k] * (y[k]+y[32-k]); 
	sum2 += (*m)[i][k+1] * (y[k+1]+y[31-k]); 
	sum2 += (*m)[i][k+33] * (y[k+33]-y[63-k]); 
	sum1 += (*m)[i][k+34] * (y[k+34]-y[62-k]); 
	k+=2;
       }
	sum1 += (*m)[i][16]*y[16] - (*m)[i][48]*y[48]; 

	s[i]    = sum1 + sum2;
	s[31-i] = sum1 - sum2;
   }
#else
   for (i=0;i<SBLIMIT;i++)
   {
       for (k=0, sum1=0.0 ;k<64;k++)
          sum1 += (*m)[i][k] * y[k];
       s[i] = sum1;
   }
#endif /*VERY_FAST_FILTER*/
}

/* JMZ 08/03/1995 FILTER */
/************************************************************************/

/************************************************************************/
/*
/* encode_info()
/* encode_infomc1() SR
/* encode_infomc2() SR
/*
/* PURPOSE:  Puts the syncword and header information on the output
/* bitstream.
/*
/************************************************************************/
 
void encode_info(frame_params *fr_ps, Bit_stream_struc *bs)
{
        layer *info = fr_ps->header;
 
        putbits(bs,0xfff,12);                    /* syncword 12 bits */
        put1bit(bs,info->version);               /* ID        1 bit  */
        putbits(bs,4-info->lay,2);               /* layer     2 bits */
        put1bit(bs,!info->error_protection);     /* bit set => no err prot */
        putbits(bs,info->bitrate_index,4);
        putbits(bs,info->sampling_frequency,2);
        put1bit(bs,info->padding);
        put1bit(bs,info->extension);             /* private_bit */
        putbits(bs,info->mode,2);
        putbits(bs,info->mode_ext,2);
        put1bit(bs,info->copyright);
        put1bit(bs,info->original);
        putbits(bs,info->emphasis,2);
}


void encode_infomc1(frame_params *fr_ps, Bit_stream_struc *bs)
{
        
        layer *info = fr_ps->header;
	
        
 
		  put1bit(bs,info->ext_bit_stream_present);
		  if(info->ext_bit_stream_present == 1) 
		    putbits(bs,info->n_ad_bytes, 8); 
		  putbits(bs,info->center, 2); 
		  putbits(bs,info->surround, 2);
		  put1bit(bs,info->lfe);
		  put1bit(bs,info->audio_mix);
		  putbits(bs,info->matrix, 2);
		  putbits(bs,info->multiling_ch, 3);
		  put1bit(bs,info->multiling_fs);
		  put1bit(bs,info->multiling_lay);
		  put1bit(bs,info->copy_ident_bit);
		  put1bit(bs,info->copy_ident_start);
}



void encode_infomc2(frame_params *fr_ps, Bit_stream_struc *bs)
{
    layer *info = fr_ps->header;
    int i, j;       
    
    
		  
		  put1bit(bs, info->tc_sbgr_select);
		  put1bit(bs, info->dyn_cross_on);
		  put1bit(bs, info->mc_prediction_on);
		  if(info->tc_sbgr_select == 1)
		    putbits(bs, info->tc_allocation, 3);
		  else
		  {
		    for(i = 0; i < 12; i++)
		         putbits(bs, info->tc_alloc[i], 3);
		  }

		  if(info->dyn_cross_on == 1)
		  {
		    put1bit(bs, info->dyn_cross_LR);
		    for(i = 0; i < 12; i++)
		    {
		        putbits(bs, info->dyn_cross[i], 4);
			if(info->surround == 3)
			    put1bit(bs, info->dyn_second_stereo[i]);
		    }	    
		  }

                  if(info->mc_prediction_on == 1)
		  {
		    fprintf(stderr, "WARNING! Not done yet Prediction!!!\n");
		     for(i = 0; i < 8; i++)
         	     {
			put1bit(bs, info->mc_pred[i]);  
			if(info->mc_pred[i] == 1)
			{
		         for(j = 0; j < n_pred_coef[info->dyn_cross[i]]; j++)
			    putbits(bs, info->predsi[i][j], 2);
			}
	             }  
		   }
}			  
    
void encode_infomc_ext1(frame_params *fr_ps, Bit_stream_struc *bs_ext)
{
        
        layer *info = fr_ps->header;
	
	    info->ext_sync = 0x7ff;
	    
		  putbits(bs_ext,info->ext_sync, 12); 
}

void encode_infomc_ext2(frame_params *fr_ps, Bit_stream_struc *bs_ext, unsigned int crc)
{
        
        layer *info = fr_ps->header;
	

		  putbits(bs_ext, crc, 16);
		  putbits(bs_ext,info->ext_length, 11);
		  put1bit(bs_ext,info->ext_bit);
}

    
 
/************************************************************************/
/*
/* mod()
/*
/* PURPOSE:  Returns the absolute value of its argument
/*
/************************************************************************/
 
double mod(double a)
{
    return (a > 0) ? a : -a;
}
 
/************************************************************************/
/*
/* I_combine_LR    (Layer I)
/* II_combine_LR	 (Layer II)
/*
/* PURPOSE:Combines left and right channels into a mono channel
/*
/* SEMANTICS:  The average of left and right subband samples is put into
/* #joint_sample#
/*
/* Layer I and II differ in frame length and # subbands used
/*
/************************************************************************/
 
void I_combine_LR(double (*sb_sample)[3][12][32], double (*joint_sample)[3][12][32])
       /*far*/                                       
       /*far*/                                          
{   /* make a filtered mono for joint stereo */
    int sb, smp;
 
   for(sb = 0; sb<SBLIMIT; ++sb)
      for(smp = 0; smp<SCALE_BLOCK; ++smp)
		  joint_sample[0][0][smp][sb] = .5 *
                    (sb_sample[0][0][smp][sb] + sb_sample[1][0][smp][sb]);
}
 
void II_combine_LR(double (*sb_sample)[3][12][32], double (*joint_sample)[3][12][32], int sblimit)
       /*far*/                                       
       /*far*/                                          
            
{  /* make a filtered mono for joint stereo */
   int sb, smp, sufr;
 
   for(sb = 0; sb<sblimit; ++sb)
      for(smp = 0; smp<SCALE_BLOCK; ++smp)
         for(sufr = 0; sufr<3; ++sufr)
		joint_sample[0][sufr][smp][sb] = .5 * (sb_sample[0][sufr][smp][sb]
                                          + sb_sample[1][sufr][smp][sb]);
}


/************************************************************************
/*
/* I_scale_factor_calc     (Layer I)
/* II_scale_factor_calc    (Layer II)
/*
/* PURPOSE:For each subband, calculate the scale factor for each set
/* of the 12 (6 in case of lsf ML) subband samples
/*
/* SEMANTICS:  Pick the scalefactor #multiple[]# just larger than the
/* absolute value of the peak subband sample of 12 samples,
/* and store the corresponding scalefactor index in #scalar#.
/*
/* Layer II has three sets of 12 (6 in case of lsf ML) subband samples 
/* for a given subband.
/*
/************************************************************************/
 
void I_scale_factor_calc(double (*sb_sample)[3][12][32], unsigned int (*scalar)[3][32], int stereo)
       /*far*/                                       
                                   
           
{
   int i,j, k;
   double s[SBLIMIT];
 
   for (k=0;k<stereo;k++) {
     for (i=0;i<SBLIMIT;i++)
       for (j=1, s[i] = mod(sb_sample[k][0][0][i]);j<SCALE_BLOCK;j++)
         if (mod(sb_sample[k][0][j][i]) > s[i])
            s[i] = mod(sb_sample[k][0][j][i]);
 
     for (i=0;i<SBLIMIT;i++)
       for (j=SCALE_RANGE-1,scalar[k][0][i]=0;j>=0;j--)
         if (s[i] < multiple[j]) { /* <= changed to <, 1992-11-06 shn */
            scalar[k][0][i] = j;
            break;
         }
   }
}

/******************************** Layer II ******************************/
 
void II_scale_factor_calc(frame_params *fr_ps, double (*sb_sample)[3][12][32], unsigned int (*scalar)[3][32], int sblimit, int l, int m)
/* sblimit has the value of mlsblimit in case II_scale_factor_calc */
/* is called in a ML channel , 7/8/95 WtK                          */
{
  int    i,j, k,t;
  double s[SBLIMIT];
  int    leng;
 
  leng = SCALE_BLOCK; /* == 12 */
  if ( (l>=7) && (fr_ps->header->multiling_fs==1) ) leng /= 2;

  for (k = l; k< m; k++) for (t=0;t<3;t++) 
  {
    for (i=0;i<sblimit;i++)
	for (j=1, s[i] = mod(sb_sample[k][t][0][i]);j<leng;j++)
		  if (mod(sb_sample[k][t][j][i]) > s[i])
			 s[i] = mod(sb_sample[k][t][j][i]);
 
    for (i=0;i<sblimit;i++)
        for (j=SCALE_RANGE-1,scalar[k][t][i]=0;j>=0;j--)
		if (s[i] < multiple[j]) 
		{                       /* <= changed to <, 1992-11-06 shn*/
                   scalar[k][t][i] = j;
                   break;
                }
        for (i=sblimit;i<SBLIMIT;i++) scalar[k][t][i] = SCALE_RANGE-1;
   }
} 

/***************************************************************************
/* void II_scale_factor_calc1(sb_sample, scalar, stereo, sblimit)
/*
/* in case of any joint stereo the scalefactor must be computed
/* a second time for the combind samples
/*
/***************************************************************************/

void II_scale_factor_calc1(double (*sb_sample)[3][12][32], unsigned int (*scalar)[3][32], int sblimit, int dim)
       /*far*/                                       
                                   
            
        
{
  int i,j, k,t;
  double s[SBLIMIT];

	for (t=0;t<3;t++) {
	 for (i=0;i<sblimit;i++)
		for (j=1, s[i] = mod(sb_sample[dim][t][0][i]);j<SCALE_BLOCK;j++)
		  if (mod(sb_sample[dim][t][j][i]) > s[i])
				 s[i] = mod(sb_sample[dim][t][j][i]);

  for (i=0;i<sblimit;i++)
	 for (j=SCALE_RANGE-1,scalar[dim][t][i]=0;j>=0;j--)
		if (s[i] < multiple[j]) { /* <= changed to <, 1992-11-06 shn */
			scalar[dim][t][i] = j;
			break;
		}
		for (i=sblimit;i<SBLIMIT;i++) scalar[dim][t][i] = SCALE_RANGE-1;
	 }
}



/************************************************************************
/*
/* pick_scale  (Layer II)
/*
/* PURPOSE:For each subband, puts the smallest scalefactor of the 3
/* associated with a frame into #max_sc#.  This is used
/* used by Psychoacoustic Model I.
/* (I would recommend changin max_sc to min_sc)
/*
/************************************************************************/
 
void pick_scale(unsigned int (*scalar)[3][32], frame_params *fr_ps, double (*max_sc)[32], int cha_sw, int aiff)
                                    	/* 08/03/1995 JMZ Multilingual */
                    
       /*far*/                     		/* 08/03/1995 JMZ Multilingual */
           
         
{
  int i,j,k,l,m;
  int max;
  int stereo  = fr_ps->stereo;
  int stereomc = fr_ps->stereomc;
  int sblimit = fr_ps->sblimit;
  int mlsblimit = fr_ps->mlsblimit;
  int n_ml_ch = fr_ps->header->multiling_ch; /* 08/03/1995 JMZ Multilingual */
 

  if(aiff != 1)
  {
     l = 0; m = 2;
  }
  else
  {   
     l = 0;
     m = 7;
  }

  for (k = l; k < m; k++) {
    for (i=0;i<sblimit;max_sc[k][i] = multiple[max], i++)
      for (j=1, max = scalar[k][0][i];j<3;j++)
         if (max > scalar[k][j][i]) max = scalar[k][j][i];
    for (i=sblimit;i<SBLIMIT;i++) max_sc[k][i] = 1E-20;
  }  

 if(aiff == 1)
 {
  if((fr_ps->header->matrix == 3) || (cha_sw == 0))
        fr_ps->header->tc_sbgr_select = 1;
  else  tc_alloc(fr_ps, max_sc);
 }

/********************************************************/
/* JMZ 08/03/1995 Multilingual , WtK 07/08/95 */

 if (n_ml_ch >0)
 {
  for (k = 7; k < 7+n_ml_ch; k++) {
    for (i=0;i<mlsblimit;max_sc[k][i] = multiple[max], i++)
      for (j=1, max = scalar[k][0][i];j<3;j++)
         if (max > scalar[k][j][i]) max = scalar[k][j][i];
    for (i=mlsblimit;i<SBLIMIT;i++) max_sc[k][i] = 1E-20;
  }
 }
/* JMZ 08/03/1995 Multilingual */
/********************************************************/

}

/***************************************************************************
/*
/* tc_alloc  (Layer II, multichannel)
/*
/* PURPOSE: For each subbandgroup the three transmissionchannels are
/*          determined by taking the channel with the lowest level
/*          according to the tabel tc_allocation in the draft
/*  8/10/93, SR          
/* 
/*           changed to a certain limit of TC_ALLOC which must be stepped
/*           beyond, before there is channel-switching
/*           9/20/93 SR
/**************************************************************************/

void tc_alloc_old(frame_params *fr_ps, double (*max_sc)[32])
{
    int i, l, k;
    int min;
    double min1;
    double min2[7][12];
    
    for(i = 0; i < 8; i++)
    {
       if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
       {
           if(max_sc[6][i] < max_sc[5][i])
              min = 6;
	   else if(max_sc[6][i] == max_sc[5][i])
	   {
	       if(max_sc[3][i] <= max_sc[5][i])
	           min = 5;
	       else min = 6;	          
	   }
	   else min = 5;
       }  
       else if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
       {
           if(max_sc[5][i] < max_sc[6][i])
              min = 5;
	   else if(max_sc[6][i] == max_sc[5][i])
	   {
	       if(max_sc[3][i] <= max_sc[5][i])
	           min = 5;
	       else min = 6;	          
	   }
	   else min = 6;
       }  
       else   	  	    
       {
	      min = 2;
       }
	
	switch(min)
	{
	    case 5: if(max_sc[4][i] <= max_sc[6][i])  /* left front,Rs*/
	              fr_ps->header->tc_alloc[i] = 1;
		    else fr_ps->header->tc_alloc[i] = 7;  /*R*/
		    break;
	    case 6: if(max_sc[3][i] <= max_sc[5][i])  /* right front,Ls*/
	              fr_ps->header->tc_alloc[i] = 2;
		    else fr_ps->header->tc_alloc[i] = 6;  /* L */
		    break;		    
	    case 2: if(((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
	            {
	               if(max_sc[4][i] <= max_sc[6][i])  
		         fr_ps->header->tc_alloc[i] = 3;
		       else fr_ps->header->tc_alloc[i] = 5;
		    }  
		    else
		    {
	               if(((20 * log10(max_sc[4][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)  
		         fr_ps->header->tc_alloc[i] = 4;
		       else fr_ps->header->tc_alloc[i] = 0;
		    }    
		    break;
	}
  }


 for(i = 8; i < 12; i++)   
   for(k = 2; k < 7; k++)
        min2[k][i] = 0.0;	 
 
 
 for(i = 8; i < 12; i++)    /*taking the average scalefactor of each sb-group*/
 {
   for(k = 2; k < 7; k++)
   {
     for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
     {
        min2[k][i] += max_sc[k][l];	 
     }
   min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
   }




    if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
    {
        if(min2[6][i] < min2[5][i])
           min = 6;
        else if(min2[6][i] == min2[5][i])
	{
	       if(min2[3][i] <= min2[5][i])
	           min = 5;
	       else min = 6;	          
	}
        else min = 5;
    }  
    else if(((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
    {
        if(min2[5][i] < min2[6][i])
           min = 5;
	else if(min2[6][i] == min2[5][i])
	{
	       if(min2[3][i] <= min2[5][i])
	           min = 5;
	       else min = 6;	          
	}
        else min = 6;
    }  
    else   	  	    
    {
           min = 2;
    }
	




	
	switch(min)
	{
	    case 5: if(min2[4][i] <= min2[6][i])  /* left front,Rs*/
	              fr_ps->header->tc_alloc[i] = 1;
		    else fr_ps->header->tc_alloc[i] = 7;  /*R*/
		    break;
	    case 6: if(min2[3][i] <= min2[5][i])  /* right front,Ls*/
	              fr_ps->header->tc_alloc[i] = 2;
		    else fr_ps->header->tc_alloc[i] = 6;  /* L */
		    break;
	    case 2: if(((20 * log10(min2[3][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
	            {
	               if(min2[4][i] <= min2[6][i])  
		         fr_ps->header->tc_alloc[i] = 3;
		       else fr_ps->header->tc_alloc[i] = 5;
		    }  
		    else
		    {
	               if(((20 * log10(min2[4][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)  
		         fr_ps->header->tc_alloc[i] = 4;
		       else fr_ps->header->tc_alloc[i] = 0;
		    }    
		    break;
	}
       
 }


     
    if(fr_ps->header->tc_alloc[0] == fr_ps->header->tc_alloc[1] &&
       fr_ps->header->tc_alloc[1] == fr_ps->header->tc_alloc[2] &&
       fr_ps->header->tc_alloc[2] == fr_ps->header->tc_alloc[3] &&
       fr_ps->header->tc_alloc[3] == fr_ps->header->tc_alloc[4] &&
       fr_ps->header->tc_alloc[4] == fr_ps->header->tc_alloc[5] &&
       fr_ps->header->tc_alloc[5] == fr_ps->header->tc_alloc[6] &&
       fr_ps->header->tc_alloc[6] == fr_ps->header->tc_alloc[7] &&
       fr_ps->header->tc_alloc[7] == fr_ps->header->tc_alloc[8] &&
       fr_ps->header->tc_alloc[8] == fr_ps->header->tc_alloc[9] &&
       fr_ps->header->tc_alloc[9] == fr_ps->header->tc_alloc[10] &&
       fr_ps->header->tc_alloc[10] == fr_ps->header->tc_alloc[11])
       {
          fr_ps->header->tc_sbgr_select = 1;
          fr_ps->header->tc_allocation = fr_ps->header->tc_alloc[0];
       }
      else fr_ps->header->tc_sbgr_select = 0; /* added 8/20/93,SR*/ 
}







/************************************************************************
/*
/* put_scale   (Layer I)
/*
/* PURPOSE:Sets #max_sc# to the scalefactor index in #scalar.
/* This is used by Psychoacoustic Model I
/*
/************************************************************************/
 
void put_scale(unsigned int (*scalar)[3][32], frame_params *fr_ps, double (*max_sc)[32])
                                   
                    
       /*far*/                    
{
   int i,j,k, max;
   int stereo  = fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int sblimit = fr_ps->sblimit;
 
	for (k = 0; k < stereo+stereomc+2; k++) for (i = 0; i < SBLIMIT; i++)
        max_sc[k][i] = multiple[scalar[k][0][i]];
}
 
/************************************************************************
/*
/* II_transmission_pattern (Layer II only)
/*
/* PURPOSE:For a given subband, determines whether to send 1, 2, or
/* all 3 of the scalefactors, and fills in the scalefactor
/* select information accordingly
/*
/* SEMANTICS:  The subbands and channels are classified based on how much
/* the scalefactors changes over its three values (corresponding
/* to the 3 sets of 12 samples per subband).  The classification
/* will send 1 or 2 scalefactors instead of three if the scalefactors
/* do not change much.  The scalefactor select information,
/* #scfsi#, is filled in accordingly.
/*
/************************************************************************/
 
void II_transmission_pattern(unsigned int (*scalar)[3][32], unsigned int (*scfsi)[32], frame_params *fr_ps)
                                    	/* JMZ 08/03/1995 Multilingual */
                                		/* JMZ 08/03/1995 Multilingual */
                    
                                    	/* JMZ 08/03/1995 Multilingual */

{
   int stereo  = fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int sblimit = fr_ps->sblimit;
   int mlsblimit = fr_ps->mlsblimit;
   int n_ml_ch = fr_ps->header->multiling_ch;/* JMZ 10/03/1995 Multilingual */

	int dscf[2];
	int class[2],i,j,k;
static int pattern[5][5] = {0x123, 0x122, 0x122, 0x133, 0x123,
                            0x113, 0x111, 0x111, 0x444, 0x113,
                            0x111, 0x111, 0x111, 0x333, 0x113,
                            0x222, 0x222, 0x222, 0x333, 0x123,
                            0x123, 0x122, 0x122, 0x133, 0x123};
 
  for (k = 0; k < stereo+stereomc+2; k++)
     for (i=0;i<sblimit;i++) 
     {
       dscf[0] =  (scalar[k][0][i]-scalar[k][1][i]);
       dscf[1] =  (scalar[k][1][i]-scalar[k][2][i]);
       for (j=0;j<2;j++)
       {
         if (dscf[j]<=-3) class[j] = 0;
         else if (dscf[j] > -3 && dscf[j] <0) class[j] = 1;
              else if (dscf[j] == 0) class[j] = 2;
                   else if (dscf[j] > 0 && dscf[j] < 3) class[j] = 3;
                        else class[j] = 4;
       }
       switch (pattern[class[0]][class[1]]) 
       {
         case 0x123 :    scfsi[k][i] = 0;
                         break;
         case 0x122 :    scfsi[k][i] = 3;
                         scalar[k][2][i] = scalar[k][1][i];
                         break;
         case 0x133 :    scfsi[k][i] = 3;
                         scalar[k][1][i] = scalar[k][2][i];
                         break;
         case 0x113 :    scfsi[k][i] = 1;
                         scalar[k][1][i] = scalar[k][0][i];
                         break;
         case 0x111 :    scfsi[k][i] = 2;
                         scalar[k][1][i] = scalar[k][2][i] = scalar[k][0][i];
                         break;
         case 0x222 :    scfsi[k][i] = 2;
                         scalar[k][0][i] = scalar[k][2][i] = scalar[k][1][i];
                         break;
         case 0x333 :    scfsi[k][i] = 2;
                         scalar[k][0][i] = scalar[k][1][i] = scalar[k][2][i];
                         break;
         case 0x444 :    scfsi[k][i] = 2;
                         if (scalar[k][0][i] > scalar[k][2][i])
                              scalar[k][0][i] = scalar[k][2][i];
                         scalar[k][1][i] = scalar[k][2][i] = scalar[k][0][i];
   
   
       } /* switch */
    } /* subband */

if (n_ml_ch >0)
{
 for (k = 7; k < 7+n_ml_ch; k++)
     for (i=0;i<mlsblimit;i++) 
     {
       dscf[0] =  (scalar[k][0][i]-scalar[k][1][i]);
       dscf[1] =  (scalar[k][1][i]-scalar[k][2][i]);
       for (j=0;j<2;j++)
       {
         if (dscf[j]<=-3) class[j] = 0;
         else if (dscf[j] > -3 && dscf[j] <0) class[j] = 1;
              else if (dscf[j] == 0) class[j] = 2;
                   else if (dscf[j] > 0 && dscf[j] < 3) class[j] = 3;
                        else class[j] = 4;
       }
       switch (pattern[class[0]][class[1]]) 
       {
         case 0x123 :    scfsi[k][i] = 0;
                         break;
         case 0x122 :    scfsi[k][i] = 3;
                         scalar[k][2][i] = scalar[k][1][i];
                         break;
         case 0x133 :    scfsi[k][i] = 3;
                         scalar[k][1][i] = scalar[k][2][i];
                         break;
         case 0x113 :    scfsi[k][i] = 1;
                         scalar[k][1][i] = scalar[k][0][i];
                         break;
         case 0x111 :    scfsi[k][i] = 2;
                         scalar[k][1][i] = scalar[k][2][i] = scalar[k][0][i];
                         break;
         case 0x222 :    scfsi[k][i] = 2;
                         scalar[k][0][i] = scalar[k][2][i] = scalar[k][1][i];
                         break;
         case 0x333 :    scfsi[k][i] = 2;
                         scalar[k][0][i] = scalar[k][1][i] = scalar[k][2][i];
                         break;
         case 0x444 :    scfsi[k][i] = 2;
                         if (scalar[k][0][i] > scalar[k][2][i])
                              scalar[k][0][i] = scalar[k][2][i];
                         scalar[k][1][i] = scalar[k][2][i] = scalar[k][0][i];
     } /* subband */
   } /* channel */
}

}
 
/************************************************************************
/*
/* I_encode_scale  (Layer I)
/* II_encode_scale (Layer II)
/*
/* PURPOSE:The encoded scalar factor information is arranged and
/* queued into the output fifo to be transmitted.
/*
/* For Layer II, the three scale factors associated with
/* a given subband and channel are transmitted in accordance
/* with the scfsi, which is transmitted first.
/*
/************************************************************************/
 
void I_encode_scale(unsigned int (*scalar)[3][32], unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)
{
   int stereo  = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int i,j;
 
   for (i=0;i<SBLIMIT;i++) for (j=0;j<stereo;j++)
      if (bit_alloc[j][i]) putbits(bs,scalar[j][0][i],6);
}
 
/***************************** Layer II  ********************************/

void
II_encode_scale(
	unsigned int (*bit_alloc)[32],
	unsigned int (*scfsi)[32],
	unsigned int (*scalar)[3][32], /* JMZ 08/03/1995 Multilingual */
	unsigned int lfe_alloc, 
	unsigned int lfe_scalar, 
	frame_params *fr_ps,
	Bit_stream_struc *bs,
	int *l,
	int *z
) {
   int stereo  = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int lfe     = fr_ps->header->lfe;
   int i,j,k, m, n, pci;
   int pred;

	for (i=0;i<sblimit;i++)
	 for (m = *l; m < *z; m++)
	 {
	     if(fr_ps->header->tc_sbgr_select == 1)
               k = transmission_channel[fr_ps->header->tc_allocation][m];
	     else
	     { 
	        if(i == 0) k = transmission_channel[fr_ps->header->tc_alloc[0]][m];
	        else
		{
                   for(n = 1; n < 12; n++)
                   {
	              if((sb_groups[n-1] < i) && (i <= sb_groups[n])) 
	              {
                          k = transmission_channel[fr_ps->header->tc_alloc[n]][m];
		          break;
	              }
                   }
		 }  
	      } 


	 
		if (bit_alloc[k][i]) 
           	    putbits(bs,scfsi[k][i],2);
          }
 
 
 pred = 0;
       if( *l == 2)
       {
	if(fr_ps->header->mc_prediction_on == 1)
	{
	   for(i = 0; i < 8; i++)
	   {
	       if(fr_ps->header->mc_pred[i] == 1)
	       {
		   for(m = 0; m < n_pred_coef[fr_ps->header->dyn_cross[i]]; m++)
		   {
		       if(fr_ps->header->predsi[i][m] != 0)
		       {
		          putbits(bs, fr_ps->header->delay_comp[i][m], 3);
			  pred += 3;
			  for(pci = 0; pci < fr_ps->header->predsi[i][m]; pci++)
			  {
			    putbits(bs, pred_coef[i][m][pci], 8);
			    pred += 8;			      
			  }
		       }    
		   }
	       }
	   }
	 }  
	}  
 
         if (lfe)
          if(lfe_alloc)
             putbits(bs,lfe_scalar,6);

	for (i=0;i<sblimit;i++)
	 for (m = *l;m < *z; m++)
	 {
	     if(fr_ps->header->tc_sbgr_select == 1)
               k = transmission_channel[fr_ps->header->tc_allocation][m];
	     else
	     {
	       if(i == 0)  k = transmission_channel[fr_ps->header->tc_alloc[0]][m];
	       else
	       {
                  for(n = 1; n < 12; n++)
                  {
	              if((sb_groups[n-1] < i) && (i <= sb_groups[n])) /*bug!! 8/21/93,SR*/
	              {
                          k = transmission_channel[fr_ps->header->tc_alloc[n]][m];
	                 break;
	              }
                   }
                } 
	      }	
	     
	     
	 
           if (bit_alloc[k][i])  
	   switch (scfsi[k][i]) 
	   {
			case 0: for (j=0;j<3;j++)
                        putbits(bs,scalar[k][j][i],6);

					break;
			case 1:
			case 3:	putbits(bs,scalar[k][0][i],6);
					putbits(bs,scalar[k][2][i],6);

					break;
			case 2: putbits(bs,scalar[k][0][i],6);

          }
       }	
}
 
/*JMZ 24/2/95 Multilingual , WtK 7/8/95*/
void II_encode_scale_ml(unsigned int (*bit_alloc)[32], unsigned int (*scfsi)[32], unsigned int (*scalar)[3][32], frame_params *fr_ps, Bit_stream_struc *bs, int *l, int *z)
{
   int stereo    = fr_ps->stereo;
   int mlsblimit = fr_ps->mlsblimit;
   int i,j,k, m, n, pci;

for (i=0;i<mlsblimit;i++)
  for (m = *l; m < *z; m++)
	{
	k=m;
	if (bit_alloc[k][i])  
		putbits(bs,scfsi[k][i],2);
	}
for (i=0;i<mlsblimit;i++)
  for (m = *l;m < *z; m++)
	{
	k=m;
	if (bit_alloc[k][i])  
		switch (scfsi[k][i]) 
		{
			case 0: for (j=0;j<3;j++)
				putbits(bs,scalar[k][j][i],6);
				break;
			case 1:
			case 3: putbits(bs,scalar[k][0][i],6);
				putbits(bs,scalar[k][2][i],6);
				break;
			case 2: putbits(bs,scalar[k][0][i],6);
				break;
		}
	}	
}

/*=======================================================================\
|                                                                        |
|      The following routines are done after the masking threshold       |
| has been calculated by the fft analysis routines in the Psychoacoustic |
| model. Using the MNR calculated, the actual number of bits allocated   |
| to each subband is found iteratively.                                  |
|                                                                        |
\=======================================================================*/
 
/************************************************************************
/*
/* I_bits_for_nonoise  (Layer I)
/* II_bits_for_nonoise (Layer II)
/*
/* PURPOSE:Returns the number of bits required to produce a
/* mask-to-noise ratio better or equal to the noise/no_noise threshold.
/*
/* SEMANTICS:
/* bbal = # bits needed for encoding bit allocation
/* bsel = # bits needed for encoding scalefactor select information
/* banc = # bits needed for ancillary data (header info included)
/*
/* For each subband and channel, will add bits until one of the
/* following occurs:
/* - Hit maximum number of bits we can allocate for that subband
/* - MNR is better than or equal to the minimum masking level
/*   (NOISY_MIN_MNR)
/* Then the bits required for scalefactors, scfsi, bit allocation,
/* and the subband samples are tallied (#req_bits#) and returned.
/*
/* (NOISY_MIN_MNR) is the smallest MNR a subband can have before it is
/* counted as 'noisy' by the logic which chooses the number of JS
/* subbands.
/*
/* Joint stereo is supported.
/*
/************************************************************************/

/*static double snr[18] = {0.00, 7.00, 11.00, 16.00, 20.84,
                         25.28, 31.59, 37.75, 43.84,
                         49.89, 55.93, 61.96, 67.98, 74.01,
                         80.03, 86.05, 92.01, 98.01};*/
static double snr[18] = { 0.00,  6.03, 11.80, 15.81, /* 0, 3, 5, 7 */
			 19.03, 23.50, 29.82, 35.99, /* 9,15,31,63 */
			 42.08, 48.13, 54.17, 60.20, /* 127, ...   */
			 66.22, 72.25, 78.27, 84.29, /* 2047, ...  */
			 90.31, 96.33};              /* 16383, ... */

int I_bits_for_nonoise(double (*perm_smr)[32], frame_params *fr_ps)
       /*far*/                      
                    
{
   int i,j,k;
   int stereo  = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   int req_bits = 0;
 
   /* initial b_anc (header) allocation bits */
   req_bits = 32 + 4 * ( (jsbound * stereo) + (SBLIMIT-jsbound) );
 
   for(i=0; i<SBLIMIT; ++i)
     for(j=0; j<((i<jsbound)?stereo:1); ++j) {
       for(k=0;k<14; ++k)
			if( (-perm_smr[j][i] + snr[k]) >= fr_ps->mnr_min)
           break; /* we found enough bits */
         if(stereo == 2 && i >= jsbound)     /* check other JS channel */
           for(;k<14; ++k)
				 if( (-perm_smr[1-j][i] + snr[k]) >= fr_ps->mnr_min) break;
         if(k>0) req_bits += (k+1)*12 + 6*((i>=jsbound)?stereo:1);
   }
   return req_bits;
}
 
/***************************** Layer II  ********************************/
 
int II_bits_for_nonoise(double (*perm_smr)[32], unsigned int (*scfsi)[32], frame_params *fr_ps, int a, int b, int *aiff)
       /*far*/                      
                               
                    
      
      
          
{
   int sb,ch,ba,i;
   int stereo  = fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int n_ml_ch = fr_ps->header->multiling_ch;	/* 23/03/1995 JMZ Multilingual */
   int sblimit = fr_ps->sblimit;
   int mlsblimit = fr_ps->mlsblimit;
   int jsbound = fr_ps->jsbound;
   al_table *alloc = fr_ps->alloc;
   al_table *allocml = fr_ps->allocml;
   int bbal = 0;
   int berr;		                  /* before: =0 92-08-11 shn */
   int banc = 32; 	                  /* header ISO Layer II */
   int bancmc = 0;                            /* header multichannel = 93, 5.7.93,SR*/
   int maxAlloc, sel_bits, sc_bits, smp_bits;
   int req_bits = 0;
   static int sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */

	if (verbosity >= 3) printf("bits_for_nonoise\n");

	if( *aiff == 1)
	{ 
	      bancmc += 31;      /* mc_header + crc + tc_sbgr_select+ dyn_cross_on + 
				    mc_prediction_on       01/05/94,  SR*/
	      if(fr_ps->header->tc_sbgr_select == 0)
		bancmc += 36;
	      else
		bancmc += 3;	

	      if(fr_ps->header->dyn_cross_on == 1)
	      {
		  fprintf(stderr, "WARNING!! not done yet Dynamic Crosstalk!!!\n");
		  bancmc += 48;
	      }

              if(fr_ps->header->mc_prediction_on == 1)
	      {
		  fprintf(stderr, "WARNING! not done yet Prediction!!!\n");
		  for(i = 0; i < 12; i++)
		  {
		    bancmc += 1;
		    if(fr_ps->header->mc_pred[i] == 1)
		       bancmc += 4;
		  }
	      }
	 }     
        else bancmc = 0;
	if (fr_ps->header->error_protection) berr=16; else berr=0; /* added 92-08-11 shn */
	/*fixed bug (no errormc) 28.6.93 SR */

	for (sb = 0; sb < jsbound; ++sb)
	  bbal += (stereo+stereomc) * (*alloc)[sb][0].bits;
	for (sb = jsbound; sb < sblimit; ++sb)
	  bbal += (stereo-1+stereomc) * (*alloc)[sb][0].bits;     	 
	for (sb = 0; sb < mlsblimit; ++sb)
	  bbal += (n_ml_ch) * (*allocml)[sb][0].bits;     	 

	req_bits = banc + bancmc + bbal + berr;

	for(sb = 0; sb < sblimit; ++sb)
	{
	  for(ch = 0; ch < ((sb < jsbound)? stereo+stereomc : 1); ++ch) /* 23/03/1995 JMZ Multilingual */ 
	  {
	     maxAlloc = (1<<(*alloc)[sb][0].bits)-1;
             sel_bits = sc_bits = smp_bits = 0;
	     for(ba = 0; ba < maxAlloc-1; ++ba)
                if( (-perm_smr[ch][sb] + snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)])
				 >= fr_ps->mnr_min)
                   break;	       
		if(((b - a) >= 1) && (sb >= jsbound))
		{ /* check other JS channels */
		      for(;ba<maxAlloc-1; ++ba)
			 if( (-perm_smr[1-ch ][sb]+ snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)])
			 	>= fr_ps->mnr_min)
		      break;
		}
	
                if(ba>0) 
		{
                 smp_bits = 12 * ((*alloc)[sb][ba].group * (*alloc)[sb][ba].bits);
                 /* scale factor bits required for subband */
                 sel_bits = 2;
		 sc_bits  = 6 * sfsPerScfsi[scfsi[ch][sb]];

		   if(stereo == 2 && sb >= jsbound) {
		       /* each new js sb has L+R scfsis*/
                       sel_bits += 2;
                       sc_bits  += 6 * sfsPerScfsi[scfsi[1-ch][sb]];
		      } 

                   req_bits += (smp_bits+sel_bits+sc_bits);
                  }
	    }
	    
   }
/******************************************/
/* 23/03/1995 JMZ Multilingual */

if(n_ml_ch>0)
{
for(sb = 0; sb < (jsbound<mlsblimit)?jsbound:mlsblimit; ++sb) /* remaining part from jsbound to mlsblimit in II_bits_for_indi() , WtK*/
	{
	for(ch = 7; ch < 7+n_ml_ch ; ++ch)  
		{
		maxAlloc = (1<<(*allocml)[sb][0].bits)-1;
		sel_bits = sc_bits = smp_bits = 0;
		for(ba = 0; ba < maxAlloc-1; ++ba)
			if( (-perm_smr[ch][sb] + snr[(*allocml)[sb][ba].quant+((ba>0)?1:0)])
				 >= fr_ps->mnr_min)
                  break;	       
		if(ba>0) 
			{
			if (fr_ps->header->multiling_fs==1)
			     smp_bits =  6 * ((*allocml)[sb][ba].group * (*allocml)[sb][ba].bits);
			else
			     smp_bits = 12 * ((*allocml)[sb][ba].group * (*allocml)[sb][ba].bits);
                /* scale factor bits required for subband */
			sel_bits = 2;
			sc_bits  = 6 * sfsPerScfsi[scfsi[ch][sb]];

			req_bits += (smp_bits+sel_bits+sc_bits);
			}
		}
	}
}
/* 23/03/1995 JMZ Multilingual */
/******************************************/
   return req_bits;
}


/**********************************************************************/ 
/*now for the independent channels, 8/6/93, SR                        */
/**********************************************************************/
int II_bits_for_indi(double (*perm_smr)[32], unsigned int (*scfsi)[32], frame_params *fr_ps, int *a, int *b, int *aiff)
{
   int sb,ch,ba,i;
   int stereo  = fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int n_ml_ch = fr_ps->header->multiling_ch;	/* 23/03/1995 JMZ Multilingual */
   int sblimit = fr_ps->sblimit;
   int mlsblimit = fr_ps->mlsblimit;
   int jsbound = fr_ps->jsbound;
   al_table *alloc = fr_ps->alloc;
   al_table *allocml = fr_ps->allocml;
   int req_bits = 0, bbal = 0;
   int berr;		                  /* before: =0 92-08-11 shn */
   int banc = 32; 	                  /* header ISO Layer II */
   int bancmc;                            /* header multichannel = 93, 5.7.93,SR*/
   int maxAlloc, sel_bits, sc_bits, smp_bits;
   static int sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */

	for(sb = jsbound; sb < sblimit; ++sb)
	{
	  for(ch = 2; ch < 5; ++ch) 
	  {
	     maxAlloc = (1<<(*alloc)[sb][0].bits)-1;
             sel_bits = sc_bits = smp_bits = 0;
	     for(ba = 0; ba < maxAlloc-1; ++ba)
                if( (-perm_smr[ch][sb] + snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)])
				 >= fr_ps->mnr_min)
				break;		/* we found enough bits */

             if(ba>0) 
	       {
                 smp_bits = 12 * ((*alloc)[sb][ba].group * (*alloc)[sb][ba].bits);
                 /* scale factor bits required for subband */
                 sel_bits = 2;
		 sc_bits  = 6 * sfsPerScfsi[scfsi[ch][sb]];
	         req_bits += smp_bits+sel_bits+sc_bits;
               }
	  }
	}
/******************************************/
/* 23/03/1995 JMZ Multilingual , WtK 7/8/95 */
	if (n_ml_ch>0)
	for(sb = jsbound; sb < mlsblimit; ++sb)
	{
		 for(ch = 7; ch < 7+n_ml_ch; ++ch) 
		 {
		 maxAlloc = (1<<(*allocml)[sb][0].bits)-1;
		 sel_bits = sc_bits = smp_bits = 0;
		 for(ba = 0; ba < maxAlloc-1; ++ba)
		 if( (-perm_smr[ch][sb] + snr[(*allocml)[sb][ba].quant+((ba>0)?1:0)])
			  >= fr_ps->mnr_min)
			 break;		/* we found enough bits */
		 if(ba>0) 
			 {
			 if (fr_ps->header->multiling_fs==1)
			       smp_bits =  6 * ((*allocml)[sb][ba].group * (*allocml)[sb][ba].bits);
			 else
			       smp_bits = 12 * ((*allocml)[sb][ba].group * (*allocml)[sb][ba].bits);
			 /* scale factor bits required for subband */
			 sel_bits = 2;
			 sc_bits  = 6 * sfsPerScfsi[scfsi[ch][sb]];

			 req_bits += smp_bits+sel_bits+sc_bits;
			 }
		 }
	}

/* 23/03/1995 JMZ Multilingual */
/******************************************/
  return req_bits;
}

	    
/************************************************************************
/*
/* I_main_bit_allocation   (Layer I)
/* II_main_bit_allocation  (Layer II)
/*
/* PURPOSE:For joint stereo mode, determines which of the 4 joint
/* stereo modes is needed.  Then calls *_a_bit_allocation(), which
/* allocates bits for each of the subbands until there are no more bits
/* left, or the MNR is at the noise/no_noise threshold.
/*
/* SEMANTICS:
/*
/* For joint stereo mode, joint stereo is changed to stereo if
/* there are enough bits to encode stereo at or better than the
/* no-noise threshold (fr_ps->mnr_min).  Otherwise, the system
/* iteratively allocates less bits by using joint stereo until one
/* of the following occurs:
/* - there are no more noisy subbands (MNR >= fr_ps->mnr_min)
/* - mode_ext has been reduced to 0, which means that all but the
/*   lowest 4 subbands have been converted from stereo to joint
/*   stereo, and no more subbands may be converted
/*
/*     This function calls *_bits_for_nonoise() and *_a_bit_allocation().
/*
/************************************************************************/
 
void I_main_bit_allocation(double (*perm_smr)[32], unsigned int (*bit_alloc)[32], int *adb, frame_params *fr_ps)
       /*far*/                      
                                   
         
                    
{
   int  noisy_sbs;
   int  mode, mode_ext, lay, i;
   int  rq_db, av_db = *adb;
static  int init = 0;
 
   if(init == 0) {
     /* rearrange snr for layer I */
     snr[2] = snr[3];
     for (i=3;i<16;i++) snr[i] = snr[i+2];
     init = 1;
   }
 
   if((mode = fr_ps->actual_mode) == MPG_MD_JOINT_STEREO) {
     fr_ps->header->mode = MPG_MD_STEREO;
     fr_ps->header->mode_ext = 0;
     fr_ps->jsbound = fr_ps->sblimit;
     if(rq_db = I_bits_for_nonoise(perm_smr, fr_ps) > *adb) {
       fr_ps->header->mode = MPG_MD_JOINT_STEREO;
       mode_ext = 4;           /* 3 is least severe reduction */
       lay = fr_ps->header->lay;
       do {
          --mode_ext;
          fr_ps->jsbound = js_bound(lay, mode_ext);
          rq_db = I_bits_for_nonoise(perm_smr, fr_ps);
       } while( (rq_db > *adb) && (mode_ext > 0));
       fr_ps->header->mode_ext = mode_ext;
     }    /* well we either eliminated noisy sbs or mode_ext == 0 */
   }
   noisy_sbs = I_a_bit_allocation(perm_smr, bit_alloc, adb, fr_ps);
}
 
 

/***************************** Layer II  ********************************/
 
void
II_main_bit_allocation(
	double (*perm_smr)[32], /* minimum masking level *//* JMZ 08/03/1995 Multilingual */
	double (*ltmin)[32], /* minimum masking level *//* JMZ 08/03/1995 Multilingual */
	unsigned int (*scfsi)[32], /* JMZ 08/03/1995 Multilingual */
	unsigned int (*bit_alloc)[32], /* JMZ 08/03/1995 Multilingual */
	int *adb,
	frame_params *fr_ps,
	int *aiff,
	double (*sb_sample)[3][12][32], /* JMZ 08/03/1995 Multilingual */
	unsigned int (*scalar)[3][32], /* JMZ 08/03/1995 Multilingual */
	double (*max_sc)[32], /* JMZ 08/03/1995 Multilingual */
	int cha_sw,
	double (*buffer)[1152], /* JMZ 08/03/1995 Multilingual */
	double (*spiki)[32], /* JMZ 08/03/1995 Multilingual */
	double (*joint_sample)[3][12][32],
	unsigned int (*j_scale)[3][32], 
	int dyn_cr, 
	unsigned int (*scfsi_dyn)[SBLIMIT], 
	unsigned int (*scalar_dyn)[3][SBLIMIT]
) {
   int  noisy_sbs, nn;
	int  mode, mode_ext, lay, modemc_hlp;
	int  rq_db, av_db = *adb;
	int a, b, i, l, m, sb, k;
	int sbbound = -30;
	float adb_help;
	double smr_pred[7][SBLIMIT];
        float preco[12][4];
	float prega[3][32];
	int bits1, bits2, ba, ba1, subgr;
	int maxAlloc;
	al_table *alloc = fr_ps->alloc;
	static int sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */
	double	    sb_sample_sum[4][3][12][32];	    
	int subfr, ch;
	unsigned int scalar_sum[4][3][SBLIMIT];
	unsigned int scfsi_sum[4][SBLIMIT]; 



  /***************************layer II two channels *******************/
  if(*aiff == 0){
	if((mode = fr_ps->actual_mode) == MPG_MD_JOINT_STEREO){
	  a = 0;
	  b = 1;
	  fr_ps->header->mode = MPG_MD_STEREO;
     fr_ps->header->mode_ext = 0;
     fr_ps->jsbound = fr_ps->sblimit;
	  if(rq_db = II_bits_for_nonoise(perm_smr, scfsi, fr_ps, a, b, aiff)
			  > *adb) {
       fr_ps->header->mode = MPG_MD_JOINT_STEREO;
       mode_ext = 4;           /* 3 is least severe reduction */
       lay = fr_ps->header->lay;
       do {
         --mode_ext;
         fr_ps->jsbound = js_bound(lay, mode_ext);
			rq_db = II_bits_for_nonoise(perm_smr, scfsi, fr_ps, a, b, aiff);
		 } while( (rq_db > *adb) && (mode_ext > 0));
       fr_ps->header->mode_ext = mode_ext;
	  }	 /* well we either eliminated noisy sbs or mode_ext == 0 */
    }
 }


 /***************** layer II five channels ****************************/
  else{
	 trans_chan(fr_ps); 		    

	for(sb = 0; sb < SBLIMIT; ++sb)
	{
	  if(sb >= 8)
	  {
	    for(subgr = 8; subgr < 12; subgr++)
		 if((sb_groups[subgr-1] < sb) && (sb <= sb_groups[subgr])) break;
	  }  
	  else subgr = sb;
   	     maxAlloc = (1<<(*alloc)[sb][0].bits)-1;
	     for(ba = 0; ba < maxAlloc-1; ++ba)
                if( (-perm_smr[0][sb] + snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)])
				 >= fr_ps->mnr_min)
				break;		/* we found enough bits */
	     for(ba1 = 0; ba1 < maxAlloc-1; ++ba1)
                if( (-perm_smr[no_channel[fr_ps->header->tc_alloc[subgr]][0]][sb] + snr[(*alloc)[sb][ba1].quant+((ba1>0)?1:0)])
				 >= fr_ps->mnr_min)
				break;		/* we found enough bits */
		if(ba1 > ba)
		{
         	 perm_smr[0][sb] = perm_smr[no_channel[fr_ps->header->tc_alloc[subgr]][0]][sb];		
		 ba = ba1;
		}

		 
		 
		 
	     maxAlloc = (1<<(*alloc)[sb][0].bits)-1;
	     for(ba = 0; ba < maxAlloc-1; ++ba)
                if( (-perm_smr[1][sb] + snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)])
				 >= fr_ps->mnr_min)
				break;		/* we found enough bits */
	     for(ba1 = 0; ba1 < maxAlloc-1; ++ba1)
                if( (-perm_smr[no_channel[fr_ps->header->tc_alloc[subgr]][1]][sb] + snr[(*alloc)[sb][ba1].quant+((ba1>0)?1:0)])
				 >= fr_ps->mnr_min)
				break;		/* we found enough bits */
		if(ba1 > ba)
		{
		 perm_smr[1][sb] = perm_smr[no_channel[fr_ps->header->tc_alloc[subgr]][1]][sb];		
		 ba = ba1;
		}
	    }
	    
	    
/************ 05/24/95, SR, dyn_cross talk **********************/	    
     if(dyn_cr != 0)
    {
    
	combine(fr_ps, sb_sample, sb_sample_sum); 	

	    for(ch=0; ch<CHANMAX2; ch++) {
		for(subfr=0; subfr<2; subfr++)
		    for(sb=0; sb<fr_ps->sblimit; sb++)
			scalar_dyn[ch][subfr][sb] = scalar[ch][subfr][sb]; 
			scfsi_calc_dyn(scalar_dyn, ch, fr_ps->sblimit, scfsi_dyn);
			scfsi_calc(scalar, ch, fr_ps->sblimit, scfsi);
		    }
	combine(fr_ps, sb_sample, sb_sample_sum);
	for(ch=0; ch<4; ch++) 
	{
	    scf_calc(sb_sample_sum, fr_ps->sblimit, ch, scalar_sum);
	    scfsi_calc_dyn(scalar_sum, ch, fr_ps->sblimit, scfsi_sum);
	}
	take_dyn_cross(dyn_cr, fr_ps, sb_sample_sum, scalar_sum, scfsi_sum, scfsi_dyn, 
	              sb_sample, scalar, scfsi); 				

    }

   if((mode = fr_ps->actual_mode) == MPG_MD_JOINT_STEREO)
   {
 	  a = 0;
	  b = 1;
	  fr_ps->header->mode = MPG_MD_STEREO;
          fr_ps->header->mode_ext = 0;
	  fr_ps->jsbound = fr_ps->sblimit;
	  adb_help = *adb;
	  if((rq_db = II_bits_for_nonoise(perm_smr, scfsi, fr_ps,/*&*/a, /*&*/b, aiff) /*JMZ 29/03/1995 BUG*/
	            + II_bits_for_indi(perm_smr, scfsi, fr_ps, &a, &b, aiff))  
					  > adb_help)
	  {
             fr_ps->header->mode = MPG_MD_JOINT_STEREO;
             mode_ext = 4;           /* 3 is least severe reduction */
             lay = fr_ps->header->lay;
             do {
               --mode_ext;
               fr_ps->jsbound = js_bound(lay, mode_ext);
	       rq_db = II_bits_for_nonoise(perm_smr, scfsi, fr_ps, a, b, aiff)
	              + II_bits_for_indi(perm_smr, scfsi, fr_ps, &a, &b, aiff);
	     } while( (rq_db >*adb) && (mode_ext > 0));
             fr_ps->header->mode_ext = mode_ext;
	  }	 /* well we either eliminated noisy sbs or mode_ext == 0 */

   }


 }  /* end of else (five-channel) */

noisy_sbs = II_a_bit_allocation(perm_smr, scfsi, bit_alloc, adb,
				  fr_ps, aiff);
				 

}
 
/************************************************************************
/*
/* I_a_bit_allocation  (Layer I)
/* II_a_bit_allocation (Layer II)
/*
/* PURPOSE:Adds bits to the subbands with the lowest mask-to-noise
/* ratios, until the maximum number of bits for the subband has
/* been allocated.
/*
/* SEMANTICS:
/* 1. Find the subband and channel with the smallest MNR (#min_sb#,
/*    and #min_ch#)
/* 2. Calculate the increase in bits needed if we increase the bit
/*    allocation to the next higher level
/* 3. If there are enough bits available for increasing the resolution
/*    in #min_sb#, #min_ch#, and the subband has not yet reached its
/*    maximum allocation, update the bit allocation, MNR, and bits
/*    available accordingly
/* 4. Repeat until there are no more bits left, or no more available
/*    subbands. (A subband is still available until the maximum
/*    number of bits for the subband has been allocated, or there
/*    aren't enough bits to go to the next higher resolution in the
/*    subband.)
/*
/************************************************************************/
 
int I_a_bit_allocation(double (*perm_smr)[32], unsigned int (*bit_alloc)[32], int *adb, frame_params *fr_ps)	/* return noisy sbs */
       /*far*/                      
                                   
         
                    
{
   int i, k, smpl_bits, scale_bits, min_sb, min_ch, oth_ch;
   int bspl, bscf, ad, noisy_sbs, done = 0;
   double mnr[2][SBLIMIT], small;
   char used[2][SBLIMIT];
   int stereo  = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   al_table *alloc = fr_ps->alloc;
   static char init= 0;
   static int bbal, banc, berr;
 
   if (!init) {
      banc = 32;     /* before: berr = 0; 92-08-11 shn */ 
      init = 1;

      if (fr_ps->header->error_protection) berr = 16; else berr= 0; /* added 92-08-11 shn */
   }
   bbal = 4 * ( (jsbound * stereo) + (SBLIMIT-jsbound) );
   *adb -= bbal + berr + banc;
   ad= *adb;
 
   for (i=0;i<SBLIMIT;i++) for (k=0;k<stereo;k++) {
     mnr[k][i]=snr[0]-perm_smr[k][i];
     bit_alloc[k][i] = 0;
     used[k][i] = 0;
   }
   bspl = bscf = 0;
 
   do  {
     /* locate the subband with minimum SMR */
     small = mnr[0][0]+1;    min_sb = -1; min_ch = -1;
     for (i=0;i<SBLIMIT;i++) for (k=0;k<stereo;k++)
       /* go on only if there are bits left */
       if (used[k][i] != 2 && small > mnr[k][i]) {
         small = mnr[k][i];
         min_sb = i;  min_ch = k;
       }
     if(min_sb > -1) {   /* there was something to find */
       /* first step of bit allocation is biggest */
       if (used[min_ch][min_sb])  { smpl_bits = 12; scale_bits = 0; }
       else                       { smpl_bits = 24; scale_bits = 6; }
       if(min_sb >= jsbound)        scale_bits *= stereo;
 
       /* check to see enough bits were available for */
       /* increasing resolution in the minimum band */
 
       if (ad  > bspl + bscf + scale_bits + smpl_bits) {
         bspl += smpl_bits; /* bit for subband sample */
         bscf += scale_bits; /* bit for scale factor */
         bit_alloc[min_ch][min_sb]++;
         used[min_ch][min_sb] = 1; /* subband has bits */
         mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb]
                               + snr[bit_alloc[min_ch][min_sb]];
         /* Check if subband has been fully allocated max bits */
         if (bit_alloc[min_ch][min_sb] ==  14 ) used[min_ch][min_sb] = 2;
       }
       else            /* no room to improve this band */
         used[min_ch][min_sb] = 2; /*   for allocation anymore */
       if(stereo == 2 && min_sb >= jsbound) {
         oth_ch = 1-min_ch;  /* joint-st : fix other ch */
         bit_alloc[oth_ch][min_sb] = bit_alloc[min_ch][min_sb];
         used[oth_ch][min_sb] = used[min_ch][min_sb];
         mnr[oth_ch][min_sb] = -perm_smr[oth_ch][min_sb]
                               + snr[bit_alloc[oth_ch][min_sb]];
       }
     }
   } while(min_sb>-1);     /* i.e. still some sub-bands to find */

   /* Calculate the number of bits left, add on to pointed var */
   ad -= bspl+bscf;
   *adb = ad;

   /* see how many channels are noisy */
   noisy_sbs = 0; small = mnr[0][0];
   for(k=0; k<stereo; ++k) {
     for(i = 0; i< SBLIMIT; ++i) {
		 if(mnr[k][i] < fr_ps->mnr_min)	 ++noisy_sbs;
       if(small > mnr[k][i])           small = mnr[k][i];
     }
   }
   return noisy_sbs;
}

/***************************** Layer II  ********************************/

int II_a_bit_allocation(double (*perm_smr)[32], unsigned int (*scfsi)[32], unsigned int (*bit_alloc)[32], int *adb, frame_params *fr_ps, int *aiff)
       /*far*/                        /* minimum masking level *//* JMZ 08/03/1995 Multilingual , WtK 7/8/95 */
          	                      /* flag for masking level */
{
	int n_ml_ch =fr_ps->header->multiling_ch; 	/*JMZ 08/03/95 Multilingual */
	int i, min_ch, min_sb, oth_ch, k, increment, scale, seli, ba, j, l;
	int increment1, scale1, seli1;
	int adb_hlp, adb_hlp1, adb_hlp2;
        int bspl, bscf, bsel, ad, noisy_sbs;
        int bspl_mpg1, bscf_mpg1, bsel_mpg1;
	double mnr[14][SBLIMIT], small;		/* JMZ 08/03/1995 Multilingual */
	char used[14][SBLIMIT];				/* JMZ 08/03/1995 Multilingual */
	int stereo	= fr_ps->stereo;
	int stereomc = fr_ps->stereomc;
        int sblimit = fr_ps->sblimit;
	int mlsblimit = fr_ps->mlsblimit;
	int jsbound = fr_ps->jsbound;
	int jsboundmc = fr_ps->jsboundmc;
	al_table *alloc = fr_ps->alloc;
	al_table *allocml = fr_ps->allocml;
	double dynsmr = 0.0;  /* border of SMR for dynamic datarate */
        static char init= 0;
	static int banc, berr;
        int bbal, bancmc, bancext, bbal_mpg1;
        int ll, pred, pci, adb_mpg1, sbgr, sb;
        static int sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */
    if (!init)
    { 
	  init = 1; banc = 32; /* banc: bits for header */;
	  if (fr_ps->header->error_protection) berr=16; else berr=0; /* added 92-08-11 shn */
    }
  
        pred = 0;
        bancmc = 0;
	bbal = 0;
	bbal_mpg1 = 0;
	bancext = 0;
	adb_mpg1 = bitrate[fr_ps->header->lay-1][fr_ps->header->bitrate_index] * 24;
	
  if( *aiff == 1)
  {
	 if(fr_ps->actual_mode == MPG_MD_JOINT_STEREO)
	 {
	         for (i = 0; i < jsbound; ++i)
		   bbal += (stereo+stereomc) * (*alloc)[i][0].bits;
		 for (i = jsbound; i < sblimit; ++i)
		   bbal += (stereo-1+stereomc) * (*alloc)[i][0].bits;
                 for (i = 0; i < mlsblimit; ++i)
		   bbal += (n_ml_ch) * (*allocml)[i][0].bits;

                 if (fr_ps->header->center == 3) bbal -= 41; 
	 }	  
	 else
	 {
	         for (i = 0; i < sblimit; ++i)
	           bbal += (stereo+stereomc) * (*alloc)[i][0].bits;
		 for (i = 0; i < mlsblimit; ++i)
	           bbal += (n_ml_ch) * (*allocml)[i][0].bits;
		 
		 if (fr_ps->header->center == 3) bbal -= 41; 
	 }
  }
  else
  {
	 for (i = 0; i < jsbound; ++i)
		  bbal += stereo * (*alloc)[i][0].bits;
         for (i = jsbound; i < sblimit; ++i)
		  bbal += (*alloc)[i][0].bits;
  }

    if(fr_ps->header->dyn_cross_on == 1)
    {
	for(i = 0; i < 12; i++)
	{
	    bbal -= dyn_bbal[fr_ps->header->dyn_cross[i]][i];
	}
    }	    
	

      if(fr_ps->header->ext_bit_stream_present == 0)
        bancmc += 35;      /* mc_header + crc + tc_sbgr_select+ dyn_cross_on + 
			    mc_prediction_on  01/05/94,  SR  new! 05/04/94,  SR*/
      else
      {
        bancmc += 43;			    
	bancext = 40;
      }
      			    
      if(fr_ps->header->tc_sbgr_select == 0)
	bancmc += 36;
      else
	bancmc += 3;	

      if(fr_ps->header->dyn_cross_on == 1)
      {
	  if(fr_ps->header->surround == 3)
	        bancmc += 61;      /* now with dyn_second_stereo,  17/02/95,  SR*/
	  else  bancmc += 49;
      }

      if(fr_ps->header->mc_prediction_on == 1)
      {
	for(i = 0; i < 8; i++)   /*now only 8 sb_groups, 05/04/94, SR*/
	{
	    bancmc += 1;
	    if(fr_ps->header->mc_pred[i] == 1)
	       bancmc += n_pred_coef[fr_ps->header->dyn_cross[i]] * 2;
	}
      }	


  for (i = 0; i < sblimit; i++) 
       for (k = 0; k < (stereo+stereomc+2); k++) 
       {
	  mnr[k][i]=snr[0]-perm_smr[k][i];
	  /* mask-to-noise-level = signal-to-noise-level - minimum-masking-*/
	  /* threshold*/

         bit_alloc[k][i] = 0;
         used[k][i] = 0;
       }
   
/********************************************************************/
/* JMZ 08/03/1995 Multilingual , 7/8/95 WtK */  
 
   for (i = 0; i < mlsblimit; i++) 
	for (k = 7; k < 7+n_ml_ch; k++) 
	{
	  mnr[k][i]=snr[0]-perm_smr[k][i];
	  /* mask-to-noise-level = signal-to-noise-level - minimum-masking-*/
	  /* threshold*/
  
	  bit_alloc[k][i] = 0;
	  used[k][i] = 0;
	}

/* JMZ 08/03/1995 Multilingual */   
/********************************************************************/
   
/******* 05/31/1995 SR   dynamic crosstalk! ****************************/
    /* dyamic crosstalk, lock sbgr which are use for dyncr. */
    if(fr_ps->header->dyn_cross_on == 1) {
	for(sbgr = 0; sbgr < SBGRS; sbgr++) {		
	    for(sb = ((sbgr == 0)?0:sb_groups[sbgr-1]+1); sb <= sb_groups[sbgr]; sb++) {
		switch(fr_ps->header->dyn_cross[sbgr]) {
	      case 0: 
		    break;
	      case 1: case 8: case 10: 
		    used[T4[sbgr]][sb] = 2;
		    break;
	      case 2: case 9: 
		    used[T3[sbgr]][sb] = 2;
		    break; 
	      case 3: 
		    used[T2[sbgr]][sb] = 2;
		    break;
	      case 4: case 11: case 12: case 14: 
		    used[T3[sbgr]][sb] = 2; 
		    used[T4[sbgr]][sb] = 2;
		    break;
	      case 5: case 13:
		    used[T2[sbgr]][sb] = 2; 
		    used[T4[sbgr]][sb] = 2;
		    break;
	      case 6: 
		    used[T2[sbgr]][sb] = 2; 
		    used[T3[sbgr]][sb] = 2;
		    break;
	      case 7: 
		    used[T2[sbgr]][sb] = 2; 
		    used[T4[sbgr]][sb] = 2; 	
		    used[T3[sbgr]][sb] = 2;
		    break;
		}
	    }	/* for(sb.. */
	}	/* for(sbgr.. */
    }		/* if(fr_ps.. */ 
       
/**********************************************************************/
 
    if(fr_ps->header->mc_prediction_on == 1)
    {
       for( i = 0; i < 8; i++) 
       {
	   if(fr_ps->header->mc_pred[i] == 1)
	   {
	       for(j = 0; j < n_pred_coef[fr_ps->header->dyn_cross[i]]; j++)
	       {
		   if(fr_ps->header->predsi[i][j] != 0)
		   {
		      pred += 3;
		      for(pci = 0; pci < fr_ps->header->predsi[i][j]; pci++)
			pred += 8;
		    }	
	       }
	   }
       }
    }  

    adb_hlp = *adb;

    if(*aiff != 1)
    {
	*adb -= bbal + berr + banc;
    }
    else 
    {
    	if(fr_ps->header->ext_bit_stream_present == 0)    
	    *adb -= bbal + berr + banc + bancmc + pred;
	else
	{
	    *adb = *adb - bbal - berr - banc - bancmc - pred - 
	    bancext - (fr_ps->header->n_ad_bytes * 8);
	    
            for(i = 0; i < jsbound; ++i)
		  bbal_mpg1 += stereo * (*alloc)[i][0].bits;
	    for(i = jsbound; i < sblimit; ++i)
		  bbal_mpg1 += (*alloc)[i][0].bits;

	    adb_mpg1 -= bbal_mpg1 + berr + banc + bancmc +
	     (fr_ps->header->n_ad_bytes * 8);
	}   
     }		    
        ad = *adb;
 
  
   bspl = bscf = bsel = bspl_mpg1 = bscf_mpg1 = bsel_mpg1 = 0;
 
   do  {
     /* locate the subband with minimum SMR */
	  small = 999999.0;
	  min_sb = -1;
	  min_ch = -1;

	for (i = 0; i < sblimit; i++)		  /* searching for the sb min SMR*/
	  for(j = 0; j < (stereo+stereomc); ++j)
	  {
	     if(fr_ps->header->tc_sbgr_select == 1)
	     {
	       if( i == 0) l = 0;
	       else
	       {
                   for(l = 1; l < 12; l++)
	              if((sb_groups[l-1] < i) && (i <= sb_groups[l])) break;
	        }
                k = transmission_channel[fr_ps->header->tc_allocation][j];
	     }  
	     else
	     { 
	       if(i == 0) 
               {
                   k = transmission_channel[fr_ps->header->tc_alloc[0]][j];
                   l = 0;
               }
	       else
	       {
                   for(l = 1; l < 12; l++)
                   {
	              if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
	              {
                          k = transmission_channel[fr_ps->header->tc_alloc[l]][j];
		          break;
	              }
		    }  
                }
	      }
	    
	    if((i >= 12) && (fr_ps->header->center == 3) && (k == 2))   
		used[k][i] = 2;

	     
	     if ((used[k][i] != 2) && (small > mnr[k][i])) 
	     {
                  small = mnr[k][i];
                  min_sb = i;  min_ch = k;
		  ll = l;		    /*sb-group*/
	     }
	   }  
/******************************************************************/
/* Multilingual JMZ 08/03/1995 */
if(n_ml_ch >0)
{
	for (i = 0; i < mlsblimit; i++)
	  for(j = 7; j < (n_ml_ch+7); ++j)
	  {
	     k=j;
	     if ((used[k][i] != 2) && (small > mnr[k][i])) 
	     {
                  small = mnr[k][i];
                  min_sb = i;  min_ch = k;
		  ll = l;		    
	     }
	}
}
/* Multilingual JMZ 08/03/1995 */
/******************************************************************/

     if(min_sb > -1) 
     {   /* there was something to find */
         /* find increase in bit allocation in subband [min] */
	 if (min_ch<7) 
	 {
	    increment = 12 * ((*alloc)[min_sb][bit_alloc[min_ch][min_sb]+1].group * 
			(*alloc)[min_sb][bit_alloc[min_ch][min_sb]+1].bits);
		        /* how many bits are needed */
            if (used[min_ch][min_sb])
             increment -= 12 * ((*alloc)[min_sb][bit_alloc[min_ch][min_sb]].group * 
                               (*alloc)[min_sb][bit_alloc[min_ch][min_sb]].bits);
	 } 
	 else /* MultiLingual 7/8/95 WtK */ 
	 {
            increment   = ((*allocml)[min_sb][bit_alloc[min_ch][min_sb]+1].group * 
			   (*allocml)[min_sb][bit_alloc[min_ch][min_sb]+1].bits);
	    if (used[min_ch][min_sb])
             increment -= ((*allocml)[min_sb][bit_alloc[min_ch][min_sb]].group * 
                           (*allocml)[min_sb][bit_alloc[min_ch][min_sb]].bits);
            if (fr_ps->header->multiling_fs==1) increment *=  6;
	    else                                increment *= 12;
	 }

       /* scale factor bits required for subband [min] */
       /* above js bound, need both chans */

       if((fr_ps->actual_mode == MPG_MD_JOINT_STEREO) && 
				    ((min_ch == 0) || (min_ch == 1)))
            oth_ch = 1 - min_ch;       
	    
       if (used[min_ch][min_sb]) scale = seli = 0;
       else 
       {			  /* this channel had no bits or scfs before */
         seli = 2;
         scale = 6 * sfsPerScfsi[scfsi[min_ch][min_sb]];
			if((fr_ps->actual_mode == MPG_MD_JOINT_STEREO) && (min_sb >= jsbound) &&
			      ((min_ch == 0) || (min_ch == 1))) 
			{
			  /* each new js sb has L+R scfsis */
				seli += 2;
		                scale += 6 * sfsPerScfsi[scfsi[oth_ch][min_sb]];
			}

/** 05/31/1995 SR   dynamic crosstalk! **/
			if(fr_ps->header->dyn_cross_on == 1)
			{
			    dyn_bal(scfsi, ll, fr_ps, min_ch, min_sb, 
				&seli, &scale);
			}
/**/
	
	}

       /* check to see enough bits were available for */
       /* increasing resolution in the minimum band */

       if(fr_ps->header->ext_bit_stream_present == 1) 
       {
        if((min_ch == 0) || (min_ch == 1))
	{
	    if (adb_mpg1 > bspl_mpg1 + bscf_mpg1 + bsel_mpg1 + seli + scale + increment) 
	    {
		bspl_mpg1 += increment;  /* bits for subband sample */
		bscf_mpg1 += scale;      /* bits for scale factor */
		bsel_mpg1 += seli;       /* bits for scfsi code */
	    }
	    else
		used[min_ch][min_sb] = 2;  /* can't increase this alloc */
	 }
       }
	
       
       if ((ad > bspl + bscf + bsel + seli + scale + increment) && (used[min_ch][min_sb] != 2)) 
       {

          ba = ++bit_alloc[min_ch][min_sb]; /* next up alloc */
          bspl += increment;  /* bits for subband sample */
          bscf += scale;      /* bits for scale factor */
          bsel += seli;       /* bits for scfsi code */
          used[min_ch][min_sb] = 1; /* subband has bits */

          if (min_ch<7) 
	  {
	    mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb] +
		                  snr[(*alloc)[min_sb][ba].quant+1];
		/* Check if subband has been fully allocated max bits */
            if (ba >= (1<<(*alloc)[min_sb][0].bits)-1) used[min_ch][min_sb] = 2;
          }
	  else /* MultiLingual 7/8/95 WtK */ 
	  {
            mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb] +
			          snr[(*allocml)[min_sb][ba].quant+1];
            if (ba >= (1<<(*allocml)[min_sb][0].bits)-1) used[min_ch][min_sb] = 2;
	  }
	}
	else used[min_ch][min_sb] = 2;  /* can't increase this alloc */
	
	
	
	  /****!!! here make a difference between the different JS-modes !!!!****/
	         
		 
						  
	         if((fr_ps->actual_mode == MPG_MD_JOINT_STEREO) && (min_sb >= jsbound) && (stereo == 2) &&
			 ((min_ch == 0) || (min_ch == 1))) 
	         {
                        /* above jsbound, alloc applies L+R */
                        ba = bit_alloc[oth_ch][min_sb] = bit_alloc[min_ch][min_sb];
 			used[oth_ch][min_sb] = used[min_ch][min_sb];
                        mnr[oth_ch][min_sb] = -perm_smr[oth_ch][min_sb] +
                               snr[(*alloc)[min_sb][ba].quant+1];
		 }
		 

/** 05/31/1995 SR   dyamic crosstalk! */
		 if(fr_ps->header->dyn_cross_on == 1)
			choose_dyn(fr_ps, min_ch, min_sb, ll, bit_alloc); 

	 }   /* end of if-loop if min_sb >-1 */
   } while(min_sb > -1);   /* until could find no channel */
   /* Calculate the number of bits left */

   ad -= bspl+bscf+bsel; 
   *adb = ad;
   for (i=  sblimit;i<SBLIMIT;i++) for (k = 0; k <  7; k++) bit_alloc[k][i]=0;
   for (i=mlsblimit;i<SBLIMIT;i++) for (k = 7; k < 14; k++) bit_alloc[k][i]=0;
 
 /*not used !?! perhaps later!! 8/21/93, SR*/
   noisy_sbs = 0;  small = mnr[0][0];      /* calc worst noise in case */
   for(k = 0; k < (stereo+stereomc); ++k)
   {
        for (i=0;i<sblimit;i++) 
	{
           if (small > mnr[k][i]) small = mnr[k][i];
	      if(mnr[k][i] < fr_ps->mnr_min) ++noisy_sbs; /* noise is not masked */
        }
    }

/* JMZ 08/03/1995 Multilingual , 7/8/95 WtK */
if(n_ml_ch>0)
 {
   for(k = 7; k < (7+n_ml_ch); ++k)
   {
        for (i=0;i<mlsblimit;i++) 
	{
           if (small > mnr[k][i]) small = mnr[k][i];
	      if(mnr[k][i] < fr_ps->mnr_min) ++noisy_sbs; /* noise is not masked */
        }
    }
 }
/* JMZ 08/03/1995 Multilingual */

   return noisy_sbs;
}
 
/************************************************************************
/*
/* I_subband_quantization  (Layer I)
/* II_subband_quantization (Layer II)
/* II_subband_quantisationmc (MPEG2)  SR
/* PURPOSE:Quantizes subband samples to appropriate number of bits
/*
/* SEMANTICS:  Subband samples are divided by their scalefactors, which
/* makes the quantization more efficient. The scaled samples are
/* quantized by the function a*x+b, where a and b are functions of
/* the number of quantization levels. The result is then truncated
/* to the appropriate number of bits and the MSB is inverted.
/*
/* Note that for fractional 2's complement, inverting the MSB for a
/* negative number x is equivalent to adding 1 to it.
/*
/************************************************************************/
 
static double a[17] = {
  0.750000000, 0.625000000, 0.875000000, 0.562500000, 0.937500000,
  0.968750000, 0.984375000, 0.992187500, 0.996093750, 0.998046875,
  0.999023438, 0.999511719, 0.999755859, 0.999877930, 0.999938965,
  0.999969482, 0.999984741 };
 
static double b[17] = {
  -0.250000000, -0.375000000, -0.125000000, -0.437500000, -0.062500000,
  -0.031250000, -0.015625000, -0.007812500, -0.003906250, -0.001953125,
  -0.000976563, -0.000488281, -0.000244141, -0.000122070, -0.000061035,
  -0.000030518, -0.000015259 };
 
/**************************************************/
/* 08/03/1995 JMZ Multilingual , 7/8/95 WtK */

void II_subband_quantization_ml(unsigned int (*scalar)[3][32], double (*sb_samples)[3][12][32], unsigned int (*j_scale)[3][32], double (*j_samps)[3][12][32], unsigned int (*bit_alloc)[32], unsigned int (*sbband)[3][12][32], frame_params *fr_ps)
{
   int i, j, k, s, n, qnt, sig, m, l, ll;
   int n_ml_ch   = fr_ps->header->multiling_ch;
   int mlsblimit = fr_ps->mlsblimit;
   int ml_lsf	 = fr_ps->header->multiling_fs;
   unsigned int stps;
   double d;
   al_table *allocml = fr_ps->allocml;
   
for (s=0;s<3;s++)
  for (j=0;j<((ml_lsf)?6:12);j++)    /* WtK half sample frequency 7/8/95 */
    for (i=0;i<mlsblimit;i++)
    {
	for (m = 7; m < 7+n_ml_ch; ++m)
	{
		k=m;
		if(bit_alloc[k][i]) {
			d = sb_samples[k][s][j][i] / multiple[scalar[k][s][i]];
			if (mod(d) >= 1.0) /* > changed to >=, 1992-11-06 shn */
			{ printf("In ML, not scaled properly, %d %d %d %d\n",k,s,j,i);
			  printf("Value %1.10f\n",sb_samples[k][s][j][i]);
			}
			qnt = (*allocml)[i][bit_alloc[k][i]].quant;
			d = d * a[qnt] + b[qnt];
			/* extract MSB N-1 bits from the floating point sample */
			if (d >= 0) sig = 1;
			else { sig = 0; d += 1.0; }
			n = 0;
			stps = (*allocml)[i][bit_alloc[k][i]].steps;
			while ((1L<<n) < stps) n++;
			n--;
			sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));
			  /* tag the inverted sign bit to sbband at position N */
			  /* The bit inversion is a must for grouping with 3,5,9 steps
			     so it is done for all subbands */
			if (sig) sbband[k][s][j][i] |= 1<<n;
		}
		else {
			sbband[k][s][j][i] = 0;
		}
	}
} 
for (s=0;s<3;s++)
  for (j=mlsblimit;j<SBLIMIT;j++)
    for (i=0;i<((ml_lsf)?6:12);i++) for (k = 7; k < 7+n_ml_ch; k++) sbband[k][s][i][j] = 0;
}
/* 08/03/1995 JMZ Multilingual */
/**************************************************/

void I_subband_quantization(unsigned int (*scalar)[3][32], double (*sb_samples)[3][12][32], unsigned int (*j_scale)[3][32], double (*j_samps)[3][12][32], unsigned int (*bit_alloc)[32], unsigned int (*sbband)[3][12][32], frame_params *fr_ps)
                                    
       /*far*/                               
                                    
       /*far*/                             /* L+R for j-stereo if necess */
                                   
             /*far*/                           
                    
{
   int i, j, k, n, sig;
   int stereo  = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   double d;
static char init = 0;

   if (!init) {
     init = 1;
     /* rearrange quantization coef to correspond to layer I table */
     a[1] = a[2]; b[1] = b[2];
     for (i=2;i<15;i++) { a[i] = a[i+2]; b[i] = b[i+2]; }
   }
   for (j=0;j<12;j++) for (i=0;i<SBLIMIT;i++)
     for (k=0;k<((i<jsbound)?stereo:1);k++)
       if (bit_alloc[k][i]) {
         /* for joint stereo mode, have to construct a single subband stream
            for the js channels.  At present, we calculate a set of mono
            subband samples and pass them through the scaling system to
            generate an alternate normalised sample stream.
 
            Could normalise both streams (divide by their scfs), then average
            them.  In bad conditions, this could give rise to spurious
            cancellations.  Instead, we could just select the sb stream from
            the larger channel (higher scf), in which case _that_ channel
            would be 'properly' reconstructed, and the mate would just be a
            scaled version.  Spec recommends averaging the two (unnormalised)
            subband channels, then normalising this new signal without
            actually sending this scale factor... This means looking ahead.
         */
         if(stereo == 2 && i>=jsbound)
           /* use the joint data passed in */
			  d = j_samps[0][0][j][i] / multiple[j_scale[0][0][i]];
         else
           d = sb_samples[k][0][j][i] / multiple[scalar[k][0][i]];
         /* scale and quantize floating point sample */
         n = bit_alloc[k][i];
         d = d * a[n-1] + b[n-1];
         /* extract MSB N-1 bits from the floating point sample */
         if (d >= 0) sig = 1;
         else { sig = 0; d += 1.0; }
         sbband[k][0][j][i] = (unsigned int) (d * (double) (1L<<n));
         /* tag the inverted sign bit to sbband at position N */
         if (sig) sbband[k][0][j][i] |= 1<<n;
       }
}
 
/***************************** Layer II  ********************************/
 
void II_subband_quantization(unsigned int (*scalar)[3][32], double (*sb_samples)[3][12][32], unsigned int (*j_scale)[3][32], double (*j_samps)[3][12][32], unsigned int (*bit_alloc)[32], unsigned int (*sbband)[3][12][32], frame_params *fr_ps)
                                    		/* 08/03/1995 JMZ Multilingual */
       /*far*/                                /* 08/03/1995 JMZ Multilingual */
                                    
       /*far*/                            
                                    		/* 08/03/1995 JMZ Multilingual */
             /*far*/                            /*08/03/1995 JMZ Multilingual*/
                    
{
   int i, j, k, s, n, qnt, sig, l, m;
   int stereo	= fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   unsigned int stps;
   double d;
   al_table *alloc = fr_ps->alloc;

   for (s=0;s<3;s++)
     for (j=0;j<12;j++)
       for (i=0;i<sblimit;i++)
         for (k=0;k<((i<jsbound)?stereo:1);k++)
	 {

	     if (bit_alloc[k][i])
	     {
               /* scale and quantize floating point sample */
               if(stereo == 2 && i>=jsbound)       /* use j-stereo samples */
	         d = j_samps[0][s][j][i] / multiple[j_scale[0][s][i]];
               else
                 d = sb_samples[k][s][j][i] / multiple[scalar[k][s][i]];

	       if (mod(d) >= 1.0) /* > changed to >=, 1992-11-06 shn */
	       {
         		printf("In compatible part, not scaled properly, %d %d %d %d\n",k,s,j,i);
			printf("Value %1.10f\n",sb_samples[k][s][j][i]);
			printf("Channel %d\n", k);
	       }
	       qnt = (*alloc)[i][bit_alloc[k][i]].quant;
               d = d * a[qnt] + b[qnt];
               /* extract MSB N-1 bits from the floating point sample */
               if (d >= 0) sig = 1;
               else { sig = 0; d += 1.0; }
               n = 0;
#ifndef MS_DOS
               stps = (*alloc)[i][bit_alloc[k][i]].steps;
               while ((1L<<n) < stps) n++;
#else
               while  ( ( (unsigned long)(1L<<(long)n) <
	              ( (unsigned long) ((*alloc)[i][bit_alloc[k][i]].steps)
                          & 0xffff)) && ( n <16)) n++;
#endif
               n--;
               sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));
               /* tag the inverted sign bit to sbband at position N */
               /* The bit inversion is a must for grouping with 3,5,9 steps
                so it is done for all subbands */
               if (sig) sbband[k][s][j][i] |= 1<<n;
	     } 
          }
           for (s=0;s<3;s++)
             for (j=sblimit;j<SBLIMIT;j++)
               for (i=0;i<12;i++) 
	         for (m=0;m<stereo;m++)
		 sbband[m][s][i][j] = 0;
}





void II_subband_quantizationmc(unsigned int (*scalar)[3][32], double (*sb_samples)[3][12][32], unsigned int (*j_scale)[3][32], double (*j_samps)[3][12][32], unsigned int (*bit_alloc)[32], unsigned int (*sbband)[3][12][32], frame_params *fr_ps)
                                    	/* 08/03/1995 JMZ Multilingual */
                                      	/* 08/03/1995 JMZ Multilingual */
                                    
                                  
                                    	/* 08/03/1995 JMZ Multilingual */
                                        /* 08/03/1995 JMZ Multilingual */
                    
{
   int i, j, k, s, n, qnt, sig, m, l, ll;
   int stereo	= fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int sblimit = fr_ps->sblimit;
   unsigned int stps;
   double d;
   al_table *alloc = fr_ps->alloc;

 


   for (s=0;s<3;s++)
     for (j=0;j<12;j++)
	 for (i=0;i<sblimit;i++)
	 {
	    if(i == 0)
		ll = 0;
	    else
	    {
                for(l = 1; l < 12; l++)
                  {
	            if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
		    {
                          ll = l;
			  break;
		     }  
		   }
	    }	   
          for (m = 2; m < 5; ++m)
	  {
	     if(fr_ps->header->tc_sbgr_select == 1)
               k = transmission_channel[fr_ps->header->tc_allocation][m];
	     else
	     {
               if(i == 0) k = transmission_channel[fr_ps->header->tc_alloc[0]][m];
	       else
	       {	     
                    k = transmission_channel[fr_ps->header->tc_alloc[ll]][m];
                }
	      }

	   if(fr_ps->header->dyn_cross_on == 1)
	   {
	       if(!dyn_ch[fr_ps->header->dyn_cross[ll]][m-2])
	       bit_alloc[k][i] = 0;

	   }
	    if(bit_alloc[k][i]) {
		d = sb_samples[k][s][j][i] / multiple[scalar[k][s][i]];
		    if (mod(d) >= 1.0) /* > changed to >=, 1992-11-06 shn */
		{
		    printf("In MC, not scaled properly, %d %d %d %d\n",k,s,j,i);
		    printf("Value %1.10f\n",sb_samples[k][s][j][i]);
		}
		qnt = (*alloc)[i][bit_alloc[k][i]].quant;
		d = d * a[qnt] + b[qnt];
		/* extract MSB N-1 bits from the floating point sample */
		if (d >= 0) sig = 1;
		else { sig = 0; d += 1.0; }
		n = 0;
#ifndef MS_DOS
		stps = (*alloc)[i][bit_alloc[k][i]].steps;
		while ((1L<<n) < stps) n++;
#else
		while  ( ( (unsigned long)(1L<<(long)n) <
			     ((unsigned long) ((*alloc)[i][bit_alloc[k][i]].steps)
			      & 0xffff
			     )
			  ) && ( n <16)
			) n++;
#endif
		n--;
		sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));
		/* tag the inverted sign bit to sbband at position N */
		/* The bit inversion is a must for grouping with 3,5,9 steps
		   so it is done for all subbands */
		if (sig) sbband[k][s][j][i] |= 1<<n;
	    }
	    else {
		sbband[k][s][j][i] = 0;
	    }
	 }
	} 
           for (s=0;s<3;s++)
             for (j=sblimit;j<SBLIMIT;j++)
		for (i=0;i<12;i++) for (k = 2; k < 7; k++) sbband[k][s][i][j] = 0;
}






 
/************************************************************************
/*
/* I_encode_bit_alloc  (Layer I)
/* II_encode_bit_alloc (Layer II)
/* II_encode_bit_allocmc (Layer II multichannel)
/*
/* PURPOSE:Writes bit allocation information onto bitstream
/*
/* Layer I uses 4 bits/subband for bit allocation information,
/* and Layer II uses 4,3,2, or 0 bits depending on the
/* quantization table used.
/*
/************************************************************************/
 
void I_encode_bit_alloc(unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)
{
   int i,k;
   int stereo  = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
 
   for (i=0;i<SBLIMIT;i++)
     for (k=0;k<((i<jsbound)?stereo:1);k++) putbits(bs,bit_alloc[k][i],4);
}
 
/***************************** Layer II  ********************************/
 
void II_encode_bit_alloc(unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)
                                    	/* 08/03/1995 JMZ Multilingual */
                    
                     
{
   int i,k;
   int stereo  = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   al_table *alloc = fr_ps->alloc;
 
	for (i=0;i<sblimit;i++)
	for (k=0;k<((i<jsbound)?stereo:1);k++)
     	{
		putbits(bs,bit_alloc[k][i],(*alloc)[i][0].bits);

       	}
}




void II_encode_bit_allocmc(unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)
                                    	/* 08/03/1995 JMZ Multilingual */
                    
                     
{
   int i,k, l, m;
   int stereomc	   = fr_ps->stereomc;
   int sblimit     = fr_ps->sblimit;
   int jsboundmc   = fr_ps->jsboundmc;
   al_table *alloc = fr_ps->alloc;
   int ll;
 

       for (i=0;i<sblimit;i++)
       {
	  for(m = 2; m < 2+stereomc; ++m)
          {        
	     if(fr_ps->header->tc_sbgr_select == 1)
	     {
               k = transmission_channel[fr_ps->header->tc_allocation][m];
               if(i == 0) ll = 0;
	       else
	       {
                  for(l = 1; l < 12; l++)
	            if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
		    {
		       ll = l;
		       break;
		     }	
	       }
	     }
	     else
	     {
               if(i == 0) 
	       {
		    k = transmission_channel[fr_ps->header->tc_alloc[0]][m];
		    ll = 0;
	       }
	       else
	       {	     
                  for(l = 1; l < 12; l++)
                  {
	            if((sb_groups[l-1] < i) && (i <= sb_groups[l])) 
	            {
                       k = transmission_channel[fr_ps->header->tc_alloc[l]][m];
		       ll = l;
		       break;
	            }
		  }  
                }
	      }

            if((fr_ps->header->center != 3) || (i < 12) || (k !=2))
	    {
	       if(dyn_ch[fr_ps->header->dyn_cross[ll]][m-2] == 1)
		  putbits(bs, bit_alloc[k][i], (*alloc)[i][0].bits);
	    }	
	}
    }	
}


/************************************************************************
/*
/* I_sample_encoding   (Layer I)
/* II_sample_encoding  (Layer II)
/* II_sample_encodingmc  (Layer II) SR
/*
/* PURPOSE:Put one frame of subband samples on to the bitstream
/*
/* SEMANTICS:  The number of bits allocated per sample is read from
/* the bit allocation information #bit_alloc#.  Layer 2
/* supports writing grouped samples for quantization steps
/* that are not a power of 2.
/*
/************************************************************************/
 
void I_sample_encoding(unsigned int (*sbband)[3][12][32], unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)
             /*far*/                           
                                   
                    
                     
{
   int i,j,k;
   int stereo  = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
 
   for(j=0;j<12;j++) {
     for(i=0;i<SBLIMIT;i++)
       for(k=0;k<((i<jsbound)?stereo:1);k++)
         if(bit_alloc[k][i]) putbits(bs,sbband[k][0][j][i],bit_alloc[k][i]+1);
   }
}
 
/***************************** Layer II  ********************************/
 
void II_sample_encoding(unsigned int (*sbband)[3][12][32], unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)
                                        	/* 08/03/1995 JMZ Multilingual */
                                    		/* 08/03/1995 JMZ Multilingual */
                    
                     
{
   unsigned int temp;
   unsigned int i,j,k,s,x,y;
   int stereo	= fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   int jsboundmc = fr_ps->jsboundmc;
   al_table *alloc = fr_ps->alloc;
 
   for (s=0;s<3;s++)
     for (j=0;j<12;j+=3)
       for (i=0;i<sblimit;i++)
         for (k=0;k<((i<jsbound)?stereo:1);k++)
           if (bit_alloc[k][i]) {
             if ((*alloc)[i][bit_alloc[k][i]].group == 3) {
               for (x=0;x<3;x++) putbits(bs,sbband[k][s][j+x][i],
                                      (*alloc)[i][bit_alloc[k][i]].bits);

            }
             else {
               y =(*alloc)[i][bit_alloc[k][i]].steps;
               temp = sbband[k][s][j][i] +
                      sbband[k][s][j+1][i] * y +
                      sbband[k][s][j+2][i] * y * y;
               putbits(bs,temp,(*alloc)[i][bit_alloc[k][i]].bits);

             }
           }
}




/******************* Layer II five channels ******************************/


void II_sample_encodingmc(unsigned int (*sbband)[3][12][32], unsigned int lfe_sbband[12], unsigned int (*bit_alloc)[32], unsigned int lfe_alloc, frame_params *fr_ps, Bit_stream_struc *bs)
{
   unsigned int temp;
   unsigned int i,j,k,s,x,y, l, m;
   int stereo	= fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int sblimit = fr_ps->sblimit;
   int jsboundmc = fr_ps->jsboundmc;
   al_table *alloc = fr_ps->alloc;
   int lfe  =     fr_ps->header->lfe;
   
   for (s=0;s<3;s++)
     for (j=0;j<12;j+=3)
     {
       if(lfe)
       {
         putbits(bs, lfe_sbband[s*4+j/3], (*alloc)[0][lfe_alloc].bits);
       }

       for (i=0;i<sblimit;i++)
         for (m = 2; m < 5; m++)
	 {
	     if(fr_ps->header->tc_sbgr_select == 1)
               k = transmission_channel[fr_ps->header->tc_allocation][m];
	     else
	     {
               if(i == 0) k = transmission_channel[fr_ps->header->tc_alloc[0]][m];
	       else
	       {	     
                  for(l = 1; l < 12; l++)
                  {
	            if((sb_groups[l-1] < i) && (i <= sb_groups[l])) 
	            {
                       k = transmission_channel[fr_ps->header->tc_alloc[l]][m];
		       break;
	            }
		  }  
                }
	      } 
	     
	 
           if (bit_alloc[k][i]) 
	   {
             if ((*alloc)[i][bit_alloc[k][i]].group == 3) 
	     {
			for (x = 0; x < 3; x++)
			 putbits(bs,sbband[k][s][j+x][i],
                                    (*alloc)[i][bit_alloc[k][i]].bits);

            }
             else 
	     {
               y =(*alloc)[i][bit_alloc[k][i]].steps;
               temp = sbband[k][s][j][i] +
                      sbband[k][s][j+1][i] * y +
                      sbband[k][s][j+2][i] * y * y;
               putbits(bs,temp,(*alloc)[i][bit_alloc[k][i]].bits);

             }
           }
	 }
   }	 
}

/************************************************************************
/*
/* encode_CRC
/*
/************************************************************************/
 
void encode_CRC(unsigned int crc, Bit_stream_struc *bs)
{
   putbits(bs, crc, 16);
}

/***************************************************************************
/*
/* tc_alloc  (Layer II, multichannel)
/*
/* PURPOSE: For each subbandgroup the three transmissionchannels are
/*          determined by taking the channel with the lowest level
/*          according to the tabel tc_allocation in the draft
/*  8/10/93, SR          
/* 
/*           changed to a certain limit of TC_ALLOC which must be stepped
/*           beyond, before there is channel-switching
/*           9/20/93 SR

/* JMZ 08/03/1995 Ajout pour traiter les differentes configurations 
/*		envisagees dans la norme
/**************************************************************************/

void tc_alloc(frame_params *fr_ps, double (*max_sc)[32])
{
	layer 	*info 	= fr_ps->header;	
	int 	center 	= info->center;		
	int 	surround = info->surround;	
	int 	matrix 	= info->matrix;		
    	int 	i, l, k;
    	int 	min;
    	double 	min1;
    	double 	min2[7][12];
	
    
/* if(matrix==3 || (matrix ==2 && center ==3)) ->tc_alloc=0
	else 	if(center==3)			->tc_alloc = 0,3,4,5
		else	if(matrix==2)		->tc_alloc = 0,1,2
			else			->tc_alloc = 0,1,2,3,4,5,6,7 */

/* 01/03/1995 JMZ Configuration 3/2 */
if(surround==2 && center !=0)
{

if(matrix==3 || (matrix ==2 && center ==3))
{
	for(i = 0; i < 12; i++)
	{
		fr_ps->header->tc_alloc[i] = 0;
	}
}
else	if(center==3) /* && matrix !=2 && matrix != 3 */
		{
			for(i = 0; i < 8; i++)
			{
				if(((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
				{
					if(max_sc[6][i] < max_sc[4][i])
						fr_ps->header->tc_alloc[i] = 5;
					else 	fr_ps->header->tc_alloc[i] = 3;
				}  
				else 	if(((20 * log10(max_sc[4][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
							fr_ps->header->tc_alloc[i] = 4;
						else   	fr_ps->header->tc_alloc[i] = 0; 
			} 
			
			for(i = 8; i < 12; i++)   
			for(k = 2; k < 7; k++)
				min2[k][i] = 0.0;	 
 
			for(i = 8; i < 12; i++)
			{
				for(k = 2; k < 7; k++)
				{
					for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
						{
							min2[k][i] += max_sc[k][l];	 
						}
					min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
				}

				if(((20 * log10(min2[3][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
				{
					if(min2[6][i] < min2[4][i])
						fr_ps->header->tc_alloc[i] = 5;
					else 	fr_ps->header->tc_alloc[i] = 3;
				}  
				else 	if(((20 * log10(min2[4][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
							fr_ps->header->tc_alloc[i] = 4;
						else   	fr_ps->header->tc_alloc[i] = 0; 
			} 
		}	
		else	
			if(matrix==2)	/* && center !=3 */
			{    
				for(i = 0; i < 8; i++)
				{
					if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
					{
						if(max_sc[6][i] < max_sc[5][i])
							fr_ps->header->tc_alloc[i] = 2;
						else 	
							fr_ps->header->tc_alloc[i] = 1;
					}  
					else 	if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
									fr_ps->header->tc_alloc[i] = 2;
							else   	fr_ps->header->tc_alloc[i] = 0; 
				} 
				
				for(i = 8; i < 12; i++)   
				for(k = 2; k < 7; k++)
					min2[k][i] = 0.0;	 
 
				for(i = 8; i < 12; i++)
				{
					for(k = 2; k < 7; k++)
					{
						for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
							{
								min2[k][i] += max_sc[k][l];	 
							}
						min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
					}

					if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
					{
						if(min2[6][i] < min2[5][i])
							fr_ps->header->tc_alloc[i] = 2;
						else 	
							fr_ps->header->tc_alloc[i] = 1;
					}  
					else 	if(((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
									fr_ps->header->tc_alloc[i] = 2;
							else   	fr_ps->header->tc_alloc[i] = 0; 
				} 
			}
			else
			{	
	
    for(i = 0; i < 8; i++)
    {
       if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
       {
           if(max_sc[6][i] < max_sc[5][i])
              min = 6;
	   else if(max_sc[6][i] == max_sc[5][i])
	   {
	       if(max_sc[3][i] <= max_sc[5][i])
	           min = 5;
	       else min = 6;	          
	   }
	   else min = 5;
       }  
       else if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
       {
	min = 6;
	/* 01/03/1995 JMZ Simplification */
       }  
       else   	  	    
       {
	      min = 2;
       }
	
	switch(min)
	{
	    case 5: if(max_sc[4][i] <= max_sc[6][i])  /* left front,Rs*/
	              fr_ps->header->tc_alloc[i] = 1;
		    else fr_ps->header->tc_alloc[i] = 7;  /*R*/
		    break;
	    case 6: if(max_sc[3][i] <= max_sc[5][i])  /* right front,Ls*/
	              fr_ps->header->tc_alloc[i] = 2;
		    else fr_ps->header->tc_alloc[i] = 6;  /* L */
		    break;		    
	    case 2: if(((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
	            {
	               if(max_sc[4][i] <= max_sc[6][i])  
		         fr_ps->header->tc_alloc[i] = 3;
		       else fr_ps->header->tc_alloc[i] = 5;
		    }  
		    else
		    {
	               if(((20 * log10(max_sc[4][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)  
		         fr_ps->header->tc_alloc[i] = 4;
		       else fr_ps->header->tc_alloc[i] = 0;
		    }    
		    break;
	}
  }

 for(i = 8; i < 12; i++)   
   for(k = 2; k < 7; k++)
        min2[k][i] = 0.0;	 
 
 
 for(i = 8; i < 12; i++)    /*taking the average scalefactor of each sb-group*/
 {
   for(k = 2; k < 7; k++)
   {
     for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
     {
        min2[k][i] += max_sc[k][l];	 
     }
   min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
   }

    if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
    {
        if(min2[6][i] < min2[5][i])
           min = 6;
        else if(min2[6][i] == min2[5][i])
	{
	       if(min2[3][i] <= min2[5][i])
	           min = 5;
	       else min = 6;	          
	}
        else min = 5;
    }  
    else if(((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
    {
	min = 6;
	/* 01/03/1995 JMZ Simplification */
    }  
    else   	  	    
    {
           min = 2;
    }
	
	switch(min)
	{
	    case 5: if(min2[4][i] <= min2[6][i])  /* left front,Rs*/
	              fr_ps->header->tc_alloc[i] = 1;
		    else fr_ps->header->tc_alloc[i] = 7;  /*R*/
		    break;
	    case 6: if(min2[3][i] <= min2[5][i])  /* right front,Ls*/
	              fr_ps->header->tc_alloc[i] = 2;
		    else fr_ps->header->tc_alloc[i] = 6;  /* L */
		    break;
	    case 2: if(((20 * log10(min2[3][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
	            {
	               if(min2[4][i] <= min2[6][i])  
		         fr_ps->header->tc_alloc[i] = 3;
		       else fr_ps->header->tc_alloc[i] = 5;
		    }  
		    else
		    {
	               if(((20 * log10(min2[4][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)  
		         fr_ps->header->tc_alloc[i] = 4;
		       else fr_ps->header->tc_alloc[i] = 0;
		    }    
		    break;
	}
   
 }
			}
}

/* 01/03/1995 JMZ Configuration 3/1 */
/**/
if (surround==1 && center !=0)
{

if(matrix==3 || (matrix ==2 && center ==3))
  {
    	for(i = 0; i < 12; i++)
	{
		fr_ps->header->tc_alloc[i] = 0;
	}
  }
else	if(center==3) /* && matrix !=2 && matrix != 3 */
	{
	for(i = 0; i < 8; i++)
	{
		if(((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
		{
			if(max_sc[6][i] < max_sc[5][i])
				fr_ps->header->tc_alloc[i] = 4;
			else 	fr_ps->header->tc_alloc[i] = 3;
		}  
		else 	if(((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
				fr_ps->header->tc_alloc[i] = 4;
			else   	fr_ps->header->tc_alloc[i] = 0; 
	} 
	
	for(i = 8; i < 12; i++)   
	for(k = 2; k < 7; k++)
		min2[k][i] = 0.0;	 
 
	for(i = 8; i < 12; i++)    
	{
		for(k = 2; k < 7; k++)
		{
			for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
			{
				min2[k][i] += max_sc[k][l];	 
			}
			min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
		}
		
		if(((20 * log10(min2[3][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
		{
			if(min2[6][i] < min2[5][i])
				fr_ps->header->tc_alloc[i] = 4;
			else 	
				fr_ps->header->tc_alloc[i] = 3;
		}  
		else 	
			if(((20 * log10(min2[3][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
				fr_ps->header->tc_alloc[i] = 4;
			else   	
				fr_ps->header->tc_alloc[i] = 0; 
	} 
	

	}	
	else	if(matrix==2)	/* && center !=3 */
		{    
		for(i = 0; i < 8; i++)
		{
			if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
			{
				if(max_sc[6][i] < max_sc[5][i])
					fr_ps->header->tc_alloc[i] = 2;
				else 	fr_ps->header->tc_alloc[i] = 1;
			}  
			else 	if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
					fr_ps->header->tc_alloc[i] = 2;
				else   	fr_ps->header->tc_alloc[i] = 0; 
		}
		 
		for(i = 8; i < 12; i++)   
		for(k = 2; k < 7; k++)
			min2[k][i] = 0.0;	 
 
		for(i = 8; i < 12; i++)    
		{
			for(k = 2; k < 7; k++)
			{
				for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
				{
					min2[k][i] += max_sc[k][l];	 
				}
				min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
			}
		
			if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
			{
				if(min2[6][i] < min2[5][i])
					fr_ps->header->tc_alloc[i] = 2;
				else 	
					fr_ps->header->tc_alloc[i] = 1;
			}  
			else 	
				if(((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
					fr_ps->header->tc_alloc[i] = 2;
				else   	
					fr_ps->header->tc_alloc[i] = 0; 
		}
		}
		else
			{	
	
 for(i = 0; i < 8; i++)
 {
	if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
	{
		if(max_sc[6][i] < max_sc[5][i])
			min = 6;
		else 	min = 5;
	}  
	else if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
		{
			min = 6;
		}  
		else   	  	    
		{
			min = 2;
		}
	
	switch(min)
	{
		case 5: 
			fr_ps->header->tc_alloc[i] = 1;
			break;

		case 6: 
			fr_ps->header->tc_alloc[i] = 2;
			break;
		    
		case 2: if(((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
			{
				if(max_sc[6][i] <= max_sc[5][i])  
					fr_ps->header->tc_alloc[i] = 4;
				else fr_ps->header->tc_alloc[i] = 3;
			}  
			else
			{
				if(((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)  
					fr_ps->header->tc_alloc[i] = 4;
				else fr_ps->header->tc_alloc[i] = 0;
			}    
			break;
	}
  }
 for(i = 8; i < 12; i++)   
 for(k = 2; k < 7; k++)
	min2[k][i] = 0.0;	 
 
 for(i = 8; i < 12; i++)
 {

   for(k = 2; k < 7; k++)
   {
     for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
     {
        min2[k][i] += max_sc[k][l];	 
     }
   min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
   }

	if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
	{
		if(min2[6][i] < min2[5][i])
			min = 6;
		else 	min = 5;
	}  
	else if(((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
		{
			min = 6;
		}  
		else   	  	    
		{
			min = 2;
		}
	
	switch(min)
	{
		case 5: 
			fr_ps->header->tc_alloc[i] = 1;
			break;

		case 6: 
			fr_ps->header->tc_alloc[i] = 2;
			break;
		    
		case 2: if(((20 * log10(min2[3][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
			{
				if(min2[6][i] <= min2[5][i])  
					fr_ps->header->tc_alloc[i] = 4;
				else fr_ps->header->tc_alloc[i] = 3;
			}  
			else
			{
				if(((20 * log10(min2[3][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)  
					fr_ps->header->tc_alloc[i] = 4;
				else fr_ps->header->tc_alloc[i] = 0;
			}    
			break;
	}
  }
			}
}
/*******************************************************************/
     
/* 01/03/1995 JMZ Configuration 3/0 (+2/0) */
/**/
if (center !=0 && (surround == 3 || surround ==0))
{

if(matrix==3 || center ==3)
  {
    	for(i = 0; i < 12; i++)
	{
		fr_ps->header->tc_alloc[i] = 0;
	}
  }
else	if(matrix==2) 
	{
		for(i = 0; i < 8; i++)
		{
			if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
			{
				if(max_sc[6][i] < max_sc[5][i])
					fr_ps->header->tc_alloc[i] = 2;
				else 	fr_ps->header->tc_alloc[i] = 1;
			}  
			else 	if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
					fr_ps->header->tc_alloc[i] = 2;
				else   	fr_ps->header->tc_alloc[i] = 0; 
		} 
		
		for(i = 8; i < 12; i++)   
		for(k = 2; k < 7; k++)
			min2[k][i] = 0.0;	 
 
		for(i = 8; i < 12; i++)    
		{
			for(k = 2; k < 7; k++)
			{
				for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
				{
					min2[k][i] += max_sc[k][l];	 
				}
				min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
			}
		
			if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
			{
				if(min2[6][i] < min2[5][i])
					fr_ps->header->tc_alloc[i] = 2;
				else 	fr_ps->header->tc_alloc[i] = 1;
			}  
			else 	if(((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
					fr_ps->header->tc_alloc[i] = 2;
				else   	fr_ps->header->tc_alloc[i] = 0; 
		} 
	}
	else
		{	
	
 for(i = 0; i < 8; i++)
 {
	if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
	{
		if(max_sc[6][i] < max_sc[5][i])
			min = 6;
		else	min = 5;
	}  
	else if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
		{
			min = 6;
		}  
		else   	  	    
		{
			min = 2;
		}
	
	switch(min)
	{
		case 5: 
			fr_ps->header->tc_alloc[i] = 1;
			break;

		case 6: 
			fr_ps->header->tc_alloc[i] = 2;
			break;
		    
		case 2: 
			fr_ps->header->tc_alloc[i] = 0;
			break;
	}
 }

 for(i = 8; i < 12; i++)   
 for(k = 2; k < 7; k++)
	min2[k][i] = 0.0;	 
 
 for(i = 8; i < 12; i++)
 {

   for(k = 2; k < 7; k++)
   {
     for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
     {
        min2[k][i] += max_sc[k][l];	 
     }
   min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
   }

	if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
	{
		if(min2[6][i] < min2[5][i])
			min = 6;
		else	min = 5;
	}  
	else if(((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
		{
			min = 6;
		}  
		else   	  	    
		{
			min = 2;
		}
	
	switch(min)
	{
		case 5: 
			fr_ps->header->tc_alloc[i] = 1;
			break;

		case 6: 
			fr_ps->header->tc_alloc[i] = 2;
			break;
		    
		case 2: 
			fr_ps->header->tc_alloc[i] = 0;
			break;
	}
 }
		}
}
/*******************************************************************/

/* 01/03/1995 JMZ et Configuration 2/1*/
/**/

if (center == 0 && surround ==1)
{

if(matrix==3 )
  {
    	for(i = 0; i < 12; i++)
	{
		fr_ps->header->tc_alloc[i] = 0;
	}
  }
else	
{
 for(i = 0; i < 8; i++)
 {
	if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
	{
		if(max_sc[6][i] < max_sc[5][i])
			min = 6;
		else	min = 5;
	}  
	else if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
		{
			min = 6;
		}  
		else   	  	    
		{
			min = 2;
		}
	
	switch(min)
	{
		case 5: 
			fr_ps->header->tc_alloc[i] = 1;
			break;

		case 6: 
			fr_ps->header->tc_alloc[i] = 2;
			break;
		    
		case 2: 
			fr_ps->header->tc_alloc[i] = 0;
			break;
	}
 }

 for(i = 8; i < 12; i++)   
 for(k = 2; k < 7; k++)
	min2[k][i] = 0.0;	 
 
 for(i = 8; i < 12; i++)
 {

   for(k = 2; k < 7; k++)
   {
     for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
     {
        min2[k][i] += max_sc[k][l];	 
     }
   min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
   }

	if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
	{
		if(min2[6][i] < min2[5][i])
			min = 6;
		else	min = 5;
	}  
	else if(((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
		{
			min = 6;
		}  
		else   	  	    
		{
			min = 2;
		}
	
	switch(min)
	{
		case 5: 
			fr_ps->header->tc_alloc[i] = 1;
			break;

		case 6: 
			fr_ps->header->tc_alloc[i] = 2;
			break;
		    
		case 2: 
			fr_ps->header->tc_alloc[i] = 0;
			break;
	}
 }
}
}
/*******************************************************************/

/* 01/03/1995 JMZ Configuration 2/2 */
/**/

if (center == 0 && surround == 2)
{

if(matrix==3 )
  {
    	for(i = 0; i < 12; i++)
	{
		fr_ps->header->tc_alloc[i] = 0;
	}
  }
else	
{
 for(i = 0; i < 8; i++)
 {
	if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
	{
		if(max_sc[6][i] < max_sc[3][i])
			fr_ps->header->tc_alloc[i] = 3;
		else 	
			fr_ps->header->tc_alloc[i] = 2;
	}  
	else if(((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
		{
			fr_ps->header->tc_alloc[i] = 1;
		}  
		else   	  	    
		{
			fr_ps->header->tc_alloc[i] = 0;
		}
 }

 for(i = 8; i < 12; i++)   
 for(k = 2; k < 7; k++)
	min2[k][i] = 0.0;	 
 
 for(i = 8; i < 12; i++)
 {

   for(k = 2; k < 7; k++)
   {
     for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
     {
        min2[k][i] += max_sc[k][l];	 
     }
   min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
   }

	if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
	{
		if(min2[6][i] < min2[3][i])
			fr_ps->header->tc_alloc[i] = 3;
		else 	
			fr_ps->header->tc_alloc[i] = 2;
	}  
	else if(((20 * log10(min2[3][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
		{
			fr_ps->header->tc_alloc[i] = 1;
		}  
		else   	  	    
		{
			fr_ps->header->tc_alloc[i] = 0;
		}
 }
 }
 }
 
/*******************************************************************/
     
    if(fr_ps->header->tc_alloc[0] == fr_ps->header->tc_alloc[1] &&
       fr_ps->header->tc_alloc[1] == fr_ps->header->tc_alloc[2] &&
       fr_ps->header->tc_alloc[2] == fr_ps->header->tc_alloc[3] &&
       fr_ps->header->tc_alloc[3] == fr_ps->header->tc_alloc[4] &&
       fr_ps->header->tc_alloc[4] == fr_ps->header->tc_alloc[5] &&
       fr_ps->header->tc_alloc[5] == fr_ps->header->tc_alloc[6] &&
       fr_ps->header->tc_alloc[6] == fr_ps->header->tc_alloc[7] &&
       fr_ps->header->tc_alloc[7] == fr_ps->header->tc_alloc[8] &&
       fr_ps->header->tc_alloc[8] == fr_ps->header->tc_alloc[9] &&
       fr_ps->header->tc_alloc[9] == fr_ps->header->tc_alloc[10] &&
       fr_ps->header->tc_alloc[10] == fr_ps->header->tc_alloc[11])
       {
          fr_ps->header->tc_sbgr_select = 1;
          fr_ps->header->tc_allocation = fr_ps->header->tc_alloc[0];
       }
      else fr_ps->header->tc_sbgr_select = 0; /* added 8/20/93,SR*/ 
}


/***************************************************************************
/*
/* ancillary_encode 
/*
/* PURPOSE: The use of ancillary part of the bitstream for information  
/*          storage.
/*         
/*        
/**************************************************************************/

void ancillary_encode(fr_ps,bs,adb)
frame_params *fr_ps;
Bit_stream_struc *bs;
int adb;
{
    int bitsPerSlot; 
    int	samplesPerFrame;
    int	bit_rate;
    int	avg_slots_per_frame;
    int	whole_SpF;
    int	usedAdb;
    int	adbNumberStart;
    int l;
    char *mesg="This bitstream use ancillary part.";
    extern int mesg_index;

    register int i;


    double frac_SpF;
    double slot_lag;
    layer *info = fr_ps->header;


    if (info->lay == 1) { bitsPerSlot = 32; samplesPerFrame = 384;  }
    else               { bitsPerSlot = 8;  samplesPerFrame = 1152; }

    bit_rate = bitrate[info->lay-1][info->bitrate_index];

    avg_slots_per_frame = ((double)samplesPerFrame /
                           s_freq[info->sampling_frequency]) *
                          ((double)bit_rate / (double)bitsPerSlot);
    whole_SpF = (int) avg_slots_per_frame;	 

    adbNumberStart = (whole_SpF+info->padding) * bitsPerSlot;
    usedAdb = adbNumberStart - adb;

    if(usedAdb <= (adbNumberStart-8)) {
	if(usedAdb % 8) {
	   for(i=0;i<(8-(usedAdb%8));i++)
	      put1bit(bs,0);
	   usedAdb += (8 - (usedAdb % 8));
	}
	while(usedAdb < adbNumberStart - 8) {
	   for(i=0;i<8;i++)
	      put1bit(bs,0);
	   usedAdb += 8;
	}
	if(mesg_index >= strlen(mesg)){
	   for(i=0;i<8;i++)
	      put1bit(bs,0);
	} else {
	   putbits(bs,(int)(mesg[mesg_index++]), 8);
	}
   } else {
	for(i=0;i<adb;i++)
	   put1bit(bs,0);
   }

}


   	


	
   	


@


1.8
log
@Added verbosity switch to control text output.
@
text
@d2 2
a3 7
 * Copyright (c) 1995 MPEG/audio software simulation group
 * All Rights Reserved
 * $Id: encode.c 1.7 1996/01/20 17:13:10 rowlands Exp rowlands $
 *
 * MPEG/audio coding/decoding software, work in progress
 *   NOT for public distribution until verified and approved by the
 *   MPEG/audio committee.
d5 2
a7 6
 * Revision 1.7  1996/01/20 17:13:10  rowlands
 * Moved Merged into main trunk
 *
 * Revision 1.6.3.1  1996/01/19  04:40:26  rowlands
 * Merged
 *
d9 1
a9 1
 * Received from Uwe Felderhoff
a10 3
 * Revision 1.6.1.1  1995/11/06  04:12:25  rowlands
 * Received from Warner ten Kate
 *
d12 1
a12 1
 * ML-LSF added WtK 7/8/95
a20 6
 * Revision 1.6  1995/06/16  10:01:27  rowlands
 * Moved merged IRT/Samsung/TI into main revision control trunk.
 *
 * Revision 1.4.3.2  1995/06/16  09:57:51  rowlands
 * Merged and tested revisions 1.5 and 1.4.3.1
 *
d22 1
a22 1
 * Input from Samsung AIT.
a23 9
 * Revision 1.5  1995/06/16  06:29:49  rowlands
 * Moved merged IRT/TI into main revision control trunk.
 *
 * Revision 1.4.2.3  1995/06/16  06:25:24  rowlands
 * Merged and tested revisions 1.4.1.6 and 1.4.2.2
 *
 * Revision 1.4.2.2  1995/06/16  04:45:49  rowlands
 * Merged TI and IRT mods using #ifdef _IRT
 *
d25 1
a25 1
 * Input from IRT
a46 6
 * Revision 1.4.1.0  1995/05/25  03:35:25  rowlands
 * Created branch for TI
 *
 * Revision 1.4  1995/04/06  04:29:39  rowlands
 * Added header and RCS info to initial revision.
 *
a49 2
 * VERSION 2.5                                                        *
 *   changes made since last update:                                  *
d137 1
a137 1
 *  Version 1.0 Shareware                                             *
d143 1
a143 1
 *  Version 1.1 Shareware                                             *
@


1.7
log
@Moved Merged into main trunk
@
text
@d4 1
a4 1
 * $Id: encode.c 1.6.3.1 1996/01/19 04:40:26 rowlands Exp $
d11 3
d250 1
a250 1
		  printf("Hit end of audio data\n");
d256 1
a256 1
		  printf("Hit end of audio data\n");
d262 1
a262 1
        printf("Insufficient PCM input for one frame - fillout with zeros\n");
d2084 1
a2084 1
	printf("bits_for_nonoise\n");
d3133 1
a3133 1
			{ printf("Not scaled properly, %d %d %d %d\n",k,s,j,i);
d3255 1
a3255 1
         		printf("Not scaled properly, %d %d %d %d\n",k,s,j,i);
d3352 1
a3352 1
		    printf("Not scaled properly, %d %d %d %d\n",k,s,j,i);
@


1.6
log
@Moved merged IRT/Samsung/TI into main revision control trunk.
@
text
@d4 1
a4 1
 * $Id: encode.c 1.4.3.2 1995/06/16 09:57:51 rowlands Exp $
d11 22
d231 1
a231 1
short pcm_sample_buffer[5760];        /*for correct reading of pcm-data*/
d254 1
a254 1
            for(i = 0; i < 5760; ++i) sample_buffer[i] = pcm_sample_buffer[i];
d299 2
a300 2
	int j, i;
	long insamp[5760];
d303 1
d307 2
a308 1
 
d364 5
a368 1
		if(((stereo + stereomc) == 5) && (aiff_ptr->numChannels == 5))
d371 1
a371 1
			info->center = 1;
d375 1
a375 1
				(unsigned long) 5760, byte_per_sample, aiff);
d378 7
a384 5
				buffer[0][j] = insamp[5*j];
				buffer[1][j] = insamp[5*j+1];
				buffer[2][j] = insamp[5*j+2];
				buffer[3][j] = insamp[5*j+3];
				buffer[4][j] = insamp[5*j+4];
a385 2
			
			matricing_fft(buffer, buffer_matr, fr_ps, dematrix2_filter_state);
d387 1
a387 1
		else if(( stereo == 0) && ( aiff_ptr->numChannels == 5))
d394 1
a394 1
				(unsigned long) 5760,byte_per_sample, aiff);
d399 5
a403 3
				buffer[2][j] = insamp[5*j+2];
				buffer[3][j] = insamp[5*j+3];
				buffer[4][j] = insamp[5*j+4];
d406 1
a406 1
		else if(( stereomc == 0) && ( aiff_ptr->numChannels == 5))
d413 1
a413 1
				(unsigned long) 5760, byte_per_sample, aiff);
d416 2
a417 2
				buffer[0][j] = insamp[5*j];
				buffer[1][j] = insamp[5*j+1];
d421 2
d473 1
a473 1
				(unsigned long) 2304, byte_per_sample, aiff);
d476 2
a477 2
				buffer[0][j] = insamp[2*j];
				buffer[1][j] = insamp[2*j+1];
d481 2
d501 31
d547 4
d629 1
a629 1
  double matrC;		/* weighting factor for C */
d631 1
d645 1
d651 1
d657 1
d680 8
a687 2
			sb_sample[0][j][l][k] = compatibleLeft;
			sb_sample[1][j][l][k] = compatibleRight;
d689 20
a783 2
/* 8/10/93 SR
/* Channel 5 and 6 are the not matriced signals L and R
d785 15
d820 1
d824 2
d851 5
a855 5
     buffer_matr[5][i] = buffer[0][i];
     buffer_matr[6][i] = buffer[1][i];
     buffer_matr[2][i] = buffer[2][i];
     buffer_matr[3][i] = buffer[3][i];
     buffer_matr[4][i] = buffer[4][i];
d860 2
a861 2
	buffer_matr[0][i] = matrNorm*(buffer[0][i] + matrC*buffer[2][i] + matrLsRs*buffer[3][i]);
	buffer_matr[1][i] = matrNorm*(buffer[1][i] + matrC*buffer[2][i] + matrLsRs*buffer[4][i]);
d868 2
a869 1
	mono_surround = (buffer[3][i] + buffer[4][i]) / 2.0;
d1109 1
a1109 1
#endif VERY_FAST_FILTER
d1297 1
a1297 1
/* of the 12 subband samples
d1303 2
a1304 2
/* Layer II has three sets of 12-subband samples for a given
/* subband.
d1333 3
a1335 5
void II_scale_factor_calc(double (*sb_sample)[3][12][32], unsigned int (*scalar)[3][32], int sblimit, int l, int m)
                                              /* 08/03/1995 JMZ Multilingual */
                                    		/* 08/03/1995 JMZ Multilingual */
            
         
d1337 1
a1337 1
  int i,j, k,t;
d1339 1
d1341 3
d1347 1
a1347 1
	for (j=1, s[i] = mod(sb_sample[k][t][0][i]);j<SCALE_BLOCK;j++)
d1420 1
d1434 1
a1434 1
  for (k = l; k < m; k++)
d1438 2
a1439 2
  for (i=sblimit;i<SBLIMIT;i++) max_sc[0][i] = max_sc[1][i] = 1E-20;
  
d1447 1
d1449 1
a1449 1
/* JMZ 08/03/1995 Multilingual */
d1453 2
a1454 2
  for (k = 7; k < 7+n_ml_ch; k++)
    for (i=0;i<sblimit;max_sc[k][i] = multiple[max], i++)
d1457 1
a1457 10
  for (i=sblimit;i<SBLIMIT;i++) 
	{
	max_sc[7+0][i] =1E-20; 
	if (n_ml_ch >1) max_sc[7+1][i] =1E-20;
	if (n_ml_ch >2) max_sc[7+2][i] =1E-20;
	if (n_ml_ch >3) max_sc[7+3][i] =1E-20;
	if (n_ml_ch >4) max_sc[7+4][i] =1E-20;
	if (n_ml_ch >5) max_sc[7+5][i] =1E-20;
	if (n_ml_ch >6) max_sc[7+6][i] =1E-20;
	}
d1459 1
d1700 1
d1758 1
a1758 1
     for (i=0;i<sblimit;i++) 
d1833 2
d1842 1
d1901 4
d1946 1
a1946 1
/*JMZ 24/2/95 Multilingual */
a1947 6
                                                         	/*JMZ 24/2/95 Multilingual */
                                    		/*JMZ 24/2/95 Multilingual */
                    
                     
       
       
d1949 2
a1950 2
   int stereo  = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
d1953 2
a1954 3
 
for (i=0;i<sblimit;i++)
for (m = *l; m < *z; m++)	/* JMZ 10/03/1995 Multilingual */
a1957 1
		{
a1958 2

		}
d1960 2
a1961 3
 
for (i=0;i<sblimit;i++)
for (m = *l;m < *z; m++)	/* JMZ 10/03/1995 Multilingual */
a1968 1

a1972 1

d1975 1
a1975 1

d2069 1
d2072 1
d2081 2
d2112 1
d2114 1
a2114 2
	  bbal += (stereo+stereomc+n_ml_ch) * (*alloc)[sb][0].bits;  /* 23/03/1995 JMZ Multilingual */
	  
d2116 4
a2119 2
	  bbal += (stereo-1+stereomc+n_ml_ch) * (*alloc)[sb][0].bits;  /* 23/03/1995 JMZ Multilingual */      	 
	  
a2121 1

d2163 1
a2163 1
for(sb = 0; sb < jsbound; ++sb)
d2167 1
a2167 1
		maxAlloc = (1<<(*alloc)[sb][0].bits)-1;
d2170 1
a2170 1
			if( (-perm_smr[ch][sb] + snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)])
d2175 4
a2178 1
			smp_bits = 12 * ((*alloc)[sb][ba].group * (*alloc)[sb][ba].bits);
a2182 7
			if(stereo == 2 && sb >= jsbound) 
				{
				/* each new js sb has L+R scfsis*/
				sel_bits += 2;
				sc_bits  += 6 * sfsPerScfsi[scfsi[1-ch][sb]];
				} 

a2193 4

 
 
 
a2197 6
       /*far*/                      
                               
                    
       
       
          
d2204 1
d2207 1
d2226 2
a2227 2
              if(ba>0) 
		{
d2232 4
a2235 4

	          req_bits += smp_bits+sel_bits+sc_bits;
                 }
	    }
d2237 21
a2257 1
/* 23/03/1995 JMZ Multilingual */
d2259 4
a2262 16
	    if (n_ml_ch>0)
	    {
			for(ch = 7; ch < 7+n_ml_ch; ++ch) 
			{
			maxAlloc = (1<<(*alloc)[sb][0].bits)-1;
			sel_bits = sc_bits = smp_bits = 0;
			for(ba = 0; ba < maxAlloc-1; ++ba)
			if( (-perm_smr[ch][sb] + snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)])
				 >= fr_ps->mnr_min)
				break;		/* we found enough bits */
			if(ba>0) 
				{
				smp_bits = 12 * ((*alloc)[sb][ba].group * (*alloc)[sb][ba].bits);
                 /* scale factor bits required for subband */
				sel_bits = 2;
				sc_bits  = 6 * sfsPerScfsi[scfsi[ch][sb]];
a2263 4
				req_bits += smp_bits+sel_bits+sc_bits;
				}
			}
		}
d2266 1
a2266 3
	    
   }
   return req_bits;
d2626 2
a2627 6
       /*far*/                        /* minimum masking level *//* JMZ 08/03/1995 Multilingual */
                                		/* JMZ 08/03/1995 Multilingual */
                                    	/* JMZ 08/03/1995 Multilingual */
         
                    
          	 /* flag for masking level */
d2640 1
d2644 1
d2668 8
a2675 12
	                     /*JS Lo + Ro */
		 for(i = 0; i < jsbound; ++i)
		 	{
		  /*bbal += 5 * (*alloc)[i][0].bits; JMZ Multilingual 20/03/1995*/
		  bbal += (stereo+stereomc+n_ml_ch) * (*alloc)[i][0].bits;
		  	}
		 for(i = jsbound; i < sblimit; ++i)
		 	{
		  /*bbal += 4 * (*alloc)[i][0].bits; JMZ Multilingual 20/03/1995*/
		  bbal += (stereo+stereomc+n_ml_ch-1) * (*alloc)[i][0].bits;
		  	}
		 if(fr_ps->header->center == 3) bbal -= 41; 
d2679 6
a2684 7
	 
	        for( i = 0; i < sblimit; ++i)
	        	{
		  /*bbal += 5 * (*alloc)[i][0].bits; JMZ Multilingual 20/03/1995*/
		  bbal += (stereo+stereomc+n_ml_ch) * (*alloc)[i][0].bits;
		  		}
		 if(fr_ps->header->center == 3) bbal -= 41; 
d2689 1
a2689 1
	 for(i = 0; i < jsbound; ++i)
d2691 1
a2691 1
		 for(i = jsbound; i < sblimit; ++i)
d2748 1
a2748 1
/* JMZ 08/03/1995 Multilingual */  
d2750 4
a2753 4
	for (i = 0; i < sblimit; i++) 
		for (k = 7; k < 7+n_ml_ch; k++) 
		{
		mnr[k][i]=snr[0]-perm_smr[k][i];
d2756 4
a2760 4
		bit_alloc[k][i] = 0;
		used[k][i] = 0;
		}

d2907 1
a2907 1
	for (i = 0; i < sblimit; i++)
d2925 3
a2927 1
	    increment = 12 * ((*alloc)[min_sb][bit_alloc[min_ch][min_sb]+1].group *
d2929 15
a2943 1
		 /* how many bits are needed */
a2944 6
       if (used[min_ch][min_sb])
         increment -= 12 * ((*alloc)[min_sb][bit_alloc[min_ch][min_sb]].group*
                           (*alloc)[min_sb][bit_alloc[min_ch][min_sb]].bits);



a3001 2
          mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb] +
			 snr[(*alloc)[min_sb][ba].quant+1];
d3003 4
a3006 1
			  
d3008 8
a3015 1
          if (ba >= (1<<(*alloc)[min_sb][0].bits)-1) used[min_ch][min_sb] = 2;
d3046 2
a3047 2
   for (i=sblimit;i<SBLIMIT;i++) for (k = 0; k < 14; k++) /*for all 14 channels, 8/21/93,SR*/ /*JMZ 08/03/1995 Multilingual */
      bit_alloc[k][i]=0;
a3048 1
 
a3056 1

d3060 1
a3060 1
/* JMZ 08/03/1995 Multilingual */
d3065 1
a3065 1
        for (i=0;i<sblimit;i++) 
a3068 1

d3108 1
a3108 1
/* 08/03/1995 JMZ Multilingual */
a3110 7
                                    
                                      
                                    
                                  
                                    
                                         /*10/03/1995 JMZ Multilingual */
                    
d3113 3
a3115 3
   int stereo	= fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int sblimit = fr_ps->sblimit;
d3118 2
a3119 3
   al_table *alloc = fr_ps->alloc;
   int n_ml_ch = fr_ps->header->multiling_ch;

d3121 3
a3123 3
for (j=0;j<12;j++)
for (i=0;i<sblimit;i++)
{
d3133 1
a3133 1
			qnt = (*alloc)[i][bit_alloc[k][i]].quant;
d3139 1
a3139 1
			stps = (*alloc)[i][bit_alloc[k][i]].steps;
d3154 2
a3155 2
for (j=sblimit;j<SBLIMIT;j++)
for (i=0;i<12;i++) for (k = 7; k < 7+n_ml_ch; k++) sbband[k][s][i][j] = 0;
d3447 1
a3447 1
   int stereo	   = fr_ps->stereomc;
d3456 1
a3456 3
	
/*	  for(m = 2; m < 5; ++m) 21/03/1995 JMZ Multimode */
	  for(m = 2; m < 2+stereo; ++m)
d3580 1
a3580 5
void II_sample_encodingmc(unsigned int (*sbband)[3][12][32], unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)
                                        	/* 08/03/1995 JMZ Multilingual */
                                    		/* 08/03/1995 JMZ Multilingual */
                    
                     
d3589 1
d3593 6
d3641 1
@


1.6.3.0
log
@Branch for merging IRT_02 and Philips_01
@
text
@d4 1
a4 1
 * $Id: encode.c 1.6 1995/06/16 10:01:27 rowlands Exp $
a10 3
 * Revision 1.6  1995/06/16  10:01:27  rowlands
 * Moved merged IRT/Samsung/TI into main revision control trunk.
 *
@


1.6.3.1
log
@Merged
@
text
@d4 1
a4 1
 * $Id: encode.c 1.6.1.1 1995/11/06 04:12:25 rowlands Exp $
a10 16
 * Revision 1.6.2.1  1995/11/06  04:19:12  rowlands
 * Received from Uwe Felderhoff
 *
 * Revision 1.6.1.1  1995/11/06  04:12:25  rowlands
 * Received from Warner ten Kate
 *
 * Revision 1.8  1995/08/14  07:53:28  tenkate
 * ML-LSF added WtK 7/8/95
 * variables "alloc" and "sblimit" changed into "allocml" and
 * "mlsblimit" where appropriate.
 * sample loops adapted to 12 or 6 depending on full or half fs.
 * II_a_bit_allocation separate summing for ML.
 *
 * Revision 1.7  1995/07/31  07:48:55  tenkate
 * addition of phantom coding, in void matricing(), 25/07/95 WtK
 *
d212 1
a212 1
short pcm_sample_buffer[6912];        /*for correct reading of pcm-data*/
d235 1
a235 1
            for(i = 0; i < 6912; ++i) sample_buffer[i] = pcm_sample_buffer[i];
d280 2
a281 2
	int k, j, i;
	long insamp[6912];
a283 1
        int lfe;
d287 1
a287 2
        lfe = info->lfe;

d343 1
a343 5
                if(lfe)
                  k = 6;
                else
                  k = 5;
		if(((stereo + stereomc) == 5) && (aiff_ptr->numChannels == k))
d346 1
a346 1
			info->center = 1; /* will be set to 3 subsequently if (phantom_c==1) */
d350 1
a350 1
				(unsigned long) (k*1152), byte_per_sample, aiff);
d353 5
a357 7
				buffer[0][j] = insamp[k*j];
				buffer[1][j] = insamp[k*j+1];
				buffer[2][j] = insamp[k*j+2];
				buffer[3][j] = insamp[k*j+3];
				buffer[4][j] = insamp[k*j+4];
                                if(lfe)
				  buffer[5][j] = insamp[k*j+5];
d359 2
d362 1
a362 1
		else if(( stereo == 0) && ( aiff_ptr->numChannels == k))
d369 1
a369 1
				(unsigned long) (k*1152),byte_per_sample, aiff);
d374 3
a376 5
				buffer[2][j] = insamp[k*j+2];
				buffer[3][j] = insamp[k*j+3];
				buffer[4][j] = insamp[k*j+4];
                                if(lfe)
                                  buffer[5][j] = insamp[6*j+5];   
d379 1
a379 1
		else if(( stereomc == 0) && ( aiff_ptr->numChannels == k))
d386 1
a386 1
				(unsigned long) (k*1152), byte_per_sample, aiff);
d389 2
a390 2
				buffer[0][j] = insamp[k*j];
				buffer[1][j] = insamp[k*j+1];
a393 2
                                if(lfe)
                                  buffer[5][j] = insamp[6*j+2];
d444 1
a444 1
				(unsigned long) ((k-3)*1152), byte_per_sample, aiff);
d447 2
a448 2
				buffer[0][j] = insamp[(k-3)*j];
				buffer[1][j] = insamp[(k-3)*j+1];
a451 2
                                if(lfe)
                                  buffer[1][j] = insamp[3*j+2]; /* ########### */
a469 31

	/*
	 * If LFE is not enabled, "buffer" contains:
	 *	buffer[0]	L
	 *	buffer[1]	R
	 *	buffer[2]	C
	 *	buffer[3]	Ls
	 *	buffer[4]	Rs
	 *
	 * If LFE is enabled, "buffer" contains:
	 *	buffer[0]	L
	 *	buffer[1]	R
	 *	buffer[2]	C
	 *	buffer[3]	LFE
	 *	buffer[4]	Ls
	 *	buffer[5]	Rs
	 */

	matricing_fft(buffer, buffer_matr, fr_ps, dematrix2_filter_state);

	/*
	 * After matrixing, "buffer_matr" contains:
	 *	buffer_matr[0]	Lo
	 *	buffer_matr[1]	Ro
	 *	buffer_matr[2]	C
	 *	buffer_matr[3]	Ls
	 *	buffer_matr[4]	Rs
	 *	buffer_matr[5]	L
	 *	buffer_matr[6]	R
	 */

a484 4
/*
/* If phantom coding is used the high-frequency part of the
/* center signal is matrixed to left and right.
/* 27/07/95 WtK
d563 1
a563 1
  double matrC,matrPC;	/* weighting factor for C, Phantom C */
a564 1
  register double val;
a577 1
	      matrPC	= 1;
a582 1
	      matrPC	= 1;
a587 1
	      matrPC	= 1 / sqrt(2.0);
d610 2
a611 8
/* #if	defined(DIFF_1) || defined(DIFF_3) */	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */ /* ########## */
/*			sb_sample[0][j][l][k] = compatibleLeft; */
/*			sb_sample[1][j][l][k] = compatibleRight; */
/* #elif	defined(DIFF_2) */				/* =========================== */

			sb_sample[0][j][l][k] = compatibleLeft + sb_sample[2][j][l][k] + sb_sample[5][j][l][k];
			sb_sample[1][j][l][k] = compatibleRight + sb_sample[2][j][l][k] + sb_sample[6][j][l][k];
/* #endif */						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a612 20

		if (fr_ps->phantom_c)            /* 27/07/95 WtK */
                {
                if (info->matrix==3)
		  for(k = 12; k < SBLIMIT; k ++)
		  {
			val = matrPC * sb_sample[2][j][l][k];
			sb_sample[0][j][l][k] += val;
			sb_sample[1][j][l][k] += val;
			sb_sample[2][j][l][k] = 0;
		  }
                else 
		  for(k = 12; k < SBLIMIT; k ++)
		  {
			val = matrPC * sb_sample[2][j][l][k];
			sb_sample[5][j][l][k] += val;
			sb_sample[6][j][l][k] += val;
			sb_sample[2][j][l][k] = 0;
		  }
                }
d688 2
a690 15
 * If LFE is not enabled, "buffer" contains:
 *	buffer[0]	L
 *	buffer[1]	R
 *	buffer[2]	C
 *	buffer[3]	Ls
 *	buffer[4]	Rs
 *
 * If LFE is enabled, "buffer" contains:
 *	buffer[0]	L
 *	buffer[1]	R
 *	buffer[2]	C
 *	buffer[3]	LFE
 *	buffer[4]	Ls
 *	buffer[5]	Rs
 *
a710 1
  int lfe;
a713 2
  lfe = info->lfe;

d739 5
a743 5
     buffer_matr[2][i]	= buffer[2][i];
     buffer_matr[3][i]	= buffer[3+lfe][i];
     buffer_matr[4][i]	= buffer[4+lfe][i];
     buffer_matr[5][i]	= buffer[0][i];
     buffer_matr[6][i]	= buffer[1][i];
d748 2
a749 2
	buffer_matr[0][i] = matrNorm*(buffer[0][i] + matrC*buffer[2][i] + matrLsRs*buffer[3+lfe][i]);
	buffer_matr[1][i] = matrNorm*(buffer[1][i] + matrC*buffer[2][i] + matrLsRs*buffer[4+lfe][i]);
d756 1
a756 2
/* add lfe to calculate "mono_surround"    UF 26/10/95 */
	mono_surround = (buffer[3+lfe][i] + buffer[4+lfe][i]) / 2.0;
d996 1
a996 1
#endif /*VERY_FAST_FILTER*/
d1184 1
a1184 1
/* of the 12 (6 in case of lsf ML) subband samples
d1190 2
a1191 2
/* Layer II has three sets of 12 (6 in case of lsf ML) subband samples 
/* for a given subband.
d1220 5
a1224 3
void II_scale_factor_calc(frame_params *fr_ps, double (*sb_sample)[3][12][32], unsigned int (*scalar)[3][32], int sblimit, int l, int m)
/* sblimit has the value of mlsblimit in case II_scale_factor_calc */
/* is called in a ML channel , 7/8/95 WtK                          */
d1226 1
a1226 1
  int    i,j, k,t;
a1227 1
  int    leng;
a1228 3
  leng = SCALE_BLOCK; /* == 12 */
  if ( (l>=7) && (fr_ps->header->multiling_fs==1) ) leng /= 2;

d1232 1
a1232 1
	for (j=1, s[i] = mod(sb_sample[k][t][0][i]);j<leng;j++)
a1304 1
  int mlsblimit = fr_ps->mlsblimit;
d1318 1
a1318 1
  for (k = l; k < m; k++) {
d1322 2
a1323 2
    for (i=sblimit;i<SBLIMIT;i++) max_sc[k][i] = 1E-20;
  }  
a1330 1

d1332 1
a1332 1
/* JMZ 08/03/1995 Multilingual , WtK 07/08/95 */
d1336 2
a1337 2
  for (k = 7; k < 7+n_ml_ch; k++) {
    for (i=0;i<mlsblimit;max_sc[k][i] = multiple[max], i++)
d1340 10
a1349 1
    for (i=mlsblimit;i<SBLIMIT;i++) max_sc[k][i] = 1E-20;
a1350 1
 }
a1590 1
   int mlsblimit = fr_ps->mlsblimit;
d1648 1
a1648 1
     for (i=0;i<mlsblimit;i++) 
a1722 2
	unsigned int lfe_alloc, 
	unsigned int lfe_scalar, 
a1729 1
   int lfe     = fr_ps->header->lfe;
a1787 4
         if (lfe)
          if(lfe_alloc)
             putbits(bs,lfe_scalar,6);

d1829 1
a1829 1
/*JMZ 24/2/95 Multilingual , WtK 7/8/95*/
d1831 6
d1838 2
a1839 2
   int stereo    = fr_ps->stereo;
   int mlsblimit = fr_ps->mlsblimit;
d1842 3
a1844 2
for (i=0;i<mlsblimit;i++)
  for (m = *l; m < *z; m++)
d1848 1
d1850 2
d1853 3
a1855 2
for (i=0;i<mlsblimit;i++)
  for (m = *l;m < *z; m++)
d1863 1
d1868 1
d1871 1
a1871 1
				break;
a1964 1
   int mlsblimit = fr_ps->mlsblimit;
a1966 1
   al_table *allocml = fr_ps->allocml;
a1974 2
	printf("bits_for_nonoise\n");

a2003 1

d2005 2
a2006 1
	  bbal += (stereo+stereomc) * (*alloc)[sb][0].bits;
d2008 2
a2009 4
	  bbal += (stereo-1+stereomc) * (*alloc)[sb][0].bits;     	 
	for (sb = 0; sb < mlsblimit; ++sb)
	  bbal += (n_ml_ch) * (*allocml)[sb][0].bits;     	 

d2012 1
d2054 1
a2054 1
for(sb = 0; sb < (jsbound<mlsblimit)?jsbound:mlsblimit; ++sb) /* remaining part from jsbound to mlsblimit in II_bits_for_indi() , WtK*/
d2058 1
a2058 1
		maxAlloc = (1<<(*allocml)[sb][0].bits)-1;
d2061 1
a2061 1
			if( (-perm_smr[ch][sb] + snr[(*allocml)[sb][ba].quant+((ba>0)?1:0)])
d2066 1
a2066 4
			if (fr_ps->header->multiling_fs==1)
			     smp_bits =  6 * ((*allocml)[sb][ba].group * (*allocml)[sb][ba].bits);
			else
			     smp_bits = 12 * ((*allocml)[sb][ba].group * (*allocml)[sb][ba].bits);
d2071 7
d2089 4
d2097 6
a2108 1
   int mlsblimit = fr_ps->mlsblimit;
a2110 1
   al_table *allocml = fr_ps->allocml;
d2129 2
a2130 2
             if(ba>0) 
	       {
d2135 4
a2138 4
	         req_bits += smp_bits+sel_bits+sc_bits;
               }
	  }
	}
d2140 1
a2140 21
/* 23/03/1995 JMZ Multilingual , WtK 7/8/95 */
	if (n_ml_ch>0)
	for(sb = jsbound; sb < mlsblimit; ++sb)
	{
		 for(ch = 7; ch < 7+n_ml_ch; ++ch) 
		 {
		 maxAlloc = (1<<(*allocml)[sb][0].bits)-1;
		 sel_bits = sc_bits = smp_bits = 0;
		 for(ba = 0; ba < maxAlloc-1; ++ba)
		 if( (-perm_smr[ch][sb] + snr[(*allocml)[sb][ba].quant+((ba>0)?1:0)])
			  >= fr_ps->mnr_min)
			 break;		/* we found enough bits */
		 if(ba>0) 
			 {
			 if (fr_ps->header->multiling_fs==1)
			       smp_bits =  6 * ((*allocml)[sb][ba].group * (*allocml)[sb][ba].bits);
			 else
			       smp_bits = 12 * ((*allocml)[sb][ba].group * (*allocml)[sb][ba].bits);
			 /* scale factor bits required for subband */
			 sel_bits = 2;
			 sc_bits  = 6 * sfsPerScfsi[scfsi[ch][sb]];
d2142 16
a2157 4
			 req_bits += smp_bits+sel_bits+sc_bits;
			 }
		 }
	}
d2159 4
d2165 3
a2167 1
  return req_bits;
d2527 6
a2532 2
       /*far*/                        /* minimum masking level *//* JMZ 08/03/1995 Multilingual , WtK 7/8/95 */
          	                      /* flag for masking level */
a2544 1
	int mlsblimit = fr_ps->mlsblimit;
a2547 1
	al_table *allocml = fr_ps->allocml;
d2571 12
a2582 8
	         for (i = 0; i < jsbound; ++i)
		   bbal += (stereo+stereomc) * (*alloc)[i][0].bits;
		 for (i = jsbound; i < sblimit; ++i)
		   bbal += (stereo-1+stereomc) * (*alloc)[i][0].bits;
                 for (i = 0; i < mlsblimit; ++i)
		   bbal += (n_ml_ch) * (*allocml)[i][0].bits;

                 if (fr_ps->header->center == 3) bbal -= 41; 
d2586 7
a2592 6
	         for (i = 0; i < sblimit; ++i)
	           bbal += (stereo+stereomc) * (*alloc)[i][0].bits;
		 for (i = 0; i < mlsblimit; ++i)
	           bbal += (n_ml_ch) * (*allocml)[i][0].bits;
		 
		 if (fr_ps->header->center == 3) bbal -= 41; 
d2597 1
a2597 1
	 for (i = 0; i < jsbound; ++i)
d2599 1
a2599 1
         for (i = jsbound; i < sblimit; ++i)
d2656 1
a2656 1
/* JMZ 08/03/1995 Multilingual , 7/8/95 WtK */  
d2658 4
a2661 4
   for (i = 0; i < mlsblimit; i++) 
	for (k = 7; k < 7+n_ml_ch; k++) 
	{
	  mnr[k][i]=snr[0]-perm_smr[k][i];
a2663 4
  
	  bit_alloc[k][i] = 0;
	  used[k][i] = 0;
	}
d2665 4
d2815 1
a2815 1
	for (i = 0; i < mlsblimit; i++)
d2833 1
a2833 3
	 if (min_ch<7) 
	 {
	    increment = 12 * ((*alloc)[min_sb][bit_alloc[min_ch][min_sb]+1].group * 
d2835 1
a2835 15
		        /* how many bits are needed */
            if (used[min_ch][min_sb])
             increment -= 12 * ((*alloc)[min_sb][bit_alloc[min_ch][min_sb]].group * 
                               (*alloc)[min_sb][bit_alloc[min_ch][min_sb]].bits);
	 } 
	 else /* MultiLingual 7/8/95 WtK */ 
	 {
            increment   = ((*allocml)[min_sb][bit_alloc[min_ch][min_sb]+1].group * 
			   (*allocml)[min_sb][bit_alloc[min_ch][min_sb]+1].bits);
	    if (used[min_ch][min_sb])
             increment -= ((*allocml)[min_sb][bit_alloc[min_ch][min_sb]].group * 
                           (*allocml)[min_sb][bit_alloc[min_ch][min_sb]].bits);
            if (fr_ps->header->multiling_fs==1) increment *=  6;
	    else                                increment *= 12;
	 }
d2837 6
d2900 2
d2903 1
a2903 4
          if (min_ch<7) 
	  {
	    mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb] +
		                  snr[(*alloc)[min_sb][ba].quant+1];
d2905 1
a2905 8
            if (ba >= (1<<(*alloc)[min_sb][0].bits)-1) used[min_ch][min_sb] = 2;
          }
	  else /* MultiLingual 7/8/95 WtK */ 
	  {
            mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb] +
			          snr[(*allocml)[min_sb][ba].quant+1];
            if (ba >= (1<<(*allocml)[min_sb][0].bits)-1) used[min_ch][min_sb] = 2;
	  }
d2936 2
a2937 2
   for (i=  sblimit;i<SBLIMIT;i++) for (k = 0; k <  7; k++) bit_alloc[k][i]=0;
   for (i=mlsblimit;i<SBLIMIT;i++) for (k = 7; k < 14; k++) bit_alloc[k][i]=0;
d2939 1
d2948 1
d2952 1
a2952 1
/* JMZ 08/03/1995 Multilingual , 7/8/95 WtK */
d2957 1
a2957 1
        for (i=0;i<mlsblimit;i++) 
d2961 1
d3001 1
a3001 1
/* 08/03/1995 JMZ Multilingual , 7/8/95 WtK */
d3004 7
d3013 3
a3015 3
   int n_ml_ch   = fr_ps->header->multiling_ch;
   int mlsblimit = fr_ps->mlsblimit;
   int ml_lsf	 = fr_ps->header->multiling_fs;
d3018 3
a3020 2
   al_table *allocml = fr_ps->allocml;
   
d3022 3
a3024 3
  for (j=0;j<((ml_lsf)?6:12);j++)    /* WtK half sample frequency 7/8/95 */
    for (i=0;i<mlsblimit;i++)
    {
d3034 1
a3034 1
			qnt = (*allocml)[i][bit_alloc[k][i]].quant;
d3040 1
a3040 1
			stps = (*allocml)[i][bit_alloc[k][i]].steps;
d3055 2
a3056 2
  for (j=mlsblimit;j<SBLIMIT;j++)
    for (i=0;i<((ml_lsf)?6:12);i++) for (k = 7; k < 7+n_ml_ch; k++) sbband[k][s][i][j] = 0;
d3348 1
a3348 1
   int stereomc	   = fr_ps->stereomc;
d3357 3
a3359 1
	  for(m = 2; m < 2+stereomc; ++m)
d3483 5
a3487 1
void II_sample_encodingmc(unsigned int (*sbband)[3][12][32], unsigned int lfe_sbband[12], unsigned int (*bit_alloc)[32], unsigned int lfe_alloc, frame_params *fr_ps, Bit_stream_struc *bs)
a3495 1
   int lfe  =     fr_ps->header->lfe;
a3498 6
     {
       if(lfe)
       {
         putbits(bs, lfe_sbband[s*4+j/3], (*alloc)[0][lfe_alloc].bits);
       }

a3540 1
   }	 
@


1.6.2.0
log
@Branch for Felderhoff
@
text
@d4 1
a4 1
 * $Id: encode.c 1.6 1995/06/16 10:01:27 rowlands Exp $
a10 3
 * Revision 1.6  1995/06/16  10:01:27  rowlands
 * Moved merged IRT/Samsung/TI into main revision control trunk.
 *
@


1.6.2.1
log
@Received from Uwe Felderhoff
@
text
@d212 1
a212 1
short pcm_sample_buffer[6912];        /*for correct reading of pcm-data*/
d235 1
a235 1
            for(i = 0; i < 6912; ++i) sample_buffer[i] = pcm_sample_buffer[i];
d280 2
a281 2
	int k, j, i;
	long insamp[6912];
a283 1
        int lfe;
a286 1
        lfe = info->lfe;
d343 1
a343 5
                if(lfe)
                  k = 6;
                else
                  k = 5;
		if(((stereo + stereomc) == 5) && (aiff_ptr->numChannels == k))
d350 1
a350 1
				(unsigned long) (k*1152), byte_per_sample, aiff);
d353 5
a357 7
				buffer[0][j] = insamp[k*j];
				buffer[1][j] = insamp[k*j+1];
				buffer[2][j] = insamp[k*j+2];
				buffer[3][j] = insamp[k*j+3];
				buffer[4][j] = insamp[k*j+4];
                                if(lfe)
				  buffer[5][j] = insamp[k*j+5];
d362 1
a362 1
		else if(( stereo == 0) && ( aiff_ptr->numChannels == k))
d369 1
a369 1
				(unsigned long) (k*1152),byte_per_sample, aiff);
d374 3
a376 5
				buffer[2][j] = insamp[k*j+2];
				buffer[3][j] = insamp[k*j+3];
				buffer[4][j] = insamp[k*j+4];
                                if(lfe)
                                  buffer[5][j] = insamp[6*j+5];   
d379 1
a379 1
		else if(( stereomc == 0) && ( aiff_ptr->numChannels == k))
d386 1
a386 1
				(unsigned long) (k*1152), byte_per_sample, aiff);
d389 2
a390 2
				buffer[0][j] = insamp[k*j];
				buffer[1][j] = insamp[k*j+1];
a393 2
                                if(lfe)
                                  buffer[5][j] = insamp[6*j+2];
d444 1
a444 1
				(unsigned long) ((k-3)*1152), byte_per_sample, aiff);
d447 2
a448 2
				buffer[0][j] = insamp[(k-3)*j];
				buffer[1][j] = insamp[(k-3)*j+1];
a451 2
                                if(lfe)
                                  buffer[1][j] = insamp[3*j+2];
d610 2
a611 2
			sb_sample[0][j][l][k] = compatibleLeft + sb_sample[2][j][l][k] + sb_sample[5][j][l][k];
			sb_sample[1][j][l][k] = compatibleRight + sb_sample[2][j][l][k] + sb_sample[6][j][l][k];
a710 1
  int lfe;
a713 1
  lfe = info->lfe;
d742 2
a743 2
     buffer_matr[3][i] = buffer[3+lfe][i];
     buffer_matr[4][i] = buffer[4+lfe][i];
d748 2
a749 2
	buffer_matr[0][i] = matrNorm*(buffer[0][i] + matrC*buffer[2][i] + matrLsRs*buffer[3+lfe][i]);
	buffer_matr[1][i] = matrNorm*(buffer[1][i] + matrC*buffer[2][i] + matrLsRs*buffer[4+lfe][i]);
d755 2
a756 2
/* add lfe to calculate "mono_surround"    UF 26/10/95 */
	mono_surround = (buffer[3+lfe][i] + buffer[4+lfe][i]) / 2.0;
d996 1
a996 1
#endif /*VERY_FAST_FILTER*/
a1722 2
	unsigned int lfe_alloc, 
	unsigned int lfe_scalar, 
a1729 1
   int lfe     = fr_ps->header->lfe;
a1787 5
         if (lfe)
          if(lfe_alloc)
             putbits(bs,lfe_scalar,6);


a2559 1

a2935 1

d3483 1
a3483 1
void II_sample_encodingmc(unsigned int (*sbband)[3][12][32], unsigned int lfe_sbband[12], unsigned int (*bit_alloc)[32], unsigned int lfe_alloc, frame_params *fr_ps, Bit_stream_struc *bs)
a3495 1
   int lfe  =     fr_ps->header->lfe;
a3498 5
     {
       if(lfe)
       {
         putbits(bs, lfe_sbband[s*4+j/3], (*alloc)[0][lfe_alloc].bits);
       }
a3540 1
   }	 
@


1.6.1.0
log
@Branch for ten Kate
@
text
@d4 1
a4 1
 * $Id: encode.c 1.6 1995/06/16 10:01:27 rowlands Exp $
a10 3
 * Revision 1.6  1995/06/16  10:01:27  rowlands
 * Moved merged IRT/Samsung/TI into main revision control trunk.
 *
@


1.6.1.1
log
@Received from Warner ten Kate
@
text
@d4 1
a4 1
 * $Id: encode.c,v 1.8 1995/08/14 07:53:28 tenkate Exp $
d10 1
a10 11
 * $Log: encode.c,v $
 * Revision 1.8  1995/08/14  07:53:28  tenkate
 * ML-LSF added WtK 7/8/95
 * variables "alloc" and "sblimit" changed into "allocml" and
 * "mlsblimit" where appropriate.
 * sample loops adapted to 12 or 6 depending on full or half fs.
 * II_a_bit_allocation separate summing for ML.
 *
 * Revision 1.7  1995/07/31  07:48:55  tenkate
 * addition of phantom coding, in void matricing(), 25/07/95 WtK
 *
d346 1
a346 1
			info->center = 1; /* will be set to 3 subsequently if (phantom_c==1) */
a484 4
/*
/* If phantom coding is used the high-frequency part of the
/* center signal is matrixed to left and right.
/* 27/07/95 WtK
d563 1
a563 1
  double matrC,matrPC;	/* weighting factor for C, Phantom C */
a564 1
  register double val;
a577 1
	      matrPC	= 1;
a582 1
	      matrPC	= 1;
a587 1
	      matrPC	= 1 / sqrt(2.0);
a612 19
		if (fr_ps->phantom_c)            /* 27/07/95 WtK */
                {
                if (info->matrix==3)
		  for(k = 12; k < SBLIMIT; k ++)
		  {
			val = matrPC * sb_sample[2][j][l][k];
			sb_sample[0][j][l][k] += val;
			sb_sample[1][j][l][k] += val;
			sb_sample[2][j][l][k] = 0;
		  }
                else 
		  for(k = 12; k < SBLIMIT; k ++)
		  {
			val = matrPC * sb_sample[2][j][l][k];
			sb_sample[5][j][l][k] += val;
			sb_sample[6][j][l][k] += val;
			sb_sample[2][j][l][k] = 0;
		  }
                }
d1184 1
a1184 1
/* of the 12 (6 in case of lsf ML) subband samples
d1190 2
a1191 2
/* Layer II has three sets of 12 (6 in case of lsf ML) subband samples 
/* for a given subband.
d1220 1
a1220 1
void II_scale_factor_calc(frame_params *fr_ps, double (*sb_sample)[3][12][32], unsigned int (*scalar)[3][32], int sblimit, int l, int m)
d1222 3
a1224 2
/* sblimit has the value of mlsblimit in case II_scale_factor_calc */
/* is called in a ML channel , 7/8/95 WtK                          */
d1226 1
a1226 1
  int    i,j, k,t;
a1227 1
  int    leng;
a1228 2
  leng = SCALE_BLOCK; /* == 12 */
  if ( (l>=7) && (fr_ps->header->multiling_fs==1) ) leng /= 2;
d1232 1
a1232 1
	for (j=1, s[i] = mod(sb_sample[k][t][0][i]);j<leng;j++)
a1304 1
  int mlsblimit = fr_ps->mlsblimit;
d1318 1
a1318 1
  for (k = l; k < m; k++) {
d1322 2
a1323 2
    for (i=sblimit;i<SBLIMIT;i++) max_sc[k][i] = 1E-20;
  }  
a1330 1
 
d1332 1
a1332 1
/* JMZ 08/03/1995 Multilingual , WtK 07/08/95 */
d1336 2
a1337 2
  for (k = 7; k < 7+n_ml_ch; k++) {
    for (i=0;i<mlsblimit;max_sc[k][i] = multiple[max], i++)
d1340 10
a1349 1
    for (i=mlsblimit;i<SBLIMIT;i++) max_sc[k][i] = 1E-20;
a1350 1
 }
a1590 1
   int mlsblimit = fr_ps->mlsblimit;
d1648 1
a1648 1
     for (i=0;i<mlsblimit;i++) 
d1829 1
a1829 1
/*JMZ 24/2/95 Multilingual , WtK 7/8/95*/
d1831 6
d1838 2
a1839 2
   int stereo    = fr_ps->stereo;
   int mlsblimit = fr_ps->mlsblimit;
d1843 2
a1844 2
for (i=0;i<mlsblimit;i++)
for (m = *l; m < *z; m++)
d1848 1
d1850 2
d1853 3
a1855 2
for (i=0;i<mlsblimit;i++)
for (m = *l;m < *z; m++)
d1863 1
d1868 1
d1871 1
a1964 1
   int mlsblimit = fr_ps->mlsblimit;
a1966 1
   al_table *allocml = fr_ps->allocml;
a2003 1

d2005 2
a2006 1
	  bbal += (stereo+stereomc) * (*alloc)[sb][0].bits;
d2008 2
a2009 4
	  bbal += (stereo-1+stereomc) * (*alloc)[sb][0].bits;     	 
	for (sb = 0; sb < mlsblimit; ++sb)
	  bbal += (n_ml_ch) * (*allocml)[sb][0].bits;     	 

d2012 1
d2054 1
a2054 1
for(sb = 0; sb < (jsbound<mlsblimit)?jsbound:mlsblimit; ++sb) /* remaining part from jsbound to mlsblimit in II_bits_for_indi() , WtK*/
d2058 1
a2058 1
		maxAlloc = (1<<(*allocml)[sb][0].bits)-1;
d2061 1
a2061 1
			if( (-perm_smr[ch][sb] + snr[(*allocml)[sb][ba].quant+((ba>0)?1:0)])
d2066 1
a2066 4
			if (fr_ps->header->multiling_fs==1)
			     smp_bits =  6 * ((*allocml)[sb][ba].group * (*allocml)[sb][ba].bits);
			else
			     smp_bits = 12 * ((*allocml)[sb][ba].group * (*allocml)[sb][ba].bits);
d2071 7
d2089 1
d2091 2
d2098 5
a2108 1
   int mlsblimit = fr_ps->mlsblimit;
a2110 1
   al_table *allocml = fr_ps->allocml;
d2129 2
a2130 2
             if(ba>0) 
	       {
d2136 3
a2138 4
	         req_bits += smp_bits+sel_bits+sc_bits;
               }
	  }
	}
d2140 1
a2140 21
/* 23/03/1995 JMZ Multilingual , WtK 7/8/95 */
	if (n_ml_ch>0)
	for(sb = jsbound; sb < mlsblimit; ++sb)
	{
		 for(ch = 7; ch < 7+n_ml_ch; ++ch) 
		 {
		 maxAlloc = (1<<(*allocml)[sb][0].bits)-1;
		 sel_bits = sc_bits = smp_bits = 0;
		 for(ba = 0; ba < maxAlloc-1; ++ba)
		 if( (-perm_smr[ch][sb] + snr[(*allocml)[sb][ba].quant+((ba>0)?1:0)])
			  >= fr_ps->mnr_min)
			 break;		/* we found enough bits */
		 if(ba>0) 
			 {
			 if (fr_ps->header->multiling_fs==1)
			       smp_bits =  6 * ((*allocml)[sb][ba].group * (*allocml)[sb][ba].bits);
			 else
			       smp_bits = 12 * ((*allocml)[sb][ba].group * (*allocml)[sb][ba].bits);
			 /* scale factor bits required for subband */
			 sel_bits = 2;
			 sc_bits  = 6 * sfsPerScfsi[scfsi[ch][sb]];
d2142 21
a2162 4
			 req_bits += smp_bits+sel_bits+sc_bits;
			 }
		 }
	}
d2165 3
a2167 1
  return req_bits;
d2527 6
a2532 2
       /*far*/                        /* minimum masking level *//* JMZ 08/03/1995 Multilingual , WtK 7/8/95 */
          	                      /* flag for masking level */
a2544 1
	int mlsblimit = fr_ps->mlsblimit;
a2547 1
	al_table *allocml = fr_ps->allocml;
d2571 12
a2582 8
	         for (i = 0; i < jsbound; ++i)
		   bbal += (stereo+stereomc) * (*alloc)[i][0].bits;
		 for (i = jsbound; i < sblimit; ++i)
		   bbal += (stereo-1+stereomc) * (*alloc)[i][0].bits;
                 for (i = 0; i < mlsblimit; ++i)
		   bbal += (n_ml_ch) * (*allocml)[i][0].bits;

                 if (fr_ps->header->center == 3) bbal -= 41; 
d2586 7
a2592 6
	         for (i = 0; i < sblimit; ++i)
	           bbal += (stereo+stereomc) * (*alloc)[i][0].bits;
		 for (i = 0; i < mlsblimit; ++i)
	           bbal += (n_ml_ch) * (*allocml)[i][0].bits;
		 
		 if (fr_ps->header->center == 3) bbal -= 41; 
d2597 1
a2597 1
	 for (i = 0; i < jsbound; ++i)
d2599 1
a2599 1
         for (i = jsbound; i < sblimit; ++i)
d2656 1
a2656 1
/* JMZ 08/03/1995 Multilingual , 7/8/95 WtK */  
d2658 4
a2661 4
   for (i = 0; i < mlsblimit; i++) 
	for (k = 7; k < 7+n_ml_ch; k++) 
	{
	  mnr[k][i]=snr[0]-perm_smr[k][i];
a2663 4
  
	  bit_alloc[k][i] = 0;
	  used[k][i] = 0;
	}
d2665 4
d2815 1
a2815 1
	for (i = 0; i < mlsblimit; i++)
d2833 1
a2833 3
	 if (min_ch<7) 
	 {
	    increment = 12 * ((*alloc)[min_sb][bit_alloc[min_ch][min_sb]+1].group * 
d2835 1
a2835 15
		        /* how many bits are needed */
            if (used[min_ch][min_sb])
             increment -= 12 * ((*alloc)[min_sb][bit_alloc[min_ch][min_sb]].group * 
                               (*alloc)[min_sb][bit_alloc[min_ch][min_sb]].bits);
	 } 
	 else /* MultiLingual 7/8/95 WtK */ 
	 {
            increment   = ((*allocml)[min_sb][bit_alloc[min_ch][min_sb]+1].group * 
			   (*allocml)[min_sb][bit_alloc[min_ch][min_sb]+1].bits);
	    if (used[min_ch][min_sb])
             increment -= ((*allocml)[min_sb][bit_alloc[min_ch][min_sb]].group * 
                           (*allocml)[min_sb][bit_alloc[min_ch][min_sb]].bits);
            if (fr_ps->header->multiling_fs==1) increment *=  6;
	    else                                increment *= 12;
	 }
d2837 6
d2900 4
a2903 4
          if (min_ch<7) 
	  {
	    mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb] +
		                  snr[(*alloc)[min_sb][ba].quant+1];
d2905 1
a2905 8
            if (ba >= (1<<(*alloc)[min_sb][0].bits)-1) used[min_ch][min_sb] = 2;
          }
	  else /* MultiLingual 7/8/95 WtK */ 
	  {
            mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb] +
			          snr[(*allocml)[min_sb][ba].quant+1];
            if (ba >= (1<<(*allocml)[min_sb][0].bits)-1) used[min_ch][min_sb] = 2;
	  }
d2936 2
a2937 2
   for (i=  sblimit;i<SBLIMIT;i++) for (k = 0; k <  7; k++) bit_alloc[k][i]=0;
   for (i=mlsblimit;i<SBLIMIT;i++) for (k = 7; k < 14; k++) bit_alloc[k][i]=0;
d2948 1
d2952 1
a2952 1
/* JMZ 08/03/1995 Multilingual , 7/8/95 WtK */
d2957 1
a2957 1
        for (i=0;i<mlsblimit;i++) 
d2961 1
d3001 1
a3001 1
/* 08/03/1995 JMZ Multilingual , 7/8/95 WtK */
d3004 7
d3013 3
a3015 3
   int n_ml_ch   = fr_ps->header->multiling_ch;
   int mlsblimit = fr_ps->mlsblimit;
   int ml_lsf	 = fr_ps->header->multiling_fs;
d3018 3
a3020 2
   al_table *allocml = fr_ps->allocml;
   
d3022 2
a3023 2
for (j=0;j<((ml_lsf)?6:12);j++)    /* WtK half sample frequency 7/8/95 */
for (i=0;i<mlsblimit;i++)
d3034 1
a3034 1
			qnt = (*allocml)[i][bit_alloc[k][i]].quant;
d3040 1
a3040 1
			stps = (*allocml)[i][bit_alloc[k][i]].steps;
d3055 2
a3056 2
for (j=mlsblimit;j<SBLIMIT;j++)
for (i=0;i<((ml_lsf)?6:12);i++) for (k = 7; k < 7+n_ml_ch; k++) sbband[k][s][i][j] = 0;
d3348 1
a3348 1
   int stereomc	   = fr_ps->stereomc;
d3357 3
a3359 1
	  for(m = 2; m < 2+stereomc; ++m)
@


1.5
log
@Moved merged IRT/TI into main revision control trunk.
@
text
@d4 1
a4 1
 * $Id: encode.c 1.4.2.3 1995/06/16 06:25:24 rowlands Exp $
d11 9
d160 9
d4333 75
@


1.4
log
@Added header and RCS info to initial revision.
@
text
@d4 1
a4 1
 * $Id$
d10 36
a45 1
 * $Log$
d256 2
a257 1
	double (*buffer_matr)[1152]
d324 1
d339 1
a339 1
			matricing_fft(buffer, buffer_matr, fr_ps);
d343 1
a343 1

d360 1
a360 1

d484 1
d492 1
a492 2
 	      printf("NOT DONE YET!!!\n");
	      exit(0);
d496 1
d536 8
a543 8
void matricing(double (*sb_sample)[3][12][32], frame_params *fr_ps)
                                      /* 24/02/1995 JMZ Multilingual */
                    

{
  double matr1;   /* factor for normalizing JMZ */
  double matr2;   /* factor for center JMZ */
  double matr3;   /* factor for surrounds */
d551 1
a551 2
      /* Changed the factors according to Committee Draft and Telefax */
      /* 10/20/93 by E. Schroeder, DTB Hannover                       */
d553 5
a557 3
	case 0: matr1 = 0.411865234375;	/* normalizing */
	      matr2 = 0.7060546875;	/* matricing   C*/
	      matr3 = matr2;          	/* matricing   Ls, Rs JMZ*/
d559 4
a562 3
	case 1: matr1 = 1/(1.5 + 0.5*sqrt(2)); /* normalizing */
              matr2 = 0.7060546875;          /* matricing C */ 
	      matr3 = 0.5;                   /* matricing Ls, Rs */
d564 4
a567 9
	case 2: matr1 = 0.411865234375;  
		matr2 = 0.7060546875;
		matr3 = matr2;		/* matricing   Ls, Rs JMZ*/
		printf("NOT DONE YET!!!\n");
		exit(0);
		break;
	case 3: matr1 = 1.0;
              matr2 = 1.0;
	      matr3 = matr2;          	/* matricing   Ls, Rs JMZ*/
d578 13
a590 23
			sb_sample[5][j][l][k] =  sb_sample[0][j][l][k] * matr1;
			sb_sample[6][j][l][k] =  sb_sample[1][j][l][k] * matr1;
		
			sb_sample[2][j][l][k] = sb_sample[2][j][l][k] * matr1 * matr2;
			sb_sample[3][j][l][k] = sb_sample[3][j][l][k] * matr1 * matr3; 
			sb_sample[4][j][l][k] = sb_sample[4][j][l][k] * matr1 * matr3; 
		 	if(info->matrix == 0 || info->matrix == 1)
			{
				sb_sample[0][j][l][k] = sb_sample[5][j][l][k] + sb_sample[2][j][l][k] + sb_sample[3][j][l][k];
				sb_sample[1][j][l][k] = sb_sample[6][j][l][k] + sb_sample[2][j][l][k] + sb_sample[4][j][l][k];
			}
			if (n_ml_ch > 0)
			{
			sb_sample[7][j][l][k] =  sb_sample[7][j][l][k] * matr1;
			sb_sample[8][j][l][k] =  sb_sample[8][j][l][k] * matr1;
			sb_sample[9][j][l][k] =  sb_sample[9][j][l][k] * matr1;
			sb_sample[10][j][l][k] =  sb_sample[10][j][l][k] * matr1;
			sb_sample[11][j][l][k] =  sb_sample[11][j][l][k] * matr1;
			sb_sample[12][j][l][k] =  sb_sample[12][j][l][k] * matr1;
			sb_sample[13][j][l][k] =  sb_sample[13][j][l][k] * matr1;
		/* Remplacer et mettre un for (i=0; i<n_ml_ch;...)*/
		/* sb_sample[7+i][j][l][k] =  sb_sample[7+i][j][l][k] * matr1;*/
			}
d599 61
d669 9
a677 2
/*                                                                         */
/***************************************************************************/
d681 4
a684 3
	double (*buffer)[1152],
	double (*buffer_matr)[1152],
	frame_params *fr_ps
d686 3
a688 3
  double matr1;   /* factor for normalizing */
  double matr2;   /* factor for matricing   */
  double matr3;   /* factor for matricing   */
d695 7
a701 3
	/* factors according to Draft International Standard */
      case 0: matr1 = 0.411865234375;     /* normalizing factor */
	      matr2 = 0.7060546875;       /* matricing factor   */
d703 4
a706 3
      case 1: matr1 = 1/(1 + sqrt(2));    /* normalizing factor */
	      matr2 = 0.7060546875;       /* matricing C        */
	      matr3 = 0.5;                /* matricing Ls, Rs   */
d708 4
a711 4
      case 2: matr1 = 0.411865234375;     /* normalizing factor */
	      matr2 = 0.7060546875;       /* matricing factor   */
	      printf(" NOT DONE YET !\n");
              exit(0);
a712 3
      case 3: matr1 = 1.0;
              matr2 = matr1;
	      break;
d723 23
a745 7
     
    if(info->matrix != 3)
    {
     if(info->matrix != 1)
     {
        buffer_matr[0][i] = buffer[0][i] + matr2*buffer[2][i] + matr2*buffer[3][i];
	buffer_matr[1][i] = buffer[1][i] + matr2*buffer[2][i] + matr2*buffer[4][i];
a746 11
     else
     {
	buffer_matr[0][i] = buffer[0][i] + matr2*buffer[2][i] + matr3*buffer[3][i];
	buffer_matr[1][i] = buffer[1][i] + matr2*buffer[2][i] + matr3*buffer[4][i];
     }
    } 
    else
    {
	buffer_matr[0][i] = buffer[0][i];
	buffer_matr[1][i] = buffer[1][i]; 
    }	
d748 1
a748 2
        
 }
a751 2

 
d822 1
a822 1
      for (i = 0; i < 5; i++)
a1055 1
		    fprintf(stderr, "WARNING! Not done yet Dynamic Crosstalk!!!\n");
d1736 1
a1736 4
			{ 
           	putbits(bs,scfsi[k][i],2);

           	}
d2233 4
a2236 1
	unsigned int (*j_scale)[3][32]
d2251 4
a2257 1

d2278 1
a2279 1
 }
d2284 2
a2301 2
                /*if( (-perm_smr[5][sb] + snr[(*alloc)[sb][ba1].quant+((ba1>0)?1:0)])
				 >= fr_ps->mnr_min)*/
a2305 1
         	 /*perm_smr[0][sb] = perm_smr[5][sb];*/		
a2319 2
                /*if( (-perm_smr[6][sb] + snr[(*alloc)[sb][ba1].quant+((ba1>0)?1:0)])
				 >= fr_ps->mnr_min)*/
a2323 1
		/* perm_smr[1][sb] = perm_smr[6][sb];*/		
d2327 26
a2352 1
 
d2531 1
a2531 1
        int ll, pred, pci, adb_mpg1;
d2651 41
d2842 8
d2905 4
d3007 1
a3007 1
		if(bit_alloc[k][i])
d3009 18
a3026 3
		if (mod(d) >= 1.0) /* > changed to >=, 1992-11-06 shn */
		{ printf("Not scaled properly, %d %d %d %d\n",k,s,j,i);
		  printf("Value %1.10f\n",sb_samples[k][s][j][i]);
d3028 3
a3030 15
		qnt = (*alloc)[i][bit_alloc[k][i]].quant;
		d = d * a[qnt] + b[qnt];
		/* extract MSB N-1 bits from the floating point sample */
		if (d >= 0) sig = 1;
		else { sig = 0; d += 1.0; }
		n = 0;
		stps = (*alloc)[i][bit_alloc[k][i]].steps;
		while ((1L<<n) < stps) n++;
		n--;
		sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));
   	          /* tag the inverted sign bit to sbband at position N */
   	          /* The bit inversion is a must for grouping with 3,5,9 steps
   	             so it is done for all subbands */
		if (sig) sbband[k][s][j][i] |= 1<<n;
		if(bit_alloc[k][i] == 0) sbband[k][s][j][i] = 0;
d3225 13
a3237 15
		    if(bit_alloc[k][i])
	               d = sb_samples[k][s][j][i] / multiple[scalar[k][s][i]];
	   
	   
	    if (mod(d) >= 1.0) /* > changed to >=, 1992-11-06 shn */
	    {
		printf("Not scaled properly, %d %d %d %d\n",k,s,j,i);
		printf("Value %1.10f\n",sb_samples[k][s][j][i]);
	    }
	    qnt = (*alloc)[i][bit_alloc[k][i]].quant;
            d = d * a[qnt] + b[qnt];
             /* extract MSB N-1 bits from the floating point sample */
             if (d >= 0) sig = 1;
             else { sig = 0; d += 1.0; }
             n = 0;
d3239 2
a3240 2
             stps = (*alloc)[i][bit_alloc[k][i]].steps;
             while ((1L<<n) < stps) n++;
d3242 6
a3247 6
             while  ( ( (unsigned long)(1L<<(long)n) <
	                 ((unsigned long) ((*alloc)[i][bit_alloc[k][i]].steps)
                          & 0xffff
                         )
                      ) && ( n <16)
                    ) n++;
d3249 10
a3258 6
             n--;
             sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));
             /* tag the inverted sign bit to sbband at position N */
             /* The bit inversion is a must for grouping with 3,5,9 steps
                so it is done for all subbands */
             if (sig) sbband[k][s][j][i] |= 1<<n;
d3378 1
a3378 4
	       {
		putbits(bs, bit_alloc[k][i], (*alloc)[i][0].bits);

			}
@


1.4.3.0
log
@Created branch for Samsung
@
text
@d4 1
a4 1
 * $Id: encode.c 1.4 1995/04/06 04:29:39 rowlands Exp $
d10 1
a10 4
 * $Log: encode.c $
 * Revision 1.4  1995/04/06  04:29:39  rowlands
 * Added header and RCS info to initial revision.
 *
@


1.4.3.1
log
@Input from Samsung AIT.
@
text
@d4 1
a4 1
 * $Id: encode.c,v 1.4 1995/04/06 04:29:39 rowlands Exp $
d10 1
a10 1
 * $Log: encode.c,v $
a118 9
/**********************************************************************
 *                                                                    *
 *  06/06/95       Yeon Bae Thomas Kim, Samsung AIT                   *
 *                 ancillary data is working                          *
 *                                                                    *
 *  06/06/95       Sang Wook Kim, Samsung AIT                         *
 *                 corrected some bugs                                *
 *                                                                    *
 **********************************************************************/
a4141 75


/***************************************************************************
/*
/* ancillary_encode 
/*
/* PURPOSE: The use of ancillary part of the bitstream for information  
/*          storage.
/*         
/*        
/**************************************************************************/

void ancillary_encode(fr_ps,bs,adb)
frame_params *fr_ps;
Bit_stream_struc *bs;
int adb;
{
    int bitsPerSlot; 
    int	samplesPerFrame;
    int	bit_rate;
    int	avg_slots_per_frame;
    int	whole_SpF;
    int	usedAdb;
    int	adbNumberStart;
    int l;
    char *mesg="This bitstream use ancillary part.";
    extern int mesg_index;

    register int i;


    double frac_SpF;
    double slot_lag;
    layer *info = fr_ps->header;


    if (info->lay == 1) { bitsPerSlot = 32; samplesPerFrame = 384;  }
    else               { bitsPerSlot = 8;  samplesPerFrame = 1152; }

    bit_rate = bitrate[info->lay-1][info->bitrate_index];

    avg_slots_per_frame = ((double)samplesPerFrame /
                           s_freq[info->sampling_frequency]) *
                          ((double)bit_rate / (double)bitsPerSlot);
    whole_SpF = (int) avg_slots_per_frame;	 

    adbNumberStart = (whole_SpF+info->padding) * bitsPerSlot;
    usedAdb = adbNumberStart - adb;

    if(usedAdb <= (adbNumberStart-8)) {
	if(usedAdb % 8) {
	   for(i=0;i<(8-(usedAdb%8));i++)
	      put1bit(bs,0);
	   usedAdb += (8 - (usedAdb % 8));
	}
	while(usedAdb < adbNumberStart - 8) {
	   for(i=0;i<8;i++)
	      put1bit(bs,0);
	   usedAdb += 8;
	}
	if(mesg_index >= strlen(mesg)){
	   for(i=0;i<8;i++)
	      put1bit(bs,0);
	} else {
	   putbits(bs,(int)(mesg[mesg_index++]), 8);
	}
   } else {
	for(i=0;i<adb;i++)
	   put1bit(bs,0);
   }

}


   	
@


1.4.3.2
log
@Merged and tested revisions 1.5 and 1.4.3.1
@
text
@d4 1
a4 1
 * $Id: encode.c 1.5 1995/06/16 06:29:49 rowlands Exp $
d10 1
a10 39
 * $Log: encode.c $
 * Revision 1.4.3.1  1995/06/16  08:25:11  rowlands
 * Input from Samsung AIT.
 *
 * Revision 1.5  1995/06/16  06:29:49  rowlands
 * Moved merged IRT/TI into main revision control trunk.
 *
 * Revision 1.4.2.3  1995/06/16  06:25:24  rowlands
 * Merged and tested revisions 1.4.1.6 and 1.4.2.2
 *
 * Revision 1.4.2.2  1995/06/16  04:45:49  rowlands
 * Merged TI and IRT mods using #ifdef _IRT
 *
 * Revision 1.4.2.1  1995/06/16  03:46:42  rowlands
 * Input from IRT
 *
 * Revision 1.4.1.6  1995/06/16  02:41:51  rowlands
 * Added dematrix procedure 2, corrected dematrixing values.
 *
 * Added support for dematrix procedure 2, without predistortion.
 * To implement predistortion will require a delay in the encoder
 * to be able to calculate the predistorted filtered surround signal
 * subband samples.
 *
 * Modified procedure matricing() to reuse the compatible stereo
 * channel signals computed by matricing_fft(). This was needed to
 * avoid calculating the low-pass-filtered surround signal in the
 * subband domain. The main function of procedure matricing() now
 * is to weight the multichannels. These channels are unweighted
 * prior to this for the benefit of the psycho model.
 *
 * Corrected weighting values for dematrixing procedures.
 * Deleted matrixing on multilingual channels.
 * In the quantization procedures, made quantizing to zero bits
 * a special case to skip some operations on undefined values.
 *
 * Revision 1.4.1.0  1995/05/25  03:35:25  rowlands
 * Created branch for TI
 *
d233 1
a233 2
	double		(*buffer_matr)[1152],
	double		dematrix2_filter_state[3]
a299 1
			/* 3/2 configuration */
d314 1
a314 1
			matricing_fft(buffer, buffer_matr, fr_ps, dematrix2_filter_state);
d318 1
a318 1
			/* 3/2 configuration with L,R channels muted */
d335 1
a335 1
			/* 3/2 configuration with C,Ls,Rs channels muted */
a458 1
	      matr3 = matr2;
d466 2
a467 1
	      matr3 = matr2;
a470 1
	      matr3 = matr2;
d510 8
a517 8
void
matricing(
	double		(*sb_sample)[3][12][32],	/* 24/02/1995 JMZ Multilingual */
	frame_params	*fr_ps
) {
  double matrNorm;	/* factor for normalizing JMZ */
  double matrC;		/* weighting factor for C */
  double matrLsRs;	/* weighting factor for Ls, Rs */
d525 2
a526 1
      /* Changed the factors according to International Standard */
d528 3
a530 5
	case 0:
	case 2:
	      matrNorm	= 1 / (1 + sqrt(2.0));
	      matrC	= 1 / sqrt(2.0);
	      matrLsRs	= 1 / sqrt(2.0);
d532 3
a534 4
	case 1:
	      matrNorm	= 1 / (1.5 + 0.5*sqrt(2.0));
	      matrC	= 1 / sqrt(2.0);
	      matrLsRs	= 0.5;
d536 9
a544 4
	case 3:
	      matrNorm	= 1;
	      matrC	= 1;
	      matrLsRs	= 1;
d555 23
a577 13
			double	compatibleLeft;
			double	compatibleRight;

			compatibleLeft	= sb_sample[5][j][l][k];
			compatibleRight	= sb_sample[6][j][l][k];

			sb_sample[5][j][l][k] = sb_sample[0][j][l][k] * matrNorm;
			sb_sample[6][j][l][k] = sb_sample[1][j][l][k] * matrNorm;
			sb_sample[2][j][l][k] = sb_sample[2][j][l][k] * matrNorm * matrC;
			sb_sample[3][j][l][k] = sb_sample[3][j][l][k] * matrNorm * matrLsRs;
			sb_sample[4][j][l][k] = sb_sample[4][j][l][k] * matrNorm * matrLsRs;
			sb_sample[0][j][l][k] = compatibleLeft;
			sb_sample[1][j][l][k] = compatibleRight;
a585 61
/**************************************************************/
/* routines for dematrix2_filter */


static double	dematrix2_filter_coeff[3][4] = {
	/* a0    b0     b1   b2 */
	{ 295, 2048, -1394, 521},	/* 44.1 kHz */
	{ 294, 2048, -1388, 520},	/* 48 kHz */
	{ 486, 2048,  -471, 370}	/* 32 kHz */
};

/*
 * init_dematrix2_filter_state()
 *
 *	This routine initializes the state vector of the dematrix
 *	procedure 2 filter to zero. The state should be initialized:
 *	- at startup
 *	- whenever the previous frame did not use dematrix procedure 2
 *	- whenever the sample rate changes
 */
void
init_dematrix2_filter_state(
	double	state[3]
) {
	state[0] = 0.0;
	state[1] = 0.0;
	state[2] = 0.0;
}

/*
 * dematrix2_filter()
 *	This routine accepts one sample of the mono surround signal,
 *	and produces one sample of the filtered signal for dematrix
 *	procedure 2.
 */
double
dematrix2_filter(
	frame_params *fr_ps,
	double	state[3],
	double	sample
) {
	int	sfreq = fr_ps->header->sampling_frequency;
	double	filteredSample;

	state[2] = state[1];
	state[1] = state[0];

	state[0] = (
		sample -
		dematrix2_filter_coeff[sfreq][2] * state[1] -
		dematrix2_filter_coeff[sfreq][3] * state[2]
	) / dematrix2_filter_coeff[sfreq][1];

	filteredSample = dematrix2_filter_coeff[sfreq][0] * (
		state[0] + 2 * state[1] + state[2]
	);

	return(filteredSample);
}


d595 2
a596 9
 *
 * This function matrixes the original audio samples to pass to the
 * psychoacoustic model. The model considers the matrixed and non-
 * matrixed versions of the signal, so both are retained here.
 * 
 * On exit, buffer_matr[0] to buffer_matr[6] contain the channels
 * Lo, Ro, C, Ls, Rs, L, R, respectively.
 *
 **************************************************************************/
d600 3
a602 4
	double		(*buffer)[1152],
	double		(*buffer_matr)[1152],
	frame_params	*fr_ps,
	double		dematrix2_filter_state[3]
d604 3
a606 3
  double matrNorm;	/* factor for normalizing JMZ */
  double matrC;		/* weighting factor for C */
  double matrLsRs;	/* weighting factor for Ls, Rs */
d613 3
a615 7
      /* Changed the factors according to International Standard */
      
	case 0:
	case 2:
	      matrNorm	= 1 / (1 + sqrt(2.0));
	      matrC	= 1 / sqrt(2.0);
	      matrLsRs	= 1 / sqrt(2.0);
d617 3
a619 4
	case 1:
	      matrNorm	= 1 / (1.5 + 0.5*sqrt(2.0));
	      matrC	= 1 / sqrt(2.0);
	      matrLsRs	= 0.5;
d621 4
a624 4
	case 3:
	      matrNorm	= 1;
	      matrC	= 1;
	      matrLsRs	= 1;
d626 3
d639 16
a654 19

     switch (info->matrix) {
     case 0:
     case 1: {
	buffer_matr[0][i] = matrNorm*(buffer[0][i] + matrC*buffer[2][i] + matrLsRs*buffer[3][i]);
	buffer_matr[1][i] = matrNorm*(buffer[1][i] + matrC*buffer[2][i] + matrLsRs*buffer[4][i]);
	break;
      }
     case 2: {
	double	mono_surround;
	double	filtered_surround;

	mono_surround = (buffer[3][i] + buffer[4][i]) / 2.0;
	filtered_surround = dematrix2_filter(fr_ps, dematrix2_filter_state, mono_surround);
        buffer_matr[0][i] = matrNorm*(buffer[0][i] + matrC*buffer[2][i] - matrLsRs*filtered_surround);
	buffer_matr[1][i] = matrNorm*(buffer[1][i] + matrC*buffer[2][i] + matrLsRs*filtered_surround);
	break;
      }
     case 3: {
d656 2
a657 4
	buffer_matr[1][i] = buffer[1][i];
	break;
      }
     }
d659 2
a660 1
}
d664 2
d736 1
a736 1
      for (i = 0; i < 14; i++)
d970 1
d1651 4
a1654 1
           	    putbits(bs,scfsi[k][i],2);
d2151 1
a2151 4
	unsigned int (*j_scale)[3][32], 
	int dyn_cr, 
	unsigned int (*scfsi_dyn)[SBLIMIT], 
	unsigned int (*scalar_dyn)[3][SBLIMIT]
a2165 4
	double	    sb_sample_sum[4][3][12][32];	    
	int subfr, ch;
	unsigned int scalar_sum[4][3][SBLIMIT];
	unsigned int scfsi_sum[4][SBLIMIT]; 
d2169 1
a2189 1
    }
d2191 1
a2195 2
	 trans_chan(fr_ps); 		    

d2212 2
d2218 1
d2233 2
d2239 1
d2243 1
a2243 26
	    
	    
/************ 05/24/95, SR, dyn_cross talk **********************/	    
     if(dyn_cr != 0)
    {
    
	combine(fr_ps, sb_sample, sb_sample_sum); 	

	    for(ch=0; ch<CHANMAX2; ch++) {
		for(subfr=0; subfr<2; subfr++)
		    for(sb=0; sb<fr_ps->sblimit; sb++)
			scalar_dyn[ch][subfr][sb] = scalar[ch][subfr][sb]; 
			scfsi_calc_dyn(scalar_dyn, ch, fr_ps->sblimit, scfsi_dyn);
			scfsi_calc(scalar, ch, fr_ps->sblimit, scfsi);
		    }
	combine(fr_ps, sb_sample, sb_sample_sum);
	for(ch=0; ch<4; ch++) 
	{
	    scf_calc(sb_sample_sum, fr_ps->sblimit, ch, scalar_sum);
	    scfsi_calc_dyn(scalar_sum, ch, fr_ps->sblimit, scfsi_sum);
	}
	take_dyn_cross(dyn_cr, fr_ps, sb_sample_sum, scalar_sum, scfsi_sum, scfsi_dyn, 
	              sb_sample, scalar, scfsi); 				

    }

d2422 1
a2422 1
        int ll, pred, pci, adb_mpg1, sbgr, sb;
a2541 41
/******* 05/31/1995 SR   dynamic crosstalk! ****************************/
    /* dyamic crosstalk, lock sbgr which are use for dyncr. */
    if(fr_ps->header->dyn_cross_on == 1) {
	for(sbgr = 0; sbgr < SBGRS; sbgr++) {		
	    for(sb = ((sbgr == 0)?0:sb_groups[sbgr-1]+1); sb <= sb_groups[sbgr]; sb++) {
		switch(fr_ps->header->dyn_cross[sbgr]) {
	      case 0: 
		    break;
	      case 1: case 8: case 10: 
		    used[T4[sbgr]][sb] = 2;
		    break;
	      case 2: case 9: 
		    used[T3[sbgr]][sb] = 2;
		    break; 
	      case 3: 
		    used[T2[sbgr]][sb] = 2;
		    break;
	      case 4: case 11: case 12: case 14: 
		    used[T3[sbgr]][sb] = 2; 
		    used[T4[sbgr]][sb] = 2;
		    break;
	      case 5: case 13:
		    used[T2[sbgr]][sb] = 2; 
		    used[T4[sbgr]][sb] = 2;
		    break;
	      case 6: 
		    used[T2[sbgr]][sb] = 2; 
		    used[T3[sbgr]][sb] = 2;
		    break;
	      case 7: 
		    used[T2[sbgr]][sb] = 2; 
		    used[T4[sbgr]][sb] = 2; 	
		    used[T3[sbgr]][sb] = 2;
		    break;
		}
	    }	/* for(sb.. */
	}	/* for(sbgr.. */
    }		/* if(fr_ps.. */ 
       
/**********************************************************************/
 
a2691 8
/** 05/31/1995 SR   dynamic crosstalk! **/
			if(fr_ps->header->dyn_cross_on == 1)
			{
			    dyn_bal(scfsi, ll, fr_ps, min_ch, min_sb, 
				&seli, &scale);
			}
/**/
	
a2746 4
/** 05/31/1995 SR   dyamic crosstalk! */
		 if(fr_ps->header->dyn_cross_on == 1)
			choose_dyn(fr_ps, min_ch, min_sb, ll, bit_alloc); 

d2845 1
a2845 1
		if(bit_alloc[k][i]) {
d2847 3
a2849 18
			if (mod(d) >= 1.0) /* > changed to >=, 1992-11-06 shn */
			{ printf("Not scaled properly, %d %d %d %d\n",k,s,j,i);
			  printf("Value %1.10f\n",sb_samples[k][s][j][i]);
			}
			qnt = (*alloc)[i][bit_alloc[k][i]].quant;
			d = d * a[qnt] + b[qnt];
			/* extract MSB N-1 bits from the floating point sample */
			if (d >= 0) sig = 1;
			else { sig = 0; d += 1.0; }
			n = 0;
			stps = (*alloc)[i][bit_alloc[k][i]].steps;
			while ((1L<<n) < stps) n++;
			n--;
			sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));
			  /* tag the inverted sign bit to sbband at position N */
			  /* The bit inversion is a must for grouping with 3,5,9 steps
			     so it is done for all subbands */
			if (sig) sbband[k][s][j][i] |= 1<<n;
d2851 15
a2865 3
		else {
			sbband[k][s][j][i] = 0;
		}
d3060 15
a3074 13
	    if(bit_alloc[k][i]) {
		d = sb_samples[k][s][j][i] / multiple[scalar[k][s][i]];
		    if (mod(d) >= 1.0) /* > changed to >=, 1992-11-06 shn */
		{
		    printf("Not scaled properly, %d %d %d %d\n",k,s,j,i);
		    printf("Value %1.10f\n",sb_samples[k][s][j][i]);
		}
		qnt = (*alloc)[i][bit_alloc[k][i]].quant;
		d = d * a[qnt] + b[qnt];
		/* extract MSB N-1 bits from the floating point sample */
		if (d >= 0) sig = 1;
		else { sig = 0; d += 1.0; }
		n = 0;
d3076 2
a3077 2
		stps = (*alloc)[i][bit_alloc[k][i]].steps;
		while ((1L<<n) < stps) n++;
d3079 6
a3084 6
		while  ( ( (unsigned long)(1L<<(long)n) <
			     ((unsigned long) ((*alloc)[i][bit_alloc[k][i]].steps)
			      & 0xffff
			     )
			  ) && ( n <16)
			) n++;
d3086 6
a3091 10
		n--;
		sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));
		/* tag the inverted sign bit to sbband at position N */
		/* The bit inversion is a must for grouping with 3,5,9 steps
		   so it is done for all subbands */
		if (sig) sbband[k][s][j][i] |= 1<<n;
	    }
	    else {
		sbband[k][s][j][i] = 0;
	    }
d3211 4
a3214 1
		  putbits(bs, bit_alloc[k][i], (*alloc)[i][0].bits);
@


1.4.2.0
log
@Created branch for IRT
@
text
@d4 1
a4 1
 * $Id: encode.c 1.4 1995/04/06 04:29:39 rowlands Exp $
d10 1
a10 4
 * $Log: encode.c $
 * Revision 1.4  1995/04/06  04:29:39  rowlands
 * Added header and RCS info to initial revision.
 *
@


1.4.2.1
log
@Input from IRT
@
text
@d4 1
a4 1
 * $Id: encode.c,v 1.4 1995/04/06 04:29:39 rowlands Exp $
d10 1
a10 1
 * $Log: encode.c,v $
d961 1
d1642 2
a1643 1
           	    putbits(bs,scfsi[k][i],2);
d1645 1
d2142 1
a2142 4
	unsigned int (*j_scale)[3][32], 
	int dyn_cr, 
	unsigned int (*scfsi_dyn)[SBLIMIT], 
	unsigned int (*scalar_dyn)[3][SBLIMIT]
a2156 4
	double	    sb_sample_sum[4][3][12][32];	    
	int subfr, ch;
	unsigned int scalar_sum[4][3][SBLIMIT];
	unsigned int scfsi_sum[4][SBLIMIT]; 
d2160 1
a2180 1
    }
d2182 1
a2186 2
	 trans_chan(fr_ps); 		    

d2203 2
d2209 1
d2224 2
d2230 1
d2234 1
a2234 27
	    
	    
	    
/************ 05/24/95, SR, dyn_cross talk **********************/	    
     if(dyn_cr != 0)
    {
    
	combine(fr_ps, sb_sample, sb_sample_sum); 	

	    for(ch=0; ch<CHANMAX2; ch++) {
		for(subfr=0; subfr<2; subfr++)
		    for(sb=0; sb<fr_ps->sblimit; sb++)
			scalar_dyn[ch][subfr][sb] = scalar[ch][subfr][sb]; 
			scfsi_calc_dyn(scalar_dyn, ch, fr_ps->sblimit, scfsi_dyn);
			scfsi_calc(scalar, ch, fr_ps->sblimit, scfsi);
		    }
	combine(fr_ps, sb_sample, sb_sample_sum);
	for(ch=0; ch<4; ch++) 
	{
	    scf_calc(sb_sample_sum, fr_ps->sblimit, ch, scalar_sum);
	    scfsi_calc_dyn(scalar_sum, ch, fr_ps->sblimit, scfsi_sum);
	}
	take_dyn_cross(dyn_cr, fr_ps, sb_sample_sum, scalar_sum, scfsi_sum, scfsi_dyn, 
	              sb_sample, scalar, scfsi); 				

    }

d2413 1
a2413 1
        int ll, pred, pci, adb_mpg1, sbgr, sb;
a2532 41
/******* 05/31/1995 SR   dynamic crosstalk! ****************************/
    /* dyamic crosstalk, lock sbgr which are use for dyncr. */
    if(fr_ps->header->dyn_cross_on == 1) {
	for(sbgr = 0; sbgr < SBGRS; sbgr++) {		
	    for(sb = ((sbgr == 0)?0:sb_groups[sbgr-1]+1); sb <= sb_groups[sbgr]; sb++) {
		switch(fr_ps->header->dyn_cross[sbgr]) {
	      case 0: 
		    break;
	      case 1: case 8: case 10: 
		    used[T4[sbgr]][sb] = 2;
		    break;
	      case 2: case 9: 
		    used[T3[sbgr]][sb] = 2;
		    break; 
	      case 3: 
		    used[T2[sbgr]][sb] = 2;
		    break;
	      case 4: case 11: case 12: case 14: 
		    used[T3[sbgr]][sb] = 2; 
		    used[T4[sbgr]][sb] = 2;
		    break;
	      case 5: case 13:
		    used[T2[sbgr]][sb] = 2; 
		    used[T4[sbgr]][sb] = 2;
		    break;
	      case 6: 
		    used[T2[sbgr]][sb] = 2; 
		    used[T3[sbgr]][sb] = 2;
		    break;
	      case 7: 
		    used[T2[sbgr]][sb] = 2; 
		    used[T4[sbgr]][sb] = 2; 	
		    used[T3[sbgr]][sb] = 2;
		    break;
		}
	    }	/* for(sb.. */
	}	/* for(sbgr.. */
    }		/* if(fr_ps.. */ 
       
/**********************************************************************/
 
a2682 8
/** 05/31/1995 SR   dynamic crosstalk! **/
			if(fr_ps->header->dyn_cross_on == 1)
			{
			    dyn_bal(scfsi, ll, fr_ps, min_ch, min_sb, 
				&seli, &scale);
			}
/**/
	
a2737 4
/** 05/31/1995 SR   dyamic crosstalk! */
		 if(fr_ps->header->dyn_cross_on == 1)
			choose_dyn(fr_ps, min_ch, min_sb, ll, bit_alloc); 

d3202 4
a3205 1
		  putbits(bs, bit_alloc[k][i], (*alloc)[i][0].bits);
@


1.4.2.2
log
@Merged TI and IRT mods using #ifdef _IRT
@
text
@d4 1
a4 1
 * $Id: encode.c 1.4.2.1 1995/06/16 03:46:42 rowlands Exp $
d10 1
a10 27
 * $Log: encode.c $
 * Revision 1.4.2.1  1995/06/16  03:46:42  rowlands
 * Input from IRT
 *
 * Revision 1.4.1.6  1995/06/16  02:41:51  rowlands
 * Added dematrix procedure 2, corrected dematrixing values.
 *
 * Added support for dematrix procedure 2, without predistortion.
 * To implement predistortion will require a delay in the encoder
 * to be able to calculate the predistorted filtered surround signal
 * subband samples.
 *
 * Modified procedure matricing() to reuse the compatible stereo
 * channel signals computed by matricing_fft(). This was needed to
 * avoid calculating the low-pass-filtered surround signal in the
 * subband domain. The main function of procedure matricing() now
 * is to weight the multichannels. These channels are unweighted
 * prior to this for the benefit of the psycho model.
 *
 * Corrected weighting values for dematrixing procedures.
 * Deleted matrixing on multilingual channels.
 * In the quantization procedures, made quantizing to zero bits
 * a special case to skip some operations on undefined values.
 *
 * Revision 1.4.1.0  1995/05/25  03:35:25  rowlands
 * Created branch for TI
 *
a223 4
#ifndef _IRT
	double		(*buffer_matr)[1152],
	double		dematrix2_filter_state[3]
#else _IRT
a224 1
#endif _IRT
a290 3
#ifndef _IRT
			/* 3/2 configuration */
#endif _IRT
a304 3
#ifndef _IRT
			matricing_fft(buffer, buffer_matr, fr_ps, dematrix2_filter_state);
#else _IRT
a305 1
#endif _IRT
a308 3
#ifndef _IRT
			/* 3/2 configuration with L,R channels muted */
#else _IRT
a309 1
#endif _IRT
a325 3
#ifndef _IRT
			/* 3/2 configuration with C,Ls,Rs channels muted */
#else _IRT
a326 1
#endif _IRT
a449 3
#ifndef _IRT
	      matr3 = matr2;
#endif _IRT
a456 3
#ifndef _IRT
	      matr3 = matr2;
#else _IRT
a458 1
#endif _IRT
a461 3
#ifndef _IRT
	      matr3 = matr2;
#endif _IRT
a500 10
#ifndef _IRT
void
matricing(
	double		(*sb_sample)[3][12][32],	/* 24/02/1995 JMZ Multilingual */
	frame_params	*fr_ps
) {
  double matrNorm;	/* factor for normalizing JMZ */
  double matrC;		/* weighting factor for C */
  double matrLsRs;	/* weighting factor for Ls, Rs */
#else _IRT
a508 1
#endif _IRT
a515 3
#ifndef _IRT
      /* Changed the factors according to International Standard */
#else _IRT
a517 1
#endif _IRT
a518 7
#ifndef _IRT
	case 0:
	case 2:
	      matrNorm	= 1 / (1 + sqrt(2.0));
	      matrC	= 1 / sqrt(2.0);
	      matrLsRs	= 1 / sqrt(2.0);
#else _IRT
a521 1
#endif _IRT
a522 6
#ifndef _IRT
	case 1:
	      matrNorm	= 1 / (1.5 + 0.5*sqrt(2.0));
	      matrC	= 1 / sqrt(2.0);
	      matrLsRs	= 0.5;
#else _IRT
a525 1
#endif _IRT
a526 6
#ifndef _IRT
	case 3:
	      matrNorm	= 1;
	      matrC	= 1;
	      matrLsRs	= 1;
#else _IRT
a535 1
#endif _IRT
a545 15
#ifndef _IRT
			double	compatibleLeft;
			double	compatibleRight;

			compatibleLeft	= sb_sample[5][j][l][k];
			compatibleRight	= sb_sample[6][j][l][k];

			sb_sample[5][j][l][k] = sb_sample[0][j][l][k] * matrNorm;
			sb_sample[6][j][l][k] = sb_sample[1][j][l][k] * matrNorm;
			sb_sample[2][j][l][k] = sb_sample[2][j][l][k] * matrNorm * matrC;
			sb_sample[3][j][l][k] = sb_sample[3][j][l][k] * matrNorm * matrLsRs;
			sb_sample[4][j][l][k] = sb_sample[4][j][l][k] * matrNorm * matrLsRs;
			sb_sample[0][j][l][k] = compatibleLeft;
			sb_sample[1][j][l][k] = compatibleRight;
#else _IRT
a568 1
#endif _IRT
a576 63
#ifndef _IRT
/**************************************************************/
/* routines for dematrix2_filter */


static double	dematrix2_filter_coeff[3][4] = {
	/* a0    b0     b1   b2 */
	{ 295, 2048, -1394, 521},	/* 44.1 kHz */
	{ 294, 2048, -1388, 520},	/* 48 kHz */
	{ 486, 2048,  -471, 370}	/* 32 kHz */
};

/*
 * init_dematrix2_filter_state()
 *
 *	This routine initializes the state vector of the dematrix
 *	procedure 2 filter to zero. The state should be initialized:
 *	- at startup
 *	- whenever the previous frame did not use dematrix procedure 2
 *	- whenever the sample rate changes
 */
void
init_dematrix2_filter_state(
	double	state[3]
) {
	state[0] = 0.0;
	state[1] = 0.0;
	state[2] = 0.0;
}

/*
 * dematrix2_filter()
 *	This routine accepts one sample of the mono surround signal,
 *	and produces one sample of the filtered signal for dematrix
 *	procedure 2.
 */
double
dematrix2_filter(
	frame_params *fr_ps,
	double	state[3],
	double	sample
) {
	int	sfreq = fr_ps->header->sampling_frequency;
	double	filteredSample;

	state[2] = state[1];
	state[1] = state[0];

	state[0] = (
		sample -
		dematrix2_filter_coeff[sfreq][2] * state[1] -
		dematrix2_filter_coeff[sfreq][3] * state[2]
	) / dematrix2_filter_coeff[sfreq][1];

	filteredSample = dematrix2_filter_coeff[sfreq][0] * (
		state[0] + 2 * state[1] + state[2]
	);

	return(filteredSample);
}


#endif _IRT
a585 11
#ifndef _IRT
 *
 * This function matrixes the original audio samples to pass to the
 * psychoacoustic model. The model considers the matrixed and non-
 * matrixed versions of the signal, so both are retained here.
 * 
 * On exit, buffer_matr[0] to buffer_matr[6] contain the channels
 * Lo, Ro, C, Ls, Rs, L, R, respectively.
 *
 **************************************************************************/
#else _IRT
a587 1
#endif _IRT
a590 6
#ifndef _IRT
	double		(*buffer)[1152],
	double		(*buffer_matr)[1152],
	frame_params	*fr_ps,
	double		dematrix2_filter_state[3]
#else _IRT
a593 1
#endif _IRT
a594 5
#ifndef _IRT
  double matrNorm;	/* factor for normalizing JMZ */
  double matrC;		/* weighting factor for C */
  double matrLsRs;	/* weighting factor for Ls, Rs */
#else _IRT
a597 1
#endif _IRT
a603 9
#ifndef _IRT
      /* Changed the factors according to International Standard */
      
	case 0:
	case 2:
	      matrNorm	= 1 / (1 + sqrt(2.0));
	      matrC	= 1 / sqrt(2.0);
	      matrLsRs	= 1 / sqrt(2.0);
#else _IRT
a606 1
#endif _IRT
a607 6
#ifndef _IRT
	case 1:
	      matrNorm	= 1 / (1.5 + 0.5*sqrt(2.0));
	      matrC	= 1 / sqrt(2.0);
	      matrLsRs	= 0.5;
#else _IRT
a610 1
#endif _IRT
a611 6
#ifndef _IRT
	case 3:
	      matrNorm	= 1;
	      matrC	= 1;
	      matrLsRs	= 1;
#else _IRT
a615 1
#endif _IRT
a616 1
#ifdef _IRT
a619 1
#endif _IRT
a629 25
#ifndef _IRT

     switch (info->matrix) {
     case 0:
     case 1: {
	buffer_matr[0][i] = matrNorm*(buffer[0][i] + matrC*buffer[2][i] + matrLsRs*buffer[3][i]);
	buffer_matr[1][i] = matrNorm*(buffer[1][i] + matrC*buffer[2][i] + matrLsRs*buffer[4][i]);
	break;
      }
     case 2: {
	double	mono_surround;
	double	filtered_surround;

	mono_surround = (buffer[3][i] + buffer[4][i]) / 2.0;
	filtered_surround = dematrix2_filter(fr_ps, dematrix2_filter_state, mono_surround);
        buffer_matr[0][i] = matrNorm*(buffer[0][i] + matrC*buffer[2][i] - matrLsRs*filtered_surround);
	buffer_matr[1][i] = matrNorm*(buffer[1][i] + matrC*buffer[2][i] + matrLsRs*filtered_surround);
	break;
      }
     case 3: {
	buffer_matr[0][i] = buffer[0][i];
	buffer_matr[1][i] = buffer[1][i];
	break;
      }
#else _IRT
a636 1
#endif _IRT
a637 1
#ifdef _IRT
a648 1
#endif _IRT
a649 3
#ifndef _IRT
}
#else _IRT
a651 1
#endif _IRT
a655 3
#ifndef _IRT

#endif _IRT
a726 3
#ifndef _IRT
      for (i = 0; i < 14; i++)
#else _IRT
a727 1
#endif _IRT
a960 3
#ifndef _IRT
		    fprintf(stderr, "WARNING! Not done yet Dynamic Crosstalk!!!\n");
#endif _IRT
a1640 4
#ifndef _IRT
			{ 
           	putbits(bs,scfsi[k][i],2);
#else _IRT
a1641 1
#endif _IRT
a1642 3
#ifndef _IRT
           	}
#endif _IRT
a2138 3
#ifndef _IRT
	unsigned int (*j_scale)[3][32]
#else _IRT
a2142 1
#endif _IRT
a2156 1
#ifdef _IRT
a2160 1
#endif _IRT
a2163 3
#ifndef _IRT

#endif _IRT
a2183 1
#ifdef _IRT
a2184 1
#endif _IRT
a2185 3
#ifndef _IRT
 }
#endif _IRT
a2189 1
#ifdef _IRT
a2191 1
#endif _IRT
a2207 4
#ifndef _IRT
                /*if( (-perm_smr[5][sb] + snr[(*alloc)[sb][ba1].quant+((ba1>0)?1:0)])
				 >= fr_ps->mnr_min)*/
#endif _IRT
a2211 3
#ifndef _IRT
         	 /*perm_smr[0][sb] = perm_smr[5][sb];*/		
#endif _IRT
a2225 4
#ifndef _IRT
                /*if( (-perm_smr[6][sb] + snr[(*alloc)[sb][ba1].quant+((ba1>0)?1:0)])
				 >= fr_ps->mnr_min)*/
#endif _IRT
a2229 3
#ifndef _IRT
		/* perm_smr[1][sb] = perm_smr[6][sb];*/		
#endif _IRT
a2232 3
#ifndef _IRT
 
#else _IRT
a2259 1
#endif _IRT
a2437 3
#ifndef _IRT
        int ll, pred, pci, adb_mpg1;
#else _IRT
a2438 1
#endif _IRT
a2557 1
#ifdef _IRT
a2598 1
#endif _IRT
a2748 1
#ifdef _IRT
a2756 1
#endif _IRT
a2811 1
#ifdef _IRT
a2815 1
#endif _IRT
a2913 3
#ifndef _IRT
		if(bit_alloc[k][i]) {
#else _IRT
a2914 1
#endif _IRT
a2915 20
#ifndef _IRT
			if (mod(d) >= 1.0) /* > changed to >=, 1992-11-06 shn */
			{ printf("Not scaled properly, %d %d %d %d\n",k,s,j,i);
			  printf("Value %1.10f\n",sb_samples[k][s][j][i]);
			}
			qnt = (*alloc)[i][bit_alloc[k][i]].quant;
			d = d * a[qnt] + b[qnt];
			/* extract MSB N-1 bits from the floating point sample */
			if (d >= 0) sig = 1;
			else { sig = 0; d += 1.0; }
			n = 0;
			stps = (*alloc)[i][bit_alloc[k][i]].steps;
			while ((1L<<n) < stps) n++;
			n--;
			sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));
			  /* tag the inverted sign bit to sbband at position N */
			  /* The bit inversion is a must for grouping with 3,5,9 steps
			     so it is done for all subbands */
			if (sig) sbband[k][s][j][i] |= 1<<n;
#else _IRT
a2918 1
#endif _IRT
a2919 5
#ifndef _IRT
		else {
			sbband[k][s][j][i] = 0;
		}
#else _IRT
a2934 1
#endif _IRT
a3128 15
#ifndef _IRT
	    if(bit_alloc[k][i]) {
		d = sb_samples[k][s][j][i] / multiple[scalar[k][s][i]];
		    if (mod(d) >= 1.0) /* > changed to >=, 1992-11-06 shn */
		{
		    printf("Not scaled properly, %d %d %d %d\n",k,s,j,i);
		    printf("Value %1.10f\n",sb_samples[k][s][j][i]);
		}
		qnt = (*alloc)[i][bit_alloc[k][i]].quant;
		d = d * a[qnt] + b[qnt];
		/* extract MSB N-1 bits from the floating point sample */
		if (d >= 0) sig = 1;
		else { sig = 0; d += 1.0; }
		n = 0;
#else _IRT
a3143 1
#endif _IRT
a3144 4
#ifndef _IRT
		stps = (*alloc)[i][bit_alloc[k][i]].steps;
		while ((1L<<n) < stps) n++;
#else _IRT
a3146 1
#endif _IRT
a3147 8
#ifndef _IRT
		while  ( ( (unsigned long)(1L<<(long)n) <
			     ((unsigned long) ((*alloc)[i][bit_alloc[k][i]].steps)
			      & 0xffff
			     )
			  ) && ( n <16)
			) n++;
#else _IRT
a3153 1
#endif _IRT
a3154 12
#ifndef _IRT
		n--;
		sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));
		/* tag the inverted sign bit to sbband at position N */
		/* The bit inversion is a must for grouping with 3,5,9 steps
		   so it is done for all subbands */
		if (sig) sbband[k][s][j][i] |= 1<<n;
	    }
	    else {
		sbband[k][s][j][i] = 0;
	    }
#else _IRT
a3160 1
#endif _IRT
a3279 6
#ifndef _IRT
	       {
		putbits(bs, bit_alloc[k][i], (*alloc)[i][0].bits);

			}
#else _IRT
a3280 1
#endif _IRT
@


1.4.2.3
log
@Merged and tested revisions 1.4.1.6 and 1.4.2.2
@
text
@d4 1
a4 1
 * $Id: encode.c 1.4.2.2 1995/06/16 04:45:49 rowlands Exp rowlands $
a10 3
 * Revision 1.4.2.2  1995/06/16  04:45:49  rowlands
 * Merged TI and IRT mods using #ifdef _IRT
 *
d250 1
d253 3
d322 1
d324 1
d339 1
d341 3
d347 1
d349 3
d368 1
d370 3
d496 1
d498 1
d506 1
d508 4
d515 1
d517 1
d557 1
d566 10
d583 1
d585 4
d590 1
d596 5
d602 1
d607 5
d613 1
d618 11
d639 1
d653 25
d686 1
d748 1
d758 1
d768 4
d775 1
d780 5
d786 1
d790 5
d801 1
d809 5
d815 1
d820 5
d826 1
d831 6
d838 5
d853 1
d877 9
d887 13
d901 1
d903 4
d910 5
d985 1
d987 3
d1223 3
d1906 4
d1911 5
d2412 3
d2419 1
d2434 1
d2439 1
d2443 3
d2466 1
d2468 1
d2470 3
d2477 1
d2480 1
d2497 4
d2505 3
d2522 4
d2530 3
d2536 3
d2541 1
d2566 1
d2745 3
d2749 1
d2869 1
d2911 1
d3062 1
d3071 1
d3127 1
d3132 1
d3231 1
d3233 3
d3237 1
d3256 5
d3262 1
d3266 17
d3477 1
d3491 17
d3509 1
d3512 4
d3517 1
d3524 8
d3533 1
d3544 8
d3671 6
d3678 1
@


1.4.1.0
log
@Created branch for TI
@
text
@d4 1
a4 1
 * $Id: encode.c,v 1.4 1995/04/06 04:29:39 rowlands Exp $
d10 1
a10 4
 * $Log: encode.c,v $
 * Revision 1.4  1995/04/06  04:29:39  rowlands
 * Added header and RCS info to initial revision.
 *
@


1.4.1.1
log
@Screwed it up too much to work, and didn't save intermediate versions
@
text
@d4 1
a4 1
 * $Id: encode.c,v 1.4.1.0 1995/05/25 03:35:25 rowlands Exp rowlands $
a10 3
 * Revision 1.4.1.0  1995/05/25  03:35:25  rowlands
 * Created branch for TI
 *
d215 2
a216 2
	FILE		*musicin,
	double		(*buffer)[1152],
d218 7
a224 8
	int		stereo,
	IFF_AIFF	*aiff_ptr,
	int		stereomc,
	frame_params	*fr_ps,
	int		*aiff,
	int		*byte_per_sample,
	double		(*buffer_matr)[1152],
	double		dematrix2_filter_state[3]
a290 1
			/* 3/2 configuration */
d305 1
a305 1
			matricing_fft(buffer, buffer_matr, fr_ps, dematrix2_filter_state);
d309 1
a309 1
			/* 3/2 configuration with L,R channels muted */
d326 1
a326 1
			/* 3/2 configuration with C,Ls,Rs channels muted */
a449 1
	      matr3 = matr2;
d457 2
a458 1
	      matr3 = matr2;
a461 1
	      matr3 = matr2;
d501 5
a505 6
void
matrix_scaling(
	double		(*sb_sample)[3][12][32],
		/* 24/02/1995 JMZ Multilingual */
	frame_params	*fr_ps
) {
d530 2
d546 3
a548 2
			sb_sample[0][j][l][k] = sb_sample[0][j][l][k] * matr1;
			sb_sample[1][j][l][k] = sb_sample[1][j][l][k] * matr1;
d551 6
a556 4
			sb_sample[4][j][l][k] = sb_sample[4][j][l][k] * matr1 * matr3;
			sb_sample[5][j][l][k] = sb_sample[5][j][l][k] * matr1;
			sb_sample[6][j][l][k] = sb_sample[6][j][l][k] * matr1;

a576 58
/**************************************************************/
/* routines for dematrix2_filter */


static double	dematrix2_filter_coeff[3][4] = {
	/* a0    b0     b1   b2 */
	{ 295, 2048, -1394, 521},	/* 44.1 kHz */
	{ 294, 2048, -1388, 520},	/* 48 kHz */
	{ 486, 2048,  -471, 370}	/* 32 kHz */
};

/*
 * init_dematrix2_filter_state()
 *
 *	This routine initializes the state vector of the dematrix
 *	procedure 2 filter to zero. The state should be initialized:
 *	- at startup
 *	- whenever the previous frame did not use dematrix procedure 2
 *	- whenever the sample rate changes
 */
void
init_dematrix2_filter_state(
	double	state[3]
) {
	state[0] = 0.0;
	state[1] = 0.0;
	state[2] = 0.0;
}

/*
 * dematrix2_filter()
 *	This routine accepts one sample of the mono surround signal,
 *	and produces one sample of the filtered signal for dematrix
 *	procedure 2.
 */
double
dematrix2_filter(
	frame_params *fr_ps,
	double	state[3],
	double	sample
) {
	int	sfreq = fr_ps->header->sampling_frequency;

	state[2] = state[1];
	state[1] = state[0];

	state[0] = (
		sample -
		dematrix2_filter_coeff[sfreq][2] * state[1] -
		dematrix2_filter_coeff[sfreq][3] * state[2]
	) / dematrix2_filter_coeff[sfreq][1];

	return dematrix2_filter_coeff[sfreq][0] * (
		state[0] + 2 * state[1] + state[2]
	);
}


d586 2
a587 9
 *
 * This function matrixes the original audio samples to pass to the
 * psychoacoustic model. The model considers the matrixed and non-
 * matrixed versions of the signal, so both are retained here.
 * 
 * On exit, buffer_matr[0] to buffer_matr[6] contain the channels
 * Lo, Ro, C, Ls, Rs, L, R, respectively.
 *
 **************************************************************************/
d591 3
a593 4
	double		(*buffer)[1152],
	double		(*buffer_matr)[1152],
	frame_params	*fr_ps,
	double		dematrix2_filter_state[3]
d604 1
a604 1
	/* factors according to International Standard */
a606 1
	      matr3 = matr2;
d608 1
a608 1
      case 1: matr1 = 1/(1.5 + 0.5 * sqrt(2)); /* normalizing factor */
d614 2
a615 1
	      matr3 = matr2;
a618 1
	      matr3 = matr2;
d630 10
a639 4

     switch (info->matrix) {
     case 0:
     case 1: {
a641 1
	break;
d643 3
a645 11
     case 2: {
	double	mono_surround;
	double	filtered_surround;

	mono_surround = (buffer[3][i] + buffer[4][i]) / 2.0;
	filtered_surround = dematrix2_filter(fr_ps, dematrix2_filter_state, mono_surround);
        buffer_matr[0][i] = buffer[0][i] + matr2*buffer[2][i] - matr3*filtered_surround;
	buffer_matr[1][i] = buffer[1][i] + matr2*buffer[2][i] + matr3*filtered_surround;
	break;
     }
     case 3: {
d648 1
a648 3
	break;
     }
    }
d650 1
d727 1
a727 1
      for (i = 0; i < 14; i++)
d2836 1
a2836 1
		if(bit_alloc[k][i]) {
d2838 3
a2840 18
			if (mod(d) >= 1.0) /* > changed to >=, 1992-11-06 shn */
			{ printf("Not scaled properly, %d %d %d %d\n",k,s,j,i);
			  printf("Value %1.10f\n",sb_samples[k][s][j][i]);
			}
			qnt = (*alloc)[i][bit_alloc[k][i]].quant;
			d = d * a[qnt] + b[qnt];
			/* extract MSB N-1 bits from the floating point sample */
			if (d >= 0) sig = 1;
			else { sig = 0; d += 1.0; }
			n = 0;
			stps = (*alloc)[i][bit_alloc[k][i]].steps;
			while ((1L<<n) < stps) n++;
			n--;
			sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));
			/* tag the inverted sign bit to sbband at position N */
			/* The bit inversion is a must for grouping with 3,5,9 steps
			so it is done for all subbands */
			if (sig) sbband[k][s][j][i] |= 1<<n;
d2842 15
a2856 3
		else {
			sbband[k][s][j][i] = 0;
		}
d3051 15
a3065 13
	    if(bit_alloc[k][i]) {
               d = sb_samples[k][s][j][i] / multiple[scalar[k][s][i]];
	       if (mod(d) >= 1.0) /* > changed to >=, 1992-11-06 shn */
	       {
		   printf("Not scaled properly, %d %d %d %d\n",k,s,j,i);
		   printf("Value %1.10f\n",sb_samples[k][s][j][i]);
	       }
	       qnt = (*alloc)[i][bit_alloc[k][i]].quant;
               d = d * a[qnt] + b[qnt];
               /* extract MSB N-1 bits from the floating point sample */
               if (d >= 0) sig = 1;
               else { sig = 0; d += 1.0; }
               n = 0;
d3067 2
a3068 2
               stps = (*alloc)[i][bit_alloc[k][i]].steps;
               while ((1L<<n) < stps) n++;
d3070 1
a3070 1
               while  ( ( (unsigned long)(1L<<(long)n) <
d3077 6
a3082 7
               n--;
               sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));
               /* tag the inverted sign bit to sbband at position N */
               /* The bit inversion is a must for grouping with 3,5,9 steps
                  so it is done for all subbands */
               if (sig) sbband[k][s][j][i] |= 1<<n;
	    }
@


1.4.1.2
log
@Backed off on some changes - working again when -UBROKEN flag
is used to disable remaining changes.
@
text
@d4 1
a4 1
 * $Id: encode.c 1.4.1.1 1995/06/11 23:26:23 rowlands Exp $
d10 1
a10 4
 * $Log: encode.c $
 * Revision 1.4.1.1  1995/06/11  23:26:23  rowlands
 * Screwed it up too much to work, and didn't save intermediate versions
 *
d218 2
a219 2
	FILE *musicin,
	double (*buffer)[1152],
d221 6
a226 6
	int stereo,
	IFF_AIFF *aiff_ptr,
	int stereomc,
	frame_params *fr_ps,
	int *aiff,
	int *byte_per_sample,
d508 3
a510 2
matricing(
	double		(*sb_sample)[3][12][32],	/* 24/02/1995 JMZ Multilingual */
a550 5
#ifndef BROKEN
			sb_sample[5][j][l][k] =  sb_sample[0][j][l][k] * matr1;
			sb_sample[6][j][l][k] =  sb_sample[1][j][l][k] * matr1;
		
#else BROKEN
a552 1
#endif BROKEN
d555 1
a555 8
			sb_sample[4][j][l][k] = sb_sample[4][j][l][k] * matr1 * matr3; 
#ifndef BROKEN
		 	if(info->matrix == 0 || info->matrix == 1)
			{
				sb_sample[0][j][l][k] = sb_sample[5][j][l][k] + sb_sample[2][j][l][k] + sb_sample[3][j][l][k];
				sb_sample[1][j][l][k] = sb_sample[6][j][l][k] + sb_sample[2][j][l][k] + sb_sample[4][j][l][k];
			}
#else BROKEN
a558 1
#endif BROKEN
d658 2
a659 2
	double (*buffer)[1152],
	double (*buffer_matr)[1152],
d699 1
a699 12
     
#ifndef BROKEN
    if(info->matrix != 3)
    {
     if(info->matrix != 1)
     {
        buffer_matr[0][i] = buffer[0][i] + matr2*buffer[2][i] + matr2*buffer[3][i];
	buffer_matr[1][i] = buffer[1][i] + matr2*buffer[2][i] + matr2*buffer[4][i];
     }
     else
     {
#else BROKEN
a702 1
#endif BROKEN
a704 1
#ifdef BROKEN
a705 1
#endif BROKEN
a706 1
#ifdef BROKEN
d716 1
a716 6
#endif BROKEN
    } 
#ifndef BROKEN
    else
    {
#else BROKEN
a717 1
#endif BROKEN
a719 1
#ifdef BROKEN
d721 2
a722 2
#endif BROKEN
    }	
a723 3
#ifndef BROKEN
        
#endif BROKEN
a724 3
#ifdef BROKEN
 }
#endif BROKEN
d2925 3
a2927 3
			  /* tag the inverted sign bit to sbband at position N */
			  /* The bit inversion is a must for grouping with 3,5,9 steps
			     so it is done for all subbands */
d3128 12
a3139 12
		d = sb_samples[k][s][j][i] / multiple[scalar[k][s][i]];
		    if (mod(d) >= 1.0) /* > changed to >=, 1992-11-06 shn */
		{
		    printf("Not scaled properly, %d %d %d %d\n",k,s,j,i);
		    printf("Value %1.10f\n",sb_samples[k][s][j][i]);
		}
		qnt = (*alloc)[i][bit_alloc[k][i]].quant;
		d = d * a[qnt] + b[qnt];
		/* extract MSB N-1 bits from the floating point sample */
		if (d >= 0) sig = 1;
		else { sig = 0; d += 1.0; }
		n = 0;
d3141 2
a3142 2
		stps = (*alloc)[i][bit_alloc[k][i]].steps;
		while ((1L<<n) < stps) n++;
d3144 6
a3149 6
		while  ( ( (unsigned long)(1L<<(long)n) <
			     ((unsigned long) ((*alloc)[i][bit_alloc[k][i]].steps)
			      & 0xffff
			     )
			  ) && ( n <16)
			) n++;
d3151 6
a3156 9
		n--;
		sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));
		/* tag the inverted sign bit to sbband at position N */
		/* The bit inversion is a must for grouping with 3,5,9 steps
		   so it is done for all subbands */
		if (sig) sbband[k][s][j][i] |= 1<<n;
	    }
	    else {
		sbband[k][s][j][i] = 0;
@


1.4.1.3
log
@Still not working, and getting inconsistent results. Possible
compiler problem??
@
text
@d4 1
a4 1
 * $Id: encode.c 1.4.1.2 1995/06/12 00:54:04 rowlands Exp rowlands $
a10 4
 * Revision 1.4.1.2  1995/06/12  00:54:04  rowlands
 * Backed off on some changes - working again when -UBROKEN flag
 * is used to disable remaining changes.
 *
d553 1
a553 17
#ifdef NEW_MATRIX_SBB
			double	compatibleLeft;
			double	compatibleRight;

			compatibleLeft	= sb_sample[5][j][l][k];
			compatibleRight	= sb_sample[6][j][l][k];

			sb_sample[5][j][l][k] = sb_sample[0][j][l][k] * matr1;
			sb_sample[6][j][l][k] = sb_sample[1][j][l][k] * matr1;
			sb_sample[2][j][l][k] = sb_sample[2][j][l][k] * matr1 * matr2;
			sb_sample[3][j][l][k] = sb_sample[3][j][l][k] * matr1 * matr3;
			sb_sample[4][j][l][k] = sb_sample[4][j][l][k] * matr1 * matr3;
			sb_sample[0][j][l][k] = compatibleLeft * matr1;
			sb_sample[1][j][l][k] = compatibleRight * matr1;

#else /* !NEW_MATRIX_SBB */
#ifndef BROKEN_MATRIX_SBB
d557 1
a557 1
#else BROKEN_MATRIX_SBB
d560 1
a560 1
#endif BROKEN_MATRIX_SBB
d564 1
a564 1
#ifndef BROKEN_MATRIX_SBB
d570 1
a570 1
#else BROKEN_MATRIX_SBB
d574 1
a574 2
#endif BROKEN_MATRIX_SBB
#endif /* !NEW_MATRIX_SBB */
d716 1
a716 1
#ifndef BROKEN_MATRIX_FFT
d726 1
a726 1
#else BROKEN_MATRIX_FFT
d730 1
a730 1
#endif BROKEN_MATRIX_FFT
d733 1
a733 1
#ifdef BROKEN_MATRIX_FFT
d735 1
d737 1
d747 3
a749 5
     }
#endif BROKEN_MATRIX_FFT
#ifndef BROKEN_MATRIX_FFT
      }
    }
d752 1
a752 1
#else BROKEN_MATRIX_FFT
d754 1
a754 1
#endif BROKEN_MATRIX_FFT
d757 1
a757 1
#ifdef BROKEN_MATRIX_FFT
d759 2
a760 2
     }
#endif BROKEN_MATRIX_FFT
d762 3
a764 3
#ifndef BROKEN_MATRIX_FFT

#endif BROKEN_MATRIX_FFT
d766 3
a768 2
}

@


1.4.1.4
log
@Fixed channel weighting for dematrix procedures 0,1,3. Still need to
check dematrix procedure 2.
@
text
@d4 1
a4 1
 * $Id: encode.c 1.4.1.3 1995/06/14 03:03:08 rowlands Exp rowlands $
a10 4
 * Revision 1.4.1.3  1995/06/14  03:03:08  rowlands
 * Still not working, and getting inconsistent results. Possible
 * compiler problem??
 *
d519 3
a521 3
  double matrNorm;	/* factor for normalizing JMZ */
  double matrC;		/* weighting factor for C */
  double matrLsRs;	/* weighting factor for Ls, Rs */
d529 2
a530 1
      /* Changed the factors according to International Standard */
d532 3
a534 5
	case 0:
	case 2:
	      matrNorm	= 1 / (1 + sqrt(2.0));
	      matrC	= 1 / sqrt(2.0);
	      matrLsRs	= 1 / sqrt(2.0);
d536 3
a538 4
	case 1:
	      matrNorm	= 1 / (1.5 + 0.5*sqrt(2.0));
	      matrC	= 1 / sqrt(2.0);
	      matrLsRs	= 0.5;
d540 7
a546 4
	case 3:
	      matrNorm	= 1;
	      matrC	= 1;
	      matrLsRs	= 1;
d564 7
a570 7
			sb_sample[5][j][l][k] = sb_sample[0][j][l][k] * matrNorm;
			sb_sample[6][j][l][k] = sb_sample[1][j][l][k] * matrNorm;
			sb_sample[2][j][l][k] = sb_sample[2][j][l][k] * matrNorm * matrC;
			sb_sample[3][j][l][k] = sb_sample[3][j][l][k] * matrNorm * matrLsRs;
			sb_sample[4][j][l][k] = sb_sample[4][j][l][k] * matrNorm * matrLsRs;
			sb_sample[0][j][l][k] = compatibleLeft;
			sb_sample[1][j][l][k] = compatibleRight;
d574 2
a575 2
			sb_sample[5][j][l][k] =  sb_sample[0][j][l][k] * matrNorm;
			sb_sample[6][j][l][k] =  sb_sample[1][j][l][k] * matrNorm;
d578 2
a579 2
			sb_sample[0][j][l][k] = sb_sample[0][j][l][k] * matrNorm;
			sb_sample[1][j][l][k] = sb_sample[1][j][l][k] * matrNorm;
d581 3
a583 3
			sb_sample[2][j][l][k] = sb_sample[2][j][l][k] * matrNorm * matrC;
			sb_sample[3][j][l][k] = sb_sample[3][j][l][k] * matrNorm * matrLsRs;
			sb_sample[4][j][l][k] = sb_sample[4][j][l][k] * matrNorm * matrLsRs; 
d591 2
a592 2
			sb_sample[5][j][l][k] = sb_sample[5][j][l][k] * matrNorm;
			sb_sample[6][j][l][k] = sb_sample[6][j][l][k] * matrNorm;
a595 2

#ifdef DO_WEIGHT_ML_CHANNELS
d598 7
a604 7
			sb_sample[7][j][l][k] =  sb_sample[7][j][l][k] * matrNorm;
			sb_sample[8][j][l][k] =  sb_sample[8][j][l][k] * matrNorm;
			sb_sample[9][j][l][k] =  sb_sample[9][j][l][k] * matrNorm;
			sb_sample[10][j][l][k] =  sb_sample[10][j][l][k] * matrNorm;
			sb_sample[11][j][l][k] =  sb_sample[11][j][l][k] * matrNorm;
			sb_sample[12][j][l][k] =  sb_sample[12][j][l][k] * matrNorm;
			sb_sample[13][j][l][k] =  sb_sample[13][j][l][k] * matrNorm;
d606 1
a606 1
		/* sb_sample[7+i][j][l][k] =  sb_sample[7+i][j][l][k] * matrNorm;*/
a607 1
#endif /* DO_WEIGHT_ML_CHANNELS */
d695 2
a696 2
	double		(*buffer)[1152],
	double		(*buffer_matr)[1152],
d700 3
a702 3
  double matrNorm;	/* factor for normalizing JMZ */
  double matrC;		/* weighting factor for C */
  double matrLsRs;	/* weighting factor for Ls, Rs */
d709 4
a712 7
      /* Changed the factors according to International Standard */
      
	case 0:
	case 2:
	      matrNorm	= 1 / (1 + sqrt(2.0));
	      matrC	= 1 / sqrt(2.0);
	      matrLsRs	= 1 / sqrt(2.0);
d714 3
a716 4
	case 1:
	      matrNorm	= 1 / (1.5 + 0.5*sqrt(2.0));
	      matrC	= 1 / sqrt(2.0);
	      matrLsRs	= 0.5;
d718 3
a720 4
	case 3:
	      matrNorm	= 1;
	      matrC	= 1;
	      matrLsRs	= 1;
d722 4
d736 1
a736 1

d742 2
a743 2
        buffer_matr[0][i] = matrNorm*(buffer[0][i] + matrC*buffer[2][i] + matrLsRs*buffer[3][i]);
	buffer_matr[1][i] = matrNorm*(buffer[1][i] + matrC*buffer[2][i] + matrLsRs*buffer[4][i]);
d752 2
a753 2
	buffer_matr[0][i] = matrNorm*(buffer[0][i] + matrC*buffer[2][i] + matrLsRs*buffer[3][i]);
	buffer_matr[1][i] = matrNorm*(buffer[1][i] + matrC*buffer[2][i] + matrLsRs*buffer[4][i]);
d763 2
a764 2
        buffer_matr[0][i] = matrNorm*(buffer[0][i] + matrC*buffer[2][i] - matrLsRs*filtered_surround);
	buffer_matr[1][i] = matrNorm*(buffer[1][i] + matrC*buffer[2][i] + matrLsRs*filtered_surround);
d783 3
@


1.4.1.5
log
@Modified dematrix2_filter() procedure to get debug output
@
text
@d4 1
a4 1
 * $Id: encode.c 1.4.1.4 1995/06/15 18:18:49 rowlands Exp rowlands $
a10 4
 * Revision 1.4.1.4  1995/06/15  18:18:49  rowlands
 * Fixed channel weighting for dematrix procedures 0,1,3. Still need to
 * check dematrix procedure 2.
 *
a662 1
#ifndef	DISABLE_DEMATRIX2_FILTER
a663 1
	double	filteredSample;
d674 1
a674 1
	filteredSample = dematrix2_filter_coeff[sfreq][0] * (
a676 5

	return(filteredSample);
#else
	return(sample);
#endif
@


1.4.1.6
log
@Added dematrix procedure 2, corrected dematrixing values.
@
text
@d4 1
a4 1
 * $Id: encode.c 1.4.1.5 1995/06/16 02:04:33 rowlands Exp rowlands $
d11 3
a13 4
 * Added support for dematrix procedure 2, without predistortion.
 * To implement predistortion will require a delay in the encoder
 * to be able to calculate the predistorted filtered surround signal
 * subband samples.
d15 3
a17 6
 * Modified procedure matricing() to reuse the compatible stereo
 * channel signals computed by matricing_fft(). This was needed to
 * avoid calculating the low-pass-filtered surround signal in the
 * subband domain. The main function of procedure matricing() now
 * is to weight the multichannels. These channels are unweighted
 * prior to this for the benefit of the psycho model.
d19 3
a21 4
 * Corrected weighting values for dematrixing procedures.
 * Deleted matrixing on multilingual channels.
 * In the quantization procedures, made quantizing to zero bits
 * a special case to skip some operations on undefined values.
d23 3
d564 1
d578 40
d667 1
d685 3
d755 11
d769 1
d772 1
d774 1
a774 1
      }
d784 3
d788 4
d793 1
d795 2
a796 1
	buffer_matr[1][i] = buffer[1][i];
a797 1
      }
d799 1
d801 1
@


1.3
log
@Hand-fixes after protoize
@
text
@d2 11
a12 3
Copyright (c) 1991 MPEG/audio software simulation group, All Rights Reserved
encode.c
**********************************************************************/
a13 5
 * MPEG/audio coding/decoding software, work in progress              *
 *   NOT for public distribution until verified and approved by the   *
 *   MPEG/audio committee.  For further information, please contact   *
 *   Davis Pan, 508-493-2241, e-mail: pan@@gauss.enet.dec.com          *
 *                                                                    *
@


1.2
log
@Processed with protoize
@
text
@d207 13
a219 2
unsigned long get_audio(FILE *musicin, long int (*buffer)[1152], long unsigned int num_samples, int stereo, IFF_AIFF *aiff_ptr, int stereomc, frame_params *fr_ps, int *aiff, int *byte_per_sample, double (*buffer_matr)[1152])
{
d583 6
a588 2
void matricing_fft(long int (*buffer)[1152], double (*buffer_matr)[1152], frame_params *fr_ps)
{
d704 6
a709 2
void window_subband(long int **buffer, double *z, int k)
{
d935 1
a935 1
void encode_infomc2(frame_params *fr_ps, Bit_stream_struc *bs, int *npredcoef)
d1460 1
a1460 1
void II_transmission_pattern(unsigned int (*scalar)[3][32], unsigned int (*scfsi)[32], frame_params *fr_ps, unsigned int (*scfsi_dyn)[32])
d1596 11
a1606 10
 
void II_encode_scale(unsigned int (*bit_alloc)[32], unsigned int (*scfsi)[32], unsigned int (*scalar)[3][32], frame_params *fr_ps, Bit_stream_struc *bs, int *l, int *z, unsigned int (*scfsi_dyn)[32])
                                                        
                                    	/* JMZ 08/03/1995 Multilingual */
                    
                     
       
       
                                    	/* JMZ 08/03/1995 Multilingual */
{
d2120 18
a2137 19
void II_main_bit_allocation(double (*perm_smr)[32], double (*ltmin)[32], unsigned int (*scfsi)[32], unsigned int (*bit_alloc)[32], int *adb, frame_params *fr_ps, int *aiff, double (*sb_sample)[3][12][32], unsigned int (*scalar)[3][32], double (*max_sc)[32], int cha_sw, double (*buffer)[1152], double (*spiki)[32], double (*joint_sample)[3][12][32], unsigned int (*j_scale)[3][32], unsigned int (*scfsi_dyn)[32], int frameNum)
                             	 /* minimum masking level *//* JMZ 08/03/1995 Multilingual */
                          	 /* minimum masking level *//* JMZ 08/03/1995 Multilingual */
                                		/* JMZ 08/03/1995 Multilingual */
                                    	/* JMZ 08/03/1995 Multilingual */
         
                    
          
                                     	/* JMZ 08/03/1995 Multilingual */
                                    	/* JMZ 08/03/1995 Multilingual */
                           				/* JMZ 08/03/1995 Multilingual */
           
                        				/* JMZ 08/03/1995 Multilingual */
                          				/* JMZ 08/03/1995 Multilingual */
                                       
                                    	
                                    	/* JMZ 08/03/1995 Multilingual */
             
{
d2163 1
a2163 1
	  if(rq_db = II_bits_for_nonoise(perm_smr, scfsi, fr_ps, &a, &b, aiff)
d2171 1
a2171 1
			rq_db = II_bits_for_nonoise(perm_smr, scfsi, fr_ps, &a, &b, aiff);
@


1.1
log
@Initial revision
@
text
@d148 1
a148 7
unsigned long read_samples(musicin, sample_buffer, num_samples, frame_size,
						 byte_per_sample, aiff)
FILE *musicin;
long sample_buffer[5760];
unsigned long num_samples, frame_size;
int *byte_per_sample;
int *aiff;
d207 1
a207 11
unsigned long get_audio(musicin, buffer, num_samples, stereo,
		aiff_ptr, stereomc, fr_ps, aiff, byte_per_sample, buffer_matr)
FILE *musicin;
long buffer[5][1152];
unsigned long num_samples;
IFF_AIFF *aiff_ptr;
int stereo, stereomc;
frame_params *fr_ps;
int *aiff;
int *byte_per_sample;
double buffer_matr[7][1152];
d416 3
a418 3
void matricing_old(sb_sample, fr_ps)
double sb_sample[14][3][12][SBLIMIT];	/* 08/03/1995 JMZ Multilingual */
frame_params *fr_ps;
d484 3
a486 3
void matricing(sb_sample, fr_ps)
double sb_sample[14][3][12][SBLIMIT]; /* 24/02/1995 JMZ Multilingual */
frame_params *fr_ps;
d572 1
a572 5
void matricing_fft(buffer, buffer_matr, fr_ps)
long buffer[5][1152];
double buffer_matr[7][1152];
frame_params *fr_ps;

d644 2
a645 2
void read_ana_window(ana_win)
double /*far*/ ana_win[HAN_SIZE];
d689 1
a689 4
void window_subband(buffer, z, k)
long **buffer;
double z[HAN_SIZE];
int k;
d728 2
a729 2
void create_ana_filter(filter)
double /*far*/ filter[SBLIMIT][64];
d757 2
a758 2
void filter_subband_old(z,s)
double /*far*/ z[HAN_SIZE], s[SBLIMIT];
d808 2
a809 2
void filter_subband(z,s)
double /*far*/ z[HAN_SIZE], s[SBLIMIT];
d872 1
a872 3
void encode_info(fr_ps,bs)
frame_params *fr_ps;
Bit_stream_struc *bs;
d892 1
a892 3
void encode_infomc1(fr_ps,bs)
frame_params *fr_ps;
Bit_stream_struc *bs;
d916 1
a916 4
void encode_infomc2(fr_ps, bs, npredcoef)
frame_params *fr_ps;
Bit_stream_struc *bs;
int npredcoef[8];
d961 1
a961 3
void encode_infomc_ext1(fr_ps,bs_ext)
frame_params *fr_ps;
Bit_stream_struc *bs_ext;
d971 1
a971 4
void encode_infomc_ext2(fr_ps,bs_ext, crc)
frame_params *fr_ps;
Bit_stream_struc *bs_ext;
unsigned int crc;
d992 1
a992 2
double mod(a)
double a;
d1011 3
a1013 3
void I_combine_LR(sb_sample, joint_sample)
double /*far*/ sb_sample[7][3][SCALE_BLOCK][SBLIMIT];
double /*far*/ joint_sample[2][3][SCALE_BLOCK][SBLIMIT];
d1023 4
a1026 4
void II_combine_LR(sb_sample, joint_sample, sblimit)
double /*far*/ sb_sample[7][3][SCALE_BLOCK][SBLIMIT];
double /*far*/ joint_sample[2][3][SCALE_BLOCK][SBLIMIT];
int sblimit;
d1055 4
a1058 4
void I_scale_factor_calc(sb_sample,scalar,stereo)
double /*far*/ sb_sample[7][3][SCALE_BLOCK][SBLIMIT];
unsigned int scalar[7][3][SBLIMIT];
int stereo;
d1080 5
a1084 5
void II_scale_factor_calc(sb_sample,scalar,sblimit, l, m)
double sb_sample[14][3][SCALE_BLOCK][SBLIMIT];/* 08/03/1995 JMZ Multilingual */
unsigned int scalar[14][3][SBLIMIT];		/* 08/03/1995 JMZ Multilingual */
int sblimit;
int l, m;
d1115 5
a1119 5
void II_scale_factor_calc1(sb_sample,scalar, sblimit, dim)
double /*far*/ sb_sample[2][3][SCALE_BLOCK][SBLIMIT];
unsigned int scalar[2][3][SBLIMIT];
int sblimit;
int dim;
d1153 6
a1158 6
void pick_scale(scalar, fr_ps, max_sc, cha_sw, aiff)
unsigned int scalar[14][3][SBLIMIT];	/* 08/03/1995 JMZ Multilingual */
frame_params *fr_ps;
double /*far*/ max_sc[14][SBLIMIT];		/* 08/03/1995 JMZ Multilingual */
int cha_sw;
int aiff;
d1230 1
a1230 3
void tc_alloc_old(fr_ps, max_sc)
frame_params *fr_ps;
double max_sc[7][SBLIMIT];
d1410 4
a1413 4
void put_scale(scalar, fr_ps, max_sc)
unsigned int scalar[7][3][SBLIMIT];
frame_params *fr_ps;
double /*far*/ max_sc[7][SBLIMIT];
d1441 5
a1445 5
void II_transmission_pattern(scalar, scfsi, fr_ps,scfsi_dyn)
unsigned int scalar[14][3][SBLIMIT];	/* JMZ 08/03/1995 Multilingual */
unsigned int scfsi[14][SBLIMIT];		/* JMZ 08/03/1995 Multilingual */
frame_params *fr_ps;
unsigned int scfsi_dyn[14][SBLIMIT];	/* JMZ 08/03/1995 Multilingual */
d1566 1
a1566 5
void I_encode_scale(scalar, bit_alloc, fr_ps, bs)
unsigned int scalar[7][3][SBLIMIT];
unsigned int bit_alloc[7][SBLIMIT];
frame_params *fr_ps;
Bit_stream_struc *bs;
d1578 8
a1585 8
void II_encode_scale(bit_alloc, scfsi, scalar, fr_ps, bs, l, z, scfsi_dyn)
unsigned int bit_alloc[14][SBLIMIT], scfsi[14][SBLIMIT];
unsigned int scalar[14][3][SBLIMIT];	/* JMZ 08/03/1995 Multilingual */
frame_params *fr_ps;
Bit_stream_struc *bs;
int *l;
int *z;
unsigned int scfsi_dyn[14][SBLIMIT];	/* JMZ 08/03/1995 Multilingual */
d1692 7
a1698 7
void II_encode_scale_ml(bit_alloc, scfsi, scalar, fr_ps, bs, l, z)
unsigned int bit_alloc[14][SBLIMIT], scfsi[14][SBLIMIT]; 	/*JMZ 24/2/95 Multilingual */
unsigned int scalar[14][3][SBLIMIT];		/*JMZ 24/2/95 Multilingual */
frame_params *fr_ps;
Bit_stream_struc *bs;
int *l;
int *z;
d1786 3
a1788 3
int I_bits_for_nonoise(perm_smr, fr_ps)
double /*far*/ perm_smr[7][SBLIMIT];
frame_params *fr_ps;
d1814 7
a1820 7
int II_bits_for_nonoise(perm_smr, scfsi, fr_ps, a, b, aiff)
double /*far*/ perm_smr[7][SBLIMIT];
unsigned int scfsi[7][SBLIMIT];
frame_params *fr_ps;
int a;
int b;
int *aiff;
d1958 7
a1964 7
int II_bits_for_indi(perm_smr, scfsi, fr_ps, a, b, aiff)
double /*far*/ perm_smr[7][SBLIMIT];
unsigned int scfsi[7][SBLIMIT];
frame_params *fr_ps;
int *a;
int *b;
int *aiff;
d2059 5
a2063 5
void I_main_bit_allocation(perm_smr, bit_alloc, adb, fr_ps)
double /*far*/ perm_smr[7][SBLIMIT];
unsigned int bit_alloc[7][SBLIMIT];
int *adb;
frame_params *fr_ps;
d2100 18
a2117 21
void II_main_bit_allocation(perm_smr, ltmin, scfsi, bit_alloc, adb,
                  fr_ps, aiff, sb_sample, scalar, max_sc,
                  cha_sw, buffer, spiki,
                  joint_sample, j_scale, scfsi_dyn, frameNum)
double perm_smr[14][SBLIMIT];	 /* minimum masking level *//* JMZ 08/03/1995 Multilingual */
double ltmin[14][SBLIMIT];	 /* minimum masking level *//* JMZ 08/03/1995 Multilingual */
unsigned int scfsi[14][SBLIMIT];		/* JMZ 08/03/1995 Multilingual */
unsigned int bit_alloc[14][SBLIMIT];	/* JMZ 08/03/1995 Multilingual */
int *adb;
frame_params *fr_ps;
int *aiff;
double sb_sample[14][3][12][SBLIMIT];	/* JMZ 08/03/1995 Multilingual */
unsigned int scalar[14][3][SBLIMIT];	/* JMZ 08/03/1995 Multilingual */
double max_sc[14][SBLIMIT];				/* JMZ 08/03/1995 Multilingual */
int cha_sw;
double buffer[14][1152];				/* JMZ 08/03/1995 Multilingual */
double spiki[14][SBLIMIT];				/* JMZ 08/03/1995 Multilingual */
double joint_sample[2][3][12][SBLIMIT];
unsigned int j_scale[2][3][SBLIMIT];	
unsigned int scfsi_dyn[14][SBLIMIT];	/* JMZ 08/03/1995 Multilingual */
int frameNum;
d2271 5
a2275 5
int I_a_bit_allocation(perm_smr, bit_alloc, adb, fr_ps)	/* return noisy sbs */
double /*far*/ perm_smr[7][SBLIMIT];
unsigned int bit_alloc[7][SBLIMIT];
int *adb;
frame_params *fr_ps;
d2362 7
a2368 8
int II_a_bit_allocation(perm_smr, scfsi, bit_alloc, adb, 
			fr_ps, aiff)
double /*far*/ perm_smr[14][SBLIMIT]; /* minimum masking level *//* JMZ 08/03/1995 Multilingual */
unsigned int scfsi[14][SBLIMIT];		/* JMZ 08/03/1995 Multilingual */
unsigned int bit_alloc[14][SBLIMIT];	/* JMZ 08/03/1995 Multilingual */
int *adb;
frame_params *fr_ps;
int *aiff;	 /* flag for masking level */
d2786 8
a2793 9
void II_subband_quantization_ml(scalar, sb_samples, j_scale, j_samps,
				  bit_alloc, sbband, fr_ps)
unsigned int scalar[14][3][SBLIMIT];
double sb_samples[14][3][12][SBLIMIT];
unsigned int j_scale[2][3][SBLIMIT];
double j_samps[2][3][12][SBLIMIT];
unsigned int bit_alloc[14][SBLIMIT];
unsigned int sbband[14][3][12][SBLIMIT]; /*10/03/1995 JMZ Multilingual */
frame_params *fr_ps;
d2841 8
a2848 9
void I_subband_quantization(scalar, sb_samples, j_scale, j_samps,
                            bit_alloc, sbband, fr_ps)
unsigned int scalar[75][3][SBLIMIT];
double /*far*/ sb_samples[7][3][12][SBLIMIT];
unsigned int j_scale[2][3][SBLIMIT];
double /*far*/ j_samps[2][3][12][SBLIMIT]; /* L+R for j-stereo if necess */
unsigned int bit_alloc[7][SBLIMIT];
unsigned int /*far*/ sbband[7][3][12][SBLIMIT];
frame_params *fr_ps;
d2899 8
a2906 9
void II_subband_quantization(scalar, sb_samples, j_scale, j_samps,
			  bit_alloc, sbband, fr_ps)
unsigned int scalar[14][3][SBLIMIT];		/* 08/03/1995 JMZ Multilingual */
double /*far*/ sb_samples[14][3][12][SBLIMIT];/* 08/03/1995 JMZ Multilingual */
unsigned int j_scale[2][3][SBLIMIT];
double /*far*/ j_samps[2][3][12][SBLIMIT];
unsigned int bit_alloc[14][SBLIMIT];		/* 08/03/1995 JMZ Multilingual */
unsigned int /*far*/ sbband[14][3][12][SBLIMIT];/*08/03/1995 JMZ Multilingual*/
frame_params *fr_ps;
d2970 8
a2977 9
void II_subband_quantizationmc(scalar, sb_samples, j_scale, j_samps,
				  bit_alloc, sbband, fr_ps)
unsigned int scalar[14][3][SBLIMIT];	/* 08/03/1995 JMZ Multilingual */
double sb_samples[14][3][12][SBLIMIT];	/* 08/03/1995 JMZ Multilingual */
unsigned int j_scale[2][3][SBLIMIT];
double j_samps[2][3][12][SBLIMIT];
unsigned int bit_alloc[14][SBLIMIT];	/* 08/03/1995 JMZ Multilingual */
unsigned int sbband[14][3][12][SBLIMIT];/* 08/03/1995 JMZ Multilingual */
frame_params *fr_ps;
d3085 1
a3085 4
void I_encode_bit_alloc(bit_alloc, fr_ps, bs)
unsigned int bit_alloc[7][SBLIMIT];
frame_params *fr_ps;
Bit_stream_struc *bs;
d3098 4
a3101 4
void II_encode_bit_alloc(bit_alloc, fr_ps, bs)
unsigned int bit_alloc[14][SBLIMIT];	/* 08/03/1995 JMZ Multilingual */
frame_params *fr_ps;
Bit_stream_struc *bs;
d3120 4
a3123 4
void II_encode_bit_allocmc(bit_alloc, fr_ps, bs)
unsigned int bit_alloc[14][SBLIMIT];	/* 08/03/1995 JMZ Multilingual */
frame_params *fr_ps;
Bit_stream_struc *bs;
d3202 5
a3206 5
void I_sample_encoding(sbband, bit_alloc, fr_ps, bs)
unsigned int /*far*/ sbband[7][3][12][SBLIMIT];
unsigned int bit_alloc[7][SBLIMIT];
frame_params *fr_ps;
Bit_stream_struc *bs;
d3222 5
a3226 5
void II_sample_encoding(sbband, bit_alloc, fr_ps, bs)
unsigned int sbband[14][3][12][SBLIMIT];	/* 08/03/1995 JMZ Multilingual */
unsigned int bit_alloc[14][SBLIMIT];		/* 08/03/1995 JMZ Multilingual */
frame_params *fr_ps;
Bit_stream_struc *bs;
d3264 5
a3268 5
void II_sample_encodingmc(sbband, bit_alloc, fr_ps, bs)
unsigned int sbband[14][3][12][SBLIMIT];	/* 08/03/1995 JMZ Multilingual */
unsigned int bit_alloc[14][SBLIMIT];		/* 08/03/1995 JMZ Multilingual */
frame_params *fr_ps;
Bit_stream_struc *bs;
d3330 1
a3330 3
void encode_CRC(crc, bs)
unsigned int crc;
Bit_stream_struc *bs;
d3352 1
a3352 3
void tc_alloc(fr_ps, max_sc)
frame_params *fr_ps;
double max_sc[7][SBLIMIT];
@
