/* opensf()

	opensf() exists only to provide backwards compatibility
	with some of the CARL software which relies on custom
	routines to read and write soundfiles.

	It takes one argument: the path and name of a soundfile.
	It returns a pointer to a "sndesc" structure, which contains
	an open file pointer to the soundfile.

	If an error occurs, NULL is returned, and the external variable
	"sferror" is set to a value defined in snd.h

	NOTE: use closesf(3CARL) to close the soundfile and free the
	sndesc structure.

	Abe Singer, June 1992
*/

#if defined nextsf
#include <carl/snd.h>


#import <cthreads.h>
#import <sound/sound.h>
#import <sys/file.h>
#import <sys/types.h>
#import <sys/stat.h>

int	sferror;

struct sndesc *opensf(fname)

char	*fname;

{
	SNDSoundStruct	*snd;	/* Temporary pointer to get soundfile info */
	struct sndesc	*sfp;	/* permanent pointer, returned with sf info */
	short		new;		/* Temporary shortsam holder */
	int		snderr;
	FILE		*fp;	/* File pointer to be stored in sfp */

	sferror = 0;
	if (!fname)
		return(NULL);

	if (!(fp = fopen(fname, "r"))) {
		sferror = SF_NOFILE;
		return(NULL);	/* Bail if can't open as standard file */
	}
	if ((snderr = SNDReadHeader(fileno(fp),&snd)) != SND_ERR_NONE) {
		sferror = SF_NOFILE;
		return(NULL);			/* Bail if no file	*/
	}
	if (snd->dataFormat != SND_FORMAT_LINEAR_16) {
		sferror = SF_NOTSHORT;
		SNDFree(snd);
		return(NULL);			/* Bail if not shortsams */
	}
	if (!(sfp = calloc(1, sizeof(struct sndesc)))) {
		sferror = SF_NOMEMORY;
		SNDFree(snd);
		return(NULL);			/* Bail if no memory	*/
	}
	
	sfp->fp =  fp;		/* Store file pointer in sndesc structure */
	sfp->nc =  snd->channelCount;	/* Store snd info in sndesc structure */
	sfp->headsize =  snd->dataLocation;	/* Store header size */	
	sfp->fs =  snd->dataSize / sizeof(short);	/* Soundfile size */
	sfp->nc =  snd->channelCount;		/* # of channels */
	sfp->sr = snd->samplingRate;		/* Sampling Rate */

	SNDFree(snd);		/* All done with soundfile structure */
	
	if (sfp->fs > 0) {			/* if sndfile is not empty... */
		fseek(sfp->fp, sfp->headsize);	/* Try to get first sample */
		if (!(fread(&new, sizeof(short), 1, sfp->fp))) {
			fclose(sfp->fp);
			free(sfp);
			sferror = SF_BADREAD;	/* Bail if can't read first sample */
			return(NULL);	/* Convert to floatsam  (below)*/
		}
		sfp->sample = (float) new / (float) SF_FACTOR;
	} else
		sfp->sample = 0.0;	/* Zero if empty file	*/
	sfp->index = 0.0;		/* index is zero in any case */

	return(sfp);		/* ThatUs all folks! */
}

# endif nextsf
