/* closesf()

	closesf() exists only to provide backwards compatibility
	with some of the CARL software which relies on custom
	routines to read and write soundfiles.

	It takes one argument: a pointer to a special soundfile
	structure.  It has no return value.  If merely closes the
	soundfile stream and frees the pointer associated with it.

	Abe Singer, June 1992
*/

#include <carl/snd.h>

void	closesf(sfp)

struct sndesc	*sfp;			/* Soundfile pointer */

{
	sferror = 0;
	if (!sfp)		/* Bail if NULL pointer */
		return;
	if (sfp->fp)		/* Close file pointer */
		fclose(sfp->fp);
	free(sfp);		/* Free the sndesc structure */
}
	


